/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PAbstractTask;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationPropertiesListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBAnnotationView;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;

class PChangeAnnotationPropertiesTask
extends PAbstractTask
implements CMBAnnotationPropertiesListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBGenericDocViewer viewer = null;
    private CMBAnnotationSet annoModel = null;
    private CMBAnnotationView annView = null;
    private CMBPageAnnotation annotation = null;
    private CMBPageAnnotation oldProps = null;
    private CMBPageAnnotation newProps = null;
    private int index;

    PChangeAnnotationPropertiesTask(PTaskManager taskManager, CMBGenericDocViewer viewer, CMBAnnotationSet annoModel, CMBAnnotationView annView, CMBPageAnnotation annotation, CMBPageAnnotation oldProps, CMBPageAnnotation newProps, boolean doItNow) {
        super(taskManager);
        this.viewer = viewer;
        this.annoModel = annoModel;
        this.annView = annView;
        this.annotation = annotation;
        this.oldProps = oldProps;
        this.newProps = newProps;
        this.index = annotation.getCurrentIndex();
        this.getManager().invokeTask(this, doItNow);
    }

    public boolean doIt() {
        String methodName = "doIt";
        try {
            CMBPageAnnotation props = this.newProps;
            this.newProps = this.oldProps;
            this.oldProps = props;
            this.annotation.updatePropertiesFrom(this.newProps);
            if (!this.oldProps.getRefreshRect().equals(this.annotation.getRefreshRect())) {
                this.annView.refreshSlightlyBiggerRect(this.oldProps.getRefreshRect());
            }
            this.annView.refreshSlightlyBiggerRect(this.annotation.getRefreshRect());
            this.viewer.getSelectedThumbnailView().repaint();
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        return false;
    }

    public boolean undoIt() {
        String methodName = "undoIt";
        try {
            CMBPageAnnotation props = this.oldProps;
            this.oldProps = this.newProps;
            this.newProps = props;
            this.annotation.updatePropertiesFrom(this.newProps);
            if (!this.oldProps.getRefreshRect().equals(this.annotation.getRefreshRect())) {
                this.annView.refreshSlightlyBiggerRect(this.oldProps.getRefreshRect());
            }
            this.annView.refreshSlightlyBiggerRect(this.annotation.getRefreshRect());
            this.viewer.getSelectedThumbnailView().repaint();
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        return true;
    }

    public void handleAnnPropWillChangeEvent(CMBPageAnnotation anno) {
    }

    public void handleAnnPropChangedEvent(CMBPageAnnotation anno) {
    }

    public String getDescription() {
        return PViewerUtilities.getMessage("changeAnnotationPropertiesTask.description");
    }
}

