/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

class PBrightnessContrastFilter
extends RGBImageFilter {
    float brightness = 100.0f;
    float contrast = 100.0f;

    public PBrightnessContrastFilter(float brightness, float contrast) {
        this.canFilterIndexColorModel = true;
        this.brightness = brightness;
        this.contrast = contrast;
    }

    public int filterRGB(int x, int y, int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        float contrastRatio = this.contrast / 100.0f;
        if (contrastRatio != 1.0f) {
            if ((r = (int)(((double)r - 127.0) * (double)contrastRatio) + 127) > 255) {
                r = 255;
            }
            if (r < 0) {
                r = 0;
            }
            if ((g = (int)(((double)g - 127.0) * (double)contrastRatio) + 127) > 255) {
                g = 255;
            }
            if (g < 0) {
                g = 0;
            }
            if ((b = (int)(((double)b - 127.0) * (double)contrastRatio) + 127) > 255) {
                b = 255;
            }
            if (b < 0) {
                b = 0;
            }
        }
        float[] hsb = Color.RGBtoHSB(r, g, b, null);
        float brightnessRatio = (float)((double)this.brightness / 100.0);
        hsb[2] = hsb[2] * brightnessRatio;
        if (hsb[2] > 1.0f) {
            hsb[2] = 1.0f;
        }
        int return_value = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return return_value;
    }
}

