/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.PBalanceTask;
import com.ibm.mm.viewer.PBrightnessContrastFilter;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.FilteredImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

class PBalanceDialog
extends JDialog {
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JPanel mainPanel = null;
    private JLabel brightnessLabel = null;
    private JSlider brightnessSlider = null;
    private JFormattedTextField brightnessField = null;
    private JLabel contrastLabel = null;
    private JSlider contrastSlider = null;
    private JFormattedTextField contrastField = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton applyButton = null;
    private JPanel imageContainer = null;
    private PImagePanel imagePanel;
    private PImagePanel previewPanel;
    private CMBGenericDocViewer viewer = null;
    private boolean balanceChanged = false;
    private ComponentOrientation compOri = null;

    public PBalanceDialog() {
        this.initialize();
    }

    public PBalanceDialog(Frame owner, CMBGenericDocViewer viewer) throws HeadlessException {
        super(owner, PViewerUtilities.getMessage("balanceDialog.title"), true);
        this.viewer = viewer;
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(300, 180));
        this.setContentPane(this.getJContentPane());
        this.applyComponentOrientation(this.getCompOri());
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                PBalanceDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(this.getOkButton());
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent we) {
                PBalanceDialog.this.requestFocus();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout8 = new FlowLayout();
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout8);
            flowLayout8.setAlignment(4);
            this.buttonPanel.add(this.getOkButton());
            this.buttonPanel.add(this.getApplyButton());
            this.buttonPanel.add(this.getCancelButton());
        }
        return this.buttonPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gbcBrightnessLabel = new GridBagConstraints();
            GridBagConstraints gbcBrightnessSlider = new GridBagConstraints();
            GridBagConstraints gbcBrightnessField = new GridBagConstraints();
            GridBagConstraints gbcContrastLabel = new GridBagConstraints();
            GridBagConstraints gbcContrastSlider = new GridBagConstraints();
            GridBagConstraints gbcContrastField = new GridBagConstraints();
            GridBagConstraints gbcImageContainer = new GridBagConstraints();
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.brightnessLabel = new JLabel();
            this.brightnessLabel.setText(PViewerUtilities.getMessage("balanceDialog.brightness"));
            gbcBrightnessLabel.gridx = 0;
            gbcBrightnessLabel.gridy = 1;
            gbcBrightnessLabel.insets = new Insets(7, 10, 4, 2);
            gbcBrightnessSlider.gridx = 1;
            gbcBrightnessSlider.gridy = 1;
            gbcBrightnessSlider.weightx = 1.0;
            gbcBrightnessSlider.fill = 2;
            gbcBrightnessSlider.insets = new Insets(7, 3, 4, 2);
            gbcBrightnessField.gridx = 2;
            gbcBrightnessField.gridy = 1;
            gbcBrightnessField.fill = 2;
            gbcBrightnessField.insets = new Insets(5, 3, 2, 11);
            gbcBrightnessField.weightx = 0.1;
            this.contrastLabel = new JLabel();
            this.contrastLabel.setText(PViewerUtilities.getMessage("balanceDialog.contrast"));
            gbcContrastLabel.gridx = 0;
            gbcContrastLabel.gridy = 2;
            gbcContrastLabel.insets = new Insets(5, 3, 2, 2);
            gbcContrastSlider.gridx = 1;
            gbcContrastSlider.gridy = 2;
            gbcContrastSlider.weightx = 1.0;
            gbcContrastSlider.fill = 2;
            gbcContrastSlider.insets = new Insets(5, 3, 2, 2);
            gbcContrastField.gridx = 2;
            gbcContrastField.gridy = 2;
            gbcContrastField.fill = 2;
            gbcContrastField.insets = new Insets(3, 3, 2, 11);
            gbcContrastField.weightx = 0.1;
            gbcImageContainer.gridx = 0;
            gbcImageContainer.gridy = 0;
            gbcImageContainer.gridwidth = 3;
            gbcImageContainer.fill = 1;
            gbcImageContainer.weighty = 1.0;
            this.mainPanel.add((Component)this.brightnessLabel, gbcBrightnessLabel);
            this.mainPanel.add((Component)this.getBrightnessSlider(), gbcBrightnessSlider);
            this.mainPanel.add((Component)this.getBrightnessField(), gbcBrightnessField);
            this.mainPanel.add((Component)this.contrastLabel, gbcContrastLabel);
            this.mainPanel.add((Component)this.getContrastSlider(), gbcContrastSlider);
            this.mainPanel.add((Component)this.getContrastField(), gbcContrastField);
            this.mainPanel.add((Component)this.getImageContainer(), gbcImageContainer);
            this.brightnessLabel.setLabelFor(this.getBrightnessSlider());
            this.brightnessLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("balanceDialog.brightness.mnemonic").charAt(0));
            this.contrastLabel.setLabelFor(this.getContrastSlider());
            this.contrastLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("balanceDialog.contrast.mnemonic").charAt(0));
            this.getImagePanel().setBrightness(this.viewer.getBrightness());
            this.getImagePanel().setContrast(this.viewer.getContrast());
            this.brightnessSlider.setValue(this.viewer.getBrightness());
            this.contrastSlider.setValue(this.viewer.getContrast());
            this.brightnessField.setText(String.valueOf(this.brightnessSlider.getValue()));
            this.contrastField.setText(String.valueOf(this.contrastSlider.getValue()));
        }
        return this.mainPanel;
    }

    private JSlider getBrightnessSlider() {
        if (this.brightnessSlider == null) {
            this.brightnessSlider = new JSlider();
            this.brightnessSlider.setMajorTickSpacing(100);
            this.brightnessSlider.setMaximum(200);
            this.brightnessSlider.setMinorTickSpacing(10);
            this.brightnessSlider.setPaintLabels(true);
            this.brightnessSlider.setPaintTicks(true);
            this.brightnessSlider.setValue(100);
            this.brightnessSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent arg0) {
                    JSlider sourceSlider = (JSlider)arg0.getSource();
                    int sourceValue = sourceSlider.getValue();
                    if (sourceSlider.getValueIsAdjusting()) {
                        PBalanceDialog.this.getBrightnessField().setText(String.valueOf(sourceValue));
                    } else {
                        PBalanceDialog.this.getBrightnessField().setValue(new Integer(sourceValue));
                    }
                    PBalanceDialog.this.getPreviewPanel().setBrightness(PBalanceDialog.this.brightnessSlider.getValue());
                }
            });
        }
        return this.brightnessSlider;
    }

    private JFormattedTextField getBrightnessField() {
        if (this.brightnessField == null) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            NumberFormatter formatter = new NumberFormatter(numberFormat);
            formatter.setMinimum(new Integer(0));
            formatter.setMaximum(new Integer(200));
            this.brightnessField = new JFormattedTextField(formatter);
            this.brightnessField.setValue(new Integer(100));
            this.brightnessField.setColumns(3);
            this.brightnessField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "validate");
            this.brightnessField.getActionMap().put("validate", new AbstractAction(){

                public void actionPerformed(ActionEvent arg0) {
                    if (PBalanceDialog.this.brightnessField.isEditValid()) {
                        try {
                            PBalanceDialog.this.brightnessField.commitEdit();
                        }
                        catch (ParseException parseException) {}
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                        PBalanceDialog.this.brightnessField.selectAll();
                    }
                }
            });
            this.brightnessField.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if ("value".equals(e.getPropertyName())) {
                        Number value = (Number)e.getNewValue();
                        PBalanceDialog.this.brightnessSlider.setValue(value.intValue());
                    }
                }
            });
            this.brightnessField.getAccessibleContext().setAccessibleName(PViewerUtilities.getMessage("balanceDialog.brightness"));
        }
        return this.brightnessField;
    }

    private JSlider getContrastSlider() {
        if (this.contrastSlider == null) {
            this.contrastSlider = new JSlider();
            this.contrastSlider.setMajorTickSpacing(100);
            this.contrastSlider.setMaximum(200);
            this.contrastSlider.setMinorTickSpacing(10);
            this.contrastSlider.setPaintLabels(true);
            this.contrastSlider.setPaintTicks(true);
            this.contrastSlider.setValue(100);
            this.contrastSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent arg0) {
                    JSlider sourceSlider = (JSlider)arg0.getSource();
                    int sourceValue = sourceSlider.getValue();
                    if (sourceSlider.getValueIsAdjusting()) {
                        PBalanceDialog.this.getContrastField().setText(String.valueOf(sourceValue));
                    } else {
                        PBalanceDialog.this.getContrastField().setValue(new Integer(sourceValue));
                    }
                    PBalanceDialog.this.getPreviewPanel().setContrast(PBalanceDialog.this.contrastSlider.getValue());
                }
            });
        }
        return this.contrastSlider;
    }

    private JFormattedTextField getContrastField() {
        if (this.contrastField == null) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            NumberFormatter formatter = new NumberFormatter(numberFormat);
            formatter.setMinimum(new Integer(0));
            formatter.setMaximum(new Integer(200));
            this.contrastField = new JFormattedTextField(formatter);
            this.contrastField.setValue(new Integer(100));
            this.contrastField.setColumns(3);
            this.contrastField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "validate");
            this.contrastField.getActionMap().put("validate", new AbstractAction(){

                public void actionPerformed(ActionEvent arg0) {
                    if (PBalanceDialog.this.contrastField.isEditValid()) {
                        try {
                            PBalanceDialog.this.contrastField.commitEdit();
                        }
                        catch (ParseException parseException) {}
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                        PBalanceDialog.this.contrastField.selectAll();
                    }
                }
            });
            this.contrastField.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if ("value".equals(e.getPropertyName())) {
                        Number value = (Number)e.getNewValue();
                        PBalanceDialog.this.contrastSlider.setValue(value.intValue());
                    }
                }
            });
            this.contrastField.getAccessibleContext().setAccessibleName(PViewerUtilities.getMessage("balanceDialog.contrast"));
        }
        return this.contrastField;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(PViewerUtilities.getMessage("balanceDialog.button.Ok"));
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (PBalanceDialog.this.balanceChanged) {
                        PBalanceTask balanceTask = new PBalanceTask(PBalanceDialog.this.viewer.getSelectedModel().getTaskManager(), PBalanceDialog.this.viewer, PBalanceDialog.this.brightnessSlider.getValue(), PBalanceDialog.this.contrastSlider.getValue());
                        PBalanceDialog.this.viewer.getSelectedModel().getTaskManager().invokeTask(balanceTask, true);
                        PBalanceDialog.this.balanceChanged = false;
                    }
                    PBalanceDialog.this.hide();
                    PBalanceDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(PViewerUtilities.getMessage("balanceDialog.button.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    PBalanceDialog.this.hide();
                    PBalanceDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private Component getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton(PViewerUtilities.getMessage("balanceDialog.button.Apply"));
            this.applyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (PBalanceDialog.this.balanceChanged) {
                        PBalanceTask balanceTask = new PBalanceTask(PBalanceDialog.this.viewer.getSelectedModel().getTaskManager(), PBalanceDialog.this.viewer, PBalanceDialog.this.brightnessSlider.getValue(), PBalanceDialog.this.contrastSlider.getValue());
                        PBalanceDialog.this.viewer.getSelectedModel().getTaskManager().invokeTask(balanceTask, true);
                        PBalanceDialog.this.getImagePanel().setBrightness(PBalanceDialog.this.brightnessSlider.getValue());
                        PBalanceDialog.this.getImagePanel().setContrast(PBalanceDialog.this.contrastSlider.getValue());
                        PBalanceDialog.this.balanceChanged = false;
                    }
                }
            });
        }
        return this.applyButton;
    }

    private JPanel getImageContainer() {
        if (this.imageContainer == null) {
            this.imageContainer = new JPanel();
            this.imageContainer.setBorder(BorderFactory.createEtchedBorder(1));
            this.imageContainer.setLayout(new GridBagLayout());
            GridBagConstraints gbcCurrentLabel = new GridBagConstraints();
            GridBagConstraints gbcPreviewLabel = new GridBagConstraints();
            GridBagConstraints gbcImagePanel = new GridBagConstraints();
            GridBagConstraints gbcPreviewPanel = new GridBagConstraints();
            gbcCurrentLabel.gridx = 0;
            gbcCurrentLabel.gridy = 0;
            gbcCurrentLabel.anchor = 23;
            gbcCurrentLabel.insets = new Insets(3, 2, 2, 2);
            gbcPreviewLabel.gridx = 1;
            gbcPreviewLabel.gridy = 0;
            gbcPreviewLabel.anchor = 23;
            gbcPreviewLabel.insets = new Insets(3, 2, 2, 2);
            gbcImagePanel.gridx = 0;
            gbcImagePanel.gridy = 1;
            gbcImagePanel.insets = new Insets(2, 2, 2, 2);
            gbcImagePanel.fill = 1;
            gbcImagePanel.weightx = 1.0;
            gbcImagePanel.weighty = 1.0;
            gbcPreviewPanel.gridx = 1;
            gbcPreviewPanel.gridy = 1;
            gbcPreviewPanel.insets = new Insets(2, 2, 2, 2);
            gbcPreviewPanel.fill = 1;
            gbcPreviewPanel.weightx = 1.0;
            gbcPreviewPanel.weighty = 1.0;
            JLabel currentLabel = new JLabel(PViewerUtilities.getMessage("balanceDialog.current"));
            JLabel previewLabel = new JLabel(PViewerUtilities.getMessage("balanceDialog.preview"));
            this.imageContainer.add((Component)currentLabel, gbcCurrentLabel);
            this.imageContainer.add((Component)previewLabel, gbcPreviewLabel);
            JPanel currentPanel = new JPanel();
            currentPanel.setLayout(new BorderLayout());
            currentPanel.add((Component)this.getImagePanel(), "Center");
            currentPanel.setBorder(BorderFactory.createBevelBorder(1));
            this.imageContainer.add((Component)currentPanel, gbcImagePanel);
            JPanel previewPanel = new JPanel();
            previewPanel.setLayout(new BorderLayout());
            previewPanel.add((Component)this.getPreviewPanel(), "Center");
            previewPanel.setBorder(BorderFactory.createBevelBorder(1));
            this.imageContainer.add((Component)previewPanel, gbcPreviewPanel);
        }
        return this.imageContainer;
    }

    private PImagePanel getImagePanel() {
        String methodName = "getImagePanel";
        if (this.imagePanel == null) {
            this.imagePanel = new PImagePanel();
            CMBPage page = null;
            try {
                page = this.viewer.getSelectedDocument().getPage(this.viewer.getCurrentPageNumber());
            }
            catch (IndexOutOfBoundsException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            if (page != null) {
                this.imagePanel = new PImagePanel(page);
            }
        }
        return this.imagePanel;
    }

    private PImagePanel getPreviewPanel() {
        String methodName = "getPreviewPanel";
        if (this.previewPanel == null) {
            this.previewPanel = new PImagePanel();
            CMBPage page = null;
            try {
                page = this.viewer.getSelectedDocument().getPage(this.viewer.getCurrentPageNumber());
            }
            catch (IndexOutOfBoundsException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            if (page != null) {
                this.previewPanel = new PImagePanel(page);
            }
        }
        return this.previewPanel;
    }

    private ComponentOrientation getCompOri() {
        if (this.compOri == null) {
            boolean ltr = PViewerUtilities.isLeftToRight();
            this.compOri = ComponentOrientation.LEFT_TO_RIGHT;
            if (!ltr) {
                this.compOri = ComponentOrientation.RIGHT_TO_LEFT;
            }
        }
        return this.compOri;
    }

    class PImagePanel
    extends JPanel {
        private static final double IMAGESMALLSIDE = 170.0;
        private static final double IMAGELONGSIDE = 220.0;
        private CMBPage _page = null;
        private transient Image _pageImage = null;
        private transient Image _previewImage = null;
        private int _brightness = 100;
        private int _contrast = 100;

        public PImagePanel() {
        }

        public PImagePanel(CMBPage page) {
            this._page = page;
            this.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent event) {
                    this.componentShownOrResized();
                }

                public void componentResized(ComponentEvent event) {
                    this.componentShownOrResized();
                }

                public void componentShownOrResized() {
                    String methodName = "PImagePanel::componentShownOrResized";
                    Dimension size = PImagePanel.this.getSize();
                    double width = PImagePanel.this._page.getWidth() * (double)PImagePanel.this._page.getPageXResolution();
                    double height = PImagePanel.this._page.getHeight() * (double)PImagePanel.this._page.getPageYResolution();
                    double scale = 1.0;
                    try {
                        int newHeight;
                        double heightScale;
                        int newWidth;
                        double widthScale;
                        scale = size.width <= 0 || size.height <= 0 ? (width > height ? 220.0 / width : 220.0 / height) : ((widthScale = (double)(newWidth = size.width) / width) < (heightScale = (double)(newHeight = size.height) / height) ? widthScale : heightScale);
                        PImagePanel.this._pageImage = PImagePanel.this._page.getImage(scale, false);
                        PBrightnessContrastFilter bcFilter = new PBrightnessContrastFilter(PImagePanel.this._brightness, PImagePanel.this._contrast);
                        PImagePanel.this._previewImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(PImagePanel.this._pageImage.getSource(), bcFilter));
                        PImagePanel.this.repaint();
                    }
                    catch (CMBDocumentEngineException e) {
                        ViewerLogger.logError((Object)this, methodName, e);
                    }
                    catch (IOException e) {
                        ViewerLogger.logError((Object)this, methodName, e);
                    }
                }
            });
        }

        int getBrightness() {
            return this._brightness;
        }

        void setBrightness(int brightness) {
            this._brightness = brightness;
            if (this._pageImage != null) {
                PBalanceDialog.this.balanceChanged = true;
                PBrightnessContrastFilter bcFilter = new PBrightnessContrastFilter(this._brightness, this._contrast);
                this._previewImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this._pageImage.getSource(), bcFilter));
                this.repaint();
            }
        }

        int getContrast() {
            return this._contrast;
        }

        void setContrast(int contrast) {
            this._contrast = contrast;
            if (this._pageImage != null) {
                PBalanceDialog.this.balanceChanged = true;
                PBrightnessContrastFilter bcFilter = new PBrightnessContrastFilter(this._brightness, this._contrast);
                this._previewImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this._pageImage.getSource(), bcFilter));
                this.repaint();
            }
        }

        public Dimension getPreferredSize() {
            double height;
            Dimension preferredSize = null;
            double width = this._page.getWidth() * (double)this._page.getPageXResolution();
            preferredSize = width < (height = this._page.getHeight() * (double)this._page.getPageYResolution()) ? new Dimension(170, 220) : new Dimension(220, 170);
            return preferredSize;
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this._previewImage != null) {
                g.drawImage(this._previewImage, 0, 0, this);
            }
        }
    }
}

