/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBBookmark;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

final class PAddBookmarkDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private CMBGenericDocViewer gdv;
    private JLabel documentNameLabel;
    private JLabel documentNameField;
    private JLabel bookmarkNameLabel;
    private JTextField bookmarkNameField;
    private JLabel pageNumberLabel;
    private JLabel pageNumberField;
    private JButton okButton;
    private JButton cancelButton;

    public PAddBookmarkDialog(Frame owner, CMBGenericDocViewer gdv) throws HeadlessException {
        super(owner, PViewerUtilities.getMessage("addBookmarkDialog.title"), true);
        this.gdv = gdv;
        this.initialize();
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(gdv);
    }

    private void initialize() {
        this.documentNameLabel = new JLabel(PViewerUtilities.getMessage("addBookmarkDialog.documentName"));
        this.documentNameField = new JLabel(this.gdv.getDocName(this.gdv.getSelectedDocument()));
        this.documentNameLabel.setLabelFor(this.documentNameField);
        this.bookmarkNameLabel = new JLabel(PViewerUtilities.getMessage("addBookmarkDialog.bookmarkName"));
        this.bookmarkNameField = new JTextField(10);
        this.bookmarkNameLabel.setLabelFor(this.bookmarkNameField);
        this.pageNumberLabel = new JLabel(PViewerUtilities.getMessage("addBookmarkDialog.pageNumber"));
        this.pageNumberField = new JLabel(String.valueOf(this.gdv.getCurrentPageNumber()));
        this.pageNumberLabel.setLabelFor(this.pageNumberField);
        this.okButton = new JButton(PViewerUtilities.getMessage("DocumentViewer.ok"));
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(PViewerUtilities.getMessage("DocumentViewer.cancel"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel fieldsPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        fieldsPanel.add((Component)this.documentNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        fieldsPanel.add((Component)this.documentNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 1, insets, 0, 0));
        fieldsPanel.add((Component)this.bookmarkNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        fieldsPanel.add((Component)this.bookmarkNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 1, insets, 0, 0));
        fieldsPanel.add((Component)this.pageNumberLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        fieldsPanel.add((Component)this.pageNumberField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 1, insets, 0, 0));
        contentPane.add((Component)fieldsPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        this.bookmarkNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                PAddBookmarkDialog.this.updateEnablement();
            }

            public void insertUpdate(DocumentEvent e) {
                PAddBookmarkDialog.this.updateEnablement();
            }

            public void removeUpdate(DocumentEvent e) {
                PAddBookmarkDialog.this.updateEnablement();
            }
        });
        this.bookmarkNameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (PAddBookmarkDialog.this.bookmarkNameField.getText().length() > 0) {
                    PAddBookmarkDialog.this.addBookmark();
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PAddBookmarkDialog.this.addBookmark();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PAddBookmarkDialog.this.dispose();
            }
        });
        AbstractAction EscAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PAddBookmarkDialog.this.dispose();
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        Object o1 = this.getRootPane().getInputMap().get(ks);
        this.getRootPane().getInputMap(2).put(ks, "escape");
        this.getRootPane().getActionMap().put("escape", EscAction);
        this.getRootPane().setDefaultButton(this.okButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent we) {
                PAddBookmarkDialog.this.requestFocus();
            }
        });
    }

    private void updateEnablement() {
        this.okButton.setEnabled(this.bookmarkNameField.getText().length() > 0);
    }

    private void addBookmark() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean eventFailed = this.gdv.fireBookmarksBeginEditingEvent(this.gdv.getSelectedDocument());
        this.setCursor(Cursor.getDefaultCursor());
        if (eventFailed) {
            return;
        }
        CMBBookmark[] oldBookmarks = this.gdv.getBookmarks();
        CMBBookmark[] newBookmarks = new CMBBookmark[oldBookmarks.length + 1];
        CMBBookmark bookmark = new CMBBookmark(this.gdv.getCurrentPageNumber(), this.bookmarkNameField.getText(), System.currentTimeMillis());
        boolean newBookmarkInserted = false;
        for (int i = 0; i < newBookmarks.length; ++i) {
            if (!newBookmarkInserted && i < oldBookmarks.length && oldBookmarks[i].getPageNumber() <= bookmark.getPageNumber()) {
                newBookmarks[i] = oldBookmarks[i];
                continue;
            }
            if (!newBookmarkInserted) {
                newBookmarks[i] = bookmark;
                newBookmarkInserted = true;
                continue;
            }
            newBookmarks[i] = oldBookmarks[i - 1];
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        eventFailed = this.gdv.fireBookmarksEndEditingEvent(this.gdv.getSelectedDocument(), newBookmarks);
        this.setCursor(Cursor.getDefaultCursor());
        if (!eventFailed) {
            this.dispose();
            this.gdv.setBookmarks(newBookmarks);
        }
    }
}

