/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBViewerAction;
import com.ibm.mm.viewer.CMBViewerConstants;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CMBViewerToolbar
extends JToolBar
implements PropertyChangeListener,
CMBViewerConstants {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private Hashtable actionComponents;
    private Hashtable actions;
    protected CMBGenericDocViewer viewer = null;
    private String position = "North";
    private int order;

    public CMBViewerToolbar(CMBGenericDocViewer viewer) {
        this.viewer = viewer;
        this.actionComponents = new Hashtable();
        this.actions = new Hashtable();
        this.setFloatable(true);
        this.setRollover(true);
        this.overrideFocusHandling();
        this.setDoubleBuffered(true);
    }

    void setPosition(String text) {
        this.position = text;
    }

    String getPosition() {
        return this.position;
    }

    void setOrder(int order) {
        this.order = order;
    }

    int getOrder() {
        return this.order;
    }

    private void overrideFocusHandling() {
        HashSet forwardKeys = new HashSet();
        this.setFocusTraversalKeys(0, forwardKeys);
        HashSet backKeys = new HashSet();
        this.setFocusTraversalKeys(1, backKeys);
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        AbstractAction tabAction = new AbstractAction("tab"){

            public void actionPerformed(ActionEvent e) {
                CMBViewerToolbar.this.getComponent(CMBViewerToolbar.this.getComponentCount() - 1).transferFocus();
            }
        };
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "tab");
        inputMap.put(KeyStroke.getKeyStroke(9, 128), "tab");
        actionMap.put("tab", tabAction);
        AbstractAction backtabAction = new AbstractAction("backtab"){

            public void actionPerformed(ActionEvent e) {
                CMBViewerToolbar.this.getComponent(0).transferFocusBackward();
            }
        };
        inputMap.put(KeyStroke.getKeyStroke(9, 64), "backtab");
        inputMap.put(KeyStroke.getKeyStroke(9, 192), "backtab");
        actionMap.put("backtab", backtabAction);
    }

    public void addActionComponent(Action action) {
        PButton button = new PButton(action);
        this.addActionComponent(action, button);
    }

    void addActionComponent(AbstractButton button) {
        Action action = button.getAction();
        this.addActionComponent(action, button);
    }

    public void addActionComponent(Action action, JComponent component) {
        this.add(component);
        String actionCommand = (String)action.getValue("ActionCommandKey");
        if (component instanceof AbstractButton) {
            this.setIcons((AbstractButton)component);
        }
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setActionCommand(actionCommand);
        }
        component.getAccessibleContext().setAccessibleName((String)action.getValue("ShortDescription"));
        if (actionCommand != null) {
            this.actions.put(actionCommand, action);
            this.actionComponents.put(actionCommand, component);
        }
        component.setBorder(new FocusDrawingBorder(component.getBorder()));
    }

    private void setIcons(AbstractButton toolButton) {
        toolButton.setMargin(new Insets(0, 0, 0, 0));
        toolButton.setText("");
    }

    public void removeActionComponent(String name) {
        Component tool = (Component)this.actionComponents.remove(name);
        this.actions.remove(name);
        this.remove(tool);
    }

    public Component getComponent(String name) {
        return (Component)this.actionComponents.get(name);
    }

    public Action getAction(String name) {
        return (Action)this.actions.get(name);
    }

    public Component[] getComponents() {
        return super.getComponents();
    }

    public Action[] getActions() {
        return (Action[])this.getActionMap().keys();
    }

    void dispose() {
        Enumeration a = this.actions.elements();
        while (a.hasMoreElements()) {
            CMBViewerAction action = (CMBViewerAction)a.nextElement();
            action.dispose();
            Object var2_2 = null;
        }
        this.actions.clear();
        this.actionComponents.clear();
        this.actions = null;
        this.actionComponents = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        AbstractButton button;
        String property;
        Object source = event.getSource();
        String command = null;
        if (source instanceof AbstractAction) {
            command = (String)((AbstractAction)source).getValue("ActionCommandKey");
        }
        if ((property = event.getPropertyName()).equals("Name") && (button = (AbstractButton)this.getComponent(command)).getIcon() != null) {
            button.setText("");
        }
    }

    private class FocusDrawingBorder
    implements Border {
        Border originalBorder;

        public FocusDrawingBorder(Border originalBorder) {
            if (originalBorder == null) {
                Border uiBorder = UIManager.getBorder("ToolBar.rolloverBorder");
                if (uiBorder == null) {
                    uiBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);
                }
                this.originalBorder = uiBorder;
            } else {
                this.originalBorder = originalBorder;
            }
        }

        public Insets getBorderInsets(Component arg0) {
            if (this.originalBorder == null) {
                return new Insets(0, 0, 0, 0);
            }
            return this.originalBorder.getBorderInsets(arg0);
        }

        public boolean isBorderOpaque() {
            return this.originalBorder.isBorderOpaque();
        }

        public void paintBorder(Component c, Graphics arg1, int arg2, int arg3, int arg4, int arg5) {
            if (this.originalBorder != null && c instanceof AbstractButton) {
                this.originalBorder.paintBorder(c, arg1, arg2, arg3, arg4, arg5);
            }
            if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && c.hasFocus()) {
                Graphics2D g = (Graphics2D)arg1;
                Color oldColor = g.getColor();
                Color focusColor = UIManager.getColor("Button.focus");
                g.setColor(focusColor);
                Stroke oldStroke = g.getStroke();
                g.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f));
                g.drawRect(1, 1, c.getWidth() - 3, c.getHeight() - 3);
                g.setColor(oldColor);
                g.setStroke(oldStroke);
            }
        }
    }

    class PButton
    extends JButton
    implements Accessible {
        public PButton(Action action) {
            super(action);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePButton();
            }
            return this.accessibleContext;
        }

        protected class AccessiblePButton
        extends JButton.AccessibleJButton {
            protected AccessiblePButton() {
                super(PButton.this);
            }

            public String getAccessibleName() {
                if (PButton.this.getAction() != null) {
                    return (String)PButton.this.getAction().getValue("ShortDescription");
                }
                return super.getAccessibleName();
            }

            public String getAccessibleDescription() {
                if (PButton.this.getAction() != null) {
                    return (String)PButton.this.getAction().getValue("LongDescription");
                }
                return super.getAccessibleDescription();
            }
        }
    }
}

