/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PDocView;
import com.ibm.mm.viewer.PFullSizeView;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PRotatePagesDialog;
import com.ibm.mm.viewer.PThumbnailsView;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationConstants;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class CMBViewerAction
extends AbstractAction
implements CMBAnnotationConstants {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    static final String UNFORMATTED_NAME = "UNFORMATTED_NAME";
    static final String UNFORMATTED_DESCRIPTION = "UNFORMATTED_DESCRIPTION";
    static final String TOGGLE_KEY = "toggle";
    private CMBGenericDocViewer viewer;
    private boolean selected;
    LinkedList components = new LinkedList();

    public CMBViewerAction(CMBGenericDocViewer viewer) {
        this.viewer = viewer;
    }

    public CMBViewerAction(CMBGenericDocViewer viewer, String name) {
        super(name);
        this.putValue("ActionCommandKey", name);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
        this.viewer = viewer;
    }

    public CMBViewerAction(CMBGenericDocViewer viewer, String name, Icon icon) {
        super(name, icon);
        this.putValue("ActionCommandKey", name);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
        this.viewer = viewer;
    }

    public CMBGenericDocViewer getViewer() {
        return this.viewer;
    }

    public void actionPerformed(ActionEvent event) {
        String methodName = "actionsPerformed";
        String actionCommand = null;
        actionCommand = (String)this.getValue("ActionCommandKey");
        if (actionCommand == null || this.viewer == null) {
            return;
        }
        this.viewer.setCurrentAction(this);
        try {
            PDocModel model = this.viewer.getSelectedModel();
            CMBDocument document = this.viewer.getSelectedDocument();
            PFullSizeView view = this.viewer.getSelectedView();
            if (!actionCommand.equalsIgnoreCase("copy") && this.viewer.getAnnotationServices() != null) {
                this.viewer.getAnnotationServices().commitPen();
            }
            if (!this.isAnnotationAction(actionCommand) && this.viewer.getAnnotationServices() != null && !this.viewer.isAnnotationToolSticky() && this.viewer.getSelectedAnnotationTool() != 0 && this.viewer.getCurrentMode() != 112 && this.viewer.getCurrentMode() != 113) {
                this.viewer.setSelectedAnnotationTool(0);
            }
            int page = 1;
            if (model != null) {
                page = model.getCurrentPageNumber();
            }
            if (actionCommand.equalsIgnoreCase("fit_height")) {
                this.viewer.fitHeight();
            } else if (actionCommand.equalsIgnoreCase("fit_width")) {
                this.viewer.fitWidth();
            } else if (actionCommand.equalsIgnoreCase("fit_window")) {
                this.viewer.fitInWindow();
            } else if (actionCommand.equalsIgnoreCase("fit_actualsize")) {
                this.viewer.fitActualSize();
            } else if (actionCommand.equalsIgnoreCase("zoom_in")) {
                this.viewer.zoomIn();
            } else if (actionCommand.equalsIgnoreCase("zoom_out")) {
                this.viewer.zoomOut();
            } else if (actionCommand.equalsIgnoreCase("zoom_custom")) {
                this.viewer.zoom();
            } else if (actionCommand.equalsIgnoreCase("enhance")) {
                this.viewer.setEnhance(!this.viewer.isEnhanced());
            } else if (actionCommand.equalsIgnoreCase("invert")) {
                this.viewer.setInvert(!this.viewer.isInverted());
            } else if (actionCommand.equalsIgnoreCase("rotate_90")) {
                this.viewer.rotatePages(1, 0, 0);
            } else if (actionCommand.equalsIgnoreCase("rotate_270")) {
                this.viewer.rotatePages(3, 0, 0);
            } else if (actionCommand.equalsIgnoreCase("rotate_180")) {
                this.viewer.rotatePages(2, 0, 0);
            } else if (actionCommand.equalsIgnoreCase("rotate_pages")) {
                if (model instanceof PPageModel) {
                    PRotatePagesDialog dlgRotatePages = new PRotatePagesDialog(((PPageModel)model).getPageCount(), this.viewer);
                    dlgRotatePages.showRotatePagesDialog();
                }
            } else if (actionCommand.equalsIgnoreCase("print_preview")) {
                this.viewer.printPreview();
            } else if (actionCommand.equalsIgnoreCase("page_setup")) {
                this.viewer.pageSetup();
            } else if (actionCommand.equalsIgnoreCase("print")) {
                this.viewer.printDocument();
            } else if (actionCommand.equalsIgnoreCase("print_all")) {
                this.viewer.printAllDocuments();
            } else if (actionCommand.equalsIgnoreCase("close_doc")) {
                this.viewer.closeDocument();
            } else if (actionCommand.equalsIgnoreCase("close_all_doc")) {
                this.viewer.closeAllDocuments();
            } else if (actionCommand.equalsIgnoreCase("help")) {
                this.viewer.fireCMBDocHelpEvent();
            } else if (actionCommand.equalsIgnoreCase("save_doc")) {
                this.viewer.save();
            } else if (actionCommand.equalsIgnoreCase("page_first")) {
                this.viewer.firstPage();
            } else if (actionCommand.equalsIgnoreCase("page_last")) {
                this.viewer.lastPage();
            } else if (actionCommand.equalsIgnoreCase("page_next")) {
                this.viewer.nextPage();
            } else if (actionCommand.equalsIgnoreCase("goto_page")) {
                if (model instanceof PPageModel) {
                    ((PPageModel)model).gotoPage(this.viewer);
                }
            } else if (actionCommand.equalsIgnoreCase("page_prev")) {
                this.viewer.prevPage();
            } else if (actionCommand.equalsIgnoreCase("doc_first")) {
                this.viewer.firstDocument();
            } else if (actionCommand.equalsIgnoreCase("doc_prev")) {
                this.viewer.prevDocument();
            } else if (actionCommand.equalsIgnoreCase("doc_next")) {
                this.viewer.nextDocument();
            } else if (actionCommand.equalsIgnoreCase("doc_last")) {
                this.viewer.lastDocument();
            } else if (actionCommand.equalsIgnoreCase("Undo")) {
                this.viewer.undo();
            } else if (actionCommand.equalsIgnoreCase("Redo")) {
                this.viewer.redo();
            } else if (actionCommand.equalsIgnoreCase("Cut")) {
                this.viewer.cut();
            } else if (actionCommand.equalsIgnoreCase("Copy")) {
                this.viewer.copy();
            } else if (actionCommand.equalsIgnoreCase("Paste")) {
                Point point = null;
                int pageNumber = ((PPageModel)this.viewer.getSelectedModel()).getCurrentPageNumber();
                Object o = event.getSource();
                if (o instanceof JComponent && ((JComponent)o).getParent() instanceof JPopupMenu) {
                    PDocView docView;
                    JComponent c = (JComponent)o;
                    JPopupMenu m = (JPopupMenu)c.getParent();
                    if (m.equals(this.viewer.getPagePopupMenu())) {
                        docView = this.viewer.getSelectedView();
                        point = docView.getPopupPoint();
                    }
                    if (m.equals(this.viewer.getThumbPopupMenu())) {
                        docView = this.viewer.getSelectedThumbnailView();
                        point = docView.getPopupPoint();
                        pageNumber = ((PThumbnailsView)docView).getPopupPage();
                    }
                }
                this.viewer.paste(point, pageNumber);
            } else if (actionCommand.equalsIgnoreCase("Arrow")) {
                this.viewer.setSelectedAnnotationTool(1);
            } else if (actionCommand.equalsIgnoreCase("Circle")) {
                this.viewer.setSelectedAnnotationTool(2);
            } else if (actionCommand.equalsIgnoreCase("Highlight")) {
                this.viewer.setSelectedAnnotationTool(3);
            } else if (actionCommand.equalsIgnoreCase("Line")) {
                this.viewer.setSelectedAnnotationTool(4);
            } else if (actionCommand.equalsIgnoreCase("note")) {
                this.viewer.setSelectedAnnotationTool(5);
            } else if (actionCommand.equalsIgnoreCase("Pen")) {
                this.viewer.setSelectedAnnotationTool(6);
            } else if (actionCommand.equalsIgnoreCase("Rect")) {
                this.viewer.setSelectedAnnotationTool(7);
            } else if (actionCommand.equalsIgnoreCase("Stamp")) {
                this.viewer.setSelectedAnnotationTool(8);
            } else if (actionCommand.equalsIgnoreCase("Text")) {
                this.viewer.setSelectedAnnotationTool(9);
            } else if (actionCommand.equalsIgnoreCase("hide_show")) {
                this.viewer.hideShowAnnotations();
            } else if (actionCommand.equalsIgnoreCase("move_front")) {
                try {
                    this.viewer.moveAnnotationFront();
                }
                catch (CMBAnnotationEngineException e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                    JOptionPane.showMessageDialog(this.viewer, e.getLocalizedMessage());
                }
            } else if (actionCommand.equalsIgnoreCase("send_back")) {
                try {
                    this.viewer.sendAnnotationBack();
                }
                catch (CMBAnnotationEngineException e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                    JOptionPane.showMessageDialog(this.viewer, e.getLocalizedMessage());
                }
            } else if (actionCommand.equalsIgnoreCase("eraser")) {
                this.viewer.setSelectedAnnotationTool(20);
            } else if (actionCommand.equalsIgnoreCase("delete")) {
                this.viewer.delete();
            } else if (actionCommand.equalsIgnoreCase("properties")) {
                this.viewer.changeAnnotationProperties();
            } else if (actionCommand.equalsIgnoreCase("pointer")) {
                this.viewer.setSelectedAnnotationTool(0);
            } else if (actionCommand.equalsIgnoreCase("selectArea")) {
                this.viewer.setCurrentMode(112);
            } else if (actionCommand.equalsIgnoreCase("showhidethumb")) {
                this.viewer.showThumbnails();
            } else if (actionCommand.equalsIgnoreCase("selectAll")) {
                this.viewer.selectAllPages();
            } else if (actionCommand.equalsIgnoreCase("deselectAll")) {
                this.viewer.deselectAll();
            } else if (actionCommand.equalsIgnoreCase("new_doc")) {
                try {
                    this.viewer.createDocument();
                }
                catch (CMBAnnotationEngineException e) {
                    JOptionPane.showMessageDialog(this.viewer, e.getLocalizedMessage());
                }
            } else if (actionCommand.equalsIgnoreCase("save_as")) {
                this.viewer.saveAsNew();
            } else if (actionCommand.equalsIgnoreCase("export_doc")) {
                this.viewer.export();
            } else if (actionCommand.equalsIgnoreCase("preferences")) {
                this.viewer.editPreferences();
            } else if (actionCommand.equalsIgnoreCase("find")) {
                this.viewer.find();
            } else if (actionCommand.equalsIgnoreCase("layout_tabbed")) {
                this.viewer.setViewerLayout(0);
            } else if (actionCommand.equalsIgnoreCase("layout_split_horizontal")) {
                this.viewer.setViewerLayout(1);
            } else if (actionCommand.equalsIgnoreCase("layout_split_vertical")) {
                this.viewer.setViewerLayout(2);
            } else if (actionCommand.equalsIgnoreCase("layout_thumbnails_only")) {
                this.viewer.setViewerLayout(3);
            }
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            JOptionPane.showMessageDialog(this.viewer, PViewerUtilities.getMessage("DocumentViewer.unexpectedError"), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0);
        }
        this.viewer.updateToolStates();
    }

    void dispose() {
        this.viewer = null;
    }

    LinkedList getComponents() {
        return this.components;
    }

    void addComponent(Component component) {
        this.components.add(component);
    }

    void removeComponent(JComponent component) {
        this.components.remove(component);
    }

    boolean isAnnotationAction(String actionCommand) {
        return actionCommand.equalsIgnoreCase("Arrow") || actionCommand.equalsIgnoreCase("Circle") || actionCommand.equalsIgnoreCase("Highlight") || actionCommand.equalsIgnoreCase("Line") || actionCommand.equalsIgnoreCase("note") || actionCommand.equalsIgnoreCase("Pen") || actionCommand.equalsIgnoreCase("Rect") || actionCommand.equalsIgnoreCase("Stamp") || actionCommand.equalsIgnoreCase("Text") || actionCommand.equalsIgnoreCase("selectArea");
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        for (int i = 0; i < this.components.size(); ++i) {
            JComponent component = (JComponent)this.components.get(i);
            if (!(component instanceof AbstractButton)) continue;
            ((AbstractButton)component).setSelected(selected);
        }
    }
}

