/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineCallbacks;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBGenericDocOCRStatusListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBLetters;
import com.ibm.mm.viewer.CMBOCREngine;
import com.ibm.mm.viewer.CMBOCRLetters;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.CMBStreamingDocServicesCallbacks;
import com.ibm.mm.viewer.CMBViewerConstants;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CMBStreamingDocServices
implements CMBViewerConstants,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private Properties _engineProperties;
    private Vector _documents = new Vector();
    private Vector _itemHandles = new Vector();
    private CMBStreamingDocServicesCallbacks _callbacks;
    private String[] _preferredFormats = new String[]{"text/html", "application/pdf", "text/plain"};
    private String[] _preferredPageFormats = new String[]{"text/html", "image/gif", "image/png", "image/jpeg", "text/plain"};
    private Properties _conversionProperties = new Properties();
    private CMBDocument _lastDocument;
    private Vector _engines;
    private CMBOCREngine _ocrEngine;
    private Object _documentsLock = new Object();
    private transient boolean _finalizing = false;

    public CMBStreamingDocServices() {
        this._init(null, null);
    }

    public CMBStreamingDocServices(CMBStreamingDocServicesCallbacks callbacks, Properties engineProperties) {
        this._init(callbacks, engineProperties);
    }

    private void _init(CMBStreamingDocServicesCallbacks callbacks, Properties engineProperties) {
        this._callbacks = callbacks;
        this._engineProperties = engineProperties;
        if (this._callbacks == null) {
            this._callbacks = new CMBStreamingDocServicesCallbacks(){};
        }
        try {
            URL url;
            if (this._engineProperties == null || this._engineProperties.isEmpty()) {
                this._engineProperties = new Properties();
            }
            if (!this._engineProperties.containsKey("ENGINES") && (url = this.getClass().getClassLoader().getResource("cmbviewerengine.properties")) != null) {
                URLConnection conn = url.openConnection();
                conn.setUseCaches(true);
                InputStream propertiesFile = conn.getInputStream();
                Properties propertiesFromFile = new Properties();
                propertiesFromFile.load(propertiesFile);
                this._engineProperties.putAll((Map<?, ?>)propertiesFromFile);
                if (this.traceEnabled()) {
                    this.trace("Default engine properties used from " + url);
                }
            }
            if (this.traceEnabled()) {
                StringBuffer engineProps = new StringBuffer("Engine properties:\n");
                Enumeration<Object> e = this._engineProperties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    engineProps.append("  ");
                    engineProps.append(key);
                    engineProps.append("=");
                    engineProps.append(this._engineProperties.get(key));
                    engineProps.append("\n");
                }
                this.trace(engineProps.toString());
            }
        }
        catch (Exception e) {
            this._engineProperties = engineProperties;
        }
    }

    public CMBDocument[] getDocuments() {
        Object[] docArray = new CMBDocument[this._documents.size()];
        this._documents.copyInto(docArray);
        return docArray;
    }

    public CMBDocument getDocuments(int index) throws ArrayIndexOutOfBoundsException {
        return (CMBDocument)this._documents.elementAt(index);
    }

    public String[] getPreferredFormats() {
        return this._preferredFormats;
    }

    public void setPreferredFormats(String[] formats) {
        this._preferredFormats = formats;
    }

    public String[] getPreferredPageFormats() {
        return this._preferredPageFormats;
    }

    public void setPreferredPageFormats(String[] pageFormats) {
        this._preferredPageFormats = pageFormats;
    }

    public Properties getConversionProperties() {
        return this._conversionProperties;
    }

    public CMBDocument createDocument(String mimeType) throws CMBDocumentEngineException {
        CMBDocumentEngine engine = this.getEngineForMimeType(mimeType);
        Object hDocument = engine.createDocument();
        CMBDocument document = new CMBDocument(this, engine, hDocument, mimeType);
        document.setNew(true);
        this._documents.addElement(document);
        this._itemHandles.addElement(null);
        this._lastDocument = document;
        return document;
    }

    public void setConversionProperties(Properties properties) {
        this._conversionProperties = properties;
    }

    public synchronized CMBDocument loadDocument(InputStream firstPart, int numberOfParts, String docMimeType, String firstPartMimeType, InputStream annotations, InputStream resources) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this.loadDocument(firstPart, 0, numberOfParts, docMimeType, firstPartMimeType, annotations, resources);
    }

    public synchronized CMBDocument loadDocument(InputStream firstPart, int firstPartSize, int numberOfParts, String docMimeType, String firstPartMimeType, InputStream annotations, InputStream resources) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this._loadDocument(firstPart, firstPartSize, numberOfParts, docMimeType, firstPartMimeType, annotations, resources, null);
    }

    public CMBDocument loadDocument(InputStream firstPart, int numberOfParts, String docMimeType, String firstPartMimeType, InputStream annotations, InputStream resources, String firstPartEncoding) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this._loadDocument(firstPart, 0, numberOfParts, docMimeType, firstPartMimeType, annotations, resources, firstPartEncoding);
    }

    public CMBDocument loadDocument(InputStream firstPart, int firstPartSize, int numberOfParts, String docMimeType, String firstPartMimeType, InputStream annotations, InputStream resources, String firstPartEncoding) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this._loadDocument(firstPart, firstPartSize, numberOfParts, docMimeType, firstPartMimeType, annotations, resources, firstPartEncoding);
    }

    public CMBDocument loadDocument(URL firstPart, int firstPartSize, int numberOfParts, String docMimeType, String firstPartMimeType, InputStream annotations, InputStream resources, String firstPartEncoding) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this._loadDocument(firstPart, firstPartSize, numberOfParts, docMimeType, firstPartMimeType, annotations, resources, firstPartEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMBDocument _loadDocument(Object firstPart, int firstPartSize, int numberOfParts, String docMimeType, String firstPartMimeType, InputStream annotations, InputStream resources, String firstPartEncoding) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (firstPart == null) {
            CMBDocumentEngineException de = new CMBDocumentEngineException("", (Object)new IllegalArgumentException("First part InputStream is null."));
            if (this.traceEnabled()) {
                this.trace(de.getMessage());
            }
            throw de;
        }
        CMBDocument document = null;
        String conversion = (String)this._conversionProperties.get(docMimeType);
        if (this.traceEnabled()) {
            this.trace("conversion property is " + conversion + " for doc mime type: " + docMimeType);
        }
        if (this.traceEnabled()) {
            this.trace("First part mime type: " + firstPartMimeType);
        }
        if (conversion == null) {
            conversion = (String)this._conversionProperties.get("*");
        }
        if (this.traceEnabled()) {
            this.trace("conversion =" + conversion);
        }
        Object object = this._documentsLock;
        synchronized (object) {
            if (conversion != null && conversion.equals("none")) {
                document = new CMBDocument(this, firstPart, firstPartMimeType);
            } else {
                if (this._engines == null) {
                    long start = 0L;
                    long end = 0L;
                    if (this.traceEnabled()) {
                        start = System.currentTimeMillis();
                    }
                    this.loadEngines();
                    if (this.traceEnabled()) {
                        end = System.currentTimeMillis();
                        this.trace("Time taken for loading engines :" + new Long(end - start));
                    }
                }
                CMBDocumentEngine engine = null;
                try {
                    engine = this.getEngineForMimeType(docMimeType);
                }
                catch (CMBDocumentEngineException e) {
                    // empty catch block
                }
                if (engine != null) {
                    if (!engine.isInitialized()) {
                        Properties thisEnginesProperties = this.loadEngineProperties(engine);
                        engine.initialize(new DocumentEngineCallbacks(), thisEnginesProperties);
                        if (this.traceEnabled() && engine instanceof SerializableDocumentEngine) {
                            this.trace("Engine " + ((SerializableDocumentEngine)engine).getEngineClassName() + " :initialized with properties: \n" + thisEnginesProperties);
                        }
                    }
                    if (this.traceEnabled()) {
                        if (engine instanceof SerializableDocumentEngine) {
                            this.trace("Engine " + ((SerializableDocumentEngine)engine).getEngineClassName() + " can load " + docMimeType);
                        }
                        this.trace("First part size = " + firstPartSize);
                    }
                    Object hDocument = null;
                    long startLoad = 0L;
                    long endLoad = 0L;
                    if (this.traceEnabled()) {
                        startLoad = System.currentTimeMillis();
                    }
                    if (firstPart instanceof InputStream) {
                        hDocument = firstPartSize > 0 ? engine.loadDocument((InputStream)firstPart, firstPartSize, numberOfParts, firstPartMimeType, docMimeType, annotations, resources, firstPartEncoding) : engine.loadDocument((InputStream)firstPart, numberOfParts, firstPartMimeType, docMimeType, annotations, resources, firstPartEncoding);
                    } else if (firstPart instanceof URL) {
                        hDocument = engine.loadDocument((URL)firstPart, firstPartSize, numberOfParts, firstPartMimeType, docMimeType, annotations, resources, firstPartEncoding);
                    }
                    if (this.traceEnabled()) {
                        endLoad = System.currentTimeMillis();
                        this.trace("Time taken for engine loadDocument() call :" + new Long(endLoad - startLoad));
                    }
                    if (hDocument != null) {
                        document = new CMBDocument(this, engine, hDocument, docMimeType);
                    }
                }
            }
            if (document == null) {
                if (this.traceEnabled()) {
                    this.trace("None of the engines can load this document format :" + docMimeType);
                }
                document = new CMBDocument(this, firstPart, firstPartMimeType);
            }
            this._documents.addElement(document);
            this._itemHandles.addElement(null);
            this._lastDocument = document;
        }
        return document;
    }

    public void movePages(CMBDocument sourceDocument, int firstSourcePage, int lastSourcePage, CMBDocument destDocument, int destPage) throws IOException {
        int i;
        this._validateMoveCopyPages(sourceDocument, firstSourcePage, lastSourcePage, destDocument, destPage);
        CMBPage[] movedPages = new CMBPage[lastSourcePage - firstSourcePage + 1];
        for (int i2 = firstSourcePage; i2 <= lastSourcePage; ++i2) {
            movedPages[i2 - firstSourcePage] = sourceDocument.pageToBeRemoved(i2);
        }
        int sourceOriginalPageCount = sourceDocument.getPageCount();
        int destOriginalPageCount = destDocument.getPageCount();
        sourceDocument.getEngine().movePages(sourceDocument.getDocumentHandle(), firstSourcePage, lastSourcePage, destDocument.getDocumentHandle(), destPage + 1, true);
        int nPagesMoved = lastSourcePage - firstSourcePage + 1;
        for (i = lastSourcePage + 1; i <= sourceOriginalPageCount; ++i) {
            sourceDocument.pageMoved(i, i - nPagesMoved);
        }
        for (i = destOriginalPageCount; i >= destPage; --i) {
            destDocument.pageMoved(i, i + nPagesMoved);
        }
        for (i = 0; i < movedPages.length; ++i) {
            destDocument.pageAdded(movedPages[i], destPage + i);
        }
        sourceDocument.setModified(true);
        destDocument.setModified(true);
    }

    public void copyPages(CMBDocument sourceDocument, int firstSourcePage, int lastSourcePage, CMBDocument destDocument, int destPage) throws IOException {
        this._validateMoveCopyPages(sourceDocument, firstSourcePage, lastSourcePage, destDocument, destPage);
        int destOriginalPageCount = destDocument.getPageCount();
        sourceDocument.getEngine().copyPages(sourceDocument.getDocumentHandle(), firstSourcePage, lastSourcePage, destDocument.getDocumentHandle(), destPage + 1, true);
        int nPagesCopied = lastSourcePage - firstSourcePage + 1;
        for (int i = destOriginalPageCount; i > destPage; --i) {
            destDocument.pageMoved(i, i + nPagesCopied);
        }
        destDocument.setModified(true);
    }

    public int getDocumentPageCount(CMBDocument doc) throws IOException, CMBDocumentEngineException {
        return doc._getPageCount();
    }

    private void _validateMoveCopyPages(CMBDocument sourceDocument, int firstSourcePage, int lastSourcePage, CMBDocument destDocument, int destPage) throws IOException {
        sourceDocument._validateDocument();
        destDocument._validateDocument();
        sourceDocument._validatePageManipulation();
        destDocument._validatePageManipulation();
        if (firstSourcePage < 1 || firstSourcePage > sourceDocument.getPageCount()) {
            throw new IndexOutOfBoundsException(PViewerUtilities.getMessage("DocumentServices.firstSourcePageInvalid"));
        }
        if (lastSourcePage < 1 || lastSourcePage > sourceDocument.getPageCount()) {
            throw new IndexOutOfBoundsException(PViewerUtilities.getMessage("DocumentServices.lastSourcePageInvalid"));
        }
        if (lastSourcePage < firstSourcePage) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentServices.lastSourcePageLessThanFirstSourcePage"));
        }
        if (destPage < 0 || destPage > destDocument.getPageCount()) {
            throw new IndexOutOfBoundsException(PViewerUtilities.getMessage("DocumentServices.destPageInvalid"));
        }
        if (sourceDocument == destDocument && destPage >= firstSourcePage && destPage <= lastSourcePage) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentServices.destPageWithinSourcePages"));
        }
        if (sourceDocument.getEngine() != destDocument.getEngine()) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentServices.sourceAndDestDocumentsInDifferentEngines"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dropDocument(CMBDocument document) {
        Object object = this._documentsLock;
        synchronized (object) {
            this._lastDocument = document;
            int index = this._documents.indexOf(document);
            if (index >= 0) {
                block6: {
                    try {
                        document.dropStream();
                    }
                    catch (IOException e) {
                        if (!this.traceEnabled()) break block6;
                        this.trace(e.getMessage());
                    }
                }
                document.dispose();
                this._documents.removeElementAt(index);
                document = null;
                this._itemHandles.removeElementAt(index);
            }
            this._lastDocument = null;
        }
    }

    public synchronized void dropAllDocuments() {
        while (this._documents.size() > 0) {
            CMBDocument document = (CMBDocument)this._documents.elementAt(0);
            this.dropDocument(document);
        }
    }

    public synchronized void setItemHandle(CMBDocument document, Object itemHandle) {
        int size = this._documents.size();
        for (int i = 0; i < size; ++i) {
            if (!this._documents.elementAt(i).equals(document)) continue;
            this._itemHandles.setElementAt(itemHandle, i);
        }
    }

    public synchronized Object getItemHandle(CMBDocument document) {
        int size = this._documents.size();
        for (int i = 0; i < size; ++i) {
            if (!this._documents.elementAt(i).equals(document)) continue;
            return this._itemHandles.elementAt(i);
        }
        return null;
    }

    public synchronized CMBDocument getDocumentFromHandle(Object hItem) {
        int size = this._itemHandles.size();
        for (int i = 0; i < size; ++i) {
            if (!this._itemHandles.elementAt(i).equals(hItem)) continue;
            return (CMBDocument)this._documents.elementAt(i);
        }
        return null;
    }

    public synchronized void terminate() {
        this.dropAllDocuments();
        this._documents.clear();
        this._itemHandles.clear();
        this._lastDocument = null;
        if (this._ocrEngine != null) {
            if (this._ocrEngine.isInitialized()) {
                this._ocrEngine.terminate();
            }
            this._ocrEngine = null;
        }
        if (this._engines == null) {
            return;
        }
        int size = this._engines.size();
        for (int i = 0; i < size; ++i) {
            CMBDocumentEngine eng = (CMBDocumentEngine)this._engines.elementAt(i);
            if (eng.isInitialized()) {
                eng.terminate();
            }
            Object var3_3 = null;
        }
        this._engines.removeAllElements();
        this._engines.clear();
        this._engines = null;
    }

    protected void finalize() throws Throwable {
        this._finalizing = true;
        this.terminate();
        this._documents = null;
        this._itemHandles = null;
        super.finalize();
    }

    CMBStreamingDocServicesCallbacks getServiceCallbacks() {
        return this._callbacks;
    }

    private CMBDocumentEngine getEngineForMimeType(String docMimeType) throws CMBDocumentEngineException {
        if (this._engines == null) {
            long start = 0L;
            long end = 0L;
            if (this.traceEnabled()) {
                start = System.currentTimeMillis();
            }
            try {
                this.loadEngines();
            }
            catch (Exception e) {
                throw new CMBDocumentEngineException(PViewerUtilities.getMessage("DocumentServices.problemLoadingEngines", new Object[]{e}));
            }
            if (this.traceEnabled()) {
                end = System.currentTimeMillis();
                this.trace("Time taken for loading engines :" + new Long(end - start));
            }
        }
        CMBDocumentEngine engineForMimeType = null;
        int engineCount = this._engines.size();
        if (this._engineProperties.get("USEENGINE." + docMimeType) != null) {
            String engineName = (String)this._engineProperties.get("USEENGINE." + docMimeType);
            for (int i = 0; i < engineCount && engineForMimeType == null; ++i) {
                SerializableDocumentEngine engine = (SerializableDocumentEngine)this._engines.elementAt(i);
                if (engine == null || !engine.getEngineClassName().equals(engineName) || !engine.canLoadDocument(docMimeType)) continue;
                engineForMimeType = engine;
            }
        }
        if (engineForMimeType != null) {
            return engineForMimeType;
        }
        for (int i = 0; i < engineCount && engineForMimeType == null; ++i) {
            CMBDocumentEngine engine = (CMBDocumentEngine)this._engines.elementAt(i);
            if (engine == null || !engine.canLoadDocument(docMimeType)) continue;
            if (this.traceEnabled() && engine instanceof SerializableDocumentEngine) {
                this.trace("Engine " + ((SerializableDocumentEngine)engine).getEngineClassName() + " can load " + docMimeType);
            }
            if (!engine.isInitialized()) {
                Properties thisEnginesProperties = this.loadEngineProperties(engine);
                engine.initialize(new DocumentEngineCallbacks(), thisEnginesProperties);
                if (this.traceEnabled() && engine instanceof SerializableDocumentEngine) {
                    this.trace("Engine " + ((SerializableDocumentEngine)engine).getEngineClassName() + " :initialized with properties: \n" + thisEnginesProperties);
                }
            }
            engineForMimeType = engine;
        }
        if (engineForMimeType == null) {
            if (this.traceEnabled()) {
                this.trace("No engine can understand " + docMimeType + " format");
            }
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("DocumentServices.noEngineSupport", new Object[]{docMimeType}));
        }
        return engineForMimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMBOCREngine getOcrEngine() throws CMBDocumentEngineException {
        Class<CMBStreamingDocServices> clazz = CMBStreamingDocServices.class;
        synchronized (CMBStreamingDocServices.class) {
            if (this._ocrEngine == null && this._engineProperties.get("OCRENGINE_CLASSNAME") != null) {
                long start = 0L;
                long end = 0L;
                if (this.traceEnabled()) {
                    start = System.currentTimeMillis();
                }
                String engineName = (String)this._engineProperties.get("OCRENGINE_CLASSNAME");
                this.trace("CMBStreamingDocServices:getOcrEngine:engineName: " + engineName);
                try {
                    Class<?> clazz2 = Class.forName(engineName);
                    Constructor<?> ocrEngineConstructor = clazz2.getDeclaredConstructor(Properties.class);
                    ocrEngineConstructor.setAccessible(true);
                    this._ocrEngine = (CMBOCREngine)ocrEngineConstructor.newInstance(this._engineProperties);
                }
                catch (Exception e) {
                    throw new CMBDocumentEngineException(PViewerUtilities.getMessage("DocumentServices.problemLoadingOCREngine " + engineName, new Object[]{e}));
                }
                if (this.traceEnabled()) {
                    end = System.currentTimeMillis();
                    this.trace("Time taken to instantiate the defined OCR engine " + engineName + ": " + new Long(end - start));
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._ocrEngine;
        }
    }

    boolean canOcr() {
        return this._ocrEngine != null && this.getOcrEngine() != null;
    }

    public boolean canOcr(CMBDocument document) {
        if (this._ocrEngine == null) {
            this.getOcrEngine();
        }
        if (this._ocrEngine != null) {
            return this._ocrEngine.canOcrDocument(document);
        }
        return false;
    }

    public synchronized CMBOCRLetters ocrPage(CMBPage page, CMBGenericDocOCRStatusListener listener) {
        if (this._ocrEngine == null) {
            this.getOcrEngine();
        }
        if (this._ocrEngine == null || page == null || !this._ocrEngine.canOcrDocument(page.getDocument())) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        if (listener != null) {
            this._ocrEngine.addOCRStatusListener(listener);
        }
        page.ocrLetters = this._ocrEngine.ocrPage(page);
        if (listener != null) {
            this._ocrEngine.removeStatusListener(listener);
        }
        return page.ocrLetters;
    }

    public void dropOcrPage(CMBPage ocrPage, CMBGenericDocOCRStatusListener listener) {
        if (this._ocrEngine == null) {
            return;
        }
        if (listener != null) {
            this._ocrEngine.addOCRStatusListener(listener);
        }
        this._ocrEngine.dropOCRPage(ocrPage);
        if (listener != null) {
            this._ocrEngine.removeStatusListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMBOCRLetters[] ocrDocument(CMBDocument document, CMBGenericDocOCRStatusListener listener) {
        CMBOCRLetters[] pages = null;
        if (this._ocrEngine == null) {
            this.getOcrEngine();
        }
        if (this._ocrEngine == null || !this._ocrEngine.canOcrDocument(document)) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        if (listener != null) {
            this._ocrEngine.addOCRStatusListener(listener);
        }
        boolean fSuccess = true;
        try {
            block12: {
                try {
                    pages = this._ocrEngine.ocrDocument(document);
                    for (int i = 1; i <= document.getPageCount(); ++i) {
                        CMBPage page = document.getPage(i);
                        if (pages[i - 1] == null) {
                            fSuccess = false;
                            continue;
                        }
                        page.ocrLetters = pages[i - 1];
                    }
                    if (!fSuccess) break block12;
                    document.setOCRValid(true);
                }
                catch (IOException e) {
                    Object var8_9 = null;
                    if (listener != null) {
                        this._ocrEngine.removeStatusListener(listener);
                    }
                }
            }
            Object var8_8 = null;
            if (listener != null) {
                this._ocrEngine.removeStatusListener(listener);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (listener != null) {
                this._ocrEngine.removeStatusListener(listener);
            }
            throw throwable;
        }
        return pages;
    }

    public void cancelOCR(CMBDocument document) {
        if (this._ocrEngine == null || !this._ocrEngine.canOcrDocument(document)) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        this._ocrEngine.cancelOCR(document);
    }

    private void loadEngines() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._engines = new Vector();
        if (this._engineProperties == null) {
            return;
        }
        int engineCount = 0;
        try {
            engineCount = Integer.parseInt(this._engineProperties.getProperty("ENGINES", "0"));
            if (this.traceEnabled()) {
                this.trace("Engine count from properties:" + this._engineProperties.getProperty("ENGINES"));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this.traceEnabled()) {
            this.trace("Engine count:" + engineCount);
        }
        for (int i = 0; i < engineCount; ++i) {
            SerializableDocumentEngine engine = null;
            String engineClassName = this._engineProperties.getProperty("ENGINE" + String.valueOf(i + 1) + "_CLASSNAME", null);
            if (engineClassName == null) {
                this.trace("Engine could not be found for class: " + engineClassName);
                continue;
            }
            engine = new SerializableDocumentEngine(engineClassName);
            if (this.traceEnabled()) {
                this.trace("Loading engine:" + engineClassName + "...");
            }
            this._engines.addElement(engine);
            String delayInitStr = this._engineProperties.getProperty("ENGINE" + String.valueOf(i + 1) + "_DELAYINIT", "false");
            boolean delayInit = false;
            if (delayInitStr != null && delayInitStr.equalsIgnoreCase("true")) {
                delayInit = true;
            }
            if (this.traceEnabled()) {
                this.trace("Delay Init is :" + delayInit + " for " + engineClassName + " engine.");
            }
            if (!delayInit) {
                Properties thisEnginesProperties = this.loadEngineProperties(engine);
                ((CMBDocumentEngine)engine).initialize(new DocumentEngineCallbacks(), thisEnginesProperties);
                if (this.traceEnabled()) {
                    this.trace(engineClassName + " :initialized with properties: \n" + thisEnginesProperties);
                }
            }
            if (!this.traceEnabled()) continue;
            this.trace("Engine  " + engineClassName + " loaded successfully.");
        }
        if (this.traceEnabled()) {
            this.trace("Document engines loaded successfully.");
        }
    }

    private Properties loadEngineProperties(CMBDocumentEngine engine) {
        String name;
        int engineIndex = 0;
        for (int i = 0; i < this._engines.size(); ++i) {
            if (this._engines.get(i) != engine) continue;
            engineIndex = i;
        }
        Properties engineSpecificProperties = new Properties();
        Enumeration<?> en = this._engineProperties.propertyNames();
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            if (!name.startsWith("ENGINE_")) continue;
            String newName = name.substring("ENGINE_".length());
            engineSpecificProperties.put(newName, this._engineProperties.getProperty(name));
        }
        en = this._engineProperties.propertyNames();
        while (en.hasMoreElements()) {
            String enginePrefix;
            name = (String)en.nextElement();
            if (!name.startsWith(enginePrefix = "ENGINE" + (engineIndex + 1) + "_")) continue;
            String newName = name.substring(enginePrefix.length());
            engineSpecificProperties.put(newName, this._engineProperties.getProperty(name));
        }
        return engineSpecificProperties;
    }

    boolean traceEnabled() {
        return this._callbacks.traceEnabled();
    }

    void trace(String message) {
        this._callbacks.trace(message);
    }

    void setLastDocument(CMBDocument document) {
        this._lastDocument = document;
    }

    private class SerializablePageHandle
    implements Serializable {
        private SerializableDocumentHandle _serializableDocumentHandle;
        private int _page;
        private transient Object _hPage;

        SerializablePageHandle(SerializableDocumentHandle serializableDocumentHandle, int page) {
            this._serializableDocumentHandle = serializableDocumentHandle;
            this._page = page;
        }

        public String toString() {
            return "" + this._hPage;
        }

        SerializableDocumentHandle getDocumentHandle() {
            return this._serializableDocumentHandle;
        }

        int getPage() {
            return this._page;
        }

        void setRealHandle(Object hPage) {
            this._hPage = hPage;
        }

        Object getRealHandle() {
            return this._hPage;
        }
    }

    private class SerializableDocumentHandle
    implements Serializable {
        private int _numberOfParts;
        private String _partMimeType;
        private String _docMimeType;
        private transient Object _hDocument;

        SerializableDocumentHandle(int numberOfParts, String partMimeType, String docMimeType) {
            this._numberOfParts = numberOfParts;
            this._partMimeType = partMimeType;
            this._docMimeType = docMimeType;
        }

        public String toString() {
            return "" + this._hDocument;
        }

        int getNumberOfParts() {
            return this._numberOfParts;
        }

        String getPartMimeType() {
            return this._partMimeType;
        }

        String getDocMimeType() {
            return this._docMimeType;
        }

        void setRealHandle(Object hDocument) {
            this._hDocument = hDocument;
        }

        Object getRealHandle() {
            return this._hDocument;
        }
    }

    private class SerializableDocumentEngine
    extends CMBDocumentEngine
    implements Serializable {
        private String _engineClassName;
        private Properties _properties;
        private CMBDocumentEngineCallbacks _callbacks;
        private Vector _loadedDocuments = new Vector();
        private Vector _loadedPages = new Vector();
        private transient CMBDocumentEngine _engine;
        private transient boolean _needToReinit;

        SerializableDocumentEngine(String engineClassName) {
            this._engineClassName = engineClassName;
            this.instantiateEngine();
        }

        private String getEngineClassName() {
            return this._engineClassName;
        }

        public String toString() {
            return "" + this._engine;
        }

        public void initialize(CMBDocumentEngineCallbacks callbacks, Properties properties) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._callbacks = callbacks;
            this._properties = properties;
            this._engine.initialize(callbacks, properties);
        }

        public void terminate() {
            if (this._needToReinit && CMBStreamingDocServices.this._finalizing) {
                return;
            }
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.terminate();
        }

        public boolean isInitialized() {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.isInitialized();
        }

        public boolean canLoadDocument(String mimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canLoadDocument(mimeType);
        }

        public Object loadDocument(InputStream partStream, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
            Object realHandle;
            if (this._needToReinit) {
                this.reinitialize();
            }
            if ((realHandle = this._engine.loadDocument(partStream, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream)) == null) {
                return null;
            }
            SerializableDocumentHandle serializableDocHandle = new SerializableDocumentHandle(numberOfParts, partMimeType, docMimeType);
            serializableDocHandle.setRealHandle(realHandle);
            this._loadedDocuments.addElement(serializableDocHandle);
            return serializableDocHandle;
        }

        public Object loadDocument(InputStream partStream, int partStreamSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
            Object realHandle;
            if (this._needToReinit) {
                this.reinitialize();
            }
            if ((realHandle = this._engine.getClass().getName().equals("com.ibm.mm.viewer.mstech.CMBMSTechDocumentEngine") || this._engine.getClass().getName().equals("com.ibm.mm.viewer.inso.CMBMSTechInsoEngine") ? this._engine.loadDocument(partStream, numberOfParts, partStreamSize, partMimeType, docMimeType, annotationStream, resourceStream) : this._engine.loadDocument(partStream, partStreamSize, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream)) == null) {
                return null;
            }
            SerializableDocumentHandle serializableDocHandle = new SerializableDocumentHandle(numberOfParts, partMimeType, docMimeType);
            serializableDocHandle.setRealHandle(realHandle);
            this._loadedDocuments.addElement(serializableDocHandle);
            return serializableDocHandle;
        }

        public void dropDocument(Object hDocument) {
            if (this._needToReinit && CMBStreamingDocServices.this._finalizing) {
                return;
            }
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.dropDocument(this.getRealDocHandle(hDocument));
            this._loadedDocuments.removeElement(hDocument);
        }

        public boolean canWriteDocument(String sourceMimeType, String destMimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canWriteDocument(sourceMimeType, destMimeType);
        }

        public void writeDocument(Object hDocument, String destMimeType, OutputStream output) throws IOException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.writeDocument(this.getRealDocHandle(hDocument), destMimeType, output);
        }

        public void writeDocument(Object document, boolean withAnnotations, String destMimeType, OutputStream output) throws IOException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.writeDocument(this.getRealDocHandle(document), withAnnotations, destMimeType, output);
        }

        public void writeDocument(Object document, boolean withAnnotations, boolean originalColor, String destMimeType, OutputStream output) throws IOException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.writeDocument(this.getRealDocHandle(document), withAnnotations, originalColor, destMimeType, output);
        }

        public void writeDocument(Object document, String destMimetype, OutputStream docStream, OutputStream annotationStream) throws IOException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.writeDocument(this.getRealDocHandle(document), destMimetype, docStream, annotationStream);
        }

        public boolean canPaginate(String mimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canPaginate(mimeType);
        }

        public int getNumberOfPages(Object hDocument) throws IOException, CMBDocumentEngineException {
            int _i;
            block5: {
                if (this._needToReinit) {
                    this.reinitialize();
                }
                _i = 0;
                try {
                    _i = this._engine.getNumberOfPages(this.getRealDocHandle(hDocument));
                }
                catch (CMBDocumentEngineException e) {
                    if (CMBStreamingDocServices.this.traceEnabled()) {
                        CMBStreamingDocServices.this.trace("Engine throwing exception getting number of pages: " + e);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (!CMBStreamingDocServices.this.traceEnabled()) break block5;
                    CMBStreamingDocServices.this.trace("Engine throwing exception getting number of pages: " + e);
                }
            }
            return _i;
        }

        public Object loadPage(Object hDocument, int page) throws IOException {
            Object realHandle;
            if (this._needToReinit) {
                this.reinitialize();
            }
            if ((realHandle = this._engine.loadPage(this.getRealDocHandle(hDocument), page)) == null) {
                return null;
            }
            SerializablePageHandle serializablePageHandle = new SerializablePageHandle((SerializableDocumentHandle)hDocument, page);
            serializablePageHandle.setRealHandle(realHandle);
            this._loadedPages.addElement(serializablePageHandle);
            return serializablePageHandle;
        }

        public void dropPage(Object hPage) {
            if (this._needToReinit && CMBStreamingDocServices.this._finalizing) {
                return;
            }
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.dropPage(this.getRealPageHandle(hPage));
            this._loadedPages.removeElement(hPage);
        }

        public double getPageWidth(Object hPage) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            double width = this._engine.getPageWidth(this.getRealPageHandle(hPage));
            if (this._engine.getClass().getName().equals("com.ibm.mm.viewer.mstech.CMBMSTechDocumentEngine") || this._engine.getClass().getName().equals("com.ibm.mm.viewer.inso.CMBMSTechInsoEngine")) {
                width /= (double)this.getPageXResolution(hPage);
            }
            return width;
        }

        public boolean isPageValid(Object hPage) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            boolean valid = this._engine.isPageValid(this.getRealPageHandle(hPage));
            return valid;
        }

        public double getPageHeight(Object hPage) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            double height = this._engine.getPageHeight(this.getRealPageHandle(hPage));
            if (this._engine.getClass().getName().equals("com.ibm.mm.viewer.mstech.CMBMSTechDocumentEngine") || this._engine.getClass().getName().equals("com.ibm.mm.viewer.inso.CMBMSTechInsoEngine")) {
                height /= (double)this.getPageYResolution(hPage);
            }
            return height;
        }

        public boolean canRotate(Object hDocument, String destMimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canRotate(this.getRealDocHandle(hDocument), destMimeType);
        }

        public double getPageMinScale(Object hPage, String destMimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getPageMinScale(this.getRealPageHandle(hPage), destMimeType);
        }

        public double getPageMaxScale(Object hPage, String destMimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getPageMaxScale(this.getRealPageHandle(hPage), destMimeType);
        }

        public int getAnnotationPosition(Object hDocument) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getAnnotationPosition(this.getRealDocHandle(hDocument));
        }

        public int getPageXResolution(Object hPage) {
            int resolution;
            if (this._needToReinit) {
                this.reinitialize();
            }
            if ((resolution = this._engine.getPageXResolution(this.getRealPageHandle(hPage))) == 0) {
                resolution = 96;
            }
            return resolution;
        }

        public CMBLetters extractText(Object hPage) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            CMBLetters letters = this._engine.extractText(this.getRealPageHandle(hPage));
            return letters;
        }

        public int getPageYResolution(Object hPage) {
            int resolution;
            if (this._needToReinit) {
                this.reinitialize();
            }
            if ((resolution = this._engine.getPageYResolution(this.getRealPageHandle(hPage))) == 0) {
                resolution = 96;
            }
            return resolution;
        }

        public boolean canEnhance(Object hDocument, String destMimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canEnhance(this.getRealDocHandle(hDocument), destMimeType);
        }

        public boolean canEnhancePage(Object hPage, String destMimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canEnhancePage(this.getRealPageHandle(hPage), destMimeType);
        }

        public boolean canInvert(Object hDocument, String destMimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canInvert(this.getRealDocHandle(hDocument), destMimeType);
        }

        public boolean canShowAnnotations(Object hDocument, String destMimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canShowAnnotations(this.getRealDocHandle(hDocument), destMimeType);
        }

        public boolean canWritePage(Object hPage, String destMimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canWritePage(this.getRealPageHandle(hPage), destMimeType);
        }

        public boolean canWritePage(String sourceMimeType, String destMimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canWritePage(sourceMimeType, destMimeType);
        }

        public String getPageMimeType(Object hPage, String[] preferredMimeTypes) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getPageMimeType(this.getRealPageHandle(hPage), preferredMimeTypes);
        }

        public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType) throws IOException, CMBDocumentEngineException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.writePage(this.getRealPageHandle(hPage), rotation, scale, enhance, invert, withAnnotations, output, destMimeType);
        }

        public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType, String resourcePrefix) throws IOException, CMBDocumentEngineException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.writePage(this.getRealPageHandle(hPage), rotation, scale, enhance, invert, withAnnotations, output, destMimeType, resourcePrefix);
        }

        public String getPageResourceMimeType(Object hPage, String resourceId) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getPageResourceMimeType(this.getRealPageHandle(hPage), resourceId);
        }

        public void writePageResource(Object hPage, String resourceId, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output) throws IOException, CMBDocumentEngineException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.writePageResource(this.getRealPageHandle(hPage), resourceId, rotation, scale, enhance, invert, withAnnotations, output);
        }

        public boolean canWriteDocumentFromPages(String sourceMimeType, String destMimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canWriteDocumentFromPages(sourceMimeType, destMimeType);
        }

        public void writeDocumentFromPages(Object hDocument, int startingPage, int endingPage, String destMimeType, OutputStream output, boolean withAnnotations) throws IOException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.writeDocumentFromPages(this.getRealDocHandle(hDocument), startingPage, endingPage, destMimeType, output, withAnnotations);
        }

        public boolean canProvidePageImage(String mimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canProvidePageImage(mimeType);
        }

        public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations) {
            Image _i;
            block3: {
                if (this._needToReinit) {
                    this.reinitialize();
                }
                _i = null;
                try {
                    _i = this._engine.getPageImage(this.getRealPageHandle(hPage), rotation, scale, enhance, invert, withAnnotations);
                }
                catch (Exception e) {
                    if (!CMBStreamingDocServices.this.traceEnabled()) break block3;
                    CMBStreamingDocServices.this.trace("Engine throwing exception getting page image: " + e);
                }
            }
            return _i;
        }

        public boolean canManipulatePages(Object hDocument) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canManipulatePages(this.getRealDocHandle(hDocument));
        }

        public boolean canDeletePages(Object hDocument, int cnt) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canDeletePages(this.getRealDocHandle(hDocument), cnt);
        }

        public boolean canPastePages(Object hDocument, int cnt) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canPastePages(this.getRealDocHandle(hDocument), cnt);
        }

        public Object createDocument() {
            Object realHandle;
            if (this._needToReinit) {
                this.reinitialize();
            }
            if ((realHandle = this._engine.createDocument()) == null) {
                return null;
            }
            SerializableDocumentHandle serializableDocHandle = new SerializableDocumentHandle(0, null, null);
            serializableDocHandle.setRealHandle(realHandle);
            this._loadedDocuments.addElement(serializableDocHandle);
            return serializableDocHandle;
        }

        public void movePages(Object sourceDocument, int firstSourcePage, int lastSourcePage, Object destDocument, int destPage, boolean withAnnotations) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.movePages(this.getRealDocHandle(sourceDocument), firstSourcePage, lastSourcePage, this.getRealDocHandle(destDocument), destPage, withAnnotations);
        }

        public void copyPages(Object sourceDocument, int firstSourcePage, int lastSourcePage, Object destDocument, int destPage, boolean withAnnotations) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.copyPages(this.getRealDocHandle(sourceDocument), firstSourcePage, lastSourcePage, this.getRealDocHandle(destDocument), destPage, withAnnotations);
        }

        public void deletePages(Object document, int firstPage, int lastPage) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.deletePages(this.getRealDocHandle(document), firstPage, lastPage);
        }

        public void rotatePage(Object page, int rotation) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.rotatePage(this.getRealPageHandle(page), rotation);
        }

        public boolean canCropPage(Object page) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canCropPage(this.getRealPageHandle(page));
        }

        public void cropPage(Object page, Rectangle cropRect) throws IllegalArgumentException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.cropPage(this.getRealPageHandle(page), cropRect);
        }

        boolean canTabulate(String mimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canTabulate(mimeType);
        }

        int getTableRows(Object hDocument) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getTableRows(this.getRealDocHandle(hDocument));
        }

        int getTableColumns(Object hDocument) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getTableColumns(this.getRealDocHandle(hDocument));
        }

        int getRowsPerPage(Object hDocument) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getRowsPerPage(this.getRealDocHandle(hDocument));
        }

        String getHeaderText(Object hDocument, int column) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getHeaderText(this.getRealDocHandle(hDocument), column);
        }

        String getCellText(Object hDocument, int row, int column) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getCellText(this.getRealDocHandle(hDocument), row, column);
        }

        String[] getRowsText(Object hDocument, int startRow, int endRow) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getRowsText(this.getRealDocHandle(hDocument), startRow, endRow);
        }

        int getPreferredColumnWidth(Object hDocument, int column) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getPreferredColumnWidth(this.getRealDocHandle(hDocument), column);
        }

        private Object getRealDocHandle(Object hDocument) {
            SerializableDocumentHandle serializableDocHandle = (SerializableDocumentHandle)hDocument;
            return serializableDocHandle.getRealHandle();
        }

        private Object getSerializableDocHandle(Object hDocument) {
            for (int i = 0; i < this._loadedDocuments.size(); ++i) {
                SerializableDocumentHandle d = (SerializableDocumentHandle)this._loadedDocuments.elementAt(i);
                if (d.getRealHandle() != hDocument) continue;
                return d;
            }
            return null;
        }

        private Object getRealPageHandle(Object hPage) {
            SerializablePageHandle serializablePageHandle = (SerializablePageHandle)hPage;
            return serializablePageHandle.getRealHandle();
        }

        private void instantiateEngine() {
            String methodName = "initiateEngine";
            try {
                Class<?> engineClass = Class.forName(this._engineClassName);
                this._engine = (CMBDocumentEngine)engineClass.newInstance();
            }
            catch (Exception e) {
                ViewerLogger.logError((Object)this, methodName, e);
                throw new RuntimeException(PViewerUtilities.getMessage("DocumentServices.engineLoadFailed", new String[]{this._engineClassName}));
            }
        }

        private void readObject(ObjectInputStream stream) throws Exception {
            stream.defaultReadObject();
            this._needToReinit = true;
        }

        private synchronized void reinitialize() {
            String methodName = "reinitialize";
            if (this._needToReinit) {
                try {
                    this.instantiateEngine();
                    this._engine.initialize(this._callbacks, this._properties);
                    this.reloadDocuments();
                    this.reloadPages();
                    this._needToReinit = false;
                }
                catch (Exception e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                    throw new RuntimeException(PViewerUtilities.getMessage("DocumentServices.engineLoadFailed", new String[]{this._engineClassName}));
                }
            }
        }

        private void reloadDocuments() throws Exception {
            for (int i = 0; i < this._loadedDocuments.size(); ++i) {
                SerializableDocumentHandle hDocument = (SerializableDocumentHandle)this._loadedDocuments.elementAt(i);
                hDocument.setRealHandle(this._engine.loadDocument(this._callbacks.getPart(hDocument, 0, null), hDocument.getNumberOfParts(), hDocument.getPartMimeType(), hDocument.getDocMimeType(), this._callbacks.getAnnotation(hDocument, 0), this._callbacks.getResources(hDocument)));
            }
        }

        private void reloadPages() throws Exception {
            for (int i = 0; i < this._loadedPages.size(); ++i) {
                SerializablePageHandle hPage = (SerializablePageHandle)this._loadedPages.elementAt(i);
                hPage.setRealHandle(this._engine.loadPage(this.getRealDocHandle(hPage.getDocumentHandle()), hPage.getPage()));
            }
        }

        public Object loadDocument(InputStream partStream, int partStreamSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
            Object realHandle;
            if (this._needToReinit) {
                this.reinitialize();
            }
            if ((realHandle = this._engine.getClass().getName().equals("com.ibm.mm.viewer.mstech.CMBMSTechDocumentEngine") || this._engine.getClass().getName().equals("com.ibm.mm.viewer.inso.CMBMSTechInsoEngine") ? this._engine.loadDocument(partStream, numberOfParts, partStreamSize, partMimeType, docMimeType, annotationStream, resourceStream, firstPartEncoding) : this._engine.loadDocument(partStream, partStreamSize, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream, firstPartEncoding)) == null) {
                return null;
            }
            SerializableDocumentHandle serializableDocHandle = new SerializableDocumentHandle(numberOfParts, partMimeType, docMimeType);
            serializableDocHandle.setRealHandle(realHandle);
            this._loadedDocuments.addElement(serializableDocHandle);
            return serializableDocHandle;
        }

        public Object loadDocument(InputStream partStream, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
            Object realHandle;
            if (this._needToReinit) {
                this.reinitialize();
            }
            if ((realHandle = this._engine.loadDocument(partStream, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream, firstPartEncoding)) == null) {
                return null;
            }
            SerializableDocumentHandle serializableDocHandle = new SerializableDocumentHandle(numberOfParts, partMimeType, docMimeType);
            serializableDocHandle.setRealHandle(realHandle);
            this._loadedDocuments.addElement(serializableDocHandle);
            return serializableDocHandle;
        }

        public Object loadDocument(URL partURL, int partSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
            Object realHandle;
            if (this._needToReinit) {
                this.reinitialize();
            }
            if ((realHandle = this._engine.loadDocument(partURL, partSize, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream, firstPartEncoding)) == null) {
                return null;
            }
            SerializableDocumentHandle serializableDocHandle = new SerializableDocumentHandle(numberOfParts, partMimeType, docMimeType);
            serializableDocHandle.setRealHandle(realHandle);
            this._loadedDocuments.addElement(serializableDocHandle);
            return serializableDocHandle;
        }

        boolean canProvideViewer(String mimeType) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canProvideViewer(mimeType);
        }

        PSingleDocViewer getViewerComponent(CMBGenericDocViewer gdv, Object hDocument, CMBDocument document, CMBAnnotationSet annotationSet) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getViewerComponent(gdv, this.getRealDocHandle(hDocument), document, annotationSet);
        }

        public boolean canBalancePage(Object hPage) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canBalancePage(this.getRealPageHandle(hPage));
        }

        public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getPageImage(this.getRealPageHandle(hPage), rotation, scale, enhance, invert, withAnnotations, contrast, brightness);
        }

        public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness, OutputStream output, String destMimeType) throws IOException, CMBDocumentEngineException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.writePage(this.getRealPageHandle(hPage), rotation, scale, enhance, invert, withAnnotations, contrast, brightness, output, destMimeType);
        }

        public String getDocumentResourceMimeType(Object document, String resourceId) throws IOException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.getDocumentResourceMimeType(this.getRealDocHandle(document), resourceId);
        }

        public void writeDocument(Object document, String destMimetype, OutputStream docStream, String urlPrefix) throws IOException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.writeDocument(this.getRealDocHandle(document), destMimetype, docStream, urlPrefix);
        }

        public void writeDocumentResource(Object document, String resourcePrefix, OutputStream docStream) throws IOException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.writeDocumentResource(this.getRealDocHandle(document), resourcePrefix, docStream);
        }

        public void drawPage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness, Graphics2D graphics) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.drawPage(this.getRealPageHandle(hPage), rotation, scale, enhance, invert, withAnnotations, contrast, brightness, graphics);
        }

        public boolean useDrawPage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.useDrawPage(this.getRealPageHandle(hPage), rotation, scale, enhance, invert, withAnnotations, contrast, brightness);
        }

        public boolean canRedactPage(Object page) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canRedactPage(this.getRealPageHandle(page));
        }

        public void redactPage(Object page, Rectangle redactRect) throws IllegalArgumentException {
            if (this._needToReinit) {
                this.reinitialize();
            }
            this._engine.redactPage(this.getRealPageHandle(page), redactRect);
        }

        public boolean canFind(Object hDocument) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.canFind(this.getRealDocHandle(hDocument));
        }

        public boolean find(Object hDocument, String text, int[] position, boolean matchCase, boolean reverse) {
            if (this._needToReinit) {
                this.reinitialize();
            }
            return this._engine.find(this.getRealDocHandle(hDocument), text, position, matchCase, reverse);
        }
    }

    private class DocumentEngineCallbacks
    extends CMBDocumentEngineCallbacks
    implements Serializable {
        private DocumentEngineCallbacks() {
        }

        public InputStream getForm(Object hDocument, String formName) {
            if (CMBStreamingDocServices.this._callbacks == null) {
                return null;
            }
            CMBDocument document = this.getCMBDocument(hDocument);
            return CMBStreamingDocServices.this._callbacks.getForm(document, formName);
        }

        public int getFormSize(Object hDocument, String formName) {
            if (CMBStreamingDocServices.this._callbacks == null) {
                return 0;
            }
            CMBDocument document = this.getCMBDocument(hDocument);
            return CMBStreamingDocServices.this._callbacks.getFormSize(document, formName);
        }

        public InputStream getPart(Object hDocument, int partNumber, StringBuffer outMimeType) {
            if (CMBStreamingDocServices.this._callbacks == null) {
                return null;
            }
            CMBDocument document = this.getCMBDocument(hDocument);
            return CMBStreamingDocServices.this._callbacks.getPart(document, partNumber, outMimeType);
        }

        public int getPartSize(Object hDocument, int partNumber) {
            if (CMBStreamingDocServices.this._callbacks == null) {
                return 0;
            }
            CMBDocument document = this.getCMBDocument(hDocument);
            return CMBStreamingDocServices.this._callbacks.getPartSize(document, partNumber);
        }

        public String getPartEncoding(Object hDocument, int partNumber) {
            if (CMBStreamingDocServices.this._callbacks == null) {
                return null;
            }
            CMBDocument document = this.getCMBDocument(hDocument);
            return CMBStreamingDocServices.this._callbacks.getPartEncoding(document, partNumber);
        }

        public InputStream getAnnotation(Object hDocument, int annotationNumber) {
            if (CMBStreamingDocServices.this._callbacks == null) {
                return null;
            }
            CMBDocument document = this.getCMBDocument(hDocument);
            return CMBStreamingDocServices.this._callbacks.getAnnotation(document, annotationNumber);
        }

        public InputStream getResources(Object hDocument) {
            if (CMBStreamingDocServices.this._callbacks == null) {
                return null;
            }
            CMBDocument document = this.getCMBDocument(hDocument);
            return CMBStreamingDocServices.this._callbacks.getResources(document);
        }

        public boolean traceEnabled() {
            return CMBStreamingDocServices.this.traceEnabled();
        }

        public void trace(String message) {
            CMBStreamingDocServices.this.trace(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CMBDocument getCMBDocument(Object hDocument) {
            if (hDocument == null) {
                return CMBStreamingDocServices.this._lastDocument;
            }
            Object object = CMBStreamingDocServices.this._documentsLock;
            synchronized (object) {
                int size = CMBStreamingDocServices.this._documents.size();
                for (int i = 0; i < size; ++i) {
                    CMBDocument document = (CMBDocument)CMBStreamingDocServices.this._documents.elementAt(i);
                    SerializableDocumentHandle d = (SerializableDocumentHandle)document.getDocumentHandle();
                    if (d == null) {
                        return CMBStreamingDocServices.this._lastDocument;
                    }
                    if (d != hDocument && d.getRealHandle() != hDocument) continue;
                    return document;
                }
            }
            return null;
        }

        public String deployNativeLibrary(String filename) {
            if (CMBStreamingDocServices.this._callbacks == null) {
                return null;
            }
            return CMBStreamingDocServices.this._callbacks.deployNativeLibrary(filename);
        }

        public int getPartPageCount(Object hDocument, int partNumber) {
            if (CMBStreamingDocServices.this._callbacks == null) {
                return 0;
            }
            CMBDocument document = this.getCMBDocument(hDocument);
            if (document == null) {
                return 0;
            }
            return CMBStreamingDocServices.this._callbacks.getPartPageCount(document, partNumber);
        }
    }
}

