/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import Snow.IMG_RECT;
import Snow.SNBD_SEARCH_RESULT;
import Snow.Snowbnd;
import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineCallbacks;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBLetter;
import com.ibm.mm.viewer.CMBLetters;
import com.ibm.mm.viewer.PDataAccessInterface;
import com.ibm.mm.viewer.PFastStreamAccess;
import com.ibm.mm.viewer.PHttpContentAccess;
import com.ibm.mm.viewer.PSimpleStreamAccess;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationServicesCallbacks;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CMBSnowboundEngine
extends CMBDocumentEngine {
    private static final int DEFAULT_DPI = 96;
    private static final double DEFAULT_PAGE_WIDTH = 8.5;
    private static final double DEFAULT_PAGE_HEIGHT = 11.0;
    private static final int MAX_IMAGE_BYTES = 0x1000000;
    private static int PDF_DPI = 200;
    private static int PDF_PIXEL_DEPTH = 24;
    private static final boolean USE_SNOWBOUND_FOR_PAGE_WRITE = false;
    private static final String OVERLAY_PATH_PROPERTY = "overlayPath";
    private static final String USE_MEMORY_PROPERTY = "useMemory";
    private static final String MIMETYPE_UNDEFINED = "mimetype/undefined";
    private CMBDocumentEngineCallbacks callbacks;
    private Properties properties;
    boolean initialized;
    boolean useMemory;
    private static Object drawPageMutex = new Object();
    CMBAnnotationServices annotationServices;
    static Snowbnd drawPageSnowbnd;
    static String drawPageMimetype;
    static double drawPageAdjustFactor;
    static SnowPart lastDrawnPart;
    static int lastDrawnPageNumber;
    static boolean lastDrawnPageInverted;
    boolean useDrawPage;
    boolean useMSTechAnnotationPosition;
    private int textDPI = 192;
    private static int[][] ditherWeight;

    @Override
    public void initialize(CMBDocumentEngineCallbacks callbacks, Properties properties) {
        this.callbacks = callbacks;
        this.properties = properties;
        this.useDrawPage = Boolean.valueOf(properties.getProperty("useDrawPage", "true"));
        this.useMSTechAnnotationPosition = Boolean.valueOf(properties.getProperty("useMSTechAnnotationPosition", "false"));
        this.annotationServices = new CMBAnnotationServices(new AnnotationServicesCallbacks(), properties);
        this.initialized = true;
        this.trace(null, "Initialized.");
    }

    @Override
    public void terminate() {
        this.annotationServices.terminate();
        this.initialized = false;
        this.trace(null, "Terminated.");
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean canLoadDocument(String mimeType) {
        if (mimeType.equals("image/tiff")) {
            return true;
        }
        if (mimeType.equals("image/tif")) {
            return true;
        }
        if (mimeType.equals("image/gif")) {
            return true;
        }
        if (mimeType.equals("image/jpg")) {
            return true;
        }
        if (mimeType.equals("image/jpeg")) {
            return true;
        }
        if (mimeType.equals("image/jfif")) {
            return true;
        }
        if (mimeType.equals("image/bmp")) {
            return true;
        }
        if (mimeType.equals("image/cals")) {
            return true;
        }
        if (mimeType.equals("image/x-cals")) {
            return true;
        }
        if (mimeType.equals("image/png")) {
            return true;
        }
        if (mimeType.equals("application/vnd.ibm.modcap")) {
            return true;
        }
        if (mimeType.equals("application/pdf")) {
            return true;
        }
        if (mimeType.equals("application/afp")) {
            return true;
        }
        if (mimeType.equals("application/line")) {
            return true;
        }
        if (mimeType.equals("text/plain")) {
            return true;
        }
        if (mimeType.equals("image/pcx") || mimeType.equals("image/x-pcx")) {
            return true;
        }
        if (mimeType.equals("image/dcx") || mimeType.equals("image/x-dcx")) {
            return true;
        }
        return mimeType.equals("application/dicom");
    }

    @Override
    public Object loadDocument(InputStream partStream, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        return this._loadDocument(partStream, -1, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream, null);
    }

    @Override
    public Object loadDocument(InputStream partStream, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
        return this._loadDocument(partStream, -1, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream, firstPartEncoding);
    }

    @Override
    public Object loadDocument(InputStream partStream, int partStreamSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        return this._loadDocument(partStream, partStreamSize, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream, null);
    }

    @Override
    public Object loadDocument(InputStream partStream, int partStreamSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
        return this._loadDocument(partStream, partStreamSize, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream, firstPartEncoding);
    }

    @Override
    public Object loadDocument(URL partURL, int partSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String partEncoding) throws IOException {
        return this._loadDocument(partURL, partSize, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream, partEncoding);
    }

    private Object _loadDocument(Object partContent, int partStreamSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
        SnowDocument document = new SnowDocument();
        this.trace(document, "loadDocument invoked");
        document.mimeType = docMimeType;
        document.parts = new SnowPart[numberOfParts];
        for (int i = 0; i < document.parts.length; ++i) {
            document.parts[i] = i == 0 ? new SnowPart(document, i, partContent, partStreamSize, partMimeType, firstPartEncoding) : new SnowPart(document, i, null, -1, null, null);
        }
        if (annotationStream != null) {
            try {
                document.annotationSet = this.annotationServices.loadAnnotationSet(annotationStream, "application/vnd.ibm.modcap", this.getAnnotationPosition(document), 1, 1);
            }
            catch (Exception e) {
                throw new CMBDocumentEngineException(PViewerUtilities.getMessage("SnowboundEngine.problemParsingAnnotations"), (Object)e);
            }
        }
        this.trace(document, "loadDocument completed.");
        return document;
    }

    private Snowbnd newSnowbnd(String mimeType) {
        Snowbnd snowbnd = new Snowbnd();
        snowbnd.setXdpi(96);
        snowbnd.setYdpi(96);
        if (mimeType != null && mimeType.equals("text/plain")) {
            snowbnd.IMGLOW_set_UTF_8(1);
            this.textDPI = Integer.parseInt(this.properties.getProperty("textDPI", "192"));
            int pageWidth = (int)(Float.parseFloat(this.properties.getProperty("pageWidth", "8.5")) * 1000.0f);
            int pageHeight = (int)(Float.parseFloat(this.properties.getProperty("pageHeight", "11.0")) * 1000.0f);
            int leftMargin = (int)(Float.parseFloat(this.properties.getProperty("leftMargin", "0.5")) * 1000.0f);
            int rightMargin = (int)(Float.parseFloat(this.properties.getProperty("rightMargin", "0.49")) * 1000.0f);
            int topMargin = (int)(Float.parseFloat(this.properties.getProperty("topMargin", "0.167")) * 1000.0f);
            int bottomMargin = (int)(Float.parseFloat(this.properties.getProperty("bottomMargin", "0.167")) * 1000.0f);
            String fontName = this.properties.getProperty("fontName", "Monospaced");
            int fontHeight = Integer.parseInt(this.properties.getProperty("fontHeight", "30"));
            boolean bold = Boolean.valueOf(this.properties.getProperty("fontBold", "true"));
            boolean italic = Boolean.valueOf(this.properties.getProperty("fontItalic", "false"));
            int lineSpacing = (int)((double)Float.parseFloat(this.properties.getProperty("lineSpacing", "10.0")) / 96.0 * (double)this.textDPI);
            double characterSpacing = (double)Float.parseFloat(this.properties.getProperty("characterSpacing", "0.0")) / 96.0 * (double)this.textDPI;
            int charactersPerLine = Integer.parseInt(this.properties.getProperty("charactersPerLine", "80"));
            int linesPerPage = Integer.parseInt(this.properties.getProperty("linesPerPage", "59"));
            int spacesForTab = Integer.parseInt(this.properties.getProperty("spacesForTab", "8"));
            snowbnd.IMGLOW_set_ascii_attributes(this.textDPI, this.textDPI, leftMargin, rightMargin, topMargin, bottomMargin, spacesForTab, pageWidth, pageHeight, fontHeight, charactersPerLine, linesPerPage, bold, italic, fontName, lineSpacing, characterSpacing);
        } else {
            snowbnd.IMGLOW_set_UTF_8(0);
        }
        snowbnd.IMGLOW_set_pdf_input(PDF_DPI, PDF_PIXEL_DEPTH);
        snowbnd.IMGLOW_set_pcl_input(200, 24);
        if (this.properties.getProperty(OVERLAY_PATH_PROPERTY) != null) {
            snowbnd.IMGLOW_set_overlay_path(this.properties.getProperty(OVERLAY_PATH_PROPERTY));
        }
        snowbnd.PrintStack = false;
        return snowbnd;
    }

    private int getXResFieldValue(Object hDocument, boolean isBigEndian) throws IOException {
        SnowDocument document = (SnowDocument)hDocument;
        boolean saveOrder = document.parts[0].getData().getBigEndian();
        document.parts[0].getData().setBigEndian(isBigEndian);
        int offset = document.parts[0].getData().getInt(4);
        int count = document.parts[0].getData().getShort(offset);
        offset += 2;
        int xres = -1;
        for (int i = 0; i < count; ++i) {
            int fieldTag = document.parts[0].getData().getShort(offset);
            int fieldType = document.parts[0].getData().getShort(offset + 2);
            int fieldValOffset = document.parts[0].getData().getInt(offset + 8);
            if (fieldTag == 282 && fieldType == 5) {
                int num = document.parts[0].getData().getInt(fieldValOffset);
                int den = document.parts[0].getData().getInt(fieldValOffset + 4);
                xres = num / den;
            }
            offset += 12;
        }
        document.parts[0].getData().setBigEndian(saveOrder);
        return xres;
    }

    private boolean isVCResZero(Object hDocument, int offset) throws IOException {
        SnowDocument document = (SnowDocument)hDocument;
        boolean saveOrder = document.parts[0].getData().getBigEndian();
        document.parts[0].getData().setBigEndian(false);
        int vcNum = document.parts[0].getData().getInt(offset);
        int vcDen = document.parts[0].getData().getInt(offset + 4);
        int vcRes = vcNum / vcDen;
        document.parts[0].getData().setBigEndian(saveOrder);
        return vcRes == 0;
    }

    private boolean isVCResZero(Object hDocument) throws IOException {
        SnowDocument document = (SnowDocument)hDocument;
        boolean saveOrder = document.parts[0].getData().getBigEndian();
        document.parts[0].getData().setBigEndian(true);
        boolean vcResZero = false;
        int offset = document.parts[0].getData().getInt(4);
        int count = document.parts[0].getData().getShort(offset);
        offset += 2;
        boolean xrestagFound = false;
        for (int i = 0; i < count; ++i) {
            boolean vcres;
            int fieldTag = document.parts[0].getData().getShort(offset);
            int fieldType = document.parts[0].getData().getShort(offset + 2);
            int fieldValOffset = document.parts[0].getData().getInt(offset + 8);
            if (fieldTag == 282) {
                xrestagFound = true;
                if (fieldType == 5 && (vcres = this.isVCResZero(hDocument, fieldValOffset))) {
                    vcResZero = true;
                }
            } else if (fieldTag == 283 && fieldType == 5 && (vcres = this.isVCResZero(hDocument, fieldValOffset))) {
                vcResZero = true;
            }
            offset += 12;
        }
        document.parts[0].getData().setBigEndian(saveOrder);
        if (!xrestagFound) {
            vcResZero = true;
        }
        return vcResZero;
    }

    @Override
    public int getAnnotationPosition(Object hDocument) {
        SnowDocument document = (SnowDocument)hDocument;
        if (document.mimeType.equals("application/pdf")) {
            return 1390;
        }
        try {
            SnowPage page1 = (SnowPage)this.loadPage(hDocument, 1);
            if (page1 != null && this.isPageValid(page1)) {
                int pageXResolution = this.getPageXResolution(page1);
                String mimeType = document.mimeType;
                if (mimeType.equals("image/gif")) {
                    return 685;
                }
                if (mimeType.equals("image/jpeg") || mimeType.equals("image/jpg")) {
                    return 7 * pageXResolution;
                }
                if (mimeType.equals("image/tiff") || mimeType.equals("image/tif")) {
                    if (this.useMSTechAnnotationPosition) {
                        int mask = 0;
                        int resUnit = this.getResolutionUnit(page1);
                        int byteOrder = this.getByteOrder(hDocument);
                        if (byteOrder == 2) {
                            if (resUnit != 2) {
                                pageXResolution = this.getXResFieldValue(hDocument, byteOrder == 2);
                            }
                            boolean vcResZero = this.isVCResZero(hDocument);
                            if (resUnit == 1) {
                                mask = vcResZero ? (mask |= 0x4000000) : (mask |= 0x1000000);
                            } else if (vcResZero || pageXResolution < 0) {
                                mask |= 0x2000000;
                            }
                        } else {
                            pageXResolution = this.getXResFieldValue(hDocument, byteOrder == 2);
                            if (resUnit == 1) {
                                mask |= 0x1000000;
                            }
                        }
                        if (resUnit == 3) {
                            mask |= 0x8000000;
                        } else if (pageXResolution == 0) {
                            mask |= 0x10000000;
                            pageXResolution = 96;
                        }
                        if (pageXResolution < 0) {
                            pageXResolution = 0;
                        }
                        return 7 * pageXResolution + mask;
                    }
                    return 7 * pageXResolution;
                }
                if (mimeType.equals("image/bmp")) {
                    return 7 * pageXResolution;
                }
                if (mimeType.equals("application/afp") || mimeType.equals("application/vnd.ibm.modcap")) {
                    return (int)(6.93 * (double)pageXResolution);
                }
                if (mimeType.equals("application/pdf")) {
                    return 1390;
                }
                return 7 * pageXResolution;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 1400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDocument(Object hDocument) {
        SnowDocument document = (SnowDocument)hDocument;
        this.trace(document, "dropDocument called");
        for (int i = 0; i < document.parts.length; ++i) {
            if (document.parts[i] == null || document.parts[i].data == null) continue;
            document.parts[i].data.dispose();
        }
        if (document.annotationSet != null) {
            this.annotationServices.dropAnnotationSet(document.annotationSet);
        }
        Object object = drawPageMutex;
        synchronized (object) {
            drawPageSnowbnd = null;
            drawPageMimetype = null;
            lastDrawnPart = null;
            lastDrawnPageNumber = -1;
        }
        this.trace(document, "dropDocument completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfPages(Object hDocument) throws IOException {
        SnowDocument document = (SnowDocument)hDocument;
        if (document.pageCount == 0) {
            Object object = document.pageCountLock;
            synchronized (object) {
                if (document.pageCount == 0) {
                    int pageCount = 0;
                    for (int i = 0; i < document.parts.length; ++i) {
                        pageCount += document.parts[i].getPageCount();
                    }
                    document.pageCount = pageCount;
                }
            }
        }
        return document.pageCount;
    }

    @Override
    public boolean canPaginate(String mimeType) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object loadPage(Object hDocument, int pageNumber) throws IOException {
        SnowPage page;
        SnowDocument document = (SnowDocument)hDocument;
        this.trace(document, "loadPage started, page " + pageNumber);
        Integer key = new Integer(pageNumber);
        SnowDocument snowDocument = document;
        synchronized (snowDocument) {
            if (document.loadedPages.containsKey(key)) {
                page = (SnowPage)document.loadedPages.get(key);
            } else {
                if (document.parts.length == 0) {
                    return null;
                }
                page = new SnowPage();
                page.document = document;
                page.originalPageNumber = pageNumber;
                if (this.isPageValid(page)) {
                    document.loadedPages.put(key, page);
                } else {
                    return null;
                }
            }
        }
        this.trace(document, "loadPage completed");
        return page;
    }

    @Override
    public void dropPage(Object hPage) {
    }

    @Override
    public boolean canInvert(Object arg0, String arg1) {
        return true;
    }

    @Override
    public boolean canEnhance(Object arg0, String arg1) {
        return true;
    }

    @Override
    public boolean canProvidePageImage(String arg0) {
        return true;
    }

    @Override
    public boolean canRotate(Object arg0, String arg1) {
        return true;
    }

    @Override
    public boolean canBalancePage(Object hPage) {
        return true;
    }

    @Override
    public double getPageWidth(Object hPage) {
        SnowPage page = (SnowPage)hPage;
        if (page.widthPixels == 0) {
            this.retrievePageMetaData(page);
        }
        if (page.permanentRotation == 90 || page.permanentRotation == 270) {
            return (double)page.heightPixels / (double)this.getPageXResolution(hPage);
        }
        return (double)page.widthPixels / (double)this.getPageXResolution(hPage);
    }

    @Override
    public boolean isPageValid(Object hPage) {
        SnowPage page = (SnowPage)hPage;
        SnowPart part = page.getPart();
        if (!page.validated) {
            if (page.document.parts.length == 0) {
                page.valid = false;
                page.validated = true;
                return false;
            }
            if (part.pageCount > 0) {
                page.valid = part.getPageCount() >= page.getPartPageNumber();
            } else {
                Snowbnd snowbnd = this.newSnowbnd(part.getMimeType());
                DataInputStream dataStream = new DataInputStream(part.getData().getInputStream());
                snowbnd.IMGLOW_set_decompsize(16, 16);
                int rc = snowbnd.IMG_decompress_bitmap(dataStream, page.getPartPageNumber() - 1);
                snowbnd.finalize();
                if (this.isOutOfMemoryRC(rc)) {
                    throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
                }
                page.valid = rc == 0;
            }
            page.validated = true;
        }
        return page.valid;
    }

    @Override
    public double getPageHeight(Object hPage) {
        SnowPage page = (SnowPage)hPage;
        if (page.heightPixels == 0) {
            this.retrievePageMetaData(page);
        }
        if (page.permanentRotation == 90 || page.permanentRotation == 270) {
            return (double)page.widthPixels / (double)this.getPageYResolution(hPage);
        }
        return (double)page.heightPixels / (double)this.getPageYResolution(hPage);
    }

    @Override
    public int getPageXResolution(Object hPage) {
        SnowPage page = (SnowPage)hPage;
        if (page.xResolution == 0) {
            this.retrievePageMetaData(page);
        }
        if (page.permanentRotation == 90 || page.permanentRotation == 270) {
            return page.yResolution;
        }
        return page.xResolution;
    }

    @Override
    public int getPageYResolution(Object hPage) {
        SnowPage page = (SnowPage)hPage;
        if (page.yResolution == 0) {
            this.retrievePageMetaData(page);
        }
        if (page.permanentRotation == 90 || page.permanentRotation == 270) {
            return page.xResolution;
        }
        return page.yResolution;
    }

    private int getBitsPerPixel(Object hPage) {
        SnowPage page = (SnowPage)hPage;
        if (page.bitsPerPixel == 0) {
            this.retrievePageMetaData(page);
        }
        return page.bitsPerPixel;
    }

    private int getResolutionUnit(Object hPage) {
        SnowPage page = (SnowPage)hPage;
        if (page.bitsPerPixel == 0) {
            this.retrievePageMetaData(page);
        }
        return page.resolutionUnit;
    }

    private int getByteOrder(Object hDocument) {
        SnowDocument document = (SnowDocument)hDocument;
        int byteOrder = 0;
        try {
            byte firstByte = document.parts[0].getData().getByte(0);
            byteOrder = firstByte == 73 ? 1 : 2;
        }
        catch (IOException e) {
            // empty catch block
        }
        return byteOrder;
    }

    private int getMaxResolution(SnowPage page) {
        return Math.max(this.getPageXResolution(page), this.getPageYResolution(page));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrievePageMetaData(SnowPage page) {
        SnowDocument document;
        SnowDocument snowDocument = document = page.document;
        synchronized (snowDocument) {
            DataInputStream dataStream;
            if (document.mimeType.equals("text/plain")) {
                page.xResolution = 96;
                page.yResolution = 96;
                page.widthPixels = 816;
                page.heightPixels = 1056;
                page.bitsPerPixel = 1;
                return;
            }
            SnowPart part = page.getPart();
            Snowbnd snowbnd = this.newSnowbnd(part.getMimeType());
            int rc = snowbnd.IMGLOW_get_fileinfo(dataStream = new DataInputStream(page.getPart().getData().getInputStream()), page.getPartPageNumber() - 1);
            if (rc < 0) {
                if (this.isOutOfMemoryRC(rc)) {
                    throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
                }
                throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
            }
            rc = snowbnd.getXdpi();
            if (rc < 0) {
                throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
            }
            page.xResolution = rc;
            if (page.xResolution <= 1) {
                page.xResolution = 96;
            }
            if ((rc = snowbnd.getWidth()) < 0) {
                throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
            }
            page.widthPixels = rc;
            if (page.widthPixels == 0) {
                page.widthPixels = 816;
            }
            if (document.mimeType.equals("application/pdf")) {
                page.widthPixels = (int)((double)page.widthPixels * (96.0 / (double)page.xResolution));
            }
            if ((rc = snowbnd.getYdpi()) < 0) {
                throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
            }
            page.yResolution = rc;
            if (page.yResolution <= 1) {
                page.yResolution = 96;
            }
            if ((rc = snowbnd.getHeight()) < 0) {
                throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
            }
            page.heightPixels = rc;
            if (page.heightPixels == 0) {
                page.heightPixels = 1056;
            }
            if (document.mimeType.equals("application/pdf")) {
                page.heightPixels = (int)((double)page.heightPixels * (96.0 / (double)page.yResolution));
            }
            if ((rc = snowbnd.getBitsPerPixel()) < 0) {
                throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
            }
            page.bitsPerPixel = rc;
            if (page.bitsPerPixel == 0) {
                page.bitsPerPixel = 24;
            }
            if (document.mimeType.equals("image/tiff")) {
                int[] value = new int[1];
                snowbnd.IMGLOW_get_tiff_tag(296, 0, value, dataStream, null, page.getPartPageNumber() - 1);
                page.resolutionUnit = value[0];
            }
            snowbnd.finalize();
            if (document.mimeType.equals("application/pdf")) {
                page.xResolution = 96;
                page.yResolution = 96;
                page.bitsPerPixel = PDF_PIXEL_DEPTH;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawPage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness, Graphics2D graphics) {
        SnowDocument document;
        SnowPage page = (SnowPage)hPage;
        SnowDocument snowDocument = document = page.document;
        synchronized (snowDocument) {
            double pageWidth = this.getPageWidth(page);
            double pageHeight = this.getPageHeight(page);
            int resolution = this.getMaxResolution(page);
            int imageWidth = (int)((double)resolution * pageWidth * scale);
            int imageHeight = (int)((double)resolution * pageHeight * scale);
            if (rotation == 1 || rotation == 3) {
                int t = imageWidth;
                imageWidth = imageHeight;
                imageHeight = t;
            }
            int totalRotation = page.permanentRotation;
            if (rotation == 0) {
                totalRotation += 0;
            } else if (rotation == 1) {
                totalRotation += 90;
            } else if (rotation == 2) {
                totalRotation += 180;
            } else if (rotation == 3) {
                totalRotation += 270;
            }
            totalRotation %= 360;
            SnowPart part = page.getPart();
            Object object = drawPageMutex;
            synchronized (object) {
                int h;
                int w;
                int y;
                int x;
                if (drawPageSnowbnd == null || drawPageMimetype != null && !drawPageMimetype.equalsIgnoreCase(part.getMimeType())) {
                    drawPageSnowbnd = this.newSnowbnd(part.getMimeType());
                    drawPageMimetype = part.getMimeType();
                }
                int partPageNumber = page.getPartPageNumber();
                if (part != lastDrawnPart || partPageNumber != lastDrawnPageNumber) {
                    int rc;
                    DataInputStream dataStream = new DataInputStream(part.getData().getInputStream());
                    drawPageAdjustFactor = Math.max((double)(page.widthPixels * page.heightPixels * (page.bitsPerPixel / 8)) / 1.6777216E7, 1.0);
                    if (drawPageAdjustFactor != 1.0) {
                        drawPageSnowbnd.IMGLOW_set_decompsize((int)((double)page.widthPixels / drawPageAdjustFactor), (int)((double)page.heightPixels / drawPageAdjustFactor));
                    }
                    if ((rc = drawPageSnowbnd.IMG_decompress_bitmap(dataStream, partPageNumber - 1)) != 0) {
                        page.valid = false;
                        page.validated = true;
                        graphics.fillRect(0, 0, imageWidth, imageHeight);
                        if (this.isOutOfMemoryRC(rc)) {
                            throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
                        }
                        throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
                    }
                    lastDrawnPart = part;
                    lastDrawnPageNumber = partPageNumber;
                    lastDrawnPageInverted = false;
                    page.valid = true;
                    page.validated = true;
                    if (part.getMimeType().equals("application/pdf")) {
                        drawPageAdjustFactor *= 96.0 / (double)PDF_DPI;
                    } else if (part.getMimeType().equals("text/plain")) {
                        drawPageAdjustFactor *= 96.0 / (double)this.textDPI;
                    }
                    drawPageSnowbnd.IMG_promote_24();
                }
                CMBSnowboundEngine.drawPageSnowbnd.alias = enhance ? 4 : 0;
                if (invert && !lastDrawnPageInverted) {
                    drawPageSnowbnd.IMG_invert_bitmap();
                    lastDrawnPageInverted = true;
                } else if (!invert && lastDrawnPageInverted) {
                    drawPageSnowbnd.IMG_invert_bitmap();
                    lastDrawnPageInverted = false;
                }
                drawPageSnowbnd.IMGLOW_set_contrast((contrast - 100) * 255 / 200);
                drawPageSnowbnd.IMGLOW_set_brightness((brightness - 100) * 255 / 200);
                drawPageSnowbnd.display_angle(totalRotation % 360);
                Rectangle clipRect = graphics.getClipBounds();
                if (clipRect.x + clipRect.width > imageWidth) {
                    clipRect.width = imageWidth - clipRect.x;
                }
                if (clipRect.y + clipRect.height > imageHeight) {
                    clipRect.height = imageHeight - clipRect.y;
                }
                if (clipRect.isEmpty()) {
                    return;
                }
                double resolutionRatio = (double)page.yResolution / (double)page.xResolution;
                if (totalRotation == 0) {
                    x = clipRect.x;
                    y = clipRect.y;
                    w = clipRect.width;
                    h = clipRect.height;
                } else if (totalRotation == 90) {
                    x = clipRect.y;
                    y = imageWidth - clipRect.width - clipRect.x;
                    w = clipRect.height;
                    h = clipRect.width;
                } else if (totalRotation == 180) {
                    x = imageWidth - clipRect.width - clipRect.x;
                    y = imageHeight - clipRect.height - clipRect.y;
                    w = clipRect.width;
                    h = clipRect.height;
                } else {
                    x = imageHeight - clipRect.height - clipRect.y;
                    y = clipRect.x;
                    w = clipRect.height;
                    h = clipRect.width;
                }
                double factor = 1.0 / scale / drawPageAdjustFactor;
                drawPageSnowbnd.IMG_set_croprect((int)((double)x * factor), (int)((double)y * factor * resolutionRatio), (int)((double)w * factor), (int)((double)h * factor * resolutionRatio));
                int rc = drawPageSnowbnd.IMG_display_bitmap((Graphics)graphics, clipRect.x, clipRect.y, clipRect.width, clipRect.height);
                AffineTransform transform = graphics.getTransform();
                if (totalRotation == 1) {
                    graphics.translate(imageWidth / 2, imageHeight / 2);
                    graphics.rotate(1.5707963267948966);
                    graphics.translate(-imageHeight / 2, -imageWidth / 2);
                    graphics.translate(0, -imageHeight + imageWidth);
                } else if (totalRotation == 2) {
                    graphics.rotate(Math.PI, imageWidth / 2, imageHeight / 2);
                } else if (totalRotation == 3) {
                    graphics.translate(imageWidth / 2, imageHeight / 2);
                    graphics.rotate(4.71238898038469);
                    graphics.translate(-imageHeight / 2, -imageWidth / 2);
                    graphics.translate(imageHeight - imageWidth, 0);
                }
                graphics.scale(scale, scale);
                for (int i = 0; i < page.redactions.size(); ++i) {
                    Rectangle redactionRect = (Rectangle)page.redactions.get(i);
                    graphics.setColor(Color.black);
                    graphics.fillRect(redactionRect.x, redactionRect.y, redactionRect.width, redactionRect.height);
                }
                if (page.document.annotationSet != null) {
                    CMBPageAnnotation[] annotations = page.document.annotationSet.getPageAnnotations(page.originalPageNumber);
                    for (int i = annotations.length - 1; i >= 0; --i) {
                        annotations[i].draw(graphics);
                    }
                }
                graphics.setTransform(transform);
            }
        }
    }

    @Override
    public boolean useDrawPage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness) {
        return this.isUseDrawPage(hPage);
    }

    boolean isUseDrawPage(Object hPage) {
        SnowPage page = (SnowPage)hPage;
        SnowDocument document = page.document;
        if (document.mimeType.equals("application/dicom")) {
            return false;
        }
        return this.useDrawPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness) {
        SnowDocument document;
        SnowPage page = (SnowPage)hPage;
        SnowDocument snowDocument = document = page.document;
        synchronized (snowDocument) {
            DataInputStream dataStream;
            int rc;
            if (page.validated && !page.valid) {
                return null;
            }
            SnowPart part = page.getPart();
            Snowbnd snowbnd = this.newSnowbnd(part.getMimeType());
            int partPageNumber = page.getPartPageNumber();
            double adjustFactor = scale;
            int neededBytes = (int)((double)(page.widthPixels * page.heightPixels * (page.bitsPerPixel / 8)) * adjustFactor * adjustFactor);
            if (neededBytes > 0x1000000) {
                adjustFactor *= 1.6777216E7 / (double)neededBytes;
            }
            adjustFactor = Math.min(Math.max(adjustFactor, 0.125), 1.0);
            if (part.getMimeType().equals("application/dicom")) {
                adjustFactor = 1.0;
            }
            if (page.bitsPerPixel == 4) {
                adjustFactor = 1.0;
            }
            if (adjustFactor < 1.0) {
                if (part.getMimeType().equals("application/pdf")) {
                    snowbnd.IMGLOW_set_pdf_input((int)((double)PDF_DPI * adjustFactor), PDF_PIXEL_DEPTH);
                }
                snowbnd.IMGLOW_set_decompsize((int)((double)page.widthPixels * adjustFactor), (int)((double)page.heightPixels * adjustFactor));
            }
            if ((rc = snowbnd.IMG_decompress_bitmap(dataStream = new DataInputStream(part.getData().getInputStream()), partPageNumber - 1)) != 0) {
                if (this.isOutOfMemoryRC(rc)) {
                    throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
                }
                throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
            }
            int resolution = this.getMaxResolution(page);
            double pageWidth = this.getPageWidth(page);
            double pageHeight = this.getPageHeight(page);
            int imageWidth = Math.max((int)((double)resolution * pageWidth * scale), 1);
            int imageHeight = Math.max((int)((double)resolution * pageHeight * scale), 1);
            int imageNonrotatedWidth = imageWidth;
            int imageNonrotatedHeight = imageHeight;
            if (rotation == 1 || rotation == 3) {
                int t = imageWidth;
                imageWidth = imageHeight;
                imageHeight = t;
            }
            BufferedImage image = page.bitsPerPixel == 1 && !withAnnotations ? new BufferedImage(imageWidth, imageHeight, 10) : (imageWidth * imageHeight * 4 > 0x1000000 ? new BufferedImage(imageWidth, imageHeight, 13) : new BufferedImage(imageWidth, imageHeight, 5));
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            int totalRotation = page.permanentRotation;
            if (rotation == 0) {
                totalRotation += 0;
            } else if (rotation == 1) {
                totalRotation += 90;
            } else if (rotation == 2) {
                totalRotation += 180;
            } else if (rotation == 3) {
                totalRotation += 270;
            }
            snowbnd.display_angle(totalRotation % 360);
            if (invert) {
                snowbnd.IMG_invert_bitmap();
            }
            snowbnd.alias = enhance ? 4 : 0;
            if (contrast != 100) {
                snowbnd.IMGLOW_set_contrast((contrast - 100) * 255 / 200);
            }
            if (brightness != 100) {
                snowbnd.IMGLOW_set_brightness((brightness - 100) * 255 / 200);
            }
            if ((rc = snowbnd.IMG_display_bitmap((Graphics)graphics, 0, 0, image.getWidth(), image.getHeight())) != 0) {
                if (this.isOutOfMemoryRC(rc)) {
                    throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
                }
                throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
            }
            snowbnd.finalize();
            if (totalRotation == 90) {
                graphics.translate(imageNonrotatedWidth / 2, imageNonrotatedHeight / 2);
                graphics.rotate(1.5707963267948966);
                graphics.translate(-imageNonrotatedHeight / 2, -imageNonrotatedWidth / 2);
                graphics.translate(0, -imageNonrotatedHeight + imageNonrotatedWidth);
            } else if (totalRotation == 180) {
                graphics.rotate(Math.PI, imageNonrotatedWidth / 2, imageNonrotatedHeight / 2);
            } else if (totalRotation == 270) {
                graphics.translate(imageNonrotatedWidth / 2, imageNonrotatedHeight / 2);
                graphics.rotate(4.71238898038469);
                graphics.translate(-imageNonrotatedHeight / 2, -imageNonrotatedWidth / 2);
                graphics.translate(imageNonrotatedHeight - imageNonrotatedWidth, 0);
            }
            graphics.scale(scale, scale);
            for (int i = 0; i < page.redactions.size(); ++i) {
                Rectangle redactionRect = (Rectangle)page.redactions.get(i);
                graphics.setColor(Color.black);
                graphics.fillRect(redactionRect.x, redactionRect.y, redactionRect.width, redactionRect.height);
            }
            if (page.document.annotationSet != null && withAnnotations) {
                CMBPageAnnotation[] annotations = page.document.annotationSet.getPageAnnotations(page.originalPageNumber);
                for (int i = annotations.length - 1; i >= 0; --i) {
                    annotations[i].draw(graphics);
                }
            }
            graphics.dispose();
            return image;
        }
    }

    @Override
    public double getPageMaxScale(Object hPage, String destMimetype) {
        if (this.isUseDrawPage(hPage)) {
            int pageResolution = Math.max(this.getPageXResolution(hPage), this.getPageYResolution(hPage));
            return 960.0 / (double)pageResolution;
        }
        SnowPage page = (SnowPage)hPage;
        int imageWidth = (int)((double)this.getPageXResolution(page) * this.getPageWidth(page));
        int imageHeight = (int)((double)this.getPageYResolution(page) * this.getPageHeight(page));
        int memoryForActualSize = Math.max(imageWidth * imageHeight * 4, 1024);
        double maxScale = Math.log(0x4000000 / memoryForActualSize) / Math.log(2.0);
        return Math.max(maxScale, 1.0);
    }

    @Override
    public double getPageMinScale(Object arg0, String arg1) {
        return 0.01;
    }

    @Override
    public boolean canManipulatePages(Object hDocument) {
        return true;
    }

    @Override
    public boolean canDeletePages(Object hDocument, int cnt) {
        SnowDocument document = (SnowDocument)hDocument;
        return document.pageCount - cnt >= 1;
    }

    @Override
    public boolean canPastePages(Object hDocument, int cnt) {
        SnowDocument document = (SnowDocument)hDocument;
        String mimeType = document.mimeType;
        return document.pageCount + cnt <= 1 || !mimeType.equals("image/gif") && !mimeType.equals("image/jpeg") && !mimeType.equals("image/png") && !mimeType.equals("image/pcx") && !mimeType.equals("image/bmp");
    }

    @Override
    public Object createDocument() {
        SnowDocument document = new SnowDocument();
        document.allPagesLoaded = true;
        document.parts = new SnowPart[0];
        document.pageCount = 0;
        document.mimeType = MIMETYPE_UNDEFINED;
        return document;
    }

    private void appendPage(Snowbnd snowObject, String filename, byte[] pageData) {
        this.trace(null, "appendPage to file: " + filename + " count of page data: " + pageData.length);
        int rc = snowObject.IMGLOW_append_page(filename, pageData, 59);
        this.trace(null, "appendPage: rc " + rc);
    }

    @Override
    public void deletePages(Object hDocument, int firstPage, int lastPage) {
        SnowDocument document = (SnowDocument)hDocument;
        this.loadAllPages(document);
        for (int i = firstPage - 1; i < document.pageCount; ++i) {
            Integer key = new Integer(i);
            if (i < lastPage) {
                document.loadedPages.remove(key);
                continue;
            }
            SnowPage page = (SnowPage)document.loadedPages.remove(key);
            document.loadedPages.put(new Integer(i - (lastPage - firstPage - 1)), page);
        }
        document.pageCount -= lastPage - firstPage - 1;
    }

    @Override
    public void copyPages(Object sourceHDocument, int firstSourcePage, int lastSourcePage, Object destHDocument, int destPage, boolean withAnnotations) {
        SnowDocument sourceDocument = (SnowDocument)sourceHDocument;
        SnowDocument destDocument = (SnowDocument)destHDocument;
        this.loadAllPages(sourceDocument);
        this.loadAllPages(destDocument);
        for (int i = firstSourcePage; i <= lastSourcePage; ++i) {
            this.copyPage(sourceDocument, i, destDocument, destPage);
        }
    }

    private void copyPage(SnowDocument sourceDocument, int sourcePage, SnowDocument destDocument, int destPage) {
        if (destDocument.mimeType.equalsIgnoreCase(MIMETYPE_UNDEFINED)) {
            destDocument.mimeType = sourceDocument.mimeType;
        }
        SnowPage originalPage = (SnowPage)sourceDocument.loadedPages.get(new Integer(sourcePage));
        SnowPage copiedPage = (SnowPage)originalPage.clone();
        for (int i = destDocument.pageCount; i >= destPage; --i) {
            SnowPage page = (SnowPage)destDocument.loadedPages.remove(new Integer(i));
            destDocument.loadedPages.put(new Integer(i + 1), page);
        }
        destDocument.loadedPages.put(new Integer(destPage), copiedPage);
        ++destDocument.pageCount;
    }

    @Override
    public void movePages(Object sourceHDocument, int firstSourcePage, int lastSourcePage, Object destHDocument, int destPage, boolean withAnnotations) {
        SnowDocument sourceDocument = (SnowDocument)sourceHDocument;
        SnowDocument destDocument = (SnowDocument)destHDocument;
        this.loadAllPages(sourceDocument);
        this.loadAllPages(destDocument);
        for (int i = firstSourcePage; i <= lastSourcePage; ++i) {
            this.movePage(sourceDocument, i, destDocument, destPage);
        }
    }

    public void movePage(SnowDocument sourceDocument, int sourcePage, SnowDocument destDocument, int destPage) {
        SnowPage page;
        int i;
        if (destDocument.mimeType.equalsIgnoreCase(MIMETYPE_UNDEFINED)) {
            destDocument.mimeType = sourceDocument.mimeType;
        }
        SnowPage movedPage = (SnowPage)sourceDocument.loadedPages.remove(new Integer(sourcePage));
        for (i = sourcePage + 1; i <= sourceDocument.pageCount; ++i) {
            page = (SnowPage)sourceDocument.loadedPages.remove(new Integer(i));
            sourceDocument.loadedPages.put(new Integer(i - 1), page);
        }
        --sourceDocument.pageCount;
        for (i = destDocument.pageCount; i >= destPage; --i) {
            page = (SnowPage)destDocument.loadedPages.remove(new Integer(i));
            destDocument.loadedPages.put(new Integer(i + 1), page);
        }
        destDocument.loadedPages.put(new Integer(destPage), movedPage);
        ++destDocument.pageCount;
    }

    private void loadAllPages(SnowDocument document) {
        if (!document.allPagesLoaded) {
            try {
                if (document.parts.length > 0 && document.pageCount == 0) {
                    this.getNumberOfPages(document);
                }
                for (int i = 0; i < document.pageCount; ++i) {
                    Integer key = new Integer(document.pageCount);
                    if (document.loadedPages.contains(key)) continue;
                    this.loadPage(document, i + 1);
                }
            }
            catch (IOException e) {
                throw new CMBDocumentEngineException(e.getMessage(), (Object)e);
            }
            document.allPagesLoaded = true;
        }
    }

    @Override
    public void rotatePage(Object hPage, int rotation) {
        SnowPage page = (SnowPage)hPage;
        if (rotation == 1) {
            page.permanentRotation += 90;
        } else if (rotation == 2) {
            page.permanentRotation += 180;
        } else if (rotation == 3) {
            page.permanentRotation += 270;
        }
        page.permanentRotation %= 360;
    }

    @Override
    public boolean canWriteDocument(String sourceMimeType, String destMimeType) {
        if (destMimeType.equals("image/tiff")) {
            return true;
        }
        if (destMimeType.equals("image/tif")) {
            return true;
        }
        if (destMimeType.equals("image/jpeg")) {
            return true;
        }
        if (destMimeType.equals("image/jpg")) {
            return true;
        }
        if (destMimeType.equals("image/gif")) {
            return true;
        }
        if (destMimeType.equals("image/bmp")) {
            return true;
        }
        if (destMimeType.equals("image/png")) {
            return true;
        }
        if (destMimeType.equals("application/vnd.ibm.modcap")) {
            return false;
        }
        if (destMimeType.equals("application/pdf")) {
            return true;
        }
        if (destMimeType.equals("text/plain")) {
            return sourceMimeType.equals("text/plain");
        }
        if (destMimeType.equals("image/pcx")) {
            return true;
        }
        return destMimeType.equals("text/html");
    }

    @Override
    public void writeDocument(Object hDocument, String destMimeType, OutputStream output) throws IOException {
        this.writeDocument(hDocument, false, false, destMimeType, output);
    }

    @Override
    public void writeDocument(Object hDocument, String destMimetype, OutputStream docStream, OutputStream annotationStream) throws IOException {
        this.writeDocument(hDocument, destMimetype, docStream);
    }

    private byte[] getRotatedPage(SnowDocument document, SnowPage page, SnowPart part) {
        DataInputStream dataStream;
        Snowbnd snowbnd = this.newSnowbnd(part.getMimeType());
        int rc = snowbnd.IMG_decompress_bitmap(dataStream = new DataInputStream(part.getData().getInputStream()), page.getPartPageNumber() - 1);
        if (rc != 0) {
            page.valid = false;
            page.validated = true;
            if (this.isOutOfMemoryRC(rc)) {
                throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
            }
            throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
        }
        page.valid = true;
        page.validated = true;
        if (page.widthPixels == 0) {
            this.retrievePageMetaData(page);
        }
        snowbnd.IMGLOW_set_pdf_output(page.widthPixels * 72 / 96, page.heightPixels * 72 / 96);
        if (page.permanentRotation != 0) {
            snowbnd.IMG_rotate_bitmap(100 * page.permanentRotation);
        }
        byte[] docbytes = null;
        try {
            File tempFileRotatedPage = File.createTempFile("cmbrotatedpage" + page.getPartPageNumber(), ".pdf");
            rc = snowbnd.IMG_save_bitmap(tempFileRotatedPage.getAbsolutePath(), this.getAppropriateImageType("application/pdf", snowbnd));
            docbytes = CMBSnowboundEngine.readFileBytes(tempFileRotatedPage);
            this.trace(document, "created temp file of rotated page at: " + tempFileRotatedPage.getAbsolutePath() + " byte count: " + docbytes.length);
        }
        catch (IOException e) {
            // empty catch block
        }
        snowbnd.finalize();
        if (rc < 0) {
            if (this.isOutOfMemoryRC(rc)) {
                throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
            }
            throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
        }
        return docbytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeDocument(Object hDocument, boolean withAnnotations, boolean originalColor, String destMimeType, OutputStream output) throws IOException {
        SnowDocument document = (SnowDocument)hDocument;
        this.trace(document, "writeDocument called");
        if (this.getNumberOfPages(document) > 1 && (destMimeType.equals("image/gif") || destMimeType.equals("image/jpeg") || destMimeType.equals("image/png") || destMimeType.equals("image/pcx") || destMimeType.equals("image/bmp"))) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("SnowboundEngine.multipageToImageWrite", new String[]{destMimeType}));
        }
        SnowDocument snowDocument = document;
        synchronized (snowDocument) {
            this.loadAllPages(document);
            if (destMimeType.equals("text/plain") && document.mimeType.equals("text/plain") && document.parts.length == 1 && !withAnnotations) {
                byte[] utf8Bytes = document.parts[0].getData().getByteArray(0, document.parts[0].partSize);
                String contentString = new String(utf8Bytes, "UTF-8");
                byte[] originalEncodingBytes = document.parts[0].partEncoding == null ? contentString.getBytes() : contentString.getBytes(document.parts[0].partEncoding);
                output.write(originalEncodingBytes);
            } else if (destMimeType.equals(document.mimeType) && destMimeType.equals("application/pdf") && (!withAnnotations || document.annotationSet == null || document.annotationSet.getAnnotationCount() <= 0)) {
                File tempFileAllPages = File.createTempFile("cmbview", ".pdf");
                if (document.parts.length > 0 && document.parts[0].partSize > 0) {
                    FileOutputStream os = new FileOutputStream(tempFileAllPages);
                    byte[] docBytes = document.parts[0].getData().getByteArray(0, document.parts[0].partSize);
                    this.trace(document, "created temp file of original document at: " + tempFileAllPages.getAbsolutePath() + " byte count: " + docBytes.length);
                    ((OutputStream)os).write(docBytes);
                    ((OutputStream)os).close();
                } else {
                    this.trace(document, "this document is from create new document with no parts");
                }
                File tempNewFile = File.createTempFile("cmbcreated", ".pdf");
                this.trace(document, "created temp file of new document at: " + tempNewFile.getAbsolutePath());
                for (int i = 1; i <= document.pageCount; ++i) {
                    Integer key = new Integer(i);
                    SnowPage page = (SnowPage)document.loadedPages.get(key);
                    SnowPart part = page.getPart();
                    Snowbnd snowbnd = this.newSnowbnd(part.getMimeType());
                    int originalpagenumber = page.originalPageNumber;
                    byte[] extractedPage = page.getData();
                    if (page.permanentRotation != 0) {
                        this.trace(document, "get bytes of permanent rotated page: " + page.permanentRotation);
                        extractedPage = this.getRotatedPage(document, page, part);
                    }
                    if (extractedPage != null && extractedPage.length > 0) {
                        this.trace(document, "extracted page: " + originalpagenumber + " bytes: " + extractedPage.length);
                    } else {
                        this.trace(document, "extracted page is null or has no content");
                    }
                    if (i == 1) {
                        CMBSnowboundEngine.saveFileBytes(extractedPage, tempNewFile);
                        continue;
                    }
                    this.appendPage(snowbnd, tempNewFile.getAbsolutePath(), extractedPage);
                }
                byte[] docbytes = CMBSnowboundEngine.readFileBytes(tempNewFile);
                output.write(docbytes);
            } else {
                File tempFile;
                block58: {
                    tempFile = File.createTempFile("cmbview", "tmp");
                    BufferedInputStream tempInputStream = null;
                    try {
                        for (int i = 1; i <= document.pageCount; ++i) {
                            int rc;
                            Integer key = new Integer(i);
                            SnowPage page = (SnowPage)document.loadedPages.get(key);
                            SnowPart part = page.getPart();
                            Snowbnd snowbnd = this.newSnowbnd(part.getMimeType());
                            DataInputStream dataStream = new DataInputStream(part.getData().getInputStream());
                            double adjustFactor = 1.0;
                            if (part.getMimeType().equals("application/pdf")) {
                                adjustFactor = (double)PDF_DPI / 96.0;
                            }
                            if ((rc = snowbnd.IMG_decompress_bitmap(dataStream, page.getPartPageNumber() - 1)) != 0) {
                                page.valid = false;
                                page.validated = true;
                                if (this.isOutOfMemoryRC(rc)) {
                                    throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
                                }
                                throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
                            }
                            page.valid = true;
                            page.validated = true;
                            if (destMimeType.equals("application/pdf")) {
                                if (page.widthPixels == 0) {
                                    this.retrievePageMetaData(page);
                                }
                                snowbnd.IMGLOW_set_pdf_output(page.widthPixels * 72 / PDF_DPI, page.heightPixels * 72 / PDF_DPI);
                            }
                            if (withAnnotations && page.document.annotationSet != null && page.document.annotationSet.getPageAnnotations(page.originalPageNumber).length > 0 || page.redactions.size() > 0) {
                                double scale = 1.0 * adjustFactor;
                                int rotation = 0;
                                boolean enhance = false;
                                int contrast = 100;
                                int brightness = 100;
                                boolean invert = false;
                                int imageWidth = (int)((double)this.getPageXResolution(page) * this.getPageWidth(page) * scale);
                                int imageHeight = (int)((double)this.getPageYResolution(page) * this.getPageHeight(page) * scale);
                                if (rotation == 1 || rotation == 3) {
                                    int t = imageWidth;
                                    imageWidth = imageHeight;
                                    imageHeight = t;
                                }
                                BufferedImage image = new BufferedImage(imageWidth, imageHeight, 5);
                                Graphics2D graphics = (Graphics2D)image.getGraphics();
                                int totalRotation = page.permanentRotation;
                                if (rotation == 0) {
                                    totalRotation += 0;
                                } else if (rotation == 1) {
                                    totalRotation += 90;
                                } else if (rotation == 2) {
                                    totalRotation += 180;
                                } else if (rotation == 3) {
                                    totalRotation += 270;
                                }
                                snowbnd.display_angle(totalRotation % 360);
                                if (invert) {
                                    snowbnd.IMG_invert_bitmap();
                                }
                                snowbnd.alias = enhance ? 4 : 0;
                                if (contrast != 100) {
                                    snowbnd.IMGLOW_set_contrast((contrast - 100) * 255 / 200);
                                }
                                if (brightness != 100) {
                                    snowbnd.IMGLOW_set_brightness((brightness - 100) * 255 / 200);
                                }
                                rc = snowbnd.IMG_display_bitmap((Graphics)graphics, 0, 0, image.getWidth(), image.getHeight());
                                snowbnd.finalize();
                                if (rc != 0) {
                                    if (this.isOutOfMemoryRC(rc)) {
                                        throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
                                    }
                                    throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
                                }
                                if (totalRotation == 1) {
                                    graphics.translate(imageWidth / 2, imageHeight / 2);
                                    graphics.rotate(1.5707963267948966);
                                    graphics.translate(-imageHeight / 2, -imageWidth / 2);
                                    graphics.translate(0, -imageHeight + imageWidth);
                                } else if (totalRotation == 2) {
                                    graphics.rotate(Math.PI, imageWidth / 2, imageHeight / 2);
                                } else if (totalRotation == 3) {
                                    graphics.translate(imageWidth / 2, imageHeight / 2);
                                    graphics.rotate(4.71238898038469);
                                    graphics.translate(-imageHeight / 2, -imageWidth / 2);
                                    graphics.translate(imageHeight - imageWidth, 0);
                                }
                                graphics.scale(scale, scale);
                                for (int j = 0; j < page.redactions.size(); ++j) {
                                    Rectangle redactionRect = (Rectangle)page.redactions.get(j);
                                    graphics.setColor(Color.black);
                                    graphics.fillRect(redactionRect.x, redactionRect.y, redactionRect.width, redactionRect.height);
                                }
                                if (page.document.annotationSet != null) {
                                    CMBPageAnnotation[] annotations = page.document.annotationSet.getPageAnnotations(page.originalPageNumber);
                                    for (int j = annotations.length - 1; j >= 0; --j) {
                                        annotations[j].draw(graphics);
                                    }
                                }
                                graphics.dispose();
                                snowbnd = this.newSnowbnd("image");
                                if (originalColor) {
                                    if (page.bitsPerPixel == 1) {
                                        this.ditherToBinary(image);
                                        rc = snowbnd.IMG_decompress_bitmap((Image)image, 1);
                                    } else {
                                        if (page.bitsPerPixel < 24) {
                                            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("SnowboundEngine.cannotWriteWithOriginalColors"));
                                        }
                                        rc = snowbnd.IMG_decompress_bitmap((Image)image, 24);
                                    }
                                } else {
                                    rc = snowbnd.IMG_decompress_bitmap((Image)image, 24);
                                }
                                if (rc != 0) {
                                    if (this.isOutOfMemoryRC(rc)) {
                                        throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
                                    }
                                    throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
                                }
                                image.flush();
                                snowbnd.setXdpi((int)((double)page.xResolution * adjustFactor));
                                snowbnd.setYdpi((int)((double)page.yResolution * adjustFactor));
                            }
                            if (page.permanentRotation != 0) {
                                snowbnd.IMG_rotate_bitmap(100 * page.permanentRotation);
                            }
                            rc = snowbnd.IMG_save_bitmap(tempFile.getAbsolutePath(), this.getAppropriateImageType(destMimeType, snowbnd));
                            snowbnd.finalize();
                            if (rc >= 0) continue;
                            if (this.isOutOfMemoryRC(rc)) {
                                throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
                            }
                            throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
                        }
                        tempInputStream = new BufferedInputStream(new FileInputStream(tempFile.getAbsolutePath()));
                        byte[] buf = new byte[1024];
                        int len = tempInputStream.read(buf);
                        while (len != -1) {
                            output.write(buf, 0, len);
                            len = tempInputStream.read(buf);
                        }
                        Object var34_50 = null;
                        if (tempInputStream == null) break block58;
                    }
                    catch (Throwable throwable) {
                        Object var34_51 = null;
                        if (tempInputStream != null) {
                            tempInputStream.close();
                        }
                        if (tempFile.exists() && !tempFile.delete()) {
                            throw new IOException(PViewerUtilities.getMessage("DocumentEngine.tempFileDeleteFailed", new String[]{tempFile.getAbsolutePath()}));
                        }
                        throw throwable;
                    }
                    tempInputStream.close();
                }
                if (tempFile.exists() && !tempFile.delete()) {
                    throw new IOException(PViewerUtilities.getMessage("DocumentEngine.tempFileDeleteFailed", new String[]{tempFile.getAbsolutePath()}));
                }
            }
        }
        this.trace(document, "writeDocument completed");
    }

    static byte[] readFileBytes(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            fis.read(data);
            fis.close();
            return data;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void saveFileBytes(byte[] data, File file) {
        if (data == null) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(data);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getAppropriateImageType(String mimeType, Snowbnd snowbnd) {
        if (mimeType.equals("image/gif")) {
            return 4;
        }
        if (mimeType.equals("image/jpeg")) {
            return 13;
        }
        if (mimeType.equals("image/tiff")) {
            int bitsPerPixel = snowbnd.getBitsPerPixel();
            if (bitsPerPixel == 1) {
                return 10;
            }
            if (bitsPerPixel == 4 || bitsPerPixel == 8) {
                return 9;
            }
            return 9;
        }
        if (mimeType.equals("application/pdf")) {
            return 59;
        }
        if (mimeType.equals("image/pcx")) {
            return 2;
        }
        if (mimeType.equals("image/dcx")) {
            return 11;
        }
        if (mimeType.equals("image/bmp")) {
            return 1;
        }
        if (mimeType.equals("text/plain")) {
            return 38;
        }
        if (mimeType.equals("image/png")) {
            return 43;
        }
        if (mimeType.equals("application/afp")) {
            return 74;
        }
        if (mimeType.equals("application/vnd.ibm.modcap")) {
            return 74;
        }
        throw new CMBDocumentEngineException(PViewerUtilities.getMessage("DocumentEngine.mimeTypeCannotBeWritten"));
    }

    private boolean isOutOfMemoryRC(int rc) {
        return rc == -1;
    }

    private String getMessageForSnowRC(int rc) {
        if (rc == -1) {
            return PViewerUtilities.getMessage("SnowboundEngine.outOfMemory");
        }
        if (rc == -2) {
            return PViewerUtilities.getMessage("SnowboundEngine.openCallFailed");
        }
        if (rc == -3) {
            return PViewerUtilities.getMessage("SnowboundEngine.badFormat");
        }
        if (rc == -4) {
            return PViewerUtilities.getMessage("SnowboundEngine.invalidString");
        }
        if (rc == -5) {
            return PViewerUtilities.getMessage("SnowboundEngine.internalProblem");
        }
        if (rc == -6) {
            return PViewerUtilities.getMessage("SnowboundEngine.cantCreateFile");
        }
        if (rc == -7) {
            return PViewerUtilities.getMessage("SnowboundEngine.unrecognizedDoc");
        }
        if (rc == -8) {
            return PViewerUtilities.getMessage("SnowboundEngine.noBitmapInfo");
        }
        if (rc == -9) {
            return PViewerUtilities.getMessage("SnowboundEngine.errorWritingDisk");
        }
        if (rc == -10) {
            return PViewerUtilities.getMessage("SnowboundEngine.displayOutOfRange");
        }
        if (rc == -11) {
            return PViewerUtilities.getMessage("SnowboundEngine.pageDoesNotExist");
        }
        if (rc == -12) {
            return PViewerUtilities.getMessage("SnowboundEngine.fileTruncated");
        }
        if (rc == -13) {
            return PViewerUtilities.getMessage("SnowboundEngine.badImageHandle");
        }
        if (rc == -14) {
            return PViewerUtilities.getMessage("SnowboundEngine.noImageDataOnClipboard");
        }
        if (rc == -15) {
            return PViewerUtilities.getMessage("SnowboundEngine.twainDriverNotFound");
        }
        if (rc == -16) {
            return PViewerUtilities.getMessage("SnowboundEngine.badScannerDriver");
        }
        if (rc == -17) {
            return PViewerUtilities.getMessage("SnowboundEngine.twainDriverNotFound");
        }
        if (rc == -18) {
            return PViewerUtilities.getMessage("SnowboundEngine.userCancel");
        }
        if (rc == -19) {
            return PViewerUtilities.getMessage("SnowboundEngine.evaluationCopyExpired");
        }
        if (rc == -20) {
            return PViewerUtilities.getMessage("SnowboundEngine.noDesignMode");
        }
        if (rc == -21) {
            return PViewerUtilities.getMessage("SnowboundEngine.saveNotBPP");
        }
        if (rc == -22) {
            return PViewerUtilities.getMessage("SnowboundEngine.notSupportedPalettized");
        }
        if (rc == -23) {
            return PViewerUtilities.getMessage("SnowboundEngine.noLZWorGIF");
        }
        if (rc == -24) {
            return PViewerUtilities.getMessage("SnowboundEngine.dllNotLoaded");
        }
        if (rc == -25) {
            return PViewerUtilities.getMessage("SnowboundEngine.onTheFlyNotSupported");
        }
        if (rc == -26) {
            return PViewerUtilities.getMessage("SnowboundEngine.noTransparency");
        }
        if (rc == -27) {
            return PViewerUtilities.getMessage("SnowboundEngine.compressionNotSupported");
        }
        if (rc == -28) {
            return PViewerUtilities.getMessage("SnowboundEngine.scanningCompleted");
        }
        if (rc == -29) {
            return PViewerUtilities.getMessage("SnowboundEngine.noPagesReady");
        }
        if (rc == -30) {
            return PViewerUtilities.getMessage("SnowboundEngine.noDelayInAnimatedGIF");
        }
        if (rc == -31) {
            return PViewerUtilities.getMessage("SnowboundEngine.tiffTagNoFound");
        }
        if (rc == -32) {
            return PViewerUtilities.getMessage("SnowboundEngine.tiledTIFFNotValid");
        }
        if (rc == -33) {
            return PViewerUtilities.getMessage("SnowboundEngine.functionNotSupported");
        }
        if (rc == -34) {
            return PViewerUtilities.getMessage("SnowboundEngine.autofeedFailed");
        }
        if (rc == -35) {
            return PViewerUtilities.getMessage("SnowboundEngine.fastTransferNotSupported");
        }
        if (rc == -36) {
            return PViewerUtilities.getMessage("SnowboundEngine.noPDFSupport");
        }
        if (rc == -37) {
            return PViewerUtilities.getMessage("SnowboundEngine.noABICSupport");
        }
        if (rc == -38) {
            return PViewerUtilities.getMessage("SnowboundEngine.exception");
        }
        return PViewerUtilities.getMessage("SnowboundEngine.unexpected", new Object[]{new Integer(rc)});
    }

    @Override
    public boolean canWritePage(Object hPage, String destMimeType) {
        return destMimeType.equals("image/png");
    }

    @Override
    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType) throws IOException, CMBDocumentEngineException {
        this.writePage(hPage, rotation, scale, enhance, invert, withAnnotations, 100, 100, output, destMimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness, OutputStream output, String destMimeType) throws IOException, CMBDocumentEngineException {
        SnowDocument document;
        SnowPage page;
        block17: {
            BufferedImage pageImage;
            block16: {
                page = (SnowPage)hPage;
                document = page.document;
                this.trace(document, "writePage:hPage:" + hPage + ":pageNumber:" + page.getPartPageNumber() + ":enter");
                pageImage = (BufferedImage)this.getPageImage(hPage, rotation, scale, enhance, invert, withAnnotations, contrast, brightness);
                if (!document.mimeType.equalsIgnoreCase("image/tiff")) break block16;
                Snowbnd snowbnd = this.newSnowbnd("image");
                int rc = snowbnd.IMG_decompress_bitmap((Image)pageImage, 24);
                if (rc < 0) {
                    snowbnd.finalize();
                    if (this.isOutOfMemoryRC(rc)) {
                        throw new OutOfMemoryError(this.getMessageForSnowRC(rc));
                    }
                    throw new CMBDocumentEngineException(this.getMessageForSnowRC(rc));
                }
                if (destMimeType.equals("image/gif")) {
                    snowbnd.IMG_color_gray();
                }
                if (this.useMemory) {
                    byte[] temp = new byte[1000000];
                    int templen = snowbnd.IMG_save_bitmap(temp, this.getAppropriateImageType(destMimeType, snowbnd));
                    if (templen < 0) {
                        temp = new byte[10000000];
                        templen = snowbnd.IMG_save_bitmap(temp, this.getAppropriateImageType(destMimeType, snowbnd));
                    }
                    snowbnd.finalize();
                    if (templen < 0) {
                        throw new CMBDocumentEngineException(this.getMessageForSnowRC(templen));
                    }
                    output.write(temp, 0, templen);
                    output.close();
                    break block17;
                } else {
                    File tempFile;
                    block15: {
                        tempFile = File.createTempFile("pageImage", "gif");
                        InputStream tempInputStream = null;
                        try {
                            int templen = snowbnd.IMG_save_bitmap(tempFile.getAbsolutePath(), this.getAppropriateImageType(destMimeType, snowbnd));
                            snowbnd.finalize();
                            if (templen < 0) {
                                if (this.isOutOfMemoryRC(templen)) {
                                    throw new OutOfMemoryError(this.getMessageForSnowRC(templen));
                                }
                                throw new CMBDocumentEngineException(this.getMessageForSnowRC(templen));
                            }
                            tempInputStream = new BufferedInputStream(new FileInputStream(tempFile));
                            byte[] buff = new byte[1024];
                            int len = 0;
                            do {
                                if ((len = tempInputStream.read(buff)) <= 0) continue;
                                output.write(buff, 0, len);
                            } while (len > 0);
                            Object var23_26 = null;
                            if (tempInputStream == null) break block15;
                        }
                        catch (Throwable throwable) {
                            Object var23_27 = null;
                            if (tempInputStream != null) {
                                tempInputStream.close();
                            }
                            if (tempFile.exists() && !tempFile.delete()) {
                                throw new IOException(PViewerUtilities.getMessage("DocumentEngine.tempFileDeleteFailed", new String[]{tempFile.getAbsolutePath()}));
                            }
                            throw throwable;
                        }
                        tempInputStream.close();
                    }
                    if (tempFile.exists() && !tempFile.delete()) {
                        throw new IOException(PViewerUtilities.getMessage("DocumentEngine.tempFileDeleteFailed", new String[]{tempFile.getAbsolutePath()}));
                    }
                }
                break block17;
            }
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
            ImageWriter writer = writers.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(output);
            writer.setOutput(ios);
            writer.write(pageImage);
            writer.dispose();
            ios.close();
        }
        this.trace(document, "writePage:hPage:" + hPage + ":pageNumber:" + page.getPartPageNumber() + ":exit");
    }

    private void trace(SnowDocument document, String message) {
        if (this.callbacks != null && this.callbacks.traceEnabled()) {
            String qualifiedMessage = "CMBSnowboundEngine:" + message;
            if (document != null) {
                qualifiedMessage = qualifiedMessage + ":Document:" + document.hashCode();
            }
            this.callbacks.trace(qualifiedMessage);
        }
    }

    @Override
    public String getDocumentResourceMimeType(Object document, String resourceId) throws IOException {
        return "image/png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDocument(Object hDocument, String destMimeType, OutputStream output, String urlPrefix) throws IOException {
        if (destMimeType.equals("text/html")) {
            SnowDocument document;
            SnowDocument snowDocument = document = (SnowDocument)hDocument;
            synchronized (snowDocument) {
                this.loadAllPages(document);
                PrintStream printstream = new PrintStream(output);
                printstream.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
                printstream.println("<html>");
                printstream.println("<head>");
                printstream.println("<style type=\"text/css\">");
                printstream.println("\t@media print {");
                printstream.println("\t\t.printOnly {");
                printstream.println("\t\t\tdisplay: inline;");
                printstream.println("\t\t}");
                printstream.println("\t\t.screenOnly {");
                printstream.println("\t\t\tdisplay: none;");
                printstream.println("\t\t}");
                printstream.println("\t\tbody {");
                printstream.println("\t\t\tbackground-color: white;");
                printstream.println("\t\t}");
                printstream.println("\t}");
                printstream.println("\t@media screen {");
                printstream.println("\t\t.printOnly {");
                printstream.println("\t\t\tdisplay: none;");
                printstream.println("\t\t}");
                printstream.println("\t\t.screenOnly {");
                printstream.println("\t\t\tdisplay: inline;");
                printstream.println("\t\t}");
                printstream.println("\t\timg {");
                printstream.println("\t\t\tmargin: 4px;");
                printstream.println("\t\t\tborder: 1px solid #000000;");
                printstream.println("\t\t}");
                printstream.println("\t}");
                printstream.println("   br.pageBreak {");
                printstream.println("\t\tpage-break-before: always;");
                printstream.println("\t}");
                printstream.println("</style>");
                printstream.println("<script type=\"text/javascript\">");
                printstream.println("// This javascript dynamically copies the id property of page images to src property");
                printstream.println("// when the page is first shown.  This avoids unneeded page rendering on the server");
                printstream.println("// in document preview situations");
                printstream.println("");
                printstream.println("window.onload = showPages;");
                printstream.println("window.onscroll = showPages;");
                printstream.println("window.onresize = showPages;");
                printstream.println("");
                printstream.println("function showPages() {");
                printstream.println("\tvar images = document.body.getElementsByTagName(\"img\");");
                printstream.println("\tfor (var i = 0; i < images.length; i++) {");
                printstream.println("\t\tvar image = images[i];");
                printstream.println("\t\tif (image.src == \"\" && isShowing(image)) {");
                printstream.println("\t\t\timage.src = image.id;");
                printstream.println("\t\t}");
                printstream.println("\t}");
                printstream.println("}");
                printstream.println("");
                printstream.println("function isShowing(domObject) {");
                printstream.println("\tif (domObject.offsetTop + domObject.offsetHeight >= document.body.scrollTop) {");
                printstream.println("\t\tif (domObject.offsetTop <= document.body.scrollTop + document.body.clientHeight) {");
                printstream.println("\t\t\treturn true;");
                printstream.println("\t\t}");
                printstream.println("\t}");
                printstream.println("\treturn false;");
                printstream.println("}");
                printstream.println("");
                printstream.println("</script>");
                printstream.println("</head>");
                printstream.println("<body>");
                for (int i = 1; i <= document.pageCount; ++i) {
                    Object hPage = this.loadPage(hDocument, i);
                    int width = (int)(this.getPageWidth(hPage) * 96.0);
                    int height = (int)(this.getPageHeight(hPage) * 96.0);
                    this.dropPage(hPage);
                    printstream.println("<img id=\"" + urlPrefix + "page" + i + ".png\" width=" + width + " height=" + height + ">");
                    if (i >= document.pageCount) continue;
                    printstream.println("<br class=\"pageBreak\">");
                }
                printstream.println("</body>");
                printstream.println("</html>");
            }
        } else {
            this.writeDocument(hDocument, destMimeType, output);
        }
    }

    @Override
    public void writeDocumentResource(Object hDocument, String resourceId, OutputStream output) throws IOException {
        if (!resourceId.substring(0, 4).equals("page")) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("SnowboundEngine.invalidResourceID", new String[]{resourceId}));
        }
        String pageId = resourceId.substring(4, resourceId.indexOf("."));
        int pageNumber = Integer.parseInt(pageId);
        Object hPage = this.loadPage(hDocument, pageNumber);
        this.writePage(hPage, 0, 96.0 / (double)this.getPageXResolution(hPage), true, false, false, 100, 100, output, "image/png");
    }

    @Override
    public boolean canRedactPage(Object page) {
        return true;
    }

    @Override
    public void redactPage(Object hPage, Rectangle redactRect) throws IllegalArgumentException {
        SnowPage page = (SnowPage)hPage;
        page.redactions.add(redactRect);
    }

    @Override
    public boolean canFind(Object hDocument) {
        boolean enableFind = Boolean.valueOf(this.properties.getProperty("enableFind", "true"));
        if (enableFind) {
            SnowDocument document = (SnowDocument)hDocument;
            if (document.mimeType.equals("application/afp")) {
                return true;
            }
            if (document.mimeType.equals("application/pdf")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public CMBLetters extractText(Object hPage) {
        SnowPage page = (SnowPage)hPage;
        SnowDocument document = page.document;
        int pageNo = page.originalPageNumber;
        CMBLetters o = null;
        Snowbnd snowbnd = this.newSnowbnd(document.mimeType);
        DataInputStream dataStream = new DataInputStream(document.parts[0].data.getInputStream());
        int[] buflenArray = new int[1];
        int[] rcArray = new int[1];
        byte[] buf = snowbnd.IMGLOW_extract_text(dataStream, buflenArray, rcArray, pageNo - 1);
        if (rcArray[0] != 0) {
            System.err.println(this.getMessageForSnowRC(rcArray[0]));
            return null;
        }
        try {
            ArrayList<CMBLetter> letters = this.parseTextBlock(snowbnd, buf, rcArray);
            o = new CMBLetters(letters.toArray(new CMBLetter[letters.size()]));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        snowbnd.finalize();
        return o;
    }

    private ArrayList<CMBLetter> parseTextBlock(Snowbnd snowbnd, byte[] extractedText, int[] rcArray) throws UnsupportedEncodingException {
        int wordCount = 0;
        ArrayList<CMBLetter> list = new ArrayList<CMBLetter>();
        short left = 0;
        short bottom = 0;
        short width = 0;
        short height = 0;
        short pageWidth = 0;
        short pageHeight = 0;
        CMBLetter prevLetter = null;
        String s = new String(extractedText);
        StringTokenizer st = new StringTokenizer(s, "\n", false);
        while (st.hasMoreTokens()) {
            String sPage;
            String tok = st.nextToken();
            if (tok.startsWith("/Xpos")) {
                String xpos = tok.substring(6, tok.length());
                left = new Float(xpos).shortValue();
            }
            if (tok.startsWith("/Ypos")) {
                String ypos = tok.substring(6, tok.length());
                bottom = new Float(ypos).shortValue();
            }
            if (tok.startsWith("/Xsize")) {
                String xsize = tok.substring(6, tok.length());
                width = new Float(xsize).shortValue();
            }
            if (tok.startsWith("/Ysize")) {
                String ysize = tok.substring(6, tok.length());
                height = new Float(ysize).shortValue();
            }
            if (tok.startsWith("/PageWidth")) {
                sPage = tok.substring(10, tok.length());
                pageWidth = new Float(sPage).shortValue();
            }
            if (tok.startsWith("/PageHeight")) {
                sPage = tok.substring(11, tok.length());
                pageHeight = new Float(sPage).shortValue();
            }
            if (tok.startsWith("/Xdpi")) {
                sPage = tok.substring(5, tok.length());
                float xdpi = new Float(sPage).shortValue();
            }
            double adjustdpi = 816.0 / (double)pageWidth;
            if (!tok.startsWith("%%SOT")) continue;
            String word = st.nextToken();
            int l = (int)((double)left * adjustdpi);
            int b = (int)((double)bottom * adjustdpi);
            int w = (int)((double)width * adjustdpi);
            int h = (int)((double)height * adjustdpi);
            left = (short)l;
            bottom = (short)b;
            width = (short)w;
            height = (short)h;
            short top = (short)(bottom - height);
            if (prevLetter != null) {
                TagLetter tl;
                short newWidth;
                short newLeft;
                if (bottom == prevLetter.getBaseline()) {
                    newLeft = (short)(prevLetter.getLeft() + prevLetter.getWidth() + 1);
                    newWidth = (short)(left - newLeft);
                    if (newWidth > 0) {
                        tl = new TagLetter(newLeft, top, newWidth, height, bottom, height, ' ');
                        list.add(tl);
                    }
                } else {
                    newLeft = (short)(prevLetter.getLeft() + prevLetter.getWidth() + 1);
                    newWidth = 1;
                    tl = new TagLetter(newLeft, prevLetter.getTop(), newWidth, height, prevLetter.getBaseline(), height, ' ');
                    list.add(tl);
                }
            }
            for (int i = 0; i < word.length(); ++i) {
                TagLetter tl = new TagLetter(left, top, width, height, bottom, height, word.charAt(i));
                list.add(tl);
                prevLetter = tl;
            }
            ++wordCount;
        }
        return list;
    }

    @Override
    public boolean find(Object hDocument, String text, int[] position, boolean matchCase, boolean reverse) {
        SnowDocument document = (SnowDocument)hDocument;
        int pageNo = position[0];
        int hitNo = position[1];
        if (!reverse) {
            if (pageNo == 0) {
                pageNo = 1;
                hitNo = 0;
            }
            while (pageNo <= document.pageCount) {
                Snowbnd snowbnd = this.newSnowbnd(document.mimeType);
                DataInputStream dataStream = new DataInputStream(document.parts[0].data.getInputStream());
                int[] buflenArray = new int[1];
                int[] rcArray = new int[1];
                byte[] buf = snowbnd.IMGLOW_extract_text(dataStream, buflenArray, rcArray, pageNo - 1);
                if (rcArray[0] != 0) {
                    System.err.println(this.getMessageForSnowRC(rcArray[0]));
                    return false;
                }
                SNBD_SEARCH_RESULT[] result = snowbnd.IMGLOW_search_text(buf, text, matchCase ? 1 : 0, rcArray);
                snowbnd.finalize();
                if (result != null && result.length > hitNo) {
                    position[0] = pageNo;
                    position[1] = hitNo + 1;
                    IMG_RECT[] rect = result[hitNo].rc;
                    position[2] = rect[0].left;
                    position[3] = rect[0].top;
                    position[4] = rect[0].right - position[2];
                    position[5] = rect[0].bottom - position[3];
                    if (document.mimeType.equals("application/pdf")) {
                        double adjustdpi = 96.0 / (double)PDF_DPI;
                        position[2] = (int)((double)position[2] * adjustdpi);
                        position[3] = (int)((double)position[3] * adjustdpi);
                        position[4] = (int)((double)position[4] * adjustdpi);
                        position[5] = (int)((double)position[5] * adjustdpi);
                    }
                    return true;
                }
                hitNo = 0;
                ++pageNo;
            }
        } else {
            if (pageNo == 0) {
                pageNo = document.pageCount;
                hitNo = 0;
            } else if (hitNo == 1) {
                --pageNo;
            }
            boolean hitFound = false;
            while (pageNo > 0) {
                Snowbnd snowbnd = this.newSnowbnd(document.mimeType);
                DataInputStream dataStream = new DataInputStream(document.parts[0].data.getInputStream());
                int[] buflenArray = new int[1];
                int[] rcArray = new int[1];
                byte[] buf = snowbnd.IMGLOW_extract_text(dataStream, buflenArray, rcArray, pageNo - 1);
                if (rcArray[0] != 0) {
                    System.err.println(this.getMessageForSnowRC(rcArray[0]));
                    return false;
                }
                SNBD_SEARCH_RESULT[] result = snowbnd.IMGLOW_search_text(buf, text, matchCase ? 1 : 0, rcArray);
                snowbnd.finalize();
                if (result != null && (hitNo > 1 || result.length > 0)) {
                    position[0] = pageNo;
                    if (hitNo <= 1) {
                        hitNo = result.length;
                    }
                    position[1] = --hitNo;
                    IMG_RECT[] rect = result[hitNo - 1].rc;
                    position[2] = rect[0].left;
                    position[3] = rect[0].top;
                    position[4] = rect[0].right - position[2];
                    position[5] = rect[0].bottom - position[3];
                    if (document.mimeType.equals("application/pdf")) {
                        double adjustdpi = 96.0 / (double)PDF_DPI;
                        position[2] = (int)((double)position[2] * adjustdpi);
                        position[3] = (int)((double)position[3] * adjustdpi);
                        position[4] = (int)((double)position[4] * adjustdpi);
                        position[5] = (int)((double)position[5] * adjustdpi);
                    }
                    return true;
                }
                hitNo = 0;
                --pageNo;
            }
        }
        return false;
    }

    public String toString() {
        return super.toString() + " {" + "properties: " + this.properties + " initialized: " + this.initialized + " useMemory: " + this.useMemory + " annotationServices: " + this.annotationServices + " drawPageSnowbnd: " + drawPageSnowbnd + " drawPageAdjustFactor: " + drawPageAdjustFactor + " lastDrawnPart: " + lastDrawnPart + " lastDrawnPageNumber: " + lastDrawnPageNumber + " lastDrawnPageInverted: " + lastDrawnPageInverted + " userDrawPage: " + this.useDrawPage + "}";
    }

    private void ditherToBinary(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rgbArray = new int[width];
        for (int y = 0; y < height; ++y) {
            image.getRGB(0, y, width, 1, rgbArray, 0, width);
            for (int x = 0; x < width; ++x) {
                int rgb = rgbArray[x];
                int avg = (((rgb & 0xFF0000) >> 16) + ((rgb & 0xFF00) >> 8) + (rgb & 0xFF)) / 3;
                int dither = ditherWeight[x % 4][y % 4] < avg ? 255 : 0;
                rgbArray[x] = rgb = dither << 16 | dither << 8 | dither;
            }
            image.setRGB(0, y, width, 1, rgbArray, 0, width);
        }
    }

    @Override
    public boolean canShowAnnotations(Object document, String destMimeType) {
        return true;
    }

    static {
        ditherWeight = new int[][]{{16, 144, 48, 176}, {208, 80, 240, 112}, {64, 192, 32, 160}, {248, 128, 224, 96}};
    }

    private class AnnotationServicesCallbacks
    extends CMBAnnotationServicesCallbacks {
        private AnnotationServicesCallbacks() {
        }

        public int addAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData) throws CMBAnnotationEngineException {
            return 0;
        }

        public InputStream getAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
            return null;
        }

        public boolean getPrivilege(CMBAnnotationSet annotationSet, int privilegeID) throws CMBAnnotationEngineException {
            return true;
        }

        public void removeAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
        }

        public void trace(String message) {
        }

        public boolean traceEnabled() {
            return false;
        }

        public void updateAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData, int annotationNumber) throws CMBAnnotationEngineException {
        }
    }

    public static class TagLetter
    extends CMBLetter {
        public TagLetter() {
        }

        public TagLetter(short left, short top, short width, short height, short baseline, short capheight, char code) {
            this.setLeft(left);
            this.setTop(top);
            this.setWidth(width);
            this.setHeight(height);
            this.setBaseline(baseline);
            this.setCapheight(capheight);
            this.setCode(code);
        }
    }

    private class SnowPage
    implements Cloneable {
        SnowDocument document;
        boolean validated;
        boolean valid;
        int originalPageNumber;
        int widthPixels;
        int heightPixels;
        int xResolution;
        int yResolution;
        int bitsPerPixel;
        int resolutionUnit;
        int permanentRotation;
        ArrayList redactions = new ArrayList();

        private SnowPage() {
        }

        public SnowPart getPart() {
            if (this.document.parts.length == 1) {
                return this.document.parts[0];
            }
            int pageCountSoFar = 0;
            for (int i = 0; i < this.document.parts.length; ++i) {
                if (this.originalPageNumber > (pageCountSoFar += this.document.parts[i].getPageCount())) continue;
                return this.document.parts[i];
            }
            return null;
        }

        public byte[] getData() throws IOException {
            Snowbnd snowObject = CMBSnowboundEngine.this.newSnowbnd(this.document.mimeType);
            DataInputStream dataStream = new DataInputStream(this.getPart().getData().getInputStream());
            int[] error = new int[]{0};
            int pageIndex = this.originalPageNumber - 1;
            byte[] extractedPage = snowObject.IMGLOW_extract_page(dataStream, pageIndex, error);
            File tempFile = File.createTempFile("cmbviewpage", ".pdf");
            CMBSnowboundEngine.saveFileBytes(extractedPage, tempFile);
            return extractedPage;
        }

        public int getPartPageNumber() {
            if (this.document.parts.length == 1) {
                return this.originalPageNumber;
            }
            int pageCountSoFar = 0;
            for (int i = 0; i < this.document.parts.length; ++i) {
                int partPageCount = this.document.parts[i].getPageCount();
                if (this.originalPageNumber <= pageCountSoFar + partPageCount) {
                    return this.originalPageNumber - pageCountSoFar;
                }
                pageCountSoFar += partPageCount;
            }
            return this.originalPageNumber - pageCountSoFar;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public String toString() {
            return super.toString() + " {" + "validated: " + this.validated + " valid: " + this.valid + " originalPageNumber: " + this.originalPageNumber + "widthPixelse: " + this.widthPixels + "heightPixels: " + this.heightPixels + "xResolution: " + this.xResolution + "yResolution: " + this.yResolution + "bitsPerPixel: " + this.bitsPerPixel + "permanentRotation: " + this.permanentRotation + "redactions: " + this.redactions + "}";
        }
    }

    private class SnowPart {
        SnowDocument document;
        int partNumber;
        private Object partContent;
        private int partSize;
        private String partMimeType;
        private String partEncoding;
        private PDataAccessInterface data;
        private int pageCount;

        public SnowPart(SnowDocument document, int partNumber, Object partContent, int partSize, String partMimeType, String partEncoding) {
            this.document = document;
            this.partNumber = partNumber;
            this.partContent = partContent;
            this.partSize = partSize;
            this.partMimeType = partMimeType;
            this.partEncoding = partEncoding;
        }

        public int getPageCount() {
            if (this.pageCount == 0) {
                this.pageCount = CMBSnowboundEngine.this.callbacks.getPartPageCount(this.document, this.partNumber);
                if (this.pageCount == 0) {
                    DataInputStream dataStream = new DataInputStream(this.getData().getInputStream());
                    Snowbnd snowbnd = CMBSnowboundEngine.this.newSnowbnd(this.partMimeType);
                    int rc = snowbnd.IMGLOW_get_pages(dataStream);
                    if (rc < 0) {
                        if (CMBSnowboundEngine.this.isOutOfMemoryRC(rc)) {
                            throw new OutOfMemoryError(CMBSnowboundEngine.this.getMessageForSnowRC(rc));
                        }
                        throw new CMBDocumentEngineException(CMBSnowboundEngine.this.getMessageForSnowRC(rc));
                    }
                    this.pageCount = rc;
                    snowbnd.finalize();
                }
            }
            return this.pageCount;
        }

        public synchronized PDataAccessInterface getData() {
            if (this.data == null) {
                try {
                    if (this.partContent == null) {
                        StringBuffer partMimeTypeBuffer = new StringBuffer();
                        this.partContent = CMBSnowboundEngine.this.callbacks.getPart(this.document, this.partNumber, partMimeTypeBuffer);
                        this.partSize = CMBSnowboundEngine.this.callbacks.getPartSize(this.document, this.partNumber);
                        this.partMimeType = partMimeTypeBuffer.toString();
                        this.partEncoding = CMBSnowboundEngine.this.callbacks.getPartEncoding(this.document, this.partNumber);
                    }
                    if (this.partMimeType.equals("text/plain")) {
                        String partText;
                        if (this.partEncoding == null) {
                            partText = new String(this.getContentBytes(this.partContent));
                            byte[] partTextBytes = partText.getBytes("UTF-8");
                            this.partContent = new ByteArrayInputStream(partTextBytes);
                            this.partSize = partTextBytes.length;
                        } else if (!this.partEncoding.equals("UTF-8")) {
                            byte[] streamBytes = this.getContentBytes(this.partContent);
                            if (streamBytes.length > 3 && streamBytes[0] == -17 && streamBytes[1] == -69 && streamBytes[2] == -65) {
                                this.partEncoding = "UTF-8";
                            }
                            partText = new String(streamBytes, this.partEncoding);
                            byte[] partTextBytes = partText.getBytes("UTF-8");
                            this.partContent = new ByteArrayInputStream(partTextBytes);
                            this.partSize = partTextBytes.length;
                        }
                    }
                    if (this.partContent instanceof URL) {
                        this.data = new PHttpContentAccess((URL)this.partContent, this.partSize);
                    } else {
                        InputStream partStream = (InputStream)this.partContent;
                        if (this.partSize <= 0) {
                            this.data = new PSimpleStreamAccess(partStream);
                            this.partSize = ((PSimpleStreamAccess)this.data).getSize();
                        } else {
                            CMBSnowboundEngine.this.useMemory = Boolean.valueOf(CMBSnowboundEngine.this.properties.getProperty(CMBSnowboundEngine.USE_MEMORY_PROPERTY, "false"));
                            this.data = new PFastStreamAccess(partStream, this.partSize, CMBSnowboundEngine.this.useMemory);
                        }
                    }
                }
                catch (IOException e) {
                    throw new CMBDocumentEngineException(PViewerUtilities.getMessage("DocumentEngine.errorReadingPart"), (Object)e);
                }
            }
            return this.data;
        }

        public String getMimeType() {
            return this.partMimeType;
        }

        public String toString() {
            return super.toString() + " {" + "partNumber: " + this.partNumber + " partContent: " + this.partContent + " partStreamSize: " + this.partSize + " partMimeType: " + this.partMimeType + " partEncoding: " + this.partEncoding + " data: " + this.data + " pageCount: " + this.pageCount + "}";
        }

        private byte[] getContentBytes(Object inputContent) throws IOException {
            InputStream inputStream = inputContent instanceof URL ? ((URL)inputContent).openStream() : (InputStream)inputContent;
            BufferedInputStream instream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream outstream = new ByteArrayOutputStream(Math.max(instream.available(), 0x100000));
            int c = 0;
            while (c != -1) {
                int len = instream.available();
                byte[] bytes = new byte[len];
                instream.read(bytes);
                outstream.write(bytes);
                c = instream.read();
                if (c == -1) continue;
                outstream.write(c);
            }
            inputStream.close();
            return outstream.toByteArray();
        }
    }

    private class SnowDocument {
        String mimeType;
        CMBAnnotationSet annotationSet;
        int pageCount;
        Object pageCountLock = new Object();
        SnowPart[] parts;
        Hashtable loadedPages = new Hashtable();
        boolean allPagesLoaded;
        int lastDrawnPage;
        Snowbnd lastDrawnPageSnowbnd;

        private SnowDocument() {
        }

        public String toString() {
            return super.toString() + " {" + "mimeType: " + this.mimeType + " annotationSet: " + this.annotationSet + " pageCount: " + this.pageCount + " parts: " + this.parts + " allPagesLoaded: " + this.allPagesLoaded + " lastDrawnPage: " + this.lastDrawnPage + " lastDrawnPageSnowbnd: " + this.lastDrawnPageSnowbnd + "}";
        }
    }
}

