/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBPreferenceSet;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class CMBPreferenceSetView
extends JPanel {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private JButton applyButton = null;
    private JButton restoreButton = null;
    protected JPanel buttonPanel = new JPanel();
    public static final long NO_BUTTONS = 0L;
    public static final long APPLY_BUTTON = 1L;
    public static final long RESTORE_BUTTON = 2L;
    public static final String APPLY_COMMAND = "Apply";
    public static final String RESTORE_COMMAND = "Restore";
    private PPreferenceSetController controller = null;

    public CMBPreferenceSetView(CMBPreferenceSet model) {
        this(model, 0L);
    }

    public CMBPreferenceSetView(CMBPreferenceSet model, long buttonFlags) {
        this.controller = new PPreferenceSetController(model, this);
        this.setLayout(new BorderLayout());
        if (buttonFlags != 0L) {
            this.add((Component)this.makeButtonPanel(buttonFlags), "After");
        }
    }

    public void setCenterPanel(JPanel panel) {
        this.add((Component)panel, "Center");
    }

    private JPanel makeButtonPanel(long buttonFlags) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(3));
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(0, 1, 5, 5));
        if ((buttonFlags & 2L) != 0L) {
            p1.add(this.getRestoreButton());
        }
        if ((buttonFlags & 1L) != 0L) {
            p1.add(this.getApplyButton());
        }
        panel.add(p1);
        return panel;
    }

    private JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton(PViewerUtilities.getMessage("preference.button.PreferenceSetApply"));
            this.applyButton.setMnemonic(PViewerUtilities.getMessage("preference.button.PreferenceSetApply.mnemonic").charAt(0));
            this.applyButton.setActionCommand(APPLY_COMMAND);
            this.applyButton.addActionListener(this.controller);
        }
        return this.applyButton;
    }

    private JButton getRestoreButton() {
        if (this.restoreButton == null) {
            this.restoreButton = new JButton(PViewerUtilities.getMessage("preference.button.PreferenceSetRestore"));
            this.restoreButton.setMnemonic(PViewerUtilities.getMessage("preference.button.PreferenceSetRestore.mnemonic").charAt(0));
            this.restoreButton.setActionCommand(RESTORE_COMMAND);
            this.restoreButton.addActionListener(this.controller);
        }
        return this.restoreButton;
    }

    private class PPreferenceSetController
    implements ActionListener {
        private CMBPreferenceSet model = null;
        private CMBPreferenceSetView view = null;

        PPreferenceSetController(CMBPreferenceSet m, CMBPreferenceSetView v) {
            this.model = m;
            this.view = v;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == CMBPreferenceSetView.APPLY_COMMAND) {
                this.model.applyAction();
                this.model.viewer.updateUserPreferencesFromPreferenceSet(this.model);
            } else if (e.getActionCommand() == CMBPreferenceSetView.RESTORE_COMMAND) {
                this.model.restoreDefaultsAction();
            }
        }
    }
}

