/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.PViewerUtilities;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CMBPageWriterServlet
extends HttpServlet {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block7: {
            String methodName = "processRequest";
            ServletOutputStream outStream = null;
            try {
                outStream = response.getOutputStream();
                CMBPage page = (CMBPage)request.getAttribute("cmbPage");
                if (page == null) {
                    throw new Exception(PViewerUtilities.getMessage("WriterServlets.noCMBPage"));
                }
                String resourceId = (String)request.getAttribute("resourceId");
                if (resourceId == null) {
                    String mimeType = page.getWriteMimeType();
                    response.setContentType(mimeType);
                    String resourceUrl = (String)request.getAttribute("resourceUrl");
                    if (resourceUrl != null) {
                        page.write((OutputStream)outStream, resourceUrl);
                    } else {
                        page.write((OutputStream)outStream);
                    }
                } else {
                    response.setContentType(page.getResourceMimeType(resourceId));
                    page.writeResource((OutputStream)outStream, resourceId);
                }
                outStream.close();
            }
            catch (Throwable e) {
                ViewerLogger.logError((Object)this, methodName, e);
                if (outStream == null) break block7;
                outStream = response.getOutputStream();
                response.setContentType("text/plain");
                PrintStream ps = new PrintStream((OutputStream)outStream);
                outStream.write((PViewerUtilities.getMessage("WriterServlets.errorOccured") + "\r\n").getBytes());
                e.printStackTrace(ps);
                ps.close();
            }
        }
    }
}

