/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBLetters;
import com.ibm.mm.viewer.CMBOCRLetters;
import com.ibm.mm.viewer.CMBStreamingDocServices;
import com.ibm.mm.viewer.CMBViewerConstants;
import com.ibm.mm.viewer.PBrightnessContrastFilter;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMBPage
implements CMBViewerConstants,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBStreamingDocServices _services;
    private CMBDocumentEngine _engine;
    private Object _hPage;
    private CMBDocument _document;
    private int _rotation = 0;
    private int _number;
    private int brightness = 100;
    private int contrast = 100;
    CMBOCRLetters ocrLetters = null;
    CMBLetters letters = null;
    Pattern findPattern = null;
    List<MatchResult> matchResults = null;
    int hitIndex = -1;
    int letterIndex = -1;

    CMBPage(CMBStreamingDocServices services, CMBDocumentEngine engine, CMBDocument document, int number) {
        this._services = services;
        this._engine = engine;
        this._document = document;
        this._hPage = null;
        this._number = number;
    }

    public CMBDocument getDocument() {
        this._validateDocument();
        return this._document;
    }

    public int getRotation() {
        this._validateDocument();
        return this._rotation;
    }

    public void setRotation(int rotation) {
        this._validateDocument();
        if (rotation < 0 || rotation > 3) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("Page.invalidRotation"));
        }
        if (!this._document.getCanRotate()) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("Page.cannotBeRotated"));
        }
        this._rotation = rotation;
    }

    public int getPageNumber() {
        this._validateDocument();
        return this._number;
    }

    public double getWidth() {
        this._validateDocument();
        try {
            this._services.setLastDocument(this._document);
            double wd = this._engine.getPageWidth(this.getPageHandle());
            if (this._services.traceEnabled()) {
                this._services.trace("Engine getPageWidth  returned:" + wd);
            }
            return wd;
        }
        catch (IOException e) {
            return 0.0;
        }
    }

    public boolean isValid() {
        this._validateDocument();
        try {
            this._services.setLastDocument(this._document);
            boolean v = this._engine.isPageValid(this.getPageHandle());
            if (this._services.traceEnabled()) {
                this._services.trace("Engine isValidPage returned:" + v);
            }
            return v;
        }
        catch (Exception e) {
            return false;
        }
    }

    public double getHeight() {
        this._validateDocument();
        try {
            this._services.setLastDocument(this._document);
            double ht = this._engine.getPageHeight(this.getPageHandle());
            if (this._services.traceEnabled()) {
                this._services.trace("Engine getPageHeight  returned:" + ht);
            }
            return ht;
        }
        catch (IOException e) {
            return 0.0;
        }
    }

    public int getPageXResolution() {
        this._validateDocument();
        try {
            this._services.setLastDocument(this._document);
            int res = this._engine.getPageXResolution(this.getPageHandle());
            if (this._services.traceEnabled()) {
                this._services.trace("Engine getPageXResolution returned :" + res);
            }
            if (res <= 0) {
                res = 96;
            }
            return res;
        }
        catch (IOException e) {
            return 96;
        }
    }

    public int getPageYResolution() {
        this._validateDocument();
        try {
            this._services.setLastDocument(this._document);
            int res = this._engine.getPageYResolution(this.getPageHandle());
            if (this._services.traceEnabled()) {
                this._services.trace("Engine getPageYResolution returned :" + res);
            }
            if (res <= 0) {
                res = 96;
            }
            return res;
        }
        catch (IOException e) {
            return 96;
        }
    }

    public CMBLetters extractText() {
        this._validateDocument();
        try {
            this._services.setLastDocument(this._document);
            CMBLetters letters = this._engine.extractText(this.getPageHandle());
            if (this._services.traceEnabled()) {
                this._services.trace("page: " + this._number + " extractText :" + letters);
            }
            this.letters = letters;
            return letters;
        }
        catch (IOException e) {
            return null;
        }
    }

    int getPageResolution() {
        return Math.max(this.getPageXResolution(), this.getPageYResolution());
    }

    public double getMinScale() {
        try {
            this._services.setLastDocument(this._document);
            double minScale = this._engine.getPageMinScale(this.getPageHandle(), this.getWriteMimeType());
            if (this._services.traceEnabled()) {
                this._services.trace("Engine getPageMinScale returned:" + minScale);
            }
            return this.getCorrectedScale(minScale);
        }
        catch (IOException e) {
            return 1.0;
        }
    }

    public double getMaxScale() {
        try {
            this._services.setLastDocument(this._document);
            double maxScale = this._engine.getPageMaxScale(this.getPageHandle(), this.getWriteMimeType());
            if (this._services.traceEnabled()) {
                this._services.trace("Engine getPageMaxScale returned :" + maxScale);
            }
            return this.getCorrectedScale(maxScale);
        }
        catch (IOException e) {
            return 1.0;
        }
    }

    public double getScale() {
        double scale = this._document.getPreferredScale();
        double minScale = this.getMinScale();
        double maxScale = this.getMaxScale();
        if (scale < minScale) {
            scale = minScale;
        }
        if (scale > maxScale) {
            scale = maxScale;
        }
        if (this._services.traceEnabled()) {
            this._services.trace("MaxScale:" + maxScale + " MinScale:" + minScale + " page scale:" + scale);
        }
        return scale;
    }

    public boolean getCanEnhance() throws CMBDocumentEngineException, IOException {
        boolean canEnhance = false;
        if (this.getDocument().getCanEnhance()) {
            this._services.setLastDocument(this._document);
            canEnhance = this._engine.canEnhancePage(this.getPageHandle(), this.getWriteMimeType());
        }
        return canEnhance;
    }

    public boolean getCanGetImage() {
        this._services.setLastDocument(this._document);
        boolean b = this._engine.canProvidePageImage(this._document.getMimeType());
        if (this._services.traceEnabled()) {
            this._services.trace("Engine canProvidePageImage(" + this._document.getMimeType() + ") returned:" + b);
        }
        return b;
    }

    public Image getImage() throws CMBDocumentEngineException, IOException {
        Image image;
        if (!this.getCanGetImage()) {
            throw new RuntimeException(PViewerUtilities.getMessage("Page.cannotGetJavaImage"));
        }
        this._services.setLastDocument(this._document);
        long start = 0L;
        long end = 0L;
        if (this._services.traceEnabled()) {
            this._services.trace("Engine getPageImage() called with arguments:  page handle:" + this.getPageHandle() + " combinedRotation:" + this.combinedRotation() + " scale:" + this.getScaleFromResolution() + " enhance:" + this._document.getEnhance() + " invert:" + this._document.getInvert() + " showAnnotations:" + this._document.getShowAnnotations());
            start = System.currentTimeMillis();
        }
        if (this._engine.canBalancePage(this.getPageHandle())) {
            image = this._engine.getPageImage(this.getPageHandle(), this.combinedRotation(), this.getScaleFromResolution(), this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations(), this.getContrast(), this.getBrightness());
        } else {
            image = this._engine.getPageImage(this.getPageHandle(), this.combinedRotation(), this.getScaleFromResolution(), this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations());
            if (this.brightness != 100 || this.contrast != 100) {
                PBrightnessContrastFilter bcFilter = new PBrightnessContrastFilter(this.brightness, this.contrast);
                image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), bcFilter));
            }
        }
        if (this._services.traceEnabled()) {
            end = System.currentTimeMillis();
            this._services.trace("Time taken for engine.getPageImage() is " + new Long(end - start));
        }
        return image;
    }

    public Image getImage(double scale) throws CMBDocumentEngineException, IOException {
        return this.getImage(scale, true);
    }

    Image getImage(double scale, boolean applyBalance) throws CMBDocumentEngineException, IOException {
        Image image;
        if (!this.getCanGetImage()) {
            throw new RuntimeException(PViewerUtilities.getMessage("Page.cannotGetJavaImage"));
        }
        long start = 0L;
        long end = 0L;
        this._services.setLastDocument(this._document);
        if (this._services.traceEnabled()) {
            this._services.trace("getImage(scale):  page handle:" + this.getPageHandle() + " combinedRotation:" + this.combinedRotation() + " scale:" + scale + " enhance:" + this._document.getEnhance() + " invert:" + this._document.getInvert() + " showAnnotations:" + this._document.getShowAnnotations());
            start = System.currentTimeMillis();
        }
        if (this._engine.canBalancePage(this.getPageHandle())) {
            image = applyBalance ? this._engine.getPageImage(this.getPageHandle(), this.combinedRotation(), scale, this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations(), this.contrast, this.brightness) : this._engine.getPageImage(this.getPageHandle(), this.combinedRotation(), scale, this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations(), 100, 100);
        } else {
            image = this._engine.getPageImage(this.getPageHandle(), this.combinedRotation(), scale, this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations());
            if (applyBalance && (this.brightness != 100 || this.contrast != 100)) {
                PBrightnessContrastFilter bcFilter = new PBrightnessContrastFilter(this.brightness, this.contrast);
                image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), bcFilter));
            }
        }
        if (this._services.traceEnabled()) {
            end = System.currentTimeMillis();
            this._services.trace("Time taken for engine.getPageImage(scale) is " + new Long(end - start));
        }
        return image;
    }

    public boolean getUseDraw() throws CMBDocumentEngineException, IOException {
        boolean useDrawPage = this._engine.useDrawPage(this.getPageHandle(), this.combinedRotation(), this.getScaleFromResolution(), this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations(), this.contrast, this.brightness);
        return useDrawPage;
    }

    public void draw(Graphics2D graphics) throws CMBDocumentEngineException, IOException {
        this._engine.drawPage(this.getPageHandle(), this.combinedRotation(), this.getScaleFromResolution(), this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations(), this.contrast, this.brightness, graphics);
    }

    void draw(double scale, Graphics2D graphics) throws CMBDocumentEngineException, IOException {
        this._engine.drawPage(this.getPageHandle(), this.combinedRotation(), scale * (double)this._document.getDisplayResolution() / (double)Math.max(this.getPageXResolution(), this.getPageYResolution()), this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations(), this.contrast, this.brightness, graphics);
    }

    public boolean getCanWrite() {
        return this.getWriteMimeType() != null;
    }

    public String getWriteMimeType() {
        String methodName = "getWriteMimeType";
        this._validateDocument();
        try {
            this._services.setLastDocument(this._document);
            String[] preferences = this._services.getPreferredPageFormats();
            String preference = this._engine.getPageMimeType(this.getPageHandle(), preferences);
            if (preference != null) {
                if (this._services.traceEnabled()) {
                    this._services.trace("Engine's preferred write mime type for this page:" + preference);
                }
                return preference;
            }
            String docMimeType = this._document.getPageWriteMimeType();
            if (this._services.traceEnabled()) {
                this._services.trace("Document's preferred write mime type for this page:" + docMimeType);
            }
            return docMimeType;
        }
        catch (IOException ioe) {
            ViewerLogger.logError((Object)this, methodName, ioe);
            return null;
        }
    }

    public void write(OutputStream outStream) throws CMBDocumentEngineException, IOException {
        long start = 0L;
        long end = 0L;
        String mimeType = this.getWriteMimeType();
        if (mimeType == null) {
            throw new RuntimeException(PViewerUtilities.getMessage("Page.cannotBeWritten"));
        }
        this._services.setLastDocument(this._document);
        if (this._services.traceEnabled()) {
            this._services.trace("Engine's writePage() called with arguments: page handle:" + this.getPageHandle() + " combinedRotation:" + this.combinedRotation() + " scale:" + this.getScaleFromResolution() + " enhance:" + this._document.getEnhance() + " invert:" + this._document.getInvert() + " showAnnotations:" + this._document.getShowAnnotations() + " outStream:" + outStream + " mimeType:" + mimeType);
            start = System.currentTimeMillis();
        }
        if (this._engine.canBalancePage(this.getPageHandle())) {
            this._engine.writePage(this.getPageHandle(), this.combinedRotation(), this.getScaleFromResolution(), this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations(), this.getContrast(), this.getBrightness(), outStream, mimeType);
        } else {
            this._engine.writePage(this.getPageHandle(), this.combinedRotation(), this.getScaleFromResolution(), this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations(), outStream, mimeType);
        }
        if (this._services.traceEnabled()) {
            end = System.currentTimeMillis();
            this._services.trace("Time taken for engine.writePage() is " + new Long(end - start));
        }
    }

    public void write(OutputStream outStream, String resourcePrefix) throws CMBDocumentEngineException, IOException {
        String mimeType = this.getWriteMimeType();
        long start = 0L;
        long end = 0L;
        if (mimeType == null) {
            throw new RuntimeException(PViewerUtilities.getMessage("Page.cannotBeWritten"));
        }
        this._services.setLastDocument(this._document);
        if (this._services.traceEnabled()) {
            this._services.trace("Engine's writePage() called with arguments: page handle:" + this.getPageHandle() + " combinedRotation:" + this.combinedRotation() + " scale:" + this.getScaleFromResolution() + " enhance:" + this._document.getEnhance() + " invert:" + this._document.getInvert() + " showAnnotations:" + this._document.getShowAnnotations() + " outStream:" + outStream + " mimeType:" + mimeType + " resourcePrefix:" + resourcePrefix);
            start = System.currentTimeMillis();
        }
        this._engine.writePage(this.getPageHandle(), this.combinedRotation(), this.getScaleFromResolution(), this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations(), outStream, mimeType, resourcePrefix);
        if (this._services.traceEnabled()) {
            end = System.currentTimeMillis();
            this._services.trace("Time taken for engine.writePage() is " + new Long(end - start));
        }
    }

    public String getResourceMimeType(String resourceId) throws IOException {
        this._validateDocument();
        this._services.setLastDocument(this._document);
        return this._engine.getPageResourceMimeType(this.getPageHandle(), resourceId);
    }

    public void writeResource(OutputStream outStream, String resourceId) throws CMBDocumentEngineException, IOException {
        this._validateDocument();
        this._services.setLastDocument(this._document);
        if (this._services.traceEnabled()) {
            this._services.trace("Engine's writePageResource() called with arguments: page handle:" + this.getPageHandle() + " combinedRotation:" + this.combinedRotation() + " scale:" + this.getScaleFromResolution() + " enhance:" + this._document.getEnhance() + " invert:" + this._document.getInvert() + " showAnnotations:" + this._document.getShowAnnotations() + " outStream:" + outStream);
        }
        this._engine.writePageResource(this.getPageHandle(), resourceId, this.combinedRotation(), this.getScaleFromResolution(), this._document.getEnhance(), this._document.getInvert(), this._document.getShowAnnotations(), outStream);
    }

    public synchronized void dispose() {
        this._validateDocument();
        if (this._hPage != null) {
            this._services.setLastDocument(this._document);
            this._engine.dropPage(this._hPage);
            this._hPage = null;
        }
    }

    public void rotate(int rotation) throws IOException {
        this._validateDocument();
        this._services.setLastDocument(this._document);
        this._engine.rotatePage(this.getPageHandle(), rotation);
        this._document.setModified(true);
    }

    public boolean getCanCrop() throws IOException {
        this._validateDocument();
        this._services.setLastDocument(this._document);
        return this._engine.canCropPage(this.getPageHandle());
    }

    public void crop(Rectangle cropRect) throws IOException {
        this._validateDocument();
        this._services.setLastDocument(this._document);
        this._engine.cropPage(this.getPageHandle(), cropRect);
        this._document.setModified(true);
    }

    boolean getCanRedact() throws IOException {
        this._validateDocument();
        this._services.setLastDocument(this._document);
        return this._engine.canRedactPage(this.getPageHandle());
    }

    public void redact(Rectangle redactRect) throws IOException {
        this._validateDocument();
        this._services.setLastDocument(this._document);
        this._engine.redactPage(this.getPageHandle(), redactRect);
        this._document.setModified(true);
    }

    public boolean getCanBalance() throws IOException {
        this._validateDocument();
        this._services.setLastDocument(this._document);
        return this._engine.canBalancePage(this.getPageHandle());
    }

    public int getContrast() {
        return this.contrast;
    }

    public void setContrast(int contrastFactor) {
        this._validateDocument();
        this.contrast = contrastFactor;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setBrightness(int brightnessFactor) {
        this._validateDocument();
        this.brightness = brightnessFactor;
    }

    public String toString() {
        return super.toString() + " {" + "hPage: " + this._hPage + " rotation: " + this._rotation + " number: " + this._number + " brightness: " + this.brightness + " contrast: " + this.contrast + "}";
    }

    void setPageNumber(int number) {
        this._number = number;
    }

    void setDocument(CMBDocument document) {
        this._document = document;
        if (this._document == null) {
            this._hPage = null;
        }
    }

    CMBDocumentEngine getEngine() {
        return this._engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPageHandle() throws IOException {
        this._validateDocument();
        if (this._hPage == null) {
            Object object = this._document.documentDropping;
            synchronized (object) {
                Object hDocument = this._document.getDocumentHandle();
                if (hDocument == null) {
                    throw new RuntimeException(PViewerUtilities.getMessage("Page.usedAfterDocumentDropped"));
                }
                this._services.setLastDocument(this._document);
                this._hPage = this._engine.loadPage(hDocument, this._number);
            }
            if (this._hPage == null) {
                throw new RuntimeException(PViewerUtilities.getMessage("Page.invalidPageHandle", new String[]{this._engine.getClass().getName()}));
            }
        }
        return this._hPage;
    }

    int combinedRotation() {
        return (this._document.getRotation() + this._rotation) % 4;
    }

    private double getScaleFromResolution() {
        double s = this.getScale() * (double)this._document.getDisplayResolution() / (double)Math.max(this.getPageXResolution(), this.getPageYResolution());
        return s;
    }

    private double getCorrectedScale(double s) {
        return s * (double)this.getPageXResolution() / (double)this._document.getDisplayResolution();
    }

    private void _validateDocument() {
        if (this._document == null) {
            throw new RuntimeException(PViewerUtilities.getMessage("Page.usedAfterDeleted"));
        }
        if (this._document.isDisposed()) {
            throw new RuntimeException(PViewerUtilities.getMessage("Page.usedAfterDocumentDropped"));
        }
    }

    public CMBLetters getLetters() {
        if (this.ocrLetters != null) {
            return this.ocrLetters;
        }
        return this.letters;
    }

    public CMBOCRLetters getOCRLetters() {
        return this.ocrLetters;
    }

    public boolean isSearchable() {
        boolean searchable = false;
        if (this.getOCRLetters() != null && this.getOCRLetters().getLetters() != null && this.getOCRLetters().getLetters().length > 0) {
            searchable = true;
        } else if (this.getLetters() != null && this.getLetters().getLetters() != null && this.getLetters().getLetters().length > 0) {
            searchable = true;
        }
        return searchable;
    }

    public int getConfidenceLevel() {
        int confidenceLevel = 0;
        if (this.getOCRLetters() != null && this.getOCRLetters().getLetters() != null) {
            boolean ocrConfident = this.getOCRLetters().isOcrConfident();
            confidenceLevel = ocrConfident ? 2 : 1;
        } else if (this.getLetters() != null && this.getLetters().getLetters() != null) {
            confidenceLevel = this.getLetters().getLetters().length > 0 ? 2 : 1;
        }
        return confidenceLevel;
    }

    public void disposeOCRLetters() {
        if (this.ocrLetters != null) {
            this.ocrLetters.disposeOCRLetters();
            this.ocrLetters = null;
        }
    }

    List<MatchResult> find(String regex, boolean matchCase) {
        String pagetext;
        if (this.getLetters() == null) {
            return null;
        }
        try {
            pagetext = this.getLetters().getSelectedText(0, this.getLetters().getLetters().length - 1);
        }
        catch (BadLocationException e) {
            return null;
        }
        Pattern p = matchCase ? Pattern.compile(regex) : Pattern.compile(regex, 2);
        Matcher m = p.matcher(pagetext);
        ArrayList<MatchResult> matchResults = new ArrayList<MatchResult>();
        while (m.find()) {
            matchResults.add(m.toMatchResult());
        }
        this.findPattern = p;
        this.matchResults = matchResults;
        return matchResults;
    }

    void clearFind() {
        this.matchResults = null;
        this.findPattern = null;
    }
}

