/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineCallbacks;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBViewerException;
import com.ibm.mm.viewer.PDataAccessInterface;
import com.ibm.mm.viewer.POutsideInDocViewer;
import com.ibm.mm.viewer.POutsideInFullSizeView;
import com.ibm.mm.viewer.POutsideInJNI;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationServicesCallbacks;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public final class CMBOutsideInViewerEngine
extends CMBDocumentEngine {
    private static final boolean USE_TEMP_FILE = true;
    private static final int DEFAULT_UNITS_PER_INCH = 1440;
    private static final double DEFAULT_PAGE_WIDTH = 8.5;
    private static final double DEFAULT_PAGE_HEIGHT = 11.0;
    private CMBDocumentEngineCallbacks callbacks;
    private Properties properties;
    private boolean initialized;
    private CMBAnnotationServices annotationServices;
    private POutsideInJNI outsideInJni;
    private long hModule;
    private HashMap<Long, OutsideInPart> hwndToPartMap;
    private static boolean wordproDocumentOpen;
    private boolean useDrawPage;
    private String platform = null;
    private static final boolean USE_FAST_STREAM = true;
    private Object numberOfPagesLock = new Object();

    public void initialize(CMBDocumentEngineCallbacks callbacks, Properties properties) {
        this.callbacks = callbacks;
        this.properties = properties;
        this.hwndToPartMap = new HashMap();
        this.platform = properties.getProperty("platform", null);
        this.useDrawPage = Boolean.valueOf(properties.getProperty("useDrawPage", "true"));
        this.annotationServices = new CMBAnnotationServices(new AnnotationServicesCallbacks(), properties);
        this.initialized = true;
        this.trace(null, null, "Initialized.  Outside In HMODULE = " + this.hModule);
    }

    public void terminate() {
        if (this.outsideInJni != null) {
            this.outsideInJni.terminate(this.hModule);
        }
        this.initialized = false;
        this.trace(null, null, "Terminated.");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean canLoadDocument(String mimeType) {
        String methodName = "canLoadDocument";
        ViewerLogger.logEntry(this, methodName);
        boolean canLoadDocument = true;
        if (mimeType.startsWith("audio") || mimeType.startsWith("video")) {
            canLoadDocument = false;
        }
        if (this.platform != null && !this.platform.equals("Win32") && !this.platform.equals("Win64")) {
            ViewerLogger.logDebug(this, methodName, "Unsupported platform: " + this.platform);
            canLoadDocument = false;
        }
        ViewerLogger.logExit(this, methodName);
        return canLoadDocument;
    }

    public Object loadDocument(InputStream contentStream, int nParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        return this.loadDocument(contentStream, -1, nParts, partMimeType, docMimeType, annotationStream, resourceStream);
    }

    public Object loadDocument(InputStream contentStream, int contentLength, int nParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        String methodName = "loadDocument";
        if (this.outsideInJni == null) {
            try {
                this.outsideInJni = new POutsideInJNI(this);
                String jarName = "cmboutsidein" + (this.platform != null ? this.platform : "") + ".jar";
                String dllPath = this.callbacks.deployNativeLibrary(jarName);
                if (dllPath == null) {
                    String cmbOutsideInDLL = (this.platform != null && this.platform.length() > 0 ? this.platform + File.separator : "") + "cmboutsideinjni";
                    ViewerLogger.logDebug(this, methodName, "Calling System.loadLibrary with " + cmbOutsideInDLL);
                    System.loadLibrary(cmbOutsideInDLL);
                } else {
                    String cmbOutsideInDLL = dllPath + "cmboutsideinjni.dll";
                    ViewerLogger.logDebug(this, methodName, "Calling System.load with " + cmbOutsideInDLL);
                    System.load(cmbOutsideInDLL);
                }
                this.hModule = this.outsideInJni.initialize(dllPath);
            }
            catch (Throwable t) {
                throw new CMBDocumentEngineException(PViewerUtilities.getMessage("StellentViewerEngine.initializationError"), (Object)t);
            }
            if (this.hModule == 0L) {
                throw new CMBDocumentEngineException(PViewerUtilities.getMessage("StellentViewerEngine.initializationError"));
            }
        }
        if (partMimeType.equals("application/vnd.lotus-wordpro")) {
            if (wordproDocumentOpen) {
                throw new CMBDocumentEngineException(PViewerUtilities.getMessage("StellentViewerEngine.multipleWordpro"));
            }
            wordproDocumentOpen = true;
        }
        OutsideInDocument document = new OutsideInDocument();
        document.parts = new OutsideInPart[nParts];
        document.mimeType = docMimeType;
        this.trace(document, null, "loadDocument invoked");
        this.loadPart(document, 0, contentStream, contentLength, partMimeType);
        if (annotationStream != null) {
            try {
                document.annotationSet = this.annotationServices.loadAnnotationSet(annotationStream, "application/vnd.ibm.modcap", this.getAnnotationPosition(document), 1, 1);
            }
            catch (Exception e) {
                throw new CMBDocumentEngineException("A problem occured parsing the annotations", (Object)e);
            }
            this.trace(document, null, "loadDocument: annotations loaded");
        }
        this.trace(document, null, "loadDocument completed.");
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPart(OutsideInDocument document, int partNumber, InputStream contentStream, int contentLength, String partMimetype) {
        String methodName = "loadPart";
        CMBOutsideInViewerEngine cMBOutsideInViewerEngine = this;
        synchronized (cMBOutsideInViewerEngine) {
            long rc;
            if (document.parts[partNumber] != null) {
                return;
            }
            OutsideInPart part = new OutsideInPart();
            part.document = document;
            part.contentLength = contentLength;
            OutsideInDispatchThread thread = new OutsideInDispatchThread(part);
            try {
                thread.setDaemon(true);
            }
            catch (SecurityException e) {
                // empty catch block
            }
            thread.start();
            try {
                OutsideInDispatchThread e = thread;
                synchronized (e) {
                    if (part.hWnd == 0L) {
                        thread.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.trace(document, null, "loadDocument: created stellent window");
            this.outsideInJni.setDWordOption(part.hWnd, 337785, 1170);
            this.outsideInJni.setDWordOption(part.hWnd, 337881, 3);
            this.outsideInJni.setDWordOption(part.hWnd, 338482, 28);
            if (partMimetype.equals("text/plain")) {
                int leftMargin = (int)(Float.parseFloat(this.properties.getProperty("leftMargin", "0.5")) * 1440.0f);
                int rightMargin = (int)(Float.parseFloat(this.properties.getProperty("rightMargin", "0.5")) * 1440.0f);
                int topMargin = (int)(Float.parseFloat(this.properties.getProperty("topMargin", "0.167")) * 1440.0f);
                int bottomMargin = (int)(Float.parseFloat(this.properties.getProperty("bottomMargin", "0.167")) * 1440.0f);
                String fontName = this.properties.getProperty("fontName", "Courier New");
                int fontSize = Integer.parseInt(this.properties.getProperty("fontSize", "23"));
                boolean bold = Boolean.valueOf(this.properties.getProperty("fontBold", "true"));
                boolean italic = Boolean.valueOf(this.properties.getProperty("fontItalic", "false"));
                if (fontName.equalsIgnoreCase("Monospaced")) {
                    fontName = "Courier New";
                } else if (fontName.equalsIgnoreCase("Serif")) {
                    fontName = "Times New Roman";
                } else if (fontName.equalsIgnoreCase("SansSerif")) {
                    fontName = "Arial";
                }
                this.outsideInJni.setMarginsOption(part.hWnd, 337782, topMargin, bottomMargin, leftMargin, rightMargin);
                int fontAttr = 0;
                if (italic) {
                    fontAttr += 2;
                }
                if (bold) {
                    fontAttr += 4;
                }
                this.outsideInJni.setFontOption(part.hWnd, 337780, fontName, (short)fontSize, (short)fontAttr);
                this.outsideInJni.setFontOption(part.hWnd, 337783, fontName, (short)fontSize, (short)fontAttr);
            }
            try {
                String tempfileprefix = Long.toString(System.currentTimeMillis());
                part.tempFile = File.createTempFile(tempfileprefix, null);
                BufferedInputStream instream = new BufferedInputStream(contentStream);
                BufferedOutputStream outstream = new BufferedOutputStream(new FileOutputStream(part.tempFile));
                int bytesWritten = 0;
                int numBytes = 4096;
                byte[] buffer = new byte[numBytes];
                while (numBytes != -1) {
                    numBytes = instream.read(buffer);
                    if (numBytes <= 0) continue;
                    outstream.write(buffer, 0, numBytes);
                    bytesWritten += numBytes;
                }
                ViewerLogger.logDebug(this, methodName, "Temp file created for part content: " + part.tempFile.getCanonicalPath());
                ViewerLogger.logDebug(this, methodName, "Expected Content length: " + contentLength);
                ViewerLogger.logDebug(this, methodName, "Total bytes written to temp file: " + bytesWritten);
                instream.close();
                outstream.close();
                this.trace(document, null, "loadDocument: part copied to temp file");
            }
            catch (IOException e) {
                throw new CMBDocumentEngineException(PViewerUtilities.getMessage("StellentViewerEngine.ioException"), (Object)e);
            }
            try {
                ViewerLogger.logInfo(this, methodName, "Calling JNI viewFile with hWnd: " + part.hWnd + ", and path: " + part.tempFile.getCanonicalPath());
                rc = this.outsideInJni.viewFile(part.hWnd, part.tempFile.getCanonicalPath());
                if (rc != 0L) {
                    throw new CMBDocumentEngineException(POutsideInJNI.getMessageForOutsideInRC(rc));
                }
                this.trace(document, null, "loadDocument: viewing file in stellent window");
            }
            catch (IOException e) {
                throw new CMBDocumentEngineException(PViewerUtilities.getMessage("StellentViewerEngine.ioException"), (Object)e);
            }
            if (!part.drawPageInited) {
                rc = this.outsideInJni.initDrawPage(part.hWnd);
                part.drawPageInited = true;
            }
            this.trace(document, null, "loadDocument: initDrawPage completed");
            part.firstPageNumber = partNumber == 0 ? 1 : document.parts[partNumber - 1].firstPageNumber + document.parts[partNumber - 1].getPageCount();
            document.parts[partNumber] = part;
        }
    }

    public int ioClose(long hwnd) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        this.trace(part.document, null, "ioClose");
        return 0;
    }

    public int ioRead(long hwnd, byte[] data, int size, int[] count) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        this.trace(part.document, null, "ioRead, size=" + size);
        if (part.data.isValidOffset(part.offset)) {
            try {
                int actualSize;
                count[0] = actualSize = part.data.getByteArray(part.offset, size, data, 0);
                part.offset += actualSize;
                this.trace(part.document, null, "ioRead, actual size=" + actualSize);
                return 0;
            }
            catch (IOException e) {
                return -10;
            }
        }
        this.trace(part.document, null, "ioRead, end of file");
        return -9;
    }

    public int ioSeek(long hwnd, int from, int offset) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        this.trace(part.document, null, "ioSeek, from=" + from + " offset=" + offset);
        if (from == 0) {
            part.offset = offset;
        } else if (from == 1) {
            part.offset += offset;
        } else if (from == 2) {
            if (part.contentLength <= 0) {
                while (part.data.isValidOffset(part.offset)) {
                    ++part.offset;
                }
                part.contentLength = part.offset;
            }
            part.offset = part.contentLength + offset;
        }
        if (part.offset < 0) {
            part.offset = 0;
            return -1;
        }
        return 0;
    }

    public int ioTell(long hwnd, int[] offset) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        this.trace(part.document, null, "ioTell");
        offset[0] = part.offset;
        return 0;
    }

    public void dropDocument(Object hDocument) {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        this.trace(document, null, "dropDocument called");
        for (int i = 0; i < document.parts.length; ++i) {
            OutsideInPart part = document.parts[i];
            if (part == null) continue;
            this.outsideInJni.closeFile(part.hWnd);
            this.outsideInJni.destroyViewerWindow(part.hWnd);
            this.hwndToPartMap.remove(part.hWnd);
            if (part.tempFile != null) {
                part.tempFile.delete();
            }
            part.isDropped = true;
        }
        if (document.mimeType.equals("application/vnd.lotus-wordpro")) {
            wordproDocumentOpen = false;
        }
        this.trace(document, null, "dropDocument completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int getNumberOfPages(Object hDocument) throws IOException {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        if (document.pageCount != 0) {
            return document.pageCount;
        }
        Object object = this.numberOfPagesLock;
        // MONITORENTER : object
        int totalPages = 0;
        int i = 0;
        while (true) {
            if (i >= document.parts.length) {
                document.pageCount = totalPages;
                // MONITOREXIT : object
                return document.pageCount;
            }
            OutsideInPart[] outsideInPartArray = document.parts;
            // MONITORENTER : document.parts
            OutsideInPart part = document.parts[i];
            if (part == null) {
                StringBuffer partMimetypeBuf = new StringBuffer();
                InputStream partStream = this.callbacks.getPart(document, i, partMimetypeBuf);
                int partSize = this.callbacks.getPartSize(document, i);
                this.loadPart(document, i, partStream, partSize, partMimetypeBuf.toString());
                part = document.parts[i];
            }
            totalPages += part.getPageCount();
            // MONITOREXIT : outsideInPartArray
            ++i;
        }
    }

    public boolean canPaginate(String mimeType) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private OutsideInPart getPartForPage(OutsideInDocument document, int pageNumber) {
        if (document.parts.length == 1) {
            return document.parts[0];
        }
        int totalPages = 0;
        int i = 0;
        while (i < document.parts.length) {
            OutsideInPart[] outsideInPartArray = document.parts;
            // MONITORENTER : document.parts
            OutsideInPart part = document.parts[i];
            if (part == null) {
                StringBuffer partMimetypeBuf = new StringBuffer();
                InputStream partStream = this.callbacks.getPart(document, i, partMimetypeBuf);
                int partSize = this.callbacks.getPartSize(document, i);
                this.loadPart(document, i, partStream, partSize, partMimetypeBuf.toString());
                part = document.parts[i];
            }
            if (part.containsPage(pageNumber - totalPages - 1)) {
                // MONITOREXIT : outsideInPartArray
                return part;
            }
            totalPages += part.getPageCount();
            // MONITOREXIT : outsideInPartArray
            ++i;
        }
        return null;
    }

    public Object loadPage(Object hDocument, int pageNumber) throws IOException {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        this.trace(document, null, "loadPage started, page " + pageNumber);
        OutsideInPart part = this.getPartForPage(document, pageNumber);
        if (part == null) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewerEngine.invalidPageNumber", new Object[]{Integer.toString(pageNumber)}));
        }
        OutsideInPage page = new OutsideInPage();
        page.part = part;
        page.documentPageNumber = pageNumber;
        page.partPageNumber = pageNumber - part.firstPageNumber + 1;
        this.trace(document, page, "loadPage completed");
        return page;
    }

    public void dropPage(Object hPage) {
    }

    public boolean canInvert(Object hDocument, String destMimeType) {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        return !this.viewingNatively(document);
    }

    public boolean canEnhance(Object hDocument, String destMimeType) {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        return document.mimeType.equals("image/tiff") || document.mimeType.equals("image/tif") || document.mimeType.equals("image/gif") || document.mimeType.equals("image/jpeg") || document.mimeType.equals("image/pcx") || document.mimeType.equals("image/dcx");
    }

    public boolean canProvidePageImage(String mimeType) {
        return true;
    }

    public boolean canRotate(Object hDocument, String destMimetype) {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        return !this.viewingNatively(document);
    }

    public double getPageWidth(Object hPage) {
        OutsideInPage page = (OutsideInPage)hPage;
        if (page.widthPixels == 0) {
            this.retrievePageMetaData(page);
        }
        return (double)page.widthPixels / (double)this.getPageXResolution(hPage);
    }

    public double getPageHeight(Object hPage) {
        OutsideInPage page = (OutsideInPage)hPage;
        if (page.heightPixels == 0) {
            this.retrievePageMetaData(page);
        }
        return (double)page.heightPixels / (double)this.getPageYResolution(hPage);
    }

    public int getPageXResolution(Object hPage) {
        OutsideInPage page = (OutsideInPage)hPage;
        if (page.xResolution == 0) {
            this.retrievePageMetaData(page);
        }
        return page.xResolution;
    }

    public int getPageYResolution(Object hPage) {
        OutsideInPage page = (OutsideInPage)hPage;
        if (page.yResolution == 0) {
            this.retrievePageMetaData(page);
        }
        return page.xResolution;
    }

    private int getMaxResolution(OutsideInPage page) {
        return Math.max(this.getPageXResolution(page), this.getPageYResolution(page));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrievePageMetaData(OutsideInPage page) {
        OutsideInPart part = page.part;
        CMBOutsideInViewerEngine cMBOutsideInViewerEngine = this;
        synchronized (cMBOutsideInViewerEngine) {
            int[] bestFormat = new int[2];
            long rc = this.outsideInJni.getDrawPageInfo(part.hWnd, page.partPageNumber - 1, 1440, 0, 0, bestFormat);
            page.xResolution = 96;
            page.widthPixels = bestFormat[0] * page.xResolution / 1440;
            if (page.widthPixels <= 0) {
                page.widthPixels = (int)(8.5 * (double)page.xResolution);
            }
            page.yResolution = 96;
            page.heightPixels = bestFormat[1] * page.yResolution / 1440;
            if (page.heightPixels <= 0) {
                page.heightPixels = (int)(11.0 * (double)page.yResolution);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness) {
        OutsideInPage page = (OutsideInPage)hPage;
        OutsideInPart part = page.part;
        CMBOutsideInViewerEngine cMBOutsideInViewerEngine = this;
        synchronized (cMBOutsideInViewerEngine) {
            long rc;
            this.trace(part.document, page, "getPageImage started");
            int imageWidth = (int)((double)this.getPageXResolution(page) * this.getPageWidth(page) * scale);
            int imageHeight = (int)((double)this.getPageYResolution(page) * this.getPageHeight(page) * scale);
            int rotatedWidth = imageWidth;
            int rotatedHeight = imageHeight;
            if (rotation == 1 || rotation == 3) {
                rotatedWidth = imageHeight;
                rotatedHeight = imageWidth;
            }
            BufferedImage image = new BufferedImage(rotatedWidth, rotatedHeight, 1);
            WritableRaster raster = image.getRaster();
            DataBufferInt dataBuffer = (DataBufferInt)raster.getDataBuffer();
            int[] imageData = dataBuffer.getData();
            if (scale >= 2.0) {
                enhance = false;
            }
            this.trace(part.document, page, "getPageImage, buffer created");
            if (page.bestFormat == null) {
                page.bestFormat = new int[2];
                rc = this.outsideInJni.getDrawPageInfo(part.hWnd, page.partPageNumber - 1, 1440, 0, 0, page.bestFormat);
                if (rc != 0L && rc != 22L) {
                    throw new CMBViewerException(POutsideInJNI.getMessageForOutsideInRC(rc));
                }
            }
            if ((rc = this.outsideInJni.drawPage(part.hWnd, page.partPageNumber - 1, 1440, page.bestFormat[0], page.bestFormat[1], imageWidth, imageHeight, rotation, enhance, invert, imageData)) != 0L && rc != 22L) {
                throw new CMBViewerException(POutsideInJNI.getMessageForOutsideInRC(rc));
            }
            this.trace(part.document, page, "getPageImage, drawPage completed");
            if (contrast != 100 || brightness != 100) {
                this.balanceImageData(imageData, contrast, brightness);
            }
            if (page.part.document.annotationSet != null && withAnnotations) {
                Graphics2D graphics = (Graphics2D)image.getGraphics();
                if (rotation == 1) {
                    graphics.translate(imageWidth / 2, imageHeight / 2);
                    graphics.rotate(1.5707963267948966);
                    graphics.translate(-imageHeight / 2, -imageWidth / 2);
                    graphics.translate(0, -imageHeight + imageWidth);
                } else if (rotation == 2) {
                    graphics.rotate(Math.PI, imageWidth / 2, imageHeight / 2);
                } else if (rotation == 3) {
                    graphics.translate(imageWidth / 2, imageHeight / 2);
                    graphics.rotate(4.71238898038469);
                    graphics.translate(-imageHeight / 2, -imageWidth / 2);
                    graphics.translate(imageHeight - imageWidth, 0);
                }
                graphics.scale(scale, scale);
                CMBPageAnnotation[] annotations = page.part.document.annotationSet.getPageAnnotations(page.documentPageNumber);
                for (int i = 0; i < annotations.length; ++i) {
                    annotations[i].draw(graphics);
                }
                graphics.dispose();
            }
            this.trace(part.document, page, "getPageImage completed");
            return image;
        }
    }

    private void balanceImageData(int[] imageData, int contrast, int brightness) {
        float contrastRatio = (float)contrast / 100.0f;
        float brightnessRatio = (float)((double)brightness / 100.0);
        for (int i = 0; i < imageData.length; ++i) {
            int newPixel;
            int pixel = imageData[i];
            int r = (pixel & 0xFF0000) >> 16;
            int g = (pixel & 0xFF00) >> 8;
            int b = pixel & 0xFF;
            if (contrastRatio != 1.0f) {
                if ((r = (int)(((double)r - 127.0) * (double)contrastRatio) + 127) > 255) {
                    r = 255;
                }
                if (r < 0) {
                    r = 0;
                }
                if ((g = (int)(((double)g - 127.0) * (double)contrastRatio) + 127) > 255) {
                    g = 255;
                }
                if (g < 0) {
                    g = 0;
                }
                if ((b = (int)(((double)b - 127.0) * (double)contrastRatio) + 127) > 255) {
                    b = 255;
                }
                if (b < 0) {
                    b = 0;
                }
            }
            float[] hsb = Color.RGBtoHSB(r, g, b, null);
            hsb[2] = hsb[2] * brightnessRatio;
            if (hsb[2] > 1.0f) {
                hsb[2] = 1.0f;
            }
            imageData[i] = newPixel = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        }
    }

    public double getPageMaxScale(Object hPage, String destMimetype) {
        if (this.useDrawPage) {
            int pageResolution = Math.max(this.getPageXResolution(hPage), this.getPageYResolution(hPage));
            return 960.0 / (double)pageResolution;
        }
        OutsideInPage page = (OutsideInPage)hPage;
        int imageWidth = (int)((double)this.getPageXResolution(page) * this.getPageWidth(page));
        int imageHeight = (int)((double)this.getPageYResolution(page) * this.getPageHeight(page));
        int memoryForActualSize = imageWidth * imageHeight * 4;
        double maxScale = Math.log(0x2000000 / memoryForActualSize) / Math.log(2.0);
        return Math.max(maxScale, 1.0);
    }

    public double getPageMinScale(Object hPage, String destMimeType) {
        return 0.01;
    }

    public boolean canWriteDocument(String sourceMimeType, String destMimeType) {
        return sourceMimeType.equals(destMimeType);
    }

    public boolean canWritePage(Object hPage, String destMimeType) {
        return destMimeType.equals("image/png");
    }

    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType) throws IOException, CMBDocumentEngineException {
        BufferedImage pageImage = (BufferedImage)this.getPageImage(hPage, rotation, scale, enhance, invert, withAnnotations);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(output);
        writer.setOutput(ios);
        writer.write(pageImage);
    }

    boolean canProvideViewer(String mimeType) {
        if (mimeType.equals("text/plain")) {
            return true;
        }
        if (mimeType.equals("text/html")) {
            return true;
        }
        if (mimeType.equals("text/richtext") || mimeType.equals("text/rtf") || mimeType.equals("application/rtf")) {
            return true;
        }
        if (mimeType.equals("application/msword")) {
            return true;
        }
        if (mimeType.equals("application/vnd.lotus-wordpro")) {
            return true;
        }
        if (mimeType.equals("application/wordperfect5.1")) {
            return true;
        }
        return mimeType.equals("text/xml");
    }

    PSingleDocViewer getViewerComponent(CMBGenericDocViewer gdv, Object hDocument, CMBDocument cmbDocument, CMBAnnotationSet annotationSet) {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        String docName = "";
        POutsideInDocViewer viewer = new POutsideInDocViewer(gdv, cmbDocument, annotationSet, docName, this.outsideInJni, document.parts[0].hWnd);
        document.parts[0].view = (POutsideInFullSizeView)viewer.createFullSizeView();
        return viewer;
    }

    private boolean viewingNatively(OutsideInDocument document) {
        return this.canProvideViewer(document.mimeType);
    }

    void onPaint(long hwnd, Rectangle r) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        if (part != null && part.view != null) {
            part.view.onPaint(r);
        }
    }

    void onVScrollPageSizeChanged(long hwnd, int pageSize) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        if (part != null && part.view != null) {
            part.view.onVScrollPageSizeChanged(pageSize);
        }
    }

    void onVScrollPositionChanged(long hwnd, int position) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        if (part != null && part.view != null) {
            part.view.onVScrollPositionChanged(position);
        }
    }

    void onVScrollRangeChanged(long hwnd, int minPosition, int maxPosition) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        if (part != null && part.view != null) {
            part.view.onVScrollRangeChanged(minPosition, maxPosition);
        }
    }

    void onVScrollMinChanged(long hwnd, int minPosition) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        if (part != null && part.view != null) {
            part.view.onVScrollMinChanged(minPosition);
        }
    }

    void onVScrollMaxChanged(long hwnd, int maxPosition) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        if (part != null && part.view != null) {
            part.view.onVScrollMaxChanged(maxPosition);
        }
    }

    void onVScrollStateChanged(long hwnd, boolean enabled) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        if (part != null && part.view != null) {
            part.view.onVScrollStateChanged(enabled);
        }
    }

    void onHScrollPageSizeChanged(long hwnd, int pageSize) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        if (part != null && part.view != null) {
            part.view.onHScrollPageSizeChanged(pageSize);
        }
    }

    void onHScrollPositionChanged(long hwnd, int position) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        if (part != null && part.view != null) {
            part.view.onHScrollPositionChanged(position);
        }
    }

    void onHScrollRangeChanged(long hwnd, int minPosition, int maxPosition) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        if (part != null && part.view != null) {
            part.view.onHScrollRangeChanged(minPosition, maxPosition);
        }
    }

    void onHScrollStateChanged(long hwnd, boolean enabled) {
        OutsideInPart part = this.hwndToPartMap.get(hwnd);
        if (part != null && part.view != null) {
            part.view.onHScrollStateChanged(enabled);
        }
    }

    private void trace(OutsideInDocument document, OutsideInPage page, String message) {
        if (this.callbacks.traceEnabled()) {
            String qualifiedMessage = "CMBOutsideInViewerEngine: " + message;
            if (document != null) {
                qualifiedMessage = qualifiedMessage + " Document: " + document.hashCode();
            }
            if (page != null) {
                qualifiedMessage = qualifiedMessage + " Page: " + page.documentPageNumber;
            }
            this.callbacks.trace(qualifiedMessage);
        }
    }

    public void writeDocument(Object hDocument, boolean withAnnotations, boolean originalColor, String destMimeType, OutputStream output) throws IOException {
        if (withAnnotations) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("StellentViewerEngine.writeWithAnnotations"));
        }
        OutsideInDocument document = (OutsideInDocument)hDocument;
        if (document.parts.length > 1) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("StellentViewerEngine.multipartWrite"));
        }
        PViewerUtilities.writeFileToStream(document.parts[0].tempFile, output);
    }

    public void writeDocument(Object hDocument, String destMimeType, OutputStream output) throws IOException {
        this.writeDocument(hDocument, false, false, destMimeType, output);
    }

    public boolean useDrawPage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness) {
        return this.useDrawPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness, Graphics2D graphics) {
        OutsideInPage page = (OutsideInPage)hPage;
        OutsideInPart part = page.part;
        CMBOutsideInViewerEngine cMBOutsideInViewerEngine = this;
        synchronized (cMBOutsideInViewerEngine) {
            long rc;
            this.trace(part.document, page, "drawPage started");
            int imageWidth = (int)((double)this.getPageXResolution(page) * this.getPageWidth(page) * scale);
            int imageHeight = (int)((double)this.getPageYResolution(page) * this.getPageHeight(page) * scale);
            int rotatedWidth = imageWidth;
            int rotatedHeight = imageHeight;
            if (rotation == 1 || rotation == 3) {
                rotatedWidth = imageHeight;
                rotatedHeight = imageWidth;
            }
            Rectangle clip = graphics.getClipBounds();
            if (clip.width + clip.x > rotatedWidth) {
                clip.width = rotatedWidth - clip.x;
            }
            if (clip.height + clip.y > rotatedHeight) {
                clip.height = rotatedHeight - clip.y;
            }
            if (clip.width <= 0 || clip.height <= 0) {
                return;
            }
            BufferedImage image = new BufferedImage(clip.width, clip.height, 1);
            WritableRaster raster = image.getRaster();
            DataBufferInt dataBuffer = (DataBufferInt)raster.getDataBuffer();
            int[] imageData = dataBuffer.getData();
            if (scale >= 2.0) {
                enhance = false;
            }
            this.trace(part.document, page, "drawPage buffer created");
            if (page.bestFormat == null) {
                page.bestFormat = new int[2];
                rc = this.outsideInJni.getDrawPageInfo(part.hWnd, page.partPageNumber - 1, 1440, 0, 0, page.bestFormat);
                if (rc != 0L && rc != 22L) {
                    throw new CMBViewerException(POutsideInJNI.getMessageForOutsideInRC(rc));
                }
            }
            if ((rc = this.outsideInJni.drawPartialPage(part.hWnd, page.partPageNumber - 1, 1440, page.bestFormat[0], page.bestFormat[1], imageWidth, imageHeight, rotation, enhance, invert, clip.x, clip.y, clip.width, clip.height, imageData)) != 0L && rc != 22L) {
                throw new CMBViewerException(POutsideInJNI.getMessageForOutsideInRC(rc));
            }
            this.trace(part.document, page, "drawPage stellent drawPartialPage completed");
            if (contrast != 100 || brightness != 100) {
                this.balanceImageData(imageData, contrast, brightness);
            }
            if (page.part.document.annotationSet != null && withAnnotations) {
                Graphics2D imageGraphics = (Graphics2D)image.getGraphics();
                if (rotation == 1) {
                    imageGraphics.translate(imageWidth / 2, imageHeight / 2);
                    imageGraphics.rotate(1.5707963267948966);
                    imageGraphics.translate(-imageHeight / 2, -imageWidth / 2);
                    imageGraphics.translate(0, -imageHeight + imageWidth);
                } else if (rotation == 2) {
                    imageGraphics.rotate(Math.PI, imageWidth / 2, imageHeight / 2);
                } else if (rotation == 3) {
                    imageGraphics.translate(imageWidth / 2, imageHeight / 2);
                    imageGraphics.rotate(4.71238898038469);
                    imageGraphics.translate(-imageHeight / 2, -imageWidth / 2);
                    imageGraphics.translate(imageHeight - imageWidth, 0);
                }
                imageGraphics.scale(scale, scale);
                CMBPageAnnotation[] annotations = page.part.document.annotationSet.getPageAnnotations(page.documentPageNumber);
                for (int i = 0; i < annotations.length; ++i) {
                    annotations[i].draw(imageGraphics);
                }
                imageGraphics.dispose();
            }
            graphics.drawImage((Image)image, clip.x, clip.y, null);
            this.trace(part.document, page, "drawPage completed");
        }
    }

    public boolean canBalancePage(Object hPage) {
        return true;
    }

    public boolean canFind(Object hDocument) {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        return document.mimeType.equals("application/msword") || document.mimeType.equals("application/vnd.lotus-wordpro") || document.mimeType.equals("text/rtf") || document.mimeType.equals("text/richtext") || document.mimeType.equals("application/rtf") || document.mimeType.equals("text/html");
    }

    private class AnnotationServicesCallbacks
    extends CMBAnnotationServicesCallbacks {
        private AnnotationServicesCallbacks() {
        }

        public int addAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData) throws CMBAnnotationEngineException {
            return 0;
        }

        public InputStream getAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
            return null;
        }

        public boolean getPrivilege(CMBAnnotationSet annotationSet, int privilegeID) throws CMBAnnotationEngineException {
            return true;
        }

        public void removeAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
        }

        public void trace(String message) {
        }

        public boolean traceEnabled() {
            return false;
        }

        public void updateAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData, int annotationNumber) throws CMBAnnotationEngineException {
        }
    }

    private class GetPageImageRunnable
    implements Runnable {
        public Object hPage;
        public int rotation;
        public double scale;
        public boolean enhance;
        public boolean invert;
        public boolean withAnnotations;
        public Image image;
        public Throwable throwable;

        private GetPageImageRunnable() {
        }

        public void run() {
            try {
                this.image = CMBOutsideInViewerEngine.this.getPageImage(this.hPage, this.rotation, this.scale, this.enhance, this.invert, this.withAnnotations);
            }
            catch (Throwable t) {
                this.throwable = t;
            }
        }
    }

    private class OutsideInDispatchThread
    extends Thread {
        OutsideInPart part;

        public OutsideInDispatchThread(OutsideInPart part) {
            this.setName("CMBOutsideInViewerEngine.OutsideInDispatchThread");
            this.part = part;
            this.setPriority(10);
            try {
                this.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CMBOutsideInViewerEngine.this.trace(this.part.document, null, "dispatchThread started");
            OutsideInDispatchThread outsideInDispatchThread = this;
            synchronized (outsideInDispatchThread) {
                this.part.hWnd = CMBOutsideInViewerEngine.this.outsideInJni.createViewerWindow();
                if (this.part.hWnd == 0L) {
                    try {
                        Thread.sleep(1000L);
                        this.part.hWnd = CMBOutsideInViewerEngine.this.outsideInJni.createViewerWindow();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                CMBOutsideInViewerEngine.this.hwndToPartMap.put(this.part.hWnd, this.part);
                this.setPriority(1);
                this.notifyAll();
            }
            CMBOutsideInViewerEngine.this.outsideInJni.dispatchMessages(this.part.hWnd);
            CMBOutsideInViewerEngine.this.trace(this.part.document, null, "dispatchThread completed");
        }
    }

    private class OutsideInPage {
        OutsideInPart part;
        int documentPageNumber;
        int partPageNumber;
        int widthPixels;
        int heightPixels;
        int xResolution;
        int yResolution;
        int[] bestFormat;

        private OutsideInPage() {
        }
    }

    class OutsideInPart {
        OutsideInDocument document;
        File tempFile;
        PDataAccessInterface data;
        int contentLength;
        int offset;
        long hWnd;
        boolean drawPageInited;
        int lastTestedPage;
        int firstPageNumber;
        private int pageCount;
        private boolean pageCountDetermined;
        private boolean pageCountingStarted;
        POutsideInFullSizeView view;
        boolean isDropped;
        private Thread determinePageCountThread;
        private Object pageCountDetermineLock = new Object();

        OutsideInPart() {
        }

        public int getPageCount() {
            if (this.pageCountDetermined) {
                return this.pageCount;
            }
            this.determinePageCount();
            return this.pageCount;
        }

        public boolean containsPage(int pageIndex) {
            if (!this.pageCountingStarted) {
                this.determinePageCountThread = new Thread(){

                    public void run() {
                        OutsideInPart.this.determinePageCount();
                    }
                };
                this.determinePageCountThread.setName("CMBStellentViewerEngine.determinePageCountThread");
                try {
                    this.determinePageCountThread.setDaemon(true);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                this.determinePageCountThread.start();
            }
            while (!this.pageCountDetermined && this.pageCount <= pageIndex && this.determinePageCountThread != null && this.determinePageCountThread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isDropped) continue;
                return false;
            }
            return pageIndex < this.pageCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void determinePageCount() {
            Object object = this.pageCountDetermineLock;
            synchronized (object) {
                if (this.pageCountDetermined) {
                    return;
                }
                this.pageCountingStarted = true;
                long result = 0L;
                while (result == 0L) {
                    int[] bestFormat = new int[2];
                    Thread.yield();
                    OutsideInPart outsideInPart = this;
                    synchronized (outsideInPart) {
                        result = 22L;
                        result = CMBOutsideInViewerEngine.this.outsideInJni.getDrawPageInfo(this.hWnd, this.pageCount, 1440, 0, 0, bestFormat);
                        result = CMBOutsideInViewerEngine.this.outsideInJni.drawPage(this.hWnd, this.pageCount, 1440, bestFormat[0], bestFormat[1], 0, 0, 0, false, false, null);
                    }
                    if (this.isDropped) {
                        return;
                    }
                    if (result == 0L || result == 22L) {
                        ++this.pageCount;
                        continue;
                    }
                    this.pageCountDetermined = true;
                    throw new CMBDocumentEngineException(POutsideInJNI.getMessageForOutsideInRC(result));
                }
                this.pageCountDetermined = true;
            }
        }
    }

    private class OutsideInDocument {
        String mimeType;
        OutsideInPart[] parts;
        CMBAnnotationSet annotationSet;
        int pageCount;

        private OutsideInDocument() {
        }
    }
}

