/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineCallbacks;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBViewerException;
import com.ibm.mm.viewer.PBrightnessContrastFilter;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationServicesCallbacks;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.outsideinsdk.Export;
import com.outsideinsdk.ExportStatusCode;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public final class CMBOutsideInExportEngine
extends CMBDocumentEngine {
    private static final int DEFAULT_DPI = 96;
    private static final double DEFAULT_PAGE_WIDTH = 8.5;
    private static final double DEFAULT_PAGE_HEIGHT = 11.0;
    private static String EXE_PATH_PROPERTY = "exePath";
    private static String TIMEOUT_PROPERTY = "OIEXPORT_TIMEOUT";
    private static String TIFF_COMPRESSION_PROPERTY = "OIEXPORT_TIFF_COMPRESSION";
    private static String GRAPHICOUTPUT_DPI_PROPERTY = "OIEXPORT_GRAPHICOUTPUT_DPI";
    private CMBDocumentEngineCallbacks callbacks;
    private Properties properties;
    CMBAnnotationServices annotationServices;
    private boolean initialized;
    private long timeout = 0L;
    private static String oiDir = null;
    private static boolean isUnix = true;
    private static boolean isAIX = false;
    private static String fontDirectory = null;
    private static final String FONTS_PATH = File.separator + "fonts";
    private static final String JRE_LIB_FONTS_PATH = File.separator + "jre" + File.separator + "lib" + File.separator + "fonts";
    private static final boolean TEST_MODE = false;
    private Object numberOfPagesLock = new Object();

    public void initialize(CMBDocumentEngineCallbacks callbacks, Properties properties) {
        this.callbacks = callbacks;
        this.properties = properties;
        this.annotationServices = new CMBAnnotationServices(new AnnotationServicesCallbacks(), properties);
        if (properties != null && properties.getProperty(TIMEOUT_PROPERTY) != null) {
            String timeoutProperty = properties.getProperty(TIMEOUT_PROPERTY);
            this.timeout = new Long(timeoutProperty);
            this.trace(null, "timeout property: " + this.timeout);
        }
        this.initialized = true;
        this.trace(null, "Initialized.");
    }

    public void terminate() {
        this.initialized = false;
        this.annotationServices.terminate();
        this.trace(null, "Terminated.");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean canLoadDocument(String mimeType) {
        return !mimeType.startsWith("audio") && !mimeType.startsWith("video");
    }

    public Object loadDocument(InputStream contentStream, int nParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        return this.loadDocument(contentStream, -1, nParts, partMimeType, docMimeType, annotationStream, resourceStream);
    }

    public Object loadDocument(InputStream contentStream, int contentLength, int nParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        OutsideInDocument document = new OutsideInDocument();
        document.parts = new OutsideInPart[nParts];
        document.mimeType = docMimeType;
        this.trace(document, "loadDocument invoked");
        this.loadPart(document, 0, contentStream, contentLength);
        if (annotationStream != null) {
            try {
                document.annotationSet = this.annotationServices.loadAnnotationSet(annotationStream, "application/vnd.ibm.modcap", this.getAnnotationPosition(document), 1, 1);
            }
            catch (Exception e) {
                throw new CMBDocumentEngineException(PViewerUtilities.getMessage("SnowboundEngine.problemParsingAnnotations"), (Object)e);
            }
        }
        this.trace(document, "loadDocument completed.");
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPart(OutsideInDocument document, int partNumber, InputStream contentStream, int contentLength) throws IOException {
        OutsideInPart[] outsideInPartArray = document.parts;
        synchronized (document.parts) {
            if (document.parts[partNumber] != null) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            OutsideInPart part = new OutsideInPart();
            part.document = document;
            part.contentLength = contentLength;
            if (part.tempDirectory == null) {
                part.tempDirectory = File.createTempFile("CMBOutsideInExportEngine", null);
                part.tempDirectory.delete();
                boolean created = part.tempDirectory.mkdir();
                if (!created) {
                    throw new IOException(PViewerUtilities.getMessage("StellentExportEngine.directoryCreateError"));
                }
                part.partDirectory = File.createTempFile("parts", null, part.tempDirectory);
                part.partDirectory.delete();
                created = part.partDirectory.mkdir();
                if (!created) {
                    throw new IOException(PViewerUtilities.getMessage("StellentExportEngine.directoryCreateError"));
                }
                this.trace(document, "loadPart:part directory: " + part.partDirectory.getCanonicalPath());
            }
            try {
                part.tempFile = File.createTempFile("part", ".dat", part.tempDirectory);
                PViewerUtilities.writeStreamToFile(contentStream, part.tempFile);
                contentStream.close();
                this.trace(document, "loadPart: part copied to temp file " + part.tempFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new CMBDocumentEngineException(PViewerUtilities.getMessage("StellentExportEngine.ioException"), (Object)e);
            }
            part.firstPageNumber = partNumber == 0 ? 1 : document.parts[partNumber - 1].firstPageNumber + document.parts[partNumber - 1].getPageCount();
            document.parts[partNumber] = part;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void dropDocument(Object hDocument) {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        this.trace(document, "dropDocument called");
        for (int i = 0; i < document.parts.length; ++i) {
            OutsideInPart part = document.parts[i];
            if (part == null) continue;
            if (part.tempFile != null) {
                part.tempFile.delete();
            }
            if (part.tempDirectory != null) {
                File[] files = part.tempDirectory.listFiles();
                for (int j = 0; j < files.length; ++j) {
                    files[j].delete();
                }
                part.tempDirectory.delete();
            }
            part.isDropped = true;
        }
        if (document.annotationSet != null) {
            this.annotationServices.dropAnnotationSet(document.annotationSet);
        }
        this.trace(document, "dropDocument completed");
    }

    public boolean canWriteDocument(String sourceMimeType, String destMimeType) {
        if (destMimeType.equals("text/html")) {
            return true;
        }
        if (destMimeType.equals("image/tiff")) {
            return true;
        }
        if (destMimeType.equals("image/gif") || destMimeType.equals("image/jpeg") || destMimeType.equals("image/bmp") || destMimeType.equals("image/png")) {
            if (sourceMimeType.equals("image/gif") || sourceMimeType.equals("image/bmp") || destMimeType.equals("image/jpeg") || destMimeType.equals("image/bmp") || destMimeType.equals("image/png")) {
                return true;
            }
        } else {
            if (destMimeType.equals("text/plain")) {
                return true;
            }
            if (destMimeType.equals("application/pdf")) {
                return true;
            }
        }
        return false;
    }

    public void writeDocument(Object hDocument, String destMimeType, OutputStream output) throws IOException {
        this.writeDocument(hDocument, destMimeType, output, (String)null);
    }

    public void writeDocument(Object hDocument, String destMimeType, OutputStream output, String resourcePrefix) throws IOException {
        String exportFormat;
        OutsideInDocument document = (OutsideInDocument)hDocument;
        OutsideInPart part = document.parts[0];
        this.trace(document, "writeDocument called");
        String tempfileprefix = Long.toString(System.currentTimeMillis());
        File tempOutFile = File.createTempFile(tempfileprefix, null, part.tempDirectory);
        Properties exporterProps = new Properties();
        String exePath = this.getExePath(this.properties);
        if (exePath != null && !exePath.isEmpty()) {
            exporterProps.setProperty("exepath", exePath + "/exporter");
        } else {
            exporterProps.setProperty("exepath", "exporter");
        }
        if (resourcePrefix != null) {
            exporterProps.setProperty("hrefprefix", resourcePrefix);
        }
        if (destMimeType.equals("image/tiff")) {
            exporterProps.setProperty("tiffmultipage", "yes");
            exporterProps.setProperty("whattoexport", "all");
            exporterProps.setProperty("graphicoutputdpi", "200");
            exporterProps.setProperty("tiffcompression", "Packbits");
        }
        exporterProps.setProperty("preferoitrendering", isAIX ? "false" : "true");
        if (destMimeType.equals("image/tiff") && this.properties != null) {
            if (this.properties.getProperty(GRAPHICOUTPUT_DPI_PROPERTY) != null) {
                String dpiProperty = this.properties.getProperty(GRAPHICOUTPUT_DPI_PROPERTY);
                this.trace(null, "graphic output dpi property: " + dpiProperty);
                exporterProps.setProperty("graphicoutputdpi", dpiProperty);
            }
            if (this.properties.getProperty(TIFF_COMPRESSION_PROPERTY) != null) {
                String tiffCompressionProperty = this.properties.getProperty(TIFF_COMPRESSION_PROPERTY);
                this.trace(null, "tiff compression property: " + tiffCompressionProperty);
                exporterProps.setProperty("tiffcompression", tiffCompressionProperty);
            }
        }
        if (destMimeType.equals("text/html")) {
            exportFormat = "fi_html";
        } else if (destMimeType.equals("image/tiff")) {
            exportFormat = "fi_tiff";
        } else if (destMimeType.equals("image/gif")) {
            exportFormat = "fi_gif";
        } else if (destMimeType.equals("image/jpeg")) {
            exportFormat = "fi_jpeg";
        } else if (destMimeType.equals("text/plain")) {
            exportFormat = "fi_text";
        } else if (destMimeType.equals("image/bmp")) {
            exportFormat = "fi_bmp";
        } else if (destMimeType.equals("image/png")) {
            exportFormat = "fi_png";
        } else if (destMimeType.equals("application/pdf")) {
            String fontDirectory;
            exportFormat = "fi_pdf";
            if (isUnix && (fontDirectory = this.findFontDirectory()) != null) {
                exporterProps.setProperty("fontdirectory", fontDirectory);
            }
        } else {
            exportFormat = "fi_html";
        }
        Export export = new Export(exporterProps);
        ExportStatusCode status = export.convert(part.tempFile.getCanonicalPath(), tempOutFile.getCanonicalPath(), exportFormat, this.timeout);
        if (!status.equals(ExportStatusCode.SCCERR_OK)) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("StellentExportEngine.outsideInConversionError", new String[]{status.getCodeText()}));
        }
        PViewerUtilities.writeFileToStream(tempOutFile, output);
        tempOutFile.delete();
        this.trace(document, "writeDocument completed");
    }

    public void writeDocument(Object hDocument, boolean withAnnotations, boolean originalColor, String destMimeType, OutputStream output) throws IOException {
        if (!withAnnotations) {
            this.writeDocument(hDocument, destMimeType, output);
            return;
        }
        OutsideInDocument document = (OutsideInDocument)hDocument;
        OutsideInPart part = document.parts[0];
        this.trace(document, "writeDocument called");
        String tempfileprefix = Long.toString(System.currentTimeMillis());
        Properties exporterProps = new Properties();
        String exePath = this.getExePath(this.properties);
        if (exePath != null && !exePath.isEmpty()) {
            exporterProps.setProperty("exepath", exePath + "/ixmulti");
        } else {
            exporterProps.setProperty("exepath", "ixmulti");
        }
        if (destMimeType.equals("image/tiff")) {
            exporterProps.setProperty("tiffmultipage", "yes");
            exporterProps.setProperty("whattoexport", "all");
            exporterProps.setProperty("graphicoutputdpi", "200");
            exporterProps.setProperty("tiffcompression", "Packbits");
            if (this.properties != null) {
                if (this.properties.getProperty(GRAPHICOUTPUT_DPI_PROPERTY) != null) {
                    String dpiProperty = this.properties.getProperty(GRAPHICOUTPUT_DPI_PROPERTY);
                    this.trace(null, "graphic output dpi property: " + dpiProperty);
                    exporterProps.setProperty("graphicoutputdpi", dpiProperty);
                }
                if (this.properties.getProperty(TIFF_COMPRESSION_PROPERTY) != null) {
                    String tiffCompressionProperty = this.properties.getProperty(TIFF_COMPRESSION_PROPERTY);
                    this.trace(null, "tiff compression property: " + tiffCompressionProperty);
                    exporterProps.setProperty("tiffcompression", tiffCompressionProperty);
                }
            }
        }
        exporterProps.setProperty("preferoitrendering", isAIX ? "false" : "true");
        Export export = new Export(exporterProps);
        String exportFormat = destMimeType.equals("text/html") ? "fi_html" : (destMimeType.equals("image/tiff") ? "fi_tiff" : (destMimeType.equals("image/gif") ? "fi_gif" : (destMimeType.equals("image/jpeg") ? "fi_jpeg" : (destMimeType.equals("text/plain") ? "fi_text" : (destMimeType.equals("image/bmp") ? "fi_bmp" : (destMimeType.equals("image/png") ? "fi_png" : "fi_html"))))));
        File tempOutFile = null;
        int pagecount = document.pageCount;
        for (int i = 1; i <= document.pageCount; ++i) {
            Integer key = new Integer(i);
            OutsideInPage page = document.loadedPages.get(key);
            if (document.loadedPages.containsKey(key)) {
                page = document.loadedPages.get(key);
            } else {
                this.loadPage(document, i);
            }
            tempOutFile = File.createTempFile(tempfileprefix + i, ".png", part.partDirectory);
            FileOutputStream outStream = new FileOutputStream(tempOutFile);
            this.writePage(page, 0, 1.0, true, false, true, 100, 100, outStream, "image/png");
        }
        tempOutFile = File.createTempFile(tempfileprefix, ".tif", part.tempDirectory);
        ExportStatusCode status = export.convertMulti(part.partDirectory.getCanonicalPath(), tempOutFile.getCanonicalPath(), this.timeout);
        if (!status.equals(ExportStatusCode.SCCERR_OK)) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("StellentExportEngine.outsideInConversionError", new String[]{status.getCodeText()}));
        }
        PViewerUtilities.writeFileToStream(tempOutFile, output);
        tempOutFile.delete();
    }

    public String getDocumentResourceMimeType(Object hDocument, String resourceId) throws IOException {
        return "image/jpeg";
    }

    public void writeDocumentResource(Object hDocument, String resourceId, OutputStream docStream) throws IOException {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        OutsideInPart part = document.parts[0];
        this.trace(document, "writeDocumentResource called");
        File resourceFile = new File(part.tempDirectory.getCanonicalPath() + File.separatorChar + resourceId);
        PViewerUtilities.writeFileToStream(resourceFile, docStream);
        this.trace(document, "writeDocument completed");
    }

    public boolean canPaginate(String mimeType) {
        return true;
    }

    private OutsideInPart getPartForPage(OutsideInDocument document, int pageNumber) throws IOException {
        if (document.parts.length == 1) {
            return document.parts[0];
        }
        int totalPages = 0;
        for (int i = 0; i < document.parts.length; ++i) {
            OutsideInPart part = document.parts[i];
            if (part == null) {
                this.loadPart(document, i, this.callbacks.getPart(document, i, new StringBuffer()), this.callbacks.getPartSize(document, i));
                part = document.parts[i];
            }
            if (part.containsPage(pageNumber - totalPages - 1)) {
                return part;
            }
            totalPages += part.getPageCount();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPages(Object hDocument) throws IOException {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        if (document.pageCount != 0) {
            return document.pageCount;
        }
        Object object = this.numberOfPagesLock;
        synchronized (object) {
            int totalPages = 0;
            for (int i = 0; i < document.parts.length; ++i) {
                OutsideInPart part = document.parts[i];
                if (part == null) {
                    this.loadPart(document, i, this.callbacks.getPart(document, i, new StringBuffer()), this.callbacks.getPartSize(document, i));
                    part = document.parts[i];
                }
                totalPages += part.getPageCount();
            }
            document.pageCount = totalPages;
        }
        return document.pageCount;
    }

    private int getInteger(byte[] data, int offset, boolean bigEndian) {
        int returnInt;
        if (bigEndian) {
            returnInt = data[offset] & 0xFF;
            returnInt = (returnInt << 8) + (data[offset + 1] & 0xFF);
            returnInt = (returnInt << 8) + (data[offset + 2] & 0xFF);
            returnInt = (returnInt << 8) + (data[offset + 3] & 0xFF);
        } else {
            returnInt = data[offset + 3] & 0xFF;
            returnInt = (returnInt << 8) + (data[offset + 2] & 0xFF);
            returnInt = (returnInt << 8) + (data[offset + 1] & 0xFF);
            returnInt = (returnInt << 8) + (data[offset] & 0xFF);
        }
        return returnInt;
    }

    private int getShort(byte[] data, int offset, boolean bigEndian) {
        int returnShort;
        if (bigEndian) {
            returnShort = data[offset] & 0xFF;
            returnShort = (short)(returnShort << 8) + (data[offset + 1] & 0xFF);
        } else {
            returnShort = data[offset + 1] & 0xFF;
            returnShort = (returnShort << 8) + (data[offset] & 0xFF);
        }
        return returnShort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadPage(Object hDocument, int pageNumber) throws IOException {
        OutsideInDocument document = (OutsideInDocument)hDocument;
        this.trace(document, "loadPage started, page " + pageNumber);
        OutsideInPart part = this.getPartForPage(document, pageNumber);
        if (part == null) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewerEngine.invalidPageNumber", new Object[]{Integer.toString(pageNumber)}));
        }
        OutsideInPage page = null;
        Integer key = new Integer(pageNumber);
        OutsideInDocument outsideInDocument = document;
        synchronized (outsideInDocument) {
            if (document.loadedPages.containsKey(key)) {
                page = document.loadedPages.get(key);
            } else {
                if (document.parts.length == 0) {
                    return null;
                }
                page = new OutsideInPage();
                page.part = part;
                page.documentPageNumber = pageNumber;
                page.partPageNumber = pageNumber - part.firstPageNumber + 1;
                document.loadedPages.put(key, page);
            }
        }
        this.trace(document, "loadPage completed");
        return page;
    }

    public void dropPage(Object hPage) {
    }

    public double getPageMaxScale(Object hPage, String destMimeType) {
        return 500.0;
    }

    public double getPageMinScale(Object hPage, String destMimeType) {
        return 0.1;
    }

    public int getPageXResolution(Object hPage) {
        return 96;
    }

    public int getPageYResolution(Object hPage) {
        return 96;
    }

    public boolean canWritePage(Object hPage, String destMimeType) {
        return destMimeType.equals("image/png");
    }

    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness, OutputStream output, String destMimeType) throws IOException, CMBDocumentEngineException {
        OutsideInPage page = (OutsideInPage)hPage;
        OutsideInPart part = page.part;
        OutsideInDocument document = part.document;
        this.trace(document, "writePage called for page " + page.documentPageNumber + " scale " + scale);
        String tempfileprefix = Long.toString(System.currentTimeMillis());
        File tempOutFile = File.createTempFile(tempfileprefix, null, part.tempDirectory);
        Properties exporterProps = new Properties();
        String exePath = this.getExePath(this.properties);
        if (exePath != null && !exePath.isEmpty()) {
            exporterProps.setProperty("exepath", exePath + "/exporter");
        } else {
            exporterProps.setProperty("exepath", "exporter");
        }
        exporterProps.setProperty("whattoexport", "range");
        exporterProps.setProperty("exportstartpage", Integer.toString(page.partPageNumber));
        exporterProps.setProperty("exportendpage", Integer.toString(page.partPageNumber));
        exporterProps.setProperty("graphicwidth", Integer.toString((int)(816.0 * scale)));
        if (destMimeType.equals("image/tiff")) {
            exporterProps.setProperty("tiffmultipage", "no");
            exporterProps.setProperty("graphicoutputdpi", "200");
            exporterProps.setProperty("tiffcompression", "Packbits");
        } else if (destMimeType.equals("image/png") || destMimeType.equals("image/jpeg") || destMimeType.equals("image/gif") || destMimeType.equals("image/bmp")) {
            exporterProps.setProperty("graphicoutputdpi", "96");
        }
        exporterProps.setProperty("preferoitrendering", isAIX ? "false" : "true");
        Export export = new Export(exporterProps);
        String exportFormat = destMimeType.equals("image/gif") ? "fi_gif" : (destMimeType.equals("image/jpeg") ? "fi_jpeg" : (destMimeType.equals("image/png") ? "fi_png" : "fi_png"));
        ExportStatusCode status = export.convert(part.tempFile.getCanonicalPath(), tempOutFile.getCanonicalPath(), exportFormat, this.timeout);
        if (!status.equals(ExportStatusCode.SCCERR_OK)) {
            throw new CMBDocumentEngineException(status.getCodeText());
        }
        if (rotation == 0 && !invert && brightness == 100 && contrast == 100 && document.annotationSet == null && !withAnnotations) {
            PViewerUtilities.writeFileToStream(tempOutFile, output);
            tempOutFile.delete();
        } else {
            int targetImageHeight;
            int targetImageWidth;
            BufferedImage image = ImageIO.read(tempOutFile);
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (rotation == 1 || rotation == 3) {
                targetImageWidth = imageHeight;
                targetImageHeight = imageWidth;
            } else {
                targetImageWidth = imageWidth;
                targetImageHeight = imageHeight;
            }
            PBrightnessContrastFilter bcFilter = new PBrightnessContrastFilter(brightness, contrast);
            BufferedImage targetImage = new BufferedImage(targetImageWidth, targetImageHeight, 2);
            for (int y = 0; y < imageHeight; ++y) {
                for (int x = 0; x < imageWidth; ++x) {
                    int rgb = image.getRGB(x, y);
                    if (invert) {
                        rgb ^= 0xFFFFFF;
                    }
                    if (brightness != 100 || contrast != 100) {
                        rgb = bcFilter.filterRGB(x, y, rgb);
                    }
                    if (rotation == 1) {
                        targetImage.setRGB(targetImageWidth - y - 1, x, rgb);
                        continue;
                    }
                    if (rotation == 2) {
                        targetImage.setRGB(targetImageWidth - x - 1, targetImageHeight - y - 1, rgb);
                        continue;
                    }
                    if (rotation == 3) {
                        targetImage.setRGB(y, targetImageHeight - x - 1, rgb);
                        continue;
                    }
                    targetImage.setRGB(x, y, rgb);
                }
            }
            Graphics2D graphics = (Graphics2D)targetImage.getGraphics();
            if (document.annotationSet != null && withAnnotations) {
                AffineTransform transformer = new AffineTransform();
                transformer.scale(scale, scale);
                AffineTransform old = graphics.getTransform();
                graphics.setTransform(transformer);
                CMBPageAnnotation[] annotations = document.annotationSet.getPageAnnotations(page.documentPageNumber);
                for (int i = annotations.length - 1; i >= 0; --i) {
                    annotations[i].draw(graphics);
                }
                graphics.setTransform(old);
            }
            if (destMimeType.equals("image/gif")) {
                ImageIO.write((RenderedImage)targetImage, "gif", output);
            } else if (destMimeType.equals("image/jpeg")) {
                ImageIO.write((RenderedImage)targetImage, "jpg", output);
            } else if (destMimeType.equals("image/png")) {
                ImageIO.write((RenderedImage)targetImage, "png", output);
            }
            output.flush();
            tempOutFile.delete();
        }
        this.trace(document, "writePage completed");
    }

    private String getExePath(Properties props) {
        String exePath = "";
        try {
            if (props != null && props.getProperty(EXE_PATH_PROPERTY) != null) {
                exePath = props.getProperty(EXE_PATH_PROPERTY);
                this.trace(null, "exe path from property: " + exePath);
            } else {
                ResourceBundle cfgResource = ResourceBundle.getBundle("ibmcmconfig");
                String workdirLoc = cfgResource.getString("IBMCMWorkingDirectory");
                exePath = workdirLoc + File.separator + "inso";
                this.trace(null, "exe path from ibmcmconfig resource bundle: " + exePath);
            }
        }
        catch (MissingResourceException e) {
            this.trace(null, "use default exe path: " + exePath);
        }
        return exePath;
    }

    private void trace(OutsideInDocument document, String message) {
        if (this.callbacks.traceEnabled()) {
            String qualifiedMessage = "CMBOutsideInExportEngine: " + message;
            if (document != null) {
                qualifiedMessage = qualifiedMessage + " Document: " + document.hashCode();
            }
            this.callbacks.trace(qualifiedMessage);
        }
    }

    public boolean canProvidePageImage(String mimeType) {
        return true;
    }

    public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.writePage(hPage, rotation, scale, enhance, invert, withAnnotations, contrast, brightness, output, "image/png");
        }
        catch (IOException e) {
            throw new CMBDocumentEngineException("Unexpected error", (Object)e);
        }
        Image image = Toolkit.getDefaultToolkit().createImage(output.toByteArray());
        return image;
    }

    public double getPageHeight(Object hPage) {
        OutsideInPage page = (OutsideInPage)hPage;
        if (page.height == 0.0) {
            this.getPageDimensions(page);
        }
        return page.height;
    }

    public double getPageWidth(Object hPage) {
        OutsideInPage page = (OutsideInPage)hPage;
        if (page.width == 0.0) {
            this.getPageDimensions(page);
        }
        return page.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPageDimensions(OutsideInPage page) {
        String mimeType = page.part.document.mimeType;
        if (mimeType.equals("text/plain") || mimeType.equals("text/html") || mimeType.equals("text/xml") || mimeType.equals("text/richtext") || mimeType.equals("application/msword") || mimeType.equals("application/vnd.lotus-wordpro") || mimeType.equals("application/wordperfect5.1")) {
            page.width = 8.5;
            page.height = 11.0;
            return;
        }
        OutsideInPage outsideInPage = page;
        synchronized (outsideInPage) {
            if (page.width > 0.0) {
                return;
            }
            Image pageImage = this.getPageImage(page, 0, 0.020833333333333332, false, false, false);
            JPanel observer = new JPanel();
            try {
                MediaTracker tracker = new MediaTracker(observer);
                tracker.addImage(pageImage, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            page.width = (double)pageImage.getWidth(observer) / 2.0;
            page.height = (double)pageImage.getHeight(observer) / 2.0;
        }
    }

    public boolean canBalancePage(Object hPage) {
        return true;
    }

    public boolean canInvert(Object hDocument, String destMimeType) {
        return true;
    }

    public boolean canRotate(Object hDocument, String destMimeType) {
        return true;
    }

    public boolean canShowAnnotations(Object document, String destMimeType) {
        return true;
    }

    private static synchronized void initializeOiDir() {
        if (oiDir == null) {
            String outsideInTestFile = "ibfpx2.flt";
            String path = System.getenv("Path");
            if (isAIX || path == null) {
                path = System.getenv("PATH");
            }
            if (path != null) {
                StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
                while (st.hasMoreTokens() && oiDir == null) {
                    String pathDir = st.nextToken();
                    try {
                        String pathToFile = pathDir + File.separator + outsideInTestFile;
                        File oiFile = new File(pathToFile);
                        if (!oiFile.exists()) continue;
                        oiDir = pathDir;
                    }
                    catch (Exception exc) {}
                }
            } else {
                oiDir = "";
            }
        }
    }

    private String findFontDirectory() {
        String methodName = "findFontDirectory";
        ViewerLogger.logEntry(this, methodName);
        if (fontDirectory == null && isUnix) {
            fontDirectory = System.getenv("ICN_FONT_DIRECTORY");
            if (fontDirectory != null) {
                ViewerLogger.logDebug(this, methodName, "ICN_FONT_DIRECTORY defined as " + fontDirectory + ".  Checking for existence.");
                File fontDirectoryFonts = new File(fontDirectory);
                if (!fontDirectoryFonts.exists() || !fontDirectoryFonts.isDirectory()) {
                    ViewerLogger.logDebug(this, methodName, "ICN_FONT_DIRECTORY " + fontDirectory + " does not exist.");
                    fontDirectory = null;
                }
            }
            if (fontDirectory == null) {
                boolean oiDirFound = false;
                if (oiDir.length() > 0) {
                    fontDirectory = oiDir + FONTS_PATH;
                    File workDirFonts = new File(fontDirectory);
                    ViewerLogger.logDebug(this, methodName, "Checking for existence of " + fontDirectory + ". (Outside In)");
                    boolean bl = oiDirFound = workDirFonts.exists() && workDirFonts.isDirectory();
                }
                if (!oiDirFound) {
                    ViewerLogger.logDebug(this, methodName, fontDirectory + " does not exist.");
                    String javaHome = System.getenv("JAVA_HOME");
                    if (javaHome != null) {
                        fontDirectory = javaHome + JRE_LIB_FONTS_PATH;
                        ViewerLogger.logDebug(this, methodName, "Checking for existence of " + fontDirectory + " (JAVA_HOME).");
                        File jreFonts = new File(fontDirectory);
                        if (!jreFonts.exists() || !jreFonts.isDirectory()) {
                            ViewerLogger.logDebug(this, methodName, fontDirectory + " does not exist.");
                            fontDirectory = null;
                        }
                    }
                }
            }
            if (fontDirectory == null) {
                ViewerLogger.logError((Object)this, methodName, "No font directory is available for PDF export.  Either set ICN_FONT_DIRECTORY in the environment to a valid location, add a fonts directory under ECMClient/viewingservices/nativelib, or specify a JAVA_HOME that contains jre/lib/fonts.");
            } else {
                ViewerLogger.logInfo(this, methodName, fontDirectory + " exists, and will be used for PDF export.");
            }
        } else {
            ViewerLogger.logInfo(this, methodName, "Windows platform detected.  font directory is not required for PDF export");
        }
        ViewerLogger.logExit(this, methodName);
        return fontDirectory;
    }

    static {
        String osName = System.getProperty("os.name");
        isUnix = !osName.startsWith("Windows");
        isAIX = osName.contains("AIX");
        CMBOutsideInExportEngine.initializeOiDir();
    }

    private class AnnotationServicesCallbacks
    extends CMBAnnotationServicesCallbacks {
        private AnnotationServicesCallbacks() {
        }

        public int addAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData) throws CMBAnnotationEngineException {
            return 0;
        }

        public InputStream getAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
            return null;
        }

        public boolean getPrivilege(CMBAnnotationSet annotationSet, int privilegeID) throws CMBAnnotationEngineException {
            return true;
        }

        public void removeAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
        }

        public void trace(String message) {
        }

        public boolean traceEnabled() {
            return false;
        }

        public void updateAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData, int annotationNumber) throws CMBAnnotationEngineException {
        }
    }

    private class OutsideInPage {
        OutsideInPart part;
        int documentPageNumber;
        int partPageNumber;
        double width;
        double height;

        private OutsideInPage() {
        }
    }

    class OutsideInPart {
        OutsideInDocument document;
        File tempDirectory;
        File partDirectory;
        File tempFile;
        int contentLength;
        int firstPageNumber;
        private int pageCount;
        boolean isDropped;

        OutsideInPart() {
        }

        public boolean containsPage(int pageIndex) throws IOException {
            return pageIndex < this.getPageCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPageCount() throws IOException {
            if (this.pageCount == 0) {
                OutsideInPart outsideInPart = this;
                synchronized (outsideInPart) {
                    if (this.pageCount == 0) {
                        File tempOutFile = File.createTempFile("PageCount", ".tif", this.tempDirectory);
                        Properties exporterProps = new Properties();
                        String exePath = CMBOutsideInExportEngine.this.getExePath(CMBOutsideInExportEngine.this.properties);
                        if (exePath != null && !exePath.isEmpty()) {
                            exporterProps.setProperty("exepath", exePath + "/exporter");
                        } else {
                            exporterProps.setProperty("exepath", "exporter");
                        }
                        exporterProps.setProperty("tiffmultipage", "yes");
                        exporterProps.setProperty("whattoexport", "all");
                        if (isUnix) {
                            exporterProps.setProperty("graphicoutputdpi", "96");
                            exporterProps.setProperty("tiffcompression", "Packbits");
                        } else {
                            exporterProps.setProperty("graphicoutputdpi", "1");
                            exporterProps.setProperty("tiffcompression", "None");
                        }
                        exporterProps.setProperty("preferoitrendering", isAIX ? "false" : "true");
                        Export export = new Export(exporterProps);
                        String exportFormat = "fi_tiff";
                        ExportStatusCode status = export.convert(this.tempFile.getCanonicalPath(), tempOutFile.getCanonicalPath(), exportFormat);
                        if (!status.equals(ExportStatusCode.SCCERR_OK)) {
                            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("StellentExportEngine.outsideInConversionError", new String[]{status.getCodeText()}));
                        }
                        FileInputStream tempOutFileInStream = new FileInputStream(tempOutFile);
                        ByteArrayOutputStream tempTiffDataStream = new ByteArrayOutputStream((int)tempOutFile.length());
                        byte[] buf = new byte[1024];
                        int length = 0;
                        while (length >= 0) {
                            length = ((InputStream)tempOutFileInStream).read(buf);
                            if (length <= 0) continue;
                            tempTiffDataStream.write(buf, 0, length);
                        }
                        ((InputStream)tempOutFileInStream).close();
                        byte[] tempTiffData = tempTiffDataStream.toByteArray();
                        int npages = 0;
                        boolean bigEndian = tempTiffData[0] == 77;
                        int ifdOffset = CMBOutsideInExportEngine.this.getInteger(tempTiffData, 4, bigEndian);
                        while (ifdOffset != 0) {
                            ++npages;
                            int numberOfDirectoryEntries = CMBOutsideInExportEngine.this.getShort(tempTiffData, ifdOffset, bigEndian);
                            ifdOffset = CMBOutsideInExportEngine.this.getInteger(tempTiffData, ifdOffset + 2 + 12 * numberOfDirectoryEntries, bigEndian);
                        }
                        this.pageCount = npages;
                    }
                }
            }
            return this.pageCount;
        }
    }

    private class OutsideInDocument {
        String mimeType;
        CMBAnnotationSet annotationSet;
        int pageCount;
        OutsideInPart[] parts;
        HashMap<Integer, OutsideInPage> loadedPages = new HashMap();

        private OutsideInDocument() {
        }
    }
}

