/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.AFP2HTML;
import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineCallbacks;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.PLargeObjIndexParser;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class CMBODDocumentEngine
extends CMBDocumentEngine {
    private static final int LINE_DATA = 1;
    private static final int AFP_DATA = 2;
    private AFP2HTML _afp2html = null;
    private Hashtable _supportedLoadTypes = new Hashtable();
    private Hashtable _supportedSaveTypes = new Hashtable();
    private Hashtable _dochandles = new Hashtable();
    private Hashtable _pagehandles = new Hashtable();
    private CMBDocumentEngineCallbacks _engCallbacks = null;
    private boolean _afp2web_installed = true;

    public void initialize(CMBDocumentEngineCallbacks callbacks, Properties properties) {
        try {
            System.loadLibrary("afp2webd");
        }
        catch (Throwable t) {
            this._afp2web_installed = false;
        }
        if (this._afp2web_installed) {
            this._afp2html = new AFP2HTML();
        }
        this._props = properties;
        this._engCallbacks = callbacks;
        this._supportedLoadTypes.put("application/afp", "yes");
        this._supportedLoadTypes.put("application/lin", "yes");
        this._supportedLoadTypes.put("application/ondemand line", "yes");
        this._supportedSaveTypes.put("text/html", "yes");
    }

    public void terminate() {
    }

    public boolean isInitialized() {
        if (this._afp2html != null) {
            return this._afp2html.isConverterReady();
        }
        return true;
    }

    public boolean canLoadDocument(String mimeType) {
        return this._supportedLoadTypes.containsKey(mimeType);
    }

    public Object loadDocument(InputStream partStream, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        if (!this._supportedLoadTypes.containsKey(docMimeType)) {
            throw new IllegalArgumentException(docMimeType + ":" + PViewerUtilities.getMessage("DocumentEngine.mimeTypeCannotBeRead"));
        }
        if (numberOfParts < 1) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentEngine.numberOfPartsCannotBeLessOne"));
        }
        DocumentInfo di = new DocumentInfo();
        di.numParts = numberOfParts;
        if (docMimeType.equals("application/afp")) {
            di.type = 2;
        } else if (docMimeType.equals("application/lin") || docMimeType.equals("application/ondemand line")) {
            di.type = 1;
        } else {
            throw new IllegalArgumentException(docMimeType + ":" + PViewerUtilities.getMessage("DocumentEngine.mimeTypeCannotBeRead"));
        }
        if (resourceStream != null) {
            this.trace("Document has resources");
            di.resbuff = CMBODDocumentEngine.getByteArrayFromInputStream(resourceStream);
        }
        if (numberOfParts > 1) {
            this.trace("Document is a large object. It contains more than one part");
            byte[] tblcnt = CMBODDocumentEngine.getByteArrayFromInputStream(partStream);
            this.trace("parsing table of contents:");
            PLargeObjIndexParser plop = new PLargeObjIndexParser();
            plop.parseLargeObjectIndex(tblcnt);
            di.numSegments = plop.getNumSegments();
            di.numPagesPerSegment = plop.getNumPagesPerSeg();
            di.numPagesInLastSegment = plop.getNumPagesLastSeg();
            di.numPages = (di.numSegments - 1) * di.numPagesPerSegment + di.numPagesInLastSegment;
            this.trace("large object document has: " + di.numSegments + " segments," + di.numPagesPerSegment + " pages per segment," + di.numPagesInLastSegment + " pages in the last segment");
            this.trace(di.numPages + " total pages");
            if (di.numSegments != numberOfParts - 1) {
                this.trace("the number of segments deduced from parsing the TOC does not match the number of part claimed to be in the document");
                return null;
            }
        } else {
            int numPages = -1;
            byte[] data = CMBODDocumentEngine.getByteArrayFromInputStream(partStream);
            if (di.type == 2) {
                numPages = this._afp2web_installed ? this._afp2html.getNumberOfPages(data) : -1;
            } else if (di.type == 1) {
                numPages = -1;
            }
            di.numSegments = 1;
            di.numPagesPerSegment = numPages;
            di.numPages = numPages;
            di.numPagesInLastSegment = numPages;
            di.loadedSegments.put("0", this.createSegment(partStream, di, 0, data));
        }
        this._dochandles.put(di, "v");
        return di;
    }

    private SegmentInfo createSegment(InputStream is, DocumentInfo di, int partNumber, byte[] buff) throws IOException {
        if (buff == null) {
            buff = CMBODDocumentEngine.getByteArrayFromInputStream(is);
        }
        SegmentInfo si = new SegmentInfo();
        if (di.resbuff != null && di.resbuff.length > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(di.resbuff);
            baos.write(buff);
            si.data = baos.toByteArray();
        } else {
            si.data = buff;
        }
        if (partNumber == 0) {
            si.startPage = 1;
            si.endPage = di.numPages;
        } else {
            si.startPage = (partNumber - 1) * di.numPagesPerSegment + 1;
            si.endPage = di.numSegments == partNumber - 1 ? si.startPage + di.numPagesInLastSegment - 1 : si.startPage + di.numPagesPerSegment - 1;
        }
        si.owningDoc = di;
        return si;
    }

    public void dropDocument(Object hDocument) {
        if (!this._dochandles.containsKey(hDocument)) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentEngine.invalidDocHandleSupplied"));
        }
        DocumentInfo di = (DocumentInfo)hDocument;
        SegmentInfo si = null;
        Enumeration e = di.loadedSegments.elements();
        while (e.hasMoreElements()) {
            si = (SegmentInfo)e.nextElement();
            if (si.numLoadedPages == 0) continue;
            throw new RuntimeException("document " + di + ":" + PViewerUtilities.getMessage("DocumentEngine.notAllPagesDropped"));
        }
        di.loadedSegments.clear();
        this._dochandles.remove(di);
    }

    public boolean canWriteDocument(String sourceMimeType, String destMimeType) {
        if ((sourceMimeType.equalsIgnoreCase("application/lin") || sourceMimeType.equalsIgnoreCase("application/ondemand line")) && destMimeType.equalsIgnoreCase("text/plain")) {
            return true;
        }
        return sourceMimeType.equals("application/afp") && destMimeType.equals("application/afp");
    }

    public void writeDocument(Object hDocument, String destMimeType, OutputStream output) throws IOException {
        if (!this._dochandles.containsKey(hDocument)) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentEngine.invalidDocHandleSupplied"));
        }
        DocumentInfo di = (DocumentInfo)hDocument;
        if (di.resbuff != null) {
            output.write(di.resbuff);
        }
        SegmentInfo si = null;
        for (int i = 0; i < di.numSegments; ++i) {
            si = (SegmentInfo)di.loadedSegments.get(Integer.toString(i));
            if (si == null) {
                this.trace("OD segment " + i + " has not been loaded yet. Loading now.");
                InputStream partStream = this._engCallbacks.getPart(di, i + 1, null);
                if (partStream == null) {
                    this.trace("Part " + (i + 1) + " could not be obtained");
                    throw new CMBDocumentEngineException("Part " + (i + 1) + " could not be obtained");
                }
                si = this.createSegment(partStream, di, i, null);
            }
            output.write(si.data);
        }
    }

    public boolean canPaginate(String mimeType) {
        if (mimeType.equals("application/afp")) {
            return this._afp2web_installed;
        }
        return false;
    }

    public int getNumberOfPages(Object hDocument) {
        if (!this._dochandles.containsKey(hDocument)) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentEngine.invalidDocHandleSupplied"));
        }
        return ((DocumentInfo)hDocument).numPages;
    }

    public Object loadPage(Object hDocument, int page) throws IOException {
        if (!this._dochandles.containsKey(hDocument)) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentEngine.invalidDocHandleSupplied"));
        }
        DocumentInfo di = (DocumentInfo)hDocument;
        if (page > di.numPages) {
            this.trace("page " + page + " does not exist in this document:" + hDocument);
            return null;
        }
        PageInfo pgi = new PageInfo();
        pgi.page = page;
        SegmentInfo si = null;
        boolean bFound = false;
        Enumeration e = di.loadedSegments.elements();
        while (e.hasMoreElements()) {
            si = (SegmentInfo)e.nextElement();
            if (!si.hasPage(page)) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            int partPageIsIn;
            int n = partPageIsIn = di.numSegments > 1 ? (page - 1) / di.numPagesPerSegment + 1 : 0;
            if (partPageIsIn == 0) {
                this.trace("Problem: page " + page + " is said to be in part 0, but this part must have been loaded in LoadDocument()");
                return null;
            }
            InputStream partStream = this._engCallbacks.getPart(di, partPageIsIn, null);
            if (partStream == null) {
                this.trace("part in which page " + page + " is in could not be obtained");
                return null;
            }
            si = this.createSegment(partStream, di, partPageIsIn, null);
            di.loadedSegments.put(Integer.toString(partPageIsIn - 1), si);
        }
        pgi.si = si;
        ++si.numLoadedPages;
        this._pagehandles.put(pgi, "v");
        return pgi;
    }

    public void dropPage(Object hPage) {
        if (!this._pagehandles.containsKey(hPage)) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentEngine.invalidPageHandleSupplied"));
        }
        --((PageInfo)hPage).si.numLoadedPages;
        this._pagehandles.remove(hPage);
    }

    public double getPageWidth(Object hPage) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public double getPageHeight(Object hPage) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean canRotate(Object hDocument, String destMimeType) {
        DocumentInfo di = (DocumentInfo)hDocument;
        return di.type == 2 && destMimeType.equals("text/html");
    }

    public double getPageMinScale(Object hPage, String destMimeType) {
        return 0.01;
    }

    public double getPageMaxScale(Object hPage, String destMimeType) {
        return 2.0;
    }

    public boolean canEnhance(Object hDocument, String destMimeType) {
        return false;
    }

    public boolean canInvert(Object hDocument, String destMimeType) {
        return false;
    }

    public boolean canShowAnnotations(Object hDocument, String destMimeType) {
        return false;
    }

    public boolean canWritePage(String sourceMimeType, String destMimeType) {
        return sourceMimeType.equals("application/afp");
    }

    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType, String resourcePrefix) throws IOException, CMBDocumentEngineException {
        if (!this._pagehandles.containsKey(hPage)) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentEngine.invalidPageHandleSupplied"));
        }
        if (!this._supportedSaveTypes.containsKey(destMimeType)) {
            throw new IllegalArgumentException(destMimeType + ":" + PViewerUtilities.getMessage("DocumentEngine.mimeTypeCannotBeWritten"));
        }
        PageInfo pgi = (PageInfo)hPage;
        byte[] segment = pgi.si.data;
        int type = pgi.si.owningDoc.type;
        if (destMimeType.equals("text/html")) {
            if (type == 1) {
                throw new IllegalArgumentException("DocumentEngine.notSupported");
            }
            int rot = 0;
            switch (rotation) {
                case 0: {
                    rot = 0;
                    break;
                }
                case 1: {
                    rot = 90;
                    break;
                }
                case 2: {
                    rot = 180;
                    break;
                }
                case 3: {
                    rot = 270;
                }
            }
            int pageInSegment = pgi.page - pgi.si.startPage + 1;
            byte[] html = this._afp2html.getHTML(segment, true, pageInSegment, rot, resourcePrefix + "IMG1.gif", (float)scale);
            String strHtml = new String(html);
            int imageBegin = strHtml.indexOf("<IMG SRC=");
            if (imageBegin != -1) {
                String patchedHtml = strHtml.substring(0, imageBegin);
                patchedHtml = patchedHtml + "<IMG SRC=\"" + resourcePrefix + "IMG1.gif";
                patchedHtml = patchedHtml + strHtml.substring(strHtml.indexOf(34, strHtml.indexOf(63, imageBegin)));
                html = patchedHtml.getBytes();
            }
            output.write(html);
        }
    }

    public String getPageResourceMimeType(Object hPage, String resourceId) {
        return "image/gif";
    }

    public void writePageResource(Object hPage, String resourceId, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output) throws IOException, CMBDocumentEngineException {
        if (!this._pagehandles.containsKey(hPage)) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentEngine.invalidPageHandleSupplied"));
        }
        PageInfo pgi = (PageInfo)hPage;
        byte[] segment = pgi.si.data;
        int type = pgi.si.owningDoc.type;
        if (type == 1) {
            throw new IllegalArgumentException("DocumentEngine.notSupported");
        }
        int rot = 0;
        switch (rotation) {
            case 0: {
                rot = 0;
                break;
            }
            case 1: {
                rot = 90;
                break;
            }
            case 2: {
                rot = 180;
                break;
            }
            case 3: {
                rot = 270;
            }
        }
        int pageInSegment = pgi.page - pgi.si.startPage + 1;
        byte[] gif = this._afp2html.getGif(segment, true, pageInSegment, rot, "", (float)scale);
        if (gif != null) {
            output.write(gif);
        }
    }

    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType) throws IOException {
        if (!this._pagehandles.containsKey(hPage)) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentEngine.invalidPageHandleSupplied"));
        }
        if (!this._supportedSaveTypes.containsKey(destMimeType)) {
            throw new IllegalArgumentException(destMimeType + ":" + PViewerUtilities.getMessage("DocumentEngine.mimeTypeCannotBeWritten"));
        }
        PageInfo pgi = (PageInfo)hPage;
        byte[] segment = pgi.si.data;
        int type = pgi.si.owningDoc.type;
        if (destMimeType.equals("text/html")) {
            if (type == 1) {
                throw new IllegalArgumentException("DocumentEngine.notSupported");
            }
            int rot = 0;
            switch (rotation) {
                case 0: {
                    rot = 0;
                    break;
                }
                case 1: {
                    rot = 90;
                    break;
                }
                case 2: {
                    rot = 180;
                    break;
                }
                case 3: {
                    rot = 270;
                }
            }
            int pageInSegment = pgi.page - pgi.si.startPage + 1;
            byte[] html = this._afp2html.getHTML(segment, true, pageInSegment, rot, "THEGIF.gif", (float)scale);
            byte[] gif = this._afp2html.getGif(segment, true, pageInSegment, rot, "THEGIF.gif", (float)scale);
            output.write(html);
            if (gif != null) {
                output.write(gif);
            }
        }
    }

    public boolean canWriteDocumentFromPages(String sourceMimeType, String destMimeType) {
        return false;
    }

    public void writeDocumentFromPages(Object hDocument, int startingPage, int endingPage, String destMimeType, OutputStream output, boolean withAnnotations) throws IOException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean canProvidePageImage(String mimeType) {
        return false;
    }

    public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    boolean canTabulate(String mimeType) {
        return false;
    }

    int getTableRows(Object hDocument) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    int getTableColumns(Object hDocument) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    int getRowsPerPage(Object hDocument) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    String getHeaderText(Object hDocument, int column) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    String getCellText(Object hDocument, int row, int column) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    String[] getRowsText(Object hDocument, int startRow, int endRow) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    int getPreferredColumnWidth(Object hDocument, int column) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    private void trace(String msg) {
        if (this._engCallbacks.traceEnabled()) {
            this._engCallbacks.trace(msg);
        }
    }

    private static byte[] getByteArrayFromInputStream(InputStream is) throws IOException {
        int readInt;
        byte[] buffer = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((readInt = is.read()) > -1) {
            bos.write(readInt);
        }
        bos.flush();
        buffer = bos.toByteArray();
        bos.close();
        return buffer;
    }

    private class PageInfo {
        public int page = -1;
        public SegmentInfo si = null;

        private PageInfo() {
        }
    }

    private class DocumentInfo {
        public int type = -1;
        public Hashtable loadedSegments = new Hashtable();
        public int numParts = 0;
        public byte[] resbuff = null;
        public int numSegments = 0;
        public int numPagesPerSegment = 0;
        public int numPagesInLastSegment = 0;
        public int numPages = 0;

        private DocumentInfo() {
        }
    }

    private class SegmentInfo {
        public byte[] data = null;
        public int startPage = -1;
        public int endPage = -1;
        public DocumentInfo owningDoc = null;
        public int numLoadedPages = 0;

        private SegmentInfo() {
        }

        public boolean hasPage(int p) {
            return this.endPage >= p && this.startPage <= p;
        }
    }
}

