/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBLetter;
import com.ibm.mm.viewer.CMBLetters;
import com.ibm.mm.viewer.CMBOCRLetter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class CMBOCRLetters
extends CMBLetters {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private boolean ocrConfident = true;

    public CMBOCRLetters(CMBOCRLetter[] letterArray, int recognitionTolerance) {
        super(letterArray);
        this.ocrConfident = this.isOcrConfident(recognitionTolerance);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init() {
        if (!this.debug) return;
        FileOutputStream os = null;
        File tempFile = File.createTempFile("cmbocrletters", "xml");
        os = new FileOutputStream(tempFile);
        this.serializeAsXML(os);
        Object var4_4 = null;
        if (os == null) return;
        try {
            os.close();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (IOException e) {
                e.printStackTrace();
                Object var4_5 = null;
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    void disposeOCRLetters() {
        super.disposeLetters();
    }

    public boolean isOcrConfident() {
        return this.ocrConfident;
    }

    boolean isOcrConfident(int recognitionTolerance) {
        int letterCount = 0;
        for (int i = 0; i < this.letters.length; ++i) {
            CMBLetter l = this.letters[i];
            short letterConfidence = l.getConfidence();
            if (letterConfidence >= recognitionTolerance) continue;
            ++letterCount;
        }
        double accuracy = 100.0 - 100.0 * ((double)letterCount / (double)this.letters.length);
        return accuracy >= (double)recognitionTolerance;
    }
}

