/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class CMBOCREngineCallback {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    Properties engineProperties;
    private static String EXE_PATH_PROPERTY = "OCRENGINE_exePath";

    public CMBOCREngineCallback(Properties engineProperties) {
        this.engineProperties = engineProperties;
    }

    public boolean traceEnabled() {
        return false;
    }

    public void trace(String message) {
        if (this.traceEnabled()) {
            System.out.println("CMBOCREngineCallback:" + message);
        }
    }

    public String deployNativeLibrary(String nativeLibName) {
        String methodName = "deployNativeLibrary";
        String exePath = this.engineProperties.getProperty(EXE_PATH_PROPERTY, null);
        if (exePath == null) {
            return null;
        }
        try {
            String destPath = this.getNativeLibraryDeployPath();
            if (!this.isVersionDifferent(nativeLibName)) {
                return destPath;
            }
            URL jarURL = new URL("jar:file:///" + exePath + System.getProperty("file.separator") + nativeLibName + "!/");
            JarURLConnection jarLib = (JarURLConnection)jarURL.openConnection();
            JarFile jarLibFile = jarLib.getJarFile();
            Enumeration<JarEntry> enuJarEntries = jarLibFile.entries();
            int fileIndex = 0;
            while (enuJarEntries.hasMoreElements()) {
                JarEntry jeOneFile = enuJarEntries.nextElement();
                File flOneFile = new File(destPath + System.getProperty("file.separator") + jeOneFile.toString());
                if (jeOneFile.isDirectory()) {
                    if (flOneFile.exists()) continue;
                    flOneFile.mkdir();
                    continue;
                }
                ++fileIndex;
                CheckedInputStream cisOneFile = new CheckedInputStream(jarLibFile.getInputStream(jeOneFile), new CRC32());
                try {
                    int numRead;
                    FileOutputStream fos = new FileOutputStream(flOneFile);
                    int bufsize = 4096;
                    byte[] buf = new byte[bufsize];
                    for (int fsize = (int)jeOneFile.getSize(); fsize > 0; fsize -= numRead) {
                        numRead = fsize > bufsize ? cisOneFile.read(buf, 0, bufsize) : cisOneFile.read(buf, 0, fsize);
                        fos.write(buf, 0, numRead);
                    }
                    fos.flush();
                    fos.close();
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
                cisOneFile.close();
            }
            FileOutputStream wManifestFile = new FileOutputStream(destPath + System.getProperty("file.separator") + nativeLibName + ".manifest");
            this.trace("deployNativeLibrary:Updating manifest file in " + destPath + System.getProperty("file.separator") + nativeLibName + ".manifest");
            Manifest cManifest = jarLibFile.getManifest();
            if (cManifest != null) {
                cManifest.write(wManifestFile);
            }
            wManifestFile.close();
            this.trace("deployNativeLibrary:Deploy finished of " + nativeLibName + " to " + destPath);
            return destPath;
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            throw new CMBDocumentEngineException(e.getMessage());
        }
    }

    private boolean isVersionDifferent(String nativeLibName) throws IOException {
        String exePath = this.engineProperties.getProperty(EXE_PATH_PROPERTY, null);
        if (exePath == null) {
            return false;
        }
        String destPath = this.getNativeLibraryDeployPath();
        URL jarURL = new URL("jar:file:///" + exePath + System.getProperty("file.separator") + nativeLibName + "!/");
        JarURLConnection jarLib = (JarURLConnection)jarURL.openConnection();
        JarFile jarLibFile = jarLib.getJarFile();
        boolean bDiffVersion = true;
        Manifest cManifest = jarLibFile.getManifest();
        Attributes cAttr = cManifest.getMainAttributes();
        String cVersion = cAttr.getValue("Implementation-Version");
        FileInputStream oManifestFile = null;
        try {
            oManifestFile = new FileInputStream(destPath + System.getProperty("file.separator") + nativeLibName + ".manifest");
        }
        catch (FileNotFoundException e) {
            bDiffVersion = true;
            return bDiffVersion;
        }
        if (oManifestFile != null) {
            Manifest oManifest = new Manifest(oManifestFile);
            Attributes oAttr = oManifest.getMainAttributes();
            String oVersion = oAttr.getValue("Implementation-Version");
            if (oVersion.compareToIgnoreCase(cVersion) == 0) {
                bDiffVersion = false;
            }
            oManifestFile.close();
        }
        return bDiffVersion;
    }

    private String getNativeLibraryDeployPath() {
        String binExt = System.getProperty("java.home") + System.getProperty("file.separator") + "bin";
        File binExtDir = new File(binExt);
        if (!binExtDir.exists()) {
            binExtDir.mkdir();
        }
        return binExt;
    }
}

