/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocOCRStatusEvent;
import com.ibm.mm.viewer.CMBGenericDocOCRStatusListener;
import com.ibm.mm.viewer.CMBOCREngineCallback;
import com.ibm.mm.viewer.CMBOCRLetters;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.CMBViewerConstants;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class CMBOCREngine
implements CMBViewerConstants {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBOCREngineCallback callback;
    private Properties engineProperties;
    private CopyOnWriteArrayList<CMBGenericDocOCRStatusListener> statusListeners = new CopyOnWriteArrayList();

    public CMBOCREngine(CMBOCREngineCallback callback, Properties engineProperties) {
        this.engineProperties = engineProperties;
    }

    public CMBOCREngine(Properties engineProperties) {
        this.engineProperties = engineProperties;
        this.callback = new CMBOCREngineCallback(engineProperties);
    }

    public abstract void initialize();

    public abstract void terminate();

    public abstract boolean isInitialized();

    public boolean canOcrDocument(CMBDocument document) {
        return false;
    }

    public abstract CMBOCRLetters[] ocrDocument(CMBDocument var1);

    public abstract void cancelOCR(CMBDocument var1);

    public abstract CMBOCRLetters ocrPage(CMBPage var1);

    public abstract void dropOCRPage(CMBPage var1);

    public CMBOCREngineCallback getCallback() {
        return this.callback;
    }

    public Properties getEngineProperties() {
        return this.engineProperties;
    }

    public void addOCRStatusListener(CMBGenericDocOCRStatusListener listener) {
        this.statusListeners.add(listener);
    }

    public void removeStatusListener(CMBGenericDocOCRStatusListener listener) {
        this.statusListeners.remove(listener);
    }

    public void fireStatusEvent(int eventType, CMBDocument document, CMBPage page, CMBOCRLetters letters) {
        CMBGenericDocOCRStatusEvent event = new CMBGenericDocOCRStatusEvent(this, eventType, document, page, letters);
        for (int i = 0; i < this.statusListeners.size(); ++i) {
            CMBGenericDocOCRStatusListener listener = this.statusListeners.get(i);
            listener.ocrStatusChanged(event);
        }
    }
}

