/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineCallbacks;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationServicesCallbacks;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class CMBMixedDocumentEngine
extends CMBDocumentEngine {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBDocumentEngineCallbacks _callbacks;
    private SubengineCallbacks _subEngineCallbacks = new SubengineCallbacks();
    private Properties _properties;
    private boolean _initialized = false;
    private CMBDocumentEngine[] _subengines;
    private String[] _subEnginesMimeTypes;
    private Hashtable _subengineDocumentToPartMap = new Hashtable();
    CMBAnnotationServices annotationServices;

    public void initialize(CMBDocumentEngineCallbacks callbacks, Properties properties) {
        this._callbacks = callbacks;
        this._properties = properties;
        String subenginesProperty = properties.getProperty("SUBENGINES");
        if (subenginesProperty == null) {
            throw new CMBDocumentEngineException("The required engine property, SUBENGINES, was not specified for CMBMixedDocumentEngine.");
        }
        String[] subengineNames = this.parseSubEnginesProperty(subenginesProperty);
        this.loadSubEngines(subengineNames);
        this.initializeSubengines();
        this.annotationServices = new CMBAnnotationServices(new AnnotationServicesCallbacks());
        this._initialized = true;
    }

    private String[] parseSubEnginesProperty(String subenginesProperty) {
        StringTokenizer tokenizer = new StringTokenizer(subenginesProperty, " ,\t\n\r\f");
        String[] subengineNames = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            subengineNames[i] = tokenizer.nextToken();
            ++i;
        }
        return subengineNames;
    }

    private void loadSubEngines(String[] subengineNames) {
        this._subengines = new CMBDocumentEngine[subengineNames.length];
        for (int i = 0; i < subengineNames.length; ++i) {
            try {
                Class<?> engineClass = Class.forName(subengineNames[i]);
                this._subengines[i] = (CMBDocumentEngine)engineClass.newInstance();
                continue;
            }
            catch (Exception e) {
                throw new CMBDocumentEngineException("The sub-engine, " + subengineNames[i] + ", could not be instantiated: " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        this._subEnginesMimeTypes = new String[subengineNames.length];
    }

    private void initializeSubengines() {
        for (int i = 0; i < this._subengines.length; ++i) {
            if (this._subengines[i].isInitialized()) continue;
            this._subengines[i].initialize(this._subEngineCallbacks, this._properties);
        }
    }

    public void terminate() {
        for (int i = 0; i < this._subengines.length; ++i) {
            if (!this._subengines[i].isInitialized()) continue;
            this._subengines[i].terminate();
        }
        this._initialized = false;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public boolean canLoadDocument(String mimeType) {
        return mimeType.equals("multipart/mixed");
    }

    public Object loadDocument(InputStream partStream, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        EngineDocument document = new EngineDocument();
        document.mimeType = docMimeType;
        document.parts = new EnginePart[numberOfParts];
        if (annotationStream != null) {
            try {
                document.annotationSet = this.annotationServices.loadAnnotationSet(annotationStream, "application/vnd.ibm.modcap", 1400, 1, 0);
            }
            catch (Exception e) {
                throw new CMBDocumentEngineException("A problem occured parsing the annotations", (Object)e);
            }
        }
        this.loadPart(document, 0, partStream, partMimeType, resourceStream);
        if (document.annotationSet != null) {
            document.annotationSet.setAnnotationPosition(this.getAnnotationPosition(document));
            System.out.println(this.getAnnotationPosition(document));
        }
        return document;
    }

    private CMBDocumentEngine getEngineForPart(String partMimeType) {
        for (int i = 0; i < this._subengines.length; ++i) {
            if (!this._subengines[i].canLoadDocument(partMimeType)) continue;
            this._subEnginesMimeTypes[i] = partMimeType;
            return this._subengines[i];
        }
        throw new CMBDocumentEngineException("Part of mimetype " + partMimeType + " cannot be loaded by any subengine");
    }

    private void loadPart(EngineDocument document, int partNumber, InputStream partStream, String partMimeType, InputStream resourceStream) throws IOException {
        String methodName = "loadPart";
        EnginePart part = new EnginePart();
        part.document = document;
        part.mimeType = partMimeType;
        part.partNumber = partNumber;
        part.subengine = this.getEngineForPart(partMimeType);
        part.firstPageNumber = partNumber == 0 ? 1 : document.parts[partNumber - 1].firstPageNumber + document.parts[partNumber - 1].subengine.getNumberOfPages(document.parts[partNumber - 1].subengineDocument);
        if (partStream == null) {
            StringBuffer partMimeTypeBuf = new StringBuffer();
            partStream = this._callbacks.getPart(document, partNumber, partMimeTypeBuf);
            partMimeType = partMimeTypeBuf.toString();
        }
        ByteArrayInputStream subAnnotationStream = null;
        if (document.annotationSet != null) {
            try {
                CMBAnnotationSet subAnnotationSet = this.annotationServices.loadAnnotationSet(null, "application/vnd.ibm.modcap", 1400, 1, 0);
                for (int i = 0; i < document.annotationSet.getAnnotationCount(); ++i) {
                    CMBPageAnnotation annotation = document.annotationSet.getAnnotationAt(i);
                    if (annotation.getPageNumber() < part.firstPageNumber) continue;
                    CMBPageAnnotation subAnnotation = (CMBPageAnnotation)annotation.clone();
                    subAnnotation.setPageNumber(subAnnotation.getPageNumber() - part.firstPageNumber + 1);
                    subAnnotationSet.addAnnotation(subAnnotation);
                }
                ByteArrayOutputStream outAnnotationStream = new ByteArrayOutputStream();
                subAnnotationSet.write(outAnnotationStream);
                outAnnotationStream.close();
                subAnnotationStream = new ByteArrayInputStream(outAnnotationStream.toByteArray());
            }
            catch (Exception e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
        }
        part.subengineDocument = part.subengine.loadDocument(partStream, 1, partMimeType, partMimeType, subAnnotationStream, resourceStream);
        this._subengineDocumentToPartMap.put(part.subengineDocument, part);
        document.parts[partNumber] = part;
    }

    public void dropDocument(Object hDocument) {
        EngineDocument document = (EngineDocument)hDocument;
        for (int i = 0; i < document.parts.length; ++i) {
            if (document.parts[i] == null) continue;
            document.parts[i].subengine.dropDocument(document.parts[i].subengineDocument);
            this._subengineDocumentToPartMap.remove(document.parts[i].subengineDocument);
            document.parts[i] = null;
        }
    }

    public boolean canWriteDocument(String sourceMimeType, String destMimeType) {
        return false;
    }

    public boolean canPaginate(String mimeType) {
        return true;
    }

    public int getNumberOfPages(Object hDocument) throws IOException {
        EngineDocument document = (EngineDocument)hDocument;
        this.loadAllParts(document);
        int pageCount = 0;
        for (int i = 0; i < document.parts.length; ++i) {
            pageCount += document.parts[i].subengine.getNumberOfPages(document.parts[i].subengineDocument);
        }
        return pageCount;
    }

    private void loadAllParts(EngineDocument document) throws IOException {
        for (int i = 0; i < document.parts.length; ++i) {
            if (document.parts[i] != null) continue;
            StringBuffer partMimeType = new StringBuffer();
            this.loadPart(document, i, this._callbacks.getPart(document, i, partMimeType), partMimeType.toString(), this._callbacks.getResources(document));
        }
    }

    public Object loadPage(Object hDocument, int pageNumber) throws IOException {
        EngineDocument document = (EngineDocument)hDocument;
        EnginePart part = null;
        int pageCount = 0;
        for (int i = 0; part == null && i < document.parts.length; ++i) {
            int partPageCount;
            if (document.parts[i] == null) {
                StringBuffer partMimeType = new StringBuffer();
                this.loadPart(document, i, this._callbacks.getPart(document, i, partMimeType), partMimeType.toString(), this._callbacks.getResources(document));
            }
            if ((partPageCount = document.parts[i].subengine.getNumberOfPages(document.parts[i].subengineDocument)) + pageCount >= pageNumber) {
                part = document.parts[i];
                continue;
            }
            pageCount += partPageCount;
        }
        EnginePage page = new EnginePage();
        page.document = document;
        page.originalPageNumber = pageNumber;
        page.part = part;
        page.partPageNumber = pageNumber - pageCount;
        page.subenginePage = part.subengine.loadPage(part.subengineDocument, page.partPageNumber);
        return page;
    }

    public void dropPage(Object hPage) {
        EnginePage page = (EnginePage)hPage;
        page.part.subengine.dropPage(page.subenginePage);
    }

    public double getPageWidth(Object hPage) {
        EnginePage page = (EnginePage)hPage;
        CMBDocumentEngine subEngine = page.part.subengine;
        double width = subEngine.getPageWidth(page.subenginePage);
        if (subEngine.getClass().getName().equals("com.ibm.mm.viewer.mstech.CMBMSTechDocumentEngine") || subEngine.getClass().getName().equals("com.ibm.mm.viewer.inso.CMBMSTechInsoEngine")) {
            width /= (double)this.getPageXResolution(hPage);
        }
        return width;
    }

    public double getPageHeight(Object hPage) {
        EnginePage page = (EnginePage)hPage;
        CMBDocumentEngine subEngine = page.part.subengine;
        double height = subEngine.getPageHeight(page.subenginePage);
        if (subEngine.getClass().getName().equals("com.ibm.mm.viewer.mstech.CMBMSTechDocumentEngine") || subEngine.getClass().getName().equals("com.ibm.mm.viewer.inso.CMBMSTechInsoEngine")) {
            height /= (double)this.getPageYResolution(hPage);
        }
        return height;
    }

    public double getPageMinScale(Object hPage, String destMimeType) {
        EnginePage page = (EnginePage)hPage;
        return page.part.subengine.getPageMinScale(page.subenginePage, destMimeType);
    }

    public double getPageMaxScale(Object hPage, String destMimeType) {
        EnginePage page = (EnginePage)hPage;
        return page.part.subengine.getPageMaxScale(page.subenginePage, destMimeType);
    }

    public int getAnnotationPosition(Object hDocument) {
        EngineDocument document = (EngineDocument)hDocument;
        return document.parts[0].subengine.getAnnotationPosition(document.parts[0].subengineDocument);
    }

    public int getPageXResolution(Object hPage) {
        EnginePage page = (EnginePage)hPage;
        return page.part.subengine.getPageXResolution(page.subenginePage);
    }

    public int getPageYResolution(Object hPage) {
        EnginePage page = (EnginePage)hPage;
        return page.part.subengine.getPageYResolution(page.subenginePage);
    }

    public boolean canRotate(Object hDocument, String destMimeType) {
        EngineDocument document = (EngineDocument)hDocument;
        try {
            this.loadAllParts(document);
        }
        catch (IOException e) {
            throw new CMBDocumentEngineException("Exception in subengine: " + e.getClass().getName() + ": " + e.getMessage());
        }
        for (int i = 0; i < document.parts.length; ++i) {
            if (document.parts[i].subengine.canRotate(document.parts[i].subengineDocument, destMimeType)) continue;
            return false;
        }
        return true;
    }

    public boolean canEnhance(Object hDocument, String destMimeType) {
        EngineDocument document = (EngineDocument)hDocument;
        try {
            this.loadAllParts(document);
        }
        catch (IOException e) {
            throw new CMBDocumentEngineException("Exception in subengine: " + e.getClass().getName() + ": " + e.getMessage());
        }
        for (int i = 0; i < document.parts.length; ++i) {
            if (document.parts[i].subengine.canEnhance(document.parts[i].subengineDocument, destMimeType)) continue;
            return false;
        }
        return true;
    }

    public boolean canInvert(Object hDocument, String destMimeType) {
        EngineDocument document = (EngineDocument)hDocument;
        try {
            this.loadAllParts(document);
        }
        catch (IOException e) {
            throw new CMBDocumentEngineException("Exception in subengine: " + e.getClass().getName() + ": " + e.getMessage());
        }
        for (int i = 0; i < document.parts.length; ++i) {
            if (document.parts[i].subengine.canInvert(document.parts[i].subengineDocument, destMimeType)) continue;
            return false;
        }
        return true;
    }

    public boolean canShowAnnotations(Object hDocument, String destMimeType) {
        return false;
    }

    public boolean canWritePage(Object hPage, String destMimeType) {
        EnginePage page = (EnginePage)hPage;
        return page.part.subengine.canWritePage(page.subenginePage, destMimeType);
    }

    public boolean canWritePage(String srcMimeType, String destMimeType) {
        return destMimeType.equals("image/gif") || destMimeType.equals("image/jpeg") || destMimeType.equals("image/png");
    }

    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType) throws IOException {
        EnginePage page = (EnginePage)hPage;
        page.part.subengine.writePage(page.subenginePage, rotation, scale, enhance, invert, withAnnotations, output, destMimeType);
    }

    public boolean canWriteDocumentFromPages(String sourceMimeType, String destMimeType) {
        return false;
    }

    public boolean canProvidePageImage(String mimeType) {
        return true;
    }

    public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations) {
        EnginePage page = (EnginePage)hPage;
        Image image = page.part.subengine.getPageImage(page.subenginePage, rotation, scale, enhance, invert, withAnnotations);
        return image;
    }

    private class AnnotationServicesCallbacks
    extends CMBAnnotationServicesCallbacks {
        private AnnotationServicesCallbacks() {
        }

        public int addAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData) throws CMBAnnotationEngineException {
            return 0;
        }

        public InputStream getAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
            return null;
        }

        public boolean getPrivilege(CMBAnnotationSet annotationSet, int privilegeID) throws CMBAnnotationEngineException {
            return true;
        }

        public void removeAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
        }

        public void trace(String message) {
            CMBMixedDocumentEngine.this._callbacks.trace(message);
        }

        public boolean traceEnabled() {
            return CMBMixedDocumentEngine.this._callbacks.traceEnabled();
        }

        public void updateAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData, int annotationNumber) throws CMBAnnotationEngineException {
        }
    }

    private class SubengineCallbacks
    extends CMBDocumentEngineCallbacks {
        private SubengineCallbacks() {
        }

        public InputStream getForm(Object hDocument, String formName) {
            EnginePart part = (EnginePart)CMBMixedDocumentEngine.this._subengineDocumentToPartMap.get(hDocument);
            return CMBMixedDocumentEngine.this._callbacks.getForm(part.document, formName);
        }

        public int getFormSize(Object hDocument, String formName) {
            EnginePart part = (EnginePart)CMBMixedDocumentEngine.this._subengineDocumentToPartMap.get(hDocument);
            return CMBMixedDocumentEngine.this._callbacks.getFormSize(part.document, formName);
        }

        public InputStream getPart(Object hDocument, int partNumber, StringBuffer outMimeType) {
            EnginePart part = (EnginePart)CMBMixedDocumentEngine.this._subengineDocumentToPartMap.get(hDocument);
            if (partNumber > 0) {
                throw new CMBDocumentEngineException("Internal engine error.  Non-zero part number.");
            }
            return CMBMixedDocumentEngine.this._callbacks.getPart(part.document, part.partNumber, outMimeType);
        }

        public int getPartSize(Object hDocument, int partNumber) {
            EnginePart part = (EnginePart)CMBMixedDocumentEngine.this._subengineDocumentToPartMap.get(hDocument);
            if (partNumber > 0) {
                throw new CMBDocumentEngineException("Internal engine error.  Non-zero part number.");
            }
            return CMBMixedDocumentEngine.this._callbacks.getPartSize(part.document, part.partNumber);
        }

        public InputStream getAnnotation(Object hDocument, int annotationNumber) {
            return null;
        }

        public InputStream getResources(Object hDocument) {
            EnginePart part = (EnginePart)CMBMixedDocumentEngine.this._subengineDocumentToPartMap.get(hDocument);
            return CMBMixedDocumentEngine.this._callbacks.getResources(part.document);
        }

        public boolean traceEnabled() {
            return CMBMixedDocumentEngine.this._callbacks.traceEnabled();
        }

        public void trace(String message) {
            CMBMixedDocumentEngine.this._callbacks.trace(message);
        }
    }

    private class EnginePage {
        public EngineDocument document;
        public int originalPageNumber;
        public EnginePart part;
        public int partPageNumber;
        public Object subenginePage;

        private EnginePage() {
        }
    }

    private class EnginePart {
        public String mimeType;
        public EngineDocument document;
        public int partNumber;
        public CMBDocumentEngine subengine;
        public Object subengineDocument;
        public CMBAnnotationSet subAnnotationSet;
        public int firstPageNumber;

        private EnginePart() {
        }
    }

    private class EngineDocument {
        public String mimeType;
        public EnginePart[] parts;
        public CMBAnnotationSet annotationSet;

        private EngineDocument() {
        }
    }
}

