/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineCallbacks;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationServicesCallbacks;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class CMBLineDataEngine
extends CMBDocumentEngine {
    private static final int X_RESOLUTION = 72;
    private static final int Y_RESOLUTION = 72;
    private static final double PAGE_WIDTH = 14.0;
    private static final double PAGE_HEIGHT = 11.0;
    private static final int CHAR_HEIGHT = 10;
    private static final int CHAR_WIDTH = 8;
    private static final double TOP_MARGIN = 0.5;
    private static final double LEFT_MARGIN = 0.5;
    private static final double BOTTOM_MARGIN = 0.5;
    private static final double RIGHT_MARGIN = 0.5;
    private static final double MAX_SCALE = 10.0;
    private static final double MIN_SCALE = 0.1;
    private static final int LINES_PER_PAGE = 80;
    private static final int COLUMNS_PER_LINE = 133;
    boolean initialized;
    CMBDocumentEngineCallbacks callbacks;
    Properties properties;
    CMBAnnotationServices annotationServices;
    private boolean useDrawPage;

    public void initialize(CMBDocumentEngineCallbacks callbacks, Properties properties) {
        this.properties = properties;
        this.callbacks = callbacks;
        this.useDrawPage = Boolean.valueOf(properties.getProperty("useDrawPage", "true"));
        this.annotationServices = new CMBAnnotationServices(new AnnotationServicesCallbacks());
        this.initialized = true;
    }

    public void terminate() {
        this.initialized = false;
        this.annotationServices.terminate();
        this.properties = null;
        this.callbacks = null;
        this.annotationServices = null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean canLoadDocument(String mimeType) {
        return mimeType.equals("application/line");
    }

    public Object loadDocument(InputStream partStream, int partStreamSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
        return this.loadDocument(partStream, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream, firstPartEncoding);
    }

    public Object loadDocument(InputStream partStream, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
        LineDataDocument document = new LineDataDocument();
        document.parts = new LineDataPart[numberOfParts];
        this.loadPart(document, 0, partStream, partMimeType, firstPartEncoding);
        if (annotationStream != null) {
            try {
                document.annotationSet = this.annotationServices.loadAnnotationSet(annotationStream, "application/vnd.ibm.modcap", this.getAnnotationPosition(document), 1, 1);
            }
            catch (Exception e) {
                throw new CMBDocumentEngineException("A problem occured parsing the annotations", (Object)e);
            }
        }
        return document;
    }

    private void loadPart(LineDataDocument document, int partNum, InputStream partStream, String partMimeType, String partEncoding) throws IOException {
        LineDataPart part = new LineDataPart();
        if (partStream == null) {
            StringBuffer partMimeTypeBuffer = new StringBuffer();
            partStream = this.callbacks.getPart(document, partNum, partMimeTypeBuffer);
            partMimeType = partMimeTypeBuffer.toString();
        }
        if (partNum > 0 && partEncoding == null) {
            partEncoding = this.callbacks.getPartEncoding(document, partNum);
        }
        part.document = document;
        part.encoding = partEncoding;
        byte[] buffer = new byte[10000];
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(10000);
        int nRead = partStream.read(buffer);
        while (nRead > 0) {
            byteStream.write(buffer, 0, nRead);
            nRead = partStream.read(buffer);
        }
        part.data = byteStream.toByteArray();
        int pageCount = 0;
        for (int i = 0; i < partNum; ++i) {
            pageCount += this.getPartPageCount(document, i);
        }
        part.startingPageNumber = pageCount + 1;
        document.parts[partNum] = part;
    }

    public void dropDocument(Object hDocument) {
        LineDataDocument document = (LineDataDocument)hDocument;
        if (document.annotationSet != null) {
            this.annotationServices.dropAnnotationSet(document.annotationSet);
            document.annotationSet = null;
        }
    }

    public boolean canWriteDocument(String sourceMimeType, String destMimeType) {
        return destMimeType.equals("text/plain") || destMimeType.equals("text/html");
    }

    public void writeDocument(Object hDocument, String destMimeType, OutputStream output) throws IOException {
        if (!destMimeType.equals("text/plain") && !destMimeType.equals("text/html")) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("LineDataEngine.unsupportedDestinationType", new String[]{destMimeType}));
        }
        LineDataDocument document = (LineDataDocument)hDocument;
        for (int i = 0; i < document.parts.length; ++i) {
            if (document.parts[i] == null) {
                this.loadPart(document, i, null, null, null);
            }
            LineDataPart part = document.parts[i];
            if (!part.transformed) {
                this.transformPart(part);
            }
            if (destMimeType.equals("text/html")) {
                output.write("<html>\n<head></head>\n<body>\n<pre>".getBytes());
            }
            int column = 0;
            for (int j = 0; j < part.transformedContent.length; ++j) {
                output.write(part.transformedContent[j]);
                ++column;
                if (part.transformedContent[j] == '\n') {
                    column = 0;
                }
                if (column < 133) continue;
                output.write(10);
                column = 0;
            }
            if (!destMimeType.equals("text/html")) continue;
            output.write("</pre>\n</body>\n</html>".getBytes());
        }
    }

    public boolean canPaginate(String mimeType) {
        return true;
    }

    public boolean canProvidePageImage(String mimeType) {
        return true;
    }

    public boolean canRotate(Object hDocument, String destMimeType) {
        return true;
    }

    public boolean canEnhance(Object hDocument, String destMimeType) {
        return false;
    }

    public boolean canShowAnnotations(Object hDocument, String destMimeType) {
        return true;
    }

    public int getNumberOfPages(Object hDocument) throws IOException {
        LineDataDocument document = (LineDataDocument)hDocument;
        int pageCount = 0;
        for (int i = 0; i < document.parts.length; ++i) {
            pageCount += this.getPartPageCount(document, i);
        }
        return pageCount;
    }

    private int getPartPageCount(LineDataDocument document, int partNumber) throws IOException {
        int partPageCount = this.callbacks.getPartPageCount(document, partNumber);
        if (partPageCount <= 0) {
            if (document.parts[partNumber] == null) {
                this.loadPart(document, partNumber, null, null, null);
            }
            if (!document.parts[partNumber].paginated) {
                this.paginatePart(document.parts[partNumber]);
            }
            partPageCount = document.parts[partNumber].nPages;
        }
        return partPageCount;
    }

    public Object loadPage(Object hDocument, int pageNumber) throws IOException {
        LineDataDocument document = (LineDataDocument)hDocument;
        LineDataPart part = this.getPartForPage(document, pageNumber);
        if (!part.paginated) {
            this.paginatePart(part);
        }
        LineDataPage page = (LineDataPage)part.pages.get(new Integer(pageNumber - part.startingPageNumber + 1));
        return page;
    }

    private LineDataPart getPartForPage(LineDataDocument document, int pageNumber) throws IOException {
        int pageCountSoFar = 0;
        for (int i = 0; i < document.parts.length; ++i) {
            if ((pageCountSoFar += this.getPartPageCount(document, i)) < pageNumber) continue;
            if (document.parts[i] == null) {
                this.loadPart(document, i, null, null, null);
            }
            return document.parts[i];
        }
        return null;
    }

    public void dropPage(Object hPage) {
    }

    public boolean canWritePage(Object hPage, String destMimeType) {
        return destMimeType.equals("image/png");
    }

    public double getPageWidth(Object hPage) {
        return 14.0;
    }

    public double getPageHeight(Object hPage) {
        return 11.0;
    }

    public int getPageXResolution(Object hPage) {
        return 72;
    }

    public int getPageYResolution(Object hPage) {
        return 72;
    }

    public double getPageMaxScale(Object hPage, String destMimeType) {
        if (this.useDrawPage) {
            int pageResolution = Math.max(this.getPageXResolution(hPage), this.getPageYResolution(hPage));
            return 960.0 / (double)pageResolution;
        }
        int imageWidth = (int)((double)this.getPageXResolution(hPage) * this.getPageWidth(hPage));
        int imageHeight = (int)((double)this.getPageYResolution(hPage) * this.getPageHeight(hPage));
        int memoryForActualSize = imageWidth * imageHeight * 4;
        double maxScale = Math.log(0x4000000 / memoryForActualSize) / Math.log(2.0);
        return Math.max(maxScale, 1.0);
    }

    public double getPageMinScale(Object hPage, String destMimeType) {
        return 0.1;
    }

    public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations) {
        LineDataPage page = (LineDataPage)hPage;
        if (!page.part.paginated) {
            this.paginatePart(page.part);
        }
        int pageWidthPixels = 1008;
        int pageHeightPixels = 792;
        int leftMarginPixels = 36;
        int topMarginPixels = 36;
        BufferedImage image = rotation == 1 || rotation == 3 ? new BufferedImage((int)((double)pageHeightPixels * scale), (int)((double)pageWidthPixels * scale), 10) : new BufferedImage((int)((double)pageWidthPixels * scale), (int)((double)pageHeightPixels * scale), 10);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        this.drawPage(hPage, rotation, scale, enhance, invert, withAnnotations, 100, 100, graphics);
        graphics.dispose();
        return image;
    }

    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType) throws IOException, CMBDocumentEngineException {
        LineDataPage page = (LineDataPage)hPage;
        BufferedImage pageImage = (BufferedImage)this.getPageImage(hPage, rotation, scale, enhance, invert, withAnnotations);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(output);
        writer.setOutput(ios);
        writer.write(pageImage);
        writer.dispose();
        ios.close();
    }

    private void transformPart(LineDataPart part) {
        String charset = part.encoding;
        try {
            if (charset != null && charset.length() > 0) {
                part.transformedContent = new String(part.data, charset).toCharArray();
            } else {
                int firstByte = part.data[0] & 0xFF;
                if (firstByte == 0) {
                    part.afplinedata = true;
                    charset = "Cp500";
                } else {
                    charset = firstByte == 0 || firstByte == 78 || firstByte == 64 || firstByte == 240 || firstByte == 96 || firstByte == 241 ? "Cp500" : "UTF8";
                }
                part.transformedContent = new String(part.data, charset).toCharArray();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("LineDataEngine.unsupportedEncoding", new String[]{charset}), (Object)e);
        }
        part.transformed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paginatePart(LineDataPart part) {
        Object object = part.paginateLock;
        synchronized (object) {
            if (part.paginated) {
                return;
            }
            if (!part.transformed) {
                this.transformPart(part);
            }
            part.nPages = 1;
            LineDataPage page = new LineDataPage();
            page.part = part;
            page.pageNumber = part.nPages;
            page.beginOffset = 0;
            int lineOnPage = 1;
            part.pages.put(new Integer(part.nPages), page);
            int column = 0;
            for (int i = 0; i < part.transformedContent.length - 1; ++i) {
                if (part.transformedContent[i] != '\n' && ++column < 133) continue;
                char controlChar = part.transformedContent[i + 1];
                if (controlChar != '+') {
                    lineOnPage = controlChar == ' ' ? ++lineOnPage : (controlChar == '0' ? (lineOnPage += 2) : (controlChar == '-' ? (lineOnPage += 3) : (controlChar == '1' ? 1 : ++lineOnPage)));
                }
                if (lineOnPage > 80 || controlChar == '1') {
                    lineOnPage = 1;
                    page.endOffset = i;
                    page = new LineDataPage();
                    page.part = part;
                    page.pageNumber = ++part.nPages;
                    page.beginOffset = i + 1;
                    part.pages.put(new Integer(part.nPages), page);
                }
                column = 0;
            }
            page.endOffset = part.transformedContent.length - 1;
            part.paginated = true;
        }
    }

    public boolean useDrawPage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness) {
        return this.useDrawPage;
    }

    public void drawPage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness, Graphics2D graphics) {
        LineDataPage page = (LineDataPage)hPage;
        if (!page.part.paginated) {
            this.paginatePart(page.part);
        }
        int pageWidthPixels = 1008;
        int pageHeightPixels = 792;
        int leftMarginPixels = 36;
        int topMarginPixels = 36;
        AffineTransform oldTransform = graphics.getTransform();
        graphics.scale(scale, scale);
        if (rotation == 1) {
            graphics.translate(pageWidthPixels / 2, pageHeightPixels / 2);
            graphics.rotate(1.5707963267948966);
            graphics.translate(-pageHeightPixels / 2, -pageWidthPixels / 2);
            graphics.translate(0, -pageHeightPixels + pageWidthPixels);
        } else if (rotation == 2) {
            graphics.translate(pageWidthPixels / 2, pageHeightPixels / 2);
            graphics.rotate(Math.PI);
            graphics.translate(-pageWidthPixels / 2, -pageHeightPixels / 2);
        } else if (rotation == 3) {
            graphics.translate(pageWidthPixels / 2, pageHeightPixels / 2);
            graphics.rotate(4.71238898038469);
            graphics.translate(-pageHeightPixels / 2, -pageWidthPixels / 2);
            graphics.translate(pageHeightPixels - pageWidthPixels, 0);
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, pageWidthPixels, pageHeightPixels);
        graphics.translate(leftMarginPixels, topMarginPixels);
        graphics.setColor(Color.black);
        Font plainFont = new Font("Monospaced", 0, 12);
        Font boldFont = new Font("Monospaced", 1, 12);
        graphics.setFont(plainFont);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int x = 0;
        int y = 0;
        int column = 0;
        char[] lastColumnChars = new char[134];
        char[] thisColumnChars = new char[134];
        boolean overstrike = false;
        for (int i = page.beginOffset + 1; i <= page.endOffset; ++i) {
            char c = page.part.transformedContent[i];
            if (c == '\n' || ++column >= 133) {
                lastColumnChars = thisColumnChars;
                thisColumnChars = new char[134];
                x = 0;
                if (c == '\n') {
                    ++i;
                }
                if (i <= page.endOffset) {
                    char controlChar = page.part.transformedContent[i];
                    if (controlChar == ' ') {
                        y += 10;
                        overstrike = false;
                    } else if (controlChar == '0') {
                        y += 20;
                        overstrike = false;
                    } else if (controlChar == '-') {
                        y += 30;
                        overstrike = false;
                    } else if (controlChar == '1') {
                        y += 0;
                        overstrike = false;
                    } else if (controlChar == '+') {
                        overstrike = true;
                    } else {
                        y += 10;
                        overstrike = false;
                    }
                }
                column = 0;
            } else {
                if (overstrike && c == lastColumnChars[column]) {
                    graphics.setFont(boldFont);
                } else {
                    graphics.setFont(plainFont);
                }
                graphics.drawChars(page.part.transformedContent, i, 1, x, y);
                x += 8;
            }
            thisColumnChars[column] = c;
        }
        if (page.part.document.annotationSet != null) {
            graphics.translate(-leftMarginPixels, -topMarginPixels);
            graphics.setClip(0, 0, pageWidthPixels, pageHeightPixels);
            CMBPageAnnotation[] annotations = page.part.document.annotationSet.getPageAnnotations(page.pageNumber);
            for (int i = 0; i < annotations.length; ++i) {
                annotations[i].draw(graphics);
            }
        }
        graphics.setTransform(oldTransform);
    }

    private class AnnotationServicesCallbacks
    extends CMBAnnotationServicesCallbacks {
        private AnnotationServicesCallbacks() {
        }

        public int addAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData) throws CMBAnnotationEngineException {
            return 0;
        }

        public InputStream getAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
            return null;
        }

        public boolean getPrivilege(CMBAnnotationSet annotationSet, int privilegeID) throws CMBAnnotationEngineException {
            return true;
        }

        public void removeAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
        }

        public void trace(String message) {
        }

        public boolean traceEnabled() {
            return false;
        }

        public void updateAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData, int annotationNumber) throws CMBAnnotationEngineException {
        }
    }

    private class LineDataPage {
        LineDataPart part;
        int pageNumber;
        int beginOffset;
        int endOffset;

        private LineDataPage() {
        }
    }

    private class LineDataPart {
        LineDataDocument document;
        String encoding;
        byte[] data;
        boolean transformed;
        boolean afplinedata;
        char[] transformedContent;
        boolean paginated;
        Object paginateLock = new Object();
        int nPages;
        int startingPageNumber;
        Hashtable pages = new Hashtable();

        private LineDataPart() {
        }
    }

    private class LineDataDocument {
        LineDataPart[] parts;
        CMBAnnotationSet annotationSet;

        private LineDataDocument() {
        }
    }
}

