/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBLetter;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

public class CMBLetters {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    protected CMBLetter[] letters;
    private static final int BASELINE_TOLERANCE = 6;
    boolean debug = false;

    public CMBLetters(CMBLetter[] letterArray) {
        this.letters = letterArray;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.debug) {
            FileOutputStream os = null;
            try {
                File tempFile = File.createTempFile("cmbletters", "xml");
                os = new FileOutputStream(tempFile);
                this.serializeAsXML(os);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    int indexOf(Point p) {
        for (int i = 0; i < this.letters.length; ++i) {
            Rectangle bounds = this.getBounds(i);
            if (!bounds.contains(p)) continue;
            return i;
        }
        return -1;
    }

    int indexOf(Point p, Point startPoint, Position.Bias direction) {
        int found = 0;
        for (int i = 0; i < this.letters.length; ++i) {
            Rectangle bounds = this.getBounds(i);
            if (!bounds.contains(p)) continue;
            found = i;
        }
        if (found > 0) {
            return found;
        }
        Rectangle b1 = this.getBounds(0);
        Rectangle bn = this.getBounds(this.letters.length - 1);
        if (direction == Position.Bias.Forward) {
            if ((double)p.y < b1.getMinY()) {
                return -1;
            }
            if ((double)p.y > bn.getMaxY()) {
                return this.letters.length - 1;
            }
        }
        if (direction == Position.Bias.Backward) {
            if ((double)p.y < b1.getMinY()) {
                return 0;
            }
            if ((double)p.y > bn.getMaxY()) {
                return -1;
            }
        }
        if (direction == Position.Bias.Forward) {
            return this.getIndexForward(p, startPoint);
        }
        return this.getIndexBackward(p, startPoint);
    }

    private int getIndexBackward(Point p, Point startPoint) {
        CMBLetter l;
        int i;
        boolean foundBaseline = false;
        int baselineIndex = -1;
        int baseline = -1;
        for (i = 0; i < this.letters.length && !foundBaseline; ++i) {
            l = this.get(i);
            if (l.getBaseline() <= p.y) continue;
            foundBaseline = true;
            baselineIndex = i;
            baseline = l.getBaseline();
        }
        if (baselineIndex == 0 && p.x < (l = this.get(baselineIndex)).getLeft()) {
            return 0;
        }
        if (baselineIndex == -1) {
            return this.letters.length - 1;
        }
        l = this.get(baselineIndex);
        if (p.y < l.getTop()) {
            if (l.getBaseline() > startPoint.y) {
                return -1;
            }
            return baselineIndex;
        }
        baseline = this.get(i).getBaseline();
        boolean done = false;
        for (i = baselineIndex + 1; i > -1 && i < this.letters.length && !done; ++i) {
            l = this.get(i);
            if (this.sameLine(l.getBaseline(), baseline)) {
                if (p.x < l.getLeft()) {
                    if (i == 0) {
                        return 0;
                    }
                    return i - 1;
                }
                if (p.x < l.getLeft() || p.x > l.getLeft() + l.getWidth()) continue;
                return i;
            }
            return i;
        }
        return -1;
    }

    private int getIndexForward(Point p, Point startPoint) {
        CMBLetter l;
        int i;
        boolean foundBaseline = false;
        int baselineIndex = 0;
        short baseline = 0;
        for (i = 0; i < this.letters.length && !foundBaseline; ++i) {
            l = this.get(i);
            if (l.getBaseline() <= p.y) continue;
            foundBaseline = true;
            baselineIndex = i;
            baseline = l.getBaseline();
        }
        l = this.get(baselineIndex);
        if (p.y < l.getTop()) {
            l = this.get(baselineIndex - 1);
            if (l.getBaseline() < startPoint.y) {
                return -1;
            }
            return baselineIndex - 1;
        }
        boolean done = false;
        for (i = baselineIndex; i > -1 && i < this.letters.length && !done; ++i) {
            CMBLetter prevl;
            l = this.get(i);
            if (this.sameLine(l.getBaseline(), baseline)) {
                if (p.x < l.getLeft()) {
                    return i - 1;
                }
                if (p.x < l.getLeft() || p.x > l.getLeft() + l.getWidth()) continue;
                return i;
            }
            if (i <= 0 || p.x <= (prevl = this.get(i - 1)).getLeft() + prevl.getWidth()) continue;
            return i - 1;
        }
        l = this.get(this.letters.length - 1);
        if (this.sameLine(l.getBaseline(), baseline) && p.x > l.getLeft() + l.getWidth()) {
            return this.letters.length - 1;
        }
        return -1;
    }

    public Rectangle getBounds(int index) {
        CMBLetter letter = this.get(index);
        Rectangle bounds = null;
        bounds = letter.getBaseline() == 0 && letter.getCapheight() == 0 ? new Rectangle(letter.getLeft(), letter.getTop(), letter.getWidth(), letter.getHeight()) : (letter.getBaseline() < letter.getTop() ? new Rectangle(letter.getLeft(), letter.getTop(), letter.getWidth(), letter.getCapheight()) : new Rectangle(letter.getLeft(), letter.getBaseline() - letter.getCapheight(), letter.getWidth(), letter.getCapheight()));
        return bounds;
    }

    private boolean sameLine(int baseline1, int baseline2) {
        return Math.abs(baseline1 - baseline2) <= 6;
    }

    CMBLetter get(int index) {
        return this.letters[index];
    }

    void disposeLetters() {
        if (this.letters != null) {
            this.letters = null;
        }
    }

    public CMBLetter[] getLetters() {
        return this.letters;
    }

    public String getSelectedText(int dot, int mark) throws BadLocationException {
        int start = dot;
        int end = mark;
        if (mark < dot) {
            start = mark;
            end = dot;
        }
        int length = end - start + 1;
        StringBuffer s = new StringBuffer(length);
        for (int i = start; i < end + 1; ++i) {
            CMBLetter l = this.letters[i];
            s.append(l.getCode());
        }
        return s.toString();
    }

    Polygon getPolygonBounds(int dot, int mark) {
        int start = dot;
        int end = mark;
        if (mark < dot) {
            start = mark;
            end = dot;
        }
        Rectangle r = this.getBounds(start);
        for (int i = start; i <= end; ++i) {
            r.add(this.getBounds(i));
        }
        Rectangle letter1R = this.getBounds(start);
        Rectangle letter2R = this.getBounds(end);
        int x1 = (int)r.getMinX();
        int x2 = (int)letter1R.getMinX();
        int x3 = (int)letter2R.getMaxX();
        int x4 = (int)r.getMaxX();
        int y1 = (int)r.getMinY();
        int y2 = (int)letter1R.getMaxY();
        int y3 = (int)letter2R.getMinY();
        int y4 = (int)r.getMaxY();
        Rectangle topR = new Rectangle(new Point(x2, y1));
        topR.add(x4, y2);
        Rectangle midR = new Rectangle(new Point(x1, y2));
        midR.add(x4, y3);
        Rectangle botR = new Rectangle(new Point(x1, y3));
        botR.add(x3, y4);
        int[] x = new int[9];
        int[] y = new int[9];
        x[0] = x2;
        y[0] = y1;
        x[1] = x4;
        y[1] = y1;
        x[2] = x4;
        y[2] = y3;
        x[3] = x3;
        y[3] = y3;
        x[4] = x3;
        y[4] = y4;
        x[5] = x1;
        y[5] = y4;
        x[6] = x1;
        y[6] = y2;
        x[7] = x2;
        y[7] = y2;
        x[8] = x2;
        y[8] = y1;
        Polygon p = new Polygon(x, y, 9);
        return p;
    }

    protected void serializeAsXML(String filename) throws FileNotFoundException {
        FileOutputStream fstream = new FileOutputStream(filename);
        this.serializeAsXML(fstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serializeAsXML(OutputStream os) {
        try {
            try {
                XMLEncoder ostream = new XMLEncoder(os);
                try {
                    for (int i = 0; i < this.letters.length; ++i) {
                        CMBLetter l = this.letters[i];
                        ostream.writeObject(l);
                    }
                    ostream.writeObject(null);
                    ostream.flush();
                }
                finally {
                    ostream.close();
                }
            }
            finally {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static CMBLetters deserializeFromXML(String filename) throws FileNotFoundException {
        FileInputStream fstream = new FileInputStream(filename);
        return CMBLetters.deserializeFromXML(fstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CMBLetters deserializeFromXML(InputStream is) {
        ArrayList<CMBLetter> list = new ArrayList<CMBLetter>();
        try {
            try {
                XMLDecoder instream = new XMLDecoder(is);
                try {
                    Object o;
                    while ((o = instream.readObject()) != null) {
                        list.add((CMBLetter)o);
                    }
                }
                finally {
                    instream.close();
                }
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        CMBLetters o = new CMBLetters(list.toArray(new CMBLetter[list.size()]));
        return o;
    }

    private void saveAsXML(String filename) {
        try {
            File f = new File(filename);
            if (!f.exists()) {
                f.createNewFile();
                this.serializeAsXML(filename);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

