/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineCallbacks;
import com.ibm.mm.viewer.PViewerUtilities;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class CMBJavaDocumentEngine
extends CMBDocumentEngine {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private boolean _initialized = false;
    private Component _mediaTrackingComponent = new Panel();

    public void initialize(CMBDocumentEngineCallbacks callbacks, Properties properties) {
        this._initialized = true;
    }

    public void terminate() {
        this._initialized = false;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public boolean canLoadDocument(String mimeType) {
        return mimeType.equalsIgnoreCase("image/gif") || mimeType.equalsIgnoreCase("image/jpeg") || mimeType.equalsIgnoreCase("image/jpg") || mimeType.equalsIgnoreCase("text/url");
    }

    public Object loadDocument(InputStream partStream, int numberOfParts, String mimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        EngineDocument document = new EngineDocument();
        document.mimeType = mimeType;
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(32076);
        byte[] bytebuf = new byte[Short.MAX_VALUE];
        int bytesRead = 0;
        while (bytesRead >= 0) {
            bytesRead = partStream.read(bytebuf);
            if (bytesRead < 0) continue;
            byteArrayStream.write(bytebuf, 0, bytesRead);
        }
        document.data = byteArrayStream.toByteArray();
        return document;
    }

    public void dropDocument(Object hDocument) {
    }

    public boolean canWriteDocument(String sourceMimeType, String destMimeType) {
        if (sourceMimeType.equals(destMimeType)) {
            return true;
        }
        return sourceMimeType.equals("text/url") && destMimeType.equals("text/html");
    }

    public void writeDocument(Object hDocument, String destMimeType, OutputStream output) throws IOException {
        EngineDocument document = (EngineDocument)hDocument;
        if (document.mimeType.equals("text/url") && destMimeType.equals("text/html")) {
            output.write("<html>\n".getBytes());
            output.write("  <head>\n".getBytes());
            output.write("    <meta http-equiv=\"Refresh\" content=\"0;URL=".getBytes());
            output.write(document.data);
            output.write("\">\n".getBytes());
            output.write("  </head>\n".getBytes());
            output.write("  <body>\n".getBytes());
            output.write("  <a href=\"".getBytes());
            output.write(document.data);
            output.write("\">".getBytes());
            output.write(document.data);
            output.write("</a>\n".getBytes());
            output.write("  </body>\n".getBytes());
            output.write("</html>".getBytes());
        } else {
            output.write(document.data);
        }
    }

    public boolean canPaginate(String mimeType) {
        return mimeType.equals("image/jpeg") || mimeType.equals("image/gif");
    }

    public int getNumberOfPages(Object hDocument) {
        return 1;
    }

    public Object loadPage(Object hDocument, int pageNumber) {
        EngineDocument document = (EngineDocument)hDocument;
        EnginePage page = new EnginePage();
        page.document = document;
        document.page = page;
        try {
            page.image = Toolkit.getDefaultToolkit().createImage(document.data);
        }
        catch (Exception e) {
            return null;
        }
        try {
            MediaTracker tracker = new MediaTracker(this._mediaTrackingComponent);
            tracker.addImage(page.image, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (page.image.getWidth(this._mediaTrackingComponent) <= 0) {
            return null;
        }
        return page;
    }

    public void dropPage(Object hPage) {
        EnginePage page = (EnginePage)hPage;
        page.image.flush();
    }

    public double getPageWidth(Object hPage) {
        EnginePage page = (EnginePage)hPage;
        return (double)page.image.getWidth(this._mediaTrackingComponent) / 150.0;
    }

    public double getPageHeight(Object hPage) {
        EnginePage page = (EnginePage)hPage;
        return (double)page.image.getHeight(this._mediaTrackingComponent) / 150.0;
    }

    public boolean canRotate(Object hDocument, String destMimeType) {
        EngineDocument document = (EngineDocument)hDocument;
        return document.mimeType.equals("image/gif") || document.mimeType.equals("image.jpeg");
    }

    public double getMinScale(Object hDocument, String destMimeType) {
        EngineDocument document = (EngineDocument)hDocument;
        if (document.mimeType.equals("image/gif") || document.mimeType.equals("image.jpeg")) {
            return 0.0125;
        }
        return 1.0;
    }

    public double getMaxScale(Object hDocument, String destMimeType) {
        EngineDocument document = (EngineDocument)hDocument;
        if (document.mimeType.equals("image/gif") || document.mimeType.equals("image.jpeg")) {
            return 4.0;
        }
        return 1.0;
    }

    public boolean canEnhance(Object hDocument, String destMimeType) {
        return false;
    }

    public boolean canInvert(Object hDocument, String destMimeType) {
        EngineDocument document = (EngineDocument)hDocument;
        return document.mimeType.equals("image/gif") || document.mimeType.equals("image.jpeg");
    }

    public boolean canShowAnnotations(Object hDocument, String destMimeType) {
        return false;
    }

    public boolean canWritePage(String sourceMimeType, String destMimeType) {
        return destMimeType.equals("image/jpeg");
    }

    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType) throws IOException {
        Image pageImage = this.getPageImage(hPage, rotation, scale, enhance, invert, withAnnotations);
        int width = pageImage.getWidth(this._mediaTrackingComponent);
        int height = pageImage.getHeight(this._mediaTrackingComponent);
        BufferedImage bufImage = new BufferedImage(width, height, 1);
        Graphics2D g2 = bufImage.createGraphics();
        g2.setClip(0, 0, width, height);
        g2.drawImage(pageImage, 0, 0, Color.white, this._mediaTrackingComponent);
        g2.dispose();
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)output);
        encoder.encode(bufImage);
    }

    public boolean canWriteDocumentFromPages(String sourceMimeType, String destMimeType) {
        return this.canWritePage(sourceMimeType, destMimeType);
    }

    public void writeDocumentFromPages(Object hDocument, int startingPage, int endingPage, String destMimeType, OutputStream output, boolean withAnnotations) throws IOException {
        EngineDocument document = (EngineDocument)hDocument;
        if (document.page == null) {
            this.loadPage(hDocument, 1);
        }
        this.writePage(document.page, 0, 1.0, false, false, withAnnotations, output, destMimeType);
    }

    public boolean canProvidePageImage(String mimeType) {
        return mimeType.equals("image/jpeg") || mimeType.equals("image/gif");
    }

    public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations) {
        EnginePage page = (EnginePage)hPage;
        Image image = page.image;
        int width = image.getWidth(this._mediaTrackingComponent);
        int height = image.getHeight(this._mediaTrackingComponent);
        if (enhance) {
            throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.enhanceNotSupported"));
        }
        if (withAnnotations) {
            throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.annotationsNotSupported"));
        }
        if (scale != 1.0) {
            image = image.getScaledInstance((int)(scale * (double)width), (int)(scale * (double)height), 1);
        }
        if (rotation != 0) {
            RotateFilter rotateFilter = new RotateFilter(rotation);
            image = this._mediaTrackingComponent.createImage(new FilteredImageSource(image.getSource(), rotateFilter));
        }
        if (invert) {
            InvertFilter invertFilter = new InvertFilter();
            image = this._mediaTrackingComponent.createImage(new FilteredImageSource(image.getSource(), invertFilter));
        }
        if (image != page.image) {
            try {
                MediaTracker tracker = new MediaTracker(this._mediaTrackingComponent);
                tracker.addImage(image, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return image;
    }

    class InvertFilter
    extends RGBImageFilter {
        public InvertFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            return rgb ^ 0xFFFFFF;
        }
    }

    class RotateFilter
    extends ImageFilter {
        int _rotation;
        int _width;
        int _height;
        int _rwidth;
        int _rheight;
        ColorModel _model;
        byte[] _bytePixels;
        int[] _intPixels;

        public RotateFilter(int rotation) {
            this._rotation = rotation;
        }

        public void setDimensions(int width, int height) {
            this._width = width;
            this._height = height;
            if (this._rotation == 0 || this._rotation == 2) {
                this._rwidth = width;
                this._rheight = height;
            } else {
                this._rwidth = height;
                this._rheight = width;
            }
            this.consumer.setDimensions(this._rwidth, this._rheight);
            this._bytePixels = null;
            this._intPixels = null;
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
            this._model = model;
            if (this._bytePixels == null) {
                this._bytePixels = new byte[this._rwidth * this._rheight];
            }
            for (int i = 0; i < pixels.length; ++i) {
                int rn;
                int rm;
                int m = x + i % w;
                int n = y + i / w;
                if (this._rotation == 0) {
                    rm = m;
                    rn = n;
                } else if (this._rotation == 1) {
                    rm = this._rwidth - n - 1;
                    rn = m;
                } else if (this._rotation == 2) {
                    rm = this._rwidth - m - 1;
                    rn = this._rheight - n - 1;
                } else {
                    rm = n;
                    rn = this._rheight - m - 1;
                }
                this._bytePixels[this._rwidth * rn + rm] = pixels[i];
            }
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            this._model = model;
            if (this._intPixels == null) {
                this._intPixels = new int[this._rwidth * this._rheight];
            }
            for (int i = 0; i < pixels.length; ++i) {
                int rn;
                int rm;
                int m = x + i % w;
                int n = y + i / w;
                if (this._rotation == 0) {
                    rm = m;
                    rn = n;
                } else if (this._rotation == 1) {
                    rm = this._rwidth - n - 1;
                    rn = m;
                } else if (this._rotation == 2) {
                    rm = this._rwidth - m - 1;
                    rn = this._rheight - n - 1;
                } else {
                    rm = n;
                    rn = this._rheight - m - 1;
                }
                this._intPixels[this._rwidth * rn + rm] = pixels[i];
            }
        }

        public void imageComplete(int status) {
            if (this._bytePixels != null) {
                this.consumer.setPixels(0, 0, this._rwidth, this._rheight, this._model, this._bytePixels, 0, this._rwidth);
            }
            if (this._intPixels != null) {
                this.consumer.setPixels(0, 0, this._rwidth, this._rheight, this._model, this._intPixels, 0, this._rwidth);
            }
            this.consumer.imageComplete(status);
        }

        public void resendTopDownLeftRight(ImageProducer ip) {
        }
    }

    private class EnginePage {
        public EngineDocument document;
        public Image image;

        private EnginePage() {
        }
    }

    private class EngineDocument {
        public String mimeType;
        public byte[] data;
        EnginePage page;

        private EngineDocument() {
        }
    }
}

