/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBBookmark;
import com.ibm.mm.viewer.CMBBookmarksEditEvent;
import com.ibm.mm.viewer.CMBBookmarksEditListener;
import com.ibm.mm.viewer.CMBCustomPageablePrintable;
import com.ibm.mm.viewer.CMBDocStateChangedListener;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBGenericDocClosedEvent;
import com.ibm.mm.viewer.CMBGenericDocClosedListener;
import com.ibm.mm.viewer.CMBGenericDocHelpEvent;
import com.ibm.mm.viewer.CMBGenericDocHelpListener;
import com.ibm.mm.viewer.CMBGenericDocOCRStatusEvent;
import com.ibm.mm.viewer.CMBGenericDocOCRStatusListener;
import com.ibm.mm.viewer.CMBGenericDocOpenedEvent;
import com.ibm.mm.viewer.CMBGenericDocOpenedListener;
import com.ibm.mm.viewer.CMBGenericDocPrintStatusEvent;
import com.ibm.mm.viewer.CMBGenericDocPrintStatusListener;
import com.ibm.mm.viewer.CMBGenericDocSaveEvent;
import com.ibm.mm.viewer.CMBGenericDocSaveListener;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBLetters;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.CMBPreferenceSet;
import com.ibm.mm.viewer.CMBPreferenceSetView;
import com.ibm.mm.viewer.CMBStreamingDocServices;
import com.ibm.mm.viewer.CMBViewerAction;
import com.ibm.mm.viewer.CMBViewerConstants;
import com.ibm.mm.viewer.CMBViewerException;
import com.ibm.mm.viewer.CMBViewerTask;
import com.ibm.mm.viewer.CMBViewerToolbar;
import com.ibm.mm.viewer.PChangeAnnotationPropertiesTask;
import com.ibm.mm.viewer.PClippedPages;
import com.ibm.mm.viewer.PCopyAnnotationTask;
import com.ibm.mm.viewer.PCopyPagesTask;
import com.ibm.mm.viewer.PCreateAnnotationTask;
import com.ibm.mm.viewer.PCutAnnotationTask;
import com.ibm.mm.viewer.PCutPagesTask;
import com.ibm.mm.viewer.PDeleteAnnotationTask;
import com.ibm.mm.viewer.PDeletePagesTask;
import com.ibm.mm.viewer.PDeleteSelectedAreaTask;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PDocView;
import com.ibm.mm.viewer.PDropDownButton;
import com.ibm.mm.viewer.PExportDocumentDialog;
import com.ibm.mm.viewer.PFindDialog;
import com.ibm.mm.viewer.PFullSizePageView;
import com.ibm.mm.viewer.PFullSizeView;
import com.ibm.mm.viewer.PFullSizeViewScrollAction;
import com.ibm.mm.viewer.PImageSelection;
import com.ibm.mm.viewer.PMoveAnnotationTask;
import com.ibm.mm.viewer.PNewPrintDialog;
import com.ibm.mm.viewer.POCRQueue;
import com.ibm.mm.viewer.POCRQueueItem;
import com.ibm.mm.viewer.POptionPane;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PPagePrintable;
import com.ibm.mm.viewer.PPageTransferHandler;
import com.ibm.mm.viewer.PPageViewer;
import com.ibm.mm.viewer.PPasteAnnotationTask;
import com.ibm.mm.viewer.PPastePagesTask;
import com.ibm.mm.viewer.PPreferenceSet;
import com.ibm.mm.viewer.PPreferenceSetsBuilder;
import com.ibm.mm.viewer.PPreferencesDialog;
import com.ibm.mm.viewer.PPrintDialog;
import com.ibm.mm.viewer.PPrintPreviewDialog;
import com.ibm.mm.viewer.PPrintQueue;
import com.ibm.mm.viewer.PPrintQueueItem;
import com.ibm.mm.viewer.PProgressOCRDialog;
import com.ibm.mm.viewer.PRedoTask;
import com.ibm.mm.viewer.PReorderAnnotationTask;
import com.ibm.mm.viewer.PResizeAnnotationTask;
import com.ibm.mm.viewer.PRotatePagesTask;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PSingleViewerLayout;
import com.ibm.mm.viewer.PSplitViewerLayout;
import com.ibm.mm.viewer.PTabbedViewerLayout;
import com.ibm.mm.viewer.PThumbnailListModel;
import com.ibm.mm.viewer.PThumbnailsOnlyViewerLayout;
import com.ibm.mm.viewer.PThumbnailsView;
import com.ibm.mm.viewer.PToolbarsBorderLayout;
import com.ibm.mm.viewer.PUndoTask;
import com.ibm.mm.viewer.PViewerLayout;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationCreatedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationCreatedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationDefaultsChangedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationDefaultsChangedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationDeletedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationDeletedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationMovedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationMovedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationPropertiesUpdatedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationPropertiesUpdatedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationReorderedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationReorderedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationResizedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationResizedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationSelectedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationSelectedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPenAnnotation;
import com.ibm.mm.viewer.annotation.CMBSelectedAnnotationToolChangedEvent;
import com.ibm.mm.viewer.annotation.CMBSelectedAnnotationToolChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.regex.MatchResult;
import javax.print.CancelablePrintJob;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class CMBGenericDocViewer
extends JPanel
implements ChangeListener,
CMBAnnotationCreatedListener,
CMBAnnotationDeletedListener,
CMBAnnotationPropertiesUpdatedListener,
CMBAnnotationReorderedListener,
CMBAnnotationMovedListener,
CMBAnnotationResizedListener,
CMBAnnotationSelectedListener,
CMBDocStateChangedListener,
CMBGenericDocStateChangedListener,
ClipboardOwner,
CMBViewerConstants {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private Hashtable activeToolbars = null;
    private Vector activeViewers = null;
    private Hashtable actions = null;
    PPrintQueue printQueue = null;
    POCRQueue ocrQueue = null;
    private boolean isTerminating = false;
    private PSingleDocViewer selectedViewer;
    private PToolbarsBorderLayout toolbarsBorderLayout;
    private JPanel toolbarsPanel;
    private String thumbnailsPosition = "East";
    private String thumbnailsRelativeSize = "medium";
    private Dimension thumbnailSize;
    JFrame thumbnailWindow = null;
    private boolean thumbnailsDocked = true;
    private CMBStreamingDocServices docServices = null;
    private CMBAnnotationServices annoServices = null;
    private Vector docOpenListeners = new Vector();
    private Vector docSelectListeners = new Vector();
    private Vector docStateChangedListeners = new Vector();
    private ArrayList docSaveListeners = new ArrayList();
    private Vector docClosedListeners = new Vector();
    private Vector docHelpListeners = new Vector();
    private ArrayList docPrintStatusListeners = new ArrayList();
    private boolean isEditable = false;
    private static final String VIEWER_CONFIG_DELIM = ",";
    Clipboard localClipboard = new Clipboard("Generic Doc Viewer local clipboard");
    private PageFormat pageFormat = null;
    private boolean bShowThumbnails = true;
    private Hashtable cursorTable = new Hashtable();
    private Hashtable printPreference = new Hashtable();
    private CMBViewerAction currentAction = null;
    private JPopupMenu pagePopupMenu = null;
    private JPopupMenu doctabPopupMenu = null;
    private JPopupMenu annoPopupMenu = null;
    private JPopupMenu thumbPopupMenu = null;
    private JPopupMenu selectAreaPopupMenu = null;
    private boolean selectInShow = true;
    private Properties configProperties = new Properties();
    private Properties systemProperties = new Properties();
    private PropertyHandler propertyHandler = new PropertyHandler();
    private Properties startingUserProperties = new Properties();
    private Preferences userPrefs = null;
    private Preferences systemPrefs = null;
    private static final String SYSTEM_PREFS_UPDATE_TEST = "SystemPrefsUpdateTest";
    private boolean systemPrefsUpdateAccess = false;
    DefaultMutableTreeNode preferenceSets = null;
    Hashtable customPreferenceSets = new Hashtable();
    private boolean pageManipulationEnabled = false;
    private boolean confirmPageDelete = false;
    private boolean continuousPaginationEnabled = false;
    private boolean multiplePageSelectionEnabled;
    private boolean scrollingLocked = false;
    private boolean selectedViewTemporary = false;
    private boolean createDocumentPrivilege = true;
    private String newDocumentMimetype = null;
    private PExportDocumentDialog exportDialog = null;
    private Hashtable customPrintables = new Hashtable();
    boolean useNewPrintDialog = false;
    boolean useNewFindDialog = false;
    private JDialog dialogDisplayed = null;
    private int toolbarOrder;
    private Timer docViewedTimer = null;
    PViewerLayout currentLayout;
    int previousLayout = 0;
    int tabPosition = 1;
    PFindDialog findDialog;
    private int currentMode = 111;
    private ArrayList registeredKeyboardActions = new ArrayList();
    private ArrayList bookmarksEditListeners;
    private String currentZoomOption = PViewerUtilities.getMessage("DocumentViewer.ZoomCustomInitialValue");
    private static Object printMutex = new Object();

    public CMBGenericDocViewer(CMBStreamingDocServices docServices, CMBAnnotationServices annoServices, Properties configProps) {
        this.setName("CMBGenericDocViewer");
        this.docServices = docServices;
        this.annoServices = annoServices;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.activeToolbars = new Hashtable();
        this.activeViewers = new Vector();
        this.actions = new Hashtable();
        this.printQueue = new PPrintQueue();
        this.ocrQueue = new POCRQueue();
        try {
            this.userPrefs = Preferences.userNodeForPackage(CMBGenericDocViewer.class);
            this.systemPrefs = Preferences.systemNodeForPackage(CMBGenericDocViewer.class);
        }
        catch (SecurityException e) {
            System.out.println(PViewerUtilities.getMessage("preference.securityException"));
        }
        this.systemPrefsUpdateAccess = CMBGenericDocViewer.systemPrefsAuthorization();
        this.currentLayout = new PTabbedViewerLayout(this);
        this.initializeViewerUsingProperties(configProps);
        PPageTransferHandler txHandler = new PPageTransferHandler(this);
        this.setTransferHandler(txHandler);
        this.initializeLayout();
        if (annoServices != null) {
            annoServices.addAnnotationToolListener(new CMBSelectedAnnotationToolChangedListener(){

                public void annotationToolChanged(CMBSelectedAnnotationToolChangedEvent e) {
                    switch (e.getAnnotationTool()) {
                        case 0: {
                            CMBGenericDocViewer.this.annoServices.setIdleDrawingMode();
                            break;
                        }
                        case 20: {
                            CMBGenericDocViewer.this.annoServices.setEraseMode();
                            break;
                        }
                        case 21: {
                            break;
                        }
                        default: {
                            if (CMBGenericDocViewer.this.getSelectedModel() == null) break;
                            CMBGenericDocViewer.this.annoServices.prepareToAddAnnotation(e.getAnnotationTool(), CMBGenericDocViewer.this.getCurrentPageNumber());
                        }
                    }
                    CMBGenericDocViewer.this.setCursorFromSelectedAnnotationTool();
                    CMBGenericDocViewer.this.updateToolStates();
                }
            });
        }
        this.addDocSelectedListener(new CMBGenericDocSelectedListener(){

            public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
                CMBGenericDocViewer.this.checkPageCountForStickyTool();
            }
        });
        this.addPropertyChangeListener("OCR_CURR_ITEM_VALID", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                CMBGenericDocViewer.this.updateToolStates();
            }
        });
        this.addDocPrintStatusListener(new CMBGenericDocPrintStatusListener(){

            public void printStatusChanged(CMBGenericDocPrintStatusEvent e) {
                if (CMBGenericDocViewer.this.isTerminating) {
                    return;
                }
                switch (e.getStatusType()) {
                    case 1: {
                        Enumeration en = CMBGenericDocViewer.this.activeViewers.elements();
                        while (en.hasMoreElements()) {
                            PSingleDocViewer v = (PSingleDocViewer)en.nextElement();
                            PDocModel docModel = null;
                            CMBAnnotationSet annoSet = null;
                            if (v == null || (docModel = v.getDocModel()) == null || !CMBGenericDocViewer.this.isDocumentPrinting(docModel.getDocument()) || (annoSet = docModel.getAnnotationSet()) == null || CMBGenericDocViewer.this.getAnnotationServices() == null) continue;
                            CMBGenericDocViewer.this.getAnnotationServices().setAnnotationSetEditable(annoSet, false);
                        }
                        break;
                    }
                    case 3: {
                        CMBAnnotationSet annoSet;
                        PSingleDocViewer viewer;
                        CMBDocument doc = e.getDocument();
                        if (CMBGenericDocViewer.this.activeViewers.size() <= 0 || (viewer = CMBGenericDocViewer.this.getViewer(doc)) == null || (annoSet = viewer.getDocModel().getAnnotationSet()) == null || CMBGenericDocViewer.this.getAnnotationServices() == null) break;
                        CMBGenericDocViewer.this.getAnnotationServices().setAnnotationSetEditable(annoSet, true);
                        break;
                    }
                }
                CMBGenericDocViewer.this.updateToolStates();
            }
        });
    }

    private void checkPageCountForStickyTool() {
        int currentPageNumber = 1;
        PDocModel docModel = this.getSelectedModel();
        if (docModel != null && this.isAnnotationToolSticky() && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() != 0) {
            currentPageNumber = docModel.getCurrentPageNumber();
            CMBAnnotationSet annoSet = docModel.getAnnotationSet();
            if (annoSet != null && this.getAnnotationServices() != null) {
                if (currentPageNumber < 1) {
                    this.getAnnotationServices().setAnnotationSetEditable(annoSet, false);
                } else if (!annoSet.isEditable() && !this.isDocumentPrinting(docModel.getDocument())) {
                    this.getAnnotationServices().setAnnotationSetEditable(annoSet, true);
                }
            }
        }
    }

    private void initializeViewerUsingProperties(Properties properties) {
        String methodName = "initializeViewerUsingProperties";
        if (properties != null) {
            ViewerLogger.logDebug(this, methodName, properties.toString());
        }
        if (this.annoServices != null) {
            Properties systemDefaults;
            if (properties != null) {
                this.annoServices.setDefaultAnnotationProperties(properties);
            } else {
                systemDefaults = new Properties();
                this.annoServices.setDefaultAnnotationProperties(systemDefaults);
            }
            systemDefaults = new Properties();
            this.annoServices.getDefaultAnnotationProperties(systemDefaults);
            if (this.systemPrefs != null && this.systemPrefsUpdateAccess) {
                Enumeration<?> annoProps = systemDefaults.propertyNames();
                while (annoProps.hasMoreElements()) {
                    String name = (String)annoProps.nextElement();
                    String value = systemDefaults.getProperty(name);
                    if (properties != null) {
                        try {
                            this.systemPrefs.put(name, value);
                        }
                        catch (IllegalStateException e) {}
                        continue;
                    }
                    if (this.keyExists(this.systemPrefs, name)) continue;
                    try {
                        this.systemPrefs.put(name, value);
                    }
                    catch (IllegalStateException e) {}
                }
            }
        }
        Properties defaultProperties = new Properties();
        InputStream defaultConfigStream = this.getClass().getClassLoader().getResourceAsStream("com/ibm/mm/viewer/CMBViewerConfiguration.properties");
        try {
            defaultProperties.load(defaultConfigStream);
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        this.updateSystemPreferencesFromProperties(defaultProperties, false);
        this.updateSystemPreferencesFromProperties(properties, true);
        if (properties != null) {
            Properties tempProperties = this.getSystemProperties(defaultProperties);
            this.systemProperties = new Properties(tempProperties);
            Enumeration<?> propNames = properties.propertyNames();
            while (propNames.hasMoreElements()) {
                String name = (String)propNames.nextElement();
                String value = properties.getProperty(name);
                this.systemProperties.put(name, value);
            }
        } else {
            this.systemProperties = this.getSystemProperties(defaultProperties);
        }
        Properties userProperties = this.getUserProperties(this.systemProperties);
        this.startingUserProperties = this.getUserProperties(null);
        this.configProperties = userProperties;
        ViewerLogger.logDebug(this, methodName, this.configProperties.toString());
        this.updateViewerFromProperties(true);
    }

    private void updateViewerFromProperties(boolean createListeners) {
        String position;
        if (this.annoServices != null) {
            this.annoServices.setDefaultAnnotationProperties(this.configProperties);
        }
        String key = "Annotations.show";
        boolean b = PViewerUtilities.getBooleanProperty(key, this.configProperties, true);
        this.putClientProperty(key, b);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Annotations.immediatePreview";
        b = PViewerUtilities.getBooleanProperty(key, this.configProperties, false);
        this.putClientProperty(key, b);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Annotations.visibleWhileDrag";
        b = PViewerUtilities.getBooleanProperty(key, this.configProperties, false);
        this.putClientProperty(key, b);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "AnnotationTool.sticky";
        b = PViewerUtilities.getBooleanProperty(key, this.configProperties, false);
        this.putClientProperty(key, b);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        this._setAnnotationToolSticky(b);
        key = "Zoom.default";
        String s = PViewerUtilities.getStringProperty(key, this.configProperties, "fit_actual", PPreferenceSet.ZOOM_DEFAULT_VALUES);
        this.putClientProperty(key, s);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Zoom.factor";
        int i = PViewerUtilities.getIntegerProperty(key, this.configProperties, 10, 1, 99);
        this.putClientProperty(key, new Integer(i));
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Document.rotate";
        s = PViewerUtilities.getStringProperty(key, this.configProperties, "rotate_0", PPreferenceSet.DOCUMENT_ROTATE_VALUES);
        this.putClientProperty(key, s);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Document.invert";
        b = PViewerUtilities.getBooleanProperty(key, this.configProperties, false);
        this.putClientProperty(key, b);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Document.enhance";
        b = PViewerUtilities.getBooleanProperty(key, this.configProperties, true);
        this.putClientProperty(key, b);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Document.ocr";
        b = PViewerUtilities.getBooleanProperty(key, this.configProperties, true);
        this.putClientProperty(key, b);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "History.queue";
        i = PViewerUtilities.getIntegerProperty(key, this.configProperties, 25, 0, 100);
        this.putClientProperty(key, new Integer(i));
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Printing.annotations.include";
        b = PViewerUtilities.getBooleanProperty(key, this.configProperties, true);
        this.putClientProperty(key, b);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Printing.centerOnPage";
        b = PViewerUtilities.getBooleanProperty(key, this.configProperties, true);
        this.putClientProperty(key, b);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Printing.fitToPage";
        b = PViewerUtilities.getBooleanProperty(key, this.configProperties, true);
        this.putClientProperty(key, b);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Printing.zoom";
        i = PViewerUtilities.getIntegerProperty(key, this.configProperties, 100, 25, 500);
        this.putClientProperty(key, new Integer(i));
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Appearance.tab.indicate";
        b = PViewerUtilities.getBooleanProperty(key, this.configProperties, true);
        this.putClientProperty(key, b);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Appearance.tab.delay";
        i = PViewerUtilities.getIntegerProperty(key, this.configProperties, 10, 0, 1024);
        this.putClientProperty(key, new Integer(i));
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Appearance.tab.fontstyle";
        s = PViewerUtilities.getStringProperty(key, this.configProperties, "bold", PPreferenceSet.FONT_STYLE_VALUES);
        this.putClientProperty(key, s);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Appearance.tab.color";
        String tabColor = PViewerUtilities.getColorProperty(key, this.configProperties, "#00FF00");
        this.putClientProperty(key, tabColor);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        if ((position = PViewerUtilities.getStringProperty(key = "Thumbnailbar.position", this.configProperties, "east", PPreferenceSet.POSITION_VALUES)).equalsIgnoreCase("Center")) {
            position = "East";
        }
        this.putClientProperty(key, position);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Thumbnailbar.show";
        this.bShowThumbnails = PViewerUtilities.getBooleanProperty(key, this.configProperties, true);
        this.putClientProperty(key, this.bShowThumbnails);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "Thumbnails.dock";
        this.thumbnailsDocked = PViewerUtilities.getBooleanProperty(key, this.configProperties, true);
        this.putClientProperty(key, this.thumbnailsDocked);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "ThumbnailSize.width";
        int w = PViewerUtilities.getIntegerProperty(key, this.configProperties, 60);
        this.putClientProperty(key, new Integer(w));
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        key = "ThumbnailSize.height";
        int h = PViewerUtilities.getIntegerProperty(key, this.configProperties, 77);
        this.putClientProperty(key, new Integer(h));
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        this.thumbnailSize = new Dimension(w, h);
        key = "ThumbnailSize";
        this.thumbnailsRelativeSize = PViewerUtilities.getStringProperty(key, this.configProperties, "medium", PPreferenceSet.RELATIVE_SIZE_VALUES);
        this.putClientProperty(key, this.thumbnailsRelativeSize);
        if (createListeners) {
            this.addPropertyChangeListener(key, this.propertyHandler);
        }
        PThumbnailListModel.setContinuousPaginationEnabled(PViewerUtilities.getBooleanProperty("ContinuousPagination", this.configProperties, false));
        this.pageManipulationEnabled = PViewerUtilities.getBooleanProperty("PageManipulation", this.configProperties, true);
        this.multiplePageSelectionEnabled = PViewerUtilities.getBooleanProperty("MultiplePageSelection", this.configProperties, false);
        String pageManipString = this.configProperties.getProperty("PageManipulation", "false");
        this.pageManipulationEnabled = Boolean.valueOf(pageManipString);
        String confirmPageDeleteString = this.configProperties.getProperty("ConfirmPageDelete", "false");
        this.confirmPageDelete = Boolean.valueOf(confirmPageDeleteString);
        String continuousPaginationString = this.configProperties.getProperty("ContinuousPagination", "false");
        this.continuousPaginationEnabled = Boolean.valueOf(continuousPaginationString);
        String multiPageSelectString = this.configProperties.getProperty("MultiplePageSelection", "false");
        this.multiplePageSelectionEnabled = Boolean.valueOf(multiPageSelectString);
        this.newDocumentMimetype = this.configProperties.getProperty("NewDocument.mimetype", "image/tiff");
        String thumbnailsRendering = this.configProperties.getProperty("ThumbnailsRendering", "ALL");
        short renderingMode = 2;
        if (thumbnailsRendering.equalsIgnoreCase("VISIBLE")) {
            renderingMode = 0;
        } else if (thumbnailsRendering.equalsIgnoreCase("AHEAD")) {
            renderingMode = 1;
        }
        PThumbnailListModel.setRenderingMode(renderingMode);
        if (this.continuousPaginationEnabled) {
            PFullSizeViewScrollAction upAction = new PFullSizeViewScrollAction(this, "scrollUp", 1, -1, true);
            KeyStroke upKs = KeyStroke.getKeyStroke("PAGE_UP");
            upAction.putValue("AcceleratorKey", upKs);
            this.registerKeyboardAction(upAction, upKs, 1);
            PFullSizeViewScrollAction downAction = new PFullSizeViewScrollAction(this, "scrollDown", 1, 1, true);
            KeyStroke downKs = KeyStroke.getKeyStroke("PAGE_DOWN");
            downAction.putValue("AcceleratorKey", downKs);
            this.registerKeyboardAction(downAction, downKs, 1);
        }
        PThumbnailListModel.setContinuousPaginationEnabled(this.continuousPaginationEnabled);
    }

    public Frame getOwningFrame() {
        for (Container comp = this; comp != null; comp = comp.getParent()) {
            if (!(comp instanceof Frame)) continue;
            return (Frame)comp;
        }
        return null;
    }

    public void updateUI() {
        super.updateUI();
        if (this.annoServices != null) {
            this.annoServices.updateComponentUI();
        }
        if (this.pagePopupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.pagePopupMenu);
        }
        if (this.selectAreaPopupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.selectAreaPopupMenu);
        }
        if (this.doctabPopupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.doctabPopupMenu);
        }
        if (this.annoPopupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.annoPopupMenu);
        }
        if (this.thumbPopupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.thumbPopupMenu);
        }
        if (this.preferenceSets != null) {
            Enumeration<TreeNode> en = this.getPreferenceSets().preorderEnumeration();
            while (en.hasMoreElements()) {
                CMBPreferenceSetView c;
                CMBPreferenceSet ps;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                if (!(node.getUserObject() instanceof CMBPreferenceSet) || (ps = (CMBPreferenceSet)node.getUserObject()).getComponent() == null || (c = ps.getComponent()) == null) continue;
                SwingUtilities.updateComponentTreeUI(c);
            }
        }
    }

    private void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 200));
        String position = this.configProperties.getProperty("Thumbnailbar.position", this.thumbnailsPosition);
        if (position.equalsIgnoreCase("Center")) {
            position = "East";
        }
        this._setThumbnailsPosition(position);
        String strDockThumbnails = this.configProperties.getProperty("Thumbnails.dock", "true");
        this.thumbnailsDocked = strDockThumbnails.equalsIgnoreCase("true");
        this._dockThumbnails(this.thumbnailsDocked);
        String strShowThumbnails = this.configProperties.getProperty("Thumbnailbar.show", "true");
        this.bShowThumbnails = strShowThumbnails.equalsIgnoreCase("true");
        this._showThumbnails(this.bShowThumbnails);
        int thumbnailSizeWidth = new Integer(this.configProperties.getProperty("ThumbnailSize.width", "60"));
        int thumbnailSizeHeight = new Integer(this.configProperties.getProperty("ThumbnailSize.height", "78"));
        this.setThumbnailsSize(new Dimension(thumbnailSizeWidth, thumbnailSizeHeight));
        this.toolbarsBorderLayout = new PToolbarsBorderLayout();
        this.toolbarsPanel = new JPanel(this.toolbarsBorderLayout);
        this.toolbarsPanel.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof JToolBar) {
                    JToolBar toolbar = (JToolBar)e.getChild();
                    Enumeration keys = CMBGenericDocViewer.this.activeToolbars.keys();
                    String name = CMBGenericDocViewer.this.getToolBarName(toolbar);
                    String position = CMBGenericDocViewer.this.toolbarsBorderLayout.getPosition(toolbar);
                    CMBGenericDocViewer.this.putClientProperty(name + ".position", position);
                    if (CMBGenericDocViewer.this.userPrefs != null) {
                        CMBGenericDocViewer.this.userPrefs.put(name + ".position", position);
                    }
                }
            }

            public void componentRemoved(ContainerEvent e) {
            }
        });
        this.toolbarsPanel.add((Component)this.currentLayout.getViewerComponent(), "Center");
        this.add((Component)this.toolbarsPanel, "Center");
        this.setupToolbars();
        this.setupPopupMenus();
        this.toolbarsPanel.setFocusable(false);
        if (this.annoServices != null) {
            this.annoServices.addAnnotationDefaultsChangedListener(new CMBAnnotationDefaultsChangedListener(){

                public void annotationDefaultsChanged(CMBAnnotationDefaultsChangedEvent e) {
                    Properties properties = new Properties();
                    CMBGenericDocViewer.this.annoServices.getDefaultAnnotationProperties(e.getAnnotationClassName(), properties);
                    CMBGenericDocViewer.this.updateUserPreferencesFromProperties(properties);
                }
            });
        }
    }

    private void setDocumentDisplayResolution(CMBDocument document) {
        String methodName = "setDocumentDisplayResolution";
        int displayResolution = 0;
        try {
            displayResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        if (this.configProperties == null) {
            System.out.println(PViewerUtilities.getMessage("DocumentViewer.configPropertiesNotSet"));
        } else {
            String resolution = this.configProperties.getProperty("DisplayResolution");
            if (resolution != null) {
                try {
                    displayResolution = Integer.parseInt(resolution);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (displayResolution != 0) {
                document.setDisplayResolution(displayResolution);
            }
        }
    }

    public void addDocOpenedListener(CMBGenericDocOpenedListener listener) {
        this.docOpenListeners.addElement(listener);
    }

    public void removeDocOpenedListener(CMBGenericDocOpenedListener listener) {
        this.docOpenListeners.removeElement(listener);
    }

    public void fireCMBDocOpenedEvent(CMBDocument document) {
        CMBGenericDocOpenedEvent docOpenedEvent = new CMBGenericDocOpenedEvent(this, document);
        for (int i = 0; i < this.docOpenListeners.size(); ++i) {
            CMBGenericDocOpenedListener listener = (CMBGenericDocOpenedListener)this.docOpenListeners.elementAt(i);
            listener.genericDocOpened(docOpenedEvent);
        }
    }

    public void addDocSelectedListener(CMBGenericDocSelectedListener listener) {
        this.docSelectListeners.addElement(listener);
    }

    public void removeDocSelectedListener(CMBGenericDocSelectedListener listener) {
        this.docSelectListeners.removeElement(listener);
    }

    public void fireCMBDocSelectedEvent(CMBDocument document) {
        CMBGenericDocSelectedEvent docSelectedEvent = new CMBGenericDocSelectedEvent(this, document);
        for (int i = 0; i < this.docSelectListeners.size(); ++i) {
            CMBGenericDocSelectedListener listener = (CMBGenericDocSelectedListener)this.docSelectListeners.elementAt(i);
            listener.genericDocSelected(docSelectedEvent);
        }
    }

    public void addDocStateChangedListener(CMBGenericDocStateChangedListener listener) {
        this.docStateChangedListeners.addElement(listener);
    }

    public void removeDocStateChangedListener(CMBGenericDocStateChangedListener listener) {
        this.docStateChangedListeners.removeElement(listener);
    }

    public void fireCMBDocStateChangedEvent(CMBDocument document, int changeType) {
        int currentPageNumber = 1;
        if (this.getSelectedModel() != null) {
            currentPageNumber = this.getSelectedModel().getCurrentPageNumber();
        }
        CMBGenericDocStateChangedEvent docStateChangedEvent = new CMBGenericDocStateChangedEvent(this, document, new int[]{currentPageNumber}, changeType);
        this.fireCMBDocStateChangedEvent(docStateChangedEvent);
    }

    private void fireCMBDocStateChangedEvent(CMBGenericDocStateChangedEvent docStateChangedEvent) {
        for (int i = 0; i < this.docStateChangedListeners.size(); ++i) {
            CMBGenericDocStateChangedListener listener = (CMBGenericDocStateChangedListener)this.docStateChangedListeners.elementAt(i);
            listener.genericDocStateChanged(docStateChangedEvent);
        }
    }

    public void addDocPrintStatusListener(CMBGenericDocPrintStatusListener listener) {
        this.docPrintStatusListeners.add(listener);
    }

    public void removeDocPrintStatusListener(CMBGenericDocPrintStatusListener listener) {
        this.docPrintStatusListeners.remove(listener);
    }

    void fireCMBDocPrintStatusEvent(int eventType, int documentsQueued, int pagesQueued, CancelablePrintJob printJob, CMBDocument document) {
        CMBGenericDocPrintStatusEvent event = new CMBGenericDocPrintStatusEvent(this, eventType, documentsQueued, pagesQueued, printJob, document);
        for (int i = 0; i < this.docPrintStatusListeners.size(); ++i) {
            CMBGenericDocPrintStatusListener listener = (CMBGenericDocPrintStatusListener)this.docPrintStatusListeners.get(i);
            listener.printStatusChanged(event);
        }
    }

    public void addDocSaveListener(CMBGenericDocSaveListener listener) {
        this.docSaveListeners.add(listener);
    }

    public void removeDocSaveListener(CMBGenericDocSaveListener listener) {
        this.docSaveListeners.remove(listener);
    }

    private void fireCMBDocSaveEvent(CMBDocument document, CMBAnnotationSet annoSet, boolean saveAsNew) {
        String actionCommand = null;
        if (this.getCurrentAction() != null) {
            actionCommand = (String)this.getCurrentAction().getValue("ActionCommandKey");
        }
        CMBGenericDocSaveEvent docSaveEvent = new CMBGenericDocSaveEvent(this, document, annoSet, saveAsNew, actionCommand);
        for (int i = 0; i < this.docSaveListeners.size(); ++i) {
            CMBGenericDocSaveListener listener = (CMBGenericDocSaveListener)this.docSaveListeners.get(i);
            listener.genericDocSave(docSaveEvent);
        }
    }

    public void addDocClosedListener(CMBGenericDocClosedListener listener) {
        this.docClosedListeners.addElement(listener);
    }

    public void removeDocClosedListener(CMBGenericDocClosedListener listener) {
        this.docClosedListeners.removeElement(listener);
    }

    public void fireCMBDocClosedEvent(CMBDocument document) {
        CMBGenericDocClosedEvent docClosedEvent = new CMBGenericDocClosedEvent(this, document);
        for (int i = 0; i < this.docClosedListeners.size(); ++i) {
            CMBGenericDocClosedListener listener = (CMBGenericDocClosedListener)this.docClosedListeners.elementAt(i);
            listener.genericDocClosed(docClosedEvent);
        }
    }

    public void addDocHelpListener(CMBGenericDocHelpListener listener) {
        this.docHelpListeners.addElement(listener);
        this.updateToolStates();
    }

    public void removeDocHelpListener(CMBGenericDocHelpListener listener) {
        this.docHelpListeners.removeElement(listener);
    }

    public void fireCMBDocHelpEvent() {
        CMBGenericDocHelpEvent docHelpEvent = new CMBGenericDocHelpEvent(this);
        for (int i = 0; i < this.docHelpListeners.size(); ++i) {
            CMBGenericDocHelpListener listener = (CMBGenericDocHelpListener)this.docHelpListeners.elementAt(i);
            listener.onHelp(docHelpEvent);
        }
    }

    public void registerKeyboardAction(Action action, KeyStroke keystroke, int inputMapID) {
        String aCommand = (String)action.getValue("ActionCommandKey");
        if (aCommand == null || aCommand.equals("")) {
            aCommand = (String)action.getValue("Name");
        }
        if (aCommand == null || aCommand.equals("")) {
            return;
        }
        this.getInputMap(inputMapID).put(keystroke, aCommand);
        this.getActionMap().put(aCommand, action);
        this.currentLayout.registerKeyboardAction(action, keystroke, inputMapID);
        RegisteredKeyboardAction registeredKeyboardAction = new RegisteredKeyboardAction();
        registeredKeyboardAction.action = action;
        registeredKeyboardAction.keystroke = keystroke;
        registeredKeyboardAction.inputMapID = inputMapID;
        this.registeredKeyboardActions.add(registeredKeyboardAction);
    }

    void reregisterKeyboardActions() {
        for (int i = 0; i < this.registeredKeyboardActions.size(); ++i) {
            RegisteredKeyboardAction registeredKeyboardAction = (RegisteredKeyboardAction)this.registeredKeyboardActions.get(i);
            this.currentLayout.registerKeyboardAction(registeredKeyboardAction.action, registeredKeyboardAction.keystroke, registeredKeyboardAction.inputMapID);
        }
    }

    public synchronized CMBDocument loadDocument(InputStream firstPart, int numberOfParts, String docMimeType, String firstPartMimeType, InputStream annoStream, InputStream resources) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.docServices == null) {
            System.out.println(PViewerUtilities.getMessage("DocumentViewer.docservicesNotSet"));
            return null;
        }
        CMBDocument document = this.docServices.loadDocument(firstPart, numberOfParts, docMimeType, firstPartMimeType, annoStream, resources);
        return document;
    }

    public synchronized CMBAnnotationSet loadAnnotations(InputStream annotations, String format, int annotationPosition, int numberOfParts, int partNumber) throws ClassNotFoundException, IllegalAccessException, InstantiationException, CMBAnnotationEngineException {
        if (this.annoServices == null) {
            System.out.println(PViewerUtilities.getMessage("DocumentViewer.annoservicesNotSet"));
            return null;
        }
        CMBAnnotationSet annotationSet = this.annoServices.loadAnnotationSet(annotations, format, annotationPosition, numberOfParts, partNumber);
        return annotationSet;
    }

    public void setRelatedInfoModified(CMBDocument document, boolean modified) {
        PSingleDocViewer viewer = this.getViewer(document);
        viewer.getDocModel().setRelatedInfoModified(modified);
        this.updateToolStates();
    }

    public boolean canSave() {
        if (this.getSelectedModel() != null && this.getSelectedModel().getCurrentPageNumber() <= 0) {
            return false;
        }
        if (this.getSelectedDocument() != null && this.getSelectedDocument().isModified()) {
            return true;
        }
        if (this.getSelectedAnnotationSet() != null && this.getSelectedAnnotationSet().isDirty()) {
            return true;
        }
        return this.getSelectedModel() != null && this.getSelectedModel().isRelatedInfoModified();
    }

    public void save() {
        if (this.annoServices != null) {
            this.annoServices.commitPen();
        }
        this.save(this.getSelectedDocument(), this.getSelectedAnnotationSet());
    }

    private void save(CMBDocument document, CMBAnnotationSet annoSet) {
        String methodName = "save";
        if (this.docSaveListeners.size() > 0) {
            this.fireCMBDocSaveEvent(document, annoSet, document.isNew());
        } else if (annoSet != null && annoSet.isDirty()) {
            try {
                this.annoServices.saveAnnotationSet(annoSet);
                annoSet.setDirty(false);
            }
            catch (CMBAnnotationEngineException aee) {
                ViewerLogger.logError((Object)this, methodName, aee);
            }
        }
    }

    public void saveAll() {
        if (this.annoServices != null) {
            this.annoServices.commitPen();
        }
        Object[] pageViewers = this.activeViewers.toArray();
        for (int i = 0; i < pageViewers.length; ++i) {
            PSingleDocViewer pageViewer = (PSingleDocViewer)pageViewers[i];
            PDocModel model = pageViewer.getDocModel();
            CMBDocument document = model.getDocument();
            CMBAnnotationSet annoSet = model.getAnnotationSet();
            if (!document.isModified() && (annoSet == null || !annoSet.isDirty()) && !model.isRelatedInfoModified()) continue;
            this.save(document, annoSet);
        }
    }

    public void saveAsNew() {
        if (this.annoServices != null) {
            this.annoServices.commitPen();
        }
        this.fireCMBDocSaveEvent(this.getSelectedDocument(), this.getSelectedAnnotationSet(), true);
    }

    public synchronized void saveAnnotations() {
        String methodName = "saveAnnotations";
        if (this.annoServices == null) {
            return;
        }
        try {
            this.annoServices.commitPen();
            this.annoServices.saveAnnotationSet(this.getSelectedAnnotationSet());
            if (this.getSelectedAnnotationSet() != null) {
                this.getSelectedAnnotationSet().setDirty(false);
            }
            this.updateToolStates();
        }
        catch (CMBAnnotationEngineException aee) {
            ViewerLogger.logError((Object)this, methodName, aee);
        }
    }

    public synchronized void saveAllAnnotations() {
        String methodName = "saveAllAnnotations";
        if (this.annoServices == null) {
            return;
        }
        try {
            Object[] pageViewers = this.activeViewers.toArray();
            for (int i = 0; i < pageViewers.length; ++i) {
                PSingleDocViewer pageViewer = (PSingleDocViewer)pageViewers[i];
                CMBAnnotationSet annoSet = pageViewer.getDocModel().getAnnotationSet();
                if (annoSet == null || !annoSet.isDirty()) continue;
                this.annoServices.saveAnnotationSet(annoSet);
                annoSet.setDirty(false);
            }
        }
        catch (CMBAnnotationEngineException aee) {
            ViewerLogger.logError((Object)this, methodName, aee);
        }
    }

    public boolean canExport() {
        if (this.getSelectedModel() == null) {
            return false;
        }
        return this.getSelectedModel().canExport();
    }

    public void exportDocument(OutputStream exportDocOutputStream, boolean withAnnotations, boolean reduceColors, String destMimetype) throws CMBViewerException, OutOfMemoryError {
        if (!this.canExport()) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        if (this.getSelectedModel() == null || this.getSelectedModel().getDocument() == null) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        String sourceMimeType = this.getSelectedModel().getDocument().getMimeType();
        if (!this.getSelectedModel().document.getEngine().canWriteDocument(sourceMimeType, destMimetype)) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        this.exportDocument(this.getSelectedModel(), exportDocOutputStream, withAnnotations, reduceColors, destMimetype);
    }

    void exportDocument(PDocModel docModel, OutputStream exportDocOutputStream, boolean withAnnotations, boolean reduceColors, String destMimetype) throws CMBViewerException, OutOfMemoryError {
        try {
            CMBDocument exportableDocument;
            if (!(withAnnotations || docModel instanceof PPageModel && ((PPageModel)docModel).getViewablePageNumbers() != null)) {
                exportableDocument = docModel.getDocument();
            } else {
                CMBDocument document = docModel.getDocument();
                CMBAnnotationSet annoSet = docModel.getAnnotationSet();
                ByteArrayOutputStream annoStream = new ByteArrayOutputStream();
                ByteArrayOutputStream docStream = new ByteArrayOutputStream();
                document.write(false, true, docStream, document.getMimeType());
                docStream.close();
                annoSet.write(annoStream);
                annoStream.close();
                byte[] docbytes = docStream.toByteArray();
                byte[] annobytes = annoStream.toByteArray();
                ByteArrayInputStream annoInputStream = new ByteArrayInputStream(annobytes);
                ByteArrayInputStream docInputStream = new ByteArrayInputStream(docbytes);
                String firstPartEncoding = this.docServices.getServiceCallbacks().getPartEncoding(document, 0);
                exportableDocument = this.docServices.loadDocument((InputStream)docInputStream, 1, document.getMimeType(), document.getMimeType(), annoInputStream, null, firstPartEncoding);
                if (docModel instanceof PPageModel) {
                    int[] viewablePageNumbers = ((PPageModel)docModel).getViewablePageNumbers();
                    int pageCount = exportableDocument.getPageCount();
                    if (viewablePageNumbers != null && viewablePageNumbers.length > 0 && viewablePageNumbers.length < pageCount) {
                        int startPage = viewablePageNumbers[viewablePageNumbers.length - 1] + 1;
                        int endPage = pageCount;
                        if (startPage <= endPage) {
                            exportableDocument.deletePages(startPage, endPage);
                        }
                        for (int i = viewablePageNumbers.length - 1; i > 0; --i) {
                            startPage = viewablePageNumbers[i - 1] + 1;
                            endPage = viewablePageNumbers[i] - 1;
                            if (startPage > endPage) continue;
                            exportableDocument.deletePages(startPage, endPage);
                        }
                        startPage = 1;
                        endPage = viewablePageNumbers[0] - 1;
                        if (startPage <= endPage) {
                            exportableDocument.deletePages(startPage, endPage);
                        }
                    }
                }
            }
            exportableDocument.write(withAnnotations, reduceColors, exportDocOutputStream, destMimetype);
            if (exportableDocument != docModel.document) {
                this.docServices.dropDocument(exportableDocument);
            }
        }
        catch (OutOfMemoryError me) {
            throw me;
        }
        catch (Exception e) {
            throw new CMBViewerException(PViewerUtilities.getMessage("exportDialog.cannotBeExported", new Object[]{e.getMessage()}));
        }
    }

    public void export() {
        if (!this.canExport()) {
            return;
        }
        if (this.exportDialog == null) {
            this.exportDialog = new PExportDocumentDialog(this.getOwningFrame(), this.getSelectedModel(), this.docServices, this);
            for (int i = 0; i < this.docHelpListeners.size(); ++i) {
                CMBGenericDocHelpListener listener = (CMBGenericDocHelpListener)this.docHelpListeners.elementAt(i);
                this.exportDialog.addDocHelpListener(listener);
            }
            this.exportDialog.buildLayout();
            this.exportDialog.pack();
            this.exportDialog.setLocationRelativeTo(this);
            this.dialogDisplayed = this.exportDialog;
            this.exportDialog.show();
            this.dialogDisplayed = null;
        } else {
            this.exportDialog.updateDialog(this.getSelectedModel(), this.docServices);
            this.dialogDisplayed = this.exportDialog;
            this.exportDialog.show();
            this.dialogDisplayed = null;
        }
        this.currentLayout.getViewerComponent().requestFocus();
    }

    public void showDocument(CMBDocument document, CMBAnnotationSet annoSet, String docName, String docMimeType) {
        try {
            this._showDocument(document, annoSet, docName, true, false, null);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void showDocument(CMBDocument document, CMBAnnotationSet annoSet, String docName, boolean select) {
        try {
            this._showDocument(document, annoSet, docName, select, false, null);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void _showDocument(final CMBDocument document, CMBAnnotationSet annoSet, String docName, boolean select, boolean viewablePageNumbersProvided, int[] viewablePageNumbers) throws CMBDocumentEngineException, IOException, IllegalArgumentException {
        if (document.getEngine() == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(CMBGenericDocViewer.this.getOwningFrame(), PViewerUtilities.getMessage("DocumentViewer.noEngineSupport", new Object[]{document.getMimeType()}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), -1);
                }
            });
            return;
        }
        this.selectInShow = select;
        if (this.activeViewers.size() < 1) {
            this.selectInShow = true;
        }
        if (this.selectInShow) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.updateToolStates();
        }
        this.setDocumentDisplayResolution(document);
        PSingleDocViewer viewer = this.createSingleDocViewer(document, annoSet, docName);
        this.activeViewers.add(viewer);
        PDocModel docModel = viewer.getDocModel();
        docModel.initUsingProperties(this.configProperties);
        if (this.pageManipulationEnabled) {
            docModel.setPrivilege(3, true);
            docModel.setPrivilege(2, true);
            docModel.setPrivilege(5, true);
            docModel.setPrivilege(4, true);
        } else {
            docModel.setPrivilege(3, false);
            docModel.setPrivilege(2, false);
            docModel.setPrivilege(5, false);
            docModel.setPrivilege(4, true);
        }
        this.currentLayout.addDocView(document, annoSet, docName, this.selectInShow);
        if (viewablePageNumbersProvided) {
            try {
                this.setViewablePageNumbers(viewablePageNumbers);
            }
            catch (IllegalArgumentException iae) {
                this.closeDocument(document);
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.validate();
                this.updateToolStates();
                throw iae;
            }
            catch (IOException ioe) {
                this.closeDocument(document);
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.validate();
                this.updateToolStates();
                throw ioe;
            }
            catch (CMBDocumentEngineException dee) {
                this.closeDocument(document);
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.updateToolStates();
                throw dee;
            }
        }
        if (this.selectInShow) {
            if (this.activeViewers.size() > 1) {
                this.activateDocument(document);
            }
            this.currentLayout.getViewerComponent().requestFocus();
        } else {
            this.buildThumbnails(document);
        }
        this.setShowAnnotations();
        this.fireCMBDocOpenedEvent(document);
        this.validate();
        this.setAnnotationPrivileges(annoSet);
        this.setAnnotationProperties();
        if (this.pageManipulationEnabled && document.getCanManipulatePages() && annoSet != null) {
            annoSet.setPermanentlyRotating(true);
        }
        this.selectInShow = true;
        this.updateToolStates();
        this.testAnnotationCorruption(docName, annoSet);
        if (annoSet != null) {
            annoSet.addAnnCreatedListener(this);
            annoSet.addAnnDeletedListener(this);
            annoSet.addAnnMovedListener(this);
            annoSet.addAnnPropertiesUpdatedListener(this);
            annoSet.addAnnReorderedListener(this);
            annoSet.addAnnResizedListener(this);
            annoSet.addAnnSelectedListener(this);
        }
        viewer.getDocModel().addDocStateChangedListener(this);
    }

    private void setAnnotationPrivileges(CMBAnnotationSet annoSet) {
        String methodName = "setAnnotationPrivileges";
        if (annoSet == null || annoSet.getAnnotationCount() == 0) {
            return;
        }
        try {
            boolean updatePrivilege = annoSet.getPrivilege(50);
            boolean deletePrivilege = annoSet.getPrivilege(62);
            boolean viewPrivilege = annoSet.getPrivilege(7);
            Iterator annotations = annoSet.getIterator();
            CMBPageAnnotation pageanno = null;
            while (annotations.hasNext()) {
                pageanno = (CMBPageAnnotation)annotations.next();
                if (pageanno == null) continue;
                pageanno.setCanUpdate(updatePrivilege);
                pageanno.setCanDelete(deletePrivilege);
                pageanno.setCanShow(viewPrivilege);
            }
        }
        catch (CMBAnnotationEngineException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        this.updateToolStates();
    }

    private void setAnnotationProperties() {
        CMBAnnotationSet annoSet = this.getSelectedAnnotationSet();
        if (annoSet == null || annoSet.getAnnotationCount() == 0) {
            return;
        }
        Iterator annotations = annoSet.getIterator();
        CMBPageAnnotation pageanno = null;
        while (annotations.hasNext()) {
            pageanno = (CMBPageAnnotation)annotations.next();
            if (pageanno == null) continue;
            pageanno.setApplyNow(this.getAnnotationsImmediatePreview());
            pageanno.setVisibleWhileDragging(this.getAnnotationsVisibleWhileDrag());
            if (this.getAnnotationsShow()) {
                pageanno.pleaseDraw();
                continue;
            }
            pageanno.dontDraw();
        }
    }

    public void showDocument(CMBDocument document, CMBAnnotationSet annoSet, String docName) {
        try {
            this._showDocument(document, annoSet, docName, true, false, null);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void showDocument(CMBDocument document, CMBAnnotationSet annoSet, String docName, int[] viewablePageNumbers) throws CMBDocumentEngineException, IOException, IllegalArgumentException {
        this._showDocument(document, annoSet, docName, true, true, viewablePageNumbers);
    }

    private void testAnnotationCorruption(String docName, CMBAnnotationSet annoSet) {
        if (annoSet != null && annoSet.isCorrupt()) {
            JOptionPane.showMessageDialog(this.getOwningFrame(), PViewerUtilities.getMessage("DocumentViewer.annotationCorruption", new Object[]{docName}), PViewerUtilities.getMessage("DocumentViewer.warningMessageTitle"), 2);
        }
    }

    public synchronized void closeDocument() {
        CMBDocument document = this.getSelectedDocument();
        if (document == null) {
            return;
        }
        this.closeDocument(document, true, true);
    }

    public synchronized void closeDocument(CMBDocument document) {
        this.closeDocument(document, true, true);
    }

    public synchronized void closeDocument(CMBDocument document, boolean prompt) {
        this.closeDocument(document, prompt, true);
    }

    public boolean promptBeforeClosing(CMBDocument document) {
        KeyboardFocusManager focusManager;
        Component focusOwner;
        PSingleDocViewer viewer = this.getViewer(document);
        PDocModel docModel = null;
        CMBAnnotationSet annoSet = null;
        if (viewer == null) {
            return true;
        }
        docModel = viewer.getDocModel();
        if (docModel == null) {
            return true;
        }
        annoSet = docModel.getAnnotationSet();
        if (this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 9 && (focusOwner = (focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getFocusOwner()) instanceof JTextField) {
            ((JTextField)focusOwner).postActionEvent();
        }
        if (this.annoServices != null) {
            this.annoServices.commitPen();
        }
        if (document.isModified() || annoSet != null && annoSet.isDirty() || docModel.isRelatedInfoModified()) {
            if (docModel.getCurrentPageNumber() <= 0) {
                this.activateDocument(document);
                int option = POptionPane.showConfirmDialog(this, (Object)PViewerUtilities.getMessage("DocumentViewer.closeWithoutSaveDialogMessage", new String[]{PViewerUtilities.stripHtml(this.getDocName(document))}), PViewerUtilities.getMessage("DocumentViewer.closeWithoutSaveDialogTitle"), 2, 3, null);
                switch (option) {
                    case 0: {
                        break;
                    }
                    case -1: 
                    case 2: {
                        return false;
                    }
                }
            } else {
                this.activateDocument(document);
                int option = POptionPane.showConfirmDialog(this, (Object)PViewerUtilities.getMessage("DocumentViewer.confirmDialogMessage", new String[]{PViewerUtilities.stripHtml(this.getDocName(document))}), PViewerUtilities.getMessage("DocumentViewer.confirmDialogTitle"), 1, 3, null);
                switch (option) {
                    case 0: {
                        this.save();
                        if (!document.isModified()) break;
                        return false;
                    }
                    case 1: {
                        break;
                    }
                    case -1: 
                    case 2: {
                        return false;
                    }
                }
            }
        }
        if (!this.isTerminating && this.isDocumentPrinting(document)) {
            this.activateDocument(document);
            int option = JOptionPane.showConfirmDialog(null, PViewerUtilities.getMessage("DocumentViewer.printWarningDialogMessage", new String[]{PViewerUtilities.stripHtml(this.getDocName(document))}), PViewerUtilities.getMessage("DocumentViewer.printWarningDialogTitle"), 0, 2, null);
            switch (option) {
                case 0: {
                    this.cancelPrintJob(document);
                    break;
                }
                case 1: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private synchronized boolean closeDocument(CMBDocument document, boolean prompt, boolean activate) {
        boolean continueClose;
        KeyboardFocusManager focusManager;
        Component focusOwner;
        String methodName = "closeDocument";
        PSingleDocViewer viewer = this.getViewer(document);
        int index = this.getViewerIndex(viewer);
        int selectedIndex = this.getViewerIndex(this.selectedViewer);
        PDocModel docModel = null;
        CMBAnnotationSet annoSet = null;
        if (viewer == null) {
            return true;
        }
        docModel = viewer.getDocModel();
        if (docModel == null) {
            return true;
        }
        annoSet = docModel.getAnnotationSet();
        if (this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 9 && (focusOwner = (focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getFocusOwner()) instanceof JTextField) {
            ((JTextField)focusOwner).postActionEvent();
        }
        if (this.annoServices != null) {
            this.annoServices.commitPen();
        }
        if (prompt && !(continueClose = this.promptBeforeClosing(document))) {
            return false;
        }
        viewer.getDocModel().removeDocStateChangedListener(this);
        this.removeDocSelectedListener((CMBGenericDocSelectedListener)((Object)viewer.getThumbnailsView()));
        this.currentLayout.closeDocument(document, activate);
        this.activeViewers.remove(this.getViewer(document));
        if (this.activeViewers.size() < 1 && this.getOwningFrame() != null) {
            this.getOwningFrame().requestFocus();
        }
        try {
            viewer.dispose();
        }
        catch (Throwable t) {
            ViewerLogger.logError((Object)this, methodName, t);
        }
        if (index <= selectedIndex) {
            if (index < selectedIndex) {
                this.activateDocument(this.getViewer(selectedIndex - 1).getDocModel().getDocument());
            } else if (index == selectedIndex) {
                this.stopDocViewedTimer();
                if (activate) {
                    this.selectedViewer = this.activeViewers.size() > 0 ? this.getViewer(Math.min(index, this.activeViewers.size() - 1)) : null;
                    if (this.selectedViewer != null && this.activeViewers.size() > 0) {
                        this.activateDocument(this.selectedViewer.getDocModel().getDocument());
                    }
                }
            }
        }
        this.fireCMBDocClosedEvent(document);
        try {
            this.docServices.dropDocument(document);
        }
        catch (Throwable t) {
            ViewerLogger.logError((Object)this, methodName, t);
        }
        try {
            if (this.annoServices != null) {
                this.annoServices.dropAnnotationSet(annoSet);
            }
        }
        catch (Throwable t) {
            ViewerLogger.logError((Object)this, methodName, t);
        }
        return true;
    }

    public synchronized void closeAllDocuments() {
        this.closeAllDocuments(true);
    }

    private synchronized boolean closeAllDocuments(boolean prompt) {
        PSingleDocViewer pageViewer;
        int i;
        String methodName = "closeAllDocuments";
        Object[] pageViewers = this.activeViewers.toArray();
        try {
            if (prompt) {
                for (i = 0; i < pageViewers.length; ++i) {
                    pageViewer = (PSingleDocViewer)pageViewers[i];
                    boolean continueClose = this.promptBeforeClosing(pageViewer.getDocModel().getDocument());
                    if (continueClose) continue;
                    return false;
                }
            }
        }
        catch (RuntimeException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        for (i = 0; i < pageViewers.length; ++i) {
            pageViewer = (PSingleDocViewer)pageViewers[i];
            this.closeDocument(pageViewer.getDocModel().getDocument(), false, false);
        }
        this.selectedViewer = null;
        return true;
    }

    public synchronized boolean terminate() {
        return this.terminate(true);
    }

    public synchronized boolean terminate(boolean prompt) {
        if (this.toolbarsPanel == null) {
            return true;
        }
        this.currentLayout.suspendDocSelectedEvents(true);
        if (this.dialogDisplayed != null) {
            this.dialogDisplayed.dispose();
        }
        this.cancelAllPrintJobs();
        this.isTerminating = true;
        this.closeAllDocuments(prompt);
        if (this.activeViewers.size() > 0) {
            this.isTerminating = false;
            this.currentLayout.suspendDocSelectedEvents(false);
            return false;
        }
        this.clearAllToolbars();
        this.registeredKeyboardActions.clear();
        if (this.actions != null) {
            this.actions.clear();
            this.actions = null;
        }
        this.cleanUpComponents();
        if (this.activeToolbars != null) {
            this.activeToolbars.clear();
            this.activeToolbars = null;
        }
        if (this.docServices != null) {
            this.docServices.terminate();
            this.docServices = null;
        }
        if (this.annoServices != null) {
            this.annoServices.terminate();
            this.annoServices = null;
        }
        this.configProperties = null;
        this.currentAction = null;
        this.cursorTable.clear();
        this.pageFormat = null;
        if (this.printPreference != null) {
            this.printPreference.clear();
            this.printPreference = null;
        }
        this.docOpenListeners.clear();
        this.docSelectListeners.clear();
        this.docStateChangedListeners.clear();
        this.docClosedListeners.clear();
        this.docHelpListeners.clear();
        this.removeAll();
        System.gc();
        return true;
    }

    private void cleanUpComponents() {
        this.pagePopupMenu = null;
        this.doctabPopupMenu = null;
        this.annoPopupMenu = null;
        this.thumbPopupMenu = null;
        this.selectAreaPopupMenu = null;
        this.currentLayout.dispose();
        this.currentLayout = null;
        this.toolbarsPanel.removeAll();
        this.toolbarsPanel = null;
        this.removeAll();
        this.repaint();
    }

    private void clearAllToolbars() {
        Enumeration e = this.activeToolbars.elements();
        while (e.hasMoreElements()) {
            CMBViewerToolbar toolbar = (CMBViewerToolbar)e.nextElement();
            toolbar.dispose();
            Object var2_2 = null;
        }
    }

    public boolean canFirstDocument() {
        return this.activeViewers.indexOf(this.selectedViewer) > 0;
    }

    public void firstDocument() {
        int currentIndex;
        if (this.activeViewers.size() > 0 && (currentIndex = this.activeViewers.indexOf(this.selectedViewer)) > 0) {
            PSingleDocViewer viewer = (PSingleDocViewer)this.activeViewers.elementAt(0);
            this.activateDocument(viewer.getDocModel().getDocument());
        }
    }

    public boolean canPrevDocument() {
        return this.activeViewers.indexOf(this.selectedViewer) > 0;
    }

    public void prevDocument() {
        int currentIndex;
        if (this.activeViewers.size() > 0 && (currentIndex = this.activeViewers.indexOf(this.selectedViewer)) > 0) {
            PSingleDocViewer viewer = (PSingleDocViewer)this.activeViewers.elementAt(currentIndex - 1);
            this.activateDocument(viewer.getDocModel().getDocument());
        }
    }

    public boolean canNextDocument() {
        return this.activeViewers.indexOf(this.selectedViewer) < this.activeViewers.size() - 1;
    }

    public void nextDocument() {
        int currentIndex;
        if (this.activeViewers.size() > 0 && (currentIndex = this.activeViewers.indexOf(this.selectedViewer)) < this.activeViewers.size() - 1) {
            PSingleDocViewer viewer = (PSingleDocViewer)this.activeViewers.elementAt(currentIndex + 1);
            this.activateDocument(viewer.getDocModel().getDocument());
        }
    }

    public boolean canLastDocument() {
        return this.activeViewers.indexOf(this.selectedViewer) < this.activeViewers.size() - 1;
    }

    public void lastDocument() {
        int currentIndex;
        if (this.activeViewers.size() > 0 && (currentIndex = this.activeViewers.indexOf(this.selectedViewer)) < this.activeViewers.size() - 1) {
            PSingleDocViewer viewer = (PSingleDocViewer)this.activeViewers.elementAt(this.activeViewers.size() - 1);
            this.activateDocument(viewer.getDocModel().getDocument());
        }
    }

    public boolean canEnhance() {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            return model.canEnhance();
        }
        return false;
    }

    public boolean canInvert() {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            return model.canInvert();
        }
        return false;
    }

    public void setEnhance(boolean enhance) throws UnsupportedOperationException {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            if (!this.canEnhance()) {
                throw new UnsupportedOperationException(PViewerUtilities.getMessage("Document.cannotBeEnhanced"));
            }
        } else {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.noSelectedDocument"));
        }
        model.setEnhance(enhance);
    }

    public boolean isEnhanced() throws UnsupportedOperationException {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            return model.isEnhance();
        }
        throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.noSelectedDocument"));
    }

    public void setInvert(boolean invert) throws UnsupportedOperationException {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            if (!this.canInvert()) {
                throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.cannotBeInverted"));
            }
        } else {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.noSelectedDocument"));
        }
        model.setInvert(invert);
    }

    public boolean isInverted() throws UnsupportedOperationException {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            return model.isInvert();
        }
        throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.noSelectedDocument"));
    }

    public boolean canPaginate() {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            return model.canPaginate();
        }
        return false;
    }

    public boolean canFirstPage() {
        int currentPagePosition;
        boolean value = false;
        PDocModel model = this.getSelectedModel();
        if (model != null && model instanceof PPageModel && (currentPagePosition = ((PPageModel)model).getCurrentPagePosition()) > 1) {
            value = true;
        }
        return value;
    }

    public void firstPage() throws UnsupportedOperationException {
        PDocModel model;
        if (this.isScrollingLocked()) {
            this.setSelectedViewTemporary(true);
            ((PFullSizePageView)this.getOtherView()).firstPage();
            this.setSelectedViewTemporary(false);
        }
        if ((model = this.getSelectedModel()) == null || !(model instanceof PPageModel)) {
            throw new UnsupportedOperationException();
        }
        ((PPageModel)model).firstPage();
    }

    public boolean canLastPage() {
        int pageCount;
        int currentPagePosition;
        boolean value = false;
        PDocModel model = this.getSelectedModel();
        if (model != null && model instanceof PPageModel && (currentPagePosition = ((PPageModel)model).getCurrentPagePosition()) < (pageCount = ((PPageModel)model).getPageCount())) {
            value = true;
        }
        return value;
    }

    public void lastPage() throws UnsupportedOperationException {
        PDocModel model;
        if (this.isScrollingLocked()) {
            this.setSelectedViewTemporary(true);
            ((PFullSizePageView)this.getOtherView()).lastPage();
            this.setSelectedViewTemporary(false);
        }
        if ((model = this.getSelectedModel()) == null || !(model instanceof PPageModel)) {
            throw new UnsupportedOperationException();
        }
        ((PPageModel)model).lastPage();
    }

    public boolean canPrevPage() {
        int currentPagePosition;
        boolean value = false;
        PDocModel model = this.getSelectedModel();
        if (model != null && model instanceof PPageModel && (currentPagePosition = ((PPageModel)model).getCurrentPagePosition()) > 1) {
            value = true;
        }
        return value;
    }

    public void prevPage() throws UnsupportedOperationException {
        PDocModel model;
        if (this.isScrollingLocked()) {
            this.setSelectedViewTemporary(true);
            ((PFullSizePageView)this.getOtherView()).prevPage();
            this.setSelectedViewTemporary(false);
        }
        if ((model = this.getSelectedModel()) == null || !(model instanceof PPageModel)) {
            throw new UnsupportedOperationException();
        }
        ((PPageModel)model).prevPage();
    }

    public boolean canNextPage() {
        boolean value = false;
        PDocModel model = this.getSelectedModel();
        if (model != null && model instanceof PPageModel) {
            int currentPagePosition = ((PPageModel)model).getCurrentPagePosition();
            int pageCount = ((PPageModel)model).getPageCount();
            if (pageCount > currentPagePosition) {
                value = true;
            } else if (pageCount == -1 && ((PPageModel)model).isValidPagePosition(currentPagePosition + 1)) {
                value = true;
            }
        }
        return value;
    }

    public void nextPage() throws UnsupportedOperationException {
        PDocModel model;
        if (this.isScrollingLocked()) {
            this.setSelectedViewTemporary(true);
            ((PFullSizePageView)this.getOtherView()).nextPage();
            this.setSelectedViewTemporary(false);
        }
        if ((model = this.getSelectedModel()) == null || !(model instanceof PPageModel)) {
            throw new UnsupportedOperationException();
        }
        ((PPageModel)model).nextPage();
    }

    public boolean canUndo() {
        if (this.getSelectedModel() == null) {
            return false;
        }
        if (this.isDocumentPrinting(this.getSelectedDocument())) {
            return false;
        }
        return this.getSelectedModel().getTaskManager().canUndo();
    }

    private String getUndoDescription() {
        if (this.getSelectedModel() == null) {
            return "";
        }
        return this.getSelectedModel().getTaskManager().getUndoDescription();
    }

    public void undo() {
        new PUndoTask(this.getSelectedModel().getTaskManager());
    }

    public boolean canRedo() {
        if (this.getSelectedModel() == null) {
            return false;
        }
        if (this.isDocumentPrinting(this.getSelectedDocument())) {
            return false;
        }
        return this.getSelectedModel().getTaskManager().canRedo();
    }

    private String getRedoDescription() {
        if (this.getSelectedModel() == null) {
            return "";
        }
        return this.getSelectedModel().getTaskManager().getRedoDescription();
    }

    public void redo() {
        new PRedoTask(this.getSelectedModel().getTaskManager());
    }

    public void addToUndoQueue(CMBViewerTask task) {
        this.getSelectedModel().getTaskManager().invokeTask(task, false);
        this.updateToolStates();
    }

    void updateThumbnailImages(int startPage, int endPage) {
        if (this.selectedViewer != null && this.selectedViewer.getThumbnailsView() != null) {
            this.selectedViewer.getThumbnailsView().updateThumbnails(startPage, endPage);
        }
    }

    void updateThumbnailImages() {
        this.updateThumbnailImages(1, this.getPageCount());
    }

    void updateThumbnailImages(int[] selectedPages) {
        PPageModel model = (PPageModel)this.getSelectedModel();
        for (int i = 0; i < selectedPages.length; ++i) {
            this.updateThumbnailImages(model.getPagePosition(selectedPages[i]), model.getPagePosition(selectedPages[i]));
        }
    }

    public void addDocStateChangedListener(CMBDocStateChangedListener listener) {
        this.getSelectedModel().addDocStateChangedListener(listener);
    }

    public void removeDocStateChangedListener(CMBDocStateChangedListener listener) {
        this.getSelectedModel().removeDocStateChangedListener(listener);
    }

    public void fireCMBDocStateChangedEvent(CMBDocument document) {
        this.fireCMBDocStateChangedEvent(document, 0);
    }

    public void handleDocStateChangedEvent(CMBDocument document) {
    }

    public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
        int currAnnotationTool = 0;
        if (this.getAnnotationServices() != null) {
            currAnnotationTool = this.getSelectedAnnotationTool();
        }
        int currentPageNumber = 1;
        if (this.getSelectedModel() != null) {
            currentPageNumber = this.getSelectedModel().getCurrentPageNumber();
        }
        if (this.getAnnotationServices() != null && evt.getChangeType() == 1) {
            this.getAnnotationServices().commitPen();
        }
        this.checkPageCountForStickyTool();
        this.updateToolStates();
        if (this.getAnnotationServices() != null && (evt.getChangeType() == 12 || evt.getChangeType() == 1)) {
            this.setSelectedAnnotation(null);
        }
        this.fireCMBDocStateChangedEvent(evt);
        if (this.getCurrentMode() != 113) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.getCurrentMode() == 113 && evt.getChangeType() == 25) {
            this.setCurrentMode(111);
        }
        if (this.getCurrentMode() == 111 && currAnnotationTool != 0 && this.isAnnotationToolSticky() && currentPageNumber > 0) {
            this.setCursorFromSelectedAnnotationTool();
        }
        if (this.getCurrentMode() == 113 && this.canSelectText() && evt.getChangeType() != 25 && evt.getChangeType() != 20 && evt.getChangeType() != 2 && evt.getChangeType() != 23) {
            this.selectText();
        }
        if (this.getCurrentMode() == 112 && evt.getChangeType() != 11) {
            this.setSelectAreaRectangle(new Rectangle(0, 0, 0, 0));
        }
    }

    public void setCurrentMode(int mode) throws IllegalArgumentException {
        switch (mode) {
            case 111: {
                int oldMode = this.getCurrentMode();
                if (this.annoServices == null) {
                    this.currentMode = mode;
                } else {
                    this.annoServices.setIdleDrawingMode();
                }
                if (oldMode != mode) {
                    this.getSelectedModel().fireDocStateChangedEvent(10);
                }
                this.updateToolStates();
                break;
            }
            case 112: {
                if (this.annoServices == null) {
                    this.currentMode = 112;
                    break;
                }
                int oldMode = this.getCurrentMode();
                this.currentMode = 112;
                if (oldMode != mode) {
                    this.getSelectedModel().fireDocStateChangedEvent(11);
                }
                this.annoServices.setSelectAreaMode();
                break;
            }
            case 113: {
                if (!this.canSelectText()) break;
                int oldMode = this.getCurrentMode();
                this.currentMode = 113;
                if (oldMode != mode) {
                    this.getSelectedModel().fireDocStateChangedEvent(11);
                }
                if (this.annoServices == null) break;
                this.annoServices.setSelectAreaMode();
                break;
            }
            default: {
                throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentViewer.invalidMode", new Object[]{new Integer(mode)}));
            }
        }
    }

    public int getCurrentMode() {
        if (this.annoServices == null) {
            return this.currentMode;
        }
        if (this.annoServices.isSelectAreaMode()) {
            if (this.currentMode == 113) {
                return 113;
            }
            return 112;
        }
        return 111;
    }

    public int getCurrentPageNumber() {
        return this.getSelectedModel().getCurrentPageNumber();
    }

    public int getPageCount() throws UnsupportedOperationException {
        String methodName = "getPageCount";
        CMBDocument document = this.getSelectedDocument();
        if (document != null) {
            try {
                return document.getPageCount();
            }
            catch (IOException ioe) {
                ViewerLogger.logError((Object)this, methodName, ioe);
                return 0;
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean isPageCountDetermined() {
        PDocModel model = this.getSelectedModel();
        if (model == null) {
            return false;
        }
        return model.getPageCount() > -1;
    }

    public void stateChanged(ChangeEvent event) {
    }

    void updateToolStates() {
        String methodName = "updateToolStates";
        if (this.isSelectedViewTemporary()) {
            return;
        }
        try {
            PDocModel docModel;
            boolean bCreateAnnoPrivilege = false;
            boolean bDeleteAnnoPrivilege = false;
            boolean bViewAnnoPrivilege = false;
            boolean bUpdateAnnoPrivilege = false;
            CMBAnnotationSet selectedAnno = this.getSelectedAnnotationSet();
            if (selectedAnno != null) {
                try {
                    bCreateAnnoPrivilege = selectedAnno.getPrivilege(8);
                    bDeleteAnnoPrivilege = selectedAnno.getPrivilege(62);
                    bViewAnnoPrivilege = selectedAnno.getPrivilege(7);
                    bUpdateAnnoPrivilege = selectedAnno.getPrivilege(50);
                }
                catch (CMBAnnotationEngineException aee) {
                    ViewerLogger.logError((Object)this, methodName, aee);
                }
            }
            boolean isDocNonEmpty = (docModel = this.getSelectedModel()) != null && docModel.getCurrentPageNumber() > 0;
            this.getAction("save_doc").setEnabled(this.canSave());
            this.getAction("new_doc").setEnabled(this.canCreateDocument());
            if (this.actions.get("export_doc") != null) {
                this.getAction("export_doc").setEnabled(this.canExport());
            }
            this.getAction("save_as").setEnabled(this.getSelectedDocument() != null && isDocNonEmpty);
            this.getAction("print").setEnabled(this.canPrint());
            this.getAction("print_all").setEnabled(this.canPrintAllDocuments());
            this.getAction("selectAll").setEnabled(this.canSelectAllPages());
            this.getAction("deselectAll").setEnabled(this.canDeselectAll());
            this.getAction("cut").setEnabled(this.canCut());
            this.updateToolDescriptions("cut", this.getCutDescription());
            this.getAction("copy").setEnabled(this.canCopy());
            this.updateToolDescriptions("copy", this.getCopyDescription());
            this.getAction("paste").setEnabled(this.canPaste());
            this.updateToolDescriptions("paste", this.getPasteDescription());
            this.getAction("delete").setEnabled(this.canDelete());
            this.updateToolDescriptions("delete", this.getDeleteDescription());
            this.getAction("undo").setEnabled(this.canUndo());
            this.updateToolDescriptions("undo", this.getUndoDescription());
            this.getAction("redo").setEnabled(this.canRedo());
            this.updateToolDescriptions("redo", this.getRedoDescription());
            this.getAction("rotate_90").setEnabled(this.canRotate());
            this.getAction("rotate_180").setEnabled(this.canRotate());
            this.getAction("rotate_270").setEnabled(this.canRotate());
            this.getAction("rotate_pages").setEnabled(this.canRotate());
            this.getAction("zoom_in").setEnabled(this.canZoomIn());
            this.getAction("zoom_out").setEnabled(this.canZoomOut());
            this.getAction("zoom_custom").setEnabled(this.canZoomIn() || this.canZoomOut());
            this.getAction("fit_height").setEnabled(this.canZoomIn() || this.canZoomOut());
            ((CMBViewerAction)this.getAction("fit_height")).setSelected(this.getSelectedView() != null && this.getSelectedView().getFit() == 2);
            this.getAction("fit_width").setEnabled(this.canZoomIn() || this.canZoomOut());
            ((CMBViewerAction)this.getAction("fit_width")).setSelected(this.getSelectedView() != null && this.getSelectedView().getFit() == 1);
            this.getAction("fit_window").setEnabled(this.canZoomIn() || this.canZoomOut());
            ((CMBViewerAction)this.getAction("fit_window")).setSelected(this.getSelectedView() != null && this.getSelectedView().getFit() == 3);
            this.getAction("fit_actualsize").setEnabled(this.canZoomIn() || this.canZoomOut());
            ((CMBViewerAction)this.getAction("fit_actualsize")).setSelected(this.getSelectedView() != null && this.getSelectedView().getFit() == 4 && this.getSelectedModel() != null && this.getSelectedModel().getScale() == 1.0);
            this.getAction("enhance").setEnabled(this.canEnhance());
            ((CMBViewerAction)this.getAction("enhance")).setSelected(this.getSelectedModel() != null && this.canEnhance() && this.isEnhanced());
            this.getAction("invert").setEnabled(this.canInvert());
            ((CMBViewerAction)this.getAction("invert")).setSelected(this.getSelectedModel() != null && this.isInverted());
            this.getAction("find").setEnabled(this.canFind());
            CMBViewerAction showHideThumbAction = (CMBViewerAction)this.getAction("showhidethumb");
            showHideThumbAction.setEnabled(isDocNonEmpty && this.getViewerLayout() != 3);
            showHideThumbAction.setSelected(this.getSelectedModel() != null && this.bShowThumbnails && this.getViewerLayout() != 3);
            this.getAction("close_doc").setEnabled(this.getSelectedModel() != null);
            this.getAction("close_all_doc").setEnabled(this.activeViewers.size() > 0);
            this.getAction("help").setEnabled(!this.docHelpListeners.isEmpty());
            boolean canSelectArea = this.getSelectedModel() != null && this.getSelectedView() != null;
            this.getAction("selectArea").setEnabled(canSelectArea && isDocNonEmpty);
            ((CMBViewerAction)this.getAction("selectArea")).setSelected(canSelectArea && isDocNonEmpty && this.getCurrentMode() == 112);
            boolean canCreateAnnotation = docModel != null && this.getSelectedView() != null && bCreateAnnoPrivilege && !this.isDocumentPrinting(docModel.getDocument());
            boolean canSelectAnnotation = docModel != null && this.getSelectedView() != null && bViewAnnoPrivilege;
            this.getAction("pointer").setEnabled((canCreateAnnotation || canSelectAnnotation) && isDocNonEmpty);
            ((CMBViewerAction)this.getAction("pointer")).setSelected((canCreateAnnotation || canSelectAnnotation) && isDocNonEmpty && this.getCurrentMode() == 111 && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 0);
            this.getAction("Arrow").setEnabled(canCreateAnnotation && isDocNonEmpty);
            ((CMBViewerAction)this.getAction("Arrow")).setSelected(canCreateAnnotation && isDocNonEmpty && this.getCurrentMode() == 111 && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 1);
            this.getAction("Circle").setEnabled(canCreateAnnotation && isDocNonEmpty);
            ((CMBViewerAction)this.getAction("Circle")).setSelected(canCreateAnnotation && isDocNonEmpty && this.getCurrentMode() == 111 && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 2);
            this.getAction("Highlight").setEnabled(canCreateAnnotation && isDocNonEmpty);
            ((CMBViewerAction)this.getAction("Highlight")).setSelected(canCreateAnnotation && isDocNonEmpty && this.getCurrentMode() == 111 && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 3);
            this.getAction("Line").setEnabled(canCreateAnnotation && isDocNonEmpty);
            ((CMBViewerAction)this.getAction("Line")).setSelected(canCreateAnnotation && isDocNonEmpty && this.getCurrentMode() == 111 && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 4);
            this.getAction("Note").setEnabled(canCreateAnnotation && isDocNonEmpty);
            ((CMBViewerAction)this.getAction("Note")).setSelected(canCreateAnnotation && isDocNonEmpty && this.getCurrentMode() == 111 && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 5);
            this.getAction("Pen").setEnabled(canCreateAnnotation && isDocNonEmpty);
            ((CMBViewerAction)this.getAction("Pen")).setSelected(canCreateAnnotation && isDocNonEmpty && this.getCurrentMode() == 111 && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 6);
            this.getAction("Rect").setEnabled(canCreateAnnotation && isDocNonEmpty);
            ((CMBViewerAction)this.getAction("Rect")).setSelected(canCreateAnnotation && isDocNonEmpty && this.getCurrentMode() == 111 && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 7);
            this.getAction("Stamp").setEnabled(canCreateAnnotation && isDocNonEmpty);
            ((CMBViewerAction)this.getAction("Stamp")).setSelected(canCreateAnnotation && isDocNonEmpty && this.getCurrentMode() == 111 && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 8);
            this.getAction("Text").setEnabled(canCreateAnnotation && isDocNonEmpty);
            ((CMBViewerAction)this.getAction("Text")).setSelected(canCreateAnnotation && isDocNonEmpty && this.getCurrentMode() == 111 && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 9);
            boolean annotationSelected = this.getAnnotationServices() != null && this.getSelectedAnnotation() != null;
            boolean canUpdateAnnotation = this.getAnnotationServices() != null && this.getSelectedAnnotation() != null && this.getSelectedAnnotation().canUpdate() && this.getSelectedAnnotationSet().isEditable();
            this.getAction("move_front").setEnabled(canUpdateAnnotation && isDocNonEmpty);
            this.getAction("send_back").setEnabled(canUpdateAnnotation && isDocNonEmpty);
            this.getAction("properties").setEnabled(annotationSelected && isDocNonEmpty);
            boolean annotationExistsInDocument = this.getSelectedAnnotationSet() != null && this.getSelectedAnnotationSet().getAnnotationCount() > 0;
            boolean annotationExistsOnPage = this.getSelectedAnnotationSet() != null && this.getSelectedAnnotationSet().getPageAnnotations(this.getCurrentPageNumber()).length > 0;
            CMBViewerAction hideShowAnnotationsAction = (CMBViewerAction)this.getAction("hide_show");
            hideShowAnnotationsAction.setEnabled(annotationExistsInDocument && (bCreateAnnoPrivilege || bViewAnnoPrivilege) && isDocNonEmpty);
            boolean annotationsShowing = annotationExistsInDocument && (bCreateAnnoPrivilege || bViewAnnoPrivilege) && this.getAnnotationsShow() && isDocNonEmpty;
            hideShowAnnotationsAction.setSelected(annotationsShowing);
            boolean canEraseAnnotation = docModel != null && bDeleteAnnoPrivilege && (bCreateAnnoPrivilege || bViewAnnoPrivilege) && isDocNonEmpty && !this.isDocumentPrinting(docModel.getDocument());
            this.getAction("eraser").setEnabled(annotationExistsOnPage && canEraseAnnotation);
            ((CMBViewerAction)this.getAction("eraser")).setSelected(annotationExistsOnPage && canEraseAnnotation && this.getAnnotationServices() != null && this.getSelectedAnnotationTool() == 20);
            this.getAction("page_first").setEnabled(this.canFirstPage());
            this.getAction("page_prev").setEnabled(this.canPrevPage());
            this.getAction("goto_page").setEnabled(this.isPageCountDetermined() && (this.canNextPage() || this.canPrevPage()));
            this.getAction("page_next").setEnabled(this.canNextPage());
            this.getAction("page_last").setEnabled(this.canLastPage());
            this.getAction("doc_first").setEnabled(this.canFirstDocument());
            this.getAction("doc_prev").setEnabled(this.canPrevDocument());
            this.getAction("doc_next").setEnabled(this.canNextDocument());
            this.getAction("doc_last").setEnabled(this.canLastDocument());
            ((CMBViewerAction)this.getAction("layout_tabbed")).setSelected(this.getViewerLayout() == 0);
            ((CMBViewerAction)this.getAction("layout_split_horizontal")).setSelected(this.getViewerLayout() == 1);
            ((CMBViewerAction)this.getAction("layout_split_vertical")).setSelected(this.getViewerLayout() == 2);
            ((CMBViewerAction)this.getAction("layout_thumbnails_only")).setSelected(this.getViewerLayout() == 3);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    boolean isSelectedViewTemporary() {
        return this.selectedViewTemporary;
    }

    private void updateToolDescriptions(String toolName, String descriptionInsert) {
        Action action = this.getAction(toolName);
        String description = (String)action.getValue("UNFORMATTED_NAME");
        if (description == null) {
            description = (String)action.getValue("Name");
            action.putValue("UNFORMATTED_NAME", description);
        }
        description = MessageFormat.format(description, descriptionInsert);
        action.putValue("Name", description);
        description = (String)action.getValue("UNFORMATTED_DESCRIPTION");
        if (description == null) {
            description = (String)action.getValue("ShortDescription");
            action.putValue("UNFORMATTED_DESCRIPTION", description);
        }
        description = MessageFormat.format(description, descriptionInsert);
        action.putValue("ShortDescription", description);
    }

    public CMBDocument getSelectedDocument() {
        if (this.selectedViewer == null) {
            return null;
        }
        if (this.selectedViewer.getDocModel() == null) {
            return null;
        }
        return this.selectedViewer.getDocModel().getDocument();
    }

    public CMBAnnotationSet getSelectedAnnotationSet() {
        if (this.selectedViewer == null) {
            return null;
        }
        if (this.selectedViewer.getDocModel() == null) {
            return null;
        }
        return this.selectedViewer.getDocModel().getAnnotationSet();
    }

    public CMBAnnotationSet getAnnotationSetForDocument(CMBDocument doc) {
        return this.getViewer(doc).getDocModel().getAnnotationSet();
    }

    PSingleDocViewer getSelectedViewer() {
        return this.selectedViewer;
    }

    PSingleDocViewer getViewer(CMBDocument doc) {
        for (int i = 0; i < this.activeViewers.size(); ++i) {
            PSingleDocViewer viewer = (PSingleDocViewer)this.activeViewers.get(i);
            if (viewer.getDocModel().getDocument() != doc) continue;
            return viewer;
        }
        return null;
    }

    PFullSizeView getSelectedView() {
        if (this.currentLayout == null) {
            return null;
        }
        return this.currentLayout.getSelectedFullSizeView();
    }

    PFullSizeView getOtherView() {
        if (this.currentLayout == null) {
            return null;
        }
        return this.currentLayout.getOtherFullSizeView();
    }

    PThumbnailsView getSelectedThumbnailView() {
        if (this.selectedViewer == null) {
            return null;
        }
        return this.selectedViewer.getThumbnailsView();
    }

    PDocModel getSelectedModel() {
        if (this.selectedViewer == null) {
            return null;
        }
        return this.selectedViewer.getDocModel();
    }

    public void activateDocument(CMBDocument document) {
        if (this.getSelectedAnnotationSet() != null) {
            this.getSelectedAnnotationSet().setActive(false);
        }
        this.currentLayout.activateDocument(document);
        if (this.getAnnotationServices() != null && !this.isAnnotationToolSticky() && this.getSelectedAnnotationTool() != 0) {
            this.setSelectedAnnotationTool(0);
        }
        this.updateToolStates();
        this.setCursorFromSelectedAnnotationTool();
        if (this.getSelectedAnnotationSet() != null) {
            this.getSelectedAnnotationSet().setActive(true);
        }
    }

    public void setCurrentPageNumber(int pageNumber) throws ArrayIndexOutOfBoundsException, UnsupportedOperationException {
        PDocModel docModel = this.getSelectedModel();
        if (docModel == null) {
            throw new UnsupportedOperationException();
        }
        docModel.setCurrentPageNumber(pageNumber);
    }

    private void buildThumbnails(CMBDocument document) {
        PThumbnailsView thumbView = null;
        PSingleDocViewer viewer = this.getViewer(document);
        if (viewer != null && (thumbView = viewer.getThumbnailsView()) != null && this.bShowThumbnails) {
            try {
                thumbView.buildThumbnails();
            }
            catch (Exception e) {
                System.out.println(PViewerUtilities.getMessage("DocumentViewer.thumbnailsNotBuilt") + e);
            }
        }
    }

    void setupThumbnailPopupMenu(PThumbnailsView thumbnailView) {
        thumbnailView.setPopupMenu(this.thumbPopupMenu, "thumbpopup");
    }

    void setupPageViewPopupMenus(PDocView pageView) {
        pageView.setPopupMenu(this.pagePopupMenu, "pagepopup");
        pageView.setPopupMenu(this.doctabPopupMenu, "doctabpopup");
        pageView.setPopupMenu(this.selectAreaPopupMenu, "selectareapopup");
        this.setAnnoPopupMenu(this.annoPopupMenu);
    }

    private void setDocumentEditable(boolean editable) {
        this.isEditable = editable;
    }

    private boolean isDocumentEditable() {
        return this.isEditable;
    }

    public void addToolbar(JToolBar toolbar, String name, String position) {
        String propShowName;
        this.activeToolbars.put(name, toolbar);
        String propPosName = name + ".position";
        this.putClientProperty(propPosName, position);
        this.addPropertyChangeListener(propPosName, this.propertyHandler);
        if (this.systemPrefs != null && this.systemPrefsUpdateAccess && !this.keyExists(this.systemPrefs, propPosName)) {
            this.systemPrefs.put(propPosName, position);
        }
        if (!this.systemProperties.containsKey(propPosName)) {
            PViewerUtilities.setStringProperty(propPosName, this.systemProperties, position);
        }
        if (this.getClientProperty(propShowName = name + ".show") == null) {
            String propValue = this.configProperties.getProperty(propShowName, "true");
            this.putClientProperty(propShowName, new Boolean(propValue));
        }
        this.addPropertyChangeListener(propShowName, this.propertyHandler);
        boolean tbShow = (Boolean)this.getClientProperty(propShowName);
        if (this.systemPrefs != null && this.systemPrefsUpdateAccess && !this.keyExists(this.systemPrefs, propShowName)) {
            this.systemPrefs.putBoolean(propShowName, tbShow);
        }
        if (!this.systemProperties.containsKey(propShowName)) {
            PViewerUtilities.setBooleanProperty(propShowName, this.systemProperties, tbShow);
        }
        if (!tbShow) {
            return;
        }
        try {
            if (position.equalsIgnoreCase("NORTH")) {
                toolbar.setAlignmentX(0.0f);
                toolbar.setOrientation(0);
                this.toolbarsPanel.add((Component)toolbar, "North");
            } else if (position.equalsIgnoreCase("SOUTH")) {
                toolbar.setAlignmentX(0.0f);
                toolbar.setOrientation(0);
                this.toolbarsPanel.add((Component)toolbar, "South");
            } else if (position.equalsIgnoreCase("EAST")) {
                toolbar.setAlignmentY(0.0f);
                toolbar.setOrientation(1);
                this.toolbarsPanel.add((Component)toolbar, "East");
            } else {
                toolbar.setAlignmentY(0.0f);
                toolbar.setOrientation(1);
                this.toolbarsPanel.add((Component)toolbar, "West");
            }
        }
        catch (IllegalArgumentException ilae) {
            toolbar.setAlignmentX(0.0f);
            this.toolbarsPanel.add((Component)toolbar, "North");
        }
    }

    private void setToolbarVisible(String tbName, boolean b) {
        JToolBar tb = this.getToolBar(tbName);
        if (tb != null) {
            if (b) {
                this.removeToolbar(tbName);
                this.addToolbar(tb, tbName, ((CMBViewerToolbar)tb).getPosition());
                this.validate();
            } else {
                if (((BasicToolBarUI)tb.getUI()).isFloating()) {
                    BasicToolBarUI ui = (BasicToolBarUI)tb.getUI();
                    ui.setFloating(false, null);
                }
                if (tb.getParent() != null) {
                    Container c = tb.getParent();
                    c.remove(tb);
                    c.validate();
                }
            }
            tb.setVisible(b);
        }
    }

    boolean isToolbarVisible(String tbName) {
        String propertyName = tbName + ".show";
        Object propertyValue = this.getClientProperty(propertyName);
        if (propertyValue != null) {
            return (Boolean)propertyValue;
        }
        JToolBar tb = this.getToolBar(tbName);
        return tb.isVisible();
    }

    private String getToolbarPosition(String tbName) {
        CMBViewerToolbar tb = (CMBViewerToolbar)this.getToolBar(tbName);
        return tb.getPosition();
    }

    private void setToolbarPosition(String tbName, String position) {
        CMBViewerToolbar tb = (CMBViewerToolbar)this.getToolBar(tbName);
        if (this.isToolbarVisible(tbName)) {
            Method m_isFloating = null;
            Method m_setFloating = null;
            try {
                m_isFloating = tb.getUI().getClass().getMethod("isFloating", null);
                boolean isFloating = (Boolean)m_isFloating.invoke((Object)tb.getUI(), null);
                if (isFloating) {
                    Class[] args = new Class[]{Boolean.TYPE, Point.class};
                    m_setFloating = tb.getUI().getClass().getMethod("setFloating", args);
                    m_setFloating.invoke((Object)tb.getUI(), Boolean.FALSE, null);
                }
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e1) {
            }
            catch (IllegalAccessException e1) {
            }
            catch (InvocationTargetException e1) {
                // empty catch block
            }
            if (!this.getToolbarPosition(tbName).equalsIgnoreCase(position)) {
                this.removeToolbar(tbName);
                this.addToolbar(tb, tbName, position);
                this.validate();
            }
        }
        tb.setPosition(position);
    }

    public JToolBar removeToolbar(String name) {
        JToolBar toolbar = (JToolBar)this.activeToolbars.remove(name);
        if (toolbar != null && toolbar.getParent() != null) {
            toolbar.getParent().remove(toolbar);
        }
        return toolbar;
    }

    public JToolBar getToolBar(String name) {
        return (JToolBar)this.activeToolbars.get(name);
    }

    String getToolBarName(JToolBar toolbar) {
        Enumeration e = this.activeToolbars.keys();
        boolean found = false;
        while (e.hasMoreElements() && !found) {
            String key = (String)e.nextElement();
            JToolBar object = this.getToolBar(key);
            if (!toolbar.equals(object)) continue;
            found = true;
            return key;
        }
        return null;
    }

    public void setAllToolbarsVisible(boolean visible) {
        Enumeration e = this.activeToolbars.elements();
        while (e.hasMoreElements()) {
            JToolBar toolbar = (JToolBar)e.nextElement();
            toolbar.setVisible(visible);
        }
    }

    public JToolBar[] getAllToolbars() {
        if (this.activeToolbars == null || this.activeToolbars.isEmpty()) {
            return new JToolBar[0];
        }
        int toolbarSize = this.activeToolbars.size();
        JToolBar[] toolbarArray = new JToolBar[toolbarSize];
        Enumeration e = this.activeToolbars.elements();
        JToolBar toolbar = null;
        int i = 0;
        while (e.hasMoreElements()) {
            toolbarArray[i] = toolbar = (JToolBar)e.nextElement();
            ++i;
        }
        return toolbarArray;
    }

    private void setupToolbars() {
        String methodName = "setUpToolbars";
        try {
            if (this.configProperties == null) {
                System.out.println(PViewerUtilities.getMessage("DocumentViewer.configPropertiesNotSet"));
                return;
            }
            String toolbarNames = this.configProperties.getProperty("Toolbars");
            if (toolbarNames != null) {
                StringTokenizer tok = new StringTokenizer(toolbarNames, VIEWER_CONFIG_DELIM);
                while (tok.hasMoreTokens()) {
                    String toolbarName = tok.nextToken();
                    String position = this.configProperties.getProperty(toolbarName + ".position", "NORTH");
                    CMBViewerToolbar toolbar = new CMBViewerToolbar(this);
                    toolbar.setOrder(this.toolbarOrder++);
                    String displayName = this.configProperties.getProperty(toolbarName + ".displayName");
                    if (displayName != null) {
                        toolbar.setName(displayName);
                    }
                    if (position.equals("NORTH") || position.equals("SOUTH")) {
                        toolbar.setOrientation(0);
                    } else {
                        toolbar.setOrientation(1);
                    }
                    toolbar.setPosition(position);
                    toolbar.getAccessibleContext().setAccessibleName(toolbarName);
                    String tools = this.configProperties.getProperty(toolbarName + ".tools");
                    if (tools == null) continue;
                    StringTokenizer toolstok = new StringTokenizer(tools, VIEWER_CONFIG_DELIM);
                    while (toolstok.hasMoreTokens()) {
                        String toolName = toolstok.nextToken().trim();
                        if (toolName.equals("separator")) {
                            toolbar.addSeparator();
                            continue;
                        }
                        Action action = this.createAction(toolName);
                        String toolClassName = this.getConfigPropertyOrMessage(toolName + ".class");
                        if (toolClassName != null && toolClassName.length() > 0) {
                            try {
                                Class<?> toolClass = Class.forName(toolClassName);
                                Constructor<?> toolConstructor = toolClass.getConstructor(CMBGenericDocViewer.class);
                                JComponent tool = (JComponent)toolConstructor.newInstance(this);
                                String tooltip = this.getConfigPropertyOrMessage(toolName + ".tooltip");
                                if (tooltip == null) {
                                    tooltip = "";
                                }
                                try {
                                    if (tooltip.indexOf("{0") >= 0) {
                                        String formattedTooltip;
                                        tooltip = formattedTooltip = MessageFormat.format(tooltip, "");
                                    }
                                    tool.setToolTipText(tooltip);
                                    int count = tool.getComponentCount();
                                    for (int i = 0; i < count; ++i) {
                                        JComponent component = (JComponent)tool.getComponent(i);
                                        component.setToolTipText(tooltip);
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                if (tool instanceof PDropDownButton) {
                                    String toolTools = this.getConfigPropertyOrMessage(toolName + ".tools");
                                    StringTokenizer toolToolsTok = new StringTokenizer(toolTools, VIEWER_CONFIG_DELIM);
                                    ArrayList<Action> toolToolActions = new ArrayList<Action>();
                                    while (toolToolsTok.hasMoreTokens()) {
                                        String toolToolName = toolToolsTok.nextToken().trim();
                                        Action toolToolAction = this.createAction(toolToolName);
                                        this.loadIconsAndCursors(toolToolName, toolToolAction, null);
                                        toolToolActions.add(toolToolAction);
                                    }
                                    Action[] actions = new Action[toolToolActions.size()];
                                    toolToolActions.toArray(actions);
                                    ((PDropDownButton)tool).setTools(actions);
                                    JButton selectedToolButton = ((PDropDownButton)tool).getSelectedToolButton();
                                    toolbar.addActionComponent(selectedToolButton);
                                    toolbar.addActionComponent(action, tool);
                                    continue;
                                }
                                toolbar.addActionComponent(action, tool);
                            }
                            catch (Exception e) {
                                ViewerLogger.logError((Object)this, methodName, e);
                            }
                            continue;
                        }
                        String isToggle = this.getConfigPropertyOrMessage(toolName + ".toggle");
                        if (isToggle != null && isToggle.equals("true")) {
                            JToggleButton toggle = new JToggleButton(action);
                            if (action instanceof CMBViewerAction) {
                                action.putValue("Toggle", new Boolean(true));
                                ((CMBViewerAction)action).addComponent(toggle);
                            }
                            toolbar.addActionComponent(toggle);
                        } else {
                            toolbar.addActionComponent(action);
                        }
                        action.addPropertyChangeListener(toolbar);
                    }
                    this.addToolbar(toolbar, toolbarName, position);
                }
            }
            this.validate();
        }
        catch (Exception e) {
            ViewerLogger.logError(this, methodName, "Error in setupToolbars()", e);
        }
        CMBViewerToolbar toolBar = null;
        Component[] toolButtons = null;
        Action toolAction = null;
        Enumeration e = this.activeToolbars.keys();
        while (e.hasMoreElements()) {
            String toolBarName = (String)e.nextElement();
            toolBar = (CMBViewerToolbar)this.getToolBar(toolBarName);
            toolButtons = toolBar.getComponents();
            for (int toolIndex = 0; toolIndex < toolButtons.length; ++toolIndex) {
                if (!(toolButtons[toolIndex] instanceof AbstractButton)) continue;
                String toolName = ((AbstractButton)toolButtons[toolIndex]).getActionCommand();
                toolAction = toolBar.getAction(toolName);
                this.loadIconsAndCursors(toolName, toolAction, (AbstractButton)toolButtons[toolIndex]);
            }
        }
        this.updateToolStates();
    }

    private void loadIconsAndCursors(String name, Action action, AbstractButton button) {
        Object normalIconUrl = null;
        AbstractButton toolButton = button;
        String normalIconStr = this.getConfigPropertyOrMessage(name + ".icon");
        ImageIcon normalIcon = this.getImageIcon(normalIconStr);
        if (normalIcon == null) {
            String label = this.configProperties.getProperty(name + ".label");
            if (label != null) {
                button.setText(label);
            }
        } else {
            int underscore = normalIconStr.lastIndexOf(95);
            String iconPrefix = null;
            try {
                iconPrefix = normalIconStr.substring(0, underscore);
            }
            catch (Exception e) {
                System.out.println("Exception :" + e);
                return;
            }
            if (iconPrefix == null) {
                return;
            }
            if (action != null) {
                action.putValue("SmallIcon", normalIcon);
            }
        }
        String cursorStr = this.getConfigPropertyOrMessage(name + ".cursor");
        if (cursorStr != null) {
            Point hotspot;
            String hotspotStr = this.getConfigPropertyOrMessage(name + ".hotspot");
            if (hotspotStr != null) {
                StringTokenizer tokenizer = new StringTokenizer(hotspotStr, VIEWER_CONFIG_DELIM);
                int x = new Integer(tokenizer.nextToken());
                int y = new Integer(tokenizer.nextToken());
                hotspot = new Point(x, y);
            } else {
                hotspot = new Point(1, 1);
            }
            if (this.getAnnotationServices() != null) {
                Cursor cursor = this.getAnnotationServices().createCustomCursor(cursorStr, hotspot);
                this.cursorTable.put(name, cursor);
            }
        }
    }

    private void setupPopupMenus() {
        this.pagePopupMenu = new JPopupMenu();
        this.pagePopupMenu.setLightWeightPopupEnabled(false);
        this.setupPopupMenu(this.pagePopupMenu, "pagepopup");
        this.selectAreaPopupMenu = new JPopupMenu();
        this.selectAreaPopupMenu.setLightWeightPopupEnabled(false);
        this.setupPopupMenu(this.selectAreaPopupMenu, "selectareapopup");
        this.doctabPopupMenu = new JPopupMenu();
        this.doctabPopupMenu.setLightWeightPopupEnabled(false);
        this.setupPopupMenu(this.doctabPopupMenu, "doctabpopup");
        this.annoPopupMenu = new JPopupMenu();
        this.annoPopupMenu.setLightWeightPopupEnabled(false);
        this.setupPopupMenu(this.annoPopupMenu, "annotationpopup");
        this.thumbPopupMenu = new JPopupMenu();
        this.thumbPopupMenu.setLightWeightPopupEnabled(false);
        this.setupPopupMenu(this.thumbPopupMenu, "thumbpopup");
    }

    private boolean setupPopupMenu(JPopupMenu popupMenu, String popupMenuName) {
        boolean bHasSubMenuItem = false;
        boolean bHasSubMenu = false;
        boolean bHasItem = false;
        boolean ltr = PViewerUtilities.isLeftToRight();
        ComponentOrientation compOri = ComponentOrientation.LEFT_TO_RIGHT;
        if (!ltr) {
            compOri = ComponentOrientation.RIGHT_TO_LEFT;
        }
        try {
            String items;
            if (this.configProperties == null) {
                System.out.println(PViewerUtilities.getMessage("DocumentViewer.configPropertiesNotSet"));
                return false;
            }
            popupMenu.setComponentOrientation(compOri);
            String subMenus = this.configProperties.getProperty(popupMenuName + ".submenus");
            if (subMenus != null) {
                StringTokenizer tokSubMenu = new StringTokenizer(subMenus, VIEWER_CONFIG_DELIM);
                while (tokSubMenu.hasMoreTokens()) {
                    String subMenuName = tokSubMenu.nextToken();
                    JMenu popsubMenu = this.setupSubMenu(subMenuName);
                    popupMenu.add(popsubMenu);
                    bHasSubMenuItem = true;
                }
                if (bHasSubMenuItem) {
                    bHasSubMenu = true;
                }
            }
            if ((items = this.configProperties.getProperty(popupMenuName + ".items")) != null) {
                StringTokenizer tokItem = new StringTokenizer(items, VIEWER_CONFIG_DELIM);
                while (tokItem.hasMoreTokens()) {
                    String itemName = tokItem.nextToken();
                    if (itemName.equalsIgnoreCase("separator")) {
                        popupMenu.addSeparator();
                        continue;
                    }
                    String subitems = this.configProperties.getProperty(itemName + ".items");
                    if (subitems != null) {
                        JMenu popsubMenu = this.setupSubMenu(itemName);
                        popupMenu.add(popsubMenu);
                        bHasSubMenuItem = true;
                        continue;
                    }
                    JMenuItem mItemName = popupMenu.add(this.getAction(itemName));
                    if (!ltr) {
                        mItemName.setAccelerator(null);
                    }
                    mItemName.setComponentOrientation(compOri);
                }
                bHasItem = true;
            }
        }
        catch (Exception e) {
            System.err.println("Error in setting up PopupMenu" + popupMenuName);
        }
        return bHasSubMenu || bHasItem;
    }

    private JMenu setupSubMenu(String subMenuName) {
        String subMenuDisplayName = this.getConfigPropertyOrMessage(subMenuName + ".label");
        if (subMenuDisplayName == null) {
            subMenuDisplayName = "";
        }
        JMenu popsubMenu = new JMenu(subMenuDisplayName);
        boolean ltr = PViewerUtilities.isLeftToRight();
        ComponentOrientation compOri = ComponentOrientation.LEFT_TO_RIGHT;
        if (!ltr) {
            compOri = ComponentOrientation.RIGHT_TO_LEFT;
        }
        popsubMenu.setComponentOrientation(compOri);
        String items = this.configProperties.getProperty(subMenuName + ".items");
        if (items != null) {
            StringTokenizer tokItem = new StringTokenizer(items, VIEWER_CONFIG_DELIM);
            while (tokItem.hasMoreTokens()) {
                String itemName = tokItem.nextToken();
                if (itemName.equalsIgnoreCase("separator")) {
                    popsubMenu.addSeparator();
                    continue;
                }
                JMenuItem mItemName = popsubMenu.add(this.getAction(itemName));
                if (!ltr) {
                    mItemName.setAccelerator(null);
                }
                mItemName.setComponentOrientation(compOri);
            }
        }
        return popsubMenu;
    }

    public Action createAction(String name) {
        String isToggle;
        String methodName = "createAction";
        Action action = null;
        if (this.actions.contains(name)) {
            return (Action)this.actions.get(name);
        }
        String actionClassName = this.getConfigPropertyOrMessage(name + ".className");
        if (actionClassName == null) {
            action = new CMBViewerAction(this, name);
        } else {
            try {
                Class<?> actionClass = this.getClass().getClassLoader().loadClass(actionClassName);
                Constructor<?> actionClassConstructor = actionClass.getConstructor(CMBGenericDocViewer.class, String.class);
                action = (Action)actionClassConstructor.newInstance(this, name);
            }
            catch (Exception e) {
                ViewerLogger.logError((Object)this, methodName, e);
                action = new CMBViewerAction(this, name);
            }
        }
        String label = this.getConfigPropertyOrMessage(name + ".label");
        if (label == null) {
            label = "";
        }
        try {
            action.putValue("UNFORMATTED_NAME", label);
            if (label.indexOf("{0") >= 0) {
                String formattedName = MessageFormat.format(label, "");
                action.putValue("Name", formattedName);
            } else {
                action.putValue("Name", label);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String tooltip = this.getConfigPropertyOrMessage(name + ".tooltip");
        if (tooltip == null) {
            tooltip = "";
        }
        try {
            action.putValue("UNFORMATTED_DESCRIPTION", tooltip);
            if (tooltip.indexOf("{0") >= 0) {
                String formattedTooltip = MessageFormat.format(tooltip, "");
                action.putValue("ShortDescription", formattedTooltip);
            } else {
                action.putValue("ShortDescription", tooltip);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String keyStr = this.getConfigPropertyOrMessage(name + ".key");
        if (keyStr != null) {
            try {
                KeyStroke ks = KeyStroke.getKeyStroke(keyStr);
                action.putValue("AcceleratorKey", ks);
                this.registerKeyboardAction(action, ks, 1);
                this.registerKeyboardAction(action, ks, 2);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((isToggle = this.getConfigPropertyOrMessage(name + ".toggle")) != null && isToggle.equals("true")) {
            action.putValue("toggle", new Boolean(true));
        }
        this.actions.put(name, action);
        return action;
    }

    String getConfigPropertyOrMessage(String key) {
        String name = this.configProperties.getProperty(key);
        if (name == null) {
            name = PViewerUtilities.getMessage(key);
        }
        if (name.equals(key)) {
            name = null;
        }
        return name;
    }

    ImageIcon getImageIcon(String name) {
        ImageIcon img_icon = null;
        if (name == null) {
            return null;
        }
        URL img_url = this.getClass().getClassLoader().getResource(name);
        if (img_url == null) {
            img_url = this.getClass().getClassLoader().getResource("com/ibm/mm/viewer/images/" + name);
        }
        if (img_url == null) {
            return null;
        }
        try {
            URLConnection img_conn = img_url.openConnection();
            img_conn.setUseCaches(true);
            InputStream img_is = img_conn.getInputStream();
            int imgSize = img_is.available();
            byte[] img_data = new byte[imgSize];
            for (int offRead = 0; offRead < imgSize; offRead += img_is.read(img_data, offRead, imgSize - offRead)) {
            }
            img_is.close();
            img_icon = new ImageIcon(img_data);
        }
        catch (IOException ignore) {
            System.err.println("Creating image icon for " + img_url.toString() + " failed.");
            return null;
        }
        if (img_icon == null) {
            return null;
        }
        return img_icon;
    }

    public Action getAction(String name) {
        Action act = null;
        act = (Action)this.actions.get(name);
        if (act == null) {
            act = this.createAction(name);
        }
        return act;
    }

    public Action[] getAllActions() {
        if (this.actions == null || this.actions.isEmpty()) {
            return new Action[0];
        }
        int actionSize = this.actions.size();
        Action[] actionArray = new Action[actionSize];
        Enumeration e = this.actions.elements();
        Action action = null;
        int i = 0;
        while (e.hasMoreElements()) {
            actionArray[i] = action = (Action)e.nextElement();
            ++i;
        }
        return actionArray;
    }

    public boolean canScale() {
        PFullSizeView view = this.getSelectedView();
        if (view != null) {
            return view.canScale();
        }
        return false;
    }

    public boolean canFitHeight() {
        boolean value = false;
        PFullSizeView view = this.getSelectedView();
        if (view != null) {
            value = view.canFitHeight();
        }
        return value;
    }

    public void fitHeight() throws UnsupportedOperationException {
        PFullSizeView view;
        if (this.isScrollingLocked()) {
            this.setSelectedViewTemporary(true);
            ((PFullSizePageView)this.getOtherView()).setViewFit(2);
            ((PFullSizePageView)this.getOtherView()).refit();
            ((PFullSizePageView)this.getOtherView()).display();
            this.setSelectedViewTemporary(false);
        }
        if ((view = this.getSelectedView()) == null) {
            throw new UnsupportedOperationException();
        }
        view.fitHeight();
    }

    public boolean canFitWidth() {
        boolean value = false;
        PFullSizeView view = this.getSelectedView();
        if (view != null) {
            value = view.canFitWidth();
        }
        return value;
    }

    public void fitWidth() throws UnsupportedOperationException {
        PFullSizeView view;
        if (this.isScrollingLocked()) {
            this.setSelectedViewTemporary(true);
            ((PFullSizePageView)this.getOtherView()).setViewFit(1);
            ((PFullSizePageView)this.getOtherView()).refit();
            ((PFullSizePageView)this.getOtherView()).display();
            this.setSelectedViewTemporary(false);
        }
        if ((view = this.getSelectedView()) == null) {
            throw new UnsupportedOperationException();
        }
        view.fitWidth();
    }

    public boolean canFitInWindow() {
        boolean value = false;
        PFullSizeView view = this.getSelectedView();
        if (view != null) {
            value = view.canFitInWindow();
        }
        return value;
    }

    public void fitInWindow() throws UnsupportedOperationException {
        PFullSizeView view;
        if (this.isScrollingLocked()) {
            this.setSelectedViewTemporary(true);
            ((PFullSizePageView)this.getOtherView()).setViewFit(3);
            ((PFullSizePageView)this.getOtherView()).refit();
            ((PFullSizePageView)this.getOtherView()).display();
            this.setSelectedViewTemporary(false);
        }
        if ((view = this.getSelectedView()) == null) {
            throw new UnsupportedOperationException();
        }
        view.fitInWindow();
    }

    public boolean canFitActualSize() {
        boolean value = false;
        PFullSizeView view = this.getSelectedView();
        if (view != null) {
            value = view.canFitActualSize();
        }
        return value;
    }

    public void fitActualSize() throws UnsupportedOperationException {
        PFullSizeView view;
        if (this.isScrollingLocked()) {
            this.setSelectedViewTemporary(true);
            ((PFullSizePageView)this.getOtherView()).setViewFit(4);
            ((PFullSizePageView)this.getOtherView()).refit();
            ((PFullSizePageView)this.getOtherView()).display();
            this.setSelectedViewTemporary(false);
        }
        if ((view = this.getSelectedView()) == null) {
            throw new UnsupportedOperationException();
        }
        view.fitActualSize();
    }

    public boolean canZoomIn() {
        PFullSizeView view = this.getSelectedView();
        if (view != null) {
            return view.canZoomIn();
        }
        return false;
    }

    public void zoomIn() throws UnsupportedOperationException {
        PFullSizeView view;
        if (this.isScrollingLocked()) {
            this.setSelectedViewTemporary(true);
            ((PFullSizePageView)this.getOtherView()).zoomInOtherView();
            ((PFullSizePageView)this.getOtherView()).refit();
            ((PFullSizePageView)this.getOtherView()).display();
            this.setSelectedViewTemporary(false);
        }
        if ((view = this.getSelectedView()) == null) {
            throw new UnsupportedOperationException();
        }
        view.zoomIn();
    }

    public boolean canZoomOut() {
        PFullSizeView view = this.getSelectedView();
        if (view != null) {
            return view.canZoomOut();
        }
        return false;
    }

    public void zoomOut() throws UnsupportedOperationException {
        PFullSizeView view;
        if (this.isScrollingLocked()) {
            this.setSelectedViewTemporary(true);
            ((PFullSizePageView)this.getOtherView()).zoomOutOtherView();
            ((PFullSizePageView)this.getOtherView()).refit();
            ((PFullSizePageView)this.getOtherView()).display();
            this.setSelectedViewTemporary(false);
        }
        if ((view = this.getSelectedView()) == null) {
            throw new UnsupportedOperationException();
        }
        view.zoomOut();
    }

    public void setZoomFactor(double newZoomFactor) throws IllegalArgumentException, UnsupportedOperationException {
        PDocModel model = this.getSelectedModel();
        if (newZoomFactor < 0.0 || newZoomFactor > 1.0) {
            throw new IllegalArgumentException();
        }
        if (model == null) {
            throw new UnsupportedOperationException();
        }
        model.setZoomFactor(newZoomFactor);
    }

    public double getZoomFactor() throws UnsupportedOperationException {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            return model.getZoomFactor();
        }
        throw new UnsupportedOperationException();
    }

    void zoom() {
        PFullSizeView view = this.getSelectedView();
        int viewHt = (int)view.getVisibleRect().getHeight();
        int viewWd = (int)view.getVisibleRect().getWidth();
        JScrollPane scrollPane = (JScrollPane)view.getParent().getParent();
        this.zoomCustom(view, new Dimension(viewWd, viewHt), this, scrollPane.getVerticalScrollBar().getPreferredSize().width, scrollPane.getHorizontalScrollBar().getPreferredSize().height);
        this.getSelectedView().requestFocus();
    }

    private void zoomCustom(PFullSizeView view, Dimension viewDim, CMBGenericDocViewer viewer, int vScrollBarWidth, int hScrollBarHeight) {
        String option;
        String options = PViewerUtilities.getMessage("DocumentViewer.ZoomCustomOptions");
        StringTokenizer tok = new StringTokenizer(options, VIEWER_CONFIG_DELIM);
        int count = tok.countTokens();
        ArrayList<String> optionsList = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String option2 = tok.nextToken();
            if (option2.endsWith(PViewerUtilities.getMessage("DocumentViewer.ZoomPercentageSymbol"))) {
                String numberString = option2.substring(0, option2.length() - 1);
                double scaleValueOfOption = (double)new Integer(numberString.trim()).intValue() / 100.0;
                if (this.getSelectedModel() instanceof PPageModel) {
                    PPageModel model = (PPageModel)this.getSelectedModel();
                    CMBPage page = model.getPage(model.getCurrentPageNumber());
                    if (!(page.getMaxScale() >= scaleValueOfOption)) continue;
                    optionsList.add(option2);
                    continue;
                }
                optionsList.add(option2);
                continue;
            }
            optionsList.add(option2);
        }
        Object choice = POptionPane.showInputDialog(viewer, PViewerUtilities.getMessage("DocumentViewer.ZoomCustomMessage"), PViewerUtilities.getMessage("DocumentViewer.ZoomCustomTitle"), optionsList.toArray(), this.currentZoomOption);
        if (choice == null) {
            return;
        }
        this.currentZoomOption = option = (String)choice;
        if (option.endsWith(PViewerUtilities.getMessage("DocumentViewer.ZoomPercentageSymbol"))) {
            String numberString = option.substring(0, option.length() - 1);
            int newscalePercent = new Integer(numberString.trim());
            this.setScale((double)newscalePercent / 100.0);
        } else if (option.equals(PViewerUtilities.getMessage("DocumentViewer.FitHeight"))) {
            this.fitHeight();
        } else if (option.equals(PViewerUtilities.getMessage("DocumentViewer.FitWidth"))) {
            this.fitWidth();
        } else if (option.equals(PViewerUtilities.getMessage("DocumentViewer.FitInWindow"))) {
            this.fitInWindow();
        } else if (option.equals(PViewerUtilities.getMessage("DocumentViewer.ActualSize"))) {
            this.fitActualSize();
        }
    }

    public int getRotation() throws UnsupportedOperationException {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            return model.getRotation();
        }
        throw new UnsupportedOperationException();
    }

    public boolean canRotate() {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            if (!this.isPageManipulationEnabled()) {
                return model.canRotate();
            }
            return model.canRotate() && !this.isDocumentPrinting(this.getSelectedModel().getDocument());
        }
        return false;
    }

    public void setRotation(int newRotation) throws IllegalArgumentException, UnsupportedOperationException {
        if (!this.isRotationValid(newRotation)) {
            throw new IllegalArgumentException();
        }
        PDocModel model = this.getSelectedModel();
        if (model == null || !(model instanceof PPageModel)) {
            throw new UnsupportedOperationException();
        }
        ((PPageModel)model).setRotation(newRotation);
        this.updateThumbnailImages();
    }

    public int getPageRotation(int pageNumber) throws ArrayIndexOutOfBoundsException, UnsupportedOperationException {
        PDocModel model = this.getSelectedModel();
        if (model != null && model instanceof PPageModel) {
            if (!((PPageModel)model).isPageValid(pageNumber)) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return ((PPageModel)model).getPageRotation(pageNumber);
        }
        throw new UnsupportedOperationException();
    }

    public void setPageRotation(int newRotation, int pageNumber) throws IllegalArgumentException, UnsupportedOperationException, ArrayIndexOutOfBoundsException {
        if (!this.isRotationValid(newRotation)) {
            throw new IllegalArgumentException();
        }
        PDocModel model = this.getSelectedModel();
        if (model != null && model instanceof PPageModel) {
            if (!((PPageModel)model).isPageValid(pageNumber)) {
                throw new ArrayIndexOutOfBoundsException();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        ((PPageModel)model).setPageRotation(newRotation, pageNumber);
        this.updateThumbnailImages(((PPageModel)model).getPagePosition(pageNumber), ((PPageModel)model).getPagePosition(pageNumber));
    }

    public void rotatePages(int newRotation, int startPage, int endPage) throws IllegalArgumentException, UnsupportedOperationException, ArrayIndexOutOfBoundsException {
        int[] pages;
        if (!this.isRotationValid(newRotation)) {
            throw new IllegalArgumentException();
        }
        PDocModel model = this.getSelectedModel();
        PFullSizeView view = this.getSelectedView();
        if (model != null && model instanceof PPageModel) {
            if (!((PPageModel)model).isPageRangeValid(startPage, endPage)) {
                throw new ArrayIndexOutOfBoundsException();
            }
            pages = new int[endPage - startPage + 1];
            if (startPage == 0 && endPage == 0) {
                pages = this.getSelectedPageNumbers();
            } else {
                for (int i = 0; i < endPage - startPage + 1; ++i) {
                    pages[i] = startPage + i;
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
        new PRotatePagesTask(model.getTaskManager(), this, pages, newRotation);
    }

    boolean isRotationValid(int newRotation) {
        boolean value = false;
        switch (newRotation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                value = true;
                break;
            }
            default: {
                value = false;
            }
        }
        return value;
    }

    public Dimension getImageSize() {
        PFullSizeView view = this.getSelectedView();
        Dimension imageSize = new Dimension();
        if (view != null && view instanceof PFullSizePageView) {
            imageSize.height = ((PFullSizePageView)view).getImageHeight();
            imageSize.width = ((PFullSizePageView)view).getImageWidth();
            return imageSize;
        }
        throw new UnsupportedOperationException();
    }

    public double getScale() {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            return model.getScale();
        }
        throw new UnsupportedOperationException();
    }

    public void setScale(double newScale) throws IllegalArgumentException, UnsupportedOperationException {
        PFullSizeView view;
        if (newScale <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.isScrollingLocked()) {
            this.setSelectedViewTemporary(true);
            ((PFullSizePageView)this.getOtherView()).setViewScale(newScale);
            ((PFullSizePageView)this.getOtherView()).refit();
            ((PFullSizePageView)this.getOtherView()).display();
            this.setSelectedViewTemporary(false);
        }
        if ((view = this.getSelectedView()) == null) {
            throw new UnsupportedOperationException();
        }
        view.setScale(newScale);
    }

    public void setBrightness(int brightness) throws IllegalArgumentException {
        if (brightness < 0 || brightness > 200) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentViewer.balanceInvalidValue", new Object[]{new Integer(brightness)}));
        }
        PDocModel model = this.getSelectedModel();
        if (model == null || !(model instanceof PPageModel)) {
            throw new UnsupportedOperationException();
        }
        ((PPageModel)model).setBrightness(brightness, this.getCurrentPageNumber());
        this.updateThumbnailImages(((PPageModel)model).getPagePosition(this.getCurrentPageNumber()), ((PPageModel)model).getPagePosition(this.getCurrentPageNumber()));
    }

    public int getBrightness() {
        PDocModel model = this.getSelectedModel();
        if (model != null && model instanceof PPageModel) {
            return ((PPageModel)model).getBrightness(this.getCurrentPageNumber());
        }
        throw new UnsupportedOperationException();
    }

    public void setContrast(int contrast) throws IllegalArgumentException {
        if (contrast < 0 || contrast > 200) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentViewer.balanceInvalidValue", new Object[]{new Integer(contrast)}));
        }
        PDocModel model = this.getSelectedModel();
        if (model == null || !(model instanceof PPageModel)) {
            throw new UnsupportedOperationException();
        }
        ((PPageModel)model).setContrast(contrast, this.getCurrentPageNumber());
        this.updateThumbnailImages(((PPageModel)model).getPagePosition(this.getCurrentPageNumber()), ((PPageModel)model).getPagePosition(this.getCurrentPageNumber()));
    }

    public int getContrast() {
        PDocModel model = this.getSelectedModel();
        if (model != null && model instanceof PPageModel) {
            return ((PPageModel)model).getContrast(this.getCurrentPageNumber());
        }
        throw new UnsupportedOperationException();
    }

    public boolean canBalance() {
        PDocModel model = this.getSelectedModel();
        if (model == null) {
            return false;
        }
        if (this.getCurrentPageNumber() <= 0) {
            return false;
        }
        if (!(model instanceof PPageModel)) {
            return false;
        }
        return ((PPageModel)model).canBalance();
    }

    public void setBalance(int brightness, int contrast) throws IllegalArgumentException {
        if (brightness < 0 || brightness > 200) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentViewer.balanceInvalidValue", new Object[]{new Integer(brightness)}));
        }
        if (contrast < 0 || contrast > 200) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentViewer.balanceInvalidValue", new Object[]{new Integer(contrast)}));
        }
        PDocModel model = this.getSelectedModel();
        if (model == null || !(model instanceof PPageModel)) {
            throw new UnsupportedOperationException();
        }
        ((PPageModel)model).setBalance(brightness, contrast, this.getCurrentPageNumber());
        this.updateThumbnailImages(((PPageModel)model).getPagePosition(this.getCurrentPageNumber()), ((PPageModel)model).getPagePosition(this.getCurrentPageNumber()));
    }

    public Rectangle getCurrentViewRectangle() throws UnsupportedOperationException {
        PDocModel model = this.getSelectedModel();
        if (model != null && model instanceof PPageModel) {
            return ((PPageModel)model).getCurrentViewRectangle();
        }
        throw new UnsupportedOperationException();
    }

    public void moveCurrentViewRectangle(int x, int y) throws IllegalArgumentException, UnsupportedOperationException {
        PFullSizeView view;
        if (this.isScrollingLocked()) {
            JScrollPane scrollPane = (JScrollPane)this.getOtherView().getParent().getParent();
            boolean hScroll = scrollPane.getHorizontalScrollBar().isVisible();
            boolean vScroll = scrollPane.getVerticalScrollBar().isVisible();
            if (hScroll || vScroll) {
                this.setSelectedViewTemporary(true);
                ((PFullSizePageView)this.getOtherView()).setViewRectangleLocation(x, y);
                ((PFullSizePageView)this.getOtherView()).refit();
                ((PFullSizePageView)this.getOtherView()).display();
                this.setSelectedViewTemporary(false);
            }
        }
        if ((view = this.getSelectedView()) != null && view instanceof PFullSizePageView) {
            int imageH = ((PFullSizePageView)view).getImageHeight();
            int imageW = ((PFullSizePageView)view).getImageWidth();
            if (x < 0 || x > imageW && y < 0 || y > imageH) {
                throw new IllegalArgumentException();
            }
            JScrollPane scrollPane = (JScrollPane)view.getParent().getParent();
            boolean hScroll = scrollPane.getHorizontalScrollBar().isVisible();
            boolean vScroll = scrollPane.getVerticalScrollBar().isVisible();
            if (!hScroll && !vScroll) {
                throw new UnsupportedOperationException();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        ((PFullSizePageView)view).moveCurrentViewRect(x, y);
    }

    public void setTabPlacement(int position) {
        this.tabPosition = position;
        this.currentLayout.setTabPlacement(position);
    }

    public void setThumbnailsPosition(String position) {
        if (!(position.equalsIgnoreCase("North") || position.equalsIgnoreCase("South") || position.equalsIgnoreCase("East") || position.equalsIgnoreCase("West"))) {
            throw new IllegalArgumentException(position);
        }
        this.putClientProperty("Thumbnailbar.position", position);
    }

    private void _setThumbnailsPosition(String position) {
        if (this.thumbnailsPosition.equalsIgnoreCase(position)) {
            return;
        }
        this.thumbnailsPosition = position;
        this.currentLayout.setThumbnailsPosition(this.thumbnailsPosition);
    }

    PSingleDocViewer[] getViewers() {
        Object[] viewersArray = new PSingleDocViewer[this.activeViewers.size()];
        this.activeViewers.copyInto(viewersArray);
        return viewersArray;
    }

    int getViewerCount() {
        return this.activeViewers.size();
    }

    PSingleDocViewer getViewer(int index) {
        return (PSingleDocViewer)this.activeViewers.get(index);
    }

    int getViewerIndex(PSingleDocViewer viewer) {
        for (int i = 0; i < this.activeViewers.size(); ++i) {
            if (this.activeViewers.get(i) != viewer) continue;
            return i;
        }
        return -1;
    }

    void setSelectedViewer(PSingleDocViewer viewer) {
        this.selectedViewer = viewer;
    }

    public boolean canLockScrolling() {
        if (this.currentLayout == null) {
            return false;
        }
        if (this.getSelectedModel() == null) {
            return false;
        }
        return this.getViewerLayout() == 1 || this.getViewerLayout() == 2;
    }

    public boolean isScrollingLocked() {
        return this.scrollingLocked;
    }

    public void lockScrolling() {
        if (!this.canLockScrolling()) {
            return;
        }
        if (this.isScrollingLocked()) {
            this._unlockScrolling();
        } else {
            this._lockScrolling();
        }
    }

    private void _unlockScrolling() {
        this.scrollingLocked = false;
        if (this.currentLayout instanceof PSplitViewerLayout) {
            ((PSplitViewerLayout)this.currentLayout).setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void _lockScrolling() {
        this.scrollingLocked = true;
        if (this.currentLayout instanceof PSplitViewerLayout) {
            ((PSplitViewerLayout)this.currentLayout).setBorder(BorderFactory.createLineBorder(SystemColor.windowBorder, 3));
        }
        this.fitInWindow();
    }

    public String getThumbnailsPosition() {
        return this.thumbnailsPosition;
    }

    public JPanel getThumbnailsPanel() {
        return this.currentLayout.getThumbnailsPanel();
    }

    public void showThumbnails(boolean bShowThumbnails) {
        this.putClientProperty("Thumbnailbar.show", bShowThumbnails);
    }

    private void _showThumbnails(boolean show) {
        if (!show && this.canDockThumbnails() && !this.areThumbnailsDocked()) {
            this.dockThumbnails(true);
        }
        this.bShowThumbnails = show;
        this.currentLayout.showThumbnails(show);
    }

    public void showThumbnails() {
        this.showThumbnails(!this.bShowThumbnails);
    }

    public boolean areThumbnailsShowing() {
        return this.bShowThumbnails;
    }

    public boolean areThumbnailsDocked() {
        return this.thumbnailsDocked;
    }

    public void dockThumbnails(boolean bDockThumbnails) {
        this.putClientProperty("Thumbnails.dock", bDockThumbnails);
    }

    private void _dockThumbnails(boolean dock) {
        this.thumbnailsDocked = dock;
        if (dock) {
            this._dockThumbnails();
        } else {
            this._undockThumbnails();
        }
    }

    public void dockThumbnails() {
        this.dockThumbnails(!this.areThumbnailsDocked());
    }

    public boolean canDockThumbnails() {
        if (this.currentLayout == null) {
            return false;
        }
        if (this.getViewerLayout() == 3) {
            return false;
        }
        if (this.getSelectedModel() == null) {
            return false;
        }
        if (this.getSelectedModel().getCurrentPageNumber() < 1) {
            return false;
        }
        return this.areThumbnailsShowing();
    }

    private void updateMapWithAction(String keyName, JComponent component) {
        Action a = this.getActionMap().get(keyName);
        if (a == null) {
            return;
        }
        KeyStroke ks = (KeyStroke)a.getValue("AcceleratorKey");
        if (ks == null) {
            return;
        }
        String aName = null;
        if (a.getValue("Name") != null) {
            aName = (String)a.getValue("Name");
            component.getInputMap(2).put(ks, aName);
            component.getActionMap().put(aName, a);
        }
    }

    private JFrame createFloatingThumbnailWindow() {
        JFrame frame = new JFrame();
        frame.getRootPane().setOpaque(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent arg0) {
                CMBGenericDocViewer.this.dockThumbnails(true);
            }
        });
        this.updateMapWithAction("doc_prev", frame.getRootPane());
        this.updateMapWithAction("doc_next", frame.getRootPane());
        this.updateMapWithAction("doc_first", frame.getRootPane());
        this.updateMapWithAction("doc_last", frame.getRootPane());
        this.updateMapWithAction("cut", frame.getRootPane());
        this.updateMapWithAction("copy", frame.getRootPane());
        this.updateMapWithAction("paste", frame.getRootPane());
        return frame;
    }

    void _setThumbnailFrameTitle() {
        if (this.thumbnailWindow == null) {
            return;
        }
        if (this.currentLayout == null || this.currentLayout.getSelectedFullSizeView() == null || this.currentLayout.getSelectedFullSizeView().getDocModel() == null) {
            return;
        }
        String msgTitle = PViewerUtilities.getMessage("DocumentViewer.floatingThumbnails.title", new Object[]{PViewerUtilities.stripHtml(this.getDocName(this.currentLayout.getSelectedFullSizeView().getDocModel().getDocument()))});
        this.thumbnailWindow.setTitle(msgTitle);
    }

    void _setThumbsViewOrientation(PThumbnailsView thumbView) {
        if (this.areThumbnailsDocked()) {
            if (this.getThumbnailsPosition().equalsIgnoreCase("North") || this.getThumbnailsPosition().equalsIgnoreCase("South")) {
                thumbView.setOrientation(0);
            } else {
                thumbView.setOrientation(1);
            }
        } else {
            thumbView.setOrientation(0);
            this._setThumbnailFrameTitle();
        }
    }

    private void _undockThumbnails() {
        if (this.thumbnailWindow == null) {
            this.thumbnailWindow = this.createFloatingThumbnailWindow();
            this.addDocOpenedListener(new CMBGenericDocOpenedListener(){

                public void genericDocOpened(CMBGenericDocOpenedEvent evt) {
                    if (CMBGenericDocViewer.this.getSelectedViewer() != null && !CMBGenericDocViewer.this.areThumbnailsDocked()) {
                        if (CMBGenericDocViewer.this.thumbnailWindow != null && CMBGenericDocViewer.this.thumbnailWindow.getContentPane() != null && !(CMBGenericDocViewer.this.thumbnailWindow.getContentPane().getSize().getHeight() > 0.0)) {
                            CMBGenericDocViewer.this.thumbnailWindow.setSize(CMBGenericDocViewer.this.currentLayout.getThumbnailsPanel().getPreferredSize());
                        }
                        if (CMBGenericDocViewer.this.getViewerCount() == 1 && !CMBGenericDocViewer.this.thumbnailWindow.isVisible()) {
                            CMBGenericDocViewer.this.thumbnailWindow.setVisible(true);
                        }
                    }
                }
            });
        }
        JPanel thumbnailPanel = this.currentLayout.getThumbnailsPanel();
        this._setThumbnailFrameTitle();
        Container thumbParent = thumbnailPanel.getParent();
        if (thumbParent == null) {
            return;
        }
        thumbParent.remove(thumbnailPanel);
        this.revalidate();
        PSingleDocViewer viewer = this.getSelectedViewer();
        if (viewer != null) {
            PThumbnailsView thumbnailView = viewer.getThumbnailsView();
            thumbnailView.setOrientation(0);
        }
        this.thumbnailWindow.getContentPane().add(thumbnailPanel);
        if (this.thumbnailWindow.getContentPane() != null && !(this.thumbnailWindow.getContentPane().getSize().getHeight() > 0.0)) {
            this.thumbnailWindow.setSize(thumbnailPanel.getPreferredSize());
            this.thumbnailWindow.pack();
        }
        if (viewer != null) {
            this.thumbnailWindow.setVisible(true);
            this.thumbnailWindow.validate();
        }
    }

    private void _dockThumbnails() {
        if (this.thumbnailWindow == null) {
            return;
        }
        JPanel thumbnailPanel = this.currentLayout.getThumbnailsPanel();
        this.thumbnailWindow.getContentPane().remove(thumbnailPanel);
        this.thumbnailWindow.setVisible(false);
        this.currentLayout.setThumbnailsPosition(this.thumbnailsPosition);
        this.revalidate();
    }

    public void setThumbnailsSize(Dimension dimThumbnailSize) {
        this.thumbnailSize = dimThumbnailSize;
        int selIndex = this.activeViewers.indexOf(this.selectedViewer);
        int tabCount = this.activeViewers.size();
        Dimension newValue = this.thumbnailSize;
        int w = this.thumbnailSize.width;
        int h = this.thumbnailSize.height;
        if (this.thumbnailsRelativeSize.equalsIgnoreCase("small")) {
            newValue = new Dimension(w / 2, h / 2);
        } else if (this.thumbnailsRelativeSize.equalsIgnoreCase("medium")) {
            newValue = new Dimension(w, h);
        } else if (this.thumbnailsRelativeSize.equalsIgnoreCase("large")) {
            newValue = new Dimension(w * 2, h * 2);
        }
        for (int i = 0; i < tabCount; ++i) {
            PSingleDocViewer viewer = (PSingleDocViewer)this.activeViewers.get(i);
            PThumbnailsView thumbnailView = viewer.getThumbnailsView();
            thumbnailView.setThumbnailSize(newValue);
            if (selIndex == i) {
                this.updateThumbnailImages();
                if (this.currentLayout.getThumbnailsPanel() == null) continue;
                this.currentLayout.getThumbnailsPanel().revalidate();
                continue;
            }
            thumbnailView.updateThumbnails(1, viewer.getDocModel().getPageCount());
        }
        this.revalidate();
    }

    Dimension getThumbnailsSize() {
        Dimension newSize = this.thumbnailSize;
        int w = this.thumbnailSize.width;
        int h = this.thumbnailSize.height;
        if (this.thumbnailsRelativeSize.equalsIgnoreCase("small")) {
            newSize = new Dimension(w / 2, h / 2);
        } else if (this.thumbnailsRelativeSize.equalsIgnoreCase("medium")) {
            newSize = new Dimension(w, h);
        } else if (this.thumbnailsRelativeSize.equalsIgnoreCase("large")) {
            newSize = new Dimension(w * 2, h * 2);
        }
        return newSize;
    }

    private void setThumbnailsRelativeSize(String relativeSize) {
        this.thumbnailsRelativeSize = relativeSize;
        this.setThumbnailsSize(this.thumbnailSize);
    }

    public JComponent getDocViewPanel() {
        return (JComponent)this.currentLayout.getSelectedFullSizeView().getParent().getParent();
    }

    public void setSelectedAnnotationTool(int tool) throws UnsupportedOperationException, IllegalArgumentException {
        if (!this.isToolValid(tool)) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentViewer.invalidTool", new Object[]{new Integer(tool)}));
        }
        if (this.annoServices == null) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.annoservicesNotSet"));
        }
        if (tool != 0 && !this.getSelectedAnnotationSet().isEditable()) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.cannotUpdateAnnotations"));
        }
        if (this.getAnnotationServices() != null && tool == 8 && tool == this.getSelectedAnnotationTool()) {
            this.annoServices.setIdleDrawingMode();
        }
        if (this.getCurrentMode() != 111) {
            this.setCurrentMode(111);
        }
        this.annoServices.setSelectedAnnotationTool(tool);
    }

    private void setCursorFromSelectedAnnotationTool() {
        if (this.getCurrentMode() != 111) {
            return;
        }
        int tool = 0;
        if (this.getAnnotationServices() != null) {
            tool = this.getSelectedAnnotationTool();
        }
        String actionCommand = null;
        if (tool == 0) {
            actionCommand = "pointer";
        }
        if (tool == 20) {
            actionCommand = "eraser";
        }
        if (tool == 1) {
            actionCommand = "Arrow";
        }
        if (tool == 2) {
            actionCommand = "Circle";
        }
        if (tool == 3) {
            actionCommand = "Highlight";
        }
        if (tool == 4) {
            actionCommand = "Line";
        }
        if (tool == 5) {
            actionCommand = "Note";
        }
        if (tool == 6) {
            actionCommand = "Pen";
        }
        if (tool == 7) {
            actionCommand = "Rect";
        }
        if (tool == 8) {
            actionCommand = "Stamp";
        }
        if (tool == 9) {
            actionCommand = "Text";
        }
        if (actionCommand != null) {
            this.setCursor(actionCommand);
        }
    }

    void setCursor(String name) {
        if (this.cursorTable.containsKey(name)) {
            Cursor c = (Cursor)this.cursorTable.get(name);
            this.setCursor(c);
        }
    }

    public void setCursor(Cursor cursor) {
        this.currentLayout.setCursor(cursor);
        super.setCursor(cursor);
    }

    boolean isToolValid(int type) {
        boolean value = false;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 20: {
                value = true;
                break;
            }
            default: {
                if (type < 100) break;
                value = true;
            }
        }
        return value;
    }

    void prepareToAddAnnotation(int annoType, int pageNumber, CMBViewerAction action) {
        if (this.annoServices != null) {
            this.setCurrentAction(action);
            this.setSelectedAnnotationTool(annoType);
        }
    }

    public void setSelectedAnnotation(CMBPageAnnotation a) throws UnsupportedOperationException, IllegalArgumentException {
        if (this.annoServices == null) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.annoservicesNotSet"));
        }
        if (this.getSelectedAnnotationSet() == null) {
            return;
        }
        if (a == null) {
            this.getSelectedAnnotationSet().setSelectedAnnotations(new CMBPageAnnotation[0]);
        } else {
            this.getSelectedAnnotationSet().setSelectedAnnotations(new CMBPageAnnotation[]{a});
        }
    }

    public CMBPageAnnotation getSelectedAnnotation() throws UnsupportedOperationException {
        if (this.annoServices == null) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.annoservicesNotSet"));
        }
        if (this.getSelectedAnnotationSet() == null) {
            return null;
        }
        CMBPageAnnotation[] selectedAnnotations = this.getSelectedAnnotationSet().getSelectedAnnotations();
        if (selectedAnnotations.length == 0) {
            return null;
        }
        return selectedAnnotations[0];
    }

    public void deleteSelectedAnnotation() throws CMBAnnotationEngineException, UnsupportedOperationException {
        if (this.annoServices == null) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.annoservicesNotSet"));
        }
        if (this.getSelectedAnnotation() == null) {
            throw new UnsupportedOperationException("DocumentViewer.noSelectedAnnotation");
        }
        new PDeleteAnnotationTask(this.getSelectedModel().getTaskManager(), this, this.getSelectedAnnotation(), true);
    }

    public void addAnnotation(CMBPageAnnotation a) throws IllegalArgumentException, CMBAnnotationEngineException, UnsupportedOperationException {
        if (this.annoServices == null) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.annoservicesNotSet"));
        }
        if (this.isDocumentPrinting(this.getSelectedDocument())) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.operationNotValidWhilePrinting"));
        }
        if (a == null) {
            throw new IllegalArgumentException();
        }
        a.setRotation(((PPageModel)this.getSelectedModel()).getPageRotation(a.getPageNumber()));
        CMBPage page = null;
        try {
            page = this.getSelectedDocument().getPage(a.getPageNumber());
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (page == null) {
            throw new IllegalArgumentException();
        }
        if (a.getRotation() == 0 || a.getRotation() == 2) {
            a.setImageHeight((int)(page.getHeight() * (double)page.getPageResolution()));
            a.setImageWidth((int)(page.getWidth() * (double)page.getPageResolution()));
        } else {
            a.setImageHeight((int)(page.getWidth() * (double)page.getPageResolution()));
            a.setImageWidth((int)(page.getHeight() * (double)page.getPageResolution()));
        }
        this.getSelectedAnnotationSet().addAnnotation(a);
        if (!this.isAnnotationToolSticky()) {
            this.setSelectedAnnotationTool(0);
        }
    }

    public void showAnnotations(boolean show) throws UnsupportedOperationException {
        if (this.annoServices == null) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.annoservicesNotSet"));
        }
        this.putClientProperty("Annotations.show", show);
    }

    private void _showAnnotations(boolean show) {
        if (this.annoServices == null) {
            return;
        }
        if (this.getSelectedAnnotationSet() == null) {
            return;
        }
        if (show) {
            this.annoServices.showAllAnnotations();
        } else {
            this.annoServices.hideAllAnnotations();
        }
        PSingleDocViewer viewer = this.getSelectedViewer();
        PThumbnailsView thumbnailView = viewer.getThumbnailsView();
        thumbnailView.repaint();
    }

    void stopDocViewedTimer() {
        if (this.docViewedTimer != null) {
            this.docViewedTimer.stop();
            this.docViewedTimer = null;
        }
    }

    private void startDocViewedTimer(int delay, ActionListener l) {
        if (this.docViewedTimer != null) {
            this.docViewedTimer.stop();
        }
        this.docViewedTimer = new Timer(delay, l);
        this.docViewedTimer.setRepeats(false);
        this.docViewedTimer.start();
    }

    private void indicateViewedDocuments(boolean indicate) {
        Enumeration en = this.activeViewers.elements();
        while (en.hasMoreElements()) {
            PSingleDocViewer v = (PSingleDocViewer)en.nextElement();
            CMBDocument document = v.getDocModel().getDocument();
            if (!this.hasDocumentBeenViewed(document)) continue;
            this.currentLayout.indicateDocument(document, indicate);
        }
    }

    void checkToIndicateDocument() {
        if (this.getSelectedDocument() == null) {
            return;
        }
        int ONE_SECOND = 1000;
        boolean indicate = (Boolean)this.getClientProperty("Appearance.tab.indicate");
        if (indicate) {
            if (this.hasDocumentBeenViewed(this.getSelectedDocument())) {
                this.currentLayout.indicateDocument(this.getSelectedDocument(), true);
            } else {
                ActionListener timerAction = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CMBGenericDocViewer.this.stopDocViewedTimer();
                        CMBGenericDocViewer.this.setDocumentViewed(CMBGenericDocViewer.this.getSelectedDocument(), true);
                    }
                };
                int delay = (Integer)this.getClientProperty("Appearance.tab.delay");
                this.startDocViewedTimer(ONE_SECOND * delay, timerAction);
            }
        } else {
            this.stopDocViewedTimer();
        }
    }

    boolean getAnnotationsShow() {
        return (Boolean)this.getClientProperty("Annotations.show");
    }

    public boolean getAnnotationsVisibleWhileDrag() {
        return (Boolean)this.getClientProperty("Annotations.visibleWhileDrag");
    }

    public void setAnnotationsVisibleWhileDrag(boolean value) {
        this.putClientProperty("Annotations.visibleWhileDrag", value);
    }

    public boolean getAnnotationsImmediatePreview() {
        return (Boolean)this.getClientProperty("Annotations.immediatePreview");
    }

    public void setAnnotationsImmediatePreview(boolean value) {
        this.putClientProperty("Annotations.immediatePreview", value);
    }

    void hideShowAnnotations() {
        if (this.annoServices == null) {
            return;
        }
        boolean showAnnotations = !this.getAnnotationsShow();
        this.showAnnotations(showAnnotations);
    }

    public boolean isAnnotationToolSticky() {
        return (Boolean)this.getClientProperty("AnnotationTool.sticky");
    }

    public void setAnnotationToolSticky(boolean value) {
        this.putClientProperty("AnnotationTool.sticky", value);
    }

    private void _setAnnotationToolSticky(boolean value) {
        if (this.annoServices != null) {
            this.annoServices.setAnnotationToolSticky(value);
        }
    }

    public void moveAnnotationFront() throws CMBAnnotationEngineException, UnsupportedOperationException {
        if (this.annoServices == null) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.annoservicesNotSet"));
        }
        if (this.getSelectedAnnotation() == null) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.noSelectedAnnotation"));
        }
        if (!this.getSelectedAnnotation().canUpdate() || !this.getSelectedAnnotationSet().isEditable()) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.cannotUpdateAnnotations"));
        }
        this.annoServices.reorderAnnotation(this.getSelectedAnnotation(), 0);
    }

    public void sendAnnotationBack() throws CMBAnnotationEngineException, UnsupportedOperationException {
        if (this.annoServices == null) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.annoservicesNotSet"));
        }
        if (this.getSelectedAnnotationSet() == null || this.getSelectedAnnotation() == null) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.noSelectedAnnotation"));
        }
        if (!this.getSelectedAnnotation().canUpdate() || !this.getSelectedAnnotationSet().isEditable()) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.cannotUpdateAnnotations"));
        }
        int count = this.getSelectedAnnotationSet().getAnnotationCount();
        this.annoServices.reorderAnnotation(this.getSelectedAnnotation(), count - 1);
    }

    void eraseAnnotation(CMBViewerAction action) {
        if (this.annoServices == null) {
            return;
        }
        this.setSelectedAnnotationTool(20);
    }

    public void changeAnnotationProperties() throws UnsupportedOperationException {
        if (this.annoServices == null) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.annoservicesNotSet"));
        }
        if (this.getSelectedAnnotation() == null) {
            throw new UnsupportedOperationException("DocumentViewer.noSelectedAnnotation");
        }
        this.annoServices.changeAnnotationProperties(this.getSelectedAnnotation());
        this.currentLayout.getViewerComponent().requestFocus();
    }

    public void setAnnoPopupMenu(JPopupMenu popupMenu) {
        if (this.annoServices == null) {
            return;
        }
        this.annoServices.setPopupMenu(popupMenu);
    }

    public void annotationCreated(CMBAnnotationCreatedEvent event) {
        CMBAnnotationSet model = event.getAnnotationModel();
        CMBPageAnnotation anno = event.getAnnotation();
        anno.setApplyNow(this.getAnnotationsImmediatePreview());
        anno.setVisibleWhileDragging(this.getAnnotationsVisibleWhileDrag());
        new PCreateAnnotationTask(this.getSelectedModel().getTaskManager(), this, anno, false);
        model.setDirty(true);
        this.updateToolStates();
        this.getSelectedThumbnailView().repaint();
        this.fireCMBDocStateChangedEvent(new CMBGenericDocStateChangedEvent(this, this.getSelectedModel().getDocument(), new int[]{this.getSelectedModel().getCurrentPageNumber()}, 6));
    }

    public void annotationDeleted(CMBAnnotationDeletedEvent event) {
        CMBAnnotationSet model = event.getAnnotationModel();
        CMBPageAnnotation anno = event.getAnnotation();
        PDeleteAnnotationTask dTask = new PDeleteAnnotationTask(this.getSelectedModel().getTaskManager(), this, anno, false);
        model.setDirty(true);
        this.updateToolStates();
        this.getSelectedThumbnailView().repaint();
        this.fireCMBDocStateChangedEvent(new CMBGenericDocStateChangedEvent(this, this.getSelectedModel().getDocument(), new int[]{this.getSelectedModel().getCurrentPageNumber()}, 8));
    }

    public void annotationMoved(CMBAnnotationMovedEvent event) {
        CMBPageAnnotation anno = event.getAnnotation();
        new PMoveAnnotationTask(this.getSelectedModel().getTaskManager(), this, event.getAnnotationView(), anno, event.getNewPoint(), event.getOldPoint(), false);
        event.getAnnotationModel().setDirty(true);
        this.updateToolStates();
        this.getSelectedThumbnailView().repaint();
        this.fireCMBDocStateChangedEvent(new CMBGenericDocStateChangedEvent(this, this.getSelectedModel().getDocument(), new int[]{this.getSelectedModel().getCurrentPageNumber()}, 7));
    }

    public void annotationResized(CMBAnnotationResizedEvent event) {
        CMBPageAnnotation anno = event.getAnnotation();
        new PResizeAnnotationTask(this.getSelectedModel().getTaskManager(), this, event.getAnnotationView(), event.getAnnotation(), event.getNewPoint(), event.getOldPoint(), false);
        event.getAnnotationModel().setDirty(true);
        this.updateToolStates();
        this.getSelectedThumbnailView().repaint();
        this.fireCMBDocStateChangedEvent(new CMBGenericDocStateChangedEvent(this, this.getSelectedModel().getDocument(), new int[]{this.getSelectedModel().getCurrentPageNumber()}, 7));
    }

    public void annotationReordered(CMBAnnotationReorderedEvent event) {
        CMBPageAnnotation anno = event.getAnnotation();
        CMBAnnotationSet model = event.getAnnotationModel();
        new PReorderAnnotationTask(this.getSelectedModel().getTaskManager(), this, model, event.getAnnotationView(), event.getAnnotation(), event.getOrigIndex(), event.getNewIndex(), false);
        model.setDirty(true);
        this.updateToolStates();
        this.getSelectedThumbnailView().repaint();
        this.fireCMBDocStateChangedEvent(new CMBGenericDocStateChangedEvent(this, this.getSelectedModel().getDocument(), new int[]{this.getSelectedModel().getCurrentPageNumber()}, 7));
    }

    public void annotationPropertiesUpdated(CMBAnnotationPropertiesUpdatedEvent event) {
        int newSize;
        int oldSize;
        CMBPageAnnotation annotation = event.getAnnotation();
        CMBPageAnnotation oldProps = event.getOldProperties();
        CMBPageAnnotation newProps = event.getNewProperties();
        if (event.getAnnotation() instanceof CMBPenAnnotation && (oldSize = ((CMBPenAnnotation)oldProps).getPenStrokes().size()) != (newSize = ((CMBPenAnnotation)newProps).getPenStrokes().size())) {
            event.getAnnotationModel().setDirty(true);
            this.updateToolStates();
            this.fireCMBDocStateChangedEvent(new CMBGenericDocStateChangedEvent(this, this.getSelectedModel().getDocument(), new int[]{this.getSelectedModel().getCurrentPageNumber()}, 7));
            return;
        }
        CMBAnnotationSet model = event.getAnnotationModel();
        PChangeAnnotationPropertiesTask task = new PChangeAnnotationPropertiesTask(this.getSelectedModel().getTaskManager(), this, model, event.getAnnotationView(), annotation, oldProps, newProps, false);
        model.setDirty(true);
        this.updateToolStates();
        this.getSelectedThumbnailView().repaint();
        this.fireCMBDocStateChangedEvent(new CMBGenericDocStateChangedEvent(this, this.getSelectedModel().getDocument(), new int[]{this.getSelectedModel().getCurrentPageNumber()}, 7));
    }

    public void annotationSelected(CMBAnnotationSelectedEvent event) {
        int[] selectedPages;
        PDocModel model;
        if (event.getAnnotation() != null && (model = this.getSelectedModel()) != null && model instanceof PPageModel && (selectedPages = ((PPageModel)model).getSelectedPages()).length > 1) {
            ((PPageModel)model).setSelectedPages(null);
            this.setSelectedAnnotation(event.getAnnotation());
        }
        if (this.getSelectedThumbnailView() != null) {
            this.getSelectedThumbnailView().repaint();
        }
        this.updateToolStates();
    }

    public int getSelectedAnnotationTool() throws UnsupportedOperationException {
        if (this.annoServices != null) {
            return this.annoServices.getSelectedAnnotationTool();
        }
        throw new UnsupportedOperationException(PViewerUtilities.getMessage("DocumentViewer.annoservicesNotSet"));
    }

    void setCurrentAction(CMBViewerAction action) {
        this.currentAction = action;
    }

    private CMBViewerAction getCurrentAction() {
        return this.currentAction;
    }

    private void setShowAnnotations() {
        boolean showAnnotations = this.getAnnotationsShow();
        this._showAnnotations(showAnnotations);
    }

    public void addCustomPreferenceSet(CMBPreferenceSet preferenceSet) {
        preferenceSet.viewer = this;
        this.customPreferenceSets.put(preferenceSet.getName(), preferenceSet);
        preferenceSet.importAction(this.getUserProperties(null));
        preferenceSet.applyAction();
    }

    public void removeCustomPreferenceSet(String name) {
        this.customPreferenceSets.remove(name);
    }

    public void editPreferences() {
        if (this.preferenceSets == null) {
            this.preferenceSets = PPreferenceSetsBuilder.createPreferenceTree(this.configProperties, this);
        } else {
            this.refreshPreferenceSets();
        }
        PPreferencesDialog d = new PPreferencesDialog(this.getOwningFrame(), this, this.configProperties, this.preferenceSets);
        for (int i = 0; i < this.docHelpListeners.size(); ++i) {
            CMBGenericDocHelpListener listener = (CMBGenericDocHelpListener)this.docHelpListeners.elementAt(i);
            d.addDocHelpListener(listener);
        }
        d.buildLayout();
        d.pack();
        d.setLocationRelativeTo(this);
        this.dialogDisplayed = d;
        d.show();
        this.dialogDisplayed = null;
        this.currentLayout.getViewerComponent().requestFocus();
    }

    DefaultMutableTreeNode getPreferenceSets() {
        if (this.preferenceSets == null) {
            this.preferenceSets = PPreferenceSetsBuilder.createPreferenceTree(this.configProperties, this);
        }
        return this.preferenceSets;
    }

    void refreshPreferenceSets() {
        Enumeration<TreeNode> en = this.preferenceSets.preorderEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            if (!(node.getUserObject() instanceof CMBPreferenceSet)) continue;
            CMBPreferenceSet ps = (CMBPreferenceSet)node.getUserObject();
            ps.updateView();
        }
    }

    public void pageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pgFormat = (PageFormat)this.printPreference.get(this.getSelectedDocument().getMimeType());
        if (pgFormat == null) {
            pgFormat = printerJob.defaultPage();
        }
        pgFormat = printerJob.pageDialog(this.pageFormat);
        this.printPreference.remove(this.getSelectedDocument());
        this.printPreference.put(this.getSelectedDocument().getMimeType(), pgFormat.clone());
    }

    public void printPreview() {
        PPrintPreviewDialog previewDialog = new PPrintPreviewDialog(this.getOwningFrame(), this.getSelectedModel());
        previewDialog.setSize(500, 500);
        previewDialog.pack();
        this.dialogDisplayed = previewDialog;
        previewDialog.show();
        this.dialogDisplayed = null;
        this.currentLayout.getViewerComponent().requestFocus();
    }

    public void addCustomPrintable(CMBCustomPageablePrintable printable) {
        this.customPrintables.put(printable.getText(), printable);
    }

    public void removeCustomPrintable(String text) {
        this.customPrintables.remove(text);
    }

    boolean canPrint() {
        PDocModel model = this.getSelectedModel();
        if (model != null) {
            return model.canPrint();
        }
        return false;
    }

    public boolean canPrintAllDocuments() {
        Object[] pageViewers = this.activeViewers.toArray();
        if (pageViewers.length == 0) {
            return false;
        }
        boolean returnValue = true;
        for (int i = 0; i < pageViewers.length; ++i) {
            PSingleDocViewer pageViewer = (PSingleDocViewer)pageViewers[i];
            PDocModel model = pageViewer.getDocModel();
            if (model == null || !model.canPrint()) continue;
            return true;
        }
        return false;
    }

    public void printDocument() throws CMBViewerException {
        if (!this.canPrint()) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        this.printDocument(this.getSelectedModel());
        this.currentLayout.getViewerComponent().requestFocus();
    }

    private void printDocument(PDocModel docModel) throws CMBViewerException {
        PPagePrintable pagePrintable;
        String docMimetype = docModel.getDocument().getMimeType();
        PageFormat pgFormat = (PageFormat)this.printPreference.get(docMimetype);
        if (pgFormat == null) {
            pagePrintable = new PPagePrintable((PPageModel)docModel, this.configProperties, this);
            pgFormat = pagePrintable.getPageFormat(0);
        } else {
            pagePrintable = new PPagePrintable((PPageModel)docModel, pgFormat, this);
        }
        this.printPreference.remove(docMimetype);
        this.useNewPrintDialog = Boolean.valueOf(this.configProperties.getProperty("printDialog.new", "false"));
        if (this.useNewPrintDialog) {
            PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            if (services == null || services.length == 0) {
                JOptionPane.showMessageDialog(this.getOwningFrame(), PViewerUtilities.getMessage("printDialog.noPrintServices"), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
                return;
            }
            PPrintQueueItem printItem = new PPrintQueueItem(this, pagePrintable, PrinterJob.getPrinterJob(), new Book());
            PNewPrintDialog dlgPrint = new PNewPrintDialog(this.getOwningFrame(), services, printItem, this.customPrintables, this);
            for (int i = 0; i < this.docHelpListeners.size(); ++i) {
                CMBGenericDocHelpListener listener = (CMBGenericDocHelpListener)this.docHelpListeners.elementAt(i);
                dlgPrint.addDocHelpListener(listener);
            }
            dlgPrint.buildLayout();
            dlgPrint.pack();
            dlgPrint.setLocationRelativeTo(this);
            this.dialogDisplayed = dlgPrint;
            dlgPrint.show();
            this.dialogDisplayed = null;
            if (!dlgPrint.printButtonSelected || dlgPrint.printerJob == null) {
                printItem.dispose();
                dlgPrint.dispose();
                return;
            }
            dlgPrint.dispose();
            this.printPreference.put(docMimetype, printItem.getPageFormat().clone());
            Enumeration en = this.customPrintables.elements();
            while (en.hasMoreElements()) {
                CMBCustomPageablePrintable custom = (CMBCustomPageablePrintable)en.nextElement();
                custom.setCenterOnPage(printItem.getPagePrintable().isCenterOnPage());
                custom.setPrinterJob(printItem.getPj());
                custom.setDocument(docModel.getDocument());
                custom.viewer = this;
                custom.aset = printItem.getPagePrintable().getAset();
            }
            this.printQueue.put(printItem);
            this.fireCMBDocPrintStatusEvent(1, 1, pagePrintable.getNumberOfPagesToPrint(), null, null);
        } else {
            PPrintDialog dlgPrint = new PPrintDialog(this.getOwningFrame(), PViewerUtilities.getMessage("printDialog.Title"), pgFormat, this);
            this.dialogDisplayed = dlgPrint;
            dlgPrint.show();
            this.dialogDisplayed = null;
            if (dlgPrint.result == 0) {
                dlgPrint.dispose();
                return;
            }
            pgFormat = dlgPrint.pageFormat;
            this.printPreference.put(docMimetype, pgFormat.clone());
            pagePrintable.setPageFormat(pgFormat);
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPageable(pagePrintable);
            boolean doPrint = printerJob.printDialog();
            if (doPrint) {
                pagePrintable.setPrintAnno(dlgPrint.bIncludeAnno);
                pagePrintable.setPrintScaleString(dlgPrint.zoomOption);
                PPrintQueueItem printItem = new PPrintQueueItem(this, pagePrintable, printerJob, null);
                this.printQueue.put(printItem);
                this.fireCMBDocPrintStatusEvent(1, 1, pagePrintable.getNumberOfPagesToPrint(), null, null);
            }
        }
    }

    public CMBDocument[] printDocuments(CMBDocument[] documents, CMBAnnotationSet[] annotationSets) {
        if (documents.length != annotationSets.length) {
            return null;
        }
        Vector<PSingleDocViewer> viewers = new Vector<PSingleDocViewer>();
        PSingleDocViewer viewer = null;
        for (int i = 0; i < documents.length; ++i) {
            viewer = this.createSingleDocViewer(documents[i], annotationSets[i], "document" + i);
            viewers.add(viewer);
        }
        Vector printVector = this.filterForPrintableDocuments(viewers);
        if (printVector == null) {
            return null;
        }
        return this.printMultiDocuments(printVector, "printDocumentsDialog.title");
    }

    public void printAllDocuments() throws CMBViewerException {
        if (!this.canPrintAllDocuments()) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        Vector printVector = this.filterForPrintableDocuments(this.activeViewers);
        if (printVector == null) {
            return;
        }
        this.printMultiDocuments(printVector, "printAllDialog.title");
        this.currentLayout.getViewerComponent().requestFocus();
    }

    private Vector filterForPrintableDocuments(Vector viewers) {
        int option;
        Object[] pageViewers = viewers.toArray();
        Vector<PSingleDocViewer> printVector = new Vector<PSingleDocViewer>();
        for (int i = 0; i < pageViewers.length; ++i) {
            PSingleDocViewer pageViewer = (PSingleDocViewer)pageViewers[i];
            PDocModel model = pageViewer.getDocModel();
            if (!model.canPrint()) continue;
            printVector.addElement(pageViewer);
        }
        if (printVector.size() < 1) {
            JOptionPane.showMessageDialog(this, PViewerUtilities.getMessage("printAllDialog.noDocumentsWithPriv"), PViewerUtilities.getMessage("DocumentViewer.warningMessageTitle"), 1, null);
            return null;
        }
        if (printVector.size() != viewers.size() && (option = JOptionPane.showConfirmDialog(this, PViewerUtilities.getMessage("printAllDialog.insufficientPriv"), PViewerUtilities.getMessage("DocumentViewer.printWarningDialogTitle"), 0, 2, null)) != 0) {
            return null;
        }
        return printVector;
    }

    private CMBDocument[] printMultiDocuments(Vector viewers, String messageKey) {
        int i;
        Object[] pageViewers = viewers.toArray();
        Vector<PPagePrintable> pagePrintableVector = new Vector<PPagePrintable>();
        PPagePrintable[] pagePrintables = null;
        PSingleDocViewer pageViewer = (PSingleDocViewer)pageViewers[0];
        PDocModel docModel = pageViewer.getDocModel();
        CMBDocument document = docModel.getDocument();
        PPagePrintable pagePrintable = new PPagePrintable((PPageModel)docModel, this.configProperties, this);
        pagePrintableVector.add(pagePrintable);
        PageFormat pgFormat = pagePrintable.getPageFormat(0);
        for (int i2 = 1; i2 < pageViewers.length; ++i2) {
            pageViewer = (PSingleDocViewer)pageViewers[i2];
            docModel = pageViewer.getDocModel();
            document = docModel.getDocument();
            pagePrintable = new PPagePrintable((PPageModel)docModel, pgFormat, this);
            pagePrintableVector.add(pagePrintable);
        }
        pagePrintables = pagePrintableVector.toArray(new PPagePrintable[pagePrintableVector.size()]);
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        if (services == null || services.length == 0) {
            JOptionPane.showMessageDialog(this.getOwningFrame(), PViewerUtilities.getMessage("printDialog.noPrintServices"), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            return null;
        }
        CMBDocument[] documentsToPrint = new CMBDocument[pagePrintables.length];
        PPrintQueueItem[] printItems = new PPrintQueueItem[pagePrintables.length];
        for (int i3 = 0; i3 < pagePrintables.length; ++i3) {
            documentsToPrint[i3] = pagePrintables[i3].getPageModel().getDocument();
            printItems[i3] = new PPrintQueueItem(this, pagePrintables[i3]);
        }
        PNewPrintDialog dlgPrint = new PNewPrintDialog(this.getOwningFrame(), messageKey, services, printItems, this);
        for (i = 0; i < this.docHelpListeners.size(); ++i) {
            CMBGenericDocHelpListener listener = (CMBGenericDocHelpListener)this.docHelpListeners.elementAt(i);
            dlgPrint.addDocHelpListener(listener);
        }
        dlgPrint.buildLayout();
        dlgPrint.pack();
        dlgPrint.setLocationRelativeTo(this);
        this.dialogDisplayed = dlgPrint;
        dlgPrint.show();
        this.dialogDisplayed = null;
        if (!dlgPrint.printButtonSelected) {
            dlgPrint.dispose();
            for (i = 0; i < printItems.length; ++i) {
                printItems[i].dispose();
                printItems[i] = null;
            }
            return null;
        }
        int documentCount = dlgPrint.documentCount;
        int pageCount = dlgPrint.pageCount;
        dlgPrint.dispose();
        for (int i4 = 0; i4 < printItems.length; ++i4) {
            this.printQueue.put(printItems[i4]);
        }
        this.fireCMBDocPrintStatusEvent(1, documentCount, pageCount, null, null);
        return documentsToPrint;
    }

    public boolean hasDocumentsPrinting() {
        return this.printQueue.hasDocumentsPrinting();
    }

    public boolean isDocumentPrinting(CMBDocument doc) {
        return this.printQueue.isDocumentPrinting(doc);
    }

    public void cancelPrintJob(CMBDocument doc) {
        this.printQueue.cancel(doc);
    }

    public void cancelAllPrintJobs() {
        this.printQueue.cancelAll();
    }

    public void printDocument(CMBDocument document, CMBAnnotationSet annotationSet) {
        PSingleDocViewer viewer = this.createSingleDocViewer(document, annotationSet, "document");
        this.printDocument(viewer.getDocModel());
        this.currentLayout.getViewerComponent().requestFocus();
    }

    public void setSelectAreaRectangle(Rectangle rect) throws IllegalArgumentException {
        PFullSizeView view = this.getSelectedView();
        if (view != null && view instanceof PFullSizeView) {
            view.setSelectAreaRectangle(rect);
        }
    }

    public Rectangle getSelectAreaRectangle() {
        PFullSizeView view = this.getSelectedView();
        if (view != null && view instanceof PFullSizeView) {
            return view.getSelectAreaRectangle();
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public int[] getViewablePageNumbers() throws CMBDocumentEngineException, IOException {
        if (this.getSelectedModel() == null) {
            return null;
        }
        return ((PPageModel)this.getSelectedModel()).getViewablePageNumbers();
    }

    public void setViewablePageNumbers(int[] _viewablePageNumbers) throws CMBDocumentEngineException, IllegalArgumentException, IOException {
        int i;
        if (_viewablePageNumbers == null || _viewablePageNumbers.length <= 0) {
            throw new IllegalArgumentException();
        }
        PPageModel pageModel = (PPageModel)this.getSelectedModel();
        Arrays.sort(_viewablePageNumbers);
        int numPageNumbers = _viewablePageNumbers.length;
        if (_viewablePageNumbers[0] < 1 || _viewablePageNumbers[numPageNumbers - 1] > this.getSelectedDocument().getPageCount()) {
            throw new IllegalArgumentException();
        }
        int[] viewablePageNumbers = null;
        Vector<Integer> pageNumbers = new Vector<Integer>();
        for (i = 0; i < numPageNumbers - 1; ++i) {
            if (_viewablePageNumbers[i] == _viewablePageNumbers[i + 1]) continue;
            pageNumbers.add(new Integer(_viewablePageNumbers[i]));
        }
        pageNumbers.add(new Integer(_viewablePageNumbers[numPageNumbers - 1]));
        viewablePageNumbers = new int[pageNumbers.size()];
        for (i = 0; i < pageNumbers.size(); ++i) {
            viewablePageNumbers[i] = (Integer)pageNumbers.get(i);
        }
        pageModel.setViewablePageNumbers(viewablePageNumbers);
        this.setDragDropAllowed(this.canDragDrop());
    }

    public void unsetViewablePageNumbers() throws IOException {
        PPageModel pageModel = (PPageModel)this.getSelectedModel();
        pageModel.unsetViewablePageNumbers();
        this.setDragDropAllowed(this.canDragDrop());
    }

    boolean canDragDrop() {
        try {
            return this.isPageManipulationEnabled() && this.getViewablePageNumbers() == null;
        }
        catch (CMBDocumentEngineException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.isPageManipulationEnabled();
    }

    void setDragDropAllowed(boolean value) {
        PSingleDocViewer viewer = this.getSelectedViewer();
        PThumbnailsView thumbnailView = viewer.getThumbnailsView();
        thumbnailView.setDragDropAllowed(value);
    }

    public boolean canCut() {
        String methodName = "canCut";
        if (this.getSelectedModel() == null) {
            return false;
        }
        if (this.getSelectedModel().getCurrentPageNumber() <= 0) {
            return false;
        }
        if (this.getCurrentMode() == 112) {
            return false;
        }
        if (this.isDocumentPrinting(this.getSelectedModel().getDocument())) {
            return false;
        }
        if (this.getAnnotationServices() != null && this.getSelectedAnnotation() != null) {
            try {
                return this.getSelectedAnnotation().canDelete() && this.getSelectedAnnotationSet().getPrivilege(62) && this.getSelectedAnnotationSet().getPrivilege(7);
            }
            catch (CMBAnnotationEngineException e) {
                ViewerLogger.logError((Object)this, methodName, e);
                return false;
            }
        }
        return this.pageManipulationEnabled && this.getSelectedDocument() != null && this.getSelectedDocument().getCanManipulatePages() && this.getSelectedModel().getPrivilege(2);
    }

    private String getCutDescription() {
        if (this.getSelectedModel() == null) {
            return "";
        }
        if (this.getCurrentMode() == 112) {
            return "";
        }
        if (this.getAnnotationServices() != null && this.getSelectedAnnotation() != null) {
            return PViewerUtilities.getMessage("cut.annotationInsert");
        }
        if (!this.pageManipulationEnabled || this.getSelectedDocument() == null || !this.getSelectedDocument().getCanManipulatePages()) {
            return "";
        }
        if (this.getSelectedPageNumbers().length > 1) {
            return PViewerUtilities.getMessage("cut.pagesInsert");
        }
        return PViewerUtilities.getMessage("cut.pageInsert");
    }

    public void cut() {
        if (this.canCut()) {
            if (this.getCurrentMode() == 112) {
                return;
            }
            if (this.getSelectedAnnotation() != null) {
                this.cutAnnotation();
            } else {
                this.cutPages();
            }
        }
    }

    public void cutAnnotation() {
        new PCutAnnotationTask(this.getSelectedModel().getTaskManager(), this, this.getSelectedAnnotation());
    }

    private void cutPages() {
        new PCutPagesTask(this.getSelectedModel().getTaskManager(), this, this.getSelectedPageNumbers());
    }

    public boolean canCopy() {
        String methodName = "canCopy";
        if (this.getSelectedModel() == null) {
            return false;
        }
        if (this.getSelectedModel().getCurrentPageNumber() <= 0) {
            return false;
        }
        if (this.getCurrentMode() == 112) {
            return !this.getSelectAreaRectangle().isEmpty();
        }
        if (this.getCurrentMode() == 113 && this.isTextSelected()) {
            return true;
        }
        if (this.isFindActive() && this.isTextSelected()) {
            return true;
        }
        if (this.getAnnotationServices() != null && this.getSelectedAnnotation() != null) {
            try {
                return this.getSelectedAnnotationSet().getPrivilege(7);
            }
            catch (CMBAnnotationEngineException e) {
                ViewerLogger.logError((Object)this, methodName, e);
                return false;
            }
        }
        return this.pageManipulationEnabled && this.getSelectedDocument() != null && this.getSelectedDocument().getCanManipulatePages();
    }

    private String getCopyDescription() {
        if (this.getSelectedModel() == null) {
            return "";
        }
        if (this.getCurrentMode() == 112) {
            return PViewerUtilities.getMessage("copy.areaInsert");
        }
        if (this.getCurrentMode() == 113 && this.isTextSelected()) {
            return PViewerUtilities.getMessage("copy.textInsert");
        }
        if (this.isFindActive() && this.isTextSelected()) {
            return PViewerUtilities.getMessage("copy.textInsert");
        }
        if (this.getAnnotationServices() != null && this.getSelectedAnnotation() != null) {
            return PViewerUtilities.getMessage("copy.annotationInsert");
        }
        if (!this.pageManipulationEnabled || this.getSelectedDocument() == null || !this.getSelectedDocument().getCanManipulatePages()) {
            return "";
        }
        if (this.getSelectedPageNumbers().length > 1) {
            return PViewerUtilities.getMessage("copy.pagesInsert");
        }
        return PViewerUtilities.getMessage("copy.pageInsert");
    }

    public void copy() throws CMBViewerException {
        if (this.canCopy()) {
            if (this.getCurrentMode() == 112) {
                this.copySelectedArea();
            } else if (this.getCurrentMode() == 113 && this.isTextSelected()) {
                this.copyText();
            } else if (this.isFindActive() && this.isTextSelected()) {
                this.copyText();
            } else if (this.getAnnotationServices() != null && this.getSelectedAnnotation() != null) {
                this.copyAnnotation();
            } else {
                this.copyPages();
            }
        }
    }

    public void copySelection() throws CMBViewerException {
        if (this.getCurrentMode() == 111) {
            if (this.getSelectedAnnotation() == null) {
                throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.invalidSelection"));
            }
            this.copyAnnotation();
        } else if (this.getCurrentMode() == 112) {
            this.copySelectedArea();
        }
    }

    public void copyAnnotation() {
        new PCopyAnnotationTask(this.getSelectedModel().getTaskManager());
        try {
            this.localClipboard.setContents((Transferable)this.getSelectedAnnotation().clone(), null);
            this.updateToolStates();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void copySelectedArea() throws CMBViewerException {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Image image = null;
        PFullSizeView view = this.getSelectedView();
        if (view != null && view instanceof PFullSizeView) {
            image = view.getSubImage();
        }
        PImageSelection imageSelection = new PImageSelection(image);
        systemClipboard.setContents(imageSelection, null);
    }

    private void copyPages() {
        new PCopyPagesTask(this.getSelectedModel().getTaskManager(), this, this.getSelectedPageNumbers());
    }

    private boolean isTextSelected() {
        PFullSizeView view = this.getSelectedView();
        if (view == null) {
            return false;
        }
        return view.isTextSelected();
    }

    private void copyText() {
        PFullSizeView view = this.getSelectedView();
        if (view != null) {
            view.copyTextToClipboard();
        }
    }

    public boolean canOcrDocument() {
        if (this.docServices == null) {
            System.out.println(PViewerUtilities.getMessage("DocumentViewer.docservicesNotSet"));
            return false;
        }
        if (this.getSelectedModel() == null) {
            return false;
        }
        if (this.getSelectedModel().getCurrentPageNumber() <= 0) {
            return false;
        }
        return this.docServices.canOcr(this.getSelectedDocument());
    }

    public void ocrPages(CMBDocument document, int[] pageNumbers) throws IOException, IllegalArgumentException {
        int i;
        if (pageNumbers == null || pageNumbers.length <= 0) {
            throw new IllegalArgumentException();
        }
        PPageModel pageModel = (PPageModel)this.getSelectedModel();
        if (pageNumbers == null || pageNumbers.length <= 0) {
            throw new IllegalArgumentException();
        }
        Arrays.sort(pageNumbers);
        int numPageNumbers = pageNumbers.length;
        if (pageNumbers[0] < 1 || pageNumbers[numPageNumbers - 1] > this.getSelectedDocument().getPageCount()) {
            throw new IllegalArgumentException();
        }
        int[] viewablePageNumbers = null;
        Vector<Integer> vpageNumbers = new Vector<Integer>();
        for (i = 0; i < numPageNumbers - 1; ++i) {
            if (pageNumbers[i] == pageNumbers[i + 1]) continue;
            vpageNumbers.add(new Integer(pageNumbers[i]));
        }
        vpageNumbers.add(new Integer(pageNumbers[numPageNumbers - 1]));
        viewablePageNumbers = new int[vpageNumbers.size()];
        for (i = 0; i < vpageNumbers.size(); ++i) {
            viewablePageNumbers[i] = (Integer)vpageNumbers.get(i);
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        POCRQueueItem item = new POCRQueueItem(this, document, pageNumbers);
        this.ocrQueue.put(item);
    }

    public void ocrDocument() {
        if (this.docServices == null) {
            System.out.println(PViewerUtilities.getMessage("DocumentViewer.docservicesNotSet"));
            return;
        }
        if (!this.canOcrDocument()) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        final CMBDocument document = this.getSelectedDocument();
        PPageModel model = (PPageModel)this.getSelectedModel();
        int pageCount = this.getSelectedModel().getPageCount();
        POCRQueueItem item = null;
        int[] pageNumbers = null;
        try {
            pageNumbers = this.getViewablePageNumbers();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (pageNumbers == null) {
            item = new POCRQueueItem(this, document, null);
        } else {
            item = new POCRQueueItem(this, document, pageNumbers);
            pageCount = pageNumbers.length;
        }
        final PProgressOCRDialog ocrProgress = new PProgressOCRDialog(this.getOwningFrame(), pageCount, item, this);
        this.addDocStateChangedListener(ocrProgress);
        this.setCursor(Cursor.getPredefinedCursor(3));
        model.addDocStateChangedListener(new CMBGenericDocStateChangedListener(){

            public void genericDocStateChanged(CMBGenericDocStateChangedEvent e) {
                if (e.getChangeType() == 24 && e.getDocument() == document) {
                    if (!CMBGenericDocViewer.this.ocrQueue.hasDocumentsOCR() && CMBGenericDocViewer.this.getCurrentMode() != 113) {
                        CMBGenericDocViewer.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    CMBGenericDocViewer.this.removeDocStateChangedListener(ocrProgress);
                    ocrProgress.dispose();
                }
            }
        });
        this.ocrQueue.put(item);
    }

    public void dropOCR(final CMBDocument document) throws IndexOutOfBoundsException, IOException {
        if (this.docServices == null) {
            System.out.println(PViewerUtilities.getMessage("DocumentViewer.docservicesNotSet"));
            return;
        }
        PPageModel model = (PPageModel)this.getViewer(document).getDocModel();
        if (model.getPageCount() <= 0) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        if (!this.docServices.canOcr(document)) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        CMBGenericDocOCRStatusListener listener = new CMBGenericDocOCRStatusListener(){

            public void ocrStatusChanged(CMBGenericDocOCRStatusEvent e) {
                if (e.getDocument() == document && e.getStatusType() == 1) {
                    e.getPage().ocrLetters = e.getLetters();
                    CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, e.getDocument(), new int[]{e.getPage().getPageNumber()}, 23);
                    CMBGenericDocViewer.this.getViewer(e.getDocument()).getDocModel().fireDocStateChangedEvent(event);
                }
            }
        };
        for (int i = 0; i < model.getPageCount(); ++i) {
            CMBPage p = document.getPage(i + 1);
            this.docServices.dropOcrPage(p, listener);
        }
    }

    void dropOCRPages(final CMBDocument document, int[] pageNumbers) throws IOException, IllegalArgumentException {
        int i;
        if (pageNumbers == null || pageNumbers.length <= 0) {
            throw new IllegalArgumentException();
        }
        PPageModel pageModel = (PPageModel)this.getSelectedModel();
        if (pageNumbers == null || pageNumbers.length <= 0) {
            throw new IllegalArgumentException();
        }
        Arrays.sort(pageNumbers);
        int numPageNumbers = pageNumbers.length;
        if (pageNumbers[0] < 1 || pageNumbers[numPageNumbers - 1] > this.getSelectedDocument().getPageCount()) {
            throw new IllegalArgumentException();
        }
        int[] viewablePageNumbers = null;
        Vector<Integer> vpageNumbers = new Vector<Integer>();
        for (i = 0; i < numPageNumbers - 1; ++i) {
            if (pageNumbers[i] == pageNumbers[i + 1]) continue;
            vpageNumbers.add(new Integer(pageNumbers[i]));
        }
        vpageNumbers.add(new Integer(pageNumbers[numPageNumbers - 1]));
        viewablePageNumbers = new int[vpageNumbers.size()];
        for (i = 0; i < vpageNumbers.size(); ++i) {
            viewablePageNumbers[i] = (Integer)vpageNumbers.get(i);
        }
        CMBGenericDocOCRStatusListener listener = new CMBGenericDocOCRStatusListener(){

            public void ocrStatusChanged(CMBGenericDocOCRStatusEvent e) {
                if (e.getDocument() == document && e.getStatusType() == 1) {
                    e.getPage().ocrLetters = e.getLetters();
                    CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, e.getDocument(), new int[]{e.getPage().getPageNumber()}, 23);
                    CMBGenericDocViewer.this.getViewer(e.getDocument()).getDocModel().fireDocStateChangedEvent(event);
                }
            }
        };
        for (int i2 = 0; i2 < viewablePageNumbers.length; ++i2) {
            CMBPage p = document.getPage(viewablePageNumbers[i2]);
            this.docServices.dropOcrPage(p, listener);
        }
    }

    public void ocrDocument(CMBDocument document) {
        if (this.docServices == null) {
            System.out.println(PViewerUtilities.getMessage("DocumentViewer.docservicesNotSet"));
            return;
        }
        PPageModel model = (PPageModel)this.getViewer(document).getDocModel();
        if (model.getPageCount() <= 0) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        if (!this.docServices.canOcr(document)) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        POCRQueueItem item = new POCRQueueItem(this, document, null);
        this.ocrQueue.put(item);
    }

    void cancelOCR(CMBDocument document) {
        if (this.docServices == null || !this.docServices.canOcr(document)) {
            System.out.println(PViewerUtilities.getMessage("DocumentViewer.docservicesNotSet"));
            return;
        }
        this.docServices.cancelOCR(document);
    }

    public void selectText() {
        if (!this.canSelectText()) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        this.setCurrentMode(113);
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.canExtractText()) {
            try {
                CMBPage page = this.getSelectedDocument().getPage(this.getCurrentPageNumber());
                if (page != null && page.letters == null) {
                    this.ocrQueue.addListenerForSelectTextAction(this, page);
                } else {
                    this.setCursor("select_text");
                }
                this._ocrPage(page);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            boolean ocrDoc = (Boolean)this.getClientProperty("Document.ocr");
            if (ocrDoc && !this.getSelectedDocument().isOCRValid()) {
                this.ocrQueue.addListenerForSelectTextAction(this, this.getSelectedDocument());
                this.ocrDocument();
            } else {
                try {
                    CMBPage page = this.getSelectedDocument().getPage(this.getCurrentPageNumber());
                    if (page != null && page.ocrLetters == null) {
                        this.ocrQueue.addListenerForSelectTextAction(this, page);
                    } else {
                        this.setCursor("select_text");
                    }
                    this._ocrPage(page);
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean canSelectText() {
        if (!(this.currentLayout instanceof PTabbedViewerLayout)) {
            return false;
        }
        PDocModel docModel = this.getSelectedModel();
        boolean isDocNonEmpty = docModel != null && docModel.getCurrentPageNumber() > 0;
        return isDocNonEmpty && (this.canOcrDocument() || this.canExtractText());
    }

    public boolean canPaste() {
        String methodName = "canPaste";
        Transferable clipContents = this.localClipboard.getContents(this);
        if (clipContents == null) {
            return false;
        }
        if (this.getSelectedModel() == null) {
            return false;
        }
        PDocModel model = this.getSelectedModel();
        if (this.getCurrentMode() == 112) {
            return false;
        }
        if (this.isDocumentPrinting(this.getSelectedModel().getDocument())) {
            return false;
        }
        if (clipContents instanceof CMBPageAnnotation) {
            try {
                return model != null && model.getPageCount() > 0 && this.getSelectedAnnotationSet() != null && this.getSelectedAnnotationSet().getPrivilege(8);
            }
            catch (CMBAnnotationEngineException e) {
                ViewerLogger.logError((Object)this, methodName, e);
                return false;
            }
        }
        if (clipContents instanceof PClippedPages) {
            CMBDocument srcDoc = ((PClippedPages)clipContents).getClipDocument();
            CMBDocumentEngine engine = srcDoc.getEngine();
            int srcPageCount = ((PClippedPages)clipContents).getPageCount();
            return this.pageManipulationEnabled && this.getSelectedDocument().getCanManipulatePages() && model != null && model.getPrivilege(3) && this.getSelectedModel().canPastePages(srcPageCount) && engine.canWriteDocument(srcDoc.getMimeType(), this.getSelectedDocument().getMimeType());
        }
        return false;
    }

    private String getPasteDescription() {
        Transferable clipContents = this.localClipboard.getContents(this);
        if (clipContents == null) {
            return "";
        }
        if (this.getCurrentMode() == 112) {
            return "";
        }
        if (clipContents instanceof CMBPageAnnotation) {
            return PViewerUtilities.getMessage("paste.annotationInsert");
        }
        if (clipContents instanceof PClippedPages) {
            if (((PClippedPages)clipContents).getPageCount() == 1) {
                return PViewerUtilities.getMessage("paste.pageInsert");
            }
            return PViewerUtilities.getMessage("paste.pagesInsert");
        }
        return "";
    }

    public void paste() {
        this.paste(null, this.getCurrentPageNumber());
    }

    void paste(Point point, int pageNumber) {
        if (this.canPaste()) {
            Transferable clipContents = this.localClipboard.getContents(this);
            if (clipContents == null) {
                return;
            }
            if (this.getCurrentMode() == 112) {
                return;
            }
            if (clipContents instanceof CMBPageAnnotation) {
                this.pasteAnnotation(point, pageNumber);
            } else {
                this.pastePages();
            }
        }
    }

    public void pasteAnnotation() {
        new PPasteAnnotationTask(this.getSelectedModel().getTaskManager(), this);
    }

    void pasteAnnotation(Point p, int pageNumber) {
        new PPasteAnnotationTask(this.getSelectedModel().getTaskManager(), this, p, pageNumber);
    }

    private void pastePages() {
        new PPastePagesTask(this.getSelectedModel().getTaskManager(), this, this.getCurrentPageNumber());
    }

    public void lostOwnership(Clipboard parClipboard, Transferable parTransferable) {
    }

    public boolean canDelete() {
        String methodName = "canDelete";
        if (this.getSelectedModel() == null) {
            return false;
        }
        if (this.getSelectedModel().getCurrentPageNumber() <= 0) {
            return false;
        }
        if (this.getCurrentMode() == 112) {
            PDocModel model = this.getSelectedModel();
            if (model == null) {
                return false;
            }
            return this.pageManipulationEnabled && this.getSelectedDocument() != null && this.getSelectedDocument().getCanManipulatePages() && this.getSelectedModel().getPrivilege(8) && ((PPageModel)this.getSelectedModel()).canRedact();
        }
        if (this.isDocumentPrinting(this.getSelectedModel().getDocument())) {
            return false;
        }
        if (this.getAnnotationServices() != null && this.getSelectedAnnotation() != null) {
            try {
                return this.getSelectedAnnotation().canDelete() && this.getSelectedAnnotationSet().getPrivilege(62) && this.getSelectedAnnotationSet().getPrivilege(7);
            }
            catch (CMBAnnotationEngineException e) {
                ViewerLogger.logError((Object)this, methodName, e);
                return false;
            }
        }
        PDocModel model = this.getSelectedModel();
        if (model == null) {
            return false;
        }
        return this.pageManipulationEnabled && this.getSelectedDocument() != null && this.getSelectedDocument().getCanManipulatePages() && this.getSelectedModel().getPrivilege(2) && this.getSelectedModel().canDeletePages(this.getSelectedPageNumbers().length);
    }

    private String getDeleteDescription() {
        if (this.getSelectedModel() == null) {
            return "";
        }
        if (this.getCurrentMode() == 112) {
            if (this.pageManipulationEnabled && this.getSelectedDocument().getCanManipulatePages() && this.getSelectedModel().getPrivilege(8) && ((PPageModel)this.getSelectedModel()).canRedact()) {
                return PViewerUtilities.getMessage("delete.selectedArea");
            }
            return "";
        }
        if (this.getAnnotationServices() != null && this.getSelectedAnnotation() != null) {
            return PViewerUtilities.getMessage("delete.annotationInsert");
        }
        if (!this.pageManipulationEnabled || this.getSelectedDocument() == null || !this.getSelectedDocument().getCanManipulatePages()) {
            return "";
        }
        if (this.getSelectedPageNumbers().length > 1) {
            return PViewerUtilities.getMessage("delete.pagesInsert");
        }
        return PViewerUtilities.getMessage("delete.pageInsert");
    }

    public void delete() {
        String methodName = "delete";
        if (this.canDelete()) {
            if (this.getCurrentMode() == 112) {
                this.deleteSelectedArea();
            } else if (this.getSelectedAnnotation() != null) {
                try {
                    this.deleteSelectedAnnotation();
                }
                catch (CMBAnnotationEngineException e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                }
            } else {
                this.deletePages();
            }
        }
    }

    private void deletePages() {
        if (this.confirmPageDelete) {
            int[] selectedPageNumbers = this.getSelectedPageNumbers();
            int option = POptionPane.showConfirmDialog(this, (Object)(selectedPageNumbers.length == 1 ? PViewerUtilities.getMessage("DocumentViewer.deletePageConfirmationMessage", new String[]{String.valueOf(selectedPageNumbers[0])}) : PViewerUtilities.getMessage("DocumentViewer.deletePagesConfirmationMessage", new String[]{String.valueOf(selectedPageNumbers.length)})), PViewerUtilities.getMessage("DocumentViewer.deletePagesConfirmationTitle"), 2, 3, null);
            switch (option) {
                case 0: {
                    break;
                }
                case -1: 
                case 2: {
                    return;
                }
                default: {
                    return;
                }
            }
        }
        new PDeletePagesTask(this.getSelectedModel().getTaskManager(), this, this.getSelectedPageNumbers());
    }

    private void deleteSelectedArea() {
        Rectangle r = this.getSelectAreaRectangle();
        CMBPage page = ((PPageModel)this.getSelectedModel()).getPage(this.getCurrentPageNumber());
        double s = 1.0 / this.getSelectedModel().getScale() * (double)page.getPageResolution() / (double)this.getSelectedDocument().getDisplayResolution();
        Rectangle rPage = new Rectangle((int)((double)r.x * s), (int)((double)r.y * s), (int)((double)r.width * s), (int)((double)r.height * s));
        new PDeleteSelectedAreaTask(this.getSelectedModel().getTaskManager(), this, this.getCurrentPageNumber(), rPage);
    }

    public boolean getPrivilege(CMBDocument document, int privilege) {
        if (privilege == 1) {
            return this.createDocumentPrivilege;
        }
        PSingleDocViewer viewer = this.getViewer(document);
        if (viewer.getDocModel() instanceof PPageModel) {
            PPageModel model = (PPageModel)viewer.getDocModel();
            return model.getPrivilege(privilege);
        }
        return false;
    }

    public void setPrivilege(CMBDocument document, int privilege, boolean enable) {
        if (privilege == 1) {
            this.createDocumentPrivilege = enable;
        } else {
            PSingleDocViewer viewer = this.getViewer(document);
            if (viewer != null && viewer.getDocModel() instanceof PPageModel) {
                PPageModel model = (PPageModel)viewer.getDocModel();
                model.setPrivilege(privilege, enable);
                if (privilege == 4 && model.getAnnotationSet() != null) {
                    if (enable && this.pageManipulationEnabled && document.getCanManipulatePages()) {
                        model.getAnnotationSet().setPermanentlyRotating(true);
                    } else {
                        model.getAnnotationSet().setPermanentlyRotating(false);
                    }
                }
            }
        }
        this.updateToolStates();
    }

    public void setPageManipulationEnabled(boolean enable) {
        this.pageManipulationEnabled = enable;
        this.updateToolStates();
    }

    public boolean isPageManipulationEnabled() {
        return this.pageManipulationEnabled;
    }

    public boolean getPageManipulationPrivilege(CMBDocument document, int privilege) {
        return this.getPrivilege(document, privilege);
    }

    public void setPageManipulationPrivilege(CMBDocument document, int privilege, boolean enable) {
        this.setPrivilege(document, privilege, enable);
    }

    public boolean isMultiplePageSelectionEnabled() {
        return this.multiplePageSelectionEnabled;
    }

    public void setMultiplePageSelectionEnabled(boolean multiplePageSelectionEnabled) {
        this.multiplePageSelectionEnabled = multiplePageSelectionEnabled;
    }

    public int[] getSelectedPageNumbers() {
        if (!(this.getSelectedModel() instanceof PPageModel)) {
            throw new UnsupportedOperationException();
        }
        return ((PPageModel)this.getSelectedModel()).getSelectedPages();
    }

    public void setSelectedPageNumbers(int[] pages) throws IllegalArgumentException {
        if (!(this.getSelectedModel() instanceof PPageModel)) {
            throw new UnsupportedOperationException();
        }
        ((PPageModel)this.getSelectedModel()).setSelectedPages(pages);
    }

    void selectAllPages() {
        try {
            int[] viewablePages = this.getViewablePageNumbers();
            if (viewablePages != null) {
                this.setSelectedPageNumbers(viewablePages);
            } else {
                int pageCount = this.getPageCount();
                int[] pages = new int[pageCount];
                for (int i = 1; i <= pageCount; ++i) {
                    pages[i - 1] = i;
                }
                this.setSelectedPageNumbers(pages);
            }
        }
        catch (IOException e) {
            return;
        }
    }

    void deselectAll() {
        int[] pages = new int[]{};
        this.setSelectedPageNumbers(pages);
    }

    boolean canSelectAllPages() {
        return this.isMultiplePageSelectionEnabled() && this.getSelectedModel() != null && this.getSelectedModel() instanceof PPageModel && ((PPageModel)this.getSelectedModel()).getSelectedPages().length != this.getSelectedModel().getPageCount();
    }

    boolean canDeselectAll() {
        if (this.getAnnotationServices() != null && this.getSelectedAnnotation() != null) {
            return true;
        }
        return this.getSelectedModel() != null && this.getSelectedModel() instanceof PPageModel && ((PPageModel)this.getSelectedModel()).getSelectedPages().length > 1;
    }

    public String getNewDocumentMimetype() {
        return this.newDocumentMimetype;
    }

    public void setNewDocumentMimetype(String mimetype) {
        this.newDocumentMimetype = mimetype;
    }

    public boolean canCreateDocument() {
        return this.isPageManipulationEnabled() && this.createDocumentPrivilege;
    }

    public CMBDocument createDocument() throws CMBDocumentEngineException, CMBAnnotationEngineException {
        String methodName = "createDocument";
        if (!this.canCreateDocument()) {
            return null;
        }
        String mimetype = this.getNewDocumentMimetype();
        String annotationtype = this.configProperties.getProperty("NewDocument.annotationtype");
        CMBDocument document = this.getDocServices().createDocument(mimetype);
        if (document != null) {
            int position = document.getAnnotationPosition();
            CMBAnnotationSet annotationSet = null;
            try {
                annotationSet = this.loadAnnotations(null, annotationtype, position, 1, 0);
            }
            catch (ClassNotFoundException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            catch (IllegalAccessException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            catch (InstantiationException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            this.showDocument(document, annotationSet, PViewerUtilities.getMessage("DocumentViewer.NewDocument"));
        }
        return document;
    }

    public void setDocName(CMBDocument document, String docName) {
        PSingleDocViewer viewer = this.getViewer(document);
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        viewer.getDocModel().setDocName(docName);
        this.currentLayout.setDocName(document, docName);
        if (this.hasDocumentBeenViewed(document)) {
            boolean indicate = (Boolean)this.getClientProperty("Appearance.tab.indicate");
            this.currentLayout.indicateDocument(document, indicate);
        }
    }

    public String getDocName(CMBDocument document) {
        PSingleDocViewer viewer = this.getViewer(document);
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        return viewer.getDocModel().getDocName();
    }

    public boolean hasDocumentBeenViewed(CMBDocument document) {
        if (this.activeViewers.size() == 0) {
            throw new IllegalArgumentException();
        }
        PSingleDocViewer viewer = this.getViewer(document);
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        PPageModel docModel = (PPageModel)viewer.getDocModel();
        return docModel.isViewed();
    }

    public void setDocumentViewed(CMBDocument document, boolean viewed) {
        if (this.activeViewers.size() == 0) {
            throw new IllegalArgumentException();
        }
        PSingleDocViewer viewer = this.getViewer(document);
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        PPageModel docModel = (PPageModel)viewer.getDocModel();
        docModel.setViewed(viewed);
        boolean indicate = (Boolean)this.getClientProperty("Appearance.tab.indicate");
        this.currentLayout.indicateDocument(document, indicate);
        if (this.getSelectedDocument().equals(document)) {
            this.checkToIndicateDocument();
        }
    }

    CMBStreamingDocServices getDocServices() {
        return this.docServices;
    }

    CMBAnnotationServices getAnnotationServices() {
        return this.annoServices;
    }

    JPopupMenu getPagePopupMenu() {
        return this.pagePopupMenu;
    }

    JPopupMenu getThumbPopupMenu() {
        return this.thumbPopupMenu;
    }

    void setDialogDisplayed(JDialog dialog) {
        this.dialogDisplayed = dialog;
    }

    public static void importSystemPreferences(InputStream is) throws IOException, InvalidPreferencesFormatException {
        Preferences systemPrefs = Preferences.systemNodeForPackage(CMBGenericDocViewer.class);
        try {
            systemPrefs.clear();
        }
        catch (BackingStoreException e) {
            System.out.println(PViewerUtilities.getMessage("preference.backingStoreException"));
        }
        Preferences.importPreferences(is);
        is.close();
    }

    public static void importUserPreferences(InputStream is) throws IOException, InvalidPreferencesFormatException {
        Preferences userPrefs = Preferences.userNodeForPackage(CMBGenericDocViewer.class);
        try {
            userPrefs.clear();
        }
        catch (BackingStoreException e) {
            System.out.println(PViewerUtilities.getMessage("preference.backingStoreException"));
        }
        Preferences.importPreferences(is);
        is.close();
    }

    public void exportSystemPreferences(OutputStream os) throws IOException, BackingStoreException, IllegalStateException {
        Preferences systemPrefs = Preferences.systemNodeForPackage(CMBGenericDocViewer.class);
        systemPrefs.exportNode(os);
    }

    public void exportUserPreferences(OutputStream os) throws IOException, BackingStoreException, IllegalStateException {
        this.updateUserPreferencesFromPreferenceSets();
        Preferences userPrefs = Preferences.userNodeForPackage(CMBGenericDocViewer.class);
        userPrefs.exportNode(os);
    }

    Properties getSystemProperties() {
        return this.systemProperties;
    }

    private Properties getSystemProperties(Properties defaults) {
        Properties properties = new Properties(defaults);
        if (this.systemPrefs == null) {
            return properties;
        }
        try {
            for (String name : this.systemPrefs.keys()) {
                String value = this.systemPrefs.get(name, "Unknown");
                properties.put(name, value);
            }
        }
        catch (BackingStoreException e) {
            System.out.println(PViewerUtilities.getMessage("preference.backingStoreException"));
        }
        return properties;
    }

    Properties getUserProperties(Properties defaults) {
        Properties properties = new Properties(defaults);
        if (this.userPrefs == null) {
            ViewerLogger.logDebug(this, "getUserProperties", properties.toString());
            return properties;
        }
        try {
            for (String name : this.userPrefs.keys()) {
                String value = this.userPrefs.get(name, "Unknown");
                properties.put(name, value);
            }
        }
        catch (BackingStoreException e) {
            System.out.println(PViewerUtilities.getMessage("preference.backingStoreException"));
        }
        ViewerLogger.logDebug(this, "getUserProperties", properties.toString());
        return properties;
    }

    public Properties getConfigProperties() {
        return this.configProperties;
    }

    public void setConfigProperties(Properties properties) {
        this.configProperties = properties;
        this.updateViewerFromProperties(false);
    }

    void updateUserPreferencesFromProperties(Properties properties) {
        if (properties != null && this.userPrefs != null) {
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                this.userPrefs.put(name, properties.getProperty(name));
            }
        }
    }

    void updateSystemPreferencesFromProperties(Properties properties, boolean override) {
        if (this.systemPrefs != null && properties != null && this.systemPrefsUpdateAccess) {
            for (int i = 0; i < PPreferenceSet.preferenceKeys.length; ++i) {
                String key = PPreferenceSet.preferenceKeys[i];
                if (!properties.containsKey(key) || this.keyExists(this.systemPrefs, key) && (!this.keyExists(this.systemPrefs, key) || !override)) continue;
                this.systemPrefs.put(key, properties.getProperty(key));
            }
            String names = properties.getProperty("Toolbars");
            if (names != null) {
                StringTokenizer tok = new StringTokenizer(names, VIEWER_CONFIG_DELIM);
                while (tok.hasMoreTokens()) {
                    String name = tok.nextToken();
                    String key = name + ".position";
                    if (properties.containsKey(key) && (!this.keyExists(this.systemPrefs, key) || this.keyExists(this.systemPrefs, key) && override)) {
                        this.systemPrefs.put(key, properties.getProperty(key));
                    }
                    if (!properties.containsKey(key = name + ".show") || this.keyExists(this.systemPrefs, key) && (!this.keyExists(this.systemPrefs, key) || !override)) continue;
                    this.systemPrefs.put(key, properties.getProperty(key));
                }
            }
        }
    }

    public boolean haveUserPreferencesChanged() throws BackingStoreException {
        Properties userProperties = new Properties();
        Enumeration<TreeNode> en = this.getPreferenceSets().preorderEnumeration();
        while (en.hasMoreElements()) {
            CMBPreferenceSet ps;
            Properties psProperties;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            if (!(node.getUserObject() instanceof CMBPreferenceSet) || (psProperties = (ps = (CMBPreferenceSet)node.getUserObject()).exportAction()) == null) continue;
            Enumeration<?> names = psProperties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                userProperties.setProperty(name, psProperties.getProperty(name));
            }
        }
        Enumeration<?> names = userProperties.propertyNames();
        while (names.hasMoreElements()) {
            String propName = (String)names.nextElement();
            String propValue = userProperties.getProperty(propName);
            if (this.startingUserProperties.containsKey(propName)) {
                String startValue = this.startingUserProperties.getProperty(propName);
                if (startValue.compareToIgnoreCase(propValue) == 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private void updateUserPreferencesFromPreferenceSets() {
        Enumeration<TreeNode> en = this.getPreferenceSets().preorderEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            if (!(node.getUserObject() instanceof CMBPreferenceSet)) continue;
            CMBPreferenceSet ps = (CMBPreferenceSet)node.getUserObject();
            this.updateUserPreferencesFromPreferenceSet(ps);
        }
    }

    void updateUserPreferencesFromPreferenceSet(CMBPreferenceSet ps) {
        Properties psProperties = ps.exportAction();
        if (psProperties != null) {
            this.updateUserPreferencesFromProperties(psProperties);
        }
    }

    private boolean keyExists(Preferences p, String s) {
        int i;
        String[] k = null;
        try {
            k = p.keys();
        }
        catch (BackingStoreException e) {
            return false;
        }
        int n = k.length;
        for (i = 0; i < n && !k[i].equals(s); ++i) {
        }
        return i < n;
    }

    private static boolean systemPrefsAuthorization() {
        try {
            Preferences systemPrefs = Preferences.systemNodeForPackage(CMBGenericDocViewer.class);
            boolean oldValue = systemPrefs.getBoolean(SYSTEM_PREFS_UPDATE_TEST, false);
            systemPrefs.putBoolean(SYSTEM_PREFS_UPDATE_TEST, !oldValue);
            systemPrefs.flush();
        }
        catch (BackingStoreException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    public void setViewerLayout(int viewerLayout) {
        if (this.currentLayout.getViewType() == viewerLayout) {
            return;
        }
        if (!this.areThumbnailsDocked()) {
            this.dockThumbnails(true);
        }
        if (this.isScrollingLocked() && viewerLayout != 1 && viewerLayout != 2) {
            this._unlockScrolling();
        }
        this.previousLayout = this.currentLayout.getViewType();
        if (viewerLayout == 0) {
            if (this.currentLayout != null) {
                this.toolbarsPanel.remove(this.currentLayout.getViewerComponent());
                this.currentLayout.dispose();
            }
            this.currentLayout = new PTabbedViewerLayout(this);
        } else if (viewerLayout == 1) {
            if (this.currentLayout != null) {
                if (this.currentLayout.getViewType() == 2) {
                    ((PSplitViewerLayout)this.currentLayout).setHorizontalSplit(true);
                    this.currentLayout.getViewerComponent().requestFocus();
                    return;
                }
                this.toolbarsPanel.remove(this.currentLayout.getViewerComponent());
                this.currentLayout.dispose();
            }
            this.currentLayout = new PSplitViewerLayout(this, true);
        } else if (viewerLayout == 2) {
            if (this.currentLayout != null) {
                if (this.currentLayout.getViewType() == 1) {
                    ((PSplitViewerLayout)this.currentLayout).setHorizontalSplit(false);
                    this.currentLayout.getViewerComponent().requestFocus();
                    return;
                }
                this.toolbarsPanel.remove(this.currentLayout.getViewerComponent());
                this.currentLayout.dispose();
            }
            this.currentLayout = new PSplitViewerLayout(this, false);
        } else if (viewerLayout == 3) {
            if (this.currentLayout != null) {
                this.toolbarsPanel.remove(this.currentLayout.getViewerComponent());
                this.currentLayout.dispose();
            }
            this.currentLayout = new PThumbnailsOnlyViewerLayout(this);
        } else if (viewerLayout == 4) {
            if (this.currentLayout != null) {
                this.toolbarsPanel.remove(this.currentLayout.getViewerComponent());
                this.currentLayout.dispose();
            }
            this.currentLayout = new PSingleViewerLayout(this);
        }
        this.toolbarsPanel.add((Component)this.currentLayout.getViewerComponent(), "Center");
        this.toolbarsPanel.validate();
        this.currentLayout.setTabPlacement(this.tabPosition);
        this.reregisterKeyboardActions();
        this.currentLayout.getViewerComponent().requestFocus();
    }

    int getPreviousLayout() {
        return this.previousLayout;
    }

    public int getViewerLayout() {
        return this.currentLayout.getViewType();
    }

    PSingleDocViewer createSingleDocViewer(CMBDocument document, CMBAnnotationSet annoSet, String docName) {
        PSingleDocViewer viewer;
        if (document.getCanProvideViewer()) {
            viewer = document.getViewerComponent(this, annoSet);
            viewer.getDocModel().setDocName(docName);
        } else {
            viewer = new PPageViewer(this, document, annoSet, docName);
        }
        return viewer;
    }

    void find() {
        if (!this.canFind()) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        this.useNewFindDialog = Boolean.valueOf(this.configProperties.getProperty("findDialog.new", "false"));
        PFullSizeView view = this.getSelectedView();
        if (view == null || !view.canFind()) {
            this.findWithOCR();
        } else if (this.useNewFindDialog) {
            this.findWithPanel();
        } else {
            if (this.findDialog == null) {
                this.findDialog = new PFindDialog(this.getOwningFrame(), this);
            }
            this.findDialog.show();
        }
    }

    public boolean canFind() {
        PFullSizeView view = this.getSelectedView();
        if (view != null && view.canFind()) {
            return true;
        }
        return this.canFindWithOCR();
    }

    public boolean canExtractText() {
        PFullSizeView view = this.getSelectedView();
        return view != null && view.canFind() && view.getDocModel().getDocument().getMimeType().equalsIgnoreCase("application/pdf");
    }

    boolean canFindWithOCR() {
        if (!(this.currentLayout instanceof PTabbedViewerLayout)) {
            return false;
        }
        if (this.ocrQueue != null && this.ocrQueue.hasDocumentsOCR()) {
            return false;
        }
        Object[] pageViewers = this.activeViewers.toArray();
        if (pageViewers.length == 0) {
            return false;
        }
        boolean returnValue = true;
        for (int i = 0; i < pageViewers.length; ++i) {
            boolean isDocNonEmpty;
            PSingleDocViewer pageViewer = (PSingleDocViewer)pageViewers[i];
            PDocModel docModel = pageViewer.getDocModel();
            boolean bl = isDocNonEmpty = docModel != null && docModel.getCurrentPageNumber() > 0;
            if (!isDocNonEmpty || !this.docServices.canOcr(docModel.getDocument())) continue;
            return true;
        }
        return false;
    }

    public CMBLetters extractText() {
        try {
            PDocModel model = this.getSelectedModel();
            if (model != null && model instanceof PPageModel) {
                CMBPage page = this.getSelectedDocument().getPage(this.getCurrentPageNumber());
                return this._extractText(page);
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    synchronized CMBLetters _extractText(CMBPage page) {
        CMBDocument document = page.getDocument();
        PSingleDocViewer viewer = this.getViewer(document);
        PDocModel model = null;
        if (viewer == null) {
            return null;
        }
        model = viewer.getDocModel();
        if (model != null && model instanceof PPageModel) {
            CMBLetters letters = page.extractText();
            if (letters != null && letters.getLetters() != null && letters.getLetters().length > 0) {
                CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, document, new int[]{page.getPageNumber()}, 26);
                model.fireDocStateChangedEvent(event);
            }
            return letters;
        }
        return null;
    }

    boolean isFindActive() {
        boolean isFindActive = false;
        if (this.currentLayout != null && this.currentLayout.getFindPanel() != null && this.currentLayout.getFindPanel().isShowing()) {
            isFindActive = true;
        }
        return isFindActive;
    }

    void findWithOCR() {
        if (!this.canFindWithOCR()) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.operationNotValid"));
        }
        this.currentLayout.showFindPanel(true);
    }

    void findWithPanel() {
        this.currentLayout.showFindPanel(true);
    }

    public boolean find(String text, boolean matchCase, boolean reverse) {
        if (this.getSelectedDocument().getEngine().canFind(this.getSelectedDocument().getDocumentHandle())) {
            PFullSizeView view = this.getSelectedView();
            if (view != null) {
                return view.find(text, matchCase, reverse);
            }
            return false;
        }
        return this.findOnPage(this.getSelectedDocument(), this.getCurrentPageNumber(), text, matchCase, reverse, true);
    }

    boolean findOnPage(CMBDocument document, int pageNum, String text, boolean matchCase, boolean reverse, boolean performOCR) {
        try {
            int pagecount = document.getPageCount();
            CMBPage page = document.getPage(pageNum);
            boolean hitFound = false;
            if (reverse) {
                do {
                    if ((hitFound = this.findPrevOnPage(document, pageNum, text, matchCase, performOCR)) || --pageNum <= 0) continue;
                    page = document.getPage(pageNum);
                    page.hitIndex = Integer.MAX_VALUE;
                } while (!hitFound && pageNum > 0);
                return hitFound;
            }
            do {
                if ((hitFound = this.findNextOnPage(document, pageNum, text, matchCase, performOCR)) || ++pageNum > pagecount) continue;
                page = document.getPage(pageNum);
                page.hitIndex = -1;
            } while (!hitFound && pageNum <= pagecount);
            return hitFound;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean canNextPage(int currentPageNumber) {
        boolean value = false;
        PDocModel model = this.getSelectedModel();
        if (model != null && model instanceof PPageModel) {
            int currentPagePosition = ((PPageModel)model).getPagePosition(currentPageNumber);
            int pageCount = ((PPageModel)model).getPageCount();
            if (pageCount > currentPagePosition) {
                value = true;
            } else if (pageCount == -1 && ((PPageModel)model).isValidPagePosition(currentPagePosition + 1)) {
                value = true;
            }
        }
        return value;
    }

    int findAll(CMBDocument document, String text, boolean matchCase) throws IOException {
        if (document.getMimeType().equalsIgnoreCase("application/pdf") ? !document.isTextValid() : !document.isOCRValid()) {
            return 0;
        }
        int matchCount = 0;
        int pageCount = document.getPageCount();
        for (int i = 1; i <= pageCount; ++i) {
            matchCount += this.findAllOnPage(document, i, text, matchCase);
        }
        return matchCount;
    }

    private void _ocrPage(CMBPage page) throws IOException {
        boolean needOcr = true;
        if (page.getLetters() == null) {
            POCRQueueItem item = new POCRQueueItem(this, page.getDocument(), new int[]{page.getPageNumber()});
            this.ocrQueue.put(item);
        }
    }

    int findAllOnPage(CMBDocument document, int pageNumber, String text, boolean matchCase) {
        int matchCount = 0;
        try {
            CMBPage page = document.getPage(pageNumber);
            this._ocrPage(page);
            if (page.findPattern != null && page.findPattern.pattern().equals(text) && (page.findPattern.flags() & 2) == 0 == matchCase) {
                if (page.matchResults != null) {
                    matchCount = page.matchResults.size();
                }
            } else {
                page.find(text, matchCase);
                if (page.matchResults != null) {
                    matchCount = page.matchResults.size();
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return matchCount;
    }

    private boolean findNextOnPage(CMBDocument document, int pageNumber, String text, boolean matchCase, boolean performOCR) {
        int hitIndex = -1;
        try {
            CMBPage page = document.getPage(pageNumber);
            if (performOCR) {
                this._ocrPage(page);
            }
            if (page.getLetters() == null || page.getLetters().getLetters() == null || page.getLetters().getLetters().length == 0) {
                return false;
            }
            if (page.findPattern != null && page.findPattern.pattern().equals(text) && (page.findPattern.flags() & 2) == 0 == matchCase) {
                hitIndex = page.hitIndex + 1;
            } else {
                page.hitIndex = -1;
                page.find(text, matchCase);
                hitIndex = page.hitIndex + 1;
            }
            if (page.matchResults == null || page.matchResults.size() == 0) {
                return false;
            }
            if (hitIndex < 0 || hitIndex >= page.matchResults.size()) {
                return false;
            }
            page.hitIndex = hitIndex;
            this.setCurrentPageNumber(pageNumber);
            MatchResult result = page.matchResults.get(hitIndex);
            Polygon selectedPolygon = page.getLetters().getPolygonBounds(result.start(), result.end() - 1);
            PPageModel pageModel = (PPageModel)this.getSelectedModel();
            Polygon scaledPolygon = pageModel.getScaledPolygon(selectedPolygon);
            try {
                this.moveCurrentViewRectangle(scaledPolygon.getBounds().x, scaledPolygon.getBounds().y);
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            page.letterIndex = result.start();
            this.getSelectedModel().fireDocStateChangedEvent(21);
            return true;
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    private boolean findPrevOnPage(CMBDocument document, int pageNumber, String text, boolean matchCase, boolean performOCR) {
        int hitIndex = -1;
        try {
            CMBPage page = document.getPage(pageNumber);
            if (performOCR) {
                this._ocrPage(page);
            }
            if (page.getLetters() == null || page.getLetters().getLetters() == null || page.getLetters().getLetters().length == 0) {
                return false;
            }
            if (page.findPattern != null && page.findPattern.pattern().equals(text) && (page.findPattern.flags() & 2) == 0 == matchCase) {
                hitIndex = page.hitIndex == Integer.MAX_VALUE ? page.matchResults.size() - 1 : page.hitIndex - 1;
            } else {
                page.find(text, matchCase);
                hitIndex = page.matchResults.size();
            }
            if (page.matchResults == null || page.matchResults.size() == 0) {
                return false;
            }
            if (hitIndex < 0 || hitIndex > page.matchResults.size()) {
                return false;
            }
            page.hitIndex = hitIndex;
            this.setCurrentPageNumber(pageNumber);
            MatchResult result = page.matchResults.get(hitIndex);
            Polygon selectedPolygon = page.getLetters().getPolygonBounds(result.start(), result.end() - 1);
            PPageModel pageModel = (PPageModel)this.getSelectedModel();
            Polygon scaledPolygon = pageModel.getScaledPolygon(selectedPolygon);
            try {
                this.moveCurrentViewRectangle(scaledPolygon.getBounds().x, scaledPolygon.getBounds().y);
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            page.letterIndex = result.end() - 1;
            this.getSelectedModel().fireDocStateChangedEvent(21);
            return true;
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    boolean isContinuousPaginationEnabled() {
        return this.continuousPaginationEnabled;
    }

    void setSelectedViewTemporary(boolean selectedViewTemporary) {
        this.selectedViewTemporary = selectedViewTemporary;
    }

    public CMBBookmark[] getBookmarks() {
        PDocModel model = this.getSelectedModel();
        if (model != null && model instanceof PPageModel) {
            return ((PPageModel)model).getBookmarks();
        }
        throw new UnsupportedOperationException();
    }

    public void setBookmarks(CMBBookmark[] bookmarks) {
        PDocModel model = this.getSelectedModel();
        if (!this._canBookmark(model)) {
            throw new UnsupportedOperationException();
        }
        ((PPageModel)model).setBookmarks(bookmarks);
    }

    public boolean canBookmark() {
        PDocModel model = this.getSelectedModel();
        return this._canBookmark(model);
    }

    private boolean _canBookmark(PDocModel model) {
        boolean supports = false;
        if (model != null && model instanceof PPageModel) {
            supports = true;
        }
        return supports;
    }

    public void addBookmarksEditListener(CMBBookmarksEditListener listener) {
        if (this.bookmarksEditListeners == null) {
            this.bookmarksEditListeners = new ArrayList();
        }
        this.bookmarksEditListeners.add(listener);
    }

    public void removeBookmarksEditListener(CMBBookmarksEditListener listener) {
        if (this.bookmarksEditListeners != null) {
            this.bookmarksEditListeners.remove(listener);
        }
    }

    boolean fireBookmarksBeginEditingEvent(CMBDocument document) {
        boolean lockFailed = false;
        if (this.bookmarksEditListeners != null) {
            CMBBookmarksEditEvent ev = new CMBBookmarksEditEvent(document, null);
            for (int i = 0; i < this.bookmarksEditListeners.size(); ++i) {
                CMBBookmarksEditListener listener = (CMBBookmarksEditListener)this.bookmarksEditListeners.get(i);
                listener.beginEditing(ev);
            }
            lockFailed = ev.getEventFailed();
        }
        return lockFailed;
    }

    boolean fireBookmarksEndEditingEvent(CMBDocument document, CMBBookmark[] newBookmarks) {
        boolean saveFailed = false;
        if (this.bookmarksEditListeners != null) {
            CMBBookmarksEditEvent ev = new CMBBookmarksEditEvent(document, newBookmarks);
            for (int i = 0; i < this.bookmarksEditListeners.size(); ++i) {
                CMBBookmarksEditListener listener = (CMBBookmarksEditListener)this.bookmarksEditListeners.get(i);
                listener.endEditing(ev);
            }
            saveFailed = ev.getEventFailed();
        }
        return saveFailed;
    }

    private class PropertyHandler
    implements PropertyChangeListener {
        private PropertyHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("Annotations.show")) {
                Boolean newValue = (Boolean)evt.getNewValue();
                if (CMBGenericDocViewer.this.annoServices != null) {
                    if (CMBGenericDocViewer.this.getSelectedModel() != null) {
                        CMBGenericDocViewer.this._showAnnotations(newValue);
                    }
                    CMBAnnotationSet[] sets = CMBGenericDocViewer.this.annoServices.getAllAnnotationSets();
                    for (int i = 0; i < sets.length; ++i) {
                        CMBAnnotationSet set = sets[i];
                        CMBPageAnnotation[] annos = set.getPageAnnotations();
                        for (int j = 0; j < annos.length; ++j) {
                            CMBPageAnnotation a = annos[j];
                            if (newValue.booleanValue()) {
                                a.pleaseDraw();
                                continue;
                            }
                            a.dontDraw();
                        }
                    }
                }
                CMBGenericDocViewer.this.validate();
            } else if (evt.getPropertyName().equalsIgnoreCase("Annotations.immediatePreview")) {
                Boolean newValue = (Boolean)evt.getNewValue();
                PViewerUtilities.setBooleanProperty("Annotations.immediatePreview", CMBGenericDocViewer.this.configProperties, newValue);
                if (CMBGenericDocViewer.this.annoServices != null) {
                    CMBAnnotationSet[] sets = CMBGenericDocViewer.this.annoServices.getAllAnnotationSets();
                    for (int i = 0; i < sets.length; ++i) {
                        CMBAnnotationSet set = sets[i];
                        CMBPageAnnotation[] annos = set.getPageAnnotations();
                        for (int j = 0; j < annos.length; ++j) {
                            CMBPageAnnotation a = annos[j];
                            a.setApplyNow(newValue);
                        }
                    }
                }
            } else if (evt.getPropertyName().equalsIgnoreCase("Annotations.visibleWhileDrag")) {
                Boolean newValue = (Boolean)evt.getNewValue();
                PViewerUtilities.setBooleanProperty("Annotations.visibleWhileDrag", CMBGenericDocViewer.this.configProperties, newValue);
                if (CMBGenericDocViewer.this.annoServices != null) {
                    CMBAnnotationSet[] sets = CMBGenericDocViewer.this.annoServices.getAllAnnotationSets();
                    for (int i = 0; i < sets.length; ++i) {
                        CMBAnnotationSet set = sets[i];
                        CMBPageAnnotation[] annos = set.getPageAnnotations();
                        for (int j = 0; j < annos.length; ++j) {
                            CMBPageAnnotation a = annos[j];
                            a.setVisibleWhileDragging(newValue);
                        }
                    }
                }
            } else if (evt.getPropertyName().equalsIgnoreCase("AnnotationTool.sticky")) {
                Boolean newValue = (Boolean)evt.getNewValue();
                PViewerUtilities.setBooleanProperty("AnnotationTool.sticky", CMBGenericDocViewer.this.configProperties, newValue);
                CMBGenericDocViewer.this._setAnnotationToolSticky(newValue);
            } else if (evt.getPropertyName().equalsIgnoreCase("History.queue")) {
                Integer newValue = (Integer)evt.getNewValue();
                Enumeration en = CMBGenericDocViewer.this.activeViewers.elements();
                while (en.hasMoreElements()) {
                    PSingleDocViewer v = (PSingleDocViewer)en.nextElement();
                    v.getDocModel().getTaskManager().setMaxHistoryLength(newValue);
                }
                PViewerUtilities.setIntegerProperty("History.queue", CMBGenericDocViewer.this.configProperties, newValue);
            } else if (evt.getPropertyName().equalsIgnoreCase("Document.rotate")) {
                String documentRotation = (String)evt.getNewValue();
                PViewerUtilities.setStringProperty("Document.rotate", CMBGenericDocViewer.this.configProperties, documentRotation);
            } else if (evt.getPropertyName().equalsIgnoreCase("Document.invert")) {
                Boolean documentInvert = (Boolean)evt.getNewValue();
                PViewerUtilities.setBooleanProperty("Document.invert", CMBGenericDocViewer.this.configProperties, documentInvert);
            } else if (evt.getPropertyName().equalsIgnoreCase("Document.enhance")) {
                Boolean documentEnhance = (Boolean)evt.getNewValue();
                PViewerUtilities.setBooleanProperty("Document.enhance", CMBGenericDocViewer.this.configProperties, documentEnhance);
            } else if (evt.getPropertyName().equalsIgnoreCase("Document.ocr")) {
                Boolean documentOCR = (Boolean)evt.getNewValue();
                PViewerUtilities.setBooleanProperty("Document.ocr", CMBGenericDocViewer.this.configProperties, documentOCR);
            } else if (evt.getPropertyName().equalsIgnoreCase("Zoom.factor")) {
                Integer newValue = (Integer)evt.getNewValue();
                double dVal = newValue.doubleValue();
                if (dVal > 0.0 && dVal <= 100.0) {
                    dVal /= 100.0;
                    Enumeration en = CMBGenericDocViewer.this.activeViewers.elements();
                    while (en.hasMoreElements()) {
                        PSingleDocViewer v = (PSingleDocViewer)en.nextElement();
                        v.getDocModel().setZoomFactor(dVal);
                    }
                    PViewerUtilities.setIntegerProperty("Zoom.factor", CMBGenericDocViewer.this.configProperties, newValue);
                }
            } else if (evt.getPropertyName().equalsIgnoreCase("Zoom.default")) {
                String zoomOption = (String)evt.getNewValue();
                PViewerUtilities.setStringProperty("Zoom.default", CMBGenericDocViewer.this.configProperties, zoomOption);
            } else if (evt.getPropertyName().equalsIgnoreCase("Appearance.tab.indicate")) {
                Boolean newValue = (Boolean)evt.getNewValue();
                CMBGenericDocViewer.this.checkToIndicateDocument();
                CMBGenericDocViewer.this.indicateViewedDocuments(newValue);
                PViewerUtilities.setBooleanProperty("Appearance.tab.indicate", CMBGenericDocViewer.this.configProperties, newValue);
            } else if (evt.getPropertyName().equalsIgnoreCase("Appearance.tab.fontstyle")) {
                String newValue = (String)evt.getNewValue();
                PViewerUtilities.setStringProperty("Appearance.tab.fontstyle", CMBGenericDocViewer.this.configProperties, newValue);
                boolean indicate = (Boolean)CMBGenericDocViewer.this.getClientProperty("Appearance.tab.indicate");
                CMBGenericDocViewer.this.indicateViewedDocuments(indicate);
            } else if (evt.getPropertyName().equalsIgnoreCase("Appearance.tab.color")) {
                String newValue = (String)evt.getNewValue();
                PViewerUtilities.setColorProperty("Appearance.tab.color", CMBGenericDocViewer.this.configProperties, newValue);
                boolean indicate = (Boolean)CMBGenericDocViewer.this.getClientProperty("Appearance.tab.indicate");
                CMBGenericDocViewer.this.indicateViewedDocuments(indicate);
            } else if (evt.getPropertyName().equalsIgnoreCase("Appearance.tab.delay")) {
                Integer newValue = (Integer)evt.getNewValue();
                PViewerUtilities.setIntegerProperty("Appearance.tab.delay", CMBGenericDocViewer.this.configProperties, newValue);
                boolean indicate = (Boolean)CMBGenericDocViewer.this.getClientProperty("Appearance.tab.indicate");
                CMBGenericDocViewer.this.checkToIndicateDocument();
            } else if (evt.getPropertyName().equalsIgnoreCase("Thumbnailbar.show")) {
                Boolean newValue = (Boolean)evt.getNewValue();
                CMBGenericDocViewer.this._showThumbnails(newValue);
                CMBGenericDocViewer.this.validate();
            } else if (evt.getPropertyName().equalsIgnoreCase("ThumbnailSize")) {
                String sizeOption = (String)evt.getNewValue();
                CMBGenericDocViewer.this.setThumbnailsRelativeSize(sizeOption);
                CMBGenericDocViewer.this.validate();
            } else if (evt.getPropertyName().equalsIgnoreCase("Thumbnailbar.position")) {
                String newValue = (String)evt.getNewValue();
                CMBGenericDocViewer.this._setThumbnailsPosition(newValue);
                CMBGenericDocViewer.this.validate();
            } else if (evt.getPropertyName().equalsIgnoreCase("Thumbnails.dock")) {
                Boolean newValue = (Boolean)evt.getNewValue();
                CMBGenericDocViewer.this._dockThumbnails(newValue);
                CMBGenericDocViewer.this.validate();
            } else if (evt.getPropertyName().endsWith(".show")) {
                String propName = evt.getPropertyName();
                int endIndex = propName.lastIndexOf(".");
                String tbName = propName.substring(0, endIndex);
                Boolean newValue = (Boolean)evt.getNewValue();
                CMBGenericDocViewer.this.removePropertyChangeListener(tbName + ".show", CMBGenericDocViewer.this.propertyHandler);
                CMBGenericDocViewer.this.removePropertyChangeListener(tbName + ".position", CMBGenericDocViewer.this.propertyHandler);
                CMBGenericDocViewer.this.setToolbarVisible(tbName, newValue);
                CMBGenericDocViewer.this.validate();
                CMBGenericDocViewer.this.addPropertyChangeListener(tbName + ".show", CMBGenericDocViewer.this.propertyHandler);
                CMBGenericDocViewer.this.addPropertyChangeListener(tbName + ".position", CMBGenericDocViewer.this.propertyHandler);
            } else if (evt.getPropertyName().endsWith(".position")) {
                String propName = evt.getPropertyName();
                int endIndex = propName.lastIndexOf(".");
                String tbName = propName.substring(0, endIndex);
                CMBGenericDocViewer.this.removePropertyChangeListener(tbName + ".show", CMBGenericDocViewer.this.propertyHandler);
                CMBGenericDocViewer.this.removePropertyChangeListener(tbName + ".position", CMBGenericDocViewer.this.propertyHandler);
                String newValue = (String)evt.getNewValue();
                CMBGenericDocViewer.this.setToolbarPosition(tbName, newValue);
                CMBGenericDocViewer.this.addPropertyChangeListener(tbName + ".show", CMBGenericDocViewer.this.propertyHandler);
                CMBGenericDocViewer.this.addPropertyChangeListener(tbName + ".position", CMBGenericDocViewer.this.propertyHandler);
            }
        }
    }

    private class RegisteredKeyboardAction {
        Action action;
        KeyStroke keystroke;
        int inputMapID;

        private RegisteredKeyboardAction() {
        }
    }
}

