/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocument;
import java.awt.Dimension;
import java.awt.Image;
import java.io.Serializable;
import java.util.EventObject;

public class CMBGenericDocStateChangedEvent
extends EventObject {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBDocument document;
    private int currentPageNumber = 1;
    private int[] pageNumbers = new int[]{1};
    private int changeType = 0;
    private Serializable relatedInfo;
    private Image[] pageThumbnails;
    private Dimension thumbnailsSize;
    private boolean thumbnailsInverted;
    private boolean thumbnailsEnhanced;
    private int thumbnailsRotation;

    public CMBGenericDocStateChangedEvent(Object source, CMBDocument document, int currentPageNumber) {
        super(source);
        this.document = document;
        this.currentPageNumber = currentPageNumber;
        this.pageNumbers = new int[]{currentPageNumber};
        this.changeType = 0;
    }

    public CMBGenericDocStateChangedEvent(Object source, CMBDocument document, int[] pageNumbers, int changeType) {
        super(source);
        this.document = document;
        this.changeType = changeType;
        this.pageNumbers = pageNumbers;
        this.currentPageNumber = pageNumbers[0];
    }

    CMBGenericDocStateChangedEvent(Object source, CMBDocument document, int[] pageNumbers, int currentPageNumber, int changeType) {
        super(source);
        this.document = document;
        this.changeType = changeType;
        this.pageNumbers = pageNumbers;
        this.currentPageNumber = currentPageNumber;
    }

    public CMBDocument getDocument() {
        return this.document;
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public int[] getPageNumbers() {
        return this.pageNumbers;
    }

    public int getChangeType() {
        return this.changeType;
    }

    public Serializable getRelatedInfo() {
        return this.relatedInfo;
    }

    public void setRelatedInfo(Serializable relatedInfo) {
        this.relatedInfo = relatedInfo;
    }

    Image[] getPageThumbnails() {
        return this.pageThumbnails;
    }

    private void setPageThumbnails(Image[] pageThumbnails) {
        this.pageThumbnails = pageThumbnails;
    }

    void setThumbnailsInfo(Image[] pageThumbnails, Dimension thumbnailsSize, CMBDocument sourceDocument) {
        this.setPageThumbnails(pageThumbnails);
        this.thumbnailsSize = thumbnailsSize;
        this.thumbnailsEnhanced = sourceDocument.getEnhance();
        this.thumbnailsInverted = sourceDocument.getInvert();
        this.thumbnailsRotation = sourceDocument.getRotation();
    }

    Dimension getThumbnailsSize() {
        return this.thumbnailsSize;
    }

    boolean areThumbnailsEnhanced() {
        return this.thumbnailsEnhanced;
    }

    boolean areThumbnailsInverted() {
        return this.thumbnailsInverted;
    }

    int getThumbnailsRotation() {
        return this.thumbnailsRotation;
    }
}

