/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngineCallbacks;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBLetters;
import com.ibm.mm.viewer.CMBViewerConstants;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;

public abstract class CMBDocumentEngine
implements CMBViewerConstants {
    Properties _props = null;
    private static Vector _parsedWorkDirs = null;
    private static int nextDir = 0;

    public abstract void initialize(CMBDocumentEngineCallbacks var1, Properties var2);

    public abstract void terminate();

    public abstract boolean isInitialized();

    public boolean canLoadDocument(String mimeType) {
        return false;
    }

    public Object loadDocument(InputStream partStream, int numberOfParts, String mimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public Object loadDocument(InputStream partStream, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        return this.loadDocument(partStream, numberOfParts, partMimeType, annotationStream, resourceStream);
    }

    public Object loadDocument(InputStream partStream, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
        return this.loadDocument(partStream, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream);
    }

    public Object loadDocument(InputStream partStream, int partStreamSize, int numberOfParts, String mimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        return this.loadDocument(partStream, numberOfParts, mimeType, annotationStream, resourceStream);
    }

    public Object loadDocument(InputStream partStream, int partStreamSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream) throws IOException {
        return this.loadDocument(partStream, partStreamSize, numberOfParts, partMimeType, annotationStream, resourceStream);
    }

    public Object loadDocument(InputStream partStream, int partStreamSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
        return this.loadDocument(partStream, partStreamSize, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream);
    }

    public Object loadDocument(URL partURL, int partSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String partEncoding) throws IOException {
        InputStream partStream = partURL.openStream();
        return this.loadDocument(partStream, partSize, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream, partEncoding);
    }

    public void dropDocument(Object hDocument) {
    }

    public boolean canWriteDocument(String sourceMimeType, String destMimeType) {
        return false;
    }

    public void writeDocument(Object hDocument, String destMimeType, OutputStream output) throws IOException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public void writeDocument(Object document, boolean withAnnotations, String destMimeType, OutputStream output) throws IOException {
        if (withAnnotations) {
            throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
        }
        this.writeDocument(document, destMimeType, output);
    }

    public void writeDocument(Object document, boolean withAnnotations, boolean originalColor, String destMimeType, OutputStream output) throws IOException {
        if (withAnnotations && originalColor) {
            throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
        }
        this.writeDocument(document, withAnnotations, destMimeType, output);
    }

    public void writeDocument(Object document, String destMimetype, OutputStream docStream, OutputStream annotationStream) throws IOException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public void writeDocument(Object document, String destMimetype, OutputStream docStream, String urlPrefix) throws IOException {
        this.writeDocument(document, destMimetype, docStream);
    }

    public void writeDocumentResource(Object document, String resourceId, OutputStream docStream) throws IOException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public String getDocumentResourceMimeType(Object document, String resourceId) throws IOException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean canPaginate(String mimeType) {
        return false;
    }

    public int getNumberOfPages(Object hDocument) throws IOException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public Object loadPage(Object hDocument, int page) throws IOException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public void dropPage(Object hPage) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public double getPageWidth(Object hPage) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean isPageValid(Object hPage) {
        try {
            this.getPageWidth(hPage);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public double getPageHeight(Object hPage) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean canRotate(Object hDocument, String destMimeType) {
        return false;
    }

    public double getPageMinScale(Object hPage, String destMimeType) {
        return 1.0;
    }

    public double getPageMaxScale(Object hPage, String destMimeType) {
        return 1.0;
    }

    public boolean canEnhance(Object hDocument, String destMimeType) {
        return false;
    }

    public boolean canEnhancePage(Object hPage, String destMimeType) {
        return true;
    }

    public boolean canInvert(Object hDocument, String destMimeType) {
        return false;
    }

    public boolean canShowAnnotations(Object hDocument, String destMimeType) {
        return false;
    }

    public boolean canBalancePage(Object hPage) {
        return false;
    }

    public boolean canWritePage(Object hPage, String destMimeType) {
        return false;
    }

    public boolean canWritePage(String sourceMimeType, String destMimeType) {
        return false;
    }

    public String getPageMimeType(Object hPage, String[] preferredMimeTypes) {
        String preference = null;
        for (int i = 0; i < preferredMimeTypes.length; ++i) {
            preference = preferredMimeTypes[i];
            if (!this.canWritePage(hPage, preference)) continue;
            return preference;
        }
        return null;
    }

    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType) throws IOException, CMBDocumentEngineException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness, OutputStream output, String destMimeType) throws IOException, CMBDocumentEngineException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType, String resourcePrefix) throws IOException, CMBDocumentEngineException {
        this.writePage(hPage, rotation, scale, enhance, invert, withAnnotations, output, destMimeType);
    }

    public String getPageResourceMimeType(Object hPage, String resourceId) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public void writePageResource(Object hPage, String resourceId, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output) throws IOException, CMBDocumentEngineException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean canWriteDocumentFromPages(String sourceMimeType, String destMimeType) {
        return false;
    }

    public void writeDocumentFromPages(Object hDocument, int startingPage, int endingPage, String destMimeType, OutputStream output, boolean withAnnotations) throws IOException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean canProvidePageImage(String mimeType) {
        return false;
    }

    public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations) {
        return this.getPageImage(hPage, rotation, scale, enhance, invert, withAnnotations, 100, 100);
    }

    public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean useDrawPage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness) {
        return false;
    }

    public void drawPage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, int contrast, int brightness, Graphics2D graphics) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public int getAnnotationPosition(Object hDocument) {
        return 1390;
    }

    public int getPageXResolution(Object hPage) {
        return 72;
    }

    public int getPageYResolution(Object hPage) {
        return 72;
    }

    public CMBLetters extractText(Object hPage) {
        return null;
    }

    public boolean canManipulatePages(Object hDocument) {
        return false;
    }

    public boolean canDeletePages(Object hDocument, int cnt) {
        return this.canManipulatePages(hDocument);
    }

    public boolean canPastePages(Object hDocument, int cnt) {
        return this.canManipulatePages(hDocument);
    }

    public Object createDocument() {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public void movePages(Object sourceDocument, int firstSourcePage, int lastSourcePage, Object destDocument, int destPage, boolean withAnnotations) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public void copyPages(Object sourceDocument, int firstSourcePage, int lastSourcePage, Object destDocument, int destPage, boolean withAnnotations) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public void deletePages(Object document, int firstPage, int lastPage) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public void rotatePage(Object page, int rotation) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean canCropPage(Object page) {
        return false;
    }

    public void cropPage(Object page, Rectangle cropRect) throws IllegalArgumentException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean canRedactPage(Object page) {
        return false;
    }

    public void redactPage(Object page, Rectangle redactRect) throws IllegalArgumentException {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean canBurnAnnotations(Object document) {
        return false;
    }

    public void burnAnnotations(Object page) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    public boolean canFind(Object hDocument) {
        return false;
    }

    public boolean find(Object hDocument, String text, int[] position, boolean matchCase, boolean reverse) {
        return false;
    }

    boolean canTabulate(String mimeType) {
        return false;
    }

    int getTableRows(Object hDocument) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    int getTableColumns(Object hDocument) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    int getRowsPerPage(Object hDocument) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    String getHeaderText(Object hDocument, int column) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    String getCellText(Object hDocument, int row, int column) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    String[] getRowsText(Object hDocument, int startRow, int endRow) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    int getPreferredColumnWidth(Object hDocument, int column) {
        throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.notSupported"));
    }

    boolean canProvideViewer(String mimeType) {
        return false;
    }

    PSingleDocViewer getViewerComponent(CMBGenericDocViewer gdv, Object hDocument, CMBDocument document, CMBAnnotationSet annotationSet) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized String getWorkDir() {
        if (_parsedWorkDirs == null) {
            String unparsedDirs = this._props.getProperty("WORK_DIR", "c:\\temp\\javaviewer");
            _parsedWorkDirs = new Vector();
            String firstDir = unparsedDirs;
            boolean end = false;
            boolean first = true;
            while (unparsedDirs.length() > 0 && !end) {
                String substring;
                block17: {
                    int pos = unparsedDirs.indexOf(";");
                    if (pos != -1) {
                        substring = unparsedDirs.substring(0, pos).trim();
                        unparsedDirs = unparsedDirs.substring(pos + 1).trim();
                    } else {
                        substring = unparsedDirs.trim();
                        end = true;
                    }
                    int len = substring.length();
                    if (len == 0) {
                        System.err.println("Error in WORK_DIR: empty dir specified");
                        continue;
                    }
                    pos = substring.indexOf("\"");
                    if (pos == 0) {
                        if ((substring = substring.substring(1)).indexOf("\"") == --len - 1) {
                            substring = substring.substring(0, len - 1);
                            --len;
                            break block17;
                        } else {
                            System.err.println("Error in WORK_DIR: " + substring + " :closing quote not at end.");
                            continue;
                        }
                    }
                    if (pos != -1) {
                        System.err.println("Error in WORK_DIR: " + substring + " :No quote at the beginning.");
                        continue;
                    }
                }
                _parsedWorkDirs.addElement(substring);
                if (!first) continue;
                firstDir = substring;
                first = false;
            }
            if (_parsedWorkDirs.size() == 0) {
                _parsedWorkDirs.addElement(firstDir);
            }
            for (int i = 0; i < _parsedWorkDirs.size(); ++i) {
                String dir = (String)_parsedWorkDirs.elementAt(i);
                File dirFile = new File(dir);
                if (!dirFile.exists()) {
                    try {
                        dirFile.mkdirs();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    String[] allFiles = dirFile.list();
                    if (allFiles == null) continue;
                    int size = allFiles.length;
                    for (int j = 0; j < size; ++j) {
                        File toDelete = new File(dir + File.separator + allFiles[j]);
                        toDelete.delete();
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        String dir = (String)_parsedWorkDirs.elementAt(nextDir);
        nextDir = (nextDir + 1) % _parsedWorkDirs.size();
        return dir;
    }
}

