/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBMultiPageNotSupportedException;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.CMBStreamingDocServices;
import com.ibm.mm.viewer.CMBViewerConstants;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.PrintJob;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Pattern;
import javax.swing.JPanel;

public class CMBDocument
implements CMBViewerConstants,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private Hashtable _pages = new Hashtable();
    private double _scale = 1.0;
    private int _rotation;
    private boolean _enhance;
    private boolean _invert;
    private boolean _withAnnotations;
    private String _mimeType;
    private boolean _canEnhance;
    private boolean _canEnhanceDetermined;
    private int _resolution = 96;
    private CMBStreamingDocServices _services;
    private CMBDocumentEngine _engine;
    private Object _hDocument;
    private Object _partContent;
    private boolean _partStreamRead = false;
    private boolean _documentDisposed = false;
    Object documentDropping = new Object();
    private boolean _isNew = false;
    private boolean _isModified = false;
    private boolean _isOCRValid = false;
    private boolean _isTextValid = false;
    private String _resourcePrefix = null;

    CMBDocument(CMBStreamingDocServices services, CMBDocumentEngine engine, Object hDocument, String mimeType) {
        this._services = services;
        this._engine = engine;
        this._hDocument = hDocument;
        this._mimeType = mimeType;
    }

    CMBDocument(CMBStreamingDocServices services, Object partContent, String mimeType) {
        this._services = services;
        this._partContent = partContent;
        this._mimeType = mimeType;
    }

    public boolean isNew() {
        this._validateDocument();
        return this._isNew;
    }

    public void setNew(boolean isNew) {
        this._validateDocument();
        this._isNew = isNew;
    }

    public boolean isModified() {
        this._validateDocument();
        return this._isModified;
    }

    public void setModified(boolean isModified) {
        this._validateDocument();
        this._isModified = isModified;
    }

    boolean isOCRValid() {
        this._validateDocument();
        return this._isOCRValid;
    }

    void setOCRValid(boolean isValid) {
        this._validateDocument();
        this._isOCRValid = isValid;
    }

    boolean isTextValid() {
        this._validateDocument();
        return this._isTextValid;
    }

    void setTextValid(boolean isValid) {
        this._validateDocument();
        this._isTextValid = isValid;
    }

    public String getMimeType() {
        this._validateDocument();
        return this._mimeType;
    }

    public boolean getCanPaginate() {
        this._validateDocument();
        if (this._engine == null) {
            return false;
        }
        String conversion = (String)this._services.getConversionProperties().get(this._mimeType);
        if (conversion != null && conversion.equals("document")) {
            if (this._services.traceEnabled()) {
                this._services.trace("Conversion is set to :" + conversion);
            }
            return false;
        }
        this._services.setLastDocument(this);
        return this._engine.canPaginate(this._mimeType);
    }

    public boolean getCanManipulatePages() {
        this._validateDocument();
        if (this._engine == null) {
            return false;
        }
        this._services.setLastDocument(this);
        return this._engine.canManipulatePages(this.getDocumentHandle());
    }

    boolean getCanPastePages(int cnt) {
        this._validateDocument();
        if (this._engine == null) {
            return false;
        }
        this._services.setLastDocument(this);
        return this._engine.canPastePages(this.getDocumentHandle(), cnt);
    }

    boolean getCanDeletePages(int cnt) {
        this._validateDocument();
        if (this._engine == null) {
            return false;
        }
        this._services.setLastDocument(this);
        return this._engine.canDeletePages(this.getDocumentHandle(), cnt);
    }

    public int getPageCount() throws IOException {
        String methodName = "getPageCount";
        if (!this.getCanPaginate()) {
            throw new RuntimeException(PViewerUtilities.getMessage("Document.cannotPaginate"));
        }
        this._services.setLastDocument(this);
        int pageCount = 0;
        try {
            pageCount = this._engine.getNumberOfPages(this.getDocumentHandle());
        }
        catch (CMBDocumentEngineException e) {
            ViewerLogger.logError((Object)this, "getPageCount", e);
        }
        if (this._services.traceEnabled()) {
            this._services.trace("Document page count:" + pageCount);
        }
        return pageCount;
    }

    int _getPageCount() throws IOException, CMBDocumentEngineException {
        if (!this.getCanPaginate()) {
            throw new RuntimeException(PViewerUtilities.getMessage("Document.cannotPaginate"));
        }
        this._services.setLastDocument(this);
        int pageCount = this._engine.getNumberOfPages(this.getDocumentHandle());
        if (this._services.traceEnabled()) {
            this._services.trace("Document page count:" + pageCount);
        }
        return pageCount;
    }

    public CMBPage[] getPages() throws IOException {
        if (!this.getCanPaginate()) {
            throw new RuntimeException(PViewerUtilities.getMessage("Document.cannotPaginate"));
        }
        int nPages = this.getPageCount();
        CMBPage[] retval = new CMBPage[nPages];
        CMBPage curPage = null;
        for (int i = 1; i <= nPages; ++i) {
            curPage = (CMBPage)this._pages.get("" + i);
            if (curPage == null) {
                curPage = new CMBPage(this._services, this._engine, this, i);
                this._pages.put("" + i, curPage);
            }
            retval[i - 1] = curPage;
        }
        return retval;
    }

    public CMBPage getPages(int index) throws ArrayIndexOutOfBoundsException, IOException {
        return this.getPage(index + 1);
    }

    public CMBPage getPage(int pageNumber) throws IndexOutOfBoundsException, IOException {
        if (!this.getCanPaginate()) {
            throw new RuntimeException(PViewerUtilities.getMessage("Document.cannotPaginate"));
        }
        if (pageNumber <= 0) {
            throw new IndexOutOfBoundsException(PViewerUtilities.getMessage("Document.pageLessThanOne"));
        }
        CMBPage the_page = (CMBPage)this._pages.get("" + pageNumber);
        if (the_page == null) {
            the_page = new CMBPage(this._services, this._engine, this, pageNumber);
            this._pages.put("" + pageNumber, the_page);
        }
        return the_page;
    }

    public double getPreferredScale() {
        this._validateDocument();
        return this._scale;
    }

    public void setPreferredScale(double scale) {
        this._validateDocument();
        this._scale = scale;
    }

    public boolean getCanRotate() {
        if (!this.getCanPaginate()) {
            return false;
        }
        this._services.setLastDocument(this);
        return this._engine.canRotate(this.getDocumentHandle(), this.getPageWriteMimeType());
    }

    public int getRotation() {
        this._validateDocument();
        return this._rotation;
    }

    public void setRotation(int rotation) {
        this._validateDocument();
        if (rotation == this._rotation) {
            return;
        }
        if (rotation < 0 || rotation > 3) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("Document.invalidRotation"));
        }
        if (!this.getCanRotate()) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("Document.cannotBeRotated"));
        }
        this._rotation = rotation;
    }

    public boolean getCanEnhance() {
        if (!this.getCanPaginate()) {
            return false;
        }
        if (!this._canEnhanceDetermined) {
            this._services.setLastDocument(this);
            this._canEnhance = this._engine.canEnhance(this.getDocumentHandle(), this.getPageWriteMimeType());
            this._canEnhanceDetermined = true;
        }
        return this._canEnhance;
    }

    public boolean getEnhance() {
        this._validateDocument();
        return this._enhance;
    }

    public void setEnhance(boolean enhance) {
        this._validateDocument();
        if (enhance == this._enhance) {
            return;
        }
        if (!this.getCanEnhance()) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("Document.cannotBeEnhanced"));
        }
        this._enhance = enhance;
    }

    public boolean getCanInvert() {
        if (!this.getCanPaginate()) {
            return false;
        }
        this._services.setLastDocument(this);
        return this._engine.canInvert(this.getDocumentHandle(), this.getPageWriteMimeType());
    }

    public boolean getInvert() {
        this._validateDocument();
        return this._invert;
    }

    public void setInvert(boolean invert) {
        this._validateDocument();
        if (invert == this._invert) {
            return;
        }
        if (!this.getCanInvert()) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("Document.cannotBeInverted"));
        }
        this._invert = invert;
    }

    public boolean getCanShowAnnotations() {
        if (!this.getCanPaginate()) {
            return false;
        }
        this._services.setLastDocument(this);
        return this._engine.canShowAnnotations(this.getDocumentHandle(), this.getPageWriteMimeType());
    }

    public boolean getShowAnnotations() {
        this._validateDocument();
        return this._withAnnotations;
    }

    public void setShowAnnotations(boolean withAnnotations) {
        this._validateDocument();
        if (withAnnotations == this._withAnnotations) {
            return;
        }
        if (!this.getCanShowAnnotations()) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("Document.cannotShowAnnotations"));
        }
        this._withAnnotations = withAnnotations;
    }

    public boolean getCanPrint() {
        this._services.setLastDocument(this);
        return this.getCanPaginate() && this._engine.canProvidePageImage(this._mimeType) && this._services.getServiceCallbacks().getPrintPrivilege(this);
    }

    public String getWriteMimeType() {
        this._validateDocument();
        if (this._engine == null) {
            return this._mimeType;
        }
        String[] preferences = this._services.getPreferredFormats();
        for (int i = 0; i < preferences.length; ++i) {
            String preference = preferences[i];
            this._services.setLastDocument(this);
            if (!this._engine.canWriteDocument(this._mimeType, preference)) continue;
            if (this._services.traceEnabled()) {
                this._services.trace("Engine canWriteDocument from " + this._mimeType + " to " + preference);
            }
            return preference;
        }
        if (this._engine.canWriteDocument(this._mimeType, this._mimeType)) {
            if (this._services.traceEnabled()) {
                this._services.trace("Engine canWriteDocument into the original format :" + this._mimeType);
            }
            return this._mimeType;
        }
        return null;
    }

    public int getAnnotationPosition() {
        if (this._engine == null) {
            return 0;
        }
        this._services.setLastDocument(this);
        int annotationPosition = this._engine.getAnnotationPosition(this.getDocumentHandle());
        if (this._services.traceEnabled()) {
            this._services.trace("getAnnotationPosition = " + annotationPosition);
        }
        return annotationPosition;
    }

    public int getDisplayResolution() {
        this._validateDocument();
        return this._resolution;
    }

    public void setDisplayResolution(int resolution) {
        this._validateDocument();
        this._resolution = resolution;
    }

    public void deletePages(int startPage, int endPage) throws IndexOutOfBoundsException, IOException, IllegalArgumentException {
        this._validateDocument();
        this._validatePageManipulation();
        if (startPage < 1 || startPage > this.getPageCount()) {
            throw new IndexOutOfBoundsException(PViewerUtilities.getMessage("DocumentServices.firstSourcePageInvalid"));
        }
        if (endPage < 1 || endPage > this.getPageCount()) {
            throw new IndexOutOfBoundsException(PViewerUtilities.getMessage("DocumentServices.lastSourcePageInvalid"));
        }
        if (startPage > endPage) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentServices.lastSourcePageLessThanFirstSourcePage"));
        }
        int originalPageCount = this.getPageCount();
        for (int i = startPage; i <= endPage; ++i) {
            this.pageToBeRemoved(i);
        }
        this._engine.deletePages(this.getDocumentHandle(), startPage, endPage);
        int nPagesDeleted = endPage - startPage + 1;
        for (int i = endPage + 1; i <= originalPageCount; ++i) {
            this.pageMoved(i, i - nPagesDeleted);
        }
        this.setModified(true);
    }

    public void movePages(int startPage, int endPage, int destPage) throws IndexOutOfBoundsException, IllegalArgumentException, IOException {
        this._validateDocument();
        this._validatePageManipulation();
        if (startPage < 1 || startPage > this.getPageCount()) {
            throw new IndexOutOfBoundsException(PViewerUtilities.getMessage("DocumentServices.firstSourcePageInvalid"));
        }
        if (endPage < 1 || endPage > this.getPageCount()) {
            throw new IndexOutOfBoundsException(PViewerUtilities.getMessage("DocumentServices.lastSourcePageInvalid"));
        }
        if (destPage < 0 || destPage > this.getPageCount()) {
            throw new IndexOutOfBoundsException(PViewerUtilities.getMessage("DocumentServices.destPageInvalid"));
        }
        if (startPage > endPage) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentServices.lastSourcePageLessThanFirstSourcePage"));
        }
        if (destPage >= startPage && destPage <= endPage) {
            throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentServices.destPageWithinSourcePages"));
        }
        this._engine.movePages(this.getDocumentHandle(), startPage, endPage, this.getDocumentHandle(), destPage + 1, true);
        int nPagesMoved = endPage - startPage + 1;
        if (destPage < startPage) {
            int i;
            int nPagesShifted = startPage - destPage - 1;
            for (i = startPage - 1; i >= destPage; --i) {
                this.pageMoved(i, i + nPagesMoved);
            }
            for (i = startPage; i <= endPage; ++i) {
                this.pageMoved(i, i - nPagesShifted);
            }
        } else {
            int i;
            int nPagesShifted = destPage - endPage;
            for (i = startPage; i <= endPage; ++i) {
                this.pageMoved(i, i + nPagesShifted);
            }
            for (i = destPage - 1; i > endPage; --i) {
                this.pageMoved(i, i - nPagesMoved);
            }
        }
        this.setModified(true);
    }

    public synchronized void print(PrintJob printJob, boolean withAnnotations) throws CMBDocumentEngineException, IOException {
        if (!this.getCanPrint()) {
            throw new RuntimeException(PViewerUtilities.getMessage("Document.cannotBePrinted"));
        }
        double oldPreferredScale = this.getPreferredScale();
        int oldRotation = this.getRotation();
        boolean oldShowAnnotations = this.getShowAnnotations();
        boolean oldEnhance = this.getEnhance();
        boolean oldInvert = this.getInvert();
        this.setPreferredScale(1.0);
        this.setRotation(0);
        this.setShowAnnotations(withAnnotations);
        this.setEnhance(false);
        this.setInvert(false);
        int pageCount = this.getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            CMBPage page = this.getPages(i);
            Image pageImage = page.getImage();
            int pageResolution = printJob.getPageResolution();
            Graphics g = printJob.getGraphics();
            g.drawImage(pageImage, 0, 0, null);
            g.dispose();
        }
        this.setPreferredScale(oldPreferredScale);
        this.setRotation(oldRotation);
        this.setShowAnnotations(oldShowAnnotations);
        this.setEnhance(oldEnhance);
        this.setInvert(oldInvert);
    }

    public void print(PrinterJob printerJob, PageFormat pageFormat, boolean withAnnotations, int[] pagesToPrint) throws CMBDocumentEngineException, IOException, IllegalArgumentException, PrinterException {
        if (this._services.traceEnabled()) {
            this._services.trace("print: Entry");
        }
        if (!this.getCanPrint() || !this.getCanPaginate()) {
            if (this._services.traceEnabled()) {
                this._services.trace("print: throwing unprintable exception");
            }
            throw new RuntimeException(PViewerUtilities.getMessage("Document.cannotBePrinted"));
        }
        double oldPreferredScale = this.getPreferredScale();
        int oldRotation = this.getRotation();
        boolean oldShowAnnotations = this.getShowAnnotations();
        boolean oldEnhance = this.getEnhance();
        boolean oldInvert = this.getInvert();
        this.setPreferredScale(1.0);
        this.setRotation(0);
        this.setShowAnnotations(withAnnotations);
        this.setEnhance(false);
        this.setInvert(false);
        int[] _printablePages = null;
        if (pagesToPrint != null) {
            int i;
            if (this._services.traceEnabled()) {
                this._services.trace("print: set pages");
            }
            Arrays.sort(pagesToPrint);
            int numPageNumbers = pagesToPrint.length;
            if (pagesToPrint[0] < 1 || pagesToPrint[numPageNumbers - 1] > this.getPageCount()) {
                throw new IllegalArgumentException();
            }
            ArrayList<Integer> pageNumbers = new ArrayList<Integer>();
            for (i = 0; i < numPageNumbers - 1; ++i) {
                if (pagesToPrint[i] == pagesToPrint[i + 1]) continue;
                pageNumbers.add(new Integer(pagesToPrint[i]));
            }
            pageNumbers.add(new Integer(pagesToPrint[numPageNumbers - 1]));
            _printablePages = new int[pageNumbers.size()];
            for (i = 0; i < pageNumbers.size(); ++i) {
                _printablePages[i] = (Integer)pageNumbers.get(i);
            }
        } else {
            if (this._services.traceEnabled()) {
                this._services.trace("print: print all pages");
            }
            _printablePages = null;
        }
        if (this._services.traceEnabled()) {
            this._services.trace("print: PrintablePageable");
        }
        PrintablePageableImpl _printablePageable = new PrintablePageableImpl();
        _printablePageable.setPageFormat(pageFormat);
        _printablePageable.setPrintablePages(_printablePages);
        printerJob.setPageable(_printablePageable);
        if (this._services.traceEnabled()) {
            this._services.trace("print: printJob.print");
        }
        printerJob.print();
        if (this._services.traceEnabled()) {
            this._services.trace("print: dispose");
        }
        _printablePageable.dispose();
        this.setPreferredScale(oldPreferredScale);
        this.setRotation(oldRotation);
        this.setShowAnnotations(oldShowAnnotations);
        this.setEnhance(oldEnhance);
        this.setInvert(oldInvert);
        if (this._services.traceEnabled()) {
            this._services.trace("print: exit");
        }
    }

    public boolean getCanWrite() {
        this._validateDocument();
        return this.getWriteMimeType() != null;
    }

    public void write(OutputStream outStream) throws CMBDocumentEngineException, IOException {
        this._write(false, false, outStream, null, null, null);
    }

    public void write(OutputStream outStream, String resourcePrefix) throws CMBDocumentEngineException, IOException {
        this._write(false, false, outStream, null, null, resourcePrefix);
    }

    public void write(boolean withAnnotations, OutputStream outStream) throws CMBDocumentEngineException, IOException {
        this._write(withAnnotations, false, outStream, null, null, null);
    }

    public void write(boolean withAnnotations, boolean originalColorPalette, OutputStream outStream, String writeMimeType) throws CMBDocumentEngineException, IOException {
        this._write(withAnnotations, originalColorPalette, outStream, null, writeMimeType, null);
    }

    public void write(OutputStream outStream, OutputStream annoStream) throws CMBDocumentEngineException, IOException {
        this._write(false, false, outStream, annoStream, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _write(boolean burnAnnotations, boolean originalColorPalette, OutputStream outStream, OutputStream annoStream, String writeMimeType, String resourcePrefix) throws CMBDocumentEngineException, IOException {
        Object object = this.documentDropping;
        synchronized (object) {
            this._validateDocument();
            if (this._engine == null) {
                if (this._services.traceEnabled()) {
                    this._services.trace("Engine is null, writing out the first part document data... ");
                }
                if (this._partStreamRead) {
                    this._partContent = this._services.getServiceCallbacks().getPart(this, 0, null);
                } else {
                    this._partStreamRead = true;
                }
                if (this._partContent == null) {
                    if (this._services.traceEnabled()) {
                        this._services.trace("_partStream is null");
                    }
                    throw new CMBDocumentEngineException(PViewerUtilities.getMessage("Document.nullPartStream"));
                }
                InputStream partStream = this._partContent instanceof URL ? ((URL)this._partContent).openStream() : (InputStream)this._partContent;
                byte[] bytebuf = new byte[Short.MAX_VALUE];
                int bytesRead = 0;
                while (bytesRead >= 0) {
                    bytesRead = partStream.read(bytebuf);
                    if (bytesRead < 0) continue;
                    outStream.write(bytebuf, 0, bytesRead);
                }
            } else {
                String mimeType = null;
                mimeType = writeMimeType != null ? writeMimeType : this.getWriteMimeType();
                if (this._services.traceEnabled()) {
                    this._services.trace("Engine's writeDocument called for writing document in " + mimeType + " format.");
                }
                if (mimeType == null) {
                    throw new RuntimeException(PViewerUtilities.getMessage("Document.cannotBeWritten"));
                }
                try {
                    this._services.setLastDocument(this);
                    if (burnAnnotations) {
                        this._engine.writeDocument(this.getDocumentHandle(), true, originalColorPalette, mimeType, outStream);
                    }
                    if (annoStream != null) {
                        this._engine.writeDocument(this.getDocumentHandle(), mimeType, outStream, annoStream);
                    }
                    if (resourcePrefix != null) {
                        this._engine.writeDocument(this.getDocumentHandle(), mimeType, outStream, resourcePrefix);
                    }
                    this._engine.writeDocument(this.getDocumentHandle(), mimeType, outStream);
                }
                catch (CMBMultiPageNotSupportedException e) {
                    throw new CMBMultiPageNotSupportedException(PViewerUtilities.getMessage("Document.cannotBeWrittenMultiPage", new String[]{mimeType}), (Object)e);
                }
            }
        }
    }

    public String getResourceMimeType(String resourceId) throws IOException {
        this._validateDocument();
        this._services.setLastDocument(this);
        return this._engine.getDocumentResourceMimeType(this.getDocumentHandle(), resourceId);
    }

    public void writeResource(OutputStream outStream, String resourceId) throws CMBDocumentEngineException, IOException {
        this._validateDocument();
        this._services.setLastDocument(this);
        this._engine.writeDocumentResource(this.getDocumentHandle(), resourceId, outStream);
    }

    public boolean getCanFind() {
        return this._engine.canFind(this.getDocumentHandle());
    }

    int getMatchCount(Pattern pattern) {
        int matchCount = 0;
        try {
            for (int i = 1; i <= this.getPageCount(); ++i) {
                CMBPage page = this.getPage(i);
                if (page.matchResults == null || page.matchResults.size() <= 0 || page.findPattern == null || !page.findPattern.pattern().equals(pattern.pattern()) || page.findPattern.flags() != pattern.flags()) continue;
                matchCount += this.getPage((int)i).matchResults.size();
            }
        }
        catch (Exception e) {
            matchCount = 0;
        }
        return matchCount;
    }

    void clearFind() {
        try {
            for (int i = 1; i <= this.getPageCount(); ++i) {
                CMBPage page = this.getPage(i);
                page.clearFind();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean find(String text, int[] position, boolean matchCase, boolean reverse) {
        return this._engine.find(this.getDocumentHandle(), text, position, matchCase, reverse);
    }

    boolean getCanProvideViewer() {
        return this._engine.canProvideViewer(this.getMimeType());
    }

    PSingleDocViewer getViewerComponent(CMBGenericDocViewer gdv, CMBAnnotationSet annotationSet) {
        return this._engine.getViewerComponent(gdv, this.getDocumentHandle(), this, annotationSet);
    }

    void pageMoved(int oldPageNumber, int newPageNumber) {
        CMBPage page = (CMBPage)this._pages.get("" + oldPageNumber);
        if (page != null) {
            this._pages.remove("" + oldPageNumber);
            page.setPageNumber(newPageNumber);
            this._pages.put("" + newPageNumber, page);
        }
    }

    CMBPage pageToBeRemoved(int pageNumber) {
        CMBPage page = (CMBPage)this._pages.get("" + pageNumber);
        if (page != null) {
            this._pages.remove("" + pageNumber);
            page.setDocument(null);
        }
        return page;
    }

    void pageAdded(CMBPage page, int pageNumber) {
        if (page != null) {
            page.setPageNumber(pageNumber);
            page.setDocument(this);
            this._pages.put("" + pageNumber, page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDisposed() {
        Object object = this.documentDropping;
        synchronized (object) {
            return this._documentDisposed;
        }
    }

    CMBDocumentEngine getEngine() {
        this._validateDocument();
        return this._engine;
    }

    Object getDocumentHandle() {
        this._validateDocument();
        return this._hDocument;
    }

    String getPageWriteMimeType() {
        this._validateDocument();
        if (this._engine == null) {
            return null;
        }
        String[] preferences = this._services.getPreferredPageFormats();
        for (int i = 0; i < preferences.length; ++i) {
            String preference = preferences[i];
            this._services.setLastDocument(this);
            if (!this._engine.canWritePage(this._mimeType, preference)) continue;
            return preference;
        }
        return null;
    }

    void dropStream() throws IOException {
        if (this._partContent != null && this._partContent instanceof InputStream) {
            ((InputStream)this._partContent).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Object object = this.documentDropping;
        synchronized (object) {
            if (this._documentDisposed) {
                return;
            }
            if (this._hDocument != null) {
                Enumeration e = this._pages.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    CMBPage p = (CMBPage)this._pages.get(key);
                    this._pages.remove(key);
                    p.dispose();
                }
                this._documentDisposed = true;
                this._services.setLastDocument(this);
                if (this._engine != null) {
                    this._engine.dropDocument(this._hDocument);
                }
                this._hDocument = null;
            }
        }
    }

    void _validateDocument() {
        if (this._documentDisposed) {
            throw new RuntimeException(PViewerUtilities.getMessage("Document.usedAfterDropped"));
        }
    }

    void _validatePageManipulation() {
        if (!this.getCanManipulatePages()) {
            throw new UnsupportedOperationException(PViewerUtilities.getMessage("Document.pageManipulationNotSupported"));
        }
    }

    private class PrintablePageableImpl
    implements Printable,
    Pageable {
        private int[] _printablePages = null;
        private int cachedPrintPageNumber = -1;
        private Image cachedPrintPageImage = null;
        private PageFormat _pageFormat = null;

        private PrintablePageableImpl() {
        }

        public void setPrintablePages(int[] printablePages) {
            this._printablePages = printablePages;
        }

        public int print(Graphics g, PageFormat format, int pageIndex) {
            String methodName = "print";
            try {
                int pageNumber = pageIndex + 1;
                if (this._printablePages != null) {
                    pageNumber = this._printablePages[pageIndex];
                }
                if (pageNumber > CMBDocument.this.getPageCount()) {
                    return 1;
                }
                JPanel jp = new JPanel();
                if (this.cachedPrintPageNumber != pageNumber) {
                    CMBPage page = null;
                    page = CMBDocument.this.getPage(pageNumber);
                    if (page != null && page.getCanGetImage()) {
                        if (this.cachedPrintPageImage != null) {
                            this.cachedPrintPageImage.flush();
                            this.cachedPrintPageImage = null;
                        }
                        this.cachedPrintPageImage = page.getImage(1.0);
                        try {
                            MediaTracker tracker = new MediaTracker(jp);
                            tracker.addImage(this.cachedPrintPageImage, 0);
                            tracker.waitForID(0);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (this.cachedPrintPageImage == null) {
                        return 1;
                    }
                    this.cachedPrintPageNumber = pageNumber;
                }
                double pageHeight = this.cachedPrintPageImage.getHeight(jp);
                double pageWidth = this.cachedPrintPageImage.getWidth(jp);
                double paperWidth = format.getImageableWidth();
                double paperHeight = format.getImageableHeight();
                double widthScale = paperWidth / pageWidth;
                double heightScale = paperHeight / pageHeight;
                double printScale = Math.min(widthScale, heightScale);
                Graphics2D g2d = (Graphics2D)g;
                g2d.translate(format.getImageableX(), format.getImageableY());
                g2d.scale(printScale, printScale);
                g2d.drawImage(this.cachedPrintPageImage, 0, 0, null);
                return 0;
            }
            catch (Exception e) {
                ViewerLogger.logError((Object)this, methodName, e);
                return 1;
            }
        }

        public void setPageFormat(PageFormat pageFormat) {
            this._pageFormat = pageFormat;
        }

        public int getNumberOfPages() {
            if (CMBDocument.this.getCanPaginate()) {
                try {
                    if (this._printablePages == null) {
                        return CMBDocument.this.getPageCount();
                    }
                    return this._printablePages.length;
                }
                catch (IOException ioe) {
                    return 1;
                }
            }
            return 1;
        }

        public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
            if (this._pageFormat == null) {
                PrinterJob printerjob = PrinterJob.getPrinterJob();
                this._pageFormat = printerjob.defaultPage();
            }
            return this._pageFormat;
        }

        public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
            return this;
        }

        void dispose() {
            if (this.cachedPrintPageImage != null) {
                this.cachedPrintPageImage.flush();
                this.cachedPrintPageImage = null;
            }
            this.cachedPrintPageNumber = -1;
        }
    }
}

