/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.PViewerUtilities;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CMBDocWriterServlet
extends HttpServlet {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String methodName = "processRequest";
        ServletOutputStream outStream = null;
        try {
            CMBDocument document = (CMBDocument)request.getAttribute("cmbDocument");
            if (document == null) {
                throw new Exception(PViewerUtilities.getMessage("WriterServlets.noCMBDocument"));
            }
            String mimeType = document.getWriteMimeType();
            response.setContentType(mimeType);
            response.setHeader("Content-Disposition", "inline; filename=document.html");
            outStream = response.getOutputStream();
            document.write((OutputStream)outStream);
            outStream.close();
        }
        catch (Throwable e) {
            ViewerLogger.logError((Object)this, methodName, e);
            if (outStream == null) {
                outStream = response.getOutputStream();
            }
            response.setContentType("text/plain");
            response.setHeader("Content-Disposition", "inline; filename=message.txt");
            PrintStream ps = new PrintStream((OutputStream)outStream);
            outStream.write((PViewerUtilities.getMessage("WriterServlets.errorOccured") + "\r\n").getBytes());
            e.printStackTrace(ps);
            ps.close();
        }
    }
}

