/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineCallbacks;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBViewerException;
import com.ibm.mm.viewer.PAFPWorkbenchJNI;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationServicesCallbacks;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class CMBAFPWorkbenchEngine
extends CMBDocumentEngine {
    private CMBDocumentEngineCallbacks callbacks;
    private Properties properties;
    private boolean initialized;
    private CMBAnnotationServices annotationServices;
    private PAFPWorkbenchJNI workbenchJNI;
    private int hvs;
    private Object numberOfPagesLock = new Object();

    public void initialize(CMBDocumentEngineCallbacks callbacks, Properties properties) {
        this.callbacks = callbacks;
        this.properties = properties;
        this.trace(null, null, "Initialize started.");
        this.annotationServices = new CMBAnnotationServices(new AnnotationServicesCallbacks());
        this.trace(null, null, "  Created instance of annotation services.");
        this.initialized = true;
        this.trace(null, null, "Initialize completed");
    }

    public void terminate() {
        this.trace(null, null, "terminate started");
        this.hvs = 0;
        this.initialized = false;
        this.trace(null, null, "terminate completed");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean canLoadDocument(String mimeType) {
        return mimeType.equals("application/afp");
    }

    public Object loadDocument(InputStream partStream, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
        return this.loadDocument(partStream, -1, numberOfParts, partMimeType, docMimeType, annotationStream, resourceStream, firstPartEncoding);
    }

    public Object loadDocument(InputStream partStream, int partStreamSize, int numberOfParts, String partMimeType, String docMimeType, InputStream annotationStream, InputStream resourceStream, String firstPartEncoding) throws IOException {
        if (this.hvs == 0) {
            this.callbacks.deployNativeLibrary("afpworkbench.jar");
            this.workbenchJNI = new PAFPWorkbenchJNI(this);
            this.workbenchJNI.initialize();
            this.trace(null, null, "  Initialized JNI.");
            this.hvs = this.workbenchJNI.getViewServ(null);
            this.workbenchJNI.vsInit(this.hvs, "", "");
            this.workbenchJNI.vsSetAppScrolling(this.hvs, true);
            this.trace(null, null, "  Initialized AFP Workbench.");
        }
        WorkbenchDocument document = new WorkbenchDocument();
        this.trace(document, null, "loadDocument invoked");
        document.parts = new WorkbenchPart[numberOfParts];
        document.mimeType = docMimeType;
        this.loadPart(document, 0, partStream, partStreamSize);
        if (annotationStream != null) {
            try {
                document.annotationSet = this.annotationServices.loadAnnotationSet(annotationStream, "od", 0, 1, 1);
                this.trace(document, null, "loadDocument: annotations loaded");
            }
            catch (Exception e) {
                throw new CMBDocumentEngineException("Exception creating annotation set", (Object)e);
            }
        }
        this.trace(document, null, "loadDocument completed");
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPart(WorkbenchDocument document, int partNumber, InputStream contentStream, int contentLength) {
        WorkbenchPart[] workbenchPartArray = document.parts;
        synchronized (document.parts) {
            if (document.parts[partNumber] != null) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            WorkbenchPart part = new WorkbenchPart();
            part.document = document;
            try {
                String tempfileprefix = Long.toString(System.currentTimeMillis());
                part.tempFile = File.createTempFile(tempfileprefix, null);
                BufferedInputStream instream = new BufferedInputStream(contentStream);
                BufferedOutputStream outstream = new BufferedOutputStream(new FileOutputStream(part.tempFile));
                int c = 0;
                while (c != -1) {
                    int len = instream.available();
                    byte[] bytes = new byte[len];
                    instream.read(bytes);
                    outstream.write(bytes);
                    c = instream.read();
                    if (c == -1) continue;
                    outstream.write(c);
                }
                instream.close();
                outstream.close();
                this.trace(document, null, "loadDocument: part copied to temp file");
            }
            catch (IOException e) {
                throw new CMBDocumentEngineException("Exception reading part content", (Object)e);
            }
            try {
                part.hvsDoc = this.workbenchJNI.vsDocStart(this.hvs, part.tempFile.getCanonicalPath(), "", "", null);
                this.trace(document, null, "loadDocument: file loaded into AFP workbench");
                if (part.hvsDoc <= 0) {
                    throw new CMBDocumentEngineException("Error loading part: rc=" + part.hvsDoc);
                }
                this.workbenchJNI.vsSetPageSize(part.hvsDoc, (short)6120, (short)7920);
            }
            catch (IOException e) {
                throw new CMBDocumentEngineException("Exception reading part content", (Object)e);
            }
            part.firstPageNumber = partNumber == 0 ? 1 : document.parts[partNumber - 1].firstPageNumber + document.parts[partNumber - 1].getPageCount();
            document.parts[partNumber] = part;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void dropDocument(Object hDocument) {
        WorkbenchDocument document = (WorkbenchDocument)hDocument;
        this.trace(document, null, "dropDocument called");
        for (int i = 0; i < document.parts.length; ++i) {
            WorkbenchPart part = document.parts[i];
            if (part == null) continue;
            this.workbenchJNI.vsDocEnd(this.hvs, part.hvsDoc);
            if (part.tempFile != null) {
                part.tempFile.delete();
            }
            part.isDropped = true;
        }
        this.trace(document, null, "dropDocument completed");
    }

    public boolean canPaginate(String mimeType) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPages(Object hDocument) throws IOException {
        WorkbenchDocument document = (WorkbenchDocument)hDocument;
        if (document.pageCount != 0) {
            return document.pageCount;
        }
        Object object = this.numberOfPagesLock;
        synchronized (object) {
            int totalPages = 0;
            for (int i = 0; i < document.parts.length; ++i) {
                WorkbenchPart part = document.parts[i];
                if (part == null) {
                    this.loadPart(document, i, this.callbacks.getPart(document, i, new StringBuffer()), this.callbacks.getPartSize(document, i));
                    part = document.parts[i];
                }
                totalPages += part.getPageCount();
            }
            document.pageCount = totalPages;
        }
        return document.pageCount;
    }

    private WorkbenchPart getPartForPage(WorkbenchDocument document, int pageNumber) {
        int totalPages = 0;
        for (int i = 0; i < document.parts.length; ++i) {
            WorkbenchPart part = document.parts[i];
            if (part == null) {
                this.loadPart(document, i, this.callbacks.getPart(document, i, new StringBuffer()), this.callbacks.getPartSize(document, i));
                part = document.parts[i];
            }
            if (part.containsPage(pageNumber - totalPages - 1)) {
                return part;
            }
            totalPages += part.getPageCount();
        }
        return null;
    }

    public Object loadPage(Object hDocument, int pageNumber) throws IOException {
        WorkbenchDocument document = (WorkbenchDocument)hDocument;
        this.trace(document, null, "loadPage started, page " + pageNumber);
        WorkbenchPart part = this.getPartForPage(document, pageNumber);
        if (part == null) {
            throw new CMBViewerException("Invalid page: " + pageNumber);
        }
        WorkbenchPage page = new WorkbenchPage();
        page.part = part;
        page.documentPageNumber = pageNumber;
        page.partPageNumber = pageNumber - part.firstPageNumber + 1;
        this.trace(document, page, "loadPage completed");
        return page;
    }

    public void dropPage(Object hPage) {
    }

    public boolean canInvert(Object hDocument, String destMimeType) {
        WorkbenchDocument document = (WorkbenchDocument)hDocument;
        return true;
    }

    public boolean canEnhance(Object hDocument, String destMimeType) {
        WorkbenchDocument document = (WorkbenchDocument)hDocument;
        return true;
    }

    public boolean canProvidePageImage(String arg0) {
        return true;
    }

    public boolean canRotate(Object hDocument, String destMimetype) {
        WorkbenchDocument document = (WorkbenchDocument)hDocument;
        return true;
    }

    public double getPageWidth(Object hPage) {
        WorkbenchPage page = (WorkbenchPage)hPage;
        return 8.5;
    }

    public double getPageHeight(Object hPage) {
        WorkbenchPage page = (WorkbenchPage)hPage;
        return 11.0;
    }

    public int getPageXResolution(Object hPage) {
        WorkbenchPage page = (WorkbenchPage)hPage;
        return 96;
    }

    public int getPageYResolution(Object hPage) {
        WorkbenchPage page = (WorkbenchPage)hPage;
        return 96;
    }

    public double getPageMaxScale(Object hPage, String destMimeType) {
        return 10.0;
    }

    public double getPageMinScale(Object hPage, String destMimeType) {
        return 0.01;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getPageImage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations) {
        WorkbenchPart part;
        WorkbenchPage page = (WorkbenchPage)hPage;
        WorkbenchPart workbenchPart = part = page.part;
        synchronized (workbenchPart) {
            this.trace(part.document, page, "getPageImage started");
            int imageWidth = (int)((double)this.getPageXResolution(page) * this.getPageWidth(page) * scale);
            int imageHeight = (int)((double)this.getPageYResolution(page) * this.getPageHeight(page) * scale);
            int rotatedWidth = imageWidth;
            int rotatedHeight = imageHeight;
            if (rotation == 1 || rotation == 3) {
                rotatedWidth = imageHeight;
                rotatedHeight = imageWidth;
            }
            BufferedImage image = new BufferedImage(rotatedWidth, rotatedHeight, 1);
            WritableRaster raster = image.getRaster();
            DataBufferInt dataBuffer = (DataBufferInt)raster.getDataBuffer();
            int[] imageData = dataBuffer.getData();
            if (scale >= 2.0) {
                enhance = false;
            }
            this.trace(part.document, page, "getPageImage, buffer created");
            int rc = 1;
            this.workbenchJNI.vsSetCurrentPage(part.hvsDoc, page.partPageNumber);
            if (enhance) {
                this.workbenchJNI.vsSetWindowSize(part.hvsDoc, imageWidth * 2, imageHeight * 2);
            } else {
                this.workbenchJNI.vsSetWindowSize(part.hvsDoc, imageWidth, imageHeight);
            }
            this.workbenchJNI.vsDocPaintImage(part.hvsDoc, imageWidth, imageHeight, imageData, false, true, rotation, enhance, invert);
            if (rc <= 0) {
                throw new CMBDocumentEngineException("Error from VSDocPaint: rc = " + rc);
            }
            this.trace(part.document, page, "getPageImage, vsDocPaint completed");
            if (page.part.document.annotationSet != null) {
                Graphics2D graphics = (Graphics2D)image.getGraphics();
                if (rotation == 1) {
                    graphics.translate(imageWidth / 2, imageHeight / 2);
                    graphics.rotate(1.5707963267948966);
                    graphics.translate(-imageHeight / 2, -imageWidth / 2);
                    graphics.translate(0, -imageHeight + imageWidth);
                } else if (rotation == 2) {
                    graphics.rotate(Math.PI, imageWidth / 2, imageHeight / 2);
                } else if (rotation == 3) {
                    graphics.translate(imageWidth / 2, imageHeight / 2);
                    graphics.rotate(4.71238898038469);
                    graphics.translate(-imageHeight / 2, -imageWidth / 2);
                    graphics.translate(imageHeight - imageWidth, 0);
                }
                graphics.scale(scale, scale);
                CMBPageAnnotation[] annotations = page.part.document.annotationSet.getPageAnnotations(page.documentPageNumber);
                for (int i = 0; i < annotations.length; ++i) {
                    annotations[i].draw(graphics);
                }
                graphics.dispose();
            }
            this.trace(part.document, page, "getPageImage completed");
            return image;
        }
    }

    public boolean canWriteDocument(String sourceMimeType, String destMimeType) {
        return false;
    }

    private void trace(WorkbenchDocument document, WorkbenchPage page, String message) {
        if (this.callbacks.traceEnabled()) {
            String qualifiedMessage = "CMBAFPWorkbenchEngine: " + message;
            if (document != null) {
                qualifiedMessage = qualifiedMessage + " Document: " + document.hashCode();
            }
            if (page != null) {
                qualifiedMessage = qualifiedMessage + " Page: " + page.documentPageNumber;
            }
            this.callbacks.trace(qualifiedMessage);
        }
    }

    public boolean canWritePage(String sourceMimeType, String destMimeType) {
        return destMimeType.equals("image/png");
    }

    public void writePage(Object hPage, int rotation, double scale, boolean enhance, boolean invert, boolean withAnnotations, OutputStream output, String destMimeType) throws IOException, CMBDocumentEngineException {
        BufferedImage pageImage = (BufferedImage)this.getPageImage(hPage, rotation, scale, enhance, invert, withAnnotations);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(output);
        writer.setOutput(ios);
        writer.write(pageImage);
    }

    private class AnnotationServicesCallbacks
    extends CMBAnnotationServicesCallbacks {
        private AnnotationServicesCallbacks() {
        }

        public int addAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData) throws CMBAnnotationEngineException {
            return 0;
        }

        public InputStream getAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
            return null;
        }

        public boolean getPrivilege(CMBAnnotationSet annotationSet, int privilegeID) throws CMBAnnotationEngineException {
            return true;
        }

        public void removeAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
        }

        public void trace(String message) {
        }

        public boolean traceEnabled() {
            return false;
        }

        public void updateAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData, int annotationNumber) throws CMBAnnotationEngineException {
        }
    }

    private class WorkbenchPage {
        WorkbenchPart part;
        int documentPageNumber;
        int partPageNumber;
        int widthPixels;
        int heightPixels;
        int xResolution;
        int yResolution;

        private WorkbenchPage() {
        }
    }

    class WorkbenchPart {
        WorkbenchDocument document;
        File tempFile;
        int hvsDoc;
        int firstPageNumber;
        private int pageCount;
        private boolean pageCountDetermined;
        private boolean pageCountingStarted;
        boolean isDropped;
        private Object pageCountDetermineLock = new Object();

        WorkbenchPart() {
        }

        public int getPageCount() {
            if (this.pageCountDetermined) {
                return this.pageCount;
            }
            this.determinePageCount();
            return this.pageCount;
        }

        public boolean containsPage(int pageIndex) {
            if (!this.pageCountingStarted) {
                Thread thread = new Thread(){

                    public void run() {
                        WorkbenchPart.this.determinePageCount();
                    }
                };
                try {
                    thread.setDaemon(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                thread.start();
            }
            while (!this.pageCountDetermined && this.pageCount <= pageIndex) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isDropped) continue;
                return false;
            }
            return pageIndex < this.pageCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void determinePageCount() {
            Object object = this.pageCountDetermineLock;
            synchronized (object) {
                if (this.pageCountDetermined) {
                    return;
                }
                this.pageCount = CMBAFPWorkbenchEngine.this.workbenchJNI.vsGetNumPages(this.hvsDoc);
                if (this.pageCount <= 0) {
                    throw new CMBDocumentEngineException("Error obtaining page count: rc=" + this.pageCount);
                }
                this.pageCountDetermined = true;
            }
        }
    }

    private class WorkbenchDocument {
        String mimeType;
        WorkbenchPart[] parts;
        CMBAnnotationSet annotationSet;
        int pageCount;

        private WorkbenchDocument() {
        }
    }
}

