/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

class AFP2HTML {
    public static final int AFP2HTML_SUCCESS = 0;
    public static final int AFP2HTML_FAILED = -1;
    public static Object dllLock = new Object();
    public boolean gifConversionFlag;
    private boolean dllLoaded;
    public int pageNumberToConvert;
    public int numberOfPages;
    public int rotationValue;
    public String imgRefString;
    public float scaleValue;
    private byte[] AFPcontent;
    private byte[] htmlcontent;
    private byte[] gifcontent;

    public AFP2HTML() {
        try {
            System.loadLibrary("AFP2HTML");
            this.dllLoaded = true;
        }
        catch (Error e) {
            System.out.println("Failed to load AFP2HTML.dll");
            System.out.println("Please verify that PATH environment variable is correct.");
            System.out.println("Converter is disabled, program should be stopped now.");
            this.dllLoaded = false;
        }
        this.gifConversionFlag = true;
        this.pageNumberToConvert = 1;
        this.numberOfPages = -1;
        this.rotationValue = 0;
        this.imgRefString = new String("");
        this.scaleValue = 1.0f;
        this.htmlcontent = null;
        this.gifcontent = null;
    }

    public boolean isConverterReady() {
        return this.dllLoaded;
    }

    public byte[] getHTML() {
        if (this.AFPcontent != null) {
            return this.getHTML(this.AFPcontent, this.createParameterList());
        }
        return null;
    }

    public byte[] getHTML(byte[] afpc) {
        if (afpc != null) {
            return this.getHTML(afpc, this.createParameterList());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHTML(byte[] afpc, boolean gCF, int pNTC, int rV, String iRS, float sV) {
        Object object = dllLock;
        synchronized (object) {
            if (afpc != null) {
                return this.getHTML(afpc, this.createParameterList(gCF, pNTC, rV, iRS, sV));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getGif(byte[] afpc, boolean gCF, int pNTC, int rV, String iRS, float sV) {
        Object object = dllLock;
        synchronized (object) {
            if (afpc != null) {
                return this.getGif(afpc, this.createParameterList(gCF, pNTC, rV, iRS, sV));
            }
            return null;
        }
    }

    public byte[] getGif() {
        if (this.AFPcontent != null) {
            return this.getGif(this.AFPcontent, this.createParameterList());
        }
        return null;
    }

    public byte[] getGif(byte[] afpc) {
        if (afpc != null) {
            return this.getGif(afpc, this.createParameterList());
        }
        return null;
    }

    public int getNumberOfPages() {
        if (this.AFPcontent != null) {
            if (this.numberOfPages == -1) {
                this.numberOfPages = this.getNumPages(this.AFPcontent);
            }
            return this.numberOfPages;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPages(byte[] afpc) {
        Object object = dllLock;
        synchronized (object) {
            if (afpc != null) {
                return this.getNumPages(afpc);
            }
            return -1;
        }
    }

    public void setAFPContent(byte[] afp) {
        this.AFPcontent = afp;
        this.numberOfPages = -1;
    }

    public byte[] getAFPContent() {
        return this.AFPcontent;
    }

    private String createParameterList(boolean gCF, int pNTC, int rV, String iRS, float sV) {
        String temp = new String("");
        temp = temp + "<1gifFlag1>" + gCF + "<1end1>\n";
        temp = temp + "<2pageNumber2>" + pNTC + "<2end2>\n";
        temp = temp + "<3rotationValue3>" + rV + "<3end3>\n";
        temp = temp + "<4imgRef4>" + iRS + "<4end4>\n";
        temp = temp + "<5scaleValue5>" + sV + "<5end5>\n";
        return temp;
    }

    private String createParameterList() {
        String temp = new String("");
        temp = temp + "<1gifFlag1>" + this.gifConversionFlag + "<1end1>\n";
        temp = temp + "<2pageNumber2>" + this.pageNumberToConvert + "<2end2>\n";
        temp = temp + "<3rotationValue3>" + this.rotationValue + "<3end3>\n";
        temp = temp + "<4imgRef4>" + this.imgRefString + "<4end4>\n";
        temp = temp + "<5scaleValue5>" + this.scaleValue + "<5end5>\n";
        return temp;
    }

    private native byte[] getHTML(byte[] var1, String var2);

    private native byte[] getGif(byte[] var1, String var2);

    private native int getNumPages(byte[] var1);
}

