/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.java;

import com.ibm.json.java.JSONObject;
import com.ibm.json.java.internal.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;

public class OrderedJSONObject
extends JSONObject {
    private static final long serialVersionUID = -3269263069889337299L;
    private ArrayList order = new ArrayList();

    public static JSONObject parse(Reader reader) throws IOException {
        reader = new BufferedReader(reader);
        return new Parser(reader).parse(true);
    }

    public static JSONObject parse(String str) throws IOException {
        StringReader strReader = new StringReader(str);
        return OrderedJSONObject.parse(strReader);
    }

    public static JSONObject parse(InputStream is) throws IOException {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, "UTF-8");
        }
        catch (Exception ex) {
            isr = new InputStreamReader(is);
        }
        return OrderedJSONObject.parse(isr);
    }

    public Object put(Object key, Object value) {
        if (null == key) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (!OrderedJSONObject.isValidObject(value)) {
            if (value != null) {
                throw new IllegalArgumentException("Invalid type of value.  Type: [" + value.getClass().getName() + "] with value: [" + value.toString() + "]");
            }
            throw new IllegalArgumentException("Invalid type of value.");
        }
        if (!this.containsKey(key)) {
            this.order.add(key);
        }
        return super.put(key, value);
    }

    public Object remove(Object key) {
        Object retVal = null;
        if (null == key) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.containsKey(key)) {
            retVal = super.remove(key);
            for (int i = 0; i < this.order.size(); ++i) {
                Object obj = this.order.get(i);
                if (!obj.equals(key)) continue;
                this.order.remove(i);
                break;
            }
        }
        return retVal;
    }

    public void clear() {
        super.clear();
        this.order.clear();
    }

    public Object clone() {
        OrderedJSONObject clone = (OrderedJSONObject)super.clone();
        Iterator order = clone.getOrder();
        ArrayList orderList = new ArrayList();
        while (order.hasNext()) {
            orderList.add(order.next());
            clone.order = orderList;
        }
        return clone;
    }

    public Iterator getOrder() {
        return this.order.iterator();
    }
}

