/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.java;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.internal.Parser;
import com.ibm.json.java.internal.Serializer;
import com.ibm.json.java.internal.SerializerVerbose;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.HashMap;

public class JSONObject
extends HashMap
implements JSONArtifact {
    private static final long serialVersionUID = -3269263069889337298L;

    public static boolean isValidObject(Object object) {
        if (null == object) {
            return true;
        }
        return JSONObject.isValidType(object.getClass());
    }

    public static boolean isValidType(Class clazz) {
        if (null == clazz) {
            throw new IllegalArgumentException();
        }
        if (String.class == clazz) {
            return true;
        }
        if (Boolean.class == clazz) {
            return true;
        }
        if (JSONObject.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (JSONArray.class == clazz) {
            return true;
        }
        return Number.class.isAssignableFrom(clazz);
    }

    public static JSONObject parse(Reader reader) throws IOException {
        return new Parser(reader).parse();
    }

    public static JSONObject parse(String str) throws IOException {
        StringReader strReader = new StringReader(str);
        return JSONObject.parse(strReader);
    }

    public static JSONObject parse(InputStream is) throws IOException {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, "UTF-8");
        }
        catch (Exception ex) {
            isr = new InputStreamReader(is);
        }
        return JSONObject.parse(isr);
    }

    public void serialize(OutputStream os) throws IOException {
        this.serialize(os, false);
    }

    public void serialize(OutputStream os, boolean verbose) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        }
        catch (UnsupportedEncodingException uex) {
            IOException iox = new IOException(uex.toString());
            iox.initCause(uex);
            throw iox;
        }
        this.serialize(writer, verbose);
    }

    public void serialize(Writer writer) throws IOException {
        this.serialize(writer, false);
    }

    public void serialize(Writer writer, boolean verbose) throws IOException {
        Class<?> writerClass = writer.getClass();
        if (!(StringWriter.class.isAssignableFrom(writerClass) || CharArrayWriter.class.isAssignableFrom(writerClass) || BufferedWriter.class.isAssignableFrom(writerClass))) {
            writer = new BufferedWriter(writer);
        }
        Serializer serializer = verbose ? new SerializerVerbose(writer) : new Serializer(writer);
        serializer.writeObject(this).flush();
    }

    public String serialize(boolean verbose) throws IOException {
        StringWriter writer = new StringWriter();
        Serializer serializer = verbose ? new SerializerVerbose(writer) : new Serializer(writer);
        serializer.writeObject(this).flush();
        return writer.toString();
    }

    public String serialize() throws IOException {
        return this.serialize(false);
    }

    public Object put(Object key, Object value) {
        if (null == key) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (!JSONObject.isValidObject(value)) {
            if (value != null) {
                throw new IllegalArgumentException("Invalid type of value.  Type: [" + value.getClass().getName() + "] with value: [" + value.toString() + "]");
            }
            throw new IllegalArgumentException("Invalid type of value.");
        }
        if (value instanceof BigDecimal) {
            value = value.toString();
        }
        return super.put(key, value);
    }

    public String toString() {
        String str = null;
        try {
            str = this.serialize(false);
        }
        catch (IOException iox) {
            str = "JSON Generation Error: [" + iox.toString() + "]";
        }
        return str;
    }
}

