/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.java;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.internal.Serializer;
import com.ibm.json.java.internal.SerializerVerbose;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class JSONArray
extends ArrayList
implements JSONArtifact {
    private static final long serialVersionUID = 9076798781015779954L;

    public JSONArray() {
    }

    public JSONArray(int initialCapacity) {
        super(initialCapacity);
    }

    public void add(int index, Object element) {
        this.checkElement(element);
        super.add(index, element);
    }

    public boolean add(Object element) {
        this.checkElement(element);
        return super.add(element);
    }

    public boolean addAll(Collection collection) {
        this.checkElements(collection);
        return super.addAll(collection);
    }

    public boolean addAll(int index, Collection collection) {
        this.checkElements(collection);
        return super.addAll(index, collection);
    }

    public Object set(int index, Object element) {
        this.checkElement(element);
        return super.set(index, element);
    }

    public static JSONArray parse(InputStream is) throws IOException {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, "UTF-8");
        }
        catch (Exception ex) {
            isr = new InputStreamReader(is);
        }
        return JSONArray.parse(isr);
    }

    public static JSONArray parse(Reader reader) throws IOException {
        StringBuffer buf = new StringBuffer("");
        buf.append("{\"jsonArray\":");
        char[] data = new char[8196];
        int amtRead = 0;
        amtRead = reader.read(data, 0, 8196);
        while (amtRead != -1) {
            buf.append(data, 0, amtRead);
            amtRead = reader.read(data, 0, 8196);
        }
        buf.append("}");
        JSONObject obj = JSONObject.parse(buf.toString());
        return (JSONArray)obj.get("jsonArray");
    }

    public static JSONArray parse(String str) throws IOException {
        StringReader strReader = new StringReader(str);
        return JSONArray.parse(strReader);
    }

    public void serialize(OutputStream os) throws IOException {
        this.serialize(os, false);
    }

    public void serialize(OutputStream os, boolean verbose) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        }
        catch (UnsupportedEncodingException uex) {
            IOException iox = new IOException(uex.toString());
            iox.initCause(uex);
            throw iox;
        }
        this.serialize(writer, verbose);
    }

    public void serialize(Writer writer) throws IOException {
        this.serialize(writer, false);
    }

    public void serialize(Writer writer, boolean verbose) throws IOException {
        Class<?> writerClass = writer.getClass();
        if (!(StringWriter.class.isAssignableFrom(writerClass) || CharArrayWriter.class.isAssignableFrom(writerClass) || BufferedWriter.class.isAssignableFrom(writerClass))) {
            writer = new BufferedWriter(writer);
        }
        Serializer serializer = verbose ? new SerializerVerbose(writer) : new Serializer(writer);
        serializer.writeArray(this).flush();
    }

    public String serialize(boolean verbose) throws IOException {
        StringWriter writer = new StringWriter();
        Serializer serializer = verbose ? new SerializerVerbose(writer) : new Serializer(writer);
        serializer.writeArray(this).flush();
        return writer.toString();
    }

    public String serialize() throws IOException {
        return this.serialize(false);
    }

    private void checkElement(Object element) {
        if (!JSONObject.isValidObject(element)) {
            throw new IllegalArgumentException("invalid type of element");
        }
    }

    private void checkElements(Collection collection) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            if (JSONObject.isValidObject(iter.next())) continue;
            throw new IllegalArgumentException("invalid type of element");
        }
    }
}

