/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.core.Versionable;
import com.filenet.api.core.WorkflowDefinition;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.EncodingUtil;
import com.ibm.ecm.util.p8.P8CeSearchUtilProxy;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8EntryTemplateWorkflow;
import com.ibm.ecm.util.p8.P8Exception;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWUserInfo;
import filenet.vw.server.Configuration;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;

public class P8Workflow {
    public static final String CURRENT = "current";
    public static final String RELEASE = "release";
    private static final String NO_DATE_VALUE = "-2000000000000";
    private static DesktopConfig desktopConfig = null;

    public static VWSession getVWSession(P8Connection connection, HttpServletRequest request) {
        String methodName = "getVWSession";
        Logger.logEntry(P8Workflow.class, methodName, (ServletRequest)request);
        VWSession vwSession = connection.getVWSession();
        if (vwSession == null) {
            try {
                vwSession = new VWSession();
                String repositoryId = request.getParameter("repositoryId");
                Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
                String serverName = null;
                RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
                serverName = repositoryConfig.getServerName();
                Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "server name: " + serverName);
                vwSession.setBootstrapCEURI(Configuration.NormalizeCEURI((String)serverName));
                String connectionPoint = P8Workflow.getConnectionPoint(request, repositoryConfig);
                vwSession.logon(connectionPoint);
                vwSession.setDefaultWebApplication(10);
                connection.setVWSession(vwSession);
            }
            catch (Exception e) {
                vwSession = null;
                Logger.logError(P8Workflow.class, methodName, (ServletRequest)request, (Throwable)e);
            }
        }
        Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
        return vwSession;
    }

    public static VWSession getConnectionPointVWSession(P8Connection connection, HttpServletRequest request) {
        String methodName = "getVWSession";
        Logger.logEntry(P8Workflow.class, methodName, (ServletRequest)request);
        VWSession vwSession = null;
        try {
            String repositoryId = request.getParameter("repositoryId");
            Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
            RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
            if (repositoryConfig != null) {
                String serverName = repositoryConfig.getServerName();
                Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "server name: " + serverName);
                String connectionPoint = P8Workflow.getConnectionPoint(request, repositoryConfig);
                if (serverName != null && serverName.length() > 0 && connectionPoint != null && connectionPoint.length() > 0) {
                    vwSession = connection.getVWSessionByConnectionPoint(serverName + connectionPoint);
                    if (vwSession == null) {
                        vwSession = new VWSession();
                        vwSession.setBootstrapCEURI(Configuration.NormalizeCEURI((String)serverName));
                        vwSession.logon(connectionPoint);
                        vwSession.setDefaultWebApplication(10);
                        connection.setVWSessionByConnectionPoint(serverName + connectionPoint, vwSession);
                    }
                } else {
                    Logger.logError(P8Workflow.class, methodName, (ServletRequest)request, "Either server name or connection point is empty");
                }
            }
        }
        catch (Exception e) {
            vwSession = null;
            Logger.logError(P8Workflow.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
        return vwSession;
    }

    private static String getConnectionPoint(HttpServletRequest request, RepositoryConfig repositoryConfig) {
        String methodName = "getConnectionPoint";
        String connectionPoint = null;
        if (repositoryConfig != null) {
            int index;
            connectionPoint = repositoryConfig.getConnectionPoint();
            Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "full connection point: " + connectionPoint);
            if (connectionPoint != null && (index = connectionPoint.lastIndexOf(58, connectionPoint.length())) != -1) {
                connectionPoint = connectionPoint.substring(0, index);
                Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "short connection point: " + connectionPoint);
            }
        }
        return connectionPoint;
    }

    public static VWStepElement getStepElement(HttpServletRequest request, String wobNum) {
        Hashtable stepElementList;
        String methodName = "getStepElement";
        HttpSession session = request.getSession(false);
        VWStepElement stepElement = null;
        if (session != null && (stepElementList = (Hashtable)session.getAttribute("p8_process_steps")) != null && wobNum != null) {
            Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "Retrieve step from session list - wobNum: " + wobNum);
            stepElement = (VWStepElement)stepElementList.get(wobNum);
        }
        return stepElement;
    }

    public static void setStepElement(HttpServletRequest request, VWStepElement stepElement, String wobNum) {
        String methodName = "setStepElement";
        Logger.logEntry(P8Workflow.class, methodName, (ServletRequest)request);
        Hashtable<String, VWStepElement> stepElementList = (Hashtable<String, VWStepElement>)request.getSession(true).getAttribute("p8_process_steps");
        if (stepElementList == null) {
            stepElementList = new Hashtable<String, VWStepElement>();
            request.getSession(true).setAttribute("p8_process_steps", stepElementList);
            P8Workflow.setStepElement(request, stepElement, wobNum);
        } else if (stepElement != null) {
            Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "Add step to session list - wobNum: " + wobNum);
            stepElementList.put(wobNum, stepElement);
        } else {
            Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "Remove step from session list - wobNum: " + wobNum);
            VWStepElement removeStepElement = (VWStepElement)stepElementList.remove(wobNum);
            removeStepElement = null;
        }
        Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
    }

    public static VWStepElement createStepElement(HttpServletRequest request, VWSession vwSession, String launchVersion, String attachmentId) throws Exception {
        String methodName = "createStepElement";
        Logger.logEntry(P8Workflow.class, methodName, (ServletRequest)request);
        VWStepElement stepElement = null;
        String decodedLaunchVersion = null;
        if (launchVersion != null) {
            boolean requireLabelDecoding = false;
            String encodedTab = EncodingUtil.encodeLabel("\t");
            if (launchVersion.contains(encodedTab)) {
                requireLabelDecoding = true;
            }
            decodedLaunchVersion = requireLabelDecoding ? EncodingUtil.decodeLabel(launchVersion) : URLDecoder.decode(launchVersion, "UTF-8");
            boolean validIdentifier = true;
            if (decodedLaunchVersion != null) {
                validIdentifier = vwSession.checkWorkflowIdentifier(decodedLaunchVersion);
            }
            if (validIdentifier) {
                stepElement = vwSession.createWorkflow(decodedLaunchVersion);
                String mainAttachmentParameterName = null;
                try {
                    mainAttachmentParameterName = (String)stepElement.getParameterValue("F_MAINATTACHMENT");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (mainAttachmentParameterName != null && attachmentId != null && attachmentId.length() > 0) {
                    String decodedAttachmentId = null;
                    decodedAttachmentId = requireLabelDecoding ? EncodingUtil.decodeLabel(attachmentId) : URLDecoder.decode(attachmentId, "UTF-8");
                    VWAttachment mainAttachment = P8Workflow.createAttachment(request, decodedAttachmentId);
                    VWParameter mainAttachmentParameter = stepElement.getParameter(mainAttachmentParameterName);
                    if (mainAttachmentParameter != null) {
                        P8Workflow.addMainAttachment(request, stepElement, mainAttachmentParameter, mainAttachment, mainAttachmentParameterName);
                    }
                }
            }
        }
        Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
        return stepElement;
    }

    public static VWStepElement getStepElement(HttpServletRequest request, MessageResources resources, VWSession vwSession, String queueName, String wobNum) throws Exception {
        String methodName = "getStepElement";
        Logger.logEntry(P8Workflow.class, methodName, (ServletRequest)request);
        VWStepElement stepElement = null;
        VWQueue queue = vwSession.getQueue(queueName);
        Object[] values = new Object[]{wobNum};
        int queryFlags = 98;
        VWQueueQuery queueQuery = queue.createQuery("F_WobNum", values, values, queryFlags, null, null, 5);
        if (queueQuery.hasNext()) {
            stepElement = (VWStepElement)queueQuery.next();
        } else {
            queryFlags = 99;
            queueQuery = queue.createQuery("F_WobNum", values, values, queryFlags, null, null, 3);
            if (queueQuery.hasNext()) {
                VWQueueElement queueElement = (VWQueueElement)queueQuery.next();
                if (queueElement != null) {
                    String lockedUserName = queueElement.getLockedUser();
                    VWUserInfo currentUserInfo = vwSession.fetchCurrentUserInfo();
                    String currentUserName = null;
                    if (currentUserInfo != null) {
                        currentUserName = currentUserInfo.getName();
                    }
                    if ((queueQuery = queue.createQuery("F_WobNum", values, values, queryFlags, null, null, 5)).hasNext()) {
                        stepElement = (VWStepElement)queueQuery.next();
                        String originator = stepElement.getOriginator();
                        if (lockedUserName != null && currentUserName != null && originator != null) {
                            boolean blockOriginator = true;
                            if (blockOriginator ? !lockedUserName.equalsIgnoreCase(currentUserName) : !lockedUserName.equalsIgnoreCase(currentUserName) && !originator.equalsIgnoreCase(currentUserName)) {
                                throw new P8Exception("process.error.exception.taskislockedby", new Object[]{lockedUserName});
                            }
                        } else {
                            if (lockedUserName != null && !lockedUserName.equalsIgnoreCase(currentUserName)) {
                                throw new P8Exception("process.error.exception.taskislockedby", new Object[]{lockedUserName});
                            }
                            if (lockedUserName == null) {
                                throw new P8Exception("process.error.exception.taskfailurelocked");
                            }
                        }
                    }
                } else {
                    throw new P8Exception("process.error.exception.tasknotavailable");
                }
            }
        }
        if (stepElement == null) {
            throw new P8Exception("process.error.exception.tasknotavailable");
        }
        Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
        return stepElement;
    }

    public static void setParameter(HttpServletRequest request, P8Connection connection, VWStepElement stepElement, VWParameter dataField, String name, JSONArray values) throws Exception {
        String strValue;
        Object objValue;
        Integer mode;
        String methodName = "setParameter";
        Logger.logEntry(P8Workflow.class, methodName, (ServletRequest)request);
        if (dataField == null || dataField.isSystemParameter()) {
            if (name.equals("F_Responses")) {
                String response = (String)values.get(0);
                if (response != null && response.length() > 0) {
                    stepElement.setSelectedResponse(response);
                }
                Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
                return;
            }
            if (name.equals("F_Subject")) {
                String subject = (String)values.get(0);
                if (subject != null && subject.length() > 0) {
                    stepElement.setParameterValue(name, (Object)subject, true);
                }
                Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
                return;
            }
            if (name.equals("F_Comment")) {
                String comment = (String)values.get(0);
                if (comment != null && comment.length() > 0) {
                    stepElement.setParameterValue(name, (Object)comment, true);
                }
                Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
                return;
            }
            if (!name.equals("F_Trackers")) {
                Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
                return;
            }
        }
        if ((mode = Integer.valueOf(dataField.getMode())).equals(2) && values.size() == 1 && (objValue = values.get(0)) instanceof String && (strValue = (String)objValue).length() == 0) {
            Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "Data field is type write only, no value set: " + name);
            Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
            return;
        }
        int type = dataField.getFieldType();
        Object[] objectValues = null;
        if (values != null && values.size() > 0) {
            objectValues = new Object[values.size()];
            if (type == 1) {
                for (int i = 0; i < values.size(); ++i) {
                    String criteriaValue = (String)values.get(i);
                    objectValues[i] = criteriaValue != null && criteriaValue.length() > 0 ? new Integer(criteriaValue) : new Integer(0);
                }
            } else if (type == 2) {
                for (int i = 0; i < values.size(); ++i) {
                    String criteriaValue = (String)values.get(i);
                    objectValues[i] = criteriaValue;
                }
            } else if (type == 4) {
                for (int i = 0; i < values.size(); ++i) {
                    String criteriaValue = (String)values.get(i);
                    objectValues[i] = new Boolean(criteriaValue);
                }
            } else if (type == 8) {
                for (int i = 0; i < values.size(); ++i) {
                    String criteriaValue = (String)values.get(i);
                    objectValues[i] = criteriaValue != null && criteriaValue.length() > 0 ? new Double(criteriaValue) : new Double(0.0);
                }
            } else if (type == 16) {
                for (int i = 0; i < values.size(); ++i) {
                    String criteriaValue = (String)values.get(i);
                    objectValues[i] = criteriaValue != null && criteriaValue.length() == 0 ? new Date(Long.parseLong(NO_DATE_VALUE)) : DateUtil.parseISODate(criteriaValue, true);
                }
            } else if (type == 64) {
                objectValues = new VWParticipant[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    Object objValue2 = values.get(i);
                    if (objValue2 instanceof JSONObject) {
                        JSONObject criteriaValue = (JSONObject)objValue2;
                        String shortName = (String)criteriaValue.get("shortName");
                        VWParticipant participant = new VWParticipant();
                        participant.setParticipantName(shortName);
                        objectValues[i] = participant;
                        continue;
                    }
                    if (values.size() != 1) continue;
                    objectValues = null;
                }
            } else if (type == 32) {
                objectValues = new VWAttachment[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    JSONObject criteriaValue = (JSONObject)values.get(i);
                    String attachmentName = (String)criteriaValue.get("attachment_name");
                    Long attType = (Long)criteriaValue.get("attachment_type");
                    int attachmentType = attType.intValue();
                    String repositoryId = (String)criteriaValue.get("attachment_repository_id");
                    String libraryName = (String)criteriaValue.get("attachment_library_name");
                    String objectStoreDisplayName = P8Workflow.getObjectStoreDisplayName(request, connection, repositoryId, libraryName);
                    Long libType = (Long)criteriaValue.get("attachment_library_type");
                    String id = (String)criteriaValue.get("attachment_id");
                    String vsId = (String)criteriaValue.get("attachment_vsid");
                    String version = (String)criteriaValue.get("attachment_version");
                    VWAttachment attachment = new VWAttachment();
                    attachment.setAttachmentName(attachmentName);
                    if (attachmentType == 3) {
                        if (version == null || version.length() == 0) {
                            attachment.setId(vsId);
                        } else if (version.equals("-1")) {
                            attachment.setVersion(version);
                            attachment.setId(vsId);
                        } else {
                            attachment.setVersion(version);
                        }
                    } else {
                        attachment.setId(id);
                    }
                    attachment.setType(attachmentType);
                    attachment.setLibraryName(objectStoreDisplayName);
                    attachment.setLibraryType(libType.intValue());
                    objectValues[i] = attachment;
                }
            }
        } else if (type == 32) {
            VWAttachment attachment = new VWAttachment();
            objectValues = new Object[]{attachment};
        }
        if (dataField.isArray() || objectValues == null) {
            stepElement.setParameterValue(name, (Object)objectValues, true);
        } else {
            stepElement.setParameterValue(name, objectValues[0], true);
        }
        Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
    }

    private static String getObjectStoreDisplayName(HttpServletRequest request, P8Connection connection, String repositoryId, String objectStoreName) {
        String objectStoreDisplayName = null;
        if (desktopConfig == null) {
            desktopConfig = Config.getDesktopConfig(request);
        }
        String objectStoreSymbolicName = null;
        if (repositoryId != null && repositoryId.length() > 0) {
            RepositoryConfig repositoryConfig = desktopConfig.getRepository(repositoryId);
            objectStoreDisplayName = repositoryConfig.getObjectStoreDisplayName();
        } else {
            for (RepositoryConfig repository : desktopConfig.getRepositoryList()) {
                objectStoreSymbolicName = repository.getObjectStore();
                if (objectStoreSymbolicName == null || !objectStoreSymbolicName.equals(objectStoreName)) continue;
                objectStoreDisplayName = repository.getObjectStoreDisplayName();
                break;
            }
        }
        if (objectStoreDisplayName == null) {
            ObjectStore os = P8Util.getObjectStore(connection, objectStoreName);
            objectStoreDisplayName = os.get_DisplayName();
        }
        return objectStoreDisplayName;
    }

    public static String getRepositoryId(DesktopConfig desktopConfig, String defaultRepositoryId, String objectStoreName) {
        String repositoryId = "";
        ArrayList<RepositoryConfig> repositories = new ArrayList<RepositoryConfig>();
        for (RepositoryConfig repository : desktopConfig.getRepositoryList()) {
            String repoObjectStoreName = repository.getObjectStoreDisplayName();
            if (repoObjectStoreName == null || !repoObjectStoreName.equals(objectStoreName)) continue;
            repositoryId = repository.getObjectId();
            repositories.add(repository);
        }
        if (repositories.size() > 1) {
            RepositoryConfig repositoryConfig = desktopConfig.getRepository(defaultRepositoryId);
            String defaultServerName = repositoryConfig.getServerName();
            for (int i = 0; i < repositories.size(); ++i) {
                String currentRepositoryId = ((RepositoryConfig)repositories.get(i)).getObjectId();
                RepositoryConfig currectRepositoryConfig = desktopConfig.getRepository(currentRepositoryId);
                String currentServerName = currectRepositoryConfig.getServerName();
                if (!currentServerName.equals(defaultServerName)) continue;
                repositoryId = currentRepositoryId;
                break;
            }
        }
        return repositoryId;
    }

    public static String getDataType(Integer type) {
        String xsType = "xs:string";
        if (type == 1) {
            xsType = "xs:long";
        } else if (type == 2) {
            xsType = "xs:string";
        } else if (type == 4) {
            xsType = "xs:boolean";
        } else if (type == 8) {
            xsType = "xs:double";
        } else if (type == 16) {
            xsType = "xs:timestamp";
        } else if (type == 32) {
            xsType = "xs:attachment";
        } else if (type == 64) {
            xsType = "xs:group";
        }
        return xsType;
    }

    public static Object getValue(VWParameter parameter) {
        Object returnVal = null;
        try {
            int fieldType = parameter.getFieldType();
            if (fieldType == 4) {
                if (parameter.isArray()) {
                    Boolean[] values = (Boolean[])parameter.getValue();
                    if (values == null || values.length < 1) {
                        returnVal = "";
                    } else {
                        String[] array = new String[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            array[i] = values[i].toString();
                        }
                        returnVal = array;
                    }
                } else {
                    Boolean value = (Boolean)parameter.getValue();
                    returnVal = value.toString();
                }
            } else if (fieldType == 8) {
                if (parameter.isArray()) {
                    Double[] values = (Double[])parameter.getValue();
                    if (values == null || values.length < 1) {
                        returnVal = "";
                    } else {
                        String[] array = new String[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            array[i] = values[i].toString();
                        }
                        returnVal = array;
                    }
                } else {
                    Double value = (Double)parameter.getValue();
                    returnVal = value.toString();
                }
            } else if (fieldType == 512) {
                if (parameter.isArray()) {
                    // empty if block
                }
            } else if (fieldType == 1) {
                if (parameter.isArray()) {
                    Integer[] values = (Integer[])parameter.getValue();
                    if (values == null || values.length < 1) {
                        returnVal = "";
                    } else {
                        String[] array = new String[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            array[i] = values[i].toString();
                        }
                        returnVal = array;
                    }
                } else {
                    Integer value = (Integer)parameter.getValue();
                    returnVal = value.toString();
                }
            } else if (fieldType == 2) {
                if (parameter.isArray()) {
                    String[] values = (String[])parameter.getValue();
                    if (values == null || values.length < 1) {
                        returnVal = "";
                    } else {
                        String[] array = new String[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            array[i] = values[i];
                        }
                        returnVal = array;
                    }
                } else {
                    String value = (String)parameter.getValue();
                    returnVal = value == null ? "" : value;
                }
            } else if (fieldType == 16) {
                if (parameter.isArray()) {
                    Date[] values = (Date[])parameter.getValue();
                    if (values == null || values.length < 1) {
                        returnVal = "";
                    } else {
                        String[] array = new String[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            Date date = values[i];
                            array[i] = P8Workflow.getDateValue(date);
                        }
                        returnVal = array;
                    }
                } else {
                    Date date = (Date)parameter.getValue();
                    returnVal = P8Workflow.getDateValue(date);
                }
            } else if (fieldType == 128) {
                if (parameter.isArray()) {
                    // empty if block
                }
            } else if (fieldType == 32) {
                Object attachmentValue = parameter.getValue();
                if (attachmentValue != null) {
                    if (attachmentValue instanceof VWAttachment) {
                        VWAttachment[] attachments = new VWAttachment[]{(VWAttachment)attachmentValue};
                        returnVal = attachments;
                    } else {
                        returnVal = (VWAttachment[])attachmentValue;
                    }
                } else {
                    VWAttachment[] attachments = new VWAttachment[1];
                    returnVal = attachments;
                }
            } else if (fieldType == 64) {
                VWParticipant[] participants = (VWParticipant[])parameter.getValue();
                returnVal = participants;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (returnVal == null) {
            returnVal = "";
        }
        return returnVal;
    }

    public static Object getValue(int fieldType, boolean isArray, Object realValue) {
        Object returnVal = null;
        try {
            if (fieldType == 4) {
                if (isArray) {
                    Boolean[] values = (Boolean[])realValue;
                    if (values == null || values.length < 1) {
                        returnVal = "";
                    } else {
                        String[] array = new String[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            array[i] = values[i].toString();
                        }
                        returnVal = array;
                    }
                } else {
                    Boolean value = (Boolean)realValue;
                    returnVal = value.toString();
                }
            } else if (fieldType == 8) {
                if (isArray) {
                    Double[] values = (Double[])realValue;
                    if (values == null || values.length < 1) {
                        returnVal = "";
                    } else {
                        String[] array = new String[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            array[i] = values[i].toString();
                        }
                        returnVal = array;
                    }
                } else {
                    Double value = (Double)realValue;
                    returnVal = value.toString();
                }
            } else if (fieldType == 512) {
                if (isArray) {
                    // empty if block
                }
            } else if (fieldType == 1) {
                if (isArray) {
                    Integer[] values = (Integer[])realValue;
                    if (values == null || values.length < 1) {
                        returnVal = "";
                    } else {
                        String[] array = new String[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            array[i] = values[i].toString();
                        }
                        returnVal = array;
                    }
                } else {
                    Integer value = (Integer)realValue;
                    returnVal = value.toString();
                }
            } else if (fieldType == 2) {
                if (isArray) {
                    String[] values = (String[])realValue;
                    if (values == null || values.length < 1) {
                        returnVal = "";
                    } else {
                        String[] array = new String[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            array[i] = values[i];
                        }
                        returnVal = array;
                    }
                } else {
                    String value = (String)realValue;
                    returnVal = value == null ? "" : value;
                }
            } else if (fieldType == 16) {
                if (isArray) {
                    Date[] values = (Date[])realValue;
                    if (values == null || values.length < 1) {
                        returnVal = "";
                    } else {
                        String[] array = new String[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            Date date = values[i];
                            array[i] = P8Workflow.getDateValue(date);
                        }
                        returnVal = array;
                    }
                } else {
                    Date date = (Date)realValue;
                    returnVal = P8Workflow.getDateValue(date);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (returnVal == null) {
            returnVal = "";
        }
        return returnVal;
    }

    private static String getDateValue(Date date) {
        String dateValue = null;
        Long NO_DATE = new Long(NO_DATE_VALUE);
        dateValue = date == null || date.getTime() == NO_DATE.longValue() ? "" : "" + DateUtil.getISODateString(date, true);
        return dateValue;
    }

    public static IndependentlyPersistableObject getPersistableObject(HttpServletRequest request, P8Connection connection, VWAttachment attachment) {
        String methodName = "getPersistableObject";
        Logger.logEntry(P8Workflow.class, methodName, (ServletRequest)request);
        String itemId = attachment.getId();
        String version = attachment.getVersion();
        int type = attachment.getType();
        Folder independentlyPersistableObject = null;
        try {
            ObjectStore os = P8Util.getObjectStore(connection, attachment.getLibraryName());
            Id id = null;
            if (type == 3) {
                if (version == null || version.length() == 0) {
                    id = new Id(itemId);
                    VersionSeries vs = Factory.VersionSeries.fetchInstance((ObjectStore)os, (Id)id, null);
                    Versionable versionableObject = vs.get_CurrentVersion();
                    if (!(versionableObject instanceof Document)) {
                        String className = versionableObject.getClass().getName();
                        Logger.logError((Object)version, methodName, (ServletRequest)request, "Expected a Document, but returned object is: " + className);
                    } else {
                        Document document = (Document)versionableObject;
                        id = document.get_Id();
                    }
                } else if (version.equals("-1")) {
                    id = new Id(itemId);
                    VersionSeries vs = Factory.VersionSeries.fetchInstance((ObjectStore)os, (Id)id, null);
                    Versionable versionableObject = vs.get_ReleasedVersion();
                    if (versionableObject == null) {
                        versionableObject = vs.get_CurrentVersion();
                    }
                    if (!(versionableObject instanceof Document)) {
                        String className = versionableObject.getClass().getName();
                        Logger.logError((Object)version, methodName, (ServletRequest)request, "Expected a Document, but returned object is: " + className);
                    } else {
                        Document document = (Document)versionableObject;
                        id = document.get_Id();
                    }
                } else {
                    id = new Id(version);
                }
            } else if (type != 5) {
                id = new Id(itemId);
            }
            if (type == 2) {
                independentlyPersistableObject = Factory.Folder.fetchInstance((ObjectStore)os, (Id)id, null);
            } else if (type == 3) {
                independentlyPersistableObject = Factory.Document.fetchInstance((ObjectStore)os, (Id)id, null);
            } else if (type == 4) {
                independentlyPersistableObject = P8CeSearchUtilProxy.fetchStoredSearch(os, id);
            } else if (type == 5) {
                Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "Can not display URL/UNC attachments: id = " + itemId);
            } else {
                independentlyPersistableObject = Factory.CustomObject.fetchInstance((ObjectStore)os, (Id)id, null);
            }
        }
        catch (EngineRuntimeException ere) {
            Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "Can not find or view attachment item: id = " + itemId);
        }
        catch (Exception e) {
            Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "Can not retrieve property information for attachment item: id = " + itemId);
        }
        Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
        return independentlyPersistableObject;
    }

    public static String fetchWorkflowVersion(HttpServletRequest request, P8Connection connection, String objectStoreName, String objectId, String vsId) {
        WorkflowDefinition workflowDefinition;
        boolean useCurrent;
        String methodName = "fetchWorkflowVersion";
        Logger.logEntry(P8Workflow.class, methodName, (ServletRequest)request);
        String vwVersion = null;
        if (objectStoreName == null || objectStoreName.length() < 1 || (objectId == null || objectId.length() < 1) && (vsId == null || vsId.length() < 1)) {
            Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
            return null;
        }
        ObjectStore os = P8Util.getObjectStore(connection, objectStoreName);
        boolean bl = useCurrent = objectId != null && objectId.equals(CURRENT);
        if (objectId == null || objectId.length() < 1 || objectId.equals(RELEASE) || useCurrent) {
            VersionSeries vs;
            PropertyFilter pf = new PropertyFilter();
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "VWVersion", null));
            if (useCurrent) {
                pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "CurrentVersion", null));
            } else {
                pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "ReleasedVersion", null));
            }
            try {
                vs = Factory.VersionSeries.fetchInstance((ObjectStore)os, (Id)new Id(vsId), (PropertyFilter)pf);
            }
            catch (EngineRuntimeException e) {
                Logger.logError(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request, (Throwable)e);
                throw e;
            }
            workflowDefinition = useCurrent ? (WorkflowDefinition)vs.get_CurrentVersion() : (WorkflowDefinition)vs.get_ReleasedVersion();
        } else {
            PropertyFilter pf = new PropertyFilter();
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(0), null, null, "VWVersion", null));
            try {
                workflowDefinition = (WorkflowDefinition)os.fetchObject("WorkflowDefinition", objectId, pf);
            }
            catch (EngineRuntimeException e) {
                Logger.logError(P8Workflow.class, methodName, (ServletRequest)request, (Throwable)e);
                throw e;
            }
        }
        vwVersion = workflowDefinition.get_VWVersion();
        if (vwVersion == null || vwVersion.length() < 1) {
            Logger.logDebug(P8Workflow.class, methodName, (ServletRequest)request, "Workflow version is not defined which means the workflow is not transfered");
            vwVersion = null;
        }
        Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
        return vwVersion;
    }

    public static VWAttachment createAttachment(HttpServletRequest request, String attachmentId) throws Exception {
        String methodName = "createAttachment";
        Logger.logEntry(P8Workflow.class, methodName, (ServletRequest)request);
        VWAttachment attachment = null;
        if (attachmentId != null && attachmentId.length() > 0) {
            int beginIndex = 0;
            int endIndex = attachmentId.indexOf(124);
            String attachmentName = attachmentId.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
            endIndex = attachmentId.indexOf(124, beginIndex);
            String attachmentDesc = attachmentId.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
            endIndex = attachmentId.indexOf(124, beginIndex);
            String attachmentType = attachmentId.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
            endIndex = attachmentId.indexOf(124, beginIndex);
            String objectStoreType = attachmentId.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
            endIndex = attachmentId.indexOf(124, beginIndex);
            String objectStoreId = attachmentId.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
            endIndex = attachmentId.length();
            String versionSeriesId = attachmentId.substring(beginIndex, endIndex);
            attachment = new VWAttachment();
            attachment.setAttachmentName(attachmentName);
            attachment.setAttachmentDescription(attachmentDesc);
            attachment.setType(Integer.parseInt(attachmentType));
            if (objectStoreType.equals("3")) {
                attachment.setLibraryType(3);
            } else {
                attachment.setLibraryType(6);
            }
            attachment.setLibraryName(objectStoreId);
            attachment.setId(versionSeriesId);
        }
        Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
        return attachment;
    }

    public static VWAttachment[] addMainAttachment(HttpServletRequest request, VWStepElement stepElement, VWParameter parameter, VWAttachment mainAttachment, String mainAttachmentParameterName) throws Exception {
        String methodName = "addMainAttachment";
        Logger.logEntry(P8Workflow.class, methodName, (ServletRequest)request);
        if (parameter.isArray()) {
            VWAttachment[] attachmentArray = (VWAttachment[])parameter.getValue();
            VWAttachment[] tempAttachArray = null;
            if (attachmentArray == null || attachmentArray.length == 1 && attachmentArray[0].getAttachmentName() == null) {
                tempAttachArray = new VWAttachment[]{mainAttachment};
            } else {
                VWAttachment[] attachArray = (VWAttachment[])parameter.getValue();
                tempAttachArray = new VWAttachment[attachArray.length + 1];
                for (int j = 0; j < attachArray.length; ++j) {
                    tempAttachArray[j] = attachArray[j];
                }
                tempAttachArray[attachArray.length] = mainAttachment;
            }
            stepElement.setParameterValue(mainAttachmentParameterName, (Object)tempAttachArray, false);
            Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
            return tempAttachArray;
        }
        stepElement.setParameterValue(mainAttachmentParameterName, (Object)mainAttachment, true);
        VWAttachment[] attachments = new VWAttachment[]{mainAttachment};
        Logger.logExit(P8Workflow.class, methodName, (ServletRequest)request);
        return attachments;
    }

    public static String getWorkflowAttachmentId(String objectStoreName, String id, String name, String objectType) {
        String attachmentId = objectType.equals("folder") ? name + "||2|3|" + objectStoreName + "|" + id : (objectType.equals("customobject") ? name + "||6|3|" + objectStoreName + "|" + id : name + "||3|3|" + objectStoreName + "|" + id);
        return attachmentId;
    }
}

