/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class P8WcmPrefsLabel {
    String localizationKey;
    String defaultResource;
    String keyAttribute;
    Map<String, String> resourceMap = new Hashtable<String, String>();
    boolean formatBundleResources = true;

    public P8WcmPrefsLabel() {
        this.defaultResource = "";
    }

    public P8WcmPrefsLabel(String defaultValue) {
        this.defaultResource = defaultValue;
    }

    public P8WcmPrefsLabel(Locale defaultLocale, String defaultValue) {
        this.defaultResource = defaultValue;
        this.setResource(defaultLocale, defaultValue);
    }

    public String getResource(Locale locale) {
        if (locale == null) {
            return this.defaultResource;
        }
        String key = locale.toString();
        String value = this.resourceMap.get(key);
        if (value == null && locale.getCountry().length() > 0) {
            value = this.resourceMap.get(locale.getLanguage());
        }
        if (value == null && value != null) {
            this.setResource(locale, value);
        }
        if (value == null) {
            this.setResource(locale, this.defaultResource);
            value = this.defaultResource;
        }
        return value;
    }

    public void setResource(Locale locale, String value) {
        if (value != null && locale != null) {
            String key = locale.toString();
            this.resourceMap.put(key, value);
            if (this.defaultResource == null) {
                this.defaultResource = value;
            }
        }
    }

    public boolean getFormatBundleResources() {
        return this.formatBundleResources;
    }

    public void setFormatBundleResources(boolean formatBundleResources) {
        this.formatBundleResources = formatBundleResources;
    }

    public String getKeyAttribute() {
        return this.keyAttribute;
    }

    public void setKeyAttribute(String keyAttribute) {
        this.keyAttribute = keyAttribute;
    }

    public String getDefaultResource() {
        return this.defaultResource;
    }

    public void setDefaultResource(String defaultResource) {
        this.defaultResource = defaultResource;
    }

    public static String[] toStringArray(P8WcmPrefsLabel[] labels, Locale locale) {
        String[] results = new String[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            P8WcmPrefsLabel label = labels[i];
            results[i] = label.getResource(locale);
        }
        return results;
    }

    public void clear() {
        this.resourceMap.clear();
    }
}

