/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.admin.ChoiceList;
import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.admin.PropertyTemplate;
import com.filenet.api.collection.AccessPermissionDescriptionList;
import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.BooleanList;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.DateTimeList;
import com.filenet.api.collection.Float64List;
import com.filenet.api.collection.IdList;
import com.filenet.api.collection.Integer32List;
import com.filenet.api.collection.PropertyDescriptionList;
import com.filenet.api.collection.StringList;
import com.filenet.api.constants.AccessType;
import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.PropertySettability;
import com.filenet.api.constants.TypeID;
import com.filenet.api.core.Containable;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.CustomObject;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.InstantiatingScope;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.core.Versionable;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.MetadataCache;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyBinary;
import com.filenet.api.property.PropertyBinaryList;
import com.filenet.api.property.PropertyBoolean;
import com.filenet.api.property.PropertyBooleanList;
import com.filenet.api.property.PropertyDateTime;
import com.filenet.api.property.PropertyDateTimeList;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.property.PropertyFloat64;
import com.filenet.api.property.PropertyFloat64List;
import com.filenet.api.property.PropertyId;
import com.filenet.api.property.PropertyIdList;
import com.filenet.api.property.PropertyInteger32;
import com.filenet.api.property.PropertyInteger32List;
import com.filenet.api.property.PropertyString;
import com.filenet.api.property.PropertyStringList;
import com.filenet.api.security.AccessPermission;
import com.filenet.api.security.AccessPermissionDescription;
import com.filenet.api.util.Id;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.core.DocumentImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectImpl;
import com.ibm.ecm.mediator.p8.P8DocumentMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8RetrieveDocumentAction;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8DocID;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8Util
extends Util {
    private static final Collator COLLATOR = Collator.getInstance();
    private static final String VERSION_STATUS_LOOKUP_ID = "{BFF36187-91DF-4F90-BAC5-CD5B3F3C6D8A}";
    private static final String LOOKUP_LIST_PROPERTY = "LookupList";
    public static final String DOCID_SEPARATOR = ",";

    public static void setProperties(HttpServletRequest request, IndependentObject item, JSONArray criterias, ClassDescription classDescription) throws Exception {
        String methodName = "setProperties";
        Logger.logEntry(P8Util.class, methodName, (ServletRequest)request);
        JSONObject criteria = null;
        PropertyDescriptionList propertyDescriptionList = classDescription.get_PropertyDescriptions();
        HashMap<String, PropertyDescription> propDescsMap = new HashMap<String, PropertyDescription>();
        PropertyDescription propertyDescription = null;
        for (int i = 0; i < propertyDescriptionList.size(); ++i) {
            propertyDescription = (PropertyDescription)propertyDescriptionList.get(i);
            propDescsMap.put(propertyDescription.get_SymbolicName(), propertyDescription);
        }
        Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "criterias.size()" + criterias.size());
        Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "adding the attribute values for the newly created item");
        for (int iCriteriaCounter = 0; iCriteriaCounter < criterias.size(); ++iCriteriaCounter) {
            Comparable<Date> value;
            criteria = (JSONObject)criterias.get(iCriteriaCounter);
            String criteriaName = criteria.get("name").toString();
            ArrayList valuesJsonArray = null;
            Object valuesJson = criteria.get("value");
            if (valuesJson == null) {
                valuesJson = criteria.get("values");
            }
            if (valuesJson != null) {
                if (valuesJson instanceof JSONArray) {
                    valuesJsonArray = (JSONArray)valuesJson;
                } else {
                    valuesJsonArray = new JSONArray();
                    ((JSONArray)valuesJsonArray).add(valuesJson.toString());
                }
            }
            String criteriaValue = valuesJsonArray.isEmpty() || valuesJsonArray.get(0) == null ? "" : valuesJsonArray.get(0).toString();
            Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "update Item: attrName=" + criteriaName + " attrValue=" + criteriaValue);
            propertyDescription = (PropertyDescription)propDescsMap.get(criteriaName);
            Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "criteriaName=" + criteriaName + "  criteriaValue=" + criteriaValue);
            if (criteriaName.equalsIgnoreCase("FolderName") && item instanceof Folder) {
                ((Folder)item).set_FolderName(criteriaValue);
                continue;
            }
            if (propertyDescription == null || propertyDescription.get_IsReadOnly().booleanValue() || criteriaValue == null) continue;
            Properties itemProperties = item.getProperties();
            String propertyName = propertyDescription.get_SymbolicName();
            TypeID type = propertyDescription.get_DataType();
            if (criteriaValue.length() < 1) {
                if (propertyDescription.get_Settability() == PropertySettability.SETTABLE_ONLY_BEFORE_CHECKIN || propertyDescription.get_Settability() == PropertySettability.SETTABLE_ONLY_ON_CREATE) continue;
                itemProperties.putObjectValue(propertyName, null);
                continue;
            }
            Cardinality cardinality = propertyDescription.get_Cardinality();
            if (cardinality.getValue() == 2) {
                String value2;
                int j;
                StringList list;
                ChoiceList choiceList = propertyDescription.get_ChoiceList();
                if (choiceList != null) {
                    if (choiceList.get_DataType().equals(TypeID.STRING)) {
                        list = Factory.StringList.createList();
                        for (j = 0; j < valuesJsonArray.size(); ++j) {
                            value2 = (String)valuesJsonArray.get(j);
                            list.add((Object)value2);
                        }
                        itemProperties.putObjectValue(propertyName, (Object)list);
                        continue;
                    }
                    if (!choiceList.get_DataType().equals(TypeID.LONG)) continue;
                    list = Factory.Integer32List.createList();
                    for (j = 0; j < valuesJsonArray.size(); ++j) {
                        value2 = (String)valuesJsonArray.get(j);
                        list.add((Object)new Integer(value2));
                    }
                    itemProperties.putObjectValue(propertyName, (Object)list);
                    continue;
                }
                if (propertyDescription.get_Settability() != PropertySettability.SETTABLE_ONLY_BEFORE_CHECKIN && propertyDescription.get_Settability() != PropertySettability.SETTABLE_ONLY_ON_CREATE) {
                    if (type == TypeID.BOOLEAN) {
                        list = Factory.BooleanList.createList();
                        for (j = 0; j < valuesJsonArray.size(); ++j) {
                            value2 = (String)valuesJsonArray.get(j);
                            list.add((Object)new Boolean(value2));
                        }
                        itemProperties.putObjectValue(propertyName, (Object)list);
                        continue;
                    }
                    if (type == TypeID.DATE) {
                        list = Factory.DateTimeList.createList();
                        for (j = 0; j < valuesJsonArray.size(); ++j) {
                            value2 = (String)valuesJsonArray.get(j);
                            list.add((Object)DateUtil.parseISODate(value2, true));
                        }
                        itemProperties.putObjectValue(propertyName, (Object)list);
                        continue;
                    }
                    if (type == TypeID.LONG) {
                        list = Factory.Integer32List.createList();
                        for (j = 0; j < valuesJsonArray.size(); ++j) {
                            value2 = (String)valuesJsonArray.get(j);
                            list.add((Object)new Integer(value2));
                        }
                        itemProperties.putObjectValue(propertyName, (Object)list);
                        continue;
                    }
                    if (type == TypeID.DOUBLE) {
                        list = Factory.Float64List.createList();
                        for (j = 0; j < valuesJsonArray.size(); ++j) {
                            value2 = (String)valuesJsonArray.get(j);
                            list.add((Object)new Double(value2));
                        }
                        itemProperties.putObjectValue(propertyName, (Object)list);
                        continue;
                    }
                    if (type == TypeID.GUID) {
                        list = Factory.IdList.createList();
                        for (j = 0; j < valuesJsonArray.size(); ++j) {
                            value2 = (String)valuesJsonArray.get(j);
                            list.add((Object)new Id(value2));
                        }
                        itemProperties.putObjectValue(propertyName, (Object)list);
                        continue;
                    }
                    list = Factory.StringList.createList();
                    for (j = 0; j < valuesJsonArray.size(); ++j) {
                        value2 = (String)valuesJsonArray.get(j);
                        list.add((Object)value2);
                    }
                    itemProperties.putObjectValue(propertyName, (Object)list);
                    continue;
                }
                if (type == TypeID.BOOLEAN) {
                    list = Factory.BooleanList.createList();
                    for (j = 0; j < valuesJsonArray.size(); ++j) {
                        value2 = (String)valuesJsonArray.get(j);
                        list.add((Object)new Boolean(value2));
                    }
                    itemProperties.putObjectValue(propertyName, (Object)list);
                    continue;
                }
                if (type == TypeID.DATE) {
                    list = Factory.DateTimeList.createList();
                    for (j = 0; j < valuesJsonArray.size(); ++j) {
                        value2 = (String)valuesJsonArray.get(j);
                        list.add((Object)DateUtil.parseISODate(value2, true));
                    }
                    itemProperties.putObjectValue(propertyName, (Object)list);
                    continue;
                }
                if (type == TypeID.LONG) {
                    list = Factory.Integer32List.createList();
                    for (j = 0; j < valuesJsonArray.size(); ++j) {
                        value2 = (String)valuesJsonArray.get(j);
                        list.add((Object)new Integer(value2));
                    }
                    itemProperties.putObjectValue(propertyName, (Object)list);
                    continue;
                }
                if (type == TypeID.DOUBLE) {
                    list = Factory.Float64List.createList();
                    for (j = 0; j < valuesJsonArray.size(); ++j) {
                        value2 = (String)valuesJsonArray.get(j);
                        list.add((Object)new Double(value2));
                    }
                    itemProperties.putObjectValue(propertyName, (Object)list);
                    continue;
                }
                if (type == TypeID.GUID) {
                    list = Factory.IdList.createList();
                    for (j = 0; j < valuesJsonArray.size(); ++j) {
                        value2 = (String)valuesJsonArray.get(j);
                        list.add((Object)new Id(value2));
                    }
                    itemProperties.putObjectValue(propertyName, (Object)list);
                    continue;
                }
                list = Factory.StringList.createList();
                for (j = 0; j < valuesJsonArray.size(); ++j) {
                    value2 = (String)valuesJsonArray.get(j);
                    list.add((Object)value2);
                }
                itemProperties.putObjectValue(propertyName, (Object)list);
                continue;
            }
            if (type == TypeID.DATE) {
                value = DateUtil.parseISODate(criteriaValue, true);
                itemProperties.putObjectValue(propertyName, (Object)value);
                continue;
            }
            if (type == TypeID.DOUBLE) {
                value = new Double(criteriaValue);
                itemProperties.putObjectValue(propertyName, (Object)value);
                continue;
            }
            if (type == TypeID.LONG) {
                value = new Integer(criteriaValue);
                itemProperties.putObjectValue(propertyName, (Object)value);
                continue;
            }
            if (type == TypeID.GUID) {
                value = new Id(criteriaValue);
                itemProperties.putObjectValue(propertyName, (Object)value);
                continue;
            }
            if (type == TypeID.BOOLEAN) {
                value = new Boolean(criteriaValue);
                itemProperties.putObjectValue(propertyName, (Object)value);
                continue;
            }
            itemProperties.putObjectValue(propertyName, (Object)criteriaValue);
        }
        Logger.logExit(P8Util.class, methodName, (ServletRequest)request);
    }

    public static P8Connection getConnection(HttpServletRequest request, String serverName) {
        String methodName = "getConnection";
        Logger.logEntry(P8Util.class, methodName, (ServletRequest)request);
        HttpSession session = request.getSession(false);
        P8Connection connection = null;
        if (session != null) {
            Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "HttpSession ID is: " + session.getId());
            Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "serverName: " + serverName);
            Hashtable connectionList = (Hashtable)session.getAttribute("p8_servers");
            if (connectionList != null && serverName != null) {
                connection = (P8Connection)connectionList.get(serverName);
            }
        }
        Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "Returning connection: " + connection);
        Logger.logExit(P8Util.class, methodName, (ServletRequest)request);
        return connection;
    }

    public static P8Connection getConnection(HttpServletRequest request) {
        return P8Util.getConnection(request, request.getParameter("repositoryId"));
    }

    public static PropertyDescription getPropertyDescription(ClassDescription classDescription, String symbolicName) {
        return P8Util.getPropertyDescription(classDescription.get_PropertyDescriptions(), symbolicName);
    }

    private static PropertyDescription getPropertyDescription(PropertyDescriptionList propertyDescriptionList, String symbolicName) {
        for (PropertyDescription propertyDescription : propertyDescriptionList) {
            String descriptionName = propertyDescription.get_SymbolicName();
            if (!descriptionName.equals(symbolicName)) continue;
            return propertyDescription;
        }
        return null;
    }

    public static PropertyDescription getPropertyDescription(ClassDescription classDescription, Property property) {
        String symbolicName = property.getPropertyName();
        return P8Util.getPropertyDescription(classDescription, symbolicName);
    }

    public static Vector getItemsFromJson(String jsonString) {
        String methodName = "getItemsFromJson";
        Vector<String> items = null;
        try {
            JSONArray jsonArray = JSONArray.parse(jsonString);
            items = new Vector<String>(jsonArray.size());
            for (int i = 0; i < jsonArray.size(); ++i) {
                String value = jsonArray.get(i).toString();
                items.add(value);
            }
        }
        catch (IOException e) {
            Logger.logError(P8Util.class, methodName, (ServletRequest)((HttpServletRequest)null), (Throwable)e);
        }
        return items;
    }

    public static Object getValue(Property property) {
        Object returnVal = null;
        if (property instanceof PropertyIdList) {
            IdList idList = property.getIdListValue();
            if (idList != null) {
                Iterator iterator = idList.iterator();
                String[] array = new String[idList.size()];
                int i = 0;
                while (iterator.hasNext()) {
                    Id id = (Id)iterator.next();
                    array[i] = id.toString();
                    ++i;
                }
                returnVal = array;
            }
        } else if (property instanceof PropertyBooleanList) {
            BooleanList booleanList = property.getBooleanListValue();
            if (booleanList != null) {
                Iterator iterator = booleanList.iterator();
                String[] array = new String[booleanList.size()];
                int i = 0;
                while (iterator.hasNext()) {
                    Boolean bool = (Boolean)iterator.next();
                    array[i] = bool.toString();
                    ++i;
                }
                returnVal = array;
            }
        } else if (property instanceof PropertyDateTimeList) {
            DateTimeList dateTimeList = property.getDateTimeListValue();
            if (dateTimeList != null) {
                Iterator iterator = dateTimeList.iterator();
                String[] array = new String[dateTimeList.size()];
                int i = 0;
                while (iterator.hasNext()) {
                    Date date = (Date)iterator.next();
                    array[i] = "" + DateUtil.getISODateString(date, true);
                    ++i;
                }
                returnVal = array;
            }
        } else if (property instanceof PropertyFloat64List) {
            Float64List floatList = property.getFloat64ListValue();
            if (floatList != null) {
                Iterator iterator = floatList.iterator();
                String[] array = new String[floatList.size()];
                int i = 0;
                while (iterator.hasNext()) {
                    Double d = (Double)iterator.next();
                    array[i] = d.toString();
                    ++i;
                }
                returnVal = array;
            }
        } else if (property instanceof PropertyInteger32List || property instanceof PropertyStringList) {
            Integer32List list;
            Object object = list = property instanceof PropertyInteger32List ? property.getInteger32ListValue() : property.getStringListValue();
            if (list != null) {
                Iterator iterator = list.iterator();
                String[] array = new String[list.size()];
                int i = 0;
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    array[i] = value.toString();
                    ++i;
                }
                returnVal = array;
            }
        } else if (property instanceof PropertyEngineObjectImpl) {
            EngineObject engObj = property.getEngineObjectValue();
            if (engObj != null) {
                if (property.getObjectValue() instanceof DocumentImpl) {
                    returnVal = ((DocumentImpl)property.getObjectValue()).get_Name();
                } else if (property.getObjectValue() instanceof Containable) {
                    returnVal = ((Containable)property.getObjectValue()).get_Name();
                }
            }
        } else if (!(property instanceof PropertyBinary) && !(property instanceof PropertyBinaryList)) {
            if (property instanceof PropertyId) {
                if (property.getIdValue() != null) {
                    returnVal = property.getIdValue().toString();
                }
            } else if (property instanceof PropertyBoolean) {
                if (property.getBooleanValue() != null) {
                    returnVal = property.getBooleanValue().toString();
                }
            } else if (property instanceof PropertyDateTime) {
                if (property.getDateTimeValue() != null) {
                    returnVal = DateUtil.getISODateString(property.getDateTimeValue(), true);
                }
            } else if (property instanceof PropertyFloat64) {
                if (property.getFloat64Value() != null) {
                    returnVal = property.getFloat64Value().toString();
                }
            } else if (property instanceof PropertyInteger32 || property instanceof PropertyString) {
                Object value = null;
                if (property instanceof PropertyInteger32) {
                    value = property.getInteger32Value();
                } else if (property instanceof PropertyString) {
                    value = property.getStringValue();
                }
                if (value != null) {
                    returnVal = value.toString().trim();
                }
            }
        }
        if (returnVal == null) {
            returnVal = "";
        }
        return returnVal;
    }

    public static List<String> getVersionStatusLookups(HttpServletRequest request, ObjectStore objectStore) {
        String key = "_versionStatusLookup" + objectStore.get_Id();
        List vs = (List)request.getAttribute(key);
        if (vs == null) {
            PropertyFilter propertyFilter = new PropertyFilter();
            propertyFilter.addIncludeProperty(1, null, null, LOOKUP_LIST_PROPERTY, null);
            CustomObject customObj = Factory.CustomObject.fetchInstance((ObjectStore)objectStore, (Id)new Id(VERSION_STATUS_LOOKUP_ID), (PropertyFilter)propertyFilter);
            Properties properties = customObj.getProperties();
            vs = properties.getStringListValue(LOOKUP_LIST_PROPERTY);
            request.setAttribute(key, (Object)vs);
        }
        return vs;
    }

    public static TypeID getTypeId(String dataType) {
        TypeID typeId = TypeID.STRING;
        if (dataType.equalsIgnoreCase("xs:binary")) {
            typeId = TypeID.BINARY;
        } else if (dataType.equalsIgnoreCase("xs:boolean")) {
            typeId = TypeID.BOOLEAN;
        } else if (dataType.equalsIgnoreCase("xs:timestamp")) {
            typeId = TypeID.DATE;
        } else if (dataType.equalsIgnoreCase("xs:double")) {
            typeId = TypeID.DOUBLE;
        } else if (dataType.equalsIgnoreCase("xs:guid")) {
            typeId = TypeID.GUID;
        } else if (dataType.equalsIgnoreCase("xs:long")) {
            typeId = TypeID.LONG;
        } else if (dataType.equalsIgnoreCase("xs:object")) {
            typeId = TypeID.OBJECT;
        } else if (dataType.equalsIgnoreCase("xs:string")) {
            typeId = TypeID.STRING;
        }
        return typeId;
    }

    public static String getDataType(TypeID typeId) {
        String dataType = "xs:string";
        if (typeId == TypeID.BINARY) {
            dataType = "xs:binary";
        } else if (typeId == TypeID.BOOLEAN) {
            dataType = "xs:boolean";
        } else if (typeId == TypeID.DATE) {
            dataType = "xs:timestamp";
        } else if (typeId == TypeID.DOUBLE) {
            dataType = "xs:double";
        } else if (typeId == TypeID.GUID) {
            dataType = "xs:guid";
        } else if (typeId == TypeID.LONG) {
            dataType = "xs:long";
        } else if (typeId == TypeID.OBJECT) {
            dataType = "xs:object";
        } else if (typeId == TypeID.STRING) {
            dataType = "xs:string";
        }
        return dataType;
    }

    public static String getDataType(PropertyDescription propertyDescription) {
        return P8Util.getDataType(propertyDescription.get_DataType());
    }

    public static boolean isNumericDataType(PropertyDescription propertyDescription) {
        String dataType = P8Util.getDataType(propertyDescription);
        return dataType.equals("xs:double") || dataType.equals("xs:long");
    }

    public static String getDocId(ObjectReference ref) {
        String objectReferenceId = ref.getClassIdentity();
        if (objectReferenceId.equals("QuickrLibrary")) {
            objectReferenceId = "Folder";
        }
        return objectReferenceId + DOCID_SEPARATOR + ref.getObjectStoreIdentity() + DOCID_SEPARATOR + ref.getObjectIdentity();
    }

    public static String getDocId(String className, String objectStoreId, String id) {
        return className + DOCID_SEPARATOR + objectStoreId + DOCID_SEPARATOR + id;
    }

    public static String getObjectIdentity(String id) {
        int firstSeparator = id.indexOf(DOCID_SEPARATOR);
        if (firstSeparator == -1) {
            return id;
        }
        int secondSeparator = id.indexOf(DOCID_SEPARATOR, firstSeparator + 1);
        if (secondSeparator == -1) {
            return id;
        }
        String objectIdentity = id.substring(secondSeparator + 1);
        return objectIdentity;
    }

    public static String getObjectStoreIdentity(String id) {
        int firstSeparator = id.indexOf(DOCID_SEPARATOR);
        if (firstSeparator == -1) {
            return null;
        }
        int secondSeparator = id.indexOf(DOCID_SEPARATOR, firstSeparator + 1);
        if (secondSeparator == -1) {
            return null;
        }
        String objectStoreIdentity = id.substring(firstSeparator + 1, secondSeparator);
        return objectStoreIdentity;
    }

    public static ObjectStore getObjectStore(P8Connection connection, String objectStoreIdOrName) {
        ObjectStore os = connection.getObjectStore(objectStoreIdOrName);
        if (os != null) {
            return os;
        }
        Domain defaultDomain = connection.getDomain();
        if (Id.isId((String)objectStoreIdOrName)) {
            os = Factory.ObjectStore.fetchInstance((Domain)defaultDomain, (Id)new Id(objectStoreIdOrName), null);
        } else {
            os = Factory.ObjectStore.fetchInstance((Domain)defaultDomain, (String)objectStoreIdOrName, null);
            ObjectStore storedOS = connection.getObjectStore(os.get_Id().toString());
            if (storedOS != null) {
                os = storedOS;
            }
        }
        connection.addObjectStore(objectStoreIdOrName, os);
        return os;
    }

    public static ObjectStore getObjectStore(HttpServletRequest request, P8Connection connection, String itemId) {
        String osId;
        String string = osId = itemId != null && itemId.length() > 0 ? P8Util.getObjectStoreIdentity(itemId) : null;
        if (osId == null) {
            osId = request.getParameter("objectStoreId");
        }
        ObjectStore os = osId != null && osId.length() > 0 ? P8Util.getObjectStore(connection, osId) : connection.getObjectStore();
        return os;
    }

    public static String getObjectStoreIdentityFromName(P8Connection connection, String objectStoreName) {
        ObjectStore os = P8Util.getObjectStore(connection, objectStoreName);
        return os != null ? os.get_Id().toString() : null;
    }

    public static IndependentlyPersistableObject getPersistableObject(HttpServletRequest request, P8Connection connection, String docId, String vsId, String version) {
        IndependentlyPersistableObject independentlyPersistableObject = null;
        if (!(vsId != null && vsId.length() != 0 || version != null && version.length() != 0)) {
            independentlyPersistableObject = P8Util.getPersistableObject(request, connection, docId);
        } else {
            Versionable vsObject = P8Util.getFromVersionSeries(request, connection, new P8DocID(docId), vsId, version, null);
            if (vsObject instanceof IndependentlyPersistableObject) {
                independentlyPersistableObject = (IndependentlyPersistableObject)vsObject;
            }
        }
        return independentlyPersistableObject;
    }

    public static IndependentlyPersistableObject getPersistableObject(HttpServletRequest request, P8Connection connection, String docId) {
        ObjectStore os = P8Util.getObjectStore(request, connection, docId);
        return P8Util.getPersistableObject(os, connection, docId);
    }

    public static IndependentlyPersistableObject getPersistableObject(ObjectStore objectStore, P8Connection connection, String docId) {
        Object independentlyPersistableObject;
        String methodName = "IndependentlyPersistableObject(objectStore,connection,docId)";
        if (docId.startsWith("/")) {
            return Factory.Folder.fetchInstance((ObjectStore)objectStore, (String)docId, null);
        }
        String classIdentity = null;
        String objectIdentity = null;
        int idSeparator = docId.indexOf(DOCID_SEPARATOR);
        if (idSeparator == -1) {
            objectIdentity = docId;
        } else {
            P8DocID p8DocID = new P8DocID(docId);
            classIdentity = p8DocID.getClassID();
            objectIdentity = p8DocID.getObjectID();
            String objectStoreId = p8DocID.getObjectStoreID();
            if (!objectStoreId.equals(objectStore.get_Id().toString())) {
                objectStore = P8Util.getObjectStore(connection, objectStoreId);
            }
        }
        Id id = new Id(objectIdentity);
        if (classIdentity != null) {
            ClassDescription classDescription;
            independentlyPersistableObject = classIdentity.equalsIgnoreCase("Document") ? Factory.Document.fetchInstance((ObjectStore)objectStore, (Id)id, null) : (classIdentity.equalsIgnoreCase("Folder") ? Factory.Folder.fetchInstance((ObjectStore)objectStore, (Id)id, null) : ((classDescription = Factory.ClassDescription.fetchInstance((Scope)objectStore, (String)classIdentity, null)).describedIsOfClass("Document").booleanValue() ? Factory.Document.fetchInstance((ObjectStore)objectStore, (Id)id, null) : (classDescription.describedIsOfClass("Folder").booleanValue() ? Factory.Folder.fetchInstance((ObjectStore)objectStore, (Id)id, null) : Factory.CustomObject.fetchInstance((ObjectStore)objectStore, (Id)id, null))));
        } else {
            try {
                independentlyPersistableObject = Factory.Document.fetchInstance((ObjectStore)objectStore, (Id)id, null);
            }
            catch (Exception e) {
                try {
                    independentlyPersistableObject = Factory.Folder.fetchInstance((ObjectStore)objectStore, (Id)id, null);
                }
                catch (Exception e2) {
                    independentlyPersistableObject = Factory.CustomObject.fetchInstance((ObjectStore)objectStore, (Id)id, null);
                }
            }
        }
        return independentlyPersistableObject;
    }

    public static Document getDocument(HttpServletRequest request, P8Connection connection, String docID) {
        P8DocID p8DocID = new P8DocID(docID);
        return P8Util.getDocument(request, connection, p8DocID, null, null, null, null);
    }

    public static Document getDocument(HttpServletRequest request, P8Connection connection, P8DocID p8DocID, String vsId, String version, P8DocumentMediator documentMediator, PropertyFilter filter) {
        String methodName = "getDocument";
        String objectStoreIdentity = p8DocID.getObjectStoreID();
        Document document = null;
        if (vsId == null || vsId.length() == 0) {
            String objectIdentity = p8DocID.getObjectID();
            Id id = new Id(objectIdentity);
            ObjectStore os = P8Util.getObjectStore(request, connection, p8DocID.toString());
            Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "Retrieving the document using docver id " + objectIdentity + " in objectstore " + objectStoreIdentity + " (vsId was not specified)");
            document = Factory.Document.fetchInstance((ObjectStore)os, (Id)id, (PropertyFilter)filter);
        } else {
            Versionable vsObject = P8Util.getFromVersionSeries(request, connection, p8DocID, vsId, version, filter);
            if (!(vsObject instanceof Document)) {
                String className = vsObject.getClass().getName();
                Logger.logError((Object)vsObject, methodName, (ServletRequest)request, "Expected a Document, but returned object is: " + className);
                if (documentMediator != null) {
                    documentMediator.addError("viewingServices.verSeriesErrorOnRetrieve", vsId, objectStoreIdentity, className);
                }
            } else {
                document = (Document)vsObject;
            }
        }
        return document;
    }

    private static Versionable getFromVersionSeries(HttpServletRequest request, P8Connection connection, P8DocID p8DocID, String vsId, String version, PropertyFilter propertyFilter) {
        String methodName = "getFromVersionSeries";
        String objectStoreIdentity = p8DocID.getObjectStoreID();
        ObjectStore os = P8Util.getObjectStore(request, connection, p8DocID.toString());
        Id id = new Id(vsId);
        VersionSeries versionSeries = Factory.VersionSeries.fetchInstance((ObjectStore)os, (Id)id, (PropertyFilter)propertyFilter);
        Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "Retrieving the document using version series id " + vsId + " in objectstore " + objectStoreIdentity);
        Versionable vsObject = null;
        if (version == null || version.equalsIgnoreCase("released")) {
            Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "Checking for releasedVersion of versionSeries " + vsId);
            vsObject = versionSeries.get_ReleasedVersion();
        }
        if (vsObject == null) {
            Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "Getting the currentVersion of versionSeries " + vsId);
            vsObject = versionSeries.get_CurrentVersion();
        }
        return vsObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getContentElementList(HttpServletRequest request, P8Connection p8Connection, P8DocID p8DocID, String vsId, String version) {
        ArrayList<Integer> contentElementList = new ArrayList<Integer>();
        try {
            UserContext.get().pushSubject(p8Connection.getSubject());
            Document document = P8Util.getDocument(request, p8Connection, p8DocID, vsId, version, null, null);
            if (document != null) {
                StringList list = document.get_ContentElementsPresent();
                if (list.size() > 1) {
                    ContentElementList p8ContentElementList = document.get_ContentElements();
                    for (int idx = 0; idx < p8ContentElementList.size(); ++idx) {
                        if (!(p8ContentElementList.get(idx) instanceof ContentTransfer)) continue;
                        contentElementList.add(idx);
                    }
                }
                P8RetrieveDocumentAction.saveAsLastDocument(request.getSession(), document, p8DocID.getObjectID(), vsId, version);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            UserContext.get().popSubject();
            throw throwable;
        }
        UserContext.get().popSubject();
        return contentElementList;
    }

    public static Folder getFolder(HttpServletRequest request, P8Connection connection, String docId) {
        int firstSeparator = docId.indexOf(DOCID_SEPARATOR);
        int secondSeparator = docId.indexOf(DOCID_SEPARATOR, firstSeparator + 1);
        String objectIdentity = docId.substring(secondSeparator + 1);
        Id id = new Id(objectIdentity);
        return Factory.Folder.fetchInstance((ObjectStore)P8Util.getObjectStore(request, connection, docId), (Id)id, null);
    }

    public static String getFolderPathName(ObjectStore objectStore, String folderId) {
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(0, null, null, "PathName", null);
        Folder ceFolder = (Folder)objectStore.fetchObject("Folder", folderId, pf);
        return ceFolder.get_PathName();
    }

    public static ClassDescription getCachedCD(ObjectStore objectStore, String className) {
        MetadataCache cmc = Factory.MetadataCache.getDefaultInstance();
        return cmc.getClassDescription((InstantiatingScope)objectStore, className);
    }

    public static boolean isDocumentClass(ClassDescription cd) {
        MetadataCache cmc = Factory.MetadataCache.getDefaultInstance();
        return cmc.describedIsOfClass(cd, "Document");
    }

    public static boolean isFolderClass(ClassDescription cd) {
        MetadataCache cmc = Factory.MetadataCache.getDefaultInstance();
        return cmc.describedIsOfClass(cd, "Folder");
    }

    public static String getClassDisplayName(ObjectStore objectStore, String className) {
        ClassDescription cd = P8Util.getCachedCD(objectStore, className);
        return cd.get_DisplayName();
    }

    static String getPropertyDisplayName(ObjectStore objectStore, String className, String propertyName) {
        String displayName = null;
        ClassDescription cd = P8Util.getCachedCD(objectStore, className);
        PropertyDescription pd = P8Util.getPropertyDescription(cd, propertyName);
        if (pd == null) {
            PropertyDescriptionList pds = P8Util.getPropertyDescriptions(cd, "ProperSubclassPropertyDescriptions");
            pd = P8Util.getPropertyDescription(pds, propertyName);
        }
        if (pd != null) {
            displayName = pd.get_DisplayName();
        }
        return displayName;
    }

    public static String getPropertyDisplayName(HttpServletRequest request, PropertyDescription propertyDescription) {
        String displayName = propertyDescription.get_DisplayName();
        if (propertyDescription.get_IsSystemOwned().booleanValue()) {
            String customLabel;
            if (P8Util.isDefaultLabel(propertyDescription.get_SymbolicName())) {
                String messageKey = "systemp8." + propertyDescription.get_SymbolicName() + ".defaultLabel";
                displayName = MessageUtil.getMessage(request.getLocale(), messageKey);
            }
            if ((customLabel = BaseUtil.getCustomLabelValue(request, "sys_" + propertyDescription.get_SymbolicName())) != null) {
                displayName = customLabel;
            }
        }
        return displayName;
    }

    public static ArrayList<PropertyDescription> getPropertyDescriptions(ClassDescription classDesc, boolean includeSubclasses, boolean sort, boolean searchableOnly, boolean systemOnly, boolean includeOVPBinary) {
        ArrayList propertyDescriptionList = new ArrayList();
        PropertyDescriptionList pdl = P8Util.getPropertyDescriptions(classDesc, "PropertyDescriptions");
        propertyDescriptionList.addAll(pdl);
        if (includeSubclasses) {
            PropertyDescriptionList pdlSubclasses = P8Util.getPropertyDescriptions(classDesc, "ProperSubclassPropertyDescriptions");
            propertyDescriptionList.addAll(pdlSubclasses);
        }
        int capacity = propertyDescriptionList.size();
        HashMap propertyDescriptionMap = sort ? new LinkedHashMap(capacity) : new HashMap(capacity);
        TreeMap sortedMap = sort ? new TreeMap(COLLATOR) : null;
        ArrayList<PropertyDescription> pdl1 = new ArrayList<PropertyDescription>();
        Object locale = null;
        for (PropertyDescription propertyDesc : propertyDescriptionList) {
            if (!propertyDesc.get_IsSearchable().booleanValue() && searchableOnly || !propertyDesc.get_IsSystemOwned().booleanValue() && systemOnly || !includeOVPBinary && (propertyDesc.get_DataType() == TypeID.OBJECT || propertyDesc.get_DataType() == TypeID.BINARY)) continue;
            if (sort) {
                String displayName = null;
                if (displayName == null) {
                    displayName = propertyDesc.get_DisplayName();
                }
                if (sortedMap.containsKey(displayName)) {
                    ArrayList<Object> list;
                    Object value = sortedMap.get(displayName);
                    if (value instanceof List) {
                        list = (ArrayList<Object>)value;
                    } else {
                        list = new ArrayList<Object>();
                        list.add(value);
                        sortedMap.put(displayName, list);
                    }
                    list.add(propertyDesc);
                    continue;
                }
                sortedMap.put(displayName, propertyDesc);
                continue;
            }
            pdl1.add(propertyDesc);
        }
        if (sort) {
            for (String key : sortedMap.keySet()) {
                Object value = sortedMap.get(key);
                if (value instanceof List) {
                    List pds = (List)value;
                    for (PropertyDescription propertyDesc : pds) {
                        propertyDescriptionMap.put(propertyDesc.get_SymbolicName(), propertyDesc);
                    }
                    continue;
                }
                PropertyDescription propertyDesc = (PropertyDescription)value;
                propertyDescriptionMap.put(propertyDesc.get_SymbolicName(), propertyDesc);
            }
            for (PropertyDescription p : propertyDescriptionMap.values()) {
                pdl1.add(p);
            }
        }
        return pdl1;
    }

    private static PropertyDescriptionList getPropertyDescriptions(ClassDescription classDesc, String propName) {
        PropertyDescriptionList pdl;
        Properties classDescProperties = classDesc.getProperties();
        if (classDescProperties.isPropertyPresent(propName)) {
            Property prop = classDescProperties.get(propName);
            pdl = (PropertyDescriptionList)prop.getObjectValue();
        } else {
            PropertyFilter pf = new PropertyFilter();
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "SymbolicName", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "DisplayName", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "DataType", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Cardinality", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "IsOrderable", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "IsSystemOwned", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "UsesLongColumn", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "IsSearchable", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "MarkingSet", null));
            Property prop = classDesc.fetchProperty(propName, pf);
            pdl = (PropertyDescriptionList)prop.getObjectValue();
        }
        return pdl;
    }

    public static List<AccessPermissionDescription> getPermissionsDescriptions(ClassDescription classDesc) {
        ArrayList<AccessPermissionDescription> permissionDescriptions = new ArrayList<AccessPermissionDescription>();
        AccessPermissionDescriptionList apdl = classDesc.get_PermissionDescriptions();
        for (AccessPermissionDescription apd : apdl) {
            permissionDescriptions.add(apd);
        }
        return permissionDescriptions;
    }

    public static int getPropertyIntegerValue(IndependentObject object, String propertyName) {
        Properties props = object.getProperties();
        if (!props.isPropertyPresent(propertyName)) {
            object.fetchProperties(new String[]{propertyName});
            props = object.getProperties();
        }
        return props.isPropertyPresent(propertyName) ? props.getInteger32Value(propertyName) : null;
    }

    public static boolean isDefaultLabel(String propertyName) {
        String[] defaultLabels = new String[]{"Creator", "DateCreated", "LastModifier", "DateLastModified", "IsReserved", "MajorVersionNumber", "MinorVersionNumber", "ContentSize", "MimeType"};
        for (int i = 0; i < defaultLabels.length; ++i) {
            if (!defaultLabels[i].equalsIgnoreCase(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static void appendAccessPermission(AccessPermissionList apl, String user, int accessmask, AccessType type, int inheritableDepth) {
        AccessPermission ap = Factory.AccessPermission.createInstance();
        ap.set_AccessMask(Integer.valueOf(accessmask));
        ap.set_AccessType(type);
        ap.set_InheritableDepth(Integer.valueOf(inheritableDepth));
        ap.set_GranteeName(user);
        apl.add((Object)ap);
    }

    public static boolean classAllowsInstances(ObjectStore objectStore, ClassDescription classDescription) {
        boolean allowsInstances = classDescription.getProperties().getBooleanValue("AllowsInstances");
        if (allowsInstances) {
            PropertyFilter pf = new PropertyFilter();
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(0), null, null, "Id", null));
            ClassDefinition classDefinition = Factory.ClassDefinition.fetchInstance((ObjectStore)objectStore, (String)classDescription.get_SymbolicName(), (PropertyFilter)pf);
            allowsInstances = (classDefinition.getAccessAllowed() & 0x100) == 256;
        }
        return allowsInstances;
    }

    public static PropertyTemplate getPropertyTemplate(ObjectStore objectStore, Id propertyId) {
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Id", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(0), null, null, "Name", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(0), null, null, "ChoiceList", null));
        PropertyTemplate propTemplate = Factory.PropertyTemplate.fetchInstance((ObjectStore)objectStore, (Id)propertyId, (PropertyFilter)pf);
        return propTemplate;
    }
}

