/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectStore;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.p8.P8CeSearchUtilProxy;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SearchDefinition;
import com.ibm.ecm.util.p8.P8Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class P8TextSearchUtil {
    private static final char[] VERITY_SPECIAL_CHARS = new char[]{',', '(', ')', '[', '{', '=', '>', '<', '!', '`', '\'', '@', '/', '\\', '&', '|', '-'};
    private static final char[] TEXT_SPECIAL_CHARS = new char[]{'^', ':', '_', '(', ')', '~', '#', '$', '%', '&', '@', '[', ']', '{', '}', '!', '\\', '=', '/', '<', '>', ';', '\'', '|', '.', ',', '+', '-'};
    private static final String[] CONTENT_RESERVED_WORDS = new String[]{"AND", "OR", "NOT", "&&", "||"};
    private static final char QUESTION_MARK = '?';
    static final char QUOTE_CHAR = '\"';
    private static final char WILDCARD_CHAR = '*';
    private static final char MINUS_CHAR = '-';
    static final String MINUS = "-";

    private P8TextSearchUtil() {
    }

    static P8SearchDefinition.Clause createContentClause(SearchTemplate.TextSearchCriterion criterion, boolean cascade, P8SearchDefinition.SearchClause searchClause, boolean processToken) throws IOException {
        P8SearchDefinition.Clause contentClause = P8TextSearchUtil.createEmptyContentClauseItem(criterion, searchClause);
        String text = criterion.getText();
        if (text == null || text.length() < 1) {
            return contentClause;
        }
        P8SearchDefinition.GroupAction groupAction = P8TextSearchUtil.getGroupAction(criterion.getOperator());
        if (groupAction == P8SearchDefinition.GroupAction.none) {
            List<String> tokens = P8TextSearchUtil.getTokens(criterion, cascade, processToken);
            int size = tokens.size();
            if (size < 1) {
                return contentClause;
            }
            P8SearchDefinition.Container container = new P8SearchDefinition.Container(P8SearchDefinition.Operator.and);
            container.setSearchClause(searchClause);
            for (int i = 0; i < size; ++i) {
                String token = tokens.get(i);
                P8SearchDefinition.ContentTerm term = P8TextSearchUtil.createContentTerm(token, true, cascade);
                P8SearchDefinition.RequiredState requiredState = term.getRequiredState();
                P8SearchDefinition.ContentClauseItem item = new P8SearchDefinition.ContentClauseItem();
                item.addContentTerm(term);
                item.setGroupAction(groupAction);
                item.setRequiredState(requiredState);
                item.setUserText(token);
                item.setSearchClause(searchClause);
                if (size == 1) {
                    item.setItemId(criterion.getItemId());
                    contentClause = item;
                    break;
                }
                if (i == 0) {
                    contentClause = container;
                }
                if (i % 2 != 0 && i + 1 < size) {
                    P8SearchDefinition.Container subContainer = new P8SearchDefinition.Container(P8SearchDefinition.Operator.and);
                    subContainer.setSearchClause(searchClause);
                    subContainer.addClause(item);
                    container.addClause(subContainer);
                    container = subContainer;
                    continue;
                }
                container.addClause(item);
            }
        } else {
            P8SearchDefinition.ContentClauseItem item = P8TextSearchUtil.newContentClauseItem(criterion.getOperator());
            item.setSearchClause(searchClause);
            item.setItemId(criterion.getItemId());
            P8TextSearchUtil.convertTextSearchCriterion(criterion, item, cascade, processToken);
            contentClause = item;
        }
        return contentClause;
    }

    static P8SearchDefinition.Clause createContentClause(List<SearchCriterion> propTextCriteria, boolean cascade, P8SearchDefinition.SearchClause searchClause, boolean processToken) throws IOException {
        if (propTextCriteria == null || propTextCriteria.size() < 1) {
            return null;
        }
        P8SearchDefinition.Clause contentClause = null;
        P8SearchDefinition.Container container = new P8SearchDefinition.Container(P8SearchDefinition.Operator.and);
        container.setSearchClause(searchClause);
        int size = propTextCriteria.size();
        for (int i = 0; i < size; ++i) {
            SearchCriterion criterion = propTextCriteria.get(i);
            SearchTemplate.TextSearchCriterion tempCriterion = new SearchTemplate.TextSearchCriterion(criterion.getValues()[0], P8SearchDefinition.GroupAction.none.toString(), 0, null, criterion.getItemId());
            P8SearchDefinition.Clause clause = P8TextSearchUtil.createContentClause(tempCriterion, cascade, searchClause, processToken);
            P8TextSearchUtil.populatePropertySymbolicName(clause, criterion.getName());
            if (size == 1) {
                contentClause = clause;
                break;
            }
            if (i == 0) {
                contentClause = container;
            }
            if (i % 2 != 0 && i + 1 < size) {
                P8SearchDefinition.Container subContainer = new P8SearchDefinition.Container(P8SearchDefinition.Operator.and);
                subContainer.setSearchClause(searchClause);
                subContainer.addClause(clause);
                container.addClause(subContainer);
                container = subContainer;
                continue;
            }
            container.addClause(clause);
        }
        return contentClause;
    }

    private static void populatePropertySymbolicName(P8SearchDefinition.Clause contentClause, String propertySymbolicName) {
        if (contentClause == null) {
            return;
        }
        if (contentClause.isContainer()) {
            P8SearchDefinition.Container container = (P8SearchDefinition.Container)contentClause;
            List<P8SearchDefinition.Clause> clauses = container.getClauses();
            for (P8SearchDefinition.Clause clause : clauses) {
                P8TextSearchUtil.populatePropertySymbolicName(clause, propertySymbolicName);
            }
        } else {
            ((P8SearchDefinition.ContentClauseItem)contentClause).setPropertySymbolicName(propertySymbolicName);
        }
    }

    static P8SearchDefinition.ContentClauseItem newContentClauseItem(String groupAction) {
        P8SearchDefinition.ContentClauseItem item = null;
        P8SearchDefinition.GroupAction operator = P8TextSearchUtil.getGroupAction(groupAction);
        if (operator == P8SearchDefinition.GroupAction.in) {
            item = new P8SearchDefinition.VerityClauseInItem();
            if (groupAction.indexOf(":") > -1) {
                ((P8SearchDefinition.VerityClauseInItem)item).setZone(groupAction.substring(groupAction.indexOf(":") + 1));
            }
        } else {
            item = operator == P8SearchDefinition.GroupAction.vql ? new P8SearchDefinition.VerityClauseVQLItem() : new P8SearchDefinition.ContentClauseItem();
        }
        item.setGroupAction(operator);
        return item;
    }

    private static P8SearchDefinition.GroupAction getGroupAction(String operator) {
        boolean advanced;
        boolean bl = advanced = operator == null || operator.length() < 1 || operator.equals("none");
        return advanced ? P8SearchDefinition.GroupAction.none : (operator.startsWith("in:") ? P8SearchDefinition.GroupAction.in : P8SearchDefinition.GroupAction.valueOf(operator));
    }

    static void convertTextSearchCriterion(SearchTemplate.TextSearchCriterion criterion, P8SearchDefinition.ContentClauseItem item, boolean cascade, boolean processToken) throws IOException {
        P8SearchDefinition.GroupAction groupAction = P8TextSearchUtil.getGroupAction(criterion.getOperator());
        item.setGroupAction(groupAction);
        item.setUserText(criterion.getText());
        if (groupAction == P8SearchDefinition.GroupAction.vql) {
            ((P8SearchDefinition.VerityClauseVQLItem)item).setVql(criterion.getText());
        } else {
            if (groupAction == P8SearchDefinition.GroupAction.near) {
                item.setSearchModifier(P8SearchDefinition.SearchModifier.proximity);
                item.setSearchModifierRange(criterion.getDistance());
            }
            ArrayList<P8SearchDefinition.ContentTerm> newTerms = new ArrayList<P8SearchDefinition.ContentTerm>();
            List<String> tokens = P8TextSearchUtil.getTokens(criterion, cascade, processToken);
            for (int i = 0; i < tokens.size(); ++i) {
                String token = tokens.get(i);
                P8SearchDefinition.ContentTerm term = P8TextSearchUtil.createContentTerm(token, groupAction == P8SearchDefinition.GroupAction.none, cascade);
                newTerms.add(term);
            }
            if (groupAction == P8SearchDefinition.GroupAction.none) {
                item.setRequiredState(newTerms.size() == 1 && ((P8SearchDefinition.ContentTerm)newTerms.get(0)).isProhibited() ? P8SearchDefinition.RequiredState.prohibited : null);
            }
            item.setContentTerms(newTerms);
        }
    }

    private static List<String> getTokens(SearchTemplate.TextSearchCriterion criterion, boolean cascade, boolean processToken) throws IOException {
        List<String> tokens = new ArrayList<String>();
        String text = criterion.getText();
        if (text != null && text.length() > 0) {
            P8SearchDefinition.GroupAction groupAction = P8TextSearchUtil.getGroupAction(criterion.getOperator());
            if (P8CeSearchUtilProxy.isStoredSearchSupported()) {
                // empty if block
            }
            boolean escapeSpecial = true;
            if (groupAction == P8SearchDefinition.GroupAction.near && cascade) {
                tokens = new ArrayList();
                tokens.add(processToken ? P8TextSearchUtil.processToken(text, cascade, escapeSpecial, true) : text);
            } else {
                tokens = P8TextSearchUtil.tokenizeContentSearchText(text, groupAction == P8SearchDefinition.GroupAction.none, cascade, processToken, escapeSpecial);
            }
        }
        return tokens;
    }

    private static P8SearchDefinition.ContentTerm createContentTerm(String term, boolean advanced, boolean cascade) {
        String wordVariation = null;
        boolean caseSensitive = false;
        P8SearchDefinition.RequiredState requiredState = P8SearchDefinition.RequiredState.none;
        boolean phrase = false;
        if (advanced && term.length() > 1 && term.startsWith(MINUS)) {
            requiredState = P8SearchDefinition.RequiredState.prohibited;
            term = term.substring(1);
        }
        if (term.startsWith("\"") && term.endsWith("\"")) {
            wordVariation = P8SearchDefinition.VeritySearchOperator.none.toString();
            caseSensitive = true;
            phrase = true;
            term = term.substring(1, term.length() - 1);
        } else {
            wordVariation = term.indexOf(42) >= 0 || term.indexOf(63) >= 0 ? P8SearchDefinition.VeritySearchOperator.wildcard.toString() : P8SearchDefinition.VeritySearchOperator.stem.toString();
        }
        return new P8SearchDefinition.ContentTerm(term, cascade ? null : wordVariation, cascade ? false : caseSensitive, requiredState, phrase);
    }

    private static List<String> tokenizeContentSearchText(String text, boolean advanced, boolean cascade, boolean processToken, boolean escapeSpecial) throws IOException {
        StringReader strReader = new StringReader(text);
        BufferedReader bufferedReader = new BufferedReader(strReader);
        StreamTokenizer parser = new StreamTokenizer(bufferedReader);
        parser.resetSyntax();
        parser.quoteChar(34);
        parser.wordChars(97, 122);
        parser.wordChars(65, 90);
        parser.wordChars(48, 57);
        parser.wordChars(39, 39);
        parser.wordChars(42, 42);
        parser.wordChars(63, 63);
        parser.wordChars(160, 255);
        char[] specialChars = P8TextSearchUtil.getContentSpecialChars(cascade);
        for (int i = 0; i < specialChars.length; ++i) {
            parser.wordChars(specialChars[i], specialChars[i]);
        }
        parser.whitespaceChars(0, 32);
        ArrayList<String> tokens = new ArrayList<String>();
        boolean prohibitNextPhrase = false;
        while (parser.nextToken() != -1) {
            boolean prohibit;
            String value;
            if (parser.sval == null || (value = parser.sval.trim()).length() == 0) continue;
            char firstChar = value.charAt(0);
            boolean bl = prohibit = advanced && firstChar == '-';
            if (prohibit && value.length() == 1) {
                prohibitNextPhrase = true;
                continue;
            }
            if (parser.ttype == 34) {
                if (processToken) {
                    value = P8TextSearchUtil.processToken(value, cascade, escapeSpecial, true);
                }
                value = '\"' + value + '\"';
                if (prohibitNextPhrase) {
                    value = MINUS + value;
                }
                tokens.add(value);
            } else if (parser.ttype == -3) {
                if (prohibit) {
                    value = value.substring(1);
                }
                if (processToken) {
                    value = P8TextSearchUtil.processToken(value, cascade, escapeSpecial, false);
                }
                if (prohibit) {
                    value = MINUS + value;
                }
                tokens.add(value);
            }
            prohibitNextPhrase = false;
        }
        if (prohibitNextPhrase) {
            tokens.add("\\-");
        }
        return tokens;
    }

    private static String processToken(String value, boolean cascade, boolean escapeSpecial, boolean escapeReserved) {
        if (!(cascade || value.indexOf(42) < 0 && value.indexOf(63) < 0 || value.indexOf(125) < 0)) {
            value = value.replaceAll("}", "");
        }
        if (cascade && value.length() == 1 && (value.equals(String.valueOf('*')) || value.equals(String.valueOf('?')))) {
            value = "\\" + value;
        } else if (escapeSpecial) {
            value = P8TextSearchUtil.escapeSpecialChars(value, cascade);
        }
        value = P8TextSearchUtil.quoteContentReservedWords(value, escapeReserved);
        return value;
    }

    private static char[] getContentSpecialChars(boolean cascade) {
        if (cascade) {
            return TEXT_SPECIAL_CHARS;
        }
        return VERITY_SPECIAL_CHARS;
    }

    private static String escapeSpecialChars(String text, boolean cascade) {
        int i;
        StringBuilder buffer = new StringBuilder();
        char[] charVals = text.toCharArray();
        boolean questionsOnly = true;
        for (i = 0; i < charVals.length; ++i) {
            if (charVals[i] == '?') continue;
            questionsOnly = false;
            break;
        }
        if (questionsOnly) {
            for (i = 0; i < charVals.length; ++i) {
                buffer.append('\\');
                buffer.append(charVals[i]);
            }
        } else {
            for (i = 0; i < charVals.length; ++i) {
                boolean specialChar = P8TextSearchUtil.isContentSpecialChar(charVals[i], cascade);
                if (specialChar) {
                    buffer.append('\\');
                } else if (charVals[i] == '*' || charVals[i] == '?') {
                    boolean beforeSpecial;
                    boolean afterSpecial = i - 1 >= 0 && (P8TextSearchUtil.isContentSpecialChar(charVals[i - 1], cascade) || charVals[i - 1] == '*');
                    boolean bl = beforeSpecial = i + 1 < charVals.length && (P8TextSearchUtil.isContentSpecialChar(charVals[i + 1], cascade) || charVals[i + 1] == '*');
                    if (afterSpecial || beforeSpecial) {
                        buffer.append('\\');
                    }
                }
                buffer.append(charVals[i]);
                if (charVals[i] != '\'') continue;
                buffer.append(charVals[i]);
            }
        }
        return buffer.toString();
    }

    private static boolean isContentSpecialChar(char c, boolean cascade) {
        boolean specialChar = false;
        char[] specialChars = P8TextSearchUtil.getContentSpecialChars(cascade);
        for (int i = 0; i < specialChars.length; ++i) {
            if (c != specialChars[i]) continue;
            specialChar = true;
            break;
        }
        return specialChar;
    }

    private static String quoteContentReservedWords(String text, boolean escape) {
        StringTokenizer t = new StringTokenizer(text);
        String quotedText = "";
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (P8TextSearchUtil.isContentReservedWord(token)) {
                token = escape ? "\\\"" + token + "\\\"" : "\"" + token + "\"";
            }
            if (quotedText.length() > 0) {
                quotedText = quotedText + " ";
            }
            quotedText = quotedText + token;
        }
        return quotedText;
    }

    private static boolean isContentReservedWord(String text) {
        boolean reserved = false;
        for (int i = 0; i < CONTENT_RESERVED_WORDS.length && !(reserved = text.equalsIgnoreCase(CONTENT_RESERVED_WORDS[i])); ++i) {
        }
        return reserved;
    }

    private static P8SearchDefinition.ContentClauseItem createEmptyContentClauseItem(SearchTemplate.TextSearchCriterion textCriterion, P8SearchDefinition.SearchClause searchClause) {
        String op;
        P8SearchDefinition.ContentClauseItem item;
        String itemId = textCriterion.getItemId();
        P8SearchDefinition.ContentClauseItem contentClauseItem = item = itemId == null || itemId.isEmpty() ? null : searchClause.getContentClauseItem(itemId);
        if (item == null) {
            item = new P8SearchDefinition.ContentClauseItem();
            item.setSearchClause(searchClause);
        }
        P8SearchDefinition.GroupAction groupAction = (op = textCriterion.getOperator()) != null && op.length() > 0 ? P8SearchDefinition.GroupAction.valueOf(op) : P8SearchDefinition.GroupAction.none;
        item.setGroupAction(groupAction);
        if (groupAction == P8SearchDefinition.GroupAction.near) {
            item.setSearchModifier(P8SearchDefinition.SearchModifier.proximity);
            item.setSearchModifierRange(textCriterion.getDistance());
        }
        item.setRequiredState(P8SearchDefinition.RequiredState.none);
        ArrayList<P8SearchDefinition.ContentTerm> contentTerms = new ArrayList<P8SearchDefinition.ContentTerm>();
        contentTerms.add(new P8SearchDefinition.ContentTerm("", null, false, null, false));
        item.setContentTerms(contentTerms);
        item.setUserText(null);
        return item;
    }

    public static String getTextSearchType(HttpServletRequest request) {
        SearchTemplate.TextSearchType type = P8TextSearchUtil.getTextSearchType(P8Util.getConnection(request), null, request);
        return type == null ? "" : type.toString();
    }

    public static String getTextSearchType(P8Connection connection, HttpServletRequest request) {
        SearchTemplate.TextSearchType type = P8TextSearchUtil.getTextSearchType(connection, null, request);
        return type == null ? "" : type.toString();
    }

    public static SearchTemplate.TextSearchType getTextSearchType(P8Connection connection, String objectStoreId, HttpServletRequest request) {
        if (connection == null) {
            return null;
        }
        int searchType = 0;
        try {
            ObjectStore os = objectStoreId == null || objectStoreId.length() < 1 ? connection.getObjectStore() : P8Util.getObjectStore(connection, objectStoreId);
            searchType = P8Util.getPropertyIntegerValue((IndependentObject)os, "CBRSearchType");
        }
        catch (Exception e) {
            Logger.logDebug(P8TextSearchUtil.class, "getTextSearchType", (ServletRequest)request, "Failed to get the value of CBRSearchType");
            return null;
        }
        SearchTemplate.TextSearchType type = null;
        if (searchType == 1) {
            type = SearchTemplate.TextSearchType.verity;
        } else if (searchType == 2) {
            type = SearchTemplate.TextSearchType.cascade;
        }
        return type;
    }
}

