/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.p8.P8Connection;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class P8SessionListener
implements HttpSessionBindingListener {
    public void valueBound(HttpSessionBindingEvent event) {
        String methodName = "valueBound";
        HttpSession session = event.getSession();
        Logger.logEntry((Object)this, "valueBound", session);
        Logger.logInfo((Object)this, "valueBound", event.getSession(), "Session: " + event.getSession() + "    maxInactiveInterval=" + event.getSession().getMaxInactiveInterval());
        Logger.logExit((Object)this, "valueBound", session);
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        String methodName = "valueUnbound";
        Logger.logEntry((Object)this, methodName, event.getSession());
        HttpSession session = event.getSession();
        HashMap servers = null;
        P8Connection theServer = null;
        try {
            if (session != null && (servers = (HashMap)session.getAttribute("p8_servers")) != null) {
                if (servers.keySet() == null) {
                    return;
                }
                for (String serverName : servers.keySet()) {
                    if (serverName == null || (theServer = (P8Connection)servers.get(serverName)) == null) continue;
                    Logger.logDebug((Object)this, methodName, session, "invalidate " + serverName + " for " + Logger.getFormattedUser(null, null));
                    theServer.cleanUp(session);
                    theServer = null;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Logger.logExit((Object)this, methodName, event.getSession());
    }
}

