/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.SecurityTemplateList;
import com.filenet.api.security.SecurityPolicy;
import com.filenet.api.security.SecurityTemplate;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Permission;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8SecurityPolicy {
    private String id;
    private String name;
    private String displayName;
    private boolean preserveDirectPermissions;
    private List<P8SecurityTemplate> securityTemplates;

    public P8SecurityPolicy(String id, String name, String displayName) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.preserveDirectPermissions = true;
        this.securityTemplates = new ArrayList<P8SecurityTemplate>(0);
    }

    public P8SecurityPolicy(P8Connection connection, SecurityPolicy securityPolicy) {
        this.id = securityPolicy.get_Id().toString();
        this.name = securityPolicy.get_Name();
        this.displayName = securityPolicy.get_DisplayName();
        this.preserveDirectPermissions = securityPolicy.get_PreserveDirectPermissions();
        SecurityTemplateList stl = securityPolicy.get_SecurityTemplates();
        this.securityTemplates = new ArrayList<P8SecurityTemplate>(stl.size());
        for (SecurityTemplate st : stl) {
            AccessPermissionList apl = st.get_TemplatePermissions();
            List<P8Permission> permissions = P8Permission.getPermissions(connection, apl, true);
            P8SecurityTemplate p8SecurityTemplate = new P8SecurityTemplate(st.get_Id().toString(), st.get_DisplayName(), st.get_ApplyStateID().toString(), st.get_IsEnabled(), permissions);
            this.securityTemplates.add(p8SecurityTemplate);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean getPreserveDirectPermissions() {
        return this.preserveDirectPermissions;
    }

    public void setPreserveDirectPermissions(boolean preserveDirectPermissions) {
        this.preserveDirectPermissions = preserveDirectPermissions;
    }

    public List<P8SecurityTemplate> getSecurityTemplates() {
        return this.securityTemplates;
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", this.id);
        jsonObject.put("name", this.name);
        jsonObject.put("displayName", this.displayName);
        jsonObject.put("preserveDirectPermissions", (Object)this.preserveDirectPermissions);
        JSONArray jsonArray = new JSONArray();
        for (P8SecurityTemplate st : this.securityTemplates) {
            jsonArray.add(st.toJSONObject());
        }
        jsonObject.put("securityTemplates", jsonArray);
        return jsonObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class P8SecurityTemplate {
        private String id;
        private String displayName;
        private String applyStateId;
        private boolean isEnabled;
        List<P8Permission> permissions;

        public P8SecurityTemplate(String id, String displayName, String applyStateId, boolean isEnabled, List<P8Permission> permissions) {
            this.id = id;
            this.displayName = displayName;
            this.applyStateId = applyStateId;
            this.isEnabled = isEnabled;
            this.permissions = permissions;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean getIsEnabled() {
            return this.isEnabled;
        }

        public void setIsEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public List<P8Permission> getPermissions() {
            return this.permissions;
        }

        public void setPermissions(List<P8Permission> permissions) {
            this.permissions = permissions;
        }

        public JSONObject toJSONObject() {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", this.id);
            jsonObject.put("applyStateId", this.applyStateId);
            jsonObject.put("isEnabled", (Object)this.isEnabled);
            jsonObject.put("displayName", this.displayName);
            jsonObject.put("acl", P8Permission.permissionsToJSONObject(this.permissions));
            return jsonObject;
        }
    }
}

