/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.p8.P8SearchDefinition;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class P8SearchUtil {
    public static final String RANK = "Rank";

    private P8SearchUtil() {
    }

    static boolean isSearchingAllClasses(List<P8SearchDefinition.Subclass> classes) {
        if (classes == null || classes.size() < 1) {
            return true;
        }
        boolean searchingAll = false;
        if (classes.size() == 1) {
            boolean rootClass;
            P8SearchDefinition.Subclass subclass = classes.get(0);
            String classSymName = subclass.getSymbolicName();
            SearchTemplate.ObjectType objectType = subclass.getObjectType();
            boolean bl = rootClass = objectType == SearchTemplate.ObjectType.document && classSymName.equals("Document") || objectType == SearchTemplate.ObjectType.folder && classSymName.equals("Folder");
            if (rootClass && subclass.isSearchSubclasses()) {
                searchingAll = true;
            }
        }
        return searchingAll;
    }

    static boolean isIcnMatchAllSearchClause(P8SearchDefinition.SearchClause searchClause) {
        P8SearchDefinition.Clause whereClause = searchClause.getWhereClause();
        if (whereClause == null) {
            return true;
        }
        return searchClause.getSearchDefinition().isIcnGenerated() && whereClause.isContainer() ? ((P8SearchDefinition.Container)whereClause).getJoin() == P8SearchDefinition.Operator.and : true;
    }

    static boolean isWhereClauseContainerIncludeCondition(P8SearchDefinition.Container container, P8SearchDefinition.Operator joinLookup, String nameLookup, P8SearchDefinition.Operator operatorLookup) {
        if (joinLookup == null) {
            joinLookup = container.getJoin();
        } else if (container.getJoin() != joinLookup) {
            return false;
        }
        List<P8SearchDefinition.Clause> clauses = container.getClauses();
        Iterator<P8SearchDefinition.Clause> i = clauses.iterator();
        boolean first = true;
        while (i.hasNext()) {
            P8SearchDefinition.Clause clause = i.next();
            if (clause.isContainer()) {
                if (first) {
                    return false;
                }
                if (!P8SearchUtil.isWhereClauseContainerIncludeCondition((P8SearchDefinition.Container)clause, joinLookup, nameLookup, operatorLookup)) {
                    return false;
                }
            } else {
                if (!(clause instanceof P8SearchDefinition.WhereClauseCondition)) {
                    return false;
                }
                P8SearchDefinition.WhereClauseCondition condition = (P8SearchDefinition.WhereClauseCondition)clause;
                if (condition.getSmartOperator() == P8SearchDefinition.Operator.notin) {
                    return true;
                }
                if (condition.isHidden() || condition.isReadOnly() || condition.isRequired()) {
                    return false;
                }
                P8SearchDefinition.Operator operator = condition.getOperator();
                if (condition.getPropDataType() == P8SearchDefinition.DataType.typeobject || operator != P8SearchDefinition.Operator.eq && operator != P8SearchDefinition.Operator.neq && operator != P8SearchDefinition.Operator.in) {
                    return false;
                }
                String name = condition.getPropName();
                if (!(nameLookup == null || name.equals(nameLookup) && operator == operatorLookup)) {
                    return false;
                }
                if (nameLookup == null) {
                    nameLookup = name;
                }
                if (operatorLookup == null) {
                    operatorLookup = operator;
                }
            }
            first = false;
        }
        if (container.getJoin() == P8SearchDefinition.Operator.or && operatorLookup != P8SearchDefinition.Operator.in && operatorLookup != P8SearchDefinition.Operator.eq) {
            return false;
        }
        return container.getJoin() != P8SearchDefinition.Operator.and || operatorLookup == P8SearchDefinition.Operator.in || operatorLookup == P8SearchDefinition.Operator.neq;
    }

    static boolean isWhereClauseContainerRangeCondition(P8SearchDefinition.Container container) {
        List<P8SearchDefinition.Clause> clauses = container.getClauses();
        if (clauses.size() != 2) {
            return false;
        }
        P8SearchDefinition.Clause from = clauses.get(0);
        P8SearchDefinition.Clause to = clauses.get(1);
        if (!(from instanceof P8SearchDefinition.WhereClauseCondition) || from.isContainer() || !(to instanceof P8SearchDefinition.WhereClauseCondition) || to.isContainer()) {
            return false;
        }
        P8SearchDefinition.WhereClauseCondition fromCondition = (P8SearchDefinition.WhereClauseCondition)from;
        P8SearchDefinition.WhereClauseCondition toCondition = (P8SearchDefinition.WhereClauseCondition)to;
        if (!fromCondition.getPropSymbolicName().equals(toCondition.getPropSymbolicName())) {
            return false;
        }
        if (fromCondition.isHidden() || fromCondition.isReadOnly() || fromCondition.isRequired()) {
            return false;
        }
        if (toCondition.isHidden() || toCondition.isReadOnly() || toCondition.isRequired()) {
            return false;
        }
        P8SearchDefinition.DataType dataType = fromCondition.getPropDataType();
        if (dataType != P8SearchDefinition.DataType.typedate && dataType != P8SearchDefinition.DataType.typedouble && dataType != P8SearchDefinition.DataType.typelong) {
            return false;
        }
        boolean between = container.getJoin() == P8SearchDefinition.Operator.and;
        P8SearchDefinition.Operator fromOperator = fromCondition.getOperator();
        P8SearchDefinition.Operator toOperator = toCondition.getOperator();
        return between ? fromOperator == P8SearchDefinition.Operator.gte && toOperator == P8SearchDefinition.Operator.lte : fromOperator == P8SearchDefinition.Operator.lt && toOperator == P8SearchDefinition.Operator.gt;
    }

    static String convertP8SearchDefinitionOperator(P8SearchDefinition.Operator operator) {
        String op;
        switch (operator) {
            case eq: {
                op = "EQUAL";
                break;
            }
            case neq: {
                op = "NOTEQUAL";
                break;
            }
            case like: {
                op = "LIKE";
                break;
            }
            case notlike: {
                op = "NOTLIKE";
                break;
            }
            case lt: {
                op = "LESS";
                break;
            }
            case lte: {
                op = "LESSOREQUAL";
                break;
            }
            case gt: {
                op = "GREATER";
                break;
            }
            case gte: {
                op = "GREATEROREQUAL";
                break;
            }
            case in: {
                op = "IN";
                break;
            }
            case notin: {
                op = "NOTIN";
                break;
            }
            case inany: {
                op = "INANY";
                break;
            }
            case isnull: {
                op = "NULL";
                break;
            }
            case isnotnull: {
                op = "NOTNULL";
                break;
            }
            case between: {
                op = "BETWEEN";
                break;
            }
            case notbetween: {
                op = "NOTBETWEEN";
                break;
            }
            case startswith: {
                op = "STARTSWITH";
                break;
            }
            case endswith: {
                op = "ENDSWITH";
                break;
            }
            case contains: {
                op = "CONTAINS";
                break;
            }
            default: {
                op = "EQUAL";
            }
        }
        return op;
    }

    static P8SearchDefinition.Operator convertP8SearchTemplateOperator(String operator) {
        P8SearchDefinition.Operator op = operator.equals("EQUAL") ? P8SearchDefinition.Operator.eq : (operator.equals("NOTEQUAL") ? P8SearchDefinition.Operator.neq : (operator.equals("LIKE") ? P8SearchDefinition.Operator.like : (operator.equals("NOTLIKE") ? P8SearchDefinition.Operator.notlike : (operator.equals("LESS") ? P8SearchDefinition.Operator.lt : (operator.equals("LESSOREQUAL") ? P8SearchDefinition.Operator.lte : (operator.equals("GREATER") ? P8SearchDefinition.Operator.gt : (operator.equals("GREATEROREQUAL") ? P8SearchDefinition.Operator.gte : (operator.equals("IN") ? P8SearchDefinition.Operator.in : (operator.equals("NOTIN") ? P8SearchDefinition.Operator.notin : (operator.equals("INANY") ? P8SearchDefinition.Operator.inany : (operator.equals("NULL") ? P8SearchDefinition.Operator.isnull : (operator.equals("NOTNULL") ? P8SearchDefinition.Operator.isnotnull : (operator.equals("BETWEEN") ? P8SearchDefinition.Operator.between : (operator.equals("NOTBETWEEN") ? P8SearchDefinition.Operator.notbetween : (operator.equals("STARTSWITH") ? P8SearchDefinition.Operator.startswith : (operator.equals("ENDSWITH") ? P8SearchDefinition.Operator.endswith : (operator.equals("CONTAINS") ? P8SearchDefinition.Operator.contains : P8SearchDefinition.Operator.eq)))))))))))))))));
        return op;
    }

    static String convertP8SearchDefinitionDataType(P8SearchDefinition.DataType dataType) {
        String xsType;
        switch (dataType) {
            case typestring: {
                xsType = "xs:string";
                break;
            }
            case typedate: {
                xsType = "xs:date";
                break;
            }
            case typeboolean: {
                xsType = "xs:boolean";
                break;
            }
            case typedouble: {
                xsType = "xs:double";
                break;
            }
            case typelong: {
                xsType = "xs:long";
                break;
            }
            case typeobject: {
                xsType = "xs:object";
                break;
            }
            default: {
                xsType = "xs:string";
            }
        }
        return xsType;
    }

    static P8SearchDefinition.DataType convertP8SearchTemplateDataType(String dataType) {
        P8SearchDefinition.DataType dt = dataType.equals("xs:string") ? P8SearchDefinition.DataType.typestring : (dataType.equals("xs:date") || dataType.equals("xs:timestamp") ? P8SearchDefinition.DataType.typedate : (dataType.equals("xs:boolean") ? P8SearchDefinition.DataType.typeboolean : (dataType.equals("xs:double") ? P8SearchDefinition.DataType.typedouble : (dataType.equals("xs:long") ? P8SearchDefinition.DataType.typelong : (dataType.equals("xs:guid") ? P8SearchDefinition.DataType.typeguid : (dataType.equals("xs:object") ? P8SearchDefinition.DataType.typeobject : P8SearchDefinition.DataType.typestring))))));
        return dt;
    }

    static String convertLikeValue(String value, P8SearchDefinition.Operator operator) {
        if (value != null && value.length() > 0) {
            value = operator == P8SearchDefinition.Operator.startswith ? value + "%" : (operator == P8SearchDefinition.Operator.endswith ? "%" + value : "%" + value + "%");
        }
        return value;
    }
}

