/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.constants.AutoClassify;
import com.filenet.api.constants.AutoUniqueName;
import com.filenet.api.constants.CheckinType;
import com.filenet.api.constants.DefineSecurityParentage;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.SpecialPrincipal;
import com.filenet.api.core.Connection;
import com.filenet.api.core.ContentElement;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.Properties;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.security.AccessPermission;
import com.filenet.api.security.User;
import com.filenet.api.util.Id;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.FileTypeConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.p8.P8TeamspaceService;
import com.ibm.ecm.util.SearchCriteria;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8DocID;
import com.ibm.ecm.util.p8.P8SearchDefinition;
import com.ibm.ecm.util.p8.P8SearchDefinitionParser;
import com.ibm.ecm.util.p8.P8SearchTemplate;
import com.ibm.ecm.util.p8.P8SearchUtil;
import com.ibm.ecm.util.p8.P8TextSearchUtil;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8SearchTemplateDocument {
    private static final String MIMETYPE = "application/x-filenet-searchtemplate";
    private static final String MIMETYPE_JSON = "application/json";
    private static final String DOCUMENT_TITLE = "DocumentTitle";
    private static final String UTF8 = "UTF-8";
    private static final int SEARCHING_OBJECT_TYPE_DOCUMENT = 1;
    private static final int SEARCHING_OBJECT_TYPE_FOLDER = 2;
    private static final int SEARCH_TYPE_STORED_SEARCH = 1;
    private static final int SEARCH_TYPE_SEARCH_TEMPLATE = 2;
    private static final String PROPERTY_SEARCH_TYPE = "SearchType";
    private static final String PROPERTY_SEARCHING_OBJECT_TYPE = "SearchingObjectType";
    private static final String PROPERTY_SEARCHING_OBJECT_STORES = "SearchingObjectStores";
    private static final String PROPERTY_APPLICATION_NAME = "ApplicationName";
    private static final String PROPERTY_CM_SEARCH_SCHEMA_VERSION = "CmSearchSchemaVersion";
    private static final String CLASS_STORED_SEARCH = "StoredSearch";
    private HttpServletRequest request;
    private P8Connection connection;
    private String storedSearchId;
    private String storedSearchVsId;
    private String teamspaceId;
    private P8SearchTemplate searchTemplate;
    private P8SearchDefinition searchDefinition;
    private Document document;

    public P8SearchTemplateDocument(HttpServletRequest request, P8Connection connection, String storedSearchId, String storedSearchVsId, String teamspaceId) {
        this.request = request;
        this.connection = connection;
        this.storedSearchId = storedSearchId;
        this.storedSearchVsId = storedSearchVsId;
        this.teamspaceId = teamspaceId;
    }

    private boolean isSearchTemplateIdSet() {
        return this.storedSearchId != null && !this.storedSearchId.isEmpty() || this.storedSearchVsId != null && !this.storedSearchVsId.isEmpty();
    }

    public P8SearchTemplate getSearchTemplate(JSONObject searchTemplateJson, boolean loadSearchDefinition) throws Exception {
        return this.getSearchTemplate(searchTemplateJson, loadSearchDefinition, false);
    }

    public P8SearchTemplate getSearchTemplate(boolean autoResolve) throws Exception {
        return this.getSearchTemplate(null, true, autoResolve);
    }

    private P8SearchTemplate getSearchTemplate(JSONObject searchTemplateJson, boolean loadSearchDefinition, boolean autoResolve) throws Exception {
        String osId;
        this.searchDefinition = new P8SearchDefinition();
        this.searchDefinition.setApiIncompatible(true);
        this.searchTemplate = new P8SearchTemplate(this.searchDefinition);
        if (this.isSearchTemplateIdSet()) {
            this.loadSearchDefinitionDocument(loadSearchDefinition);
            if (loadSearchDefinition) {
                this.loadSearchDefinition(autoResolve);
            }
            this.searchTemplate.setDisplayName(this.document.get_Name());
            Properties props = this.document.getProperties();
            Boolean autoRun = false;
            if (props.isPropertyPresent("IcnAutoRun")) {
                autoRun = props.getBooleanValue("IcnAutoRun");
            }
            this.searchTemplate.setAutoRun(autoRun != null ? autoRun : false);
            Boolean showInTree = false;
            if (props.isPropertyPresent("IcnShowInTree")) {
                showInTree = props.getBooleanValue("IcnShowInTree");
            }
            this.searchTemplate.setShowInTree(showInTree != null ? showInTree : false);
            this.searchTemplate.setAutoResolved(this.searchDefinition.isAutoResolved());
        }
        if (searchTemplateJson != null && !searchTemplateJson.isEmpty()) {
            this.searchTemplate.fromJSON(searchTemplateJson);
            if (this.isSearchTemplateIdSet() && loadSearchDefinition) {
                this.convertP8SearchDefinitionObjectStores();
                P8SearchDefinition.SearchClause clause = this.searchDefinition.getSearchClause(this.searchTemplate.getObjectType());
                P8SearchDefinition.ContentCriteria criteria = clause == null ? null : clause.getContentCriteria();
                List<P8SearchDefinition.SearchInObjectStore> objectStores = this.searchTemplate.getObjectStores();
                String osId2 = objectStores != null && objectStores.size() > 0 ? objectStores.get(0).getId() : null;
                SearchTemplate.TextSearchType searchType = criteria == null ? P8TextSearchUtil.getTextSearchType(this.connection, osId2, this.request) : criteria.getTextSearchType();
                this.searchTemplate.setTextSearchType(searchType);
            } else {
                osId = this.addDefaultObjectStore().getId();
                SearchTemplate.TextSearchType searchType = P8TextSearchUtil.getTextSearchType(this.connection, osId, this.request);
                this.searchTemplate.setTextSearchType(searchType);
                this.searchDefinition.setDatabaseType(P8Util.getObjectStore(this.connection, osId).get_DatabaseType().getValue());
            }
        } else if (this.isSearchTemplateIdSet()) {
            this.convertToP8SearchTemplate();
            this.normalizeResultsDisplay();
            if (this.searchTemplate.getTextSearchType() == null) {
                osId = this.searchTemplate.getObjectStores().get(0).getId();
                SearchTemplate.TextSearchType textSearchType = P8TextSearchUtil.getTextSearchType(this.connection, osId, this.request);
                this.searchTemplate.setTextSearchType(textSearchType);
            }
            P8SearchDefinition.SearchInObjectStore searchObjStore = this.searchTemplate.getObjectStores().get(0);
            ObjectStore objStore = P8Util.getObjectStore(this.connection, searchObjStore.getId());
            ClassDescription classDesc = P8Util.getCachedCD(objStore, this.searchTemplate.getFirstClassName());
            ArrayList<PropertyDescription> propertyDescriptions = P8Util.getPropertyDescriptions(classDesc, this.searchTemplate.isFirstClassSearchSubclasses(), false, true, false, true);
            block0: for (SearchCriteria criteria : this.searchTemplate.getSearchCriteria()) {
                SearchCriterion criterion = (SearchCriterion)criteria;
                for (PropertyDescription propertyDesc : propertyDescriptions) {
                    if (!propertyDesc.get_SymbolicName().equals(criterion.getName())) continue;
                    criterion.setDataType(P8Util.getDataType(propertyDesc));
                    criterion.setCardinality(propertyDesc.get_Cardinality().toString());
                    continue block0;
                }
            }
        }
        if (this.searchDefinition != null) {
            this.searchTemplate.setSearchDefinition(this.searchDefinition);
            this.searchTemplate.setProductName(this.searchDefinition.getProductName());
        }
        return this.searchTemplate;
    }

    private P8SearchDefinition.SearchInObjectStore addDefaultObjectStore() {
        ObjectStore os = this.connection.getObjectStore();
        String osId = os.getObjectReference().getObjectIdentity();
        P8SearchDefinition.SearchInObjectStore searchOs = new P8SearchDefinition.SearchInObjectStore(osId, os.get_DisplayName());
        this.searchTemplate.addObjectStore(searchOs);
        return searchOs;
    }

    private void normalizeResultsDisplay() {
        String[] filteredProperties;
        String nameProperty;
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(this.request);
        String[] columns = this.searchTemplate.getResultsDisplay().getColumns();
        if (columns.length == 0) {
            columns = repositoryConfig.getSearchDefaultColumns();
        }
        String sortBy = this.searchTemplate.getResultsDisplay().getSortByProperty();
        boolean sortAsc = this.searchTemplate.getResultsDisplay().getSortAscending();
        if (this.searchTemplate.getObjectType() == SearchTemplate.ObjectType.document) {
            nameProperty = repositoryConfig.getDocNameProperty();
            filteredProperties = repositoryConfig.getSearchFilteredDocumentProperties();
        } else {
            nameProperty = repositoryConfig.getFolderNameProperty();
            filteredProperties = repositoryConfig.getSearchFilteredFolderProperties();
        }
        HashSet<String> filteredSet = new HashSet<String>(Arrays.asList(filteredProperties));
        ArrayList<String> normalizedList = new ArrayList<String>();
        for (String selectProp : columns) {
            if (selectProp.equals("{NAME}")) {
                selectProp = nameProperty;
            }
            if (!filteredSet.contains(selectProp) || selectProp.equals(nameProperty)) {
                if (normalizedList.size() != 0 && selectProp.equals(nameProperty)) continue;
                normalizedList.add(selectProp);
                continue;
            }
            if (!selectProp.equals(sortBy)) continue;
            sortBy = nameProperty;
            sortAsc = true;
        }
        if (normalizedList.size() == 0 || !((String)normalizedList.get(0)).equals(nameProperty)) {
            normalizedList.add(0, nameProperty);
        }
        String[] normalizedColumns = new String[normalizedList.size()];
        SearchTemplate.ResultsDisplay rd = new SearchTemplate.ResultsDisplay(sortBy != null && sortBy.length() > 0 ? sortBy : nameProperty, sortAsc, normalizedList.toArray(normalizedColumns));
        this.searchTemplate.setResultsDisplay(rd);
    }

    private void loadSearchDefinition(boolean autoResolve) throws Exception {
        String methodName = "loadSearchDefinition";
        Logger.logDebug(P8SearchTemplateDocument.class, methodName, (ServletRequest)this.request, "loading search definition document: " + this.document.getObjectReference());
        ContentElementList contentElements = this.document.get_ContentElements();
        ContentElement contentElement = (ContentElement)contentElements.get(0);
        ContentTransfer contentTransfer = (ContentTransfer)contentElement;
        InputStream contentStream = contentTransfer.accessContentStream();
        Logger.logDebug(P8SearchTemplateDocument.class, "loadSearchDefinition", (ServletRequest)this.request, "parsing search template and building criteria objects");
        this.searchDefinition = P8SearchDefinitionParser.parse(contentStream);
        Teamspace teamspace = null;
        if (this.teamspaceId != null && this.teamspaceId.length() > 0) {
            P8TeamspaceService teamspaceService = new P8TeamspaceService(this.connection.getCEConnection(), this.connection.getDomain(), this.connection.getObjectStore(), this.connection, this.request);
            teamspace = teamspaceService.retrieveTeamspace(this.teamspaceId, "searches", "instance");
        }
        if (contentElements.size() > 1) {
            for (int i = 1; i < contentElements.size(); ++i) {
                contentElement = (ContentElement)contentElements.get(i);
                if (!MIMETYPE_JSON.equals(contentElement.get_ContentType())) continue;
                JSONObject json = (JSONObject)JSON.parse(((ContentTransfer)contentElement).accessContentStream());
                SearchTemplate.Macros macros = new SearchTemplate.Macros();
                macros.fromJSON((JSONObject)json.get("macros"));
                this.searchTemplate.setMacros(macros);
                break;
            }
        }
        this.validate(teamspace, autoResolve);
        String useCeApi = this.request.getParameter("searchViaCeApi");
        if (useCeApi == null || useCeApi.isEmpty() || !Boolean.valueOf(useCeApi).booleanValue()) {
            this.searchDefinition.setApiIncompatible(true);
        }
        Logger.logDebug(P8SearchTemplateDocument.class, "loadSearchDefinition", (ServletRequest)this.request, "searchDefinition: " + this.searchDefinition);
    }

    public Document save(String name, String description, JSONObject searchTemplateJson) throws Exception {
        Document checkedOutDoc;
        if (searchTemplateJson != null) {
            this.getSearchTemplate(searchTemplateJson, false);
        }
        if ((checkedOutDoc = (Document)this.document.get_Reservation()) == null) {
            return null;
        }
        int access = checkedOutDoc.getAccessAllowed();
        if ((access & 4) != 4) {
            throw new IllegalAccessException();
        }
        Properties properties = checkedOutDoc.getProperties();
        properties.putObjectValue(DOCUMENT_TITLE, (Object)name);
        properties.putObjectValue("Description", (Object)description);
        properties.putValue("IcnAutoRun", this.searchTemplate.isAutoRun());
        properties.putValue("IcnShowInTree", this.searchTemplate.isShowInTree());
        properties.putValue(PROPERTY_SEARCH_TYPE, this.searchTemplate.isAutoRun() ? 1 : 2);
        properties.putValue(PROPERTY_SEARCHING_OBJECT_TYPE, this.getSearchObjectType());
        properties.putValue(PROPERTY_SEARCHING_OBJECT_STORES, this.connection.getObjectStore().get_SymbolicName());
        checkedOutDoc.set_ContentElements(this.createContentElements());
        checkedOutDoc.checkin(AutoClassify.DO_NOT_AUTO_CLASSIFY, CheckinType.MAJOR_VERSION);
        checkedOutDoc.save(RefreshMode.REFRESH);
        return checkedOutDoc;
    }

    public Document saveAs(String templateName, String description, JSONObject searchTemplateJson, String folderPID, AccessPermissionList permissions) throws Exception {
        if (searchTemplateJson != null) {
            this.searchTemplate = this.getSearchTemplate(searchTemplateJson, false);
        }
        ObjectStore objectStore = this.connection.getObjectStore();
        ClassDescription classDescription = P8Util.getCachedCD(objectStore, CLASS_STORED_SEARCH);
        Id id = classDescription.get_Id();
        Document document = Factory.Document.createInstance((ObjectStore)objectStore, (String)id.toString());
        document.set_MimeType(MIMETYPE);
        Properties documentProperties = document.getProperties();
        documentProperties.putValue(DOCUMENT_TITLE, templateName);
        documentProperties.putValue("Description", description);
        documentProperties.putValue("IcnAutoRun", this.searchTemplate.isAutoRun());
        documentProperties.putValue("IcnShowInTree", this.searchTemplate.isShowInTree());
        documentProperties.putValue(PROPERTY_SEARCH_TYPE, this.searchTemplate.isAutoRun() ? 1 : 2);
        documentProperties.putValue(PROPERTY_SEARCHING_OBJECT_TYPE, this.getSearchObjectType());
        documentProperties.putValue(PROPERTY_SEARCHING_OBJECT_STORES, this.connection.getObjectStore().get_SymbolicName());
        documentProperties.putValue(PROPERTY_APPLICATION_NAME, "Navigator");
        if (documentProperties.isPropertyPresent(PROPERTY_CM_SEARCH_SCHEMA_VERSION)) {
            documentProperties.putValue(PROPERTY_CM_SEARCH_SCHEMA_VERSION, 3);
        }
        document.set_ContentElements(this.createContentElements());
        document.checkin(AutoClassify.DO_NOT_AUTO_CLASSIFY, CheckinType.MAJOR_VERSION);
        AccessPermissionList permissionAPL = Factory.AccessPermission.createList();
        AccessPermissionList defaultInstancePermissionsList = classDescription.get_DefaultInstancePermissions();
        for (AccessPermission ap : defaultInstancePermissionsList) {
            if (ap.get_GranteeName().equalsIgnoreCase(SpecialPrincipal.CREATOR_OWNER.getValue())) {
                AccessPermission newAp = Factory.AccessPermission.createInstance();
                newAp.set_AccessMask(ap.get_AccessMask());
                newAp.set_AccessType(ap.get_AccessType());
                newAp.set_InheritableDepth(ap.get_InheritableDepth());
                User currentUser = Factory.User.fetchCurrent((Connection)this.connection.getCEConnection(), null);
                newAp.set_GranteeName(currentUser.get_ShortName());
                ap = newAp;
            }
            if (ap.get_GranteeName().equalsIgnoreCase(SpecialPrincipal.AUTHENTICATED_USERS.getValue())) continue;
            permissionAPL.add((Object)ap);
        }
        if (permissions != null) {
            permissionAPL.addAll((Collection)permissions);
        }
        document.set_Permissions(permissionAPL);
        document.save(RefreshMode.REFRESH);
        if (folderPID != null && folderPID.length() > 0) {
            Folder folder = P8Util.getFolder(this.request, this.connection, folderPID);
            ReferentialContainmentRelationship rcr = folder.file((IndependentlyPersistableObject)document, AutoUniqueName.AUTO_UNIQUE, null, DefineSecurityParentage.DO_NOT_DEFINE_SECURITY_PARENTAGE);
            rcr.save(RefreshMode.NO_REFRESH);
        }
        return document;
    }

    private ContentElementList createContentElements() throws Exception {
        ContentElementList contentElementList = Factory.ContentElement.createList();
        ContentTransfer contentTransfer = Factory.ContentTransfer.createInstance();
        contentTransfer.set_ContentType(MIMETYPE);
        byte[] templateBytes = this.convertToXml().getBytes(UTF8);
        contentTransfer.setCaptureSource((InputStream)new ByteArrayInputStream(templateBytes));
        contentElementList.add((Object)contentTransfer);
        SearchTemplate.Macros macros = this.searchTemplate.getMacros();
        if (macros != null) {
            JSONObject json = new JSONObject();
            json.put("macros", macros.toJSON());
            contentTransfer = Factory.ContentTransfer.createInstance();
            contentTransfer.set_ContentType(MIMETYPE_JSON);
            templateBytes = json.toString().getBytes(UTF8);
            contentTransfer.setCaptureSource((InputStream)new ByteArrayInputStream(templateBytes));
            contentElementList.add((Object)contentTransfer);
        }
        return contentElementList;
    }

    private int getSearchObjectType() {
        SearchTemplate.ObjectType objectType = this.searchTemplate.getObjectType();
        if (objectType != null) {
            if (objectType == SearchTemplate.ObjectType.document) {
                return 1;
            }
            if (objectType == SearchTemplate.ObjectType.folder) {
                return 2;
            }
        }
        return -1;
    }

    private void loadSearchDefinitionDocument(boolean loadContent) {
        boolean released = this.storedSearchVsId != null && !this.storedSearchVsId.isEmpty();
        PropertyFilter pf = new PropertyFilter();
        if (released) {
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "ReleasedVersion", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Name", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "IcnAutoRun", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "IcnShowInTree", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Reservation", null));
            if (loadContent) {
                pf.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "ContentElements", null));
                pf.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "Content", null));
                pf.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "ContentType", null));
            }
        } else {
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(0), null, null, "Name", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(0), null, null, "IcnAutoRun", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(0), null, null, "IcnShowInTree", null));
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Reservation", null));
            if (loadContent) {
                pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "ContentElements", null));
                pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Content", null));
                pf.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "ContentType", null));
            }
        }
        String version = released ? "released" : null;
        this.document = P8Util.getDocument(this.request, this.connection, new P8DocID(this.storedSearchId), this.storedSearchVsId, version, null, pf);
    }

    private void convertToP8SearchTemplate() {
        P8SearchDefinition.SearchClause commonSearchClause;
        List<P8SearchDefinition.SearchClause> searchClauses = this.searchDefinition.getSearchClauses();
        if (searchClauses.size() < 1) {
            return;
        }
        for (P8SearchDefinition.SearchClause clause : searchClauses) {
            if (clause.getFrom() != SearchTemplate.ObjectType.customobject) continue;
            throw new RuntimeException("search.exception.customObjectSearch");
        }
        if (searchClauses.size() > 1) {
            throw new RuntimeException("search.exception.unsupportedSearch");
        }
        this.convertP8SearchDefinitionObjectStores();
        List<P8SearchDefinition.SearchInFolder> folders = this.searchDefinition.getFolders();
        for (P8SearchDefinition.SearchInFolder folder : folders) {
            this.searchTemplate.addFolder(new SearchTemplate.SearchFolder(folder.getId(), folder.getPathName(), folder.isSearchSubfolders(), folder.getView(), folder.getObjectStoreId(), folder.getObjectStoreName(), folder.getItemId()));
        }
        P8SearchDefinition.SearchClause searchClause = this.searchDefinition.getSearchClauses().get(0);
        this.convertP8SearchDefinitionClass(searchClause);
        P8SearchDefinition.ContentCriteria contentCriteria = searchClause.getContentCriteria();
        boolean rank = false;
        if (contentCriteria != null) {
            this.searchTemplate.setTextSearchType(contentCriteria.getTextSearchType());
            this.convertP8SearchDefinitionContentCriteria(contentCriteria.getContentClause());
            rank = contentCriteria.isShowRank();
            this.searchTemplate.setTextSearchCriteriaLayout(this.createCriteriaLayout(contentCriteria.getContentClause()));
            this.searchTemplate.setPropertyTextAnded(contentCriteria.getJoin() == P8SearchDefinition.JoinType.inner);
        }
        P8SearchDefinition.Clause commonClause = (commonSearchClause = this.searchDefinition.getSearchClause(SearchTemplate.ObjectType.common)) == null ? null : commonSearchClause.getWhereClause();
        P8SearchDefinition.Clause whereClause = searchClause.getWhereClause();
        this.convertP8SearchDefinitionWhereClauseConditions(whereClause, commonClause);
        this.convertP8SearchDefinitionSelectProperties(searchClause.getSelectProperties(), rank);
        if (this.searchDefinition.isIcnGenerated()) {
            this.searchTemplate.isAndSearch(P8SearchUtil.isIcnMatchAllSearchClause(searchClause));
        }
        this.searchTemplate.setVersionOption(this.searchDefinition.getVersionSelection());
        this.searchTemplate.setOperatorHidden(!this.searchDefinition.isShowOperators());
        this.searchTemplate.setCriteriaRelationshipHidden(!this.searchDefinition.isShowAndOrConditions());
    }

    private P8SearchTemplate.CriteriaLayout createCriteriaLayout(P8SearchDefinition.Clause clause) {
        if (clause == null || !clause.isContainer()) {
            return null;
        }
        P8SearchDefinition.Container container = (P8SearchDefinition.Container)clause;
        P8SearchTemplate.CriteriaLayout layout = new P8SearchTemplate.CriteriaLayout(container.getJoin().toString());
        List<P8SearchDefinition.Clause> clauses = container.getClauses();
        for (P8SearchDefinition.Clause child : clauses) {
            this.populateCriteriaLayout(child, layout);
        }
        if (layout.isEmpty()) {
            layout = null;
        }
        return layout;
    }

    private void populateCriteriaLayout(P8SearchDefinition.Clause clause, P8SearchTemplate.CriteriaLayout parentLayout) {
        if (clause == null) {
            return;
        }
        if (clause.isContainer()) {
            P8SearchTemplate.CriteriaLayout layout;
            P8SearchDefinition.Container container = (P8SearchDefinition.Container)clause;
            P8SearchDefinition.Container parent = clause.getContainer();
            if (parent.getJoin() != container.getJoin()) {
                layout = new P8SearchTemplate.CriteriaLayout(container.getJoin().toString());
                parentLayout.addChildLayout(layout);
            } else {
                layout = parentLayout;
            }
            List<P8SearchDefinition.Clause> clauses = container.getClauses();
            for (P8SearchDefinition.Clause child : clauses) {
                if (child.isContainer()) {
                    this.populateCriteriaLayout(child, layout);
                    continue;
                }
                P8SearchDefinition.ClauseItem item = (P8SearchDefinition.ClauseItem)child;
                if (item.isHidden()) continue;
                layout.addItemId(((P8SearchDefinition.ClauseItem)child).getItemId());
            }
            if (layout != parentLayout) {
                if (layout.getItemIdsSize() == 1 && layout.getChildLayoutsSize() < 1) {
                    String itemId = layout.getItemIds().get(0);
                    parentLayout.addItemId(itemId);
                    layout.removeItemId(itemId);
                }
                if (layout.isEmpty()) {
                    parentLayout.removeChildLayout(layout);
                }
            }
        } else {
            P8SearchDefinition.ClauseItem item = (P8SearchDefinition.ClauseItem)clause;
            if (!item.isHidden()) {
                parentLayout.addItemId(item.getItemId());
            }
        }
    }

    private void convertP8SearchDefinitionObjectStores() {
        List<P8SearchDefinition.SearchInObjectStore> objectStores = this.searchDefinition.getObjectStores();
        for (P8SearchDefinition.SearchInObjectStore objectStore : objectStores) {
            P8SearchDefinition.SearchInObjectStore os = new P8SearchDefinition.SearchInObjectStore(objectStore.getId(), objectStore.getName());
            os.setSymbolicName(objectStore.getSymbolicName());
            this.searchTemplate.addObjectStore(os);
        }
    }

    private void convertP8SearchDefinitionClass(P8SearchDefinition.SearchClause searchClause) {
        SearchTemplate.ObjectType objectType = searchClause.getFrom();
        this.searchTemplate.setObjectType(objectType);
        List<P8SearchDefinition.Subclass> subclasses = searchClause.getSubclasses();
        for (P8SearchDefinition.Subclass subclass : subclasses) {
            SearchTemplate.SearchClass searchClass = new SearchTemplate.SearchClass(subclass.getSymbolicName(), subclass.getDisplayName(), subclass.getObjectType(), subclass.isSearchSubclasses(), subclass.getEditProperty(), subclass.getItemId());
            this.searchTemplate.addClass(searchClass);
        }
    }

    private void convertP8SearchDefinitionWhereClauseConditions(P8SearchDefinition.Clause whereClause, P8SearchDefinition.Clause commonClause) {
        if (whereClause == null) {
            return;
        }
        if (whereClause.isContainer()) {
            boolean newGroup;
            P8SearchDefinition.Container container = (P8SearchDefinition.Container)whereClause;
            List<P8SearchDefinition.Clause> whereClauses = container.getClauses();
            P8SearchDefinition.Container parentContainer = container.getContainer();
            boolean bl = newGroup = parentContainer == null || container.getJoin() != parentContainer.getJoin();
            if (newGroup && P8SearchUtil.isWhereClauseContainerIncludeCondition(container, null, null, null)) {
                List<P8SearchDefinition.WhereClauseCondition> conditions = this.collectWhereClauseConditions(container);
                Iterator<P8SearchDefinition.WhereClauseCondition> i = conditions.iterator();
                String[] values = new String[conditions.size()];
                String[] displayValues = new String[conditions.size()];
                P8SearchDefinition.WhereClauseCondition firstCondition = null;
                int count = 0;
                String itemIds = "";
                while (i.hasNext()) {
                    P8SearchDefinition.WhereClauseCondition condition = i.next();
                    String value = condition.getLiteral();
                    String displayValue = condition.getLabel();
                    values[count] = value;
                    String string = displayValues[count] = displayValue != null ? displayValue : value;
                    if (firstCondition == null) {
                        firstCondition = condition;
                    }
                    if (!itemIds.isEmpty()) {
                        itemIds = itemIds + ",";
                    }
                    itemIds = itemIds + condition.getItemId();
                    ++count;
                }
                SearchCriterion criterion = new SearchCriterion();
                criterion.setName(firstCondition.getPropSymbolicName());
                criterion.setDisplayName(firstCondition.getPropName());
                P8SearchDefinition.Operator operator = firstCondition.getSmartOperator();
                if (operator == null) {
                    operator = container.getJoin() == P8SearchDefinition.Operator.or ? P8SearchDefinition.Operator.inany : (firstCondition.getOperator() == P8SearchDefinition.Operator.neq ? P8SearchDefinition.Operator.notin : P8SearchDefinition.Operator.in);
                }
                criterion.setOperator(P8SearchUtil.convertP8SearchDefinitionOperator(operator));
                criterion.setReadOnly(firstCondition.isReadOnly());
                criterion.setHidden(firstCondition.isHidden());
                criterion.setRequired(firstCondition.isRequired());
                criterion.setDataType(P8SearchUtil.convertP8SearchDefinitionDataType(firstCondition.getPropDataType()));
                criterion.setValues(values);
                criterion.setDisplayValues(displayValues);
                criterion.setItemId(itemIds);
                this.searchTemplate.addCriterion(criterion);
            } else if (container.isRange()) {
                P8SearchDefinition.WhereClauseCondition fromCondition = (P8SearchDefinition.WhereClauseCondition)whereClauses.get(0);
                P8SearchDefinition.WhereClauseCondition toCondition = (P8SearchDefinition.WhereClauseCondition)whereClauses.get(1);
                SearchCriterion criterion = new SearchCriterion();
                criterion.setName(fromCondition.getPropSymbolicName());
                criterion.setDisplayName(fromCondition.getPropName());
                P8SearchDefinition.Operator operator = container.getJoin() == P8SearchDefinition.Operator.and ? P8SearchDefinition.Operator.between : P8SearchDefinition.Operator.notbetween;
                criterion.setOperator(P8SearchUtil.convertP8SearchDefinitionOperator(operator));
                criterion.setReadOnly(fromCondition.isReadOnly());
                criterion.setHidden(fromCondition.isHidden());
                criterion.setRequired(fromCondition.isRequired());
                criterion.setDataType(P8SearchUtil.convertP8SearchDefinitionDataType(fromCondition.getPropDataType()));
                criterion.setValues(new String[]{fromCondition.getLiteral(), toCondition.getLiteral()});
                criterion.setItemId(fromCondition.getItemId() + "," + toCondition.getItemId());
                this.searchTemplate.addCriterion(criterion);
            } else {
                for (P8SearchDefinition.Clause wc : whereClauses) {
                    this.convertP8SearchDefinitionWhereClauseConditions(wc, commonClause);
                }
            }
        } else if (whereClause == P8SearchDefinition.COMMON_CLAUSE) {
            this.convertP8SearchDefinitionWhereClauseConditions(commonClause, null);
        } else {
            P8SearchDefinition.WhereClauseCondition condition = (P8SearchDefinition.WhereClauseCondition)whereClause;
            SearchCriterion criterion = new SearchCriterion();
            criterion.setName(condition.getPropSymbolicName());
            criterion.setDisplayName(condition.getPropName());
            criterion.setOperator(P8SearchUtil.convertP8SearchDefinitionOperator(condition.getSmartOperator() != null ? condition.getSmartOperator() : condition.getOperator()));
            criterion.setReadOnly(condition.isReadOnly());
            criterion.setHidden(condition.isHidden());
            criterion.setRequired(condition.isRequired());
            criterion.setDataType(P8SearchUtil.convertP8SearchDefinitionDataType(condition.getPropDataType()));
            criterion.setValues(new String[]{condition.getLiteral()});
            criterion.setDisplayValues(new String[]{condition.getLabel()});
            criterion.setItemId(condition.getItemId());
            this.searchTemplate.addCriterion(criterion);
        }
    }

    private List<P8SearchDefinition.WhereClauseCondition> collectWhereClauseConditions(P8SearchDefinition.Container container) {
        ArrayList<P8SearchDefinition.WhereClauseCondition> conditions = new ArrayList<P8SearchDefinition.WhereClauseCondition>();
        List<P8SearchDefinition.Clause> clauses = container.getClauses();
        for (P8SearchDefinition.Clause clause : clauses) {
            if (clause.isContainer()) {
                conditions.addAll(this.collectWhereClauseConditions((P8SearchDefinition.Container)clause));
                continue;
            }
            conditions.add((P8SearchDefinition.WhereClauseCondition)clause);
        }
        return conditions;
    }

    private void convertP8SearchDefinitionSelectProperties(List<P8SearchDefinition.SelectProperty> selectProperties, boolean rank) {
        ArrayList<String> columnList = new ArrayList<String>();
        String sortBy = null;
        boolean sortAsc = true;
        if (selectProperties != null && selectProperties.size() > 0) {
            for (P8SearchDefinition.SelectProperty selectProp : selectProperties) {
                if (selectProp == P8SearchDefinition.SELECT_PROPERTY_ALL) continue;
                columnList.add(selectProp.getSymbolicName());
                if (selectProp.getSortLevel() != 1) continue;
                sortBy = selectProp.getSymbolicName();
                sortAsc = !selectProp.isSortOrderDescending();
            }
        }
        if (rank) {
            sortBy = "Rank";
            sortAsc = false;
        }
        String[] columns = new String[columnList.size()];
        SearchTemplate.ResultsDisplay rd = new SearchTemplate.ResultsDisplay(sortBy, sortAsc, columnList.toArray(columns));
        this.searchTemplate.setResultsDisplay(rd);
    }

    private void convertP8SearchDefinitionContentCriteria(P8SearchDefinition.Clause contentClause) {
        if (contentClause == null) {
            return;
        }
        if (this.searchDefinition.isIcnGenerated()) {
            Collection<P8SearchDefinition.ClauseItem> items = contentClause.getSearchClause().retrieveContentClauseItems().values();
            boolean contentClauseDefined = false;
            boolean propClauseDefined = false;
            for (P8SearchDefinition.ClauseItem i : items) {
                P8SearchDefinition.ContentClauseItem item = (P8SearchDefinition.ContentClauseItem)i;
                String propName = item.getPropertySymbolicName();
                if (!(contentClauseDefined || propName != null && propName.length() >= 1)) {
                    contentClauseDefined = true;
                }
                if (propClauseDefined || propName == null || propName.length() <= 0) continue;
                propClauseDefined = true;
            }
            if (contentClauseDefined) {
                SearchTemplate.TextSearchCriterion criterion = propClauseDefined ? this.getTextSearchCriterion(((P8SearchDefinition.Container)contentClause).getClauses().get(0)) : this.getTextSearchCriterion(contentClause);
                this.searchTemplate.addTextSearchCriterion(criterion);
            }
            if (propClauseDefined) {
                if (contentClauseDefined) {
                    this.convertSearchDefinitionPropertyContentCriteria(((P8SearchDefinition.Container)contentClause).getClauses().get(1));
                } else {
                    this.convertSearchDefinitionPropertyContentCriteria(contentClause);
                }
            }
        } else {
            this.convertLegacySearchDefinitionContentCriteria(contentClause);
        }
    }

    private SearchTemplate.TextSearchCriterion getTextSearchCriterion(P8SearchDefinition.Clause contentClause) {
        if (contentClause == null) {
            return null;
        }
        String text = this.getText(contentClause);
        SearchTemplate.TextSearchCriterion criterion = new SearchTemplate.TextSearchCriterion();
        criterion.setText(text);
        if (contentClause.isContainer()) {
            criterion.setOperator("");
        } else {
            String op;
            P8SearchDefinition.ContentClauseItem item = (P8SearchDefinition.ContentClauseItem)contentClause;
            P8SearchDefinition.GroupAction groupAction = item.getGroupAction();
            String string = item.isSearchModifierProximity() ? P8SearchDefinition.GroupAction.near.toString() : (op = groupAction == P8SearchDefinition.GroupAction.none ? "" : item.getGroupAction().toString());
            if (groupAction == P8SearchDefinition.GroupAction.in) {
                op = op + ":" + ((P8SearchDefinition.VerityClauseInItem)item).getZone();
            }
            criterion.setOperator(op);
            criterion.setDistance(item.isSearchModifierProximity() ? item.getSearchModifierRange() : 0);
            criterion.setEditProperty(item.getEditProperty());
            criterion.setItemId(item.getItemId());
        }
        return criterion;
    }

    private void convertSearchDefinitionPropertyContentCriteria(P8SearchDefinition.Clause contentClause) {
        if (contentClause == null) {
            return;
        }
        if (contentClause.isContainer()) {
            P8SearchDefinition.Container container = (P8SearchDefinition.Container)contentClause;
            List<P8SearchDefinition.Clause> clauses = container.getClauses();
            if (clauses.size() == 2) {
                this.convertSearchDefinitionPropertyContentCriterion(clauses.get(0));
                this.convertSearchDefinitionPropertyContentCriteria(clauses.get(1));
            } else {
                for (P8SearchDefinition.Clause clause : clauses) {
                    this.convertSearchDefinitionPropertyContentCriteria(clause);
                }
            }
        } else {
            this.convertSearchDefinitionPropertyContentCriterion(contentClause);
        }
    }

    private void convertSearchDefinitionPropertyContentCriterion(P8SearchDefinition.Clause contentClause) {
        if (contentClause == null) {
            return;
        }
        SearchTemplate.TextSearchCriterion criterion = this.getTextSearchCriterion(contentClause);
        if (criterion != null) {
            SearchCriterion sc = new SearchCriterion();
            if (contentClause.isContainer()) {
                sc.setName(this.retrievePropertySymbolicName(contentClause));
            } else {
                sc.setItemId(((P8SearchDefinition.ContentClauseItem)contentClause).getItemId());
                sc.setName(((P8SearchDefinition.ContentClauseItem)contentClause).getPropertySymbolicName());
            }
            sc.setOperator(P8SearchUtil.convertP8SearchDefinitionOperator(P8SearchDefinition.Operator.contains));
            sc.setValues(new String[]{criterion.getText()});
            this.searchTemplate.addCriterion(sc);
        }
    }

    private String retrievePropertySymbolicName(P8SearchDefinition.Clause contentClause) {
        if (contentClause == null) {
            return null;
        }
        String propName = null;
        if (contentClause.isContainer()) {
            P8SearchDefinition.Clause clause;
            P8SearchDefinition.Container container = (P8SearchDefinition.Container)contentClause;
            List<P8SearchDefinition.Clause> clauses = container.getClauses();
            Iterator<P8SearchDefinition.Clause> i$ = clauses.iterator();
            while (i$.hasNext() && ((propName = this.retrievePropertySymbolicName(clause = i$.next())) == null || propName.length() <= 0)) {
            }
        } else {
            return ((P8SearchDefinition.ContentClauseItem)contentClause).getPropertySymbolicName();
        }
        return propName;
    }

    private void convertLegacySearchDefinitionContentCriteria(P8SearchDefinition.Clause contentClause) {
        if (contentClause == null) {
            return;
        }
        if (contentClause.isContainer()) {
            P8SearchDefinition.Container container = (P8SearchDefinition.Container)contentClause;
            List<P8SearchDefinition.Clause> clauses = container.getClauses();
            for (P8SearchDefinition.Clause clause : clauses) {
                this.convertLegacySearchDefinitionContentCriteria(clause);
            }
        } else {
            SearchTemplate.TextSearchCriterion criterion = this.getTextSearchCriterion(contentClause);
            if (criterion != null) {
                this.searchTemplate.addTextSearchCriterion(criterion);
            }
        }
    }

    private String getText(P8SearchDefinition.Clause cascadeClause) {
        if (cascadeClause == null) {
            return null;
        }
        StringBuilder text = new StringBuilder();
        if (cascadeClause.isContainer()) {
            P8SearchDefinition.Container container = (P8SearchDefinition.Container)cascadeClause;
            List<P8SearchDefinition.Clause> clauses = container.getClauses();
            for (P8SearchDefinition.Clause clause : clauses) {
                String query = this.getText(clause);
                if (query == null || query.length() == 0) continue;
                if (text.length() > 0) {
                    text.append(" ");
                }
                text.append(query);
            }
        } else {
            P8SearchDefinition.ContentClauseItem item = (P8SearchDefinition.ContentClauseItem)cascadeClause;
            P8SearchDefinition.GroupAction groupAction = item.getGroupAction();
            if (groupAction == P8SearchDefinition.GroupAction.vql) {
                String value = ((P8SearchDefinition.VerityClauseVQLItem)item).getVql();
                if (value == null || value.length() < 1) {
                    return null;
                }
                text.append(value);
            } else {
                List<P8SearchDefinition.ContentTerm> terms = item.getContentTerms();
                if (terms == null || terms.size() < 1) {
                    return null;
                }
                P8SearchDefinition.RequiredState required = item.getRequiredState();
                for (P8SearchDefinition.ContentTerm term : terms) {
                    if (text.length() > 0) {
                        text.append(" ");
                    }
                    String value = term.getValue();
                    if (term.isPhrase()) {
                        value = "\"" + value + "\"";
                    }
                    if (required == P8SearchDefinition.RequiredState.prohibited) {
                        value = "-" + value;
                    }
                    text.append(value);
                }
            }
        }
        return text.toString();
    }

    private String convertToXml() throws Exception {
        SearchTemplate.TextSearchCriterion textCriterion;
        List<SearchCriterion> textSearchCriteria;
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\"?>");
        xml.append("<storedsearch xmlns=\"http://filenet.com/namespaces/wcm/apps/1.0\">");
        xml.append("<version dtd=\"3.0\" searchobject=\"3\" />");
        xml.append("<product name=\"").append("Navigator").append("\" version=\"").append("2.0.0").append("1.0\" />");
        SearchTemplate.VersionOption versionOption = this.searchTemplate.getVersionOption();
        if (versionOption == null) {
            versionOption = SearchTemplate.VersionOption.none;
        }
        xml.append("<searchspec versionselection=\"").append((Object)versionOption).append("\">");
        xml.append("<searchtype>");
        xml.append("<template showandorconditions=\"true\" showmaxrecords=\"false\" showoperators=\"true\" />");
        xml.append("</searchtype>");
        xml.append("<objectstores mergeoption=\"union\">");
        List<P8SearchDefinition.SearchInObjectStore> objectStores = this.searchTemplate.getObjectStores();
        for (P8SearchDefinition.SearchInObjectStore objectStore : objectStores) {
            xml.append("<objectstore id=\"").append(objectStore.getId()).append("\"").append(" name=\"").append(objectStore.getName()).append("\" />");
        }
        xml.append("</objectstores>");
        int itemId = 1;
        xml.append("<searchcriteria>");
        xml.append("<folders>");
        List<SearchTemplate.SearchFolder> folders = this.searchTemplate.getFolders();
        if (folders != null) {
            for (SearchTemplate.SearchFolder folder : folders) {
                xml.append("<folder id=\"").append(folder.getId()).append("\" itemid=\"").append(itemId++).append("\" pathname=\"").append(folder.getPathName()).append("\" searchsubfolders=\"").append(folder.isSearchSubfolders()).append("\" view=\"editable\">");
                xml.append("<objectstore id=\"").append(folder.getObjectStoreId()).append("\" />");
                xml.append("</folder>");
            }
        }
        xml.append("</folders>");
        SearchTemplate.ObjectType objectType = this.searchTemplate.getObjectType();
        xml.append("<searchclauses>");
        xml.append("<searchclause>");
        xml.append("<select>");
        xml.append("<selectprops>");
        SearchTemplate.ResultsDisplay resultsDisplay = this.searchTemplate.getResultsDisplay();
        String sortProperty = null;
        if (resultsDisplay != null) {
            sortProperty = resultsDisplay.getSortByProperty();
            for (String name : resultsDisplay.getColumns()) {
                if (name.equalsIgnoreCase(sortProperty)) {
                    xml.append("<selectprop alignment=\"left\" itemid=\"").append(itemId++).append("\" name=\"").append(name).append("\" objecttype=\"").append((Object)objectType).append("\" sortlevel=\"1\" sortorder=\"").append(resultsDisplay.getSortOrder()).append("\" symname=\"").append(name).append("\" />");
                    continue;
                }
                xml.append("<selectprop alignment=\"left\" itemid=\"").append(itemId++).append("\" name=\"").append(name).append("\" objecttype=\"").append((Object)objectType).append("\" sortlevel=\"0\" sortorder=\"none\" symname=\"").append(name).append("\" />");
            }
        }
        xml.append("</selectprops>");
        xml.append("</select>");
        xml.append("<from>");
        xml.append("<class symname=\"").append((Object)objectType).append("\" />");
        xml.append("</from>");
        xml.append("<where>");
        List<SearchCriterion> searchCriteria = this.searchTemplate.getPropertySearchCriteria();
        Iterator<SearchCriterion> itr = searchCriteria.iterator();
        int size = searchCriteria.size();
        int opened = 0;
        int i = 0;
        while (itr.hasNext()) {
            SearchCriterion criterion;
            String xmlOperator;
            boolean between;
            if (i + 1 < size) {
                xml.append(this.searchTemplate.isAndSearch() ? "<and>" : "<or>");
                ++opened;
            }
            if ((between = (xmlOperator = P8SearchUtil.convertP8SearchTemplateOperator((criterion = itr.next()).getOperator()).toString()).equals(P8SearchDefinition.Operator.between.toString())) || xmlOperator.equals(P8SearchDefinition.Operator.notbetween.toString())) {
                xml.append("<").append(between ? "and" : "or").append(">");
                String[] values = criterion.getValues();
                SearchCriterion from = new SearchCriterion();
                from.setName(criterion.getName());
                from.setOperator(between ? "GREATEROREQUAL" : "LESS");
                from.setDataType(criterion.getDataType());
                from.setValues(new String[]{values != null && values.length > 0 ? values[0] : null});
                this.convertSearchCriterionToXml(xml, from, objectType, itemId++);
                SearchCriterion to = new SearchCriterion();
                to.setName(criterion.getName());
                to.setOperator(between ? "LESSOREQUAL" : "GREATER");
                to.setDataType(criterion.getDataType());
                to.setValues(new String[]{values != null && values.length > 1 ? values[1] : null});
                this.convertSearchCriterionToXml(xml, to, objectType, itemId++);
                xml.append("</").append(between ? "and" : "or").append(">");
            } else if (xmlOperator.equals(P8SearchDefinition.Operator.in.toString()) || xmlOperator.equals(P8SearchDefinition.Operator.inany.toString()) || xmlOperator.equals(P8SearchDefinition.Operator.notin.toString())) {
                SearchCriterion c;
                String operator;
                String join = xmlOperator.equals(P8SearchDefinition.Operator.inany.toString()) ? "or" : "and";
                String name = criterion.getName();
                String customAttributes = null;
                if (criterion.getCardinality().equals("SINGLE")) {
                    operator = xmlOperator.equals(P8SearchDefinition.Operator.notin.toString()) ? "NOTEQUAL" : "EQUAL";
                } else {
                    operator = "IN";
                    if (xmlOperator.equals(P8SearchDefinition.Operator.notin.toString())) {
                        customAttributes = "smartoperator=\"" + xmlOperator + "\"";
                    }
                }
                String dataType = criterion.getDataType();
                String[] values = criterion.getValues();
                if (values != null && values.length > 0) {
                    int j;
                    int length = values.length;
                    int tagCount = 0;
                    for (j = 0; j < length; ++j) {
                        if (j + 1 < length) {
                            xml.append("<").append(join).append(">");
                            ++tagCount;
                        }
                        c = new SearchCriterion();
                        c.setName(name);
                        c.setOperator(operator);
                        c.setDataType(dataType);
                        c.setValues(new String[]{values[j]});
                        this.convertSearchCriterionToXml(xml, c, objectType, itemId++, customAttributes);
                    }
                    for (j = 0; j < tagCount; ++j) {
                        xml.append("</").append(join).append(">");
                    }
                } else {
                    xml.append("<").append(join).append(">");
                    c = new SearchCriterion();
                    c.setName(name);
                    c.setOperator(operator);
                    c.setDataType(dataType);
                    this.convertSearchCriterionToXml(xml, c, objectType, itemId++, customAttributes);
                    xml.append("</").append(join).append(">");
                }
            } else {
                String customAttributes = null;
                if (xmlOperator.equals(P8SearchDefinition.Operator.like.toString()) || xmlOperator.equals(P8SearchDefinition.Operator.notlike.toString()) || xmlOperator.equals(P8SearchDefinition.Operator.startswith.toString()) || xmlOperator.equals(P8SearchDefinition.Operator.endswith.toString())) {
                    String[] stringArray;
                    String[] values = criterion.getValues();
                    String value = values != null && values.length > 0 ? values[0] : null;
                    if ((value = P8SearchUtil.convertLikeValue(value, P8SearchDefinition.Operator.valueOf(xmlOperator))) != null) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = value;
                    } else {
                        stringArray = null;
                    }
                    values = stringArray;
                    criterion.setValues(values);
                    if (!xmlOperator.equals(P8SearchDefinition.Operator.like.toString()) && !xmlOperator.equals(P8SearchDefinition.Operator.notlike.toString())) {
                        criterion.setOperator("LIKE");
                        customAttributes = "smartoperator=\"" + xmlOperator + "\"";
                    }
                }
                this.convertSearchCriterionToXml(xml, criterion, objectType, itemId++, customAttributes);
            }
            ++i;
        }
        for (i = 0; i < opened; ++i) {
            xml.append(this.searchTemplate.isAndSearch() ? "</and>" : "</or>");
        }
        xml.append("</where>");
        xml.append("<subclasses>");
        List<SearchTemplate.SearchClass> classes = this.searchTemplate.getClasses();
        for (SearchTemplate.SearchClass sc : classes) {
            String classSymName = sc.getName();
            boolean rootClass = objectType == SearchTemplate.ObjectType.document && classSymName.equals("Document") || objectType == SearchTemplate.ObjectType.folder && classSymName.equals("Folder");
            boolean searchSubclasses = sc.isSearchSubclasses();
            boolean skipSubclass = rootClass && searchSubclasses;
            if (skipSubclass) continue;
            xml.append("<subclass editproperty=\"editable\" itemid=\"").append(itemId++).append("\" symname=\"").append(classSymName).append("\" name=\"").append(sc.getDisplayName()).append("\" objecttype=\"").append((Object)objectType).append("\" includesubclasses=\"").append(searchSubclasses).append("\" />");
        }
        xml.append("</subclasses>");
        ArrayList<SearchTemplate.TextSearchCriterion> textCriteria = new ArrayList<SearchTemplate.TextSearchCriterion>();
        SearchTemplate.TextSearchCriterion contentTextCriteria = this.searchTemplate.getFirstTextSearchCriterion();
        if (contentTextCriteria != null) {
            textCriteria.add(contentTextCriteria);
        }
        if ((textSearchCriteria = this.searchTemplate.getPropertyTextSearchCriteria()) != null && !textSearchCriteria.isEmpty()) {
            for (SearchCriterion criterion : textSearchCriteria) {
                String[] values = criterion.getValues();
                String value = values != null && values.length > 0 ? values[0] : null;
                textCriterion = new SearchTemplate.TextSearchCriterion(value, P8SearchDefinition.GroupAction.none.toString(), 0);
                textCriteria.add(textCriterion);
            }
        }
        if (!textCriteria.isEmpty()) {
            boolean rank;
            boolean cascade = this.searchTemplate.isCascade();
            boolean bl = rank = sortProperty != null && sortProperty.equalsIgnoreCase("Rank");
            if (cascade) {
                xml.append("<content dialect=\"lucene\" contentsummary=\"false\" jointype=\"inner\" rank=\"" + rank + "\">");
            } else {
                xml.append("<veritycontent contentsummary=\"false\" jointype=\"inner\" rank=\"" + rank + "\">");
            }
            Iterator itrText = textCriteria.iterator();
            size = textCriteria.size();
            opened = 0;
            int i2 = 0;
            while (itrText.hasNext()) {
                if (i2 + 1 < size) {
                    xml.append(cascade ? "<and>" : "<verityand>");
                    ++opened;
                }
                textCriterion = (SearchTemplate.TextSearchCriterion)itrText.next();
                P8SearchDefinition.Clause contentClause = P8TextSearchUtil.createContentClause(textCriterion, cascade, null, false);
                if (!(textSearchCriteria.isEmpty() || contentTextCriteria != null && i2 <= 0)) {
                    int pos = contentTextCriteria == null ? i2 : i2 - 1;
                    SearchCriterion criterion = textSearchCriteria.get(pos);
                    this.populatePropertySymbolicName(contentClause, criterion == null ? null : criterion.getName());
                }
                xml.append(this.createXml(contentClause, cascade, itemId++));
                ++i2;
            }
            for (i2 = 0; i2 < opened; ++i2) {
                xml.append(cascade ? "</and>" : "</verityand>");
            }
            xml.append(cascade ? "</content>" : "</veritycontent>");
        }
        xml.append("</searchclause>");
        xml.append("</searchclauses>");
        xml.append("</searchcriteria>");
        xml.append("</searchspec>");
        xml.append("</storedsearch>");
        return xml.toString();
    }

    private String createXml(P8SearchDefinition.Clause contentClause, boolean cascade, int startItemId) throws IOException {
        if (contentClause == null) {
            return null;
        }
        StringBuilder xml = new StringBuilder();
        if (contentClause.isContainer()) {
            boolean and;
            P8SearchDefinition.Container container = (P8SearchDefinition.Container)contentClause;
            List<P8SearchDefinition.Clause> clauses = container.getClauses();
            ArrayList<String> xmls = new ArrayList<String>();
            for (P8SearchDefinition.Clause clause : clauses) {
                String childXml = this.createXml(clause, cascade, startItemId++);
                if (childXml == null || childXml.length() == 0) continue;
                xmls.add(childXml);
            }
            P8SearchDefinition.Operator operator = container.getJoin();
            boolean bl = and = operator != null && operator == P8SearchDefinition.Operator.and;
            if (xmls.size() > 1) {
                this.wrapContentConditions(xmls, and, cascade, xml);
            } else if (xmls.size() == 1) {
                xml.append((String)xmls.get(0));
            }
        } else if (cascade) {
            this.createCascadeContentItemXml((P8SearchDefinition.ContentClauseItem)contentClause, startItemId++, xml);
        } else {
            this.createVerityContentItemXml((P8SearchDefinition.ContentClauseItem)contentClause, startItemId++, xml);
        }
        return xml.toString();
    }

    private void wrapContentConditions(List<String> conditions, boolean and, boolean cascade, StringBuilder xml) {
        String begin;
        String string = cascade ? (and ? "<and>" : "<or>") : (begin = and ? "<verityand>" : "<verityor>");
        String end = cascade ? (and ? "</and>" : "</or>") : (and ? "</verityand>" : "</verityor>");
        xml.append(begin);
        for (String query : conditions) {
            xml.append(query);
        }
        xml.append(end);
    }

    private void createCascadeContentItemXml(P8SearchDefinition.ContentClauseItem item, int itemId, StringBuilder xml) {
        List<P8SearchDefinition.ContentTerm> terms = item.getContentTerms();
        if (terms == null || terms.size() < 1) {
            return;
        }
        P8SearchDefinition.GroupAction groupAction = item.getGroupAction();
        String propName = item.getPropertySymbolicName();
        if (propName != null && propName.length() > 0) {
            xml.append("<field name=\"").append(propName).append("\">");
        }
        xml.append("<item editproperty=\"editable\" itemid=\"").append(itemId).append("\"");
        if (groupAction == P8SearchDefinition.GroupAction.all || groupAction == P8SearchDefinition.GroupAction.any) {
            xml.append(" groupaction=\"").append((Object)groupAction).append("\"");
        }
        P8SearchDefinition.RequiredState required = item.getRequiredState();
        if (item.isSearchModifierProximity()) {
            int range = item.getSearchModifierRange();
            if (range < 1) {
                range = 1024;
            }
            xml.append(" searchmodifier=\"proximity\" searchmodifierrange=\"").append(range).append("\"");
        } else if (required != P8SearchDefinition.RequiredState.none) {
            xml.append(" requiredstate=\"").append(required == P8SearchDefinition.RequiredState.required ? "required" : "prohibited").append("\"");
        }
        xml.append("><terms>");
        for (P8SearchDefinition.ContentTerm term : terms) {
            xml.append("<term");
            if (term.isPhrase()) {
                xml.append(" phrase=\"true\"");
            }
            xml.append(">").append(term.getValue()).append("</term>");
        }
        xml.append("</terms></item>");
        if (propName != null && propName.length() > 0) {
            xml.append("</field>");
        }
    }

    private void createVerityContentItemXml(P8SearchDefinition.ContentClauseItem item, int itemId, StringBuilder xml) {
        List<P8SearchDefinition.ContentTerm> terms = item.getContentTerms();
        if (terms == null || terms.size() < 1) {
            return;
        }
        P8SearchDefinition.GroupAction groupAction = item.getGroupAction();
        xml.append("<verityitem editproperty=\"editable\" itemid=\"").append(itemId).append("\"").append(" groupaction=\"").append((Object)groupAction).append("\">");
        xml.append("<usertext>").append(item.getUserText()).append("</usertext>").append("<verityitemdata>");
        if (groupAction == P8SearchDefinition.GroupAction.near) {
            xml.append("<veritynear");
            int distance = item.getSearchModifierRange();
            if (distance > 0) {
                xml.append(" distance=\"").append(distance).append("\"");
            }
            xml.append(">");
        } else if (groupAction != P8SearchDefinition.GroupAction.none) {
            xml.append("<verity").append((Object)groupAction).append(">");
        }
        for (P8SearchDefinition.ContentTerm term : terms) {
            P8SearchDefinition.VeritySearchOperator operator;
            xml.append("<verityunit");
            if (term.isProhibited()) {
                xml.append(" not=\"true\"");
            }
            if ((operator = term.getWordVariation()) != null) {
                xml.append(" wordvariation=\"").append((Object)operator).append("\"");
            }
            if (term.isPhrase()) {
                xml.append(">\"").append(term.getValue()).append("\"</verityunit>");
                continue;
            }
            xml.append(">").append(term.getValue()).append("</verityunit>");
        }
        if (groupAction != P8SearchDefinition.GroupAction.none) {
            xml.append("</verity").append((Object)groupAction).append(">");
        }
        xml.append("</verityitemdata></verityitem>");
    }

    private void populatePropertySymbolicName(P8SearchDefinition.Clause contentClause, String propertySymbolicName) {
        if (contentClause == null) {
            return;
        }
        if (contentClause.isContainer()) {
            P8SearchDefinition.Container container = (P8SearchDefinition.Container)contentClause;
            List<P8SearchDefinition.Clause> clauses = container.getClauses();
            for (P8SearchDefinition.Clause clause : clauses) {
                this.populatePropertySymbolicName(clause, propertySymbolicName);
            }
        } else {
            ((P8SearchDefinition.ContentClauseItem)contentClause).setPropertySymbolicName(propertySymbolicName);
        }
    }

    private void convertSearchCriterionToXml(StringBuilder xml, SearchCriterion criterion, SearchTemplate.ObjectType objectType, int itemId) throws Exception {
        this.convertSearchCriterionToXml(xml, criterion, objectType, itemId, null);
    }

    private void convertSearchCriterionToXml(StringBuilder xml, SearchCriterion criterion, SearchTemplate.ObjectType objectType, int itemId, String customAttributes) throws Exception {
        String xmlOperator = P8SearchUtil.convertP8SearchTemplateOperator(criterion.getOperator()).toString();
        xml.append("<").append(xmlOperator).append(">");
        String xmlSymName = criterion.getName();
        String xmlDataType = P8SearchUtil.convertP8SearchTemplateDataType(criterion.getDataType()).toString();
        xml.append("<whereprop editproperty=\"editable\" itemid=\"").append(itemId).append("\" name=\"").append(xmlSymName).append("\" objecttype=\"").append((Object)objectType).append("\" symname=\"").append(xmlSymName).append("\"");
        if (customAttributes != null) {
            xml.append(" ").append(customAttributes);
        }
        xml.append(">");
        xml.append("<propdesc datatype=\"").append(xmlDataType).append("\" haschoices=\"false\" hasmarkings=\"false\" symname=\"").append(xmlSymName).append("\" />");
        xml.append("</whereprop>");
        String xmlDefaultValue = "";
        if (criterion.getValues().length > 0 && (xmlDefaultValue = criterion.getValues()[0]) != null && !xmlDefaultValue.isEmpty() && P8SearchDefinition.DataType.valueOf(xmlDataType) == P8SearchDefinition.DataType.typedate) {
            Calendar cal = WCDateFormat.parseW3CDate(xmlDefaultValue, null);
            xmlDefaultValue = WCDateFormat.convertDateToW3CDate(cal, true);
        }
        xml.append("<literal><![CDATA[").append(xmlDefaultValue).append("]]></literal>");
        xml.append("</").append(xmlOperator).append(">");
    }

    private void validate(Teamspace teamspace, boolean autoResolve) throws Exception {
        SearchTemplate.Macros macros;
        P8SearchDefinition.SearchInObjectStore os;
        boolean autoResolved = false;
        List<P8SearchDefinition.SearchInObjectStore> objectStores = this.searchDefinition.getObjectStores();
        Iterator<P8SearchDefinition.SearchInObjectStore> itrOs = objectStores.iterator();
        while (itrOs.hasNext()) {
            os = itrOs.next();
            try {
                ObjectStore ceOs = P8Util.getObjectStore(this.connection, os.getId());
                os.setName(ceOs.get_DisplayName());
                os.setSymbolicName(ceOs.get_SymbolicName());
            }
            catch (EngineRuntimeException e) {
                ExceptionCode eCode = e.getExceptionCode();
                if (eCode == ExceptionCode.E_OBJECT_NOT_FOUND || eCode == ExceptionCode.E_OBJECT_DELETED || eCode == ExceptionCode.E_BAD_CLASSID) {
                    if (!autoResolve) {
                        throw new RuntimeException("search.exception.folderNotFound");
                    }
                    itrOs.remove();
                    autoResolved = true;
                    continue;
                }
                throw e;
            }
        }
        if (objectStores.size() < 1) {
            os = this.connection.getObjectStore();
            P8SearchDefinition.SearchInObjectStore searchOs = new P8SearchDefinition.SearchInObjectStore(os.get_Id().toString(), os.get_DisplayName());
            searchOs.setSymbolicName(os.get_SymbolicName());
            objectStores.add(searchOs);
        }
        List<P8SearchDefinition.SearchInFolder> folders = this.searchDefinition.getFolders();
        Iterator<P8SearchDefinition.SearchInFolder> itr = folders.iterator();
        while (itr.hasNext()) {
            P8SearchDefinition.SearchInFolder folder = itr.next();
            try {
                ObjectStore os2 = P8Util.getObjectStore(this.connection, folder.getObjectStoreId());
                String folderId = folder.getId();
                if (folderId.equals(SearchTemplate.THIS_TEAMSPACE_ID)) {
                    folder.setPathName(os2.get_SymbolicName() + "\\" + (teamspace != null ? teamspace.getName() : folderId));
                } else {
                    String pathName = P8Util.getFolderPathName(os2, folderId);
                    if (pathName.startsWith("/ClbTeamspaces")) {
                        int index = pathName.indexOf("/", "/ClbTeamspaces".length() + 1);
                        String teamspaceFolderPathName = index < 0 ? pathName : pathName.substring(0, index);
                        PropertyFilter propFilter = new PropertyFilter();
                        propFilter.addIncludeProperty(0, null, null, "ClbTeamspaceName", null);
                        Folder ceFolder = (Folder)os2.fetchObject("Folder", teamspaceFolderPathName, propFilter);
                        Properties properties = ceFolder.getProperties();
                        String teamspaceName = "/" + properties.getStringValue("ClbTeamspaceName");
                        pathName = index < 0 ? teamspaceName : teamspaceName + pathName.substring(index);
                    }
                    folder.setPathName(pathName);
                }
                folder.setObjectStoreId(os2.getObjectReference().getObjectIdentity());
                folder.setObjectStoreName(os2.get_SymbolicName());
            }
            catch (EngineRuntimeException e) {
                ExceptionCode eCode = e.getExceptionCode();
                if (eCode == ExceptionCode.E_OBJECT_NOT_FOUND || eCode == ExceptionCode.E_OBJECT_DELETED || eCode == ExceptionCode.E_BAD_CLASSID) {
                    if (!autoResolve) {
                        throw new RuntimeException("search.exception.folderNotFound");
                    }
                    itr.remove();
                    autoResolved = true;
                    continue;
                }
                throw e;
            }
        }
        ObjectStore os3 = P8Util.getObjectStore(this.connection, this.searchDefinition.getObjectStores().get(0).getId());
        List<P8SearchDefinition.SearchClause> clauses = this.searchDefinition.getSearchClauses();
        for (P8SearchDefinition.SearchClause clause : clauses) {
            SearchTemplate.ObjectType objectType = clause.getFrom();
            String className = null;
            List<P8SearchDefinition.Subclass> subclasses = clause.getSubclasses();
            Iterator<P8SearchDefinition.Subclass> itrClasses = subclasses.iterator();
            while (itrClasses.hasNext()) {
                P8SearchDefinition.Subclass subclass = itrClasses.next();
                try {
                    subclass.setDisplayName(P8Util.getClassDisplayName(os3, subclass.getSymbolicName()));
                    if (className != null) continue;
                    className = subclass.getSymbolicName();
                }
                catch (EngineRuntimeException e) {
                    ExceptionCode eCode = e.getExceptionCode();
                    if (eCode == ExceptionCode.E_OBJECT_NOT_FOUND || eCode == ExceptionCode.E_OBJECT_DELETED || eCode == ExceptionCode.E_BAD_CLASSID) {
                        if (!autoResolve) {
                            throw new RuntimeException("search.exception.classNotFound");
                        }
                        itrClasses.remove();
                        autoResolved = true;
                        continue;
                    }
                    throw e;
                }
            }
            if (className == null) {
                className = objectType == SearchTemplate.ObjectType.folder ? "Folder" : "Document";
                String displayName = P8Util.getClassDisplayName(os3, className);
                P8SearchDefinition.Subclass subclass = new P8SearchDefinition.Subclass(className, displayName, objectType, SearchTemplate.SearchEditProperty.editable, null, true);
                subclasses.add(subclass);
            }
            Collection<P8SearchDefinition.ClauseItem> conditions = clause.retrieveWhereClauseConditions().values();
            Iterator<P8SearchDefinition.ClauseItem> itrConditions = conditions.iterator();
            while (itrConditions.hasNext()) {
                P8SearchDefinition.WhereClauseCondition condition = (P8SearchDefinition.WhereClauseCondition)itrConditions.next();
                String symbolicName = condition.getPropSymbolicName();
                String literal = condition.getLiteral();
                String displayName = P8Util.getPropertyDisplayName(os3, className, symbolicName);
                if (displayName == null) {
                    if (!autoResolve) {
                        throw new RuntimeException("search.exception.propertyNotFound");
                    }
                    itrConditions.remove();
                    autoResolved = true;
                    continue;
                }
                condition.setPropName(displayName);
                if (literal == null || literal.length() <= 0 || !symbolicName.equals("Creator") && !symbolicName.equals("LastModifier") && !symbolicName.equals("Owner")) continue;
                try {
                    User user = Factory.User.fetchInstance((Connection)this.connection.getCEConnection(), (String)literal, null);
                    condition.setLabel(user.get_DisplayName());
                }
                catch (EngineRuntimeException e) {
                    condition.setLabel(literal);
                }
            }
        }
        int searchType = 0;
        try {
            searchType = P8Util.getPropertyIntegerValue((IndependentObject)os3, "CBRSearchType");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (searchType == 0) {
            for (P8SearchDefinition.SearchClause clause : clauses) {
                if (!clause.isContentCriteriaDefined()) continue;
                if (!autoResolve) {
                    throw new RuntimeException("search.exception.textSearchNotFound");
                }
                clause.setContentCriteria(null);
                autoResolved = true;
            }
        }
        if ((macros = this.searchTemplate.getMacros()) != null) {
            SearchTemplate.UserAction[] userActions;
            String[] fileTypes = macros.getFileTypes();
            if (fileTypes != null && fileTypes.length > 0) {
                Map<String, FileTypeConfig> configMap = this.getFileTypeConfigMap();
                if (configMap.isEmpty()) {
                    if (!autoResolve) {
                        throw new RuntimeException("search.exception.fileTypeConfigNotFound");
                    }
                    macros.setFileTypes(null);
                    autoResolved = true;
                } else {
                    ArrayList<String> fileTypeList = new ArrayList<String>();
                    for (String fileType : fileTypes) {
                        if (!configMap.containsKey(fileType)) {
                            if (!autoResolve) {
                                throw new RuntimeException("search.exception.fileTypeConfigNotFound");
                            }
                            autoResolved = true;
                            continue;
                        }
                        if (!autoResolve) continue;
                        fileTypeList.add(fileType);
                    }
                    if (autoResolved) {
                        macros.setFileTypes(fileTypeList.toArray(new String[fileTypeList.size()]));
                    }
                }
            }
            if ((userActions = macros.getUserActions()) != null) {
                for (SearchTemplate.UserAction userAction : userActions) {
                    String[] users = userAction.getUsers();
                    if (users == null) continue;
                    String[] userDisplayNames = new String[users.length];
                    int i = 0;
                    for (String userName : users) {
                        if (userName.equals("{ME}")) {
                            userDisplayNames[i++] = userName;
                            continue;
                        }
                        try {
                            User user = Factory.User.fetchInstance((Connection)this.connection.getCEConnection(), (String)userName, null);
                            userDisplayNames[i++] = user.get_DisplayName();
                        }
                        catch (EngineRuntimeException e) {
                            userDisplayNames[i++] = userName;
                        }
                    }
                    userAction.setUserDisplayNames(userDisplayNames);
                }
            }
        }
        this.searchDefinition.setAutoResolved(autoResolved);
        this.searchDefinition.setDatabaseType(os3.get_DatabaseType().getValue());
    }

    private Map<String, FileTypeConfig> getFileTypeConfigMap() throws ConfigurationException, MissingValueException {
        String appName = this.request.getParameter("application");
        if (appName == null || appName.isEmpty()) {
            appName = "navigator";
        }
        SettingsConfig settingsConfig = Config.getSettingsConfig(appName);
        return settingsConfig.getFileTypesMap(appName);
    }
}

