/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.p8.P8SearchDefinition;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8SearchTemplate
extends SearchTemplate {
    private String productName;
    private List<P8SearchDefinition.SearchInObjectStore> objectStores;
    private CriteriaLayout textSearchCriteriaLayout;
    private boolean operatorHidden;
    private boolean criteriaRelationshipHidden;
    private P8SearchDefinition searchDefinition = null;

    public P8SearchTemplate() {
    }

    public P8SearchTemplate(P8SearchDefinition searchDefinition) {
        this.searchDefinition = searchDefinition;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void addObjectStore(P8SearchDefinition.SearchInObjectStore objectStore) {
        if (this.objectStores == null) {
            this.objectStores = new ArrayList<P8SearchDefinition.SearchInObjectStore>();
        }
        this.objectStores.add(objectStore);
    }

    public List<P8SearchDefinition.SearchInObjectStore> getObjectStores() {
        return this.objectStores;
    }

    public CriteriaLayout getTextSearchCriteriaLayout() {
        return this.textSearchCriteriaLayout;
    }

    public void setTextSearchCriteriaLayout(CriteriaLayout textSearchCriteriaLayout) {
        this.textSearchCriteriaLayout = textSearchCriteriaLayout;
    }

    public boolean isOperatorHidden() {
        return this.operatorHidden;
    }

    public void setOperatorHidden(boolean operatorHidden) {
        this.operatorHidden = operatorHidden;
    }

    public boolean isCriteriaRelationshipHidden() {
        return this.criteriaRelationshipHidden;
    }

    public void setCriteriaRelationshipHidden(boolean criteriaRelationshipHidden) {
        this.criteriaRelationshipHidden = criteriaRelationshipHidden;
    }

    public boolean isCascade() {
        SearchTemplate.TextSearchType type = this.getTextSearchType();
        return type == null || type == SearchTemplate.TextSearchType.cascade;
    }

    public P8SearchDefinition getSearchDefinition() {
        return this.searchDefinition;
    }

    void setSearchDefinition(P8SearchDefinition searchDefinition) {
        this.searchDefinition = searchDefinition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CriteriaLayout {
        private String join;
        private List<String> itemIds;
        private List<CriteriaLayout> childLayouts;

        CriteriaLayout(String join) {
            this.join = join;
        }

        public String getJoin() {
            return this.join;
        }

        public void setJoin(String join) {
            this.join = join;
        }

        public List<String> getItemIds() {
            return this.itemIds;
        }

        public void setItemIds(List<String> itemIds) {
            this.itemIds = itemIds;
        }

        public void addItemId(String itemId) {
            if (this.itemIds == null) {
                this.itemIds = new ArrayList<String>();
            }
            this.itemIds.add(itemId);
        }

        public void removeItemId(String itemId) {
            if (this.itemIds != null) {
                this.itemIds.remove(itemId);
            }
        }

        public int getItemIdsSize() {
            if (this.itemIds == null) {
                return 0;
            }
            return this.itemIds.size();
        }

        public List<CriteriaLayout> getChildLayouts() {
            return this.childLayouts;
        }

        public void setChildLayouts(List<CriteriaLayout> childLayouts) {
            this.childLayouts = childLayouts;
        }

        public void addChildLayout(CriteriaLayout childLayout) {
            if (this.childLayouts == null) {
                this.childLayouts = new ArrayList<CriteriaLayout>();
            }
            this.childLayouts.add(childLayout);
        }

        public void removeChildLayout(CriteriaLayout childLayout) {
            if (this.childLayouts != null) {
                this.childLayouts.remove(childLayout);
            }
        }

        public int getChildLayoutsSize() {
            if (this.childLayouts == null) {
                return 0;
            }
            return this.childLayouts.size();
        }

        public boolean isEmpty() {
            boolean empty = true;
            if (this.itemIds != null && this.itemIds.size() > 0) {
                empty = false;
            }
            if (this.childLayouts != null && this.childLayouts.size() > 0) {
                empty = false;
            }
            return empty;
        }

        public JSONObject toJSON() {
            JSONObject json = new JSONObject();
            json.put("criteriaLayoutJoin", this.join == null || this.join.length() < 1 ? P8SearchDefinition.Operator.and.toString() : this.join);
            if (this.itemIds != null && this.itemIds.size() > 0) {
                for (String itemId : this.itemIds) {
                    JSONUtils.accumulate(json, "criteriaLayoutItemIds", itemId);
                }
            }
            if (this.childLayouts != null && this.childLayouts.size() > 0) {
                for (CriteriaLayout layout : this.childLayouts) {
                    JSONUtils.accumulate(json, "criteriaLayoutChildLayouts", layout.toJSON());
                }
            }
            return json;
        }
    }
}

