/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.core.ObjectStore;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.FileTypeConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.UserActionMacroConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.util.ForwardPager;
import com.ibm.ecm.util.SearchCriteria;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.p8.P8CeSearchUtilProxy;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Iterator;
import com.ibm.ecm.util.p8.P8QueryContinuationData;
import com.ibm.ecm.util.p8.P8SearchDefinition;
import com.ibm.ecm.util.p8.P8SearchTemplate;
import com.ibm.ecm.util.p8.P8SearchUtil;
import com.ibm.ecm.util.p8.P8TextSearchUtil;
import com.ibm.ecm.util.p8.P8Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8SearchRunner {
    private static final String[] DOCUMENT_ADDITIONAL_SELECT_PROPS = new String[]{"LastModifier", "DateLastModified", "ContentSize", "ClassDescription", "IsCurrentVersion", "IsReserved", "Reservation", "MimeType", "VersionStatus", "MajorVersionNumber", "MinorVersionNumber", "VersionSeries", "Id", "ReplicationGroup", "Creator", "ReservationType", "IsVersioningEnabled", "Owner", "EntryTemplateObjectStoreName", "EntryTemplateId", "EntryTemplateLaunchedWorkflowNumber"};
    private static final String[] FOLDER_ADDITIONAL_SELECT_PROPS = new String[]{"ClassDescription", "Id", "ContainerType"};
    private static final String PROPERTY_TABLE_ALIAS = "t";
    private static final String CONTENT_TABLE_ALIAS = "c";
    private static final String K2VQL = "K2VQL";
    private static final String LUCENE = "Lucene";
    private HttpServletRequest request;
    private P8Connection connection;
    private P8SearchTemplate searchTemplate;
    private P8SearchDefinition searchDefinition;
    private String storedSearchId;
    private String teamspaceId;
    private P8QueryContinuationData queryData;

    public P8SearchRunner(HttpServletRequest request, P8Connection connection, P8SearchTemplate searchTemplate, String storedSearchId, String teamspaceId) {
        this.request = request;
        this.connection = connection;
        this.searchTemplate = searchTemplate;
        this.searchDefinition = searchTemplate.getSearchDefinition();
        this.storedSearchId = storedSearchId;
        this.teamspaceId = teamspaceId;
    }

    public P8SearchRunner(HttpServletRequest request, P8Connection connection, P8QueryContinuationData continuationData) {
        this.request = request;
        this.connection = connection;
        this.queryData = continuationData;
    }

    public List<Object> runSearch(String orderBy, boolean orderDescending, int pageSize, int maxResults, int timeout) throws Exception {
        block9: {
            block8: {
                Object searchParams;
                SearchTemplate.ObjectType objectType;
                block10: {
                    if (this.searchTemplate == null) {
                        return null;
                    }
                    if (this.searchTemplate.getResultsDisplay() != null && (orderBy == null || orderBy.length() == 0)) {
                        orderBy = this.searchTemplate.getResultsDisplay().getSortByProperty();
                        orderDescending = !this.searchTemplate.getResultsDisplay().getSortAscending();
                    }
                    List<P8SearchDefinition.SearchInObjectStore> objectStores = this.searchTemplate.getObjectStores();
                    String[] osIds = new String[objectStores.size()];
                    for (int i = 0; i < objectStores.size(); ++i) {
                        String osId;
                        osIds[i] = osId = objectStores.get(i).getId();
                    }
                    this.convertToP8SearchDefinition();
                    this.queryData = new P8QueryContinuationData();
                    this.queryData.orderByRank = orderBy != null && orderBy.equalsIgnoreCase("Rank");
                    this.queryData.descending = orderDescending;
                    this.queryData.setObjectStoreIds(osIds);
                    this.queryData.mergeUnion = this.searchDefinition.isMergeOptionUnion();
                    if (this.storedSearchId == null || this.storedSearchId.isEmpty() || this.searchDefinition.isApiIncompatible() || !P8CeSearchUtilProxy.isStoredSearchSupported()) break block8;
                    ObjectStore searchStore = P8Util.getObjectStore(this.request, this.connection, this.storedSearchId);
                    this.queryData.ceStoredSearch = P8CeSearchUtilProxy.getStoredSearch(searchStore, this.storedSearchId);
                    objectType = this.searchTemplate.getObjectType();
                    P8SearchDefinition.SearchClause clause = this.searchDefinition.getSearchClause(objectType);
                    if (clause == null) break block9;
                    searchParams = P8CeSearchUtilProxy.convertToCeSearchParameters(this.connection, clause, orderBy, orderDescending, !this.searchDefinition.isTemplate());
                    if (objectType != SearchTemplate.ObjectType.folder) break block10;
                    this.queryData.ceFolderSearchParams = searchParams;
                    break block9;
                }
                if (objectType != SearchTemplate.ObjectType.document) break block9;
                this.queryData.ceDocumentSearchParams = searchParams;
                break block9;
            }
            Map<SearchTemplate.ObjectType, String> listOfSearches = this.getQueries(orderBy, orderDescending, maxResults, timeout);
            for (Map.Entry<SearchTemplate.ObjectType, String> e : listOfSearches.entrySet()) {
                String sqlString = e.getValue();
                SearchTemplate.ObjectType key = e.getKey();
                if (key == SearchTemplate.ObjectType.folder) {
                    this.queryData.folderSQL = sqlString;
                    continue;
                }
                if (key != SearchTemplate.ObjectType.document) continue;
                this.queryData.documentSQL = sqlString;
            }
        }
        P8Iterator itr = new P8Iterator((ServletRequest)this.request, this.connection, this.queryData, pageSize);
        ForwardPager<Object> pager = new ForwardPager<Object>(itr, pageSize);
        List<Object> hits = pager.loadNextPage();
        if (!pager.isEndReached()) {
            this.queryData.sessionKey = Long.toString(System.currentTimeMillis(), 36);
            this.queryData.itemsToSkip = pager.getNumberOfItemsRetrieved();
            this.queryData.checkpoint = itr.getNextPageCheckpoint();
            if (!P8CeSearchUtilProxy.isCascadeSupported()) {
                this.request.getSession().setAttribute(this.queryData.sessionKey, pager);
            }
        }
        if (pager.isEndReached() || P8CeSearchUtilProxy.isCascadeSupported()) {
            itr.reset();
        }
        return hits;
    }

    public List<Object> retrieveNextPage(int pageSize, int itemsNeeded, int itemsToSkip) throws Exception {
        if (this.queryData == null) {
            return null;
        }
        P8Iterator itr = null;
        HttpSession session = this.request.getSession();
        ForwardPager<Object> pager = (ForwardPager<Object>)session.getAttribute(this.queryData.sessionKey);
        if (pager == null) {
            itr = new P8Iterator((ServletRequest)this.request, this.connection, this.queryData, pageSize);
            pager = new ForwardPager<Object>(itr, pageSize);
        }
        List<Object> hits = pager.loadNextPage();
        if (itemsNeeded > 0) {
            if (itemsToSkip > 0) {
                itemsNeeded -= itemsToSkip;
            }
            while (itemsNeeded > pager.getNumberOfItemsRetrieved() && !pager.isEndReached()) {
                List nextPage = pager.loadNextPage();
                hits.addAll(nextPage);
            }
        }
        if (pager.isEndReached()) {
            session.removeAttribute(this.queryData.sessionKey);
            this.queryData = null;
        } else {
            this.queryData.itemsToSkip = pager.getNumberOfItemsRetrieved();
            if (itr != null) {
                this.queryData.checkpoint = itr.getNextPageCheckpoint();
            }
        }
        if (itr != null && (pager.isEndReached() || P8CeSearchUtilProxy.isCascadeSupported())) {
            itr.reset();
        }
        return hits;
    }

    public String getQueryContinuationData() throws UnsupportedEncodingException {
        return this.queryData == null || this.queryData.sessionKey == null ? null : this.queryData.saveToString();
    }

    private Map<SearchTemplate.ObjectType, String> getQueries(String sortProperty, boolean sortDescending, int maxResult, int timeout) throws Exception {
        List<P8SearchDefinition.SearchInFolder> folders = this.searchDefinition.getFolders();
        if (folders != null) {
            for (P8SearchDefinition.SearchInFolder folder : folders) {
                if (!folder.getId().equals(SearchTemplate.THIS_TEAMSPACE_ID)) continue;
                if (this.teamspaceId != null && this.teamspaceId.length() > 0) {
                    folder.setId(this.teamspaceId);
                    continue;
                }
                throw new UnsupportedOperationException("search.exception.unsupportedTeamspaceSearch");
            }
        }
        boolean isRecordRepository = this.connection.isRecordObjectStore();
        boolean isSearchAddOnInstalled = this.connection.isSearchAddOnInstalled();
        HashMap<SearchTemplate.ObjectType, String> queries = new HashMap<SearchTemplate.ObjectType, String>();
        P8SearchDefinition.SearchClause commonClause = this.searchDefinition.getSearchClause(SearchTemplate.ObjectType.common);
        SearchTemplate.VersionOption versionSelection = this.searchDefinition.getVersionSelection();
        P8SearchDefinition.SearchClause searchClause = this.searchDefinition.getSearchClause(SearchTemplate.ObjectType.document);
        if (searchClause != null) {
            ArrayList<String> additionalPropertiesList = new ArrayList<String>(Arrays.asList(DOCUMENT_ADDITIONAL_SELECT_PROPS));
            if (isRecordRepository) {
                additionalPropertiesList.add("RecordInformation");
            }
            List<P8SearchDefinition.Subclass> subclasses = searchClause.getSubclasses();
            if (isSearchAddOnInstalled && subclasses != null) {
                for (P8SearchDefinition.Subclass subclass : subclasses) {
                    if (!subclass.getSymbolicName().equals("StoredSearch") && (!subclass.getSymbolicName().equals("Document") || !subclass.isSearchSubclasses())) continue;
                    additionalPropertiesList.add("IcnAutoRun");
                    additionalPropertiesList.add("IcnShowInTree");
                    break;
                }
            }
            String query = this.getQuery(searchClause, commonClause, additionalPropertiesList, folders, versionSelection, sortProperty, sortDescending, maxResult, timeout);
            queries.put(SearchTemplate.ObjectType.document, query);
        }
        if ((searchClause = this.searchDefinition.getSearchClause(SearchTemplate.ObjectType.folder)) != null) {
            ArrayList<String> additionalProperties = new ArrayList<String>(Arrays.asList(FOLDER_ADDITIONAL_SELECT_PROPS));
            String query = this.getQuery(searchClause, commonClause, additionalProperties, folders, null, sortProperty, sortDescending, maxResult, timeout);
            queries.put(SearchTemplate.ObjectType.folder, query);
        }
        return queries;
    }

    private String getQuery(P8SearchDefinition.SearchClause searchClause, P8SearchDefinition.SearchClause commonClause, List<String> additionalSelectProps, List<P8SearchDefinition.SearchInFolder> folders, SearchTemplate.VersionOption versionSelection, String sortProperty, boolean sortDescending, int maxResult, int timeout) throws Exception {
        String orderByClause;
        String versionClause;
        String classClause;
        if (searchClause == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String selectClause = this.getSelectClause(searchClause.getSelectProperties(), additionalSelectProps, sortProperty);
        String from = "[" + searchClause.getFrom().toString() + "] " + PROPERTY_TABLE_ALIAS;
        StringBuilder where = new StringBuilder();
        String folderClause = this.getFolderClause(folders);
        if (folderClause != null) {
            where.append(folderClause);
        }
        String whereClause = this.getWhereClause(searchClause.getWhereClause(), commonClause == null ? null : commonClause.getWhereClause());
        String macroClause = this.getMacroClause();
        if (!macroClause.isEmpty()) {
            if (!whereClause.isEmpty()) {
                whereClause = whereClause + " AND ";
            }
            whereClause = whereClause + macroClause;
        }
        P8SearchDefinition.ContentCriteria contentCriteria = searchClause.getContentCriteria();
        String contentClause = this.getContentClause(contentCriteria);
        if (whereClause != null && whereClause.length() > 0 || contentClause != null && contentClause.length() > 0) {
            boolean contentClauseDefined;
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("(");
            if (whereClause != null && whereClause.length() > 0) {
                where.append("(").append(whereClause).append(")");
            }
            boolean bl = contentClauseDefined = contentClause != null && contentClause.length() > 0;
            if (searchClause.isPropertyContentCriteriaDefined() || contentClauseDefined) {
                P8SearchDefinition.JoinType join;
                P8SearchDefinition.JoinType joinType = join = contentClauseDefined ? contentCriteria.getJoin() : P8SearchDefinition.JoinType.inner;
                if (join != P8SearchDefinition.JoinType.inner && whereClause != null && whereClause.length() > 0) {
                    join = P8SearchDefinition.JoinType.leftouter;
                    from = from + " LEFT OUTER";
                } else {
                    join = P8SearchDefinition.JoinType.inner;
                    from = from + " INNER";
                }
                from = from + " JOIN ContentSearch c on t.This = c.QueriedObject";
                if (whereClause != null && whereClause.length() > 0) {
                    if (join == P8SearchDefinition.JoinType.inner) {
                        where.append(" AND ");
                    } else {
                        where.append(" OR ");
                    }
                }
                if (contentClauseDefined) {
                    where.append(this.createContentClause(contentClause, contentCriteria.isCascade(), null));
                }
                if (sortProperty != null && sortProperty.equalsIgnoreCase("Rank")) {
                    selectClause = selectClause + ", c.[Rank]";
                }
            }
            where.append(")");
        }
        if ((classClause = this.getClassClause(searchClause.getSubclasses())) != null && classClause.length() > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(classClause);
        }
        if (searchClause.getFrom() == SearchTemplate.ObjectType.document && (versionClause = this.getVersionClause(versionSelection)) != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(versionClause);
        }
        if ((orderByClause = this.getOrderByClause(sortProperty, sortDescending)) == null) {
            orderByClause = this.getOrderByClause(searchClause.getSelectProperties());
        }
        buffer.append("SELECT ");
        if (maxResult > 0) {
            buffer.append("TOP " + maxResult + " ");
        }
        buffer.append(selectClause);
        buffer.append(" FROM ").append(from);
        if (where.length() > 0) {
            buffer.append(" WHERE ").append((CharSequence)where);
        }
        if (orderByClause != null && orderByClause.length() > 0) {
            buffer.append(" ORDER BY ");
            buffer.append(orderByClause);
        }
        if (timeout > 0) {
            buffer.append(" OPTIONS (TIMELIMIT " + timeout + ")");
        }
        return buffer.toString();
    }

    private String createContentClause(String contentClause, boolean cascade, String scope) {
        String dialect;
        String string = dialect = cascade ? LUCENE : K2VQL;
        if (scope == null || scope.length() < 1) {
            scope = "*";
        }
        return " Contains(" + scope + ", '" + contentClause + "', '" + dialect + "')";
    }

    private String getSelectClause(List<P8SearchDefinition.SelectProperty> selectProps, List<String> additionalSelectProps, String sortProperty) {
        StringBuilder buffer = new StringBuilder();
        if (selectProps != null) {
            for (P8SearchDefinition.SelectProperty selectProp : selectProps) {
                String name = selectProp.getSymbolicName();
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append("t.[").append(name).append("]");
            }
        }
        if (additionalSelectProps != null) {
            for (String name : additionalSelectProps) {
                if (selectProps != null && selectProps.contains(name)) continue;
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append("t.[").append(name).append("]");
            }
        }
        return buffer.toString();
    }

    private String getOrderByClause(String sortProperty, boolean descending) {
        if (sortProperty == null || sortProperty.length() == 0) {
            return null;
        }
        if (sortProperty.equals("!MimeTypeIcon")) {
            sortProperty = "MimeType";
        } else if (sortProperty.equals("!Name")) {
            sortProperty = "DocumentTitle";
        }
        String orderBy = (sortProperty.equalsIgnoreCase("Rank") ? CONTENT_TABLE_ALIAS : PROPERTY_TABLE_ALIAS) + ".[" + sortProperty + (descending ? "] DESC" : "]");
        return orderBy;
    }

    private String getOrderByClause(List<P8SearchDefinition.SelectProperty> selectProps) {
        if (selectProps == null || selectProps.size() < 1) {
            return null;
        }
        Map<String, P8SearchDefinition.SelectProperty> sortProps = this.getSortedProperties(selectProps);
        if (sortProps == null || sortProps.size() < 1) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (P8SearchDefinition.SelectProperty selectProp : sortProps.values()) {
            String name = selectProp.getSymbolicName();
            P8SearchDefinition.SortOrder so = selectProp.getSortOrder();
            if (so == P8SearchDefinition.SortOrder.none) continue;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("t.[").append(name).append("] ");
            if (so == P8SearchDefinition.SortOrder.ascending) {
                buffer.append("ASC");
                continue;
            }
            if (so != P8SearchDefinition.SortOrder.descending) continue;
            buffer.append("DESC");
        }
        return buffer.toString();
    }

    private Map<String, P8SearchDefinition.SelectProperty> getSortedProperties(List<P8SearchDefinition.SelectProperty> selectProps) {
        if (selectProps == null || selectProps.size() < 1) {
            return null;
        }
        TreeMap<String, P8SearchDefinition.SelectProperty> sortProps = new TreeMap<String, P8SearchDefinition.SelectProperty>();
        for (P8SearchDefinition.SelectProperty selectProp : selectProps) {
            int sl = selectProp.getSortLevel();
            if (sl <= 0) continue;
            String sortLevel = String.valueOf(sl);
            sortProps.put(sortLevel, selectProp);
        }
        return sortProps;
    }

    private String getFolderClause(List<P8SearchDefinition.SearchInFolder> folders) {
        if (folders == null || folders.size() < 1) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (P8SearchDefinition.SearchInFolder folder : folders) {
            String id = folder.getId();
            boolean subfolders = folder.isSearchSubfolders();
            if (buffer.length() > 0) {
                buffer.append(" OR ");
            }
            buffer.append("t.This");
            if (subfolders) {
                buffer.append(" InSubfolder ");
            } else {
                buffer.append(" InFolder ");
            }
            buffer.append("'").append(id).append("'");
        }
        if (buffer.length() > 0) {
            buffer.insert(0, "(");
            buffer.append(")");
        }
        return buffer.toString();
    }

    private String getWhereClause(P8SearchDefinition.Clause whereClause, P8SearchDefinition.Clause commonWhereClause) throws ParseException, IOException {
        if (whereClause == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        if (whereClause.isContainer()) {
            P8SearchDefinition.Container wcc = (P8SearchDefinition.Container)whereClause;
            String join = wcc.getJoin().toString();
            List<P8SearchDefinition.Clause> whereClauses = wcc.getClauses();
            boolean wrap = false;
            for (P8SearchDefinition.Clause wc : whereClauses) {
                String c = this.getWhereClause(wc, commonWhereClause);
                if (c == null || c.length() == 0) continue;
                if (buffer.length() > 0) {
                    buffer.append(" ").append(join).append(" ");
                    wrap = true;
                }
                buffer.append(c);
            }
            if (wrap) {
                buffer.insert(0, "(");
                buffer.append(")");
            }
        } else if (whereClause == P8SearchDefinition.COMMON_CLAUSE) {
            buffer.append(this.getWhereClause(commonWhereClause, null));
        } else {
            P8SearchDefinition.WhereClauseCondition wcc = (P8SearchDefinition.WhereClauseCondition)whereClause;
            buffer.append(this.getWhereClauseCondition(wcc));
        }
        return buffer.toString();
    }

    private String getWhereClauseCondition(P8SearchDefinition.WhereClauseCondition whereClauseCondition) throws ParseException, IOException {
        int databaseType;
        String value = whereClauseCondition.getLiteral();
        if (value == null) {
            value = "";
        }
        P8SearchDefinition.Operator operator = whereClauseCondition.getOperator();
        P8SearchDefinition.DataType dataType = whereClauseCondition.getPropDataType();
        if (operator != P8SearchDefinition.Operator.isnull && operator != P8SearchDefinition.Operator.isnotnull) {
            if (value.length() == 0) {
                return "";
            }
            if (operator == P8SearchDefinition.Operator.contains) {
                SearchTemplate.TextSearchCriterion textCriterion = new SearchTemplate.TextSearchCriterion(value, P8SearchDefinition.GroupAction.none.toString(), 0);
                P8SearchDefinition.SearchClause searchClause = whereClauseCondition.getSearchClause();
                boolean cascade = searchClause.getSearchDefinition().isCascade();
                P8SearchDefinition.Clause contentClause = P8TextSearchUtil.createContentClause(textCriterion, cascade, searchClause, true);
                String contentQuery = this.createCascadeQuery(contentClause);
                return this.createContentClause(contentQuery, cascade, whereClauseCondition.getPropSymbolicName());
            }
            if (dataType == P8SearchDefinition.DataType.typestring) {
                value = "'" + value.replaceAll("'", "''") + "'";
            } else if (dataType == P8SearchDefinition.DataType.typeobject && !value.startsWith("{")) {
                value = "'" + value + "'";
            }
        }
        if ((databaseType = whereClauseCondition.getDatabaseType()) == 1 && (operator == P8SearchDefinition.Operator.like || operator == P8SearchDefinition.Operator.notlike)) {
            value = value.replaceAll("\\[", "[[]");
        }
        String condition = "";
        String name = "t.[" + whereClauseCondition.getPropSymbolicName() + "]";
        if (dataType == P8SearchDefinition.DataType.typedate && value.length() > 0 && (condition = this.getDateCondition(name, value, operator)).isEmpty()) {
            Calendar cal = WCDateFormat.parseW3CDate(value, null);
            value = WCDateFormat.getDateString(null, cal.getTimeInMillis(), WCDateFormat.UTC_DATE_FORMAT);
        }
        if (condition.length() < 1) {
            switch (operator) {
                case gt: {
                    condition = condition + name + " > " + value;
                    break;
                }
                case gte: {
                    condition = condition + name + " >= " + value;
                    break;
                }
                case lt: {
                    condition = condition + name + " < " + value;
                    break;
                }
                case lte: {
                    condition = condition + name + " <= " + value;
                    break;
                }
                case eq: {
                    if (dataType == P8SearchDefinition.DataType.typeobject) {
                        condition = condition + name + " = Object(" + value + ")";
                        break;
                    }
                    condition = condition + name + " = " + value;
                    break;
                }
                case neq: {
                    if (dataType == P8SearchDefinition.DataType.typeobject) {
                        condition = condition + "NOT (" + name + " = Object(" + value + "))";
                        break;
                    }
                    condition = condition + name + " <> " + value;
                    break;
                }
                case like: {
                    condition = condition + name + " LIKE " + value;
                    break;
                }
                case notlike: {
                    condition = condition + "NOT (" + name + " LIKE " + value + ")";
                    break;
                }
                case in: 
                case inany: {
                    condition = condition + value + " IN " + name;
                    break;
                }
                case notin: {
                    condition = condition + "NOT (" + value + " IN " + name + ")";
                    break;
                }
                case isnull: {
                    condition = condition + name + " IS NULL";
                    break;
                }
                case isnotnull: {
                    condition = condition + name + " IS NOT NULL";
                    break;
                }
            }
        }
        return condition;
    }

    private String getDateCondition(String propName, String date, P8SearchDefinition.Operator operator) throws ParseException {
        Calendar cal = WCDateFormat.parseW3CDate(date, null);
        String[] dates = WCDateFormat.getDateRangeStrings(null, cal.getTimeInMillis(), WCDateFormat.UTC_DATE_FORMAT);
        String currentDay = dates[0];
        String nextDay = dates[1];
        return this.getDateCondition(propName, currentDay, nextDay, operator);
    }

    private String getDateCondition(String propName, String beginDate, String endDate, P8SearchDefinition.Operator operator) throws ParseException {
        String condition = "";
        switch (operator) {
            case eq: {
                condition = condition + "(" + propName + " >= " + beginDate + " AND ";
                condition = condition + propName + " < " + endDate + ")";
                break;
            }
            case lte: {
                condition = condition + propName + " < " + endDate;
                break;
            }
            case neq: {
                condition = condition + "(" + propName + " < " + beginDate + " OR ";
                condition = condition + propName + " >= " + endDate + ")";
                break;
            }
            case gt: {
                condition = condition + propName + " >= " + endDate;
                break;
            }
            case lt: {
                condition = condition + propName + " < " + beginDate;
            }
        }
        return condition;
    }

    String getMacroClause() throws ParseException, ConfigurationException, MissingValueException {
        String clause = this.getFileTypeConditions();
        String actionClause = this.getUserActionConditions();
        if (!clause.isEmpty() && !actionClause.isEmpty()) {
            clause = clause + " AND ";
        }
        clause = clause + actionClause;
        return clause;
    }

    private String getFileTypeConditions() throws ConfigurationException, MissingValueException {
        SearchTemplate.Macros macros = this.searchTemplate.getMacros();
        if (macros == null) {
            return "";
        }
        String[] fileTypes = macros.getFileTypes();
        if (fileTypes == null || fileTypes.length < 1) {
            return "";
        }
        Map<String, FileTypeConfig> fileTypeConfigMap = this.getFileTypeConfigMap();
        if (fileTypeConfigMap.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String fileType : fileTypes) {
            String[] mimeTypes;
            FileTypeConfig fileTypeConfig;
            if (fileType == null || fileType.isEmpty() || (fileTypeConfig = fileTypeConfigMap.get(fileType)) == null || (mimeTypes = fileTypeConfig.getContentTypes()) == null || mimeTypes.length <= 0) continue;
            for (int i = 0; i < mimeTypes.length; ++i) {
                String operator;
                if (mimeTypes[i] == null || mimeTypes[i].isEmpty()) continue;
                String type = mimeTypes[i].replaceAll("\\*", "%");
                String string = operator = type.indexOf("%") > -1 ? " LIKE " : " = ";
                if (buffer.length() > 0) {
                    buffer.append(" OR ");
                }
                buffer.append(PROPERTY_TABLE_ALIAS).append(".[").append("MimeType").append("]").append(operator).append("'").append(type).append("'");
            }
        }
        if (buffer.length() > 0) {
            buffer.insert(0, "(").append(")");
        }
        return buffer.toString();
    }

    private String getUserActionConditions() throws ParseException, ConfigurationException, MissingValueException {
        SearchTemplate.Macros macros = this.searchTemplate.getMacros();
        if (macros == null) {
            return "";
        }
        SearchTemplate.UserAction[] userActions = macros.getUserActions();
        if (userActions == null || userActions.length < 1) {
            return "";
        }
        Map<String, UserActionMacroConfig> configMap = this.getMacroConfigMap(UserActionMacroConfig.class);
        if (configMap.isEmpty()) {
            return "";
        }
        StringBuilder totalBuffer = new StringBuilder();
        for (SearchTemplate.UserAction userAction : userActions) {
            UserActionMacroConfig config;
            String action = userAction.getAction();
            if (action == null || action.isEmpty() || (config = configMap.get(action)).isEmpty()) continue;
            StringBuilder buffer = new StringBuilder();
            String[] users = userAction.getUsers();
            if (users != null && users.length > 0) {
                String actionByProp = config.getUserProperty();
                for (String user : users) {
                    if (user == null || user.isEmpty()) continue;
                    if (user.equals("{ME}")) {
                        user = this.connection.getUserId();
                    }
                    if (buffer.length() > 0) {
                        buffer.append(" OR ");
                    }
                    buffer.append(PROPERTY_TABLE_ALIAS).append(".[").append(actionByProp).append("] = ").append("'").append(user).append("'");
                }
                if (buffer.length() > 0) {
                    buffer.insert(0, "(").append(")");
                }
            }
            boolean joined = false;
            String[] dates = userAction.getDates();
            if (dates != null && dates.length > 0) {
                P8SearchDefinition.Operator op;
                String dateProp = "t.[" + config.getDateProperty() + "]";
                String dateOp = userAction.getDateOperator();
                String dateCondition = "";
                P8SearchDefinition.Operator operator = op = dateOp == null || dateOp.isEmpty() ? P8SearchDefinition.Operator.eq : P8SearchUtil.convertP8SearchTemplateOperator(dateOp);
                if (op == P8SearchDefinition.Operator.between && dates != null && dates.length > 1) {
                    Calendar cal = WCDateFormat.parseW3CDate(dates[0], null);
                    String beginDate = WCDateFormat.getDateString(null, cal.getTimeInMillis(), WCDateFormat.UTC_DATE_FORMAT);
                    cal = WCDateFormat.parseW3CDate(dates[1], null);
                    String endDate = WCDateFormat.getDateRangeStrings(null, cal.getTimeInMillis(), WCDateFormat.UTC_DATE_FORMAT)[1];
                    dateCondition = this.getDateCondition(dateProp, beginDate, endDate, P8SearchDefinition.Operator.eq);
                } else {
                    if (op == P8SearchDefinition.Operator.between) {
                        op = P8SearchDefinition.Operator.eq;
                    }
                    String date = dates == null || dates.length < 1 ? null : dates[0];
                    String string = dateCondition = date == null || date.isEmpty() ? "" : this.getDateCondition(dateProp, date, op);
                }
                if (!dateCondition.isEmpty()) {
                    if (buffer.length() > 0) {
                        joined = true;
                        buffer.append(" AND ");
                    }
                    buffer.append(dateCondition);
                }
            }
            if (config.isReserved()) {
                if (buffer.length() > 0) {
                    joined = true;
                    buffer.append(" AND ");
                }
                buffer.append(PROPERTY_TABLE_ALIAS).append(".[").append("IsReserved").append("] = true");
            }
            if (joined) {
                buffer.insert(0, "(").append(")");
            }
            if (totalBuffer.length() > 0) {
                totalBuffer.append(" OR ");
            }
            totalBuffer.append((CharSequence)buffer);
        }
        return totalBuffer.toString();
    }

    private String getClassClause(List<P8SearchDefinition.Subclass> classes) {
        if (P8SearchUtil.isSearchingAllClasses(classes)) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (P8SearchDefinition.Subclass subclass : classes) {
            if (subclass.isUnselected()) continue;
            if (buffer.length() > 0) {
                buffer.append(" OR ");
            }
            buffer.append(subclass.isSearchSubclasses() ? "IsOfClass(" : "IsClass(").append(PROPERTY_TABLE_ALIAS).append(", [").append(subclass.getSymbolicName()).append("])");
        }
        if (buffer.length() > 0) {
            buffer.insert(0, "(");
            buffer.append(")");
        }
        return buffer.toString();
    }

    private String getVersionClause(SearchTemplate.VersionOption versionSelection) {
        if (versionSelection == SearchTemplate.VersionOption.currentversion) {
            return "t.IsCurrentVersion = true";
        }
        if (versionSelection == SearchTemplate.VersionOption.releasedversion) {
            return "t.VersionStatus = 1";
        }
        return null;
    }

    private String getContentClause(P8SearchDefinition.ContentCriteria contentCriteria) throws IOException {
        if (contentCriteria == null) {
            return null;
        }
        if (contentCriteria.isCascade()) {
            return this.createCascadeQuery(contentCriteria.getContentClause());
        }
        return this.createVerityQuery(contentCriteria.getContentClause(), contentCriteria.isShowRank());
    }

    private void convertToP8SearchDefinition() throws Exception {
        SearchTemplate.ObjectType objectType;
        P8SearchDefinition.SearchClause searchClause;
        if (this.searchDefinition == null) {
            this.searchDefinition = new P8SearchDefinition();
        }
        if ((searchClause = this.searchDefinition.getSearchClause(objectType = this.searchTemplate.getObjectType())) == null) {
            searchClause = new P8SearchDefinition.SearchClause(objectType.toString());
            this.searchDefinition.addSearchClause(searchClause);
        }
        this.convertP8SearchTemplateSelectProperties();
        this.convertP8SearchTemplateFolders();
        this.convertP8SearchTemplateClass();
        boolean wasIcnMatchAll = P8SearchUtil.isIcnMatchAllSearchClause(searchClause);
        Set<String> propItemIds = searchClause.retrieveWhereClauseConditions().keySet();
        Set<String> textItemIds = searchClause.retrieveContentClauseItems().keySet();
        this.convertP8SearchTemplateSearchCriteria();
        this.convertP8SearchTemplateTextSearchCriteria();
        this.searchDefinition.setTextSearchType(this.searchTemplate.getTextSearchType());
        this.checkIfSearchClauseIsApiCompatible(searchClause, wasIcnMatchAll, propItemIds, textItemIds);
        SearchTemplate.VersionOption versionOption = this.searchTemplate.getVersionOption();
        if (versionOption != null) {
            this.searchDefinition.setVersionSelection(versionOption.toString());
        }
    }

    private void checkIfSearchClauseIsApiCompatible(P8SearchDefinition.SearchClause searchClause, boolean wasIcnMatchAll, Set<String> propItemIds, Set<String> textItemIds) {
        boolean incompatible;
        P8SearchDefinition sd = searchClause.getSearchDefinition();
        if (sd.isApiIncompatible()) {
            return;
        }
        boolean bl = incompatible = this.searchDefinition.isIcnGenerated() && P8SearchUtil.isIcnMatchAllSearchClause(searchClause) != wasIcnMatchAll;
        if (!incompatible) {
            boolean bl2 = incompatible = !this.isSearchClauseCompatible(searchClause.retrieveWhereClauseConditions().values(), propItemIds);
        }
        if (!incompatible) {
            incompatible = !this.isSearchClauseCompatible(searchClause.retrieveContentClauseItems().values(), textItemIds);
        }
        sd.setApiIncompatible(incompatible);
    }

    private boolean isSearchClauseCompatible(Collection<P8SearchDefinition.ClauseItem> conditions, Set<String> itemIds) {
        boolean compatible = true;
        if (conditions.size() != itemIds.size()) {
            compatible = false;
        } else {
            for (P8SearchDefinition.ClauseItem item : conditions) {
                String itemId = item.getItemId();
                if (itemId != null && !itemId.isEmpty() && itemIds.contains(itemId)) continue;
                compatible = false;
                break;
            }
        }
        return compatible;
    }

    private boolean isAnyValueSet(String[] values) {
        if (values == null) {
            return false;
        }
        boolean set = false;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].isEmpty()) continue;
            set = true;
            break;
        }
        return set;
    }

    private void convertP8SearchTemplateSelectProperties() {
        String[] columns;
        SearchTemplate.ObjectType objectType = this.searchTemplate.getObjectType();
        P8SearchDefinition.SearchClause searchClause = this.searchDefinition.getSearchClause(objectType);
        SearchTemplate.ResultsDisplay display = this.searchTemplate.getResultsDisplay();
        String[] stringArray = columns = display != null ? display.getColumns() : null;
        if (columns != null && columns.length > 0) {
            String sortBy = display.getSortByProperty();
            boolean asc = display.getSortAscending();
            ArrayList<P8SearchDefinition.SelectProperty> selectProps = new ArrayList<P8SearchDefinition.SelectProperty>();
            for (int i = 0; i < columns.length; ++i) {
                P8SearchDefinition.SelectProperty prop = this.applySelectProperty(searchClause, columns[i], columns[i].equals(sortBy) ? 1 : 0, asc ? P8SearchDefinition.SortOrder.ascending : P8SearchDefinition.SortOrder.descending, null, objectType);
                selectProps.add(prop);
            }
            searchClause.setSelectProperties(selectProps);
        } else {
            String namePropName;
            String string = namePropName = objectType == SearchTemplate.ObjectType.document ? "DocumentTitle" : "FolderName";
            if (this.searchDefinition.isIcnGenerated()) {
                ArrayList<P8SearchDefinition.SelectProperty> selectProps = new ArrayList<P8SearchDefinition.SelectProperty>();
                selectProps.add(this.applySelectProperty(searchClause, namePropName, 1, P8SearchDefinition.SortOrder.ascending, null, objectType));
                List<SearchCriteria> searchCriteria = this.searchTemplate.getSearchCriteria();
                for (SearchCriteria criteriaEntry : searchCriteria) {
                    SearchCriterion criterion = (SearchCriterion)criteriaEntry;
                    if (criterion.getName().equalsIgnoreCase(namePropName)) continue;
                    selectProps.add(this.applySelectProperty(searchClause, criterion.getName(), 0, null, criterion.getDisplayName(), objectType));
                }
                searchClause.setSelectProperties(selectProps);
            } else {
                List<P8SearchDefinition.SelectProperty> selectProps = searchClause.getSelectProperties();
                P8SearchDefinition.SelectProperty nameProp = searchClause.getSelectProperty(namePropName);
                if (nameProp == null) {
                    nameProp = new P8SearchDefinition.SelectProperty(namePropName, null, objectType, 0, null, null);
                    Map<String, P8SearchDefinition.SelectProperty> sortProps = this.getSortedProperties(selectProps);
                    if (sortProps == null || sortProps.size() < 1) {
                        nameProp.setSortLevel(1);
                        nameProp.setSortOrder(P8SearchDefinition.SortOrder.ascending);
                    }
                    selectProps.add(nameProp);
                }
            }
        }
    }

    private P8SearchDefinition.SelectProperty applySelectProperty(P8SearchDefinition.SearchClause searchClause, String propSymbolicName, int sortLevel, P8SearchDefinition.SortOrder sortOrder, String propName, SearchTemplate.ObjectType objectType) {
        P8SearchDefinition.SelectProperty prop = searchClause.getSelectProperty(propSymbolicName);
        if (prop == null) {
            prop = new P8SearchDefinition.SelectProperty(propSymbolicName, propName, objectType, sortLevel, sortOrder, null);
            prop.setItemId(UUID.randomUUID().toString());
        } else {
            prop.setSortLevel(sortLevel);
            prop.setSortOrder(sortOrder);
        }
        return prop;
    }

    private void convertP8SearchTemplateFolders() {
        List<SearchTemplate.SearchFolder> folders = this.searchTemplate.getFolders();
        if (folders == null) {
            return;
        }
        ArrayList<P8SearchDefinition.SearchInFolder> searchInFolders = new ArrayList<P8SearchDefinition.SearchInFolder>();
        for (SearchTemplate.SearchFolder folder : folders) {
            P8SearchDefinition.SearchInFolder searchInFolder = new P8SearchDefinition.SearchInFolder(folder.getId(), folder.getPathName(), folder.isSearchSubfolders(), folder.getView(), folder.getObjectStoreId());
            searchInFolder.setItemId(folder.getItemId());
            searchInFolders.add(searchInFolder);
        }
        this.searchDefinition.setFolders(searchInFolders);
    }

    private void convertP8SearchTemplateClass() {
        SearchTemplate.ObjectType objectType = this.searchTemplate.getObjectType();
        P8SearchDefinition.SearchClause searchClause = this.searchDefinition.getSearchClause(objectType);
        List<P8SearchDefinition.Subclass> subclasses = searchClause.getSubclasses();
        for (P8SearchDefinition.Subclass sc : subclasses) {
            sc.setUnselected(true);
        }
        List<SearchTemplate.SearchClass> classes = this.searchTemplate.getClasses();
        if (this.isSearchingAllClasses()) {
            return;
        }
        for (SearchTemplate.SearchClass searchClass : classes) {
            this.applySubclass(searchClass, searchClause);
        }
    }

    private boolean isSearchingAllClasses() {
        List<SearchTemplate.SearchClass> classes = this.searchTemplate.getClasses();
        if (classes == null || classes.size() < 1) {
            return true;
        }
        boolean searchingAll = false;
        if (classes.size() == 1) {
            boolean rootClass;
            SearchTemplate.SearchClass subclass = classes.get(0);
            String classSymName = subclass.getName();
            SearchTemplate.ObjectType objectType = subclass.getObjectType();
            boolean bl = rootClass = objectType == SearchTemplate.ObjectType.document && classSymName.equals("Document") || objectType == SearchTemplate.ObjectType.folder && classSymName.equals("Folder");
            if (rootClass && subclass.isSearchSubclasses()) {
                searchingAll = true;
            }
        }
        return searchingAll;
    }

    private void applySubclass(SearchTemplate.SearchClass searchClass, P8SearchDefinition.SearchClause searchClause) {
        P8SearchDefinition.Subclass subclass;
        String itemId = searchClass.getItemId();
        if (itemId == null || itemId.isEmpty()) {
            itemId = UUID.randomUUID().toString();
        }
        if ((subclass = searchClause.getSubclass(itemId)) == null) {
            subclass = new P8SearchDefinition.Subclass(searchClass.getName(), searchClass.getDisplayName(), searchClass.getObjectType(), searchClass.getEditProperty(), searchClass.getItemId(), searchClass.isSearchSubclasses());
            searchClause.addSubclass(subclass);
        } else {
            subclass.setSearchSubclasses(searchClass.isSearchSubclasses());
            subclass.setUnselected(false);
        }
    }

    private void convertP8SearchTemplateSearchCriteria() throws Exception {
        SearchTemplate.ObjectType objectType = this.searchTemplate.getObjectType();
        P8SearchDefinition.SearchClause searchClause = this.searchDefinition.getSearchClause(objectType);
        ArrayList<P8SearchDefinition.Clause> conditions = new ArrayList<P8SearchDefinition.Clause>();
        List<SearchCriterion> searchCriteria = this.searchTemplate.getPropertySearchCriteria();
        for (SearchCriterion criteriaEntry : searchCriteria) {
            String value;
            SearchCriterion criterion = criteriaEntry;
            SearchTemplate.SearchEditProperty view = criterion.isHidden() ? SearchTemplate.SearchEditProperty.hidden : (criterion.isReadOnly() ? SearchTemplate.SearchEditProperty.readonly : (criterion.isRequired() ? SearchTemplate.SearchEditProperty.required : SearchTemplate.SearchEditProperty.editable));
            String[] values = criterion.getValues();
            boolean valueSet = this.isAnyValueSet(values);
            String criterionOperator = criterion.getOperator();
            P8SearchDefinition.Operator operator = P8SearchUtil.convertP8SearchTemplateOperator(criterionOperator);
            P8SearchDefinition.DataType dataType = P8SearchUtil.convertP8SearchTemplateDataType(criterion.getDataType());
            String[] itemIds = criterion.getItemId().split(",");
            if (valueSet && this.isSmartOperator(operator)) {
                String name = criterion.getName();
                String displayName = criterion.getDisplayName();
                P8SearchDefinition.Container container = operator == P8SearchDefinition.Operator.between || operator == P8SearchDefinition.Operator.notbetween ? this.explodeBetweenCondition(searchClause, name, displayName, dataType, operator, values, view) : this.explodeIncludeCondition(searchClause, name, displayName, dataType, operator, values, view, criterion.getCardinality());
                if (container.getClauses().size() > 0) {
                    conditions.add(container);
                }
                if (this.searchDefinition.isIcnGenerated()) continue;
                this.applySmartOperatorConditions(itemIds[0], container, searchClause);
                continue;
            }
            String string = value = values == null || values.length < 1 ? null : values[0];
            if (operator == P8SearchDefinition.Operator.like || operator == P8SearchDefinition.Operator.notlike || operator == P8SearchDefinition.Operator.startswith || operator == P8SearchDefinition.Operator.endswith) {
                value = P8SearchUtil.convertLikeValue(value, operator);
                if (operator != P8SearchDefinition.Operator.notlike) {
                    operator = P8SearchDefinition.Operator.like;
                }
            }
            for (int i = 0; i < itemIds.length; ++i) {
                P8SearchDefinition.WhereClauseCondition condition = this.applyWhereClauseCondition(searchClause, itemIds[i], operator, value, criterion.getName(), criterion.getDisplayName(), dataType, view, null);
                value = null;
                conditions.add(condition);
            }
        }
        if (this.searchDefinition.isIcnGenerated()) {
            if (conditions.size() > 1) {
                P8SearchDefinition.Container container = new P8SearchDefinition.Container(this.searchTemplate.isAndSearch() ? P8SearchDefinition.Operator.and : P8SearchDefinition.Operator.or);
                container.setClauses(conditions);
                container.setSearchClause(searchClause);
                searchClause.setWhereClause(container);
            } else if (conditions.size() == 1) {
                searchClause.setWhereClause((P8SearchDefinition.Clause)conditions.get(0));
            } else {
                searchClause.setWhereClause(null);
            }
        }
    }

    private boolean isSmartOperator(P8SearchDefinition.Operator operator) {
        return operator == P8SearchDefinition.Operator.between || operator == P8SearchDefinition.Operator.notbetween || operator == P8SearchDefinition.Operator.in || operator == P8SearchDefinition.Operator.notin || operator == P8SearchDefinition.Operator.inany;
    }

    private void applySmartOperatorConditions(String itemId, P8SearchDefinition.Container container, P8SearchDefinition.SearchClause searchClause) {
        P8SearchDefinition.WhereClauseCondition condition = searchClause.getWhereClauseCondition(itemId);
        P8SearchDefinition.Container originalContainer = condition.getContainer();
        if (originalContainer == null) {
            P8SearchDefinition.SearchClause clause = condition.getSearchClause();
            clause.setWhereClause(container);
        } else if (originalContainer.isInclude() || originalContainer.isRange()) {
            originalContainer.setClauses(container.getClauses());
        } else {
            originalContainer.replaceClause(condition, container);
        }
    }

    private P8SearchDefinition.WhereClauseCondition applyWhereClauseCondition(P8SearchDefinition.SearchClause searchClause, String itemId, P8SearchDefinition.Operator operator, String value, String propSymbolicName, String propName, P8SearchDefinition.DataType propDataType, SearchTemplate.SearchEditProperty editProperty, P8SearchDefinition.Container container) {
        P8SearchDefinition.WhereClauseCondition condition = searchClause.getWhereClauseCondition(itemId);
        if (condition == null) {
            condition = new P8SearchDefinition.WhereClauseCondition(operator, propSymbolicName, propName, searchClause.getFrom(), propDataType, false, null, false, editProperty, value);
            condition.setSearchClause(searchClause);
            condition.setItemId(itemId);
            if (container != null) {
                container.addClause(condition);
            }
        } else {
            condition.setOperator(operator);
            condition.setLiteral(value);
        }
        return condition;
    }

    private P8SearchDefinition.Container explodeIncludeCondition(P8SearchDefinition.SearchClause searchClause, String name, String displayName, P8SearchDefinition.DataType dataType, P8SearchDefinition.Operator operator, String[] values, SearchTemplate.SearchEditProperty view, String cardinality) throws Exception {
        P8SearchDefinition.Container container = new P8SearchDefinition.Container(operator == P8SearchDefinition.Operator.inany ? P8SearchDefinition.Operator.or : P8SearchDefinition.Operator.and);
        container.setSearchClause(searchClause);
        if (cardinality.equals("SINGLE")) {
            P8SearchDefinition.Operator operator2 = operator = operator == P8SearchDefinition.Operator.inany ? P8SearchDefinition.Operator.eq : P8SearchDefinition.Operator.neq;
        }
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                this.applyWhereClauseCondition(searchClause, null, operator, value, name, displayName, dataType, view, container);
            }
        }
        return container;
    }

    private P8SearchDefinition.Container explodeBetweenCondition(P8SearchDefinition.SearchClause searchClause, String name, String displayName, P8SearchDefinition.DataType dataType, P8SearchDefinition.Operator operator, String[] values, SearchTemplate.SearchEditProperty view) throws Exception {
        boolean between = operator == P8SearchDefinition.Operator.between;
        P8SearchDefinition.Container container = new P8SearchDefinition.Container(between ? P8SearchDefinition.Operator.and.toString() : P8SearchDefinition.Operator.or.toString());
        if (values != null && values.length > 0) {
            String value;
            container.setSearchClause(searchClause);
            if (values[0] != null && !values[0].isEmpty()) {
                value = values[0];
                this.applyWhereClauseCondition(searchClause, null, between ? P8SearchDefinition.Operator.gte : P8SearchDefinition.Operator.lt, value, name, displayName, dataType, view, container);
            }
            if (values.length > 1 && values[1] != null && !values[1].isEmpty()) {
                value = values[1];
                this.applyWhereClauseCondition(searchClause, null, between ? P8SearchDefinition.Operator.lte : P8SearchDefinition.Operator.gt, value, name, displayName, dataType, view, container);
            }
        }
        return container;
    }

    private void convertP8SearchTemplateTextSearchCriteria() throws Exception {
        boolean sortByRank;
        P8SearchDefinition.SearchClause searchClause = this.searchDefinition.getSearchClause(this.searchTemplate.getObjectType());
        List<SearchTemplate.TextSearchCriterion> textSearchCriteria = this.searchTemplate.getTextSearchCriteria();
        String sortProperty = this.searchTemplate.getResultsDisplay().getSortByProperty();
        boolean bl = sortByRank = sortProperty != null && sortProperty.equalsIgnoreCase("Rank");
        if (this.searchDefinition.isIcnGenerated()) {
            List<SearchCriterion> propTextCriteria = this.searchTemplate.getPropertyTextSearchCriteria();
            if (!(textSearchCriteria != null && textSearchCriteria.size() >= 1 || propTextCriteria != null && propTextCriteria.size() >= 1)) {
                return;
            }
            boolean cascade = this.searchTemplate.isCascade();
            P8SearchDefinition.Clause contentClause = null;
            P8SearchDefinition.Clause propContentClause = null;
            if (textSearchCriteria != null && textSearchCriteria.size() > 0) {
                SearchTemplate.TextSearchCriterion criterion = textSearchCriteria.get(0);
                contentClause = P8TextSearchUtil.createContentClause(criterion, cascade, searchClause, true);
            }
            if (propTextCriteria != null && propTextCriteria.size() > 0) {
                propContentClause = P8TextSearchUtil.createContentClause(propTextCriteria, cascade, searchClause, true);
            }
            if (contentClause != null || propContentClause != null) {
                P8SearchDefinition.Clause clause;
                if (contentClause != null && propContentClause != null) {
                    clause = new P8SearchDefinition.Container(P8SearchDefinition.Operator.and);
                    clause.setSearchClause(searchClause);
                    ((P8SearchDefinition.Container)clause).addClause(contentClause);
                    ((P8SearchDefinition.Container)clause).addClause(propContentClause);
                } else {
                    clause = contentClause != null ? contentClause : propContentClause;
                }
                P8SearchDefinition.ContentCriteria contentCriteria = new P8SearchDefinition.ContentCriteria();
                contentCriteria.setContentClause(clause);
                contentCriteria.setJoin(P8SearchDefinition.JoinType.inner);
                contentCriteria.setShowRank(sortByRank);
                contentCriteria.setTextSearchType(cascade ? SearchTemplate.TextSearchType.cascade : SearchTemplate.TextSearchType.verity);
                contentCriteria.setSearchClause(searchClause);
                searchClause.setContentCriteria(contentCriteria);
            }
        } else {
            if (textSearchCriteria == null || textSearchCriteria.size() < 1) {
                return;
            }
            P8SearchDefinition.ContentCriteria definedCriteria = searchClause.getContentCriteria();
            definedCriteria.setShowRank(sortByRank);
            for (SearchTemplate.TextSearchCriterion criterion : textSearchCriteria) {
                String itemId = criterion.getItemId();
                P8SearchDefinition.ContentClauseItem oldClause = searchClause.getContentClauseItem(itemId);
                P8SearchDefinition.Clause newClause = P8TextSearchUtil.createContentClause(criterion, definedCriteria.isCascade(), searchClause, true);
                P8SearchDefinition.Container container = oldClause.getContainer();
                if (container == null) {
                    definedCriteria.setContentClause(newClause);
                    continue;
                }
                container.replaceClause(oldClause, newClause);
            }
        }
    }

    private String createCascadeQuery(P8SearchDefinition.Clause cascadeClause) throws IOException {
        if (cascadeClause == null) {
            return null;
        }
        StringBuilder textQuery = new StringBuilder();
        if (cascadeClause.isContainer()) {
            P8SearchDefinition.Container container = (P8SearchDefinition.Container)cascadeClause;
            List<P8SearchDefinition.Clause> clauses = container.getClauses();
            ArrayList<String> queries = new ArrayList<String>();
            for (P8SearchDefinition.Clause clause : clauses) {
                String query = this.createCascadeQuery(clause);
                if (query == null || query.length() == 0) continue;
                queries.add(query);
            }
            P8SearchDefinition.Operator operator = container.getJoin();
            boolean and = operator != null && operator == P8SearchDefinition.Operator.and;
            for (String query : queries) {
                if (textQuery.length() > 0) {
                    textQuery.append(and ? " AND " : " OR ");
                }
                textQuery.append(query);
            }
            if (queries.size() > 1) {
                textQuery.insert(0, "(").append(")");
            }
        } else {
            P8SearchDefinition.ContentClauseItem item = (P8SearchDefinition.ContentClauseItem)cascadeClause;
            List<P8SearchDefinition.ContentTerm> terms = item.getContentTerms();
            if (terms == null || terms.size() < 1) {
                return null;
            }
            String propName = item.getPropertySymbolicName();
            boolean fielded = propName != null && propName.length() > 0;
            P8SearchDefinition.RequiredState required = item.getRequiredState();
            P8SearchDefinition.GroupAction groupAction = item.getGroupAction();
            for (P8SearchDefinition.ContentTerm term : terms) {
                String value;
                if (textQuery.length() > 0) {
                    textQuery.append(" ");
                    textQuery.append(groupAction == P8SearchDefinition.GroupAction.all ? "AND " : "OR ");
                }
                if ((value = term.getValue()) == null || value.isEmpty()) continue;
                if (term.isPhrase() && !item.isSearchModifierProximity()) {
                    value.replaceAll("\"", "\\\"");
                    value = "\"" + value + "\"";
                }
                if (required == P8SearchDefinition.RequiredState.prohibited) {
                    value = fielded ? "(-" + value + ")" : "-" + value;
                }
                textQuery.append(value);
            }
            if (textQuery.length() > 0) {
                if (item.isSearchModifierProximity()) {
                    int range = item.getSearchModifierRange();
                    if (range < 1) {
                        range = 1024;
                    }
                    for (int i = 0; i < textQuery.length(); ++i) {
                        if (textQuery.charAt(i) != '\"' || i != 0 && textQuery.charAt(i - 1) == '\\') continue;
                        textQuery.insert(i, "\\");
                    }
                    textQuery.insert(0, "\"").append("\"~").append(range);
                } else if (terms.size() > 1 && textQuery.length() > 0) {
                    textQuery.insert(0, "(");
                    textQuery.append(")");
                }
                if (fielded) {
                    textQuery.insert(0, propName + ":");
                }
            }
        }
        return textQuery.toString();
    }

    private String createVerityQuery(P8SearchDefinition.Clause verityClause, boolean showRank) {
        StringBuilder buffer = new StringBuilder();
        if (verityClause != null) {
            if (verityClause.isContainer()) {
                P8SearchDefinition.Container verityContainer = (P8SearchDefinition.Container)verityClause;
                List<P8SearchDefinition.Clause> verityClauses = verityContainer.getClauses();
                for (P8SearchDefinition.Clause vc : verityClauses) {
                    String clause = this.createVerityQuery(vc, showRank);
                    if (clause == null || clause.length() == 0) continue;
                    if (buffer.length() > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(clause);
                }
                if (buffer.length() > 0) {
                    buffer.insert(0, "<" + (Object)((Object)verityContainer.getJoin()) + "> (");
                    buffer.append(")");
                }
            } else {
                P8SearchDefinition.GroupAction groupAction = ((P8SearchDefinition.ContentClauseItem)verityClause).getGroupAction();
                String clause = groupAction == P8SearchDefinition.GroupAction.in ? this.createVerityInItemClause((P8SearchDefinition.VerityClauseInItem)verityClause, showRank) : (groupAction == P8SearchDefinition.GroupAction.vql ? this.createVerityVQLItemClause((P8SearchDefinition.VerityClauseVQLItem)verityClause) : this.createVerityGenericItemClause((P8SearchDefinition.ContentClauseItem)verityClause, showRank));
                if (clause != null && clause.length() > 0) {
                    buffer.append(clause);
                }
            }
        }
        return buffer.toString();
    }

    private String createVerityGenericItemClause(P8SearchDefinition.ContentClauseItem verityItem, boolean showRank) {
        StringBuilder buffer = new StringBuilder();
        List<P8SearchDefinition.ContentTerm> units = verityItem.getContentTerms();
        for (P8SearchDefinition.ContentTerm unit : units) {
            String clause = this.createVerityUnitClause(unit, showRank);
            if (clause == null || clause.length() <= 0) continue;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(clause);
        }
        if (buffer.length() > 0) {
            P8SearchDefinition.GroupAction groupAction = verityItem.getGroupAction();
            String operator = "";
            if (groupAction == P8SearchDefinition.GroupAction.near) {
                int distance = verityItem.getSearchModifierRange();
                operator = distance > 0 ? "<near/" + distance + ">" : "<near>";
            } else if (groupAction != P8SearchDefinition.GroupAction.none) {
                operator = "<" + (Object)((Object)groupAction) + ">";
            }
            buffer.insert(0, operator + " (");
            if (showRank) {
                buffer.insert(0, "<Many> ");
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    private String createVerityInItemClause(P8SearchDefinition.VerityClauseInItem verityItem, boolean showRank) {
        String zone = verityItem.getZone();
        if (zone == null || zone.length() == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        List<P8SearchDefinition.ContentTerm> units = verityItem.getContentTerms();
        for (P8SearchDefinition.ContentTerm unit : units) {
            String clause = this.createVerityUnitClause(unit, showRank);
            if (clause == null || clause.length() <= 0) continue;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(clause);
        }
        if (buffer.length() > 0) {
            buffer.insert(0, "(<Any> (");
            buffer.append(")) ");
            if (showRank) {
                buffer.append("<Many> ");
            }
            buffer.append("<In> ");
            buffer.append(zone);
        }
        return buffer.toString();
    }

    private String createVerityVQLItemClause(P8SearchDefinition.VerityClauseVQLItem verityItem) {
        String vql = verityItem.getVql();
        vql = vql.replaceAll("'", "''");
        return vql;
    }

    private String createVerityUnitClause(P8SearchDefinition.ContentTerm verityUnit, boolean showRank) {
        P8SearchDefinition.VeritySearchOperator operator;
        String value = verityUnit.getValue();
        if (value == null || value.length() == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (verityUnit.isCaseSensitive()) {
            buffer.append("<Case> ");
        }
        if (verityUnit.isProhibited()) {
            buffer.append("<Not> ");
        }
        if (verityUnit.isPhrase()) {
            value = "\"" + value + "\"";
        }
        if ((operator = verityUnit.getWordVariation()) != null) {
            if (operator == P8SearchDefinition.VeritySearchOperator.soundex) {
                buffer.append("<Soundex> ");
            } else if (operator == P8SearchDefinition.VeritySearchOperator.stem) {
                if (showRank) {
                    buffer.append("<Many> ");
                }
                buffer.append("<Stem> ");
            } else if (operator == P8SearchDefinition.VeritySearchOperator.thesaurus) {
                buffer.append("<Thesaurus> ");
            } else if (operator == P8SearchDefinition.VeritySearchOperator.wildcard) {
                if (showRank) {
                    buffer.append("<Many> ");
                }
                buffer.append("<Wildcard> ");
            } else if (operator == P8SearchDefinition.VeritySearchOperator.word) {
                if (showRank) {
                    buffer.append("<Many> ");
                }
                buffer.append("<Word> ");
            }
        }
        buffer.append(value);
        return buffer.toString();
    }

    Map<String, FileTypeConfig> getFileTypeConfigMap() throws ConfigurationException, MissingValueException {
        return this.getMacroConfigMap(FileTypeConfig.class);
    }

    <T extends ConfigurationObject> Map<String, T> getMacroConfigMap(Class<T> configClass) throws ConfigurationException, MissingValueException {
        String appName = this.request.getParameter("application");
        if (appName == null || appName.isEmpty()) {
            appName = "navigator";
        }
        SettingsConfig settingsConfig = Config.getSettingsConfig(appName);
        return settingsConfig.getMacrosMap(appName, configClass);
    }
}

