/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.core.IndependentObject;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.p8.P8HitSorter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class P8SearchResultsBean
implements Serializable,
Enumeration {
    private static final long serialVersionUID = 8731157793062169124L;
    private List hits;
    private Iterator hitsIterator;
    protected HttpServletRequest request;
    private boolean hasFolderContents = false;

    public P8SearchResultsBean(HttpServletRequest request) {
        this.request = request;
        this.hits = new ArrayList(0);
        this.hitsIterator = this.hits.iterator();
        Logger.logDebug((Object)this, "WCSearchResultsBean()", (ServletRequest)request, "In constructor()");
    }

    public P8SearchResultsBean(HttpServletRequest request, List newHits, boolean hasFolderContents) {
        this.request = request;
        this.hasFolderContents = hasFolderContents;
        this.initialize(newHits);
    }

    public P8SearchResultsBean(HttpServletRequest request, List newHits) {
        this.request = request;
        this.initialize(newHits);
    }

    private void initialize(List newHits) {
        String methodName = "initialize";
        if (newHits != null) {
            this.hits = newHits;
            this.hitsIterator = newHits.iterator();
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "In constructor(Vector newHits)");
        if (newHits != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Number of items in Vector => " + newHits.size());
        }
    }

    public void reset() {
        this.hitsIterator = this.hits.iterator();
    }

    public boolean hasMoreElements() {
        return this.hitsIterator.hasNext();
    }

    public Object nextElement() {
        return this.hitsIterator.next();
    }

    public int size() {
        return this.hits.size();
    }

    public void sort(boolean ascending, String columnName) {
        IndependentObject[] theHits = this.hits.toArray(new IndependentObject[0]);
        Arrays.sort(theHits, new P8HitSorter(ascending, columnName));
        this.hits = new ArrayList<IndependentObject>(Arrays.asList(theHits));
        this.reset();
    }

    public List getHits() {
        return this.hits;
    }

    public void setHits(List hits) {
        this.hits = hits;
    }

    public void setHasFolderContents(boolean value) {
        this.hasFolderContents = value;
    }

    public boolean hasFolderContents() {
        return this.hasFolderContents;
    }
}

