/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.p8.P8SearchDefinition;
import com.ibm.ecm.util.p8.P8SearchUtil;
import com.ibm.ecm.util.p8.P8TextSearchUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RegexMatcher;
import org.apache.commons.digester.RegexRules;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.SimpleRegexMatcher;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class P8SearchDefinitionParser {
    static P8SearchDefinition parse(InputStream definition) throws IOException, SAXException {
        Digester digester = new Digester();
        SimpleRegexMatcher m = new SimpleRegexMatcher();
        digester.setRules((Rules)new RegexRules((RegexMatcher)m));
        digester.setValidating(false);
        P8SearchDefinitionParser.addSearchDefinitionParsingRules(digester);
        return (P8SearchDefinition)digester.parse(definition);
    }

    private static void addSearchDefinitionParsingRules(Digester digester) {
        digester.addRule("storedsearch", (Rule)new SearchDefinitionRule());
        digester.addRule("storedsearch/version", (Rule)new InfoAndOptionsRule());
        digester.addRule("storedsearch/product", (Rule)new InfoAndOptionsRule());
        digester.addRule("storedsearch/searchspec", (Rule)new InfoAndOptionsRule());
        digester.addRule("storedsearch/searchspec/searchtype/template", (Rule)new InfoAndOptionsRule());
        digester.addRule("storedsearch/searchspec/objectstores", (Rule)new InfoAndOptionsRule());
        digester.addRule("storedsearch/searchspec/options", (Rule)new InfoAndOptionsRule());
        digester.addRule("storedsearch/searchspec/objectstores/objectstore", (Rule)new ObjectStoreRule());
        digester.addRule("storedsearch/searchspec/searchcriteria/folders/folder", (Rule)new FolderRule());
        digester.addRule("storedsearch/searchspec/searchcriteria/folders/folder/objectstore", (Rule)new FolderObjectStoreRule());
        digester.addRule("storedsearch/searchspec/searchcriteria/searchclauses/searchclause", (Rule)new SearchClauseRule());
        digester.addRule("storedsearch/searchspec/searchcriteria/searchclauses/searchclause/from/class", (Rule)new SearchClauseObjectTypeRule());
        digester.addRule("storedsearch/searchspec/searchcriteria/searchclauses/searchclause/select/selectpropall", (Rule)new SelectAllPropertiesRule());
        digester.addRule("storedsearch/searchspec/searchcriteria/searchclauses/searchclause/select/selectprops/selectprop", (Rule)new SelectPropertyRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.commonplaceholder), (Rule)new WhereCommonPlaceholderRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.and), (Rule)new ContainerRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.or), (Rule)new ContainerRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.eq), (Rule)new WhereClauseConditionRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.neq), (Rule)new WhereClauseConditionRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.gt), (Rule)new WhereClauseConditionRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.gte), (Rule)new WhereClauseConditionRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.lt), (Rule)new WhereClauseConditionRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.lte), (Rule)new WhereClauseConditionRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.in), (Rule)new WhereClauseConditionRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.like), (Rule)new WhereClauseConditionRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.notlike), (Rule)new WhereClauseConditionRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.isnull), (Rule)new WhereClauseConditionRule());
        digester.addRule("*/" + (Object)((Object)P8SearchDefinition.Operator.isnotnull), (Rule)new WhereClauseConditionRule());
        digester.addRule("*/whereprop", (Rule)new WherePropertyRule());
        digester.addRule("*/whereprop/propdesc", (Rule)new WherePropertyRule());
        digester.addRule("*/literal", (Rule)new WherePropertyRule());
        digester.addRule("storedsearch/searchspec/searchcriteria/searchclauses/searchclause/content", (Rule)new ContentClauseRule());
        digester.addRule("*/item", (Rule)new ContentClauseItemRule());
        digester.addRule("*/field", (Rule)new FieldRule());
        digester.addRule("*/term", (Rule)new ContentItemTermRule());
        digester.addRule("storedsearch/searchspec/searchcriteria/searchclauses/searchclause/veritycontent", (Rule)new ContentClauseRule());
        digester.addRule("*/verityand", (Rule)new ContainerRule());
        digester.addRule("*/verityor", (Rule)new ContainerRule());
        digester.addRule("*/verityitem", (Rule)new ContentClauseItemRule());
        digester.addRule("*/verityitem/usertext", (Rule)new ContentClauseItemTextRule());
        digester.addRule("*/verityitem/verityitemdata/veritynear", (Rule)new ContentClauseItemTextRule());
        digester.addRule("*/verityitem/verityitemdata/verityin/verityzones/verityzone/verityzonename", (Rule)new ContentClauseItemTextRule());
        digester.addRule("*/verityitem/verityitemdata/verityvql", (Rule)new ContentClauseItemTextRule());
        digester.addRule("storedsearch/searchspec/searchcriteria/searchclauses/searchclause/subclasses/subclass", (Rule)new SubclassRule());
    }

    private static class SubclassRule
    extends Rule {
        private SubclassRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            P8SearchDefinition.SearchClause searchClause = (P8SearchDefinition.SearchClause)this.getDigester().peek();
            P8SearchDefinition.Subclass subclass = new P8SearchDefinition.Subclass(attributes.getValue("symname"), attributes.getValue("name"), attributes.getValue("objecttype"), attributes.getValue("editproperty"), attributes.getValue("itemid"), attributes.getValue("includesubclasses"));
            searchClause.addSubclass(subclass);
        }
    }

    private static class ContentClauseItemTextRule
    extends Rule {
        private ContentClauseItemTextRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            P8SearchDefinition.ContentClauseItem item = (P8SearchDefinition.ContentClauseItem)this.getDigester().peek();
            if (name.equals("veritynear")) {
                String distance = attributes.getValue("distance");
                item.setSearchModifierRange(distance == null ? 0 : Integer.valueOf(distance));
            }
        }

        public void body(String namespace, String name, String text) {
            if (name.equals("usertext")) {
                P8SearchDefinition.ContentClauseItem item = (P8SearchDefinition.ContentClauseItem)this.getDigester().peek();
                item.setUserText(text);
            } else if (name.equals("verityzonename")) {
                P8SearchDefinition.VerityClauseInItem item = (P8SearchDefinition.VerityClauseInItem)this.getDigester().peek();
                item.setZone(text);
            } else if (name.equals("verityvql")) {
                P8SearchDefinition.VerityClauseVQLItem item = (P8SearchDefinition.VerityClauseVQLItem)this.getDigester().peek();
                item.setVql(text);
            }
        }
    }

    private static class ContentItemTermRule
    extends Rule {
        private ContentItemTermRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            Digester digester = this.getDigester();
            P8SearchDefinition.ContentClauseItem item = (P8SearchDefinition.ContentClauseItem)digester.peek();
            P8SearchDefinition.ContentTerm term = new P8SearchDefinition.ContentTerm();
            term.setCaseSensitive(Boolean.valueOf(attributes.getValue("case")));
            term.setPhrase(Boolean.valueOf(attributes.getValue("phrase")));
            digester.addBeanPropertySetter("*/term", "value");
            item.addContentTerm(term);
            digester.push((Object)term);
        }

        public void body(String namespace, String name, String text) {
            P8SearchDefinition.ContentTerm term = (P8SearchDefinition.ContentTerm)this.getDigester().peek();
            term.setValue(text);
        }

        public void end(String namespace, String name) {
            this.getDigester().pop();
        }
    }

    private static class ContentClauseItemRule
    extends Rule {
        private ContentClauseItemRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            Digester digester = this.getDigester();
            Object parent = digester.peek();
            P8SearchDefinition.ContentClauseItem item = P8TextSearchUtil.newContentClauseItem(attributes.getValue("groupaction"));
            if (parent instanceof P8SearchDefinition.ContentClauseItem) {
                item.setPropertySymbolicName(((P8SearchDefinition.ContentClauseItem)parent).getPropertySymbolicName());
                digester.pop();
                parent = digester.peek();
            }
            digester.push((Object)item);
            if (parent instanceof P8SearchDefinition.ContentCriteria) {
                item.setSearchClause(((P8SearchDefinition.ContentCriteria)parent).getSearchClause());
                ((P8SearchDefinition.ContentCriteria)parent).setContentClause(item);
            } else {
                item.setSearchClause(((P8SearchDefinition.Container)parent).getSearchClause());
                ((P8SearchDefinition.Container)parent).addClause(item);
            }
            item.setGroupAction(attributes.getValue("groupaction"));
            item.setSearchModifier(attributes.getValue("searchmodifier"));
            String modifierRange = attributes.getValue("searchmodifierrange");
            item.setSearchModifierRange(modifierRange == null ? 0 : Integer.valueOf(modifierRange));
            item.setRequiredState(attributes.getValue("requiredstate"));
            item.setItemId(attributes.getValue("itemid"));
            item.setEditProperty(attributes.getValue("editproperty"));
        }

        public void end(String namespace, String name) {
            P8SearchDefinition.ContentClauseItem item = (P8SearchDefinition.ContentClauseItem)this.getDigester().pop();
            P8SearchDefinition.SearchClause searchClause = item.getSearchClause();
            if (searchClause.getContentCriteria().isCascade()) {
                StringBuilder text = new StringBuilder();
                List<P8SearchDefinition.ContentTerm> contentTerms = item.getContentTerms();
                for (P8SearchDefinition.ContentTerm term : contentTerms) {
                    String value = term.getValue();
                    if (value == null || value.length() < 1) continue;
                    if (text.length() > 0) {
                        text.append(" ");
                    }
                    if (item.isRequiredStateProhibited()) {
                        text.append("-");
                    }
                    if (term.isPhrase()) {
                        text.append("\"").append(value).append("\"");
                        continue;
                    }
                    text.append(value);
                }
                item.setUserText(text.toString());
            } else {
                try {
                    String userText = item.getUserText();
                    P8SearchDefinition.GroupAction groupAction = item.getGroupAction();
                    if (groupAction == P8SearchDefinition.GroupAction.none && userText != null && userText.length() > 1 && userText.startsWith("!")) {
                        userText = "-" + userText.substring(1);
                    }
                    SearchTemplate.TextSearchCriterion criterion = new SearchTemplate.TextSearchCriterion(userText, groupAction == P8SearchDefinition.GroupAction.none ? "" : groupAction.toString(), item.getSearchModifierRange());
                    P8TextSearchUtil.convertTextSearchCriterion(criterion, item, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class FieldRule
    extends Rule {
        private FieldRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            Digester digester = this.getDigester();
            P8SearchDefinition.ContentClauseItem item = new P8SearchDefinition.ContentClauseItem();
            digester.push((Object)item);
            item.setPropertySymbolicName(attributes.getValue("name"));
        }
    }

    private static class ContentClauseRule
    extends Rule {
        private ContentClauseRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            P8SearchDefinition.ContentCriteria contentClause = new P8SearchDefinition.ContentCriteria();
            Digester digester = this.getDigester();
            P8SearchDefinition.SearchClause searchClause = (P8SearchDefinition.SearchClause)digester.peek();
            contentClause.setSearchClause(searchClause);
            searchClause.setContentCriteria(contentClause);
            contentClause.setDialect(attributes.getValue("dialect"));
            contentClause.setShowContentSummary(attributes.getValue("contentsummary"));
            contentClause.setShowRank(attributes.getValue("rank"));
            contentClause.setJoin(attributes.getValue("jointype"));
            contentClause.setTextSearchType(name == "content" ? SearchTemplate.TextSearchType.cascade : SearchTemplate.TextSearchType.verity);
            digester.push((Object)contentClause);
        }

        public void end(String namespace, String name) {
            this.getDigester().pop();
        }
    }

    private static class WherePropertyRule
    extends Rule {
        private WherePropertyRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            P8SearchDefinition.WhereClauseCondition condition = (P8SearchDefinition.WhereClauseCondition)this.getDigester().peek();
            if (name.equals("whereprop")) {
                condition.setPropName(attributes.getValue("name"));
                condition.setPropSymbolicName(attributes.getValue("symname"));
                condition.setPropObjectType(attributes.getValue("objecttype"));
                condition.setItemId(attributes.getValue("itemid"));
                condition.setEditProperty(attributes.getValue("editproperty"));
                condition.setSmartOperator(attributes.getValue("smartoperator"));
            } else if (name.equals("propdesc")) {
                condition.setPropDataType(attributes.getValue("datatype"));
                condition.setPropHasChoices(Boolean.valueOf(attributes.getValue("haschoices")));
                condition.setPropChoiceId(attributes.getValue("choiceId"));
                condition.setPropHasMarkings(Boolean.valueOf(attributes.getValue("hasmarkings")));
            }
        }

        public void body(String namespace, String name, String text) {
            if (name.equals("literal")) {
                P8SearchDefinition.WhereClauseCondition condition = (P8SearchDefinition.WhereClauseCondition)this.getDigester().peek();
                condition.setLiteral(text);
            }
        }
    }

    private static class WhereCommonPlaceholderRule
    extends Rule {
        private WhereCommonPlaceholderRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            Digester digester = this.getDigester();
            Object parent = digester.peek();
            digester.push((Object)P8SearchDefinition.COMMON_CLAUSE);
            if (parent instanceof P8SearchDefinition.SearchClause) {
                ((P8SearchDefinition.SearchClause)parent).setWhereClause(P8SearchDefinition.COMMON_CLAUSE);
            } else {
                ((P8SearchDefinition.Container)parent).addClause(P8SearchDefinition.COMMON_CLAUSE);
            }
        }

        public void end(String namespace, String name) {
            this.getDigester().pop();
        }
    }

    private static class WhereClauseConditionRule
    extends Rule {
        private WhereClauseConditionRule() {
        }

        public void begin(String namespace, String operator, Attributes attributes) {
            Digester digester = this.getDigester();
            Object parent = digester.peek();
            P8SearchDefinition.WhereClauseCondition condition = new P8SearchDefinition.WhereClauseCondition();
            condition.setOperator(operator);
            digester.push((Object)condition);
            if (parent instanceof P8SearchDefinition.SearchClause) {
                condition.setSearchClause((P8SearchDefinition.SearchClause)parent);
                ((P8SearchDefinition.SearchClause)parent).setWhereClause(condition);
            } else {
                condition.setSearchClause(((P8SearchDefinition.Container)parent).getSearchClause());
                ((P8SearchDefinition.Container)parent).addClause(condition);
            }
        }

        public void end(String namespace, String name) {
            P8SearchDefinition.WhereClauseCondition condition = (P8SearchDefinition.WhereClauseCondition)this.getDigester().pop();
            P8SearchDefinition.Operator operator = condition.getOperator();
            String literal = condition.getLiteral();
            if (literal != null && literal.length() > 0) {
                if (operator == P8SearchDefinition.Operator.like || operator == P8SearchDefinition.Operator.notlike) {
                    if (operator == P8SearchDefinition.Operator.like) {
                        if (literal.charAt(0) != '%' && literal.charAt(literal.length() - 1) == '%') {
                            operator = P8SearchDefinition.Operator.startswith;
                        } else if (literal.charAt(0) == '%' && literal.charAt(literal.length() - 1) != '%') {
                            operator = P8SearchDefinition.Operator.endswith;
                        }
                    }
                    if (literal.charAt(0) == '%') {
                        literal = literal.substring(1);
                    }
                    if (literal.length() > 0 && literal.charAt(literal.length() - 1) == '%') {
                        literal = literal.substring(0, literal.length() - 1);
                    }
                    if (literal.equals("{}")) {
                        literal = "";
                    }
                    condition.setOperator(operator.toString());
                    condition.setLiteral(literal);
                } else if (condition.getPropDataType().equals((Object)P8SearchDefinition.DataType.typedate)) {
                    Calendar cal = WCDateFormat.parseW3CDate(literal, null);
                    literal = WCDateFormat.getDateString(null, cal.getTimeInMillis(), WCDateFormat.UTC_DATE_FORMAT);
                    condition.setLiteral(literal);
                }
            }
        }
    }

    private static class ContainerRule
    extends Rule {
        private ContainerRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            Digester digester = this.getDigester();
            Object parent = digester.peek();
            P8SearchDefinition.Container container = new P8SearchDefinition.Container();
            container.setJoin(name.startsWith("verity") ? P8SearchDefinition.Operator.valueOf(name.substring(6)) : P8SearchDefinition.Operator.valueOf(name));
            if (parent instanceof P8SearchDefinition.SearchClause) {
                container.setSearchClause((P8SearchDefinition.SearchClause)parent);
                ((P8SearchDefinition.SearchClause)parent).setWhereClause(container);
            } else if (parent instanceof P8SearchDefinition.ContentCriteria) {
                container.setSearchClause(((P8SearchDefinition.ContentCriteria)parent).getSearchClause());
                ((P8SearchDefinition.ContentCriteria)parent).setContentClause(container);
            } else {
                container.setSearchClause(((P8SearchDefinition.Container)parent).getSearchClause());
                ((P8SearchDefinition.Container)parent).addClause(container);
            }
            digester.push((Object)container);
        }

        public void end(String namespace, String name) {
            P8SearchDefinition.Container container = (P8SearchDefinition.Container)this.getDigester().pop();
            P8SearchDefinition.Container parentContainer = container.getContainer();
            boolean newGroup = parentContainer == null || container.getJoin() != parentContainer.getJoin();
            container.setInclude(newGroup && P8SearchUtil.isWhereClauseContainerIncludeCondition(container, null, null, null));
            container.setRange(P8SearchUtil.isWhereClauseContainerRangeCondition(container));
        }
    }

    private static class SelectAllPropertiesRule
    extends Rule {
        private SelectAllPropertiesRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            P8SearchDefinition.SearchClause searchClause = (P8SearchDefinition.SearchClause)this.getDigester().peek();
            searchClause.addSelectProperty(P8SearchDefinition.SELECT_PROPERTY_ALL);
        }
    }

    private static class SelectPropertyRule
    extends Rule {
        private SelectPropertyRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            P8SearchDefinition.SearchClause searchClause = (P8SearchDefinition.SearchClause)this.getDigester().peek();
            String sortLevelAttr = attributes.getValue("sortlevel");
            int sortLevel = sortLevelAttr == null ? 0 : Integer.valueOf(sortLevelAttr);
            P8SearchDefinition.SelectProperty selectProp = new P8SearchDefinition.SelectProperty(attributes.getValue("symname"), attributes.getValue("name"), attributes.getValue("objecttype"), sortLevel, attributes.getValue("sortorder"), attributes.getValue("alignment"));
            selectProp.setItemId(attributes.getValue("itemid"));
            searchClause.addSelectProperty(selectProp);
        }
    }

    private static class SearchClauseObjectTypeRule
    extends Rule {
        private SearchClauseObjectTypeRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            P8SearchDefinition.SearchClause searchClause = (P8SearchDefinition.SearchClause)this.getDigester().peek();
            searchClause.setFrom(attributes.getValue("symname"));
        }
    }

    private static class SearchClauseRule
    extends Rule {
        private SearchClauseRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            Digester digester = this.getDigester();
            P8SearchDefinition searchDefinition = (P8SearchDefinition)digester.peek();
            P8SearchDefinition.SearchClause searchClause = new P8SearchDefinition.SearchClause();
            searchDefinition.addSearchClause(searchClause);
            digester.push((Object)searchClause);
        }

        public void end(String namespace, String name) {
            this.getDigester().pop();
        }
    }

    private static class FolderObjectStoreRule
    extends Rule {
        private FolderObjectStoreRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            P8SearchDefinition.SearchInFolder folder = (P8SearchDefinition.SearchInFolder)this.getDigester().peek();
            folder.setObjectStoreId(attributes.getValue("id"));
        }
    }

    private static class FolderRule
    extends Rule {
        private FolderRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            Digester digester = this.getDigester();
            P8SearchDefinition searchDefinition = (P8SearchDefinition)digester.peek();
            String id = attributes.getValue("id");
            String pathname = attributes.getValue("pathname");
            boolean searchSubfolders = Boolean.valueOf(attributes.getValue("searchsubfolders"));
            String view = attributes.getValue("view");
            P8SearchDefinition.SearchInFolder folder = new P8SearchDefinition.SearchInFolder(id, pathname, searchSubfolders, view, null);
            String itemId = attributes.getValue("itemid");
            folder.setItemId(itemId);
            searchDefinition.addFolder(folder);
            digester.push((Object)folder);
        }

        public void end(String namespace, String name) {
            this.getDigester().pop();
        }
    }

    private static class ObjectStoreRule
    extends Rule {
        private ObjectStoreRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            P8SearchDefinition searchDefinition = (P8SearchDefinition)this.getDigester().peek();
            P8SearchDefinition.SearchInObjectStore objectStore = new P8SearchDefinition.SearchInObjectStore(attributes.getValue("id"), attributes.getValue("name"));
            searchDefinition.addObjectStore(objectStore);
        }
    }

    private static class InfoAndOptionsRule
    extends Rule {
        private InfoAndOptionsRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            P8SearchDefinition searchDefinition = (P8SearchDefinition)this.getDigester().peek();
            if (name.equals("version")) {
                searchDefinition.setDtdVersion(attributes.getValue("dtd"));
                searchDefinition.setSearchVersion(attributes.getValue("searchobject"));
            } else if (name.equals("product")) {
                searchDefinition.setProductName(attributes.getValue("name"));
                searchDefinition.setProductVersion(attributes.getValue("version"));
            } else if (name.equals("searchspec")) {
                searchDefinition.setVersionSelection(attributes.getValue("versionselection"));
            } else if (name.equals("template")) {
                searchDefinition.setTemplate(true);
                searchDefinition.setShowAndOrConditions(attributes.getValue("showandorconditions"));
                searchDefinition.setShowMaxRecords(attributes.getValue("showmaxrecords"));
                searchDefinition.setShowOperators(attributes.getValue("showoperators"));
            } else if (name.equals("objectstores")) {
                searchDefinition.setMergeOption(attributes.getValue("mergeoption"));
            } else if (name.equals("options")) {
                searchDefinition.setMaxRecords(attributes.getValue("maxrecords"));
            }
        }
    }

    private static class SearchDefinitionRule
    extends Rule {
        private SearchDefinitionRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            Digester digester = this.getDigester();
            P8SearchDefinition searchDefinition = new P8SearchDefinition();
            digester.push((Object)searchDefinition);
        }

        public void end(String namespace, String name) {
            this.getDigester().pop();
        }
    }
}

