/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.ibm.ecm.util.SearchTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8SearchDefinition {
    public static final SelectProperty SELECT_PROPERTY_ALL = new SelectProperty("*", null, (String)null, 0, (String)null, null);
    public static final Clause COMMON_CLAUSE = new Clause(){

        public boolean isContainer() {
            return false;
        }
    };
    private static final String NEW_LINE = System.getProperty("line.separator") + "    ";
    private String dtdVersion;
    private String searchVersion;
    private String productName;
    private String productVersion;
    private boolean template;
    private SearchTemplate.VersionOption versionSelection;
    private boolean showAndOrConditions;
    private boolean showMaxRecords;
    private boolean showOperators;
    private MergeScope mergeOption;
    private int maxRecords;
    private SearchTemplate.TextSearchType textSearchType;
    private boolean autoResolved;
    private int databaseType;
    private boolean apiIncompatible;
    private List<SearchInObjectStore> objectStores = new ArrayList<SearchInObjectStore>();
    private List<SearchInFolder> folders = new ArrayList<SearchInFolder>();
    private List<SearchClause> searchClauses = new ArrayList<SearchClause>();

    String getDtdVersion() {
        return this.dtdVersion;
    }

    void setDtdVersion(String dtdVersion) {
        this.dtdVersion = dtdVersion;
    }

    public List<SearchInFolder> getFolders() {
        return this.folders;
    }

    void setFolders(List<SearchInFolder> folders) {
        this.folders = folders;
    }

    void addFolder(SearchInFolder folder) {
        this.folders.add(folder);
    }

    int getMaxRecords() {
        return this.maxRecords;
    }

    void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    void setMaxRecords(String maxRecords) {
        this.maxRecords = Integer.parseInt(maxRecords);
    }

    public MergeScope getMergeOption() {
        return this.mergeOption;
    }

    public boolean isMergeOptionUnion() {
        return this.mergeOption != null && this.mergeOption == MergeScope.union;
    }

    void setMergeOption(String mergeOption) {
        this.mergeOption = mergeOption == null ? null : MergeScope.valueOf(mergeOption);
    }

    public SearchTemplate.TextSearchType getTextSearchType() {
        return this.textSearchType;
    }

    void setTextSearchType(SearchTemplate.TextSearchType textSearchType) {
        this.textSearchType = textSearchType;
    }

    public boolean isCascade() {
        return this.textSearchType == null || this.textSearchType == SearchTemplate.TextSearchType.cascade;
    }

    List<SearchInObjectStore> getObjectStores() {
        return this.objectStores;
    }

    List<String> getObjectStoreNames() {
        ArrayList<String> osNames = new ArrayList<String>();
        for (SearchInObjectStore sos : this.objectStores) {
            osNames.add(sos.getName());
        }
        return osNames;
    }

    void setObjectStores(List<SearchInObjectStore> objectStores) {
        this.objectStores = objectStores;
    }

    void addObjectStore(SearchInObjectStore objectStore) {
        this.objectStores.add(objectStore);
    }

    String getProductName() {
        return this.productName;
    }

    void setProductName(String productName) {
        this.productName = productName;
    }

    public boolean isIcnGenerated() {
        return this.productName == null || this.productName.equals("Navigator");
    }

    String getProductVersion() {
        return this.productVersion;
    }

    void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public List<SearchClause> getSearchClauses() {
        return this.searchClauses;
    }

    void addSearchClause(SearchClause searchClause) {
        searchClause.setSearchDefinition(this);
        this.searchClauses.add(searchClause);
    }

    public SearchClause getSearchClause(SearchTemplate.ObjectType objectType) {
        SearchClause searchClause = null;
        for (SearchClause sc : this.searchClauses) {
            if (!sc.getFrom().equals((Object)objectType)) continue;
            searchClause = sc;
            break;
        }
        return searchClause;
    }

    String getSearchVersion() {
        return this.searchVersion;
    }

    void setSearchVersion(String searchVersion) {
        this.searchVersion = searchVersion;
    }

    public boolean isTemplate() {
        return this.template;
    }

    void setTemplate(boolean template) {
        this.template = template;
    }

    boolean isShowAndOrConditions() {
        return this.showAndOrConditions;
    }

    void setShowAndOrConditions(boolean showAndOrConditions) {
        this.showAndOrConditions = showAndOrConditions;
    }

    void setShowAndOrConditions(String showAndOrConditions) {
        this.showAndOrConditions = Boolean.valueOf(showAndOrConditions);
    }

    boolean isShowMaxRecords() {
        return this.showMaxRecords;
    }

    void setShowMaxRecords(boolean showMaxRecords) {
        this.showMaxRecords = showMaxRecords;
    }

    void setShowMaxRecords(String showMaxRecords) {
        this.showMaxRecords = Boolean.valueOf(showMaxRecords);
    }

    boolean isShowOperators() {
        return this.showOperators;
    }

    void setShowOperators(boolean showOperators) {
        this.showOperators = showOperators;
    }

    void setShowOperators(String showOperators) {
        this.showOperators = Boolean.valueOf(showOperators);
    }

    public SearchTemplate.VersionOption getVersionSelection() {
        return this.versionSelection;
    }

    void setVersionSelection(String versionSelection) {
        this.versionSelection = versionSelection == null ? null : SearchTemplate.VersionOption.valueOf(versionSelection);
    }

    boolean isVersionSelectionAll() {
        return this.versionSelection != null && this.versionSelection.equals((Object)SearchTemplate.VersionOption.allversions);
    }

    boolean isVersionSelectionReleased() {
        return this.versionSelection != null && this.versionSelection.equals((Object)SearchTemplate.VersionOption.releasedversion);
    }

    boolean isVersionSelectionCurrent() {
        return this.versionSelection != null && this.versionSelection.equals((Object)SearchTemplate.VersionOption.currentversion);
    }

    public boolean isAutoResolved() {
        return this.autoResolved;
    }

    public void setAutoResolved(boolean autoResolved) {
        this.autoResolved = autoResolved;
    }

    public int getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(int databaseType) {
        this.databaseType = databaseType;
    }

    public boolean isApiIncompatible() {
        return this.apiIncompatible;
    }

    void setApiIncompatible(boolean apiIncompatible) {
        this.apiIncompatible = apiIncompatible;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("(dtdVersion = ").append(this.dtdVersion);
        str.append(", searchVersion = ").append(this.searchVersion);
        str.append(", productName = ").append(this.productName);
        str.append(", productVersion = ").append(this.productVersion);
        str.append(", template = ").append(this.template);
        str.append(", versionSelection = ").append((Object)this.versionSelection);
        str.append(", showAndOrConditions = ").append(this.showAndOrConditions);
        str.append(", showMaxRecords = ").append(this.showMaxRecords);
        str.append(", showOperators = ").append(this.showOperators);
        str.append(", mergeOption = ").append((Object)this.mergeOption);
        str.append(", maxRecords = ").append(this.maxRecords);
        str.append(", textSearchType = ").append((Object)this.textSearchType);
        str.append(", autoResolved = ").append(this.autoResolved);
        str.append(", databaseType = ").append(this.databaseType);
        str.append(", apiIncompatible = ").append(this.apiIncompatible);
        str.append(", ").append(NEW_LINE).append("OBJECTSTORES = ").append(this.objectStores);
        str.append(", ").append(NEW_LINE).append("FOLDERS = ").append(this.folders);
        str.append(", ").append(NEW_LINE).append("SEARCHCLAUSES = ").append(this.searchClauses).append(")");
        return str.toString();
    }

    public static class Subclass {
        private String symbolicName;
        private String displayName;
        private SearchTemplate.ObjectType objectType;
        private SearchTemplate.SearchEditProperty editProperty;
        private String itemId;
        private boolean unselected;
        private boolean searchSubclasses;

        Subclass() {
        }

        Subclass(String symbolicName, String displayName, String objectType, String editProperty, String itemId, String searchSubclasses) {
            this.symbolicName = symbolicName;
            this.displayName = displayName;
            this.objectType = objectType == null ? null : SearchTemplate.ObjectType.valueOf(objectType);
            this.editProperty = editProperty == null ? null : SearchTemplate.SearchEditProperty.valueOf(editProperty);
            this.itemId = itemId;
            this.searchSubclasses = searchSubclasses == null ? false : Boolean.valueOf(searchSubclasses);
        }

        Subclass(String symbolicName, String displayName, SearchTemplate.ObjectType objectType, SearchTemplate.SearchEditProperty editProperty, String itemId, boolean searchSubclasses) {
            this.symbolicName = symbolicName;
            this.displayName = displayName;
            this.objectType = objectType;
            this.editProperty = editProperty;
            this.itemId = itemId;
            this.searchSubclasses = searchSubclasses;
        }

        String getItemId() {
            return this.itemId;
        }

        void setItemId(String itemId) {
            this.itemId = itemId;
        }

        String getDisplayName() {
            return this.displayName;
        }

        void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        SearchTemplate.ObjectType getObjectType() {
            return this.objectType;
        }

        void setObjectType(String objectType) {
            this.objectType = objectType == null ? null : SearchTemplate.ObjectType.valueOf(objectType);
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        void setSymbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
        }

        SearchTemplate.SearchEditProperty getEditProperty() {
            return this.editProperty == null ? SearchTemplate.SearchEditProperty.editable : this.editProperty;
        }

        void setEditProperty(String editProperty) {
            this.editProperty = editProperty == null ? null : SearchTemplate.SearchEditProperty.valueOf(editProperty);
        }

        boolean isHidden() {
            return this.editProperty != null && this.editProperty.equals((Object)SearchTemplate.SearchEditProperty.hidden);
        }

        boolean isReadOnly() {
            return this.editProperty != null && this.editProperty.equals((Object)SearchTemplate.SearchEditProperty.readonly);
        }

        public boolean isUnselected() {
            return this.unselected;
        }

        void setUnselected(boolean unselected) {
            this.unselected = unselected;
        }

        boolean isSearchSubclasses() {
            return this.searchSubclasses;
        }

        void setSearchSubclasses(boolean searchSubclasses) {
            this.searchSubclasses = searchSubclasses;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(symbolicName = ").append(this.symbolicName);
            str.append(", displayName = ").append(this.displayName);
            str.append(", objectType = ").append((Object)this.objectType);
            str.append(", editProperty = ").append((Object)this.editProperty);
            str.append(", itemId = ").append(this.itemId);
            str.append(", unselected = ").append(this.unselected);
            str.append(", searchSubclasses = ").append(this.searchSubclasses).append(")");
            return str.toString();
        }
    }

    public static class VerityClauseVQLItem
    extends ContentClauseItem {
        private String vql;

        VerityClauseVQLItem() {
        }

        VerityClauseVQLItem(String vql) {
            this.vql = vql;
        }

        public String getVql() {
            return this.vql;
        }

        void setVql(String vql) {
            this.vql = vql;
        }

        public GroupAction getGroupAction() {
            return GroupAction.vql;
        }

        public String toString() {
            return "(vql = " + this.vql + ")";
        }
    }

    public static class VerityClauseInItem
    extends ContentClauseItem {
        private String zone;

        VerityClauseInItem() {
        }

        VerityClauseInItem(String zone) {
            this.zone = zone;
        }

        public String getZone() {
            return this.zone;
        }

        void setZone(String zone) {
            this.zone = zone;
        }

        public GroupAction getGroupAction() {
            return GroupAction.in;
        }

        public String toString() {
            return "(zone = " + this.zone + ")";
        }
    }

    public static class ContentTerm {
        private String value;
        private VeritySearchOperator wordVariation;
        private boolean caseSensitive;
        private RequiredState requiredState;
        private boolean phrase;

        ContentTerm() {
            this.value = "";
        }

        ContentTerm(String value, String wordVariation, boolean caseSensitive, RequiredState requiredState, boolean phrase) {
            this.setValue(value);
            this.setWordVariation(wordVariation);
            this.setCaseSensitive(caseSensitive);
            this.setRequiredState(requiredState);
            this.setPhrase(phrase);
        }

        public String getValue() {
            return this.value == null ? "" : this.value;
        }

        void setValue(String value) {
            this.value = value == null ? "" : value;
        }

        public VeritySearchOperator getWordVariation() {
            return this.wordVariation;
        }

        void setWordVariation(String wordVariation) {
            this.wordVariation = wordVariation == null ? null : VeritySearchOperator.valueOf(wordVariation);
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public RequiredState getRequiredState() {
            return this.requiredState == null ? RequiredState.none : this.requiredState;
        }

        void setRequiredState(RequiredState requiredState) {
            this.requiredState = requiredState == null ? RequiredState.none : requiredState;
        }

        public boolean isRequired() {
            return this.requiredState != null && this.requiredState == RequiredState.required;
        }

        public boolean isProhibited() {
            return this.requiredState != null && this.requiredState == RequiredState.prohibited;
        }

        public boolean isPhrase() {
            return this.phrase;
        }

        void setPhrase(boolean phrase) {
            this.phrase = phrase;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(value = ").append(this.value);
            str.append(", wordVariation = ").append((Object)this.wordVariation);
            str.append(", caseSensitive = ").append(this.caseSensitive);
            str.append(", requiredState = ").append((Object)this.requiredState);
            str.append(", phrase = ").append(this.phrase).append(")");
            return str.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContentClauseItem
    extends ClauseItem {
        private GroupAction groupAction;
        private SearchModifier searchModifier;
        private int searchModifierRange;
        private RequiredState requiredState;
        private String userText;
        private List<ContentTerm> contentTerms = new ArrayList<ContentTerm>();
        private String propertySymbolicName;

        ContentClauseItem() {
            this.userText = "";
        }

        ContentClauseItem(String groupAction, String userText, String editProperty) {
            super(editProperty);
            this.groupAction = groupAction == null || groupAction.length() < 1 ? GroupAction.none : GroupAction.valueOf(groupAction);
            this.userText = userText == null ? "" : userText;
        }

        @Override
        public boolean isContainer() {
            return false;
        }

        public GroupAction getGroupAction() {
            return this.groupAction == null ? GroupAction.none : this.groupAction;
        }

        void setGroupAction(String groupAction) {
            this.groupAction = groupAction == null || groupAction.length() < 1 ? GroupAction.none : GroupAction.valueOf(groupAction);
        }

        void setGroupAction(GroupAction groupAction) {
            this.groupAction = groupAction == null ? GroupAction.none : groupAction;
        }

        boolean isGroupActionAll() {
            return this.groupAction != null && this.groupAction == GroupAction.all;
        }

        boolean isGroupActionAny() {
            return this.groupAction != null && this.groupAction == GroupAction.any;
        }

        boolean isGroupActionVql() {
            return this.groupAction != null && this.groupAction == GroupAction.vql;
        }

        boolean isGroupActionNear() {
            return this.groupAction != null && this.groupAction == GroupAction.near;
        }

        SearchModifier getSearchModifier() {
            return this.searchModifier;
        }

        void setSearchModifier(String searchModifier) {
            this.searchModifier = searchModifier == null ? null : SearchModifier.valueOf(searchModifier);
        }

        void setSearchModifier(SearchModifier searchModifier) {
            this.searchModifier = searchModifier;
        }

        boolean isSearchModifierProximity() {
            return this.searchModifier != null && this.searchModifier.equals((Object)SearchModifier.proximity);
        }

        int getSearchModifierRange() {
            return this.searchModifierRange;
        }

        void setSearchModifierRange(int searchModifierRange) {
            this.searchModifierRange = searchModifierRange;
        }

        RequiredState getRequiredState() {
            return this.requiredState == null ? RequiredState.none : this.requiredState;
        }

        void setRequiredState(String requiredState) {
            this.requiredState = requiredState == null || requiredState.length() < 1 ? RequiredState.none : RequiredState.valueOf(requiredState);
        }

        void setRequiredState(RequiredState requiredState) {
            this.requiredState = requiredState == null ? RequiredState.none : requiredState;
        }

        boolean isRequiredStateProhibited() {
            return this.requiredState != null && this.requiredState.equals((Object)RequiredState.prohibited);
        }

        public List<ContentTerm> getContentTerms() {
            return this.contentTerms;
        }

        void setContentTerms(List<ContentTerm> contentTerms) {
            this.contentTerms = contentTerms;
        }

        void addContentTerm(ContentTerm contentTerm) {
            this.contentTerms.add(contentTerm);
        }

        String getUserText() {
            return this.userText == null ? "" : this.userText;
        }

        void setUserText(String userText) {
            this.userText = userText == null ? "" : userText;
        }

        String getPropertySymbolicName() {
            return this.propertySymbolicName;
        }

        void setPropertySymbolicName(String propertySymbolicName) {
            this.propertySymbolicName = propertySymbolicName;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(groupAction = ").append((Object)this.groupAction);
            str.append(", searchModifier = ").append((Object)this.searchModifier);
            str.append(", searchModifierRange = ").append(this.searchModifierRange);
            str.append(", requiredState = ").append((Object)this.requiredState);
            str.append(", userText = ").append(this.userText);
            str.append(", contentTerms = ").append(this.contentTerms);
            str.append(", itemId = ").append(this.getItemId());
            str.append(", editProperty = ").append((Object)this.getEditProperty());
            str.append(", propertySymbolicName = ").append(this.propertySymbolicName).append(")");
            return str.toString();
        }
    }

    public static class ContentCriteria {
        private String dialect;
        private JoinType join;
        private boolean showContentSummary;
        private boolean showRank;
        private Clause contentClause;
        private SearchClause searchClause;
        private SearchTemplate.TextSearchType textSearchType;

        ContentCriteria() {
        }

        ContentCriteria(String dialect, String join, boolean showContentSummary, boolean showRank, SearchTemplate.TextSearchType textSearchType) {
            this.dialect = dialect;
            this.join = join == null ? null : JoinType.valueOf(join);
            this.showContentSummary = showContentSummary;
            this.showRank = showRank;
            this.textSearchType = textSearchType;
        }

        String getDialect() {
            return this.dialect;
        }

        void setDialect(String dialect) {
            this.dialect = dialect;
        }

        public JoinType getJoin() {
            return this.join;
        }

        void setJoin(String join) {
            this.join = join == null ? null : JoinType.valueOf(join);
        }

        void setJoin(JoinType join) {
            this.join = join;
        }

        public boolean isShowContentSummary() {
            return this.showContentSummary;
        }

        void setShowContentSummary(boolean showContentSummary) {
            this.showContentSummary = showContentSummary;
        }

        void setShowContentSummary(String showContentSummary) {
            this.showContentSummary = Boolean.valueOf(showContentSummary);
        }

        public boolean isShowRank() {
            return this.showRank;
        }

        void setShowRank(boolean showRank) {
            this.showRank = showRank;
        }

        void setShowRank(String showRank) {
            this.showRank = Boolean.valueOf(showRank);
        }

        public Clause getContentClause() {
            return this.contentClause;
        }

        void setContentClause(Clause contentClause) {
            this.contentClause = contentClause;
        }

        SearchClause getSearchClause() {
            return this.searchClause;
        }

        void setSearchClause(SearchClause searchClause) {
            this.searchClause = searchClause;
        }

        public boolean isCascade() {
            return this.textSearchType == null || this.textSearchType == SearchTemplate.TextSearchType.cascade;
        }

        public SearchTemplate.TextSearchType getTextSearchType() {
            return this.textSearchType == null ? SearchTemplate.TextSearchType.cascade : this.textSearchType;
        }

        void setTextSearchType(SearchTemplate.TextSearchType textSearchType) {
            this.textSearchType = textSearchType;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(dialect = ").append(this.dialect);
            str.append(", join = ").append((Object)this.join);
            str.append(", showContentSummary = ").append(this.showContentSummary);
            str.append(", showRank = ").append(this.showRank);
            str.append(", contentClause = ").append(this.contentClause);
            str.append(", textSearchType = ").append(this.textSearchType == null ? "" : this.textSearchType.toString()).append(")");
            return str.toString();
        }
    }

    public static class WhereClauseCondition
    extends ClauseItem {
        private Operator operator;
        private String propSymbolicName;
        private String propName;
        private SearchTemplate.ObjectType propObjectType;
        private DataType propDataType;
        private boolean propHasChoices;
        private String propChoiceId;
        private boolean propHasMarkings;
        private String literal;
        private String label;
        private boolean valid = true;
        private Operator smartOperator;

        WhereClauseCondition() {
        }

        WhereClauseCondition(String operator, String propSymbolicName, String propName, String propObjectType, String propDataType, boolean propHasChoices, String propChoiceId, boolean propHasMarkings, String editProperty, String literal) {
            super(editProperty);
            this.operator = operator == null ? null : Operator.valueOf(operator);
            this.propSymbolicName = propSymbolicName;
            this.propName = propName;
            this.propObjectType = propObjectType == null ? null : SearchTemplate.ObjectType.valueOf(propObjectType);
            this.propDataType = propDataType == null ? null : DataType.valueOf(propDataType);
            this.propHasChoices = propHasChoices;
            this.propChoiceId = propChoiceId;
            this.propHasMarkings = propHasMarkings;
            this.literal = literal;
        }

        WhereClauseCondition(Operator operator, String propSymbolicName, String propName, SearchTemplate.ObjectType propObjectType, DataType propDataType, boolean propHasChoices, String propChoiceId, boolean propHasMarkings, SearchTemplate.SearchEditProperty editProperty, String literal) {
            super(editProperty);
            this.operator = operator;
            this.propSymbolicName = propSymbolicName;
            this.propName = propName;
            this.propObjectType = propObjectType;
            this.propDataType = propDataType;
            this.propHasChoices = propHasChoices;
            this.propChoiceId = propChoiceId;
            this.propHasMarkings = propHasMarkings;
            this.literal = literal;
        }

        public boolean isContainer() {
            return false;
        }

        public String getLiteral() {
            return this.literal;
        }

        void setLiteral(String literal) {
            this.literal = literal;
        }

        public String getLabel() {
            return this.label;
        }

        void setLabel(String label) {
            this.label = label;
        }

        public Operator getOperator() {
            return this.operator;
        }

        void setOperator(String operator) {
            this.operator = operator == null ? null : Operator.valueOf(operator);
        }

        void setOperator(Operator operator) {
            this.operator = operator;
        }

        boolean isOperatorNullOrNotNull() {
            return this.operator != null && (this.operator == Operator.isnull || this.operator == Operator.isnotnull);
        }

        public DataType getPropDataType() {
            return this.propDataType;
        }

        void setPropDataType(String propDataType) {
            this.propDataType = propDataType == null ? null : DataType.valueOf(propDataType);
        }

        boolean isPropHasChoices() {
            return this.propHasChoices;
        }

        void setPropHasChoices(boolean propHasChoices) {
            this.propHasChoices = propHasChoices;
        }

        String getPropChoiceId() {
            return this.propChoiceId;
        }

        void setPropChoiceId(String propChoiceId) {
            this.propChoiceId = propChoiceId;
        }

        boolean isPropHasMarkings() {
            return this.propHasMarkings;
        }

        void setPropHasMarkings(boolean propHasMarkings) {
            this.propHasMarkings = propHasMarkings;
        }

        String getPropName() {
            return this.propName;
        }

        void setPropName(String propName) {
            this.propName = propName;
        }

        SearchTemplate.ObjectType getPropObjectType() {
            return this.propObjectType;
        }

        void setPropObjectType(String propObjectType) {
            this.propObjectType = propObjectType == null ? null : SearchTemplate.ObjectType.valueOf(propObjectType);
        }

        public String getPropSymbolicName() {
            return this.propSymbolicName;
        }

        void setPropSymbolicName(String propSymbolicName) {
            this.propSymbolicName = propSymbolicName;
        }

        boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
        }

        public Operator getSmartOperator() {
            return this.smartOperator;
        }

        void setSmartOperator(String smartOperator) {
            this.smartOperator = smartOperator == null ? null : Operator.valueOf(smartOperator);
        }

        int getDatabaseType() {
            SearchClause sc = this.getSearchClause();
            P8SearchDefinition sd = sc == null ? null : sc.getSearchDefinition();
            return sd == null ? 0 : sd.getDatabaseType();
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(operator = ").append((Object)this.operator);
            str.append(", propSymbolicName = ").append(this.propSymbolicName);
            str.append(", propName = ").append(this.propName);
            str.append(", propObjectType = ").append((Object)this.propObjectType);
            str.append(", propDataType = ").append((Object)this.propDataType);
            str.append(", propHasChoices = ").append(this.propHasChoices);
            str.append(", propChoiceId = ").append(this.propChoiceId);
            str.append(", propHasMarkings = ").append(this.propHasMarkings);
            str.append(", editProperty = ").append((Object)this.getEditProperty());
            str.append(", literal = ").append(this.literal);
            str.append(", itemId = ").append(this.getItemId());
            str.append(", valid = ").append(this.valid).append(")");
            return str.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Container
    extends Clause {
        private Operator join;
        private List<Clause> clauses = new ArrayList<Clause>();
        private boolean include;
        private boolean range;

        Container() {
        }

        Container(String join) {
            this(join == null ? null : Operator.valueOf(join));
        }

        Container(Operator join) {
            this.join = join;
        }

        public Operator getJoin() {
            return this.join;
        }

        void setJoin(Operator join) {
            this.join = join;
        }

        @Override
        public boolean isContainer() {
            return true;
        }

        public List<Clause> getClauses() {
            return this.clauses;
        }

        void setClauses(List<Clause> clauses) {
            this.clauses = clauses;
            this.resetItemsCache();
        }

        void addClause(Clause clause) {
            this.clauses.add(clause);
            clause.setContainer(this);
            this.resetItemsCache();
        }

        void replaceClause(Clause oldClause, Clause newClause) {
            for (int i = 0; i < this.clauses.size(); ++i) {
                Clause clause = this.clauses.get(i);
                String itemId = clause.getItemId();
                if (!clause.equals(oldClause) && (itemId == null || !itemId.equals(oldClause.getItemId()))) continue;
                if (newClause == null) {
                    this.clauses.remove(clause);
                    break;
                }
                this.clauses.set(i, newClause);
                break;
            }
            if (newClause != null) {
                newClause.setContainer(this);
            }
            this.resetItemsCache();
        }

        private void resetItemsCache() {
            SearchClause sc = this.getSearchClause();
            if (sc != null) {
                sc.resetItemsCache();
            }
        }

        boolean isInclude() {
            return this.include;
        }

        void setInclude(boolean include) {
            this.include = include;
        }

        public boolean isRange() {
            return this.range;
        }

        public void setRange(boolean range) {
            this.range = range;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(join = ").append((Object)this.getJoin());
            str.append(", include = ").append(this.include);
            str.append(", range = ").append(this.range);
            str.append(", ").append(NEW_LINE).append("    whereClauses = ").append(this.clauses).append(")");
            return str.toString();
        }
    }

    static abstract class ClauseItem
    extends Clause {
        private SearchTemplate.SearchEditProperty editProperty;

        ClauseItem() {
        }

        ClauseItem(SearchTemplate.SearchEditProperty editProperty) {
            this.editProperty = editProperty;
        }

        ClauseItem(String editProperty) {
            this.editProperty = editProperty == null ? null : SearchTemplate.SearchEditProperty.valueOf(editProperty);
        }

        SearchTemplate.SearchEditProperty getEditProperty() {
            return this.editProperty == null ? SearchTemplate.SearchEditProperty.editable : this.editProperty;
        }

        void setEditProperty(String editProperty) {
            this.editProperty = editProperty == null ? null : SearchTemplate.SearchEditProperty.valueOf(editProperty);
        }

        boolean isHidden() {
            return this.editProperty != null && this.editProperty == SearchTemplate.SearchEditProperty.hidden;
        }

        boolean isReadOnly() {
            return this.editProperty != null && this.editProperty == SearchTemplate.SearchEditProperty.readonly;
        }

        boolean isRequired() {
            return this.editProperty != null && this.editProperty == SearchTemplate.SearchEditProperty.required;
        }
    }

    static abstract class Clause {
        private Container container;
        private String itemId;
        private SearchClause searchClause;

        Clause() {
        }

        abstract boolean isContainer();

        Container getContainer() {
            return this.container;
        }

        void setContainer(Container container) {
            this.container = container;
        }

        String getItemId() {
            return this.itemId;
        }

        void setItemId(String itemId) {
            this.itemId = itemId;
        }

        SearchClause getSearchClause() {
            if (this.searchClause == null) {
                Container c = this.getContainer();
                this.searchClause = c == null ? null : c.getSearchClause();
            }
            return this.searchClause;
        }

        void setSearchClause(SearchClause searchClause) {
            this.searchClause = searchClause;
        }
    }

    public static class SelectProperty {
        private String symbolicName;
        private String displayName;
        private SearchTemplate.ObjectType objectType;
        private int sortLevel;
        private SortOrder sortOrder;
        private String alignment;
        private String itemId;
        private SearchClause searchClause;

        SelectProperty() {
        }

        SelectProperty(String symbolicName, String displayName, String objectType, int sortLevel, String sortOrder, String alignment) {
            this.symbolicName = symbolicName;
            this.displayName = displayName;
            this.objectType = objectType == null ? null : SearchTemplate.ObjectType.valueOf(objectType);
            this.sortLevel = sortLevel;
            this.sortOrder = sortOrder == null || sortOrder.isEmpty() ? null : SortOrder.valueOf(sortOrder);
            this.alignment = alignment;
        }

        SelectProperty(String symbolicName, String displayName, SearchTemplate.ObjectType objectType, int sortLevel, SortOrder sortOrder, String alignment) {
            this.symbolicName = symbolicName;
            this.displayName = displayName;
            this.objectType = objectType;
            this.sortLevel = sortLevel;
            this.sortOrder = sortOrder;
            this.alignment = alignment;
        }

        String getAlignment() {
            return this.alignment;
        }

        void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        String getItemId() {
            return this.itemId;
        }

        void setItemId(String itemId) {
            this.itemId = itemId;
        }

        String getDisplayName() {
            return this.displayName;
        }

        void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        SearchTemplate.ObjectType getObjectType() {
            return this.objectType;
        }

        void setObjectType(String objectType) {
            this.objectType = objectType == null ? null : SearchTemplate.ObjectType.valueOf(objectType);
        }

        public int getSortLevel() {
            return this.sortLevel;
        }

        void setSortLevel(int sortLevel) {
            this.sortLevel = sortLevel;
        }

        public SortOrder getSortOrder() {
            return this.sortOrder;
        }

        void setSortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        boolean isSortOrderDescending() {
            return this.sortOrder != null && this.sortOrder.equals((Object)SortOrder.descending);
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        void setSymbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
        }

        SearchClause getSearchClause() {
            return this.searchClause;
        }

        void setSearchClause(SearchClause searchClause) {
            this.searchClause = searchClause;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(symbolicName = ").append(this.symbolicName);
            str.append(", displayName = ").append(this.displayName);
            str.append(", objectType = ").append((Object)this.objectType);
            str.append(", sortLevel = ").append(this.sortLevel);
            str.append(", sortOrder = ").append((Object)this.sortOrder);
            str.append(", alignment = ").append(this.alignment);
            str.append(", itemId = ").append(this.itemId).append(")");
            return str.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchClause {
        private List<SelectProperty> selectProperties = new ArrayList<SelectProperty>();
        private SearchTemplate.ObjectType from;
        private Clause whereClause;
        private ContentCriteria contentCriteria;
        private List<Subclass> subclasses = new ArrayList<Subclass>();
        private Map<String, ClauseItem> whereClauseItems = null;
        private Map<String, ClauseItem> contentClauseItems = null;
        private P8SearchDefinition searchDefinition;

        SearchClause() {
        }

        boolean isSortingDefined() {
            Map<String, SelectProperty> sortProps = this.getSortedProperties(this.selectProperties);
            return sortProps != null && sortProps.size() > 0;
        }

        SearchClause(String from) {
            this.from = from == null ? null : SearchTemplate.ObjectType.valueOf(from);
        }

        public SearchTemplate.ObjectType getFrom() {
            return this.from;
        }

        void setFrom(String from) {
            this.from = from == null ? null : SearchTemplate.ObjectType.valueOf(from);
        }

        public List<SelectProperty> getSelectProperties() {
            return this.selectProperties;
        }

        SelectProperty getSelectProperty(String propertyName) {
            if (propertyName.startsWith("[")) {
                propertyName = propertyName.substring(1, propertyName.length() - 1);
            }
            SelectProperty selectProp = null;
            for (SelectProperty sp : this.selectProperties) {
                if (!sp.getSymbolicName().equals(propertyName)) continue;
                selectProp = sp;
                break;
            }
            return selectProp;
        }

        void setSelectProperties(List<SelectProperty> selectProperties) {
            this.selectProperties = selectProperties;
        }

        void addSelectProperty(SelectProperty selectProperty) {
            selectProperty.setSearchClause(this);
            this.selectProperties.add(selectProperty);
        }

        public List<Subclass> getSubclasses() {
            return this.subclasses;
        }

        void setSubclasses(List<Subclass> subclasses) {
            this.subclasses = subclasses;
        }

        void addSubclass(Subclass subclass) {
            this.subclasses.add(subclass);
        }

        Subclass getSubclass(String itemId) {
            if (itemId == null || itemId.isEmpty()) {
                return null;
            }
            Subclass subclass = null;
            for (Subclass sc : this.subclasses) {
                if (!itemId.equals(sc.getItemId())) continue;
                subclass = sc;
                break;
            }
            return subclass;
        }

        public ContentCriteria getContentCriteria() {
            return this.contentCriteria;
        }

        void setContentCriteria(ContentCriteria contentCriteria) {
            this.contentCriteria = contentCriteria;
            this.contentClauseItems = null;
        }

        public Clause getWhereClause() {
            return this.whereClause;
        }

        void setWhereClause(Clause whereClause) {
            this.whereClause = whereClause;
            this.whereClauseItems = null;
        }

        private void extractClauseItems(Clause clause, Map<String, ClauseItem> conditions) {
            if (clause == null) {
                return;
            }
            if (clause.isContainer()) {
                Container wcc = (Container)clause;
                List<Clause> whereClauses = wcc.getClauses();
                for (Clause wc : whereClauses) {
                    this.extractClauseItems(wc, conditions);
                }
            } else {
                ClauseItem condition = (ClauseItem)clause;
                conditions.put(clause.getItemId(), condition);
            }
        }

        Map<String, ClauseItem> retrieveWhereClauseConditions() {
            if (this.whereClauseItems != null) {
                return this.whereClauseItems;
            }
            this.whereClauseItems = new HashMap<String, ClauseItem>();
            this.extractClauseItems(this.whereClause, this.whereClauseItems);
            return this.whereClauseItems;
        }

        WhereClauseCondition getWhereClauseCondition(String itemId) {
            return (WhereClauseCondition)this.retrieveWhereClauseConditions().get(itemId);
        }

        Map<String, ClauseItem> retrieveContentClauseItems() {
            if (this.contentClauseItems != null) {
                return this.contentClauseItems;
            }
            this.contentClauseItems = new HashMap<String, ClauseItem>();
            if (this.contentCriteria != null) {
                this.extractClauseItems(this.contentCriteria.getContentClause(), this.contentClauseItems);
            }
            return this.contentClauseItems;
        }

        ContentClauseItem getContentClauseItem(String itemId) {
            return (ContentClauseItem)this.retrieveContentClauseItems().get(itemId);
        }

        private void resetItemsCache() {
            this.whereClauseItems = null;
            this.contentClauseItems = null;
        }

        public boolean isContentCriteriaDefined() {
            boolean defined = false;
            Collection<ClauseItem> conditions = this.retrieveContentClauseItems().values();
            for (ClauseItem c : conditions) {
                ContentClauseItem item = (ContentClauseItem)c;
                String text = item.getUserText();
                if (text == null || text.length() <= 0) continue;
                defined = true;
                break;
            }
            return defined;
        }

        public boolean isPropertyContentCriteriaDefined() {
            boolean defined = false;
            Collection<ClauseItem> conditions = this.retrieveWhereClauseConditions().values();
            for (ClauseItem c : conditions) {
                WhereClauseCondition condition = (WhereClauseCondition)c;
                String value = condition.getLiteral();
                defined = condition.getOperator() == Operator.contains && value != null && value.length() > 0;
                if (!defined) continue;
                break;
            }
            return defined;
        }

        P8SearchDefinition getSearchDefinition() {
            return this.searchDefinition;
        }

        void setSearchDefinition(P8SearchDefinition searchDefinition) {
            this.searchDefinition = searchDefinition;
        }

        Map<String, SelectProperty> getSortedProperties(List<SelectProperty> selectProps) {
            if (selectProps == null || selectProps.size() < 1) {
                return null;
            }
            TreeMap<String, SelectProperty> sortProps = new TreeMap<String, SelectProperty>();
            for (SelectProperty selectProp : selectProps) {
                int sl = selectProp.getSortLevel();
                if (sl <= 0) continue;
                String sortLevel = String.valueOf(sl);
                sortProps.put(sortLevel, selectProp);
            }
            return sortProps;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(").append(NEW_LINE).append("SELECTCLAUSE = ").append(this.selectProperties);
            str.append(", ").append(NEW_LINE).append("FROMCLAUSE = ").append((Object)this.from);
            str.append(", ").append(NEW_LINE).append("SUBCLASSES = ").append(this.subclasses);
            str.append(", ").append(NEW_LINE).append("WHERECLAUSE = ").append(this.whereClause);
            str.append(", ").append(NEW_LINE).append("CONTENTCLAUSE = ").append(this.contentCriteria).append(")");
            return str.toString();
        }
    }

    public static class SearchInFolder {
        private String id;
        private String pathName;
        private boolean searchSubfolders;
        private String itemId;
        private SearchTemplate.SearchFolderView view;
        private String objectStoreId;
        private String objectStoreName;

        SearchInFolder() {
        }

        SearchInFolder(String id, String pathName, boolean searchSubfolders, String view, String objectStoreId) {
            this.id = id;
            this.pathName = pathName;
            this.searchSubfolders = searchSubfolders;
            this.view = view == null ? null : SearchTemplate.SearchFolderView.valueOf(view);
            this.objectStoreId = objectStoreId;
        }

        SearchInFolder(String id, String pathName, boolean searchSubfolders, SearchTemplate.SearchFolderView view, String objectStoreId) {
            this.id = id;
            this.pathName = pathName;
            this.searchSubfolders = searchSubfolders;
            this.view = view;
            this.objectStoreId = objectStoreId;
        }

        public String getId() {
            return this.id;
        }

        void setId(String id) {
            this.id = id;
        }

        String getItemId() {
            return this.itemId;
        }

        void setItemId(String itemId) {
            this.itemId = itemId;
        }

        String getObjectStoreId() {
            return this.objectStoreId;
        }

        void setObjectStoreId(String objectStoreId) {
            this.objectStoreId = objectStoreId;
        }

        String getObjectStoreName() {
            return this.objectStoreName;
        }

        void setObjectStoreName(String objectStoreName) {
            this.objectStoreName = objectStoreName;
        }

        String getPathName() {
            return this.pathName;
        }

        void setPathName(String pathName) {
            this.pathName = pathName;
        }

        public boolean isSearchSubfolders() {
            return this.searchSubfolders;
        }

        void setSearchSubfolders(boolean searchSubfolders) {
            this.searchSubfolders = searchSubfolders;
        }

        SearchTemplate.SearchFolderView getView() {
            return this.view;
        }

        void setView(String view) {
            this.view = view == null ? null : SearchTemplate.SearchFolderView.valueOf(view);
        }

        boolean isHidden() {
            return this.view != null && this.view == SearchTemplate.SearchFolderView.hidden;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(id = ").append(this.id);
            str.append(", pathName = ").append(this.pathName);
            str.append(", searchSubfolders = ").append(this.searchSubfolders);
            str.append(", itemId = ").append(this.itemId);
            str.append(", view = ").append((Object)this.view);
            str.append(", objectStoreId = ").append(this.objectStoreId).append(")");
            return str.toString();
        }
    }

    public static class SearchInObjectStore {
        private String id;
        private String name;
        private String symbolicName;

        SearchInObjectStore() {
        }

        public SearchInObjectStore(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public void setSymbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(id = ").append(this.id);
            str.append(", name = ").append(this.name).append(")");
            return str.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VeritySearchOperator {
        soundex,
        stem,
        thesaurus,
        wildcard,
        word,
        none;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        and,
        commonplaceholder,
        eq,
        gt,
        gte,
        in,
        inany,
        isnotnull,
        isnull,
        like,
        lt,
        lte,
        neq,
        notin,
        notlike,
        or,
        between,
        notbetween,
        startswith,
        endswith,
        contains;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CbrColumn {
        rank,
        contentsummary;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JoinType {
        inner,
        leftouter,
        fullouter;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchModifier {
        proximity,
        boost,
        fuzzy;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequiredState {
        prohibited,
        required,
        none;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GroupAction {
        all,
        any,
        near,
        none,
        paragraph,
        sentence,
        in,
        vql;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        typestring,
        typeobject,
        typedate,
        typebinary,
        typeboolean,
        typedouble,
        typeguid,
        typelong;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortOrder {
        ascending,
        descending,
        none;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MergeScope {
        intersection,
        union,
        none;

    }
}

