/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.core.CustomObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.property.Properties;
import com.ibm.ecm.util.p8.P8Query;
import java.util.Iterator;

public class P8RecordsUtil {
    private static final String FPOS_SETUP_ID = "{C0B882FD-9434-4885-82B7-B13B59E29CFF}";
    private static final String PROPERTY_VALUE = "PropertyValue";
    private static final String BASE = "Base";
    private static final String PRO_2002 = "PRO-2002";
    private static final String DOD_5015_CLASSIFIED = "DOD-5015.2 Classified";
    private static final String DOD_5015 = "DOD-5015.2";
    public static final String RECORD = "RecordInfo";
    public static final String ELECTRONIC_RECORD = "ElectronicRecordInfo";
    public static final String RMFOLDER = "RMFolder";
    public static final String SYSTEM_CONFIGURATION = "SystemConfiguration";
    public static final String FILEPLAN = "ClassificationScheme";

    public static Datamodel getDatamodelType(ObjectStore os) {
        Properties properties;
        CustomObject co = Factory.CustomObject.fetchInstance((ObjectStore)os, (String)FPOS_SETUP_ID, null);
        if (co != null && (properties = co.getProperties()).isPropertyPresent(PROPERTY_VALUE)) {
            String datamodel = co.getProperties().getStringValue(PROPERTY_VALUE);
            if (datamodel.equals(BASE)) {
                return Datamodel.Base;
            }
            if (datamodel.equals(PRO_2002)) {
                return Datamodel.Pro;
            }
            if (datamodel.equals(DOD_5015_CLASSIFIED)) {
                return Datamodel.DoDClassified;
            }
            if (datamodel.equals(DOD_5015)) {
                return Datamodel.DoD;
            }
            return null;
        }
        return null;
    }

    public static RecordRepositoryType getRecordRepositoryType(ObjectStore os) {
        P8Query query = new P8Query();
        query.setRequestedProperties("Id", "SymbolicName", "DisplayName");
        query.setFromClause("ClassDefinition");
        query.setObjectStore(os);
        StringBuilder whereClause = new StringBuilder("SymbolicName");
        whereClause.append(" IN ('");
        whereClause.append("RecordInfo', 'ElectronicRecordInfo', 'RMFolder', 'SystemConfiguration', 'ClassificationScheme')");
        query.setWhereClause(whereClause.toString());
        int contentIndicator = 0;
        int fileplanIndicator = 0;
        Iterator<IndependentObject> results = query.executeQueryAsObjectsIterator();
        while (results.hasNext()) {
            ClassDefinition cd = (ClassDefinition)results.next();
            String name = cd.get_SymbolicName();
            if (name.equals(RECORD)) {
                ++contentIndicator;
                ++fileplanIndicator;
            }
            if (!name.equals(ELECTRONIC_RECORD) && !name.equals(RMFOLDER) && !name.equals(SYSTEM_CONFIGURATION) && !name.equals(FILEPLAN)) continue;
            ++fileplanIndicator;
        }
        if (contentIndicator == 1 && fileplanIndicator != 5) {
            return RecordRepositoryType.Content;
        }
        if (fileplanIndicator == 5) {
            return RecordRepositoryType.FilePlan;
        }
        return RecordRepositoryType.Plain;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecordRepositoryType {
        Content,
        FilePlan,
        Plain;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Datamodel {
        Base,
        DoD,
        Pro,
        DoDClassified;

    }
}

