/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.core.Document;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class P8QueryContinuationData {
    private static final String SALT = "za1uve3uzera2evu41pr";
    public boolean isWorkBasketData = false;
    public String sessionKey;
    public String documentSQL;
    public String folderSQL;
    public boolean returnOnlyFolders;
    public boolean descending;
    public String objectStoreId;
    public String folderId;
    public int itemsToSkip;
    public boolean orderByRank;
    public boolean mergeUnion;
    public boolean queriedAll;
    public byte[] checkpoint;
    public String fileTypeFilter;
    public Document ceStoredSearch;
    public Object ceDocumentSearchParams;
    public Object ceFolderSearchParams;
    public String applicationSpaceName;
    public String processRoleName;
    public String queueName;
    public String inbasketName;
    public String lastWorkRecord;
    public String orderBy;

    public P8QueryContinuationData(String serializedForm, boolean isWorkBasketData) throws UnsupportedEncodingException {
        this.isWorkBasketData = isWorkBasketData;
        String[] parts = StringUtils.splitPreserveAllTokens((String)serializedForm, (char)'*');
        this.sessionKey = P8QueryContinuationData.dec(parts[0]);
        String checksum = "";
        if (isWorkBasketData) {
            this.applicationSpaceName = P8QueryContinuationData.dec(parts[1]);
            this.processRoleName = P8QueryContinuationData.dec(parts[2]);
            this.queueName = P8QueryContinuationData.dec(parts[3]);
            this.inbasketName = P8QueryContinuationData.dec(parts[4]);
            this.lastWorkRecord = P8QueryContinuationData.dec(parts[5]);
            this.orderBy = P8QueryContinuationData.dec(parts[6]);
            this.descending = P8QueryContinuationData.decBool(parts[7]);
            checksum = parts[8];
        } else {
            this.documentSQL = P8QueryContinuationData.dec(parts[1]);
            this.folderSQL = P8QueryContinuationData.dec(parts[2]);
            this.returnOnlyFolders = P8QueryContinuationData.decBool(parts[3]);
            this.descending = P8QueryContinuationData.decBool(parts[4]);
            this.objectStoreId = P8QueryContinuationData.dec(parts[5]);
            this.folderId = P8QueryContinuationData.dec(parts[6]);
            this.itemsToSkip = Integer.parseInt(parts[7]);
            this.orderByRank = P8QueryContinuationData.decBool(parts[8]);
            this.mergeUnion = P8QueryContinuationData.decBool(parts[9]);
            this.queriedAll = P8QueryContinuationData.decBool(parts[10]);
            this.checkpoint = P8QueryContinuationData.decBytes(parts[11]);
            this.fileTypeFilter = P8QueryContinuationData.dec(parts[12]);
            checksum = parts[13];
        }
        String calculatedChecksum = this.calculateChecksum();
        if (!StringUtils.equals((String)checksum, (String)calculatedChecksum)) {
            throw new RuntimeException("Invalid checksum!");
        }
    }

    public P8QueryContinuationData() {
    }

    public String saveToString() throws UnsupportedEncodingException {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(P8QueryContinuationData.enc(this.sessionKey));
        if (this.isWorkBasketData) {
            parts.add(P8QueryContinuationData.enc(this.applicationSpaceName));
            parts.add(P8QueryContinuationData.enc(this.processRoleName));
            parts.add(P8QueryContinuationData.enc(this.queueName));
            parts.add(P8QueryContinuationData.enc(this.inbasketName));
            parts.add(P8QueryContinuationData.enc(this.lastWorkRecord));
            parts.add(P8QueryContinuationData.enc(this.orderBy));
            parts.add(P8QueryContinuationData.enc(this.descending));
        } else {
            parts.add(P8QueryContinuationData.enc(this.documentSQL));
            parts.add(P8QueryContinuationData.enc(this.folderSQL));
            parts.add(P8QueryContinuationData.enc(this.returnOnlyFolders));
            parts.add(P8QueryContinuationData.enc(this.descending));
            parts.add(P8QueryContinuationData.enc(this.objectStoreId));
            parts.add(P8QueryContinuationData.enc(this.folderId));
            parts.add(Integer.toString(this.itemsToSkip));
            parts.add(P8QueryContinuationData.enc(this.orderByRank));
            parts.add(P8QueryContinuationData.enc(this.mergeUnion));
            parts.add(P8QueryContinuationData.enc(this.queriedAll));
            parts.add(P8QueryContinuationData.enc(this.checkpoint));
            parts.add(P8QueryContinuationData.enc(this.fileTypeFilter));
        }
        String checksum = this.calculateChecksum();
        parts.add(checksum);
        String result = StringUtils.join(parts, (char)'*');
        return result;
    }

    private static String dec(String encoded) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)encoded)) {
            return "";
        }
        return new String(Base64.decodeBase64((String)encoded), "UTF-8");
    }

    private static boolean decBool(String encoded) {
        return StringUtils.equals((String)encoded, (String)"1");
    }

    private static byte[] decBytes(String encoded) {
        if (StringUtils.isEmpty((String)encoded)) {
            return null;
        }
        return Base64.decodeBase64((String)encoded);
    }

    private static String enc(String str) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        return Base64.encodeBase64String((byte[])str.getBytes("UTF-8")).trim();
    }

    private static String enc(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        return Base64.encodeBase64String((byte[])bytes).trim();
    }

    private static String enc(boolean bool) {
        return bool ? "1" : "0";
    }

    private String calculateChecksum() {
        String str = SALT + (this.sessionKey == null ? "" : this.sessionKey) + (this.checkpoint == null ? "" : P8QueryContinuationData.enc(this.checkpoint));
        String checksumString = P8QueryContinuationData.enc(DigestUtils.sha256((String)str));
        return checksumString;
    }

    public void setObjectStoreIds(String[] objectStoreIds) {
        for (int i = 0; i < objectStoreIds.length; ++i) {
            this.objectStoreId = i == 0 ? objectStoreIds[i] : this.objectStoreId + ":" + objectStoreIds[i];
        }
    }

    public String[] getObjectStoreIds() {
        return this.objectStoreId.split(":");
    }
}

