/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.constants.FilteredPropertyType;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8Query {
    private static final int STRING_BUFFER_SIZE = 400;
    private static final int DEFAULT_PAGE_SIZE = 200;
    private Collection<String> subProperties;
    private Collection<String> requestedProperties;
    private String fromClause;
    private String whereClause;
    private String orderByClause;
    private ObjectStore objectStore;
    private int pageSize = 200;
    private boolean addBracketsAroundSelectProperties = true;

    public void setAddBracketsAroundSelectProperties(boolean value) {
        this.addBracketsAroundSelectProperties = value;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = fromClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public Collection<String> getRequestedProperties() {
        return this.requestedProperties;
    }

    public void setRequestedProperties(String ... props) {
        this.requestedProperties = new HashSet<String>();
        this.requestedProperties.addAll(new HashSet<String>(Arrays.asList(props)));
    }

    public void setRequestedProperties(Collection<String> props) {
        this.requestedProperties = props;
    }

    public Collection<String> getSubProperties() {
        return this.subProperties;
    }

    public void setSubProperties(Collection<String> subProperties) {
        this.subProperties = subProperties;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public String generateSQL() {
        StringBuilder sql = new StringBuilder(400);
        sql.append("SELECT ");
        if (this.requestedProperties != null && this.requestedProperties.size() != 0) {
            Iterator<String> iterator = this.requestedProperties.iterator();
            while (iterator.hasNext()) {
                String prop = iterator.next();
                if (this.addBracketsAroundSelectProperties) {
                    sql.append('[');
                }
                sql.append(prop);
                if (this.addBracketsAroundSelectProperties) {
                    sql.append(']');
                }
                if (!iterator.hasNext()) continue;
                sql.append(", ");
            }
        } else {
            sql.append("*");
        }
        sql.append(" FROM ");
        sql.append(this.fromClause);
        if (this.whereClause != null && this.whereClause.length() != 0) {
            sql.append(" WHERE ");
            sql.append(this.whereClause);
        }
        if (this.orderByClause != null && this.orderByClause.length() != 0) {
            sql.append(" ORDER BY ");
            sql.append(this.orderByClause);
        }
        String sqlString = sql.toString();
        return sqlString;
    }

    public static Iterator<IndependentObject> executeQueryAsObjectsIterator(ObjectStore objectStore, String sql, Collection<String> subProperties, int pageSize, PropertyFilter filter) {
        SearchScope scope = new SearchScope(objectStore);
        SearchSQL search = new SearchSQL(sql);
        if (filter == null) {
            filter = P8Query.configurePropertyFilter(subProperties);
        }
        IndependentObjectSet rows = scope.fetchObjects(search, Integer.valueOf(pageSize), filter, Boolean.TRUE);
        return rows.iterator();
    }

    public Iterator<IndependentObject> executeQueryAsObjectsIterator() {
        String sql = this.generateSQL();
        return P8Query.executeQueryAsObjectsIterator(this.objectStore, sql, this.subProperties, this.pageSize, null);
    }

    private static PropertyFilter configurePropertyFilter(Collection<String> properties) {
        PropertyFilter filter = new PropertyFilter();
        if (properties != null) {
            for (String propertyName : properties) {
                filter.addIncludeProperty(1, null, null, propertyName, null);
            }
            filter.setMaxRecursion(1);
        }
        return filter;
    }

    public static PropertyFilter getDocumentPropertyFilter() {
        PropertyFilter propertyFilter = new PropertyFilter();
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_BOOLEAN, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_DATE, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_DOUBLE, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_GUID, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_LONG, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_STRING, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_BOOLEAN, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_DATE, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_DOUBLE, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_GUID, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_LONG, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_STRING, null);
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "VersionSeries", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "Id", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "ContentSize", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "MimeType", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "IsReserved", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "IsCurrentVersion", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "IsVersioningEnabled", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Reservation", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "ReservationType", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "Creator", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "Owner", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "VersionStatus", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "MajorVersionNumber", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "MinorVersionNumber", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "ClassDescription", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "PropertyDescriptions", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(4), null, null, "SymbolicName", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(4), null, null, "DataType", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(4), null, null, "IsHidden", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(4), null, null, "ChoiceList", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "ReplicationGroup", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "DisplayName", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "EntryTemplateObjectStoreName", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "EntryTemplateId", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "RecordInformation", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Parent", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "IcnAutoRun", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "IcnShowInTree", null));
        return propertyFilter;
    }

    public static PropertyFilter getFolderPropertyFilter() {
        PropertyFilter propertyFilter = new PropertyFilter();
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_BOOLEAN, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_DATE, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_DOUBLE, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_GUID, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_LONG, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.LIST_OF_STRING, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_BOOLEAN, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_DATE, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_DOUBLE, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_GUID, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_LONG, null);
        propertyFilter.addIncludeType(1, null, null, FilteredPropertyType.SINGLETON_STRING, null);
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Parent", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "Id", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "WorkspaceName", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "ClassDescription", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(2), null, null, "PropertyDescriptions", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(4), null, null, "SymbolicName", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(4), null, null, "DataType", null));
        propertyFilter.addIncludeProperty(new FilterElement(Integer.valueOf(4), null, null, "IsHidden", null));
        return propertyFilter;
    }

    public String toString() {
        return "(" + this.generateSQL() + ")";
    }
}

