/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.constants.AccessType;
import com.filenet.api.constants.SpecialPrincipal;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Containable;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.Scope;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.security.AccessPermission;
import com.filenet.api.security.Group;
import com.filenet.api.security.User;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8Permission {
    private String id;
    private String granteeName;
    private String displayName;
    private String emailAddress;
    private int granteeType;
    private int accessMask;
    private int accessType;
    private int inheritableDepth;
    private int permissionSource;

    public P8Permission() {
    }

    public P8Permission(String id, String granteeName, String displayName, int granteeType, int accessMask, int accessType, int inheritableDepth, int permissionSource) {
        this.id = id;
        this.granteeName = granteeName;
        this.displayName = displayName;
        this.granteeType = granteeType;
        this.accessMask = accessMask;
        this.accessType = accessType;
        this.inheritableDepth = inheritableDepth;
        this.permissionSource = permissionSource;
        this.emailAddress = "";
    }

    public P8Permission(String id, String granteeName, String displayName, String emailAddress, int granteeType, int accessMask, int accessType, int inheritableDepth, int permissionSource) {
        this.id = id;
        this.granteeName = granteeName;
        this.displayName = displayName;
        this.granteeType = granteeType;
        this.emailAddress = emailAddress;
        this.accessMask = accessMask;
        this.accessType = accessType;
        this.inheritableDepth = inheritableDepth;
        this.permissionSource = permissionSource;
        this.emailAddress = "";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGranteeName() {
        return this.granteeName;
    }

    public void setGranteeName(String granteeName) {
        this.granteeName = granteeName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public int getGranteeType() {
        return this.granteeType;
    }

    public void setGranteeType(int granteeType) {
        this.granteeType = granteeType;
    }

    public void setGranteeTypeValue(String granteeType) {
        this.setGranteeType(Integer.parseInt(granteeType));
    }

    public int getAccessMask() {
        return this.accessMask;
    }

    public void setAccessMask(int accessMask) {
        this.accessMask = accessMask;
    }

    public void setAccessMaskValue(String accessMask) {
        this.setAccessMask(Integer.parseInt(accessMask));
    }

    public int getAccessType() {
        return this.accessType;
    }

    public void setAccessType(int accessType) {
        this.accessType = accessType;
    }

    public void setAccessTypeValue(String accessType) {
        this.setAccessType(Integer.parseInt(accessType));
    }

    public int getInheritableDepth() {
        return this.inheritableDepth;
    }

    public void setInheritableDepth(int inheritableDepth) {
        this.inheritableDepth = inheritableDepth;
    }

    public void setInheritableDepthValue(String inheritableDepth) {
        this.setInheritableDepth(Integer.parseInt(inheritableDepth));
    }

    public int getPermissionSource() {
        return this.permissionSource;
    }

    public void setPermissionSource(int permissionSource) {
        this.permissionSource = permissionSource;
    }

    public void setPermissionSourceValue(String permissionSource) {
        this.setPermissionSource(Integer.parseInt(permissionSource));
    }

    public static List<P8Permission> getPermissions(HttpServletRequest request, P8Connection connection, String id) {
        List<P8Permission> permissionList = new ArrayList<P8Permission>();
        IndependentlyPersistableObject ipo = P8Util.getPersistableObject(request, connection, id);
        if (ipo instanceof Containable) {
            AccessPermissionList apl = ((Containable)ipo).get_Permissions();
            permissionList = P8Permission.getPermissionList(connection, apl, true);
        }
        return permissionList;
    }

    public static AccessPermissionList getPermissionsFromJSON(String permissionJSON) throws Exception {
        AccessPermissionList permissionList = null;
        if (permissionJSON != null) {
            JSONArray permissionJSONArray = JSONArray.parse(permissionJSON);
            permissionList = P8Permission.getPermissionsFromJSON(permissionJSONArray);
        }
        return permissionList;
    }

    public static AccessPermissionList getPermissionsFromJSON(JSONArray permissionJSONArray) throws Exception {
        AccessPermissionList permissionList = null;
        if (permissionJSONArray != null && permissionJSONArray.size() >= 0) {
            permissionList = Factory.AccessPermission.createList();
            for (int i = 0; i < permissionJSONArray.size(); ++i) {
                JSONObject permission = (JSONObject)permissionJSONArray.get(i);
                int mask = Integer.parseInt(permission.get("accessMask").toString());
                if (mask <= 0) continue;
                AccessPermission accessPermission = Factory.AccessPermission.createInstance();
                accessPermission.set_AccessType(Integer.parseInt(permission.get("accessType").toString()) == 1 ? AccessType.ALLOW : AccessType.DENY);
                accessPermission.set_AccessMask(Integer.valueOf(Integer.parseInt(permission.get("accessMask").toString())));
                accessPermission.set_InheritableDepth(Integer.valueOf(Integer.parseInt(permission.get("inheritableDepth").toString())));
                accessPermission.set_GranteeName(permission.get("granteeName").toString());
                permissionList.add((Object)accessPermission);
            }
        }
        return permissionList;
    }

    public static AccessPermissionList getPermissions(List<P8Permission> permissions) throws Exception {
        AccessPermissionList permissionList = null;
        if (permissions != null && permissions.size() >= 0) {
            permissionList = Factory.AccessPermission.createList();
            for (int i = 0; i < permissions.size(); ++i) {
                P8Permission permission = permissions.get(i);
                if (permission.getAccessMask() <= 0) continue;
                AccessPermission accessPermission = Factory.AccessPermission.createInstance();
                accessPermission.set_AccessType(permission.getAccessType() == 1 ? AccessType.ALLOW : AccessType.DENY);
                accessPermission.set_AccessMask(Integer.valueOf(permission.getAccessMask()));
                accessPermission.set_InheritableDepth(Integer.valueOf(permission.getInheritableDepth()));
                accessPermission.set_GranteeName(permission.getGranteeName());
                permissionList.add((Object)accessPermission);
            }
        }
        return permissionList;
    }

    public static List<P8Permission> getDefaultInstancePermissions(P8Connection connection, String className, boolean setCreatorOwner) {
        ClassDescription classDescription = Factory.ClassDescription.fetchInstance((Scope)connection.getObjectStore(), (String)className, null);
        AccessPermissionList apl = classDescription.get_DefaultInstancePermissions();
        return P8Permission.getPermissionList(connection, apl, setCreatorOwner);
    }

    public static List<P8Permission> getPermissions(P8Connection connection, AccessPermissionList apl, boolean setCreatorOwner) {
        return P8Permission.getPermissionList(connection, apl, setCreatorOwner);
    }

    public static void updatePermissionNames(P8Connection connection, P8Permission permission, boolean setCreatorOwner) {
        if (connection == null) {
            return;
        }
        String granteeId = permission.getId();
        String granteeName = permission.getGranteeName();
        String displayName = permission.getDisplayName();
        String emailAddress = "";
        if (setCreatorOwner && granteeName.equalsIgnoreCase(SpecialPrincipal.CREATOR_OWNER.getValue())) {
            User currentUser = Factory.User.fetchCurrent((Connection)connection.getCEConnection(), null);
            granteeId = currentUser.get_Id();
            granteeName = currentUser.get_ShortName();
            displayName = currentUser.get_DisplayName();
            emailAddress = currentUser.get_Email();
        } else if (!granteeName.equalsIgnoreCase(SpecialPrincipal.AUTHENTICATED_USERS.getValue())) {
            try {
                if (permission.getGranteeType() == 2000) {
                    User user = Factory.User.fetchInstance((Connection)connection.getCEConnection(), (String)granteeId, null);
                    granteeId = user.get_Id();
                    granteeName = user.get_ShortName();
                    displayName = user.get_DisplayName();
                    emailAddress = user.get_Email();
                } else {
                    Group group = Factory.Group.fetchInstance((Connection)connection.getCEConnection(), (String)granteeId, null);
                    granteeId = group.get_Id();
                    granteeName = group.get_ShortName();
                    displayName = group.get_DisplayName();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (granteeName == null || granteeName.length() == 0) {
            granteeName = granteeId;
        }
        if (displayName == null || displayName.length() == 0) {
            displayName = granteeName;
        }
        permission.setId(granteeId);
        permission.setGranteeName(granteeName);
        permission.setDisplayName(displayName);
        permission.setEmailAddress(emailAddress);
    }

    private static List<P8Permission> getPermissionList(P8Connection connection, AccessPermissionList apl, boolean setCreatorOwner) {
        ArrayList<P8Permission> permissionList = new ArrayList<P8Permission>();
        for (AccessPermission ap : apl) {
            String granteeId = ap.get_GranteeName();
            P8Permission permission = new P8Permission(granteeId, granteeId, granteeId, ap.get_GranteeType().getValue(), ap.get_AccessMask(), ap.get_AccessType().getValue(), ap.get_InheritableDepth(), ap.get_PermissionSource().getValue());
            P8Permission.updatePermissionNames(connection, permission, setCreatorOwner);
            permissionList.add(permission);
        }
        return permissionList;
    }

    public static JSONArray permissionsToJSONObject(List<P8Permission> permissions) {
        JSONArray jsonPermissions = new JSONArray();
        if (permissions != null) {
            for (P8Permission permission : permissions) {
                JSONObject jsonPermission = new JSONObject();
                jsonPermission.put("id", permission.getId());
                jsonPermission.put("granteeName", permission.getGranteeName());
                jsonPermission.put("displayName", permission.getDisplayName());
                jsonPermission.put("granteeType", (Object)permission.getGranteeType());
                jsonPermission.put("accessMask", (Object)permission.getAccessMask());
                jsonPermission.put("accessType", (Object)permission.getAccessType());
                jsonPermission.put("inheritableDepth", (Object)permission.getInheritableDepth());
                jsonPermission.put("permissionSource", (Object)permission.getPermissionSource());
                jsonPermissions.add(jsonPermission);
            }
        }
        return jsonPermissions;
    }
}

