/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.admin.AddOn;
import com.filenet.api.collection.IdList;
import com.filenet.api.constants.AddOnType;
import com.filenet.api.constants.FilteredPropertyType;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.api.util.UserContext;
import com.ibm.ecm.serviceability.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Scanner;
import javax.security.auth.Subject;
import javax.servlet.http.HttpSession;

public class P8NexusAddOn {
    private static final String BASE_NEXUS_ADDON_NAME = "IBM Content Navigator 2.0.0";
    private static final String NEXUS_ADDON_NAME_EXTN = "Extensions";
    public static final Id NEXUS_STORED_SEARCH_ADDON_ID = new Id("{CE510ADD-0000-0000-0000-000000000011}");
    public static final Id NEXUS_TEAMSPACE_ADDON_ID = new Id("{CE510ADD-0000-0000-0000-000000000012}");
    public static final String NEXUS_STORED_SEARCH_ADDON_NAME = "IBM Content Navigator 2.0.0 Stored Search Extensions";
    public static final String NEXUS_TEAMSPACE_ADDON_NAME = "IBM Content Navigator 2.0.0 Teamspace Extensions";
    private static String ADDON_STORED_SEARCH_IMPORT_FILE = "NexusStoredSearchAddonImportData.xml";
    private static String ADDON_TEAMSPACE_IMPORT_FILE = "NexusTeamSpaceAddonImportData.xml";
    private static String ADDON_IMPORT_BASE_PATH = "com/ibm/ecm/util/p8/";
    private static final String TEAMSPACES_FOLDER_NAME = "Teamspaces";
    private static final String TEAMSPACES_TEMPLATES_FOLDER_NAME = "Teamspace Templates";
    public static final Id BASE_APPLICATION_ADDON_ID = new Id("{CE451ADD-0000-0000-0000-000000000004}");
    public static final Id BASE_STORED_SEARCH_ADDON_ID = new Id("{CE451ADD-0000-0000-0000-000000000006}");
    public static final Id CE520_BASE_STORED_SEARCH_ADDON_ID = new Id("{CE511ADD-0000-0000-0000-000000000006}");
    public static final Id WORKPLACE_ACCESS_ROLE_ADDON_ID = new Id("{CE451ADD-0000-0000-0000-000000000008}");

    public static Connection establishConnection(String userName, String password, String stanza, String uri) {
        Connection con = Factory.Connection.getConnection((String)uri);
        UserContext uc = UserContext.get();
        Subject sub = UserContext.createSubject((Connection)con, (String)userName, (String)password, (String)stanza);
        uc.pushSubject(sub);
        return con;
    }

    public static void createAddOn(String userName, String password, String stanza, String uri, Id addonId) throws Exception {
        Connection connection = P8NexusAddOn.establishConnection(userName, password, stanza, uri);
        Domain domain = Factory.Domain.fetchInstance((Connection)connection, null, null);
        P8NexusAddOn.createAddOn(domain, addonId);
    }

    public static void updateAddOn(String userName, String password, String stanza, String uri, Id addonId) throws Exception {
        Connection connection = P8NexusAddOn.establishConnection(userName, password, stanza, uri);
        Domain domain = Factory.Domain.fetchInstance((Connection)connection, null, null);
        P8NexusAddOn.updateAddOn(domain, addonId);
    }

    public static void deleteAddOn(String userName, String password, String stanza, String uri, Id addonId) throws Exception {
        Connection connection = P8NexusAddOn.establishConnection(userName, password, stanza, uri);
        Domain domain = Factory.Domain.fetchInstance((Connection)connection, null, null);
        P8NexusAddOn.deleteAddOn(domain, addonId);
    }

    public static void installAddOn(String userName, String password, String stanza, String uri, String objectStoreName, Id addonId) throws Exception {
        Connection connection = P8NexusAddOn.establishConnection(userName, password, stanza, uri);
        Domain domain = Factory.Domain.fetchInstance((Connection)connection, null, null);
        P8NexusAddOn.installAddOn(domain, objectStoreName, addonId);
    }

    public static boolean checkPreRequisiteAddons(String userName, String password, String stanza, String uri, String objectStoreName, Id addonId) throws Exception {
        Connection connection = P8NexusAddOn.establishConnection(userName, password, stanza, uri);
        Domain domain = Factory.Domain.fetchInstance((Connection)connection, null, null);
        ObjectStore os = Factory.ObjectStore.fetchInstance((Domain)domain, (String)objectStoreName, null);
        return P8NexusAddOn.checkPreRequisiteAddons(domain, os, addonId);
    }

    public static void deleteAddOn(Domain domain, Id addonId) throws Exception {
        String methodName = "deleteAddOns";
        if (P8NexusAddOn.addOnExistsInDomain(domain, addonId)) {
            AddOn ao = Factory.AddOn.fetchInstance((Domain)domain, (Id)addonId, null);
            if (ao.get_Id().equals((Object)addonId)) {
                Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, "Add on " + P8NexusAddOn.getAddonName(addonId) + " (" + addonId + ") Found.");
                ao.delete();
                ao.save(RefreshMode.REFRESH);
                Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, "Add on " + P8NexusAddOn.getAddonName(addonId) + " (" + addonId + ") Deleted.");
                domain.refresh();
            }
        } else {
            Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, "Add on " + P8NexusAddOn.getAddonName(addonId) + " (" + addonId + ") Does not exist.");
        }
    }

    private static String getAddonName(Id addonId) {
        if (addonId.equals((Object)NEXUS_STORED_SEARCH_ADDON_ID)) {
            return NEXUS_STORED_SEARCH_ADDON_NAME;
        }
        if (addonId.equals((Object)NEXUS_TEAMSPACE_ADDON_ID)) {
            return NEXUS_TEAMSPACE_ADDON_NAME;
        }
        return null;
    }

    private static IdList getPreRequisiteAddons(Id addonId) {
        IdList prerequisites = Factory.IdList.createList();
        if (addonId.equals((Object)NEXUS_STORED_SEARCH_ADDON_ID)) {
            prerequisites.add((Object)BASE_STORED_SEARCH_ADDON_ID);
            prerequisites.add((Object)BASE_APPLICATION_ADDON_ID);
        } else if (addonId.equals((Object)NEXUS_TEAMSPACE_ADDON_ID)) {
            prerequisites.add((Object)BASE_APPLICATION_ADDON_ID);
        }
        return prerequisites;
    }

    private static String getAddonImportFilePath(Id addonId) {
        if (addonId.equals((Object)NEXUS_STORED_SEARCH_ADDON_ID)) {
            return ADDON_IMPORT_BASE_PATH + ADDON_STORED_SEARCH_IMPORT_FILE;
        }
        if (addonId.equals((Object)NEXUS_TEAMSPACE_ADDON_ID)) {
            return ADDON_IMPORT_BASE_PATH + ADDON_TEAMSPACE_IMPORT_FILE;
        }
        return null;
    }

    public static boolean checkPreRequisiteAddons(Domain domain, ObjectStore os, Id addonId) throws Exception {
        String methodName = "checkPreRequisiteAddons";
        Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, "Checking Prerequisite addons for  " + addonId + " In domain=" + domain.get_Name() + " ObjectStore= " + os.get_SymbolicName());
        IdList prerequisites = P8NexusAddOn.getPreRequisiteAddons(addonId);
        boolean prereqExists = false;
        for (int i = 0; i < prerequisites.size(); ++i) {
            if (!P8NexusAddOn.addOnExistsInDomain(domain, (Id)prerequisites.get(i)) || !P8NexusAddOn.addOnExistsInObjectStore(os, (Id)prerequisites.get(i))) {
                Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, ">>>>>>Addon " + prerequisites.get(i) + "Exists in domain=" + domain.get_Name() + " ObjectStore= " + os.get_SymbolicName() + " ? FALSE");
                return false;
            }
            Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, ">>>>>>Addon " + prerequisites.get(i) + "Exists in domain=" + domain.get_Name() + " ObjectStore= " + os.get_SymbolicName() + " ? TRUE");
            prereqExists = true;
        }
        return prereqExists;
    }

    public static AddOn updateAddOn(Domain domain, Id addonId) throws Exception {
        String methodName = "updateAddOn";
        domain.refresh();
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(0, null, null, "RootClassDefinitions", null);
        pf.addIncludeProperty(0, null, null, "DisplayName", null);
        pf.addIncludeProperty(0, null, null, "Domain", null);
        AddOn nexusAddOn = null;
        try {
            if (P8NexusAddOn.addOnExistsInDomain(domain, addonId)) {
                Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, "Updating " + P8NexusAddOn.getAddonName(addonId) + " (" + addonId + ") to Domain '" + domain.get_Name() + "' ...");
                IdList prerequisites = P8NexusAddOn.getPreRequisiteAddons(addonId);
                nexusAddOn = Factory.AddOn.fetchInstance((Domain)domain, (Id)addonId, (PropertyFilter)pf);
                nexusAddOn.set_DisplayName(P8NexusAddOn.getAddonName(addonId));
                nexusAddOn.set_AddOnType(AddOnType.OPTIONAL);
                nexusAddOn.set_Prerequisites(prerequisites);
                nexusAddOn.setImportDataStream((InputStream)new ByteArrayInputStream(P8NexusAddOn.getNexusManifest(addonId).getBytes()));
                nexusAddOn.setPostImportScriptStream((InputStream)new ByteArrayInputStream(P8NexusAddOn.getPostImportScript(addonId).getBytes()));
                nexusAddOn.setPreImportScriptStream((InputStream)new ByteArrayInputStream(P8NexusAddOn.getPreImportScript().getBytes()));
                nexusAddOn.save(RefreshMode.REFRESH);
                Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, "Add on " + P8NexusAddOn.getAddonName(addonId) + " (" + addonId + ") updated");
            } else {
                Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, P8NexusAddOn.getAddonName(addonId) + " does not exists on Domain '" + domain.get_Name() + "'.");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return nexusAddOn;
    }

    public static AddOn createAddOn(Domain domain, Id addonId) throws Exception {
        String methodName = "createAddOn";
        domain.refresh();
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(0, null, null, "RootClassDefinitions", null);
        pf.addIncludeProperty(0, null, null, "DisplayName", null);
        pf.addIncludeProperty(0, null, null, "Domain", null);
        AddOn nexusAddOn = null;
        try {
            if (!P8NexusAddOn.addOnExistsInDomain(domain, addonId)) {
                Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, "Adding " + P8NexusAddOn.getAddonName(addonId) + " (" + addonId + ") to Domain '" + domain.get_Name() + "' ...");
                IdList prerequisites = P8NexusAddOn.getPreRequisiteAddons(addonId);
                nexusAddOn = Factory.AddOn.createInstance((Domain)domain, (Id)addonId);
                nexusAddOn.set_DisplayName(P8NexusAddOn.getAddonName(addonId));
                nexusAddOn.set_AddOnType(AddOnType.OPTIONAL);
                nexusAddOn.set_Prerequisites(prerequisites);
                nexusAddOn.setImportDataStream((InputStream)new ByteArrayInputStream(P8NexusAddOn.getNexusManifest(addonId).getBytes()));
                nexusAddOn.setPostImportScriptStream((InputStream)new ByteArrayInputStream(P8NexusAddOn.getPostImportScript(addonId).getBytes()));
                nexusAddOn.setPreImportScriptStream((InputStream)new ByteArrayInputStream(P8NexusAddOn.getPreImportScript().getBytes()));
                nexusAddOn.save(RefreshMode.REFRESH);
                Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, "Add on " + P8NexusAddOn.getAddonName(addonId) + " (" + addonId + ") Created");
            } else {
                Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, P8NexusAddOn.getAddonName(addonId) + " already added to Domain '" + domain.get_Name() + "'.");
                nexusAddOn = Factory.AddOn.fetchInstance((Domain)domain, (Id)addonId, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return nexusAddOn;
    }

    public static void installAddOn(Domain domain, String osName, Id addonId) throws Exception {
        String methodName = "installAddOn";
        ObjectStore os = Factory.ObjectStore.fetchInstance((Domain)domain, (String)osName, null);
        if (!P8NexusAddOn.addOnExistsInObjectStore(os, addonId)) {
            AddOn addOn = Factory.AddOn.fetchSupersedingInstance((Domain)domain, (Id)addonId, null);
            os.refresh();
            Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, " Installing " + P8NexusAddOn.getAddonName(addonId) + " (" + addonId + ") into ObjectStore '" + os.get_DisplayName() + "' ...");
            os.installAddOn(addOn);
            os.save(RefreshMode.REFRESH);
            os.refresh();
            Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, " Addon " + P8NexusAddOn.getAddonName(addonId) + " (" + addonId + ") installed into ObjectStore '" + os.get_DisplayName() + "'.");
        } else {
            Logger.logInfo(P8NexusAddOn.class, methodName, (HttpSession)null, P8NexusAddOn.getAddonName(addonId) + " (" + addonId + ") already installed in ObjectStore '" + os.get_DisplayName() + "'.");
        }
    }

    public static boolean addOnExistsInDomain(Domain domain, Id addOnId) {
        boolean addOnExists;
        block8: {
            addOnExists = false;
            if (domain != null) {
                PropertyFilter pf = new PropertyFilter();
                pf = P8NexusAddOn.addScalarsToFilter(pf, 1);
                try {
                    AddOn ao = Factory.AddOn.fetchInstance((Domain)domain, (Id)addOnId, (PropertyFilter)pf);
                    if (ao.get_Id().equals((Object)addOnId)) {
                        addOnExists = true;
                    }
                }
                catch (EngineRuntimeException ere) {
                    try {
                        AddOn ao = Factory.AddOn.fetchSupersedingInstance((Domain)domain, (Id)addOnId, (PropertyFilter)pf);
                        IdList supersededAddOns = ao.get_SupersededAddOnIds();
                        for (int i = 0; i < supersededAddOns.size(); ++i) {
                            if (!((Id)supersededAddOns.get(i)).equals((Object)addOnId)) continue;
                            return true;
                        }
                    }
                    catch (EngineRuntimeException eree) {
                        if (!eree.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                            throw eree;
                        }
                        return false;
                    }
                    if (ere.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) break block8;
                    throw ere;
                }
            }
        }
        return addOnExists;
    }

    public static boolean addOnExistsInObjectStore(ObjectStore os, Id addOnId) throws Exception {
        boolean addOnExists = false;
        if (os != null && !(addOnExists = os.isAddOnInstalled(addOnId))) {
            AddOn superCededAddon = Factory.AddOn.fetchSupersedingInstance((Domain)os.get_Domain(), (Id)addOnId, null);
            addOnExists = os.isAddOnInstalled(superCededAddon.get_Id());
        }
        return addOnExists;
    }

    public static PropertyFilter addScalarsToFilter(PropertyFilter filter, int scalarRecursionLevel) {
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.SINGLETON_BINARY, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.SINGLETON_BOOLEAN, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.SINGLETON_DATE, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.SINGLETON_DOUBLE, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.SINGLETON_GUID, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.SINGLETON_LONG, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.SINGLETON_STRING, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.LIST_OF_BINARY, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.LIST_OF_BOOLEAN, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.LIST_OF_DATE, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.LIST_OF_DOUBLE, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.LIST_OF_GUID, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.LIST_OF_LONG, null);
        filter.addIncludeType(scalarRecursionLevel, null, null, FilteredPropertyType.LIST_OF_STRING, null);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNexusManifest(Id addonId) throws IOException {
        StringBuilder fileContents = new StringBuilder();
        ClassLoader cl = P8NexusAddOn.class.getClassLoader();
        InputStream is = cl.getResourceAsStream(P8NexusAddOn.getAddonImportFilePath(addonId));
        Scanner scanner = new Scanner(is);
        String lineSeparator = System.getProperty("line.separator");
        try {
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine() + lineSeparator);
            }
            String string = fileContents.toString();
            Object var8_7 = null;
            scanner.close();
            return string;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            scanner.close();
            throw throwable;
        }
    }

    private static void printClassPath() {
        String methodName = "printClassPath";
        ClassLoader sysClassLoader = P8NexusAddOn.class.getClassLoader();
        URL[] urls = ((URLClassLoader)sysClassLoader).getURLs();
        for (int i = 0; i < urls.length; ++i) {
            Logger.logDebug(P8NexusAddOn.class, methodName, (HttpSession)null, urls[i].getFile());
        }
    }

    private static String getTeamSpacePostImportScript() {
        return "importPackage(Packages.java.lang);importPackage(Packages.java.util);importPackage(Packages.com.filenet.api.core);importPackage(Packages.com.filenet.api.constants);importPackage(Packages.com.filenet.api.admin);importPackage(Packages.com.filenet.api.collection);importPackage(Packages.com.filenet.api.security);function PostImportScriptMethod(objectStore) {System.out.println(\"Inside PostImportScriptMethod(ObjectStore=\" + objectStore.get_DisplayName() + \")\");changePermissions(objectStore, \"ClbRole\");changePermissions(objectStore, \"ClbSecurityAdapter\");changePermissions(objectStore, \"ClbTeamspace\");changePermissions(objectStore, \"ClbTeamspaceTemplate\");createFolders(objectStore);}function changePermissions(objectStore, classname) {objectStore.refresh();role = Factory.ClassDefinition.fetchInstance(objectStore, \"\"+classname, null);permissions = role.get_DefaultInstancePermissions();iter = permissions.iterator();authUsersFound=false;creatorFound=false;authUser=null;updated=false;while (iter.hasNext()){ap =  iter.next();if (ap.get_GranteeName().equals(\"#AUTHENTICATED-USERS\")){authUser=ap;authUsersFound=true;System.out.println(\"Found the AUTHENTICATED-USERS\");}if (ap.get_GranteeName().equals(\"#CREATOR-OWNER\")){creatorFound = true;System.out.println(\"Found the CREATOR-OWNER\");}}if(!creatorFound){ap = Factory.AccessPermission.createInstance();ap.set_AccessType(AccessType.ALLOW);ap.set_AccessMask(new Integer(AccessLevel.FULL_CONTROL_DOCUMENT_AS_INT - AccessRight.MAJOR_VERSION_AS_INT));ap.set_InheritableDepth(new Integer(0));ap.set_GranteeName(\"#CREATOR-OWNER\");System.out.println(\"Adding the CREATOR-OWNER\");permissions.add(ap);updated=true;}if(authUsersFound ||updated){if(authUsersFound){permissions.remove(authUser);System.out.println(\"Removing the AUTHENTICATED-USERS\");}role.set_DefaultInstancePermissions(permissions);role.save(RefreshMode.REFRESH);System.out.println(\"Updated the class definition \"+role.get_SymbolicName());}updated=false;creatorFound=false;}function createFolders(objectStore) {objectStore.refresh();rootFldr = objectStore.get_RootFolder();iter = rootFldr.get_Containees().iterator();teamSpacesFound=false;teamSpacesTemplateFound=false;rolesFound=false;while (iter.hasNext()){rcr =  iter.next();name = rcr.get_ContainmentName();if(name.equals(\"Teamspaces\")){teamSpacesFound =true;System.out.println(\"Found Teamspaces in ObjectStore '\" + objectStore.get_DisplayName() + \"'.\");}if(name.equals(\"Teamspace Templates\")){teamSpacesTemplateFound =true;System.out.println(\"Found Teamspace Templates in ObjectStore '\" + objectStore.get_DisplayName() + \"'.\");}if(name.equals(\"Roles\")){rolesFound =true;System.out.println(\"Found Roles in ObjectStore '\" + objectStore.get_DisplayName() + \"'.\");}}if(!teamSpacesFound){System.out.println(\"Creating Teamspaces into ObjectStore '\" + objectStore.get_DisplayName() + \"'.\");teamSpaceFolder = rootFldr.createSubFolder(\"ClbTeamspaces\");teamSpaceFolder.getProperties().putValue(\"IsHiddenContainer\", true);teamSpaceFolder.save(RefreshMode.REFRESH);rootFldr.save(RefreshMode.REFRESH);}if(!teamSpacesTemplateFound){System.out.println(\"Creating Teamspace Templates into ObjectStore '\" + objectStore.get_DisplayName() + \"'.\");teamSpacesTemplateFolder = rootFldr.createSubFolder(\"ClbTeamspace Templates\");teamSpacesTemplateFolder.getProperties().putValue(\"IsHiddenContainer\", true);teamSpacesTemplateFolder.save(RefreshMode.REFRESH);rootFldr.save(RefreshMode.REFRESH);}if(!rolesFound){System.out.println(\"Creating Roles into ObjectStore '\" + objectStore.get_DisplayName() + \"'.\");rolesFolder = rootFldr.createSubFolder(\"ClbRoles\");rolesFolder.getProperties().putValue(\"IsHiddenContainer\", true);rolesFolder.save(RefreshMode.REFRESH);rootFldr.save(RefreshMode.REFRESH);}}";
    }

    private static String getPostImportScript(Id addonId) {
        if (addonId.equals((Object)NEXUS_TEAMSPACE_ADDON_ID)) {
            return P8NexusAddOn.getTeamSpacePostImportScript();
        }
        return "importClass(java.lang.System);importPackage(Packages.com.filenet.api.core);function PostImportScriptMethod (objectStore) {System.out.println(\"Inside PostImportScriptMethod(ObjectStore=\" + objectStore.get_DisplayName() + \")\");}";
    }

    private static String getPreImportScript() {
        return "importClass(java.lang.System);importPackage(Packages.com.filenet.api.core);//System.out.println(\"@@@ Parsed script - prior to calling method @@@\");\nfunction PreImportScriptMethod (objectStore) {System.out.println(\"Inside PreImportScriptMethod(ObjectStore=\" + objectStore.get_DisplayName() + \")\");}";
    }
}

