/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.EngineSet;
import com.filenet.api.collection.PageIterator;
import com.filenet.api.collection.RepositoryRowSet;
import com.filenet.api.constants.MergeMode;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.p8.P8CeSearchUtilProxy;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Query;
import com.ibm.ecm.util.p8.P8QueryContinuationData;
import com.ibm.ecm.util.p8.P8Util;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.ServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8Iterator
implements Iterator<Object> {
    private ServletRequest request;
    private P8Connection connection;
    private P8QueryContinuationData continuationData;
    private int pageSize;
    private int fetchedItemsCount;
    private PageIterator pageIterator;
    private Iterator<Object> iterator;

    public P8Iterator(ServletRequest request, P8Connection connection, P8QueryContinuationData continuationData, int pageSize) {
        this.request = request;
        this.connection = connection;
        this.continuationData = continuationData;
        this.pageSize = pageSize;
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.retrieveNextPage();
        }
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iterator.next();
    }

    private void retrieveNextPage() {
        if (this.pageIterator == null) {
            this.pageIterator = this.startPageIterator();
        }
        if (this.pageIterator != null && this.pageIterator.nextPage()) {
            this.iterator = this.getCurrentPage();
        } else {
            this.reset();
            int remaining = this.pageSize - this.fetchedItemsCount;
            if (!this.continuationData.returnOnlyFolders && !this.continuationData.queriedAll && remaining > 0) {
                this.pageIterator = this.search(true, remaining);
                if (this.pageIterator != null && this.pageIterator.nextPage()) {
                    this.iterator = this.getCurrentPage();
                }
                this.continuationData.queriedAll = true;
            }
        }
    }

    public void reset() {
        this.iterator = null;
        if (this.pageIterator != null) {
            this.pageIterator.reset();
        }
        this.pageIterator = null;
    }

    private Iterator<Object> getCurrentPage() {
        if (this.pageIterator == null) {
            return null;
        }
        Object[] objects = this.pageIterator.getCurrentPage();
        this.fetchedItemsCount += objects.length;
        return Arrays.asList(objects).iterator();
    }

    private PageIterator startPageIterator() {
        if (this.continuationData.checkpoint == null) {
            return this.search(false);
        }
        return this.resume();
    }

    PageIterator resume() {
        Logger.logEntry((Object)this, "resume", this.request);
        if (this.continuationData.checkpoint == null) {
            return null;
        }
        PageIterator pi = P8CeSearchUtilProxy.resumePageIterator(this.connection, this.continuationData.checkpoint);
        pi.setPageSize(this.pageSize);
        Logger.logExit((Object)this, "resume", this.request);
        return pi;
    }

    private PageIterator search(boolean secondQuery) {
        return this.search(secondQuery, this.pageSize);
    }

    private PageIterator search(boolean secondQuery, int currentPageSize) {
        if (currentPageSize < 1) {
            return null;
        }
        PageIterator pi = this.isStoredSearchSet() ? this.executeStoredSearch(secondQuery, currentPageSize) : this.runSql(secondQuery, currentPageSize);
        return pi;
    }

    private boolean isStoredSearchSet() {
        return (this.continuationData.ceDocumentSearchParams != null || this.continuationData.ceFolderSearchParams != null) && this.continuationData.ceStoredSearch != null;
    }

    private PageIterator runSql(boolean secondQuery, int currentPageSize) {
        String sql;
        String string = sql = this.isSearchingForFolders(secondQuery) ? this.continuationData.folderSQL : this.continuationData.documentSQL;
        if (sql == null || sql.length() < 1) {
            return null;
        }
        return this.invokeSql(sql, secondQuery, currentPageSize);
    }

    PageIterator invokeSql(String sql, boolean secondQuery, int currentPageSize) {
        Logger.logEntry((Object)this, "invokeSql", this.request);
        if (sql == null || sql.length() < 1) {
            return null;
        }
        Logger.logDebug((Object)this, "invokeSql", this.request, "sql: " + sql);
        SearchSQL search = new SearchSQL(sql);
        PropertyFilter pf = this.isSearchingForFolders(secondQuery) ? P8Query.getFolderPropertyFilter() : P8Query.getDocumentPropertyFilter();
        SearchScope searchScope = this.getSearchScope();
        RepositoryRowSet resultSet = this.continuationData.orderByRank ? searchScope.fetchRows(search, Integer.valueOf(currentPageSize), pf, Boolean.TRUE) : searchScope.fetchObjects(search, Integer.valueOf(currentPageSize), pf, Boolean.TRUE);
        Logger.logExit((Object)this, "invokeSql", this.request);
        return resultSet.pageIterator();
    }

    private PageIterator executeStoredSearch(boolean secondQuery, int currentPageSize) {
        Object searchParams;
        Object object = searchParams = this.isSearchingForFolders(secondQuery) ? this.continuationData.ceFolderSearchParams : this.continuationData.ceDocumentSearchParams;
        if (searchParams == null) {
            return null;
        }
        return this.invokeStoredSearch(searchParams, secondQuery, currentPageSize);
    }

    PageIterator invokeStoredSearch(Object searchParams, boolean secondQuery, int currentPageSize) {
        PropertyFilter pf;
        boolean searchFolders;
        String fromClass;
        Logger.logEntry((Object)this, "invokeStoredSearch", this.request);
        if (searchParams == null) {
            return null;
        }
        SearchScope searchScope = this.getSearchScope();
        EngineSet resultsRowtSet = P8CeSearchUtilProxy.executeStoredSearch(searchScope, this.continuationData.ceStoredSearch, fromClass = (searchFolders = this.isSearchingForFolders(secondQuery)) ? "Folder" : "Document", searchParams, currentPageSize, pf = searchFolders ? P8Query.getFolderPropertyFilter() : P8Query.getDocumentPropertyFilter(), this.continuationData.orderByRank);
        if (resultsRowtSet == null) {
            return this.runSql(secondQuery, currentPageSize);
        }
        Logger.logExit((Object)this, "invokeStoredSearch", this.request);
        return resultsRowtSet.pageIterator();
    }

    private boolean isSearchingForFolders(boolean secondQuery) {
        return this.continuationData.returnOnlyFolders || !this.continuationData.descending && !secondQuery || this.continuationData.descending && secondQuery;
    }

    private SearchScope getSearchScope() {
        SearchScope searchScope;
        String[] osIds = this.continuationData.getObjectStoreIds();
        if (osIds.length > 1) {
            ObjectStore[] ceStores = new ObjectStore[osIds.length];
            for (int i = 0; i < osIds.length; ++i) {
                ObjectStore ceStore;
                ceStores[i] = ceStore = P8Util.getObjectStore(this.connection, osIds[i]);
            }
            searchScope = new SearchScope(ceStores, this.continuationData.mergeUnion ? MergeMode.UNION : MergeMode.INTERSECTION);
        } else {
            searchScope = new SearchScope(P8Util.getObjectStore(this.connection, osIds[0]));
        }
        return searchScope;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public byte[] getNextPageCheckpoint() {
        return P8CeSearchUtilProxy.getNextPageCheckpoint(this.pageIterator);
    }
}

